from spriter.sprite import Sprite
import unittest


HAPPY_BASE64 = "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"


class TestBase64Images(unittest.TestCase):

    def setUp(self):
        self.paths = ["tests/fixtures/happy.png"]
        self.sprite = Sprite(self.paths)

    def test_get_base_64_str(self):
        img = self.sprite.get_base64_str()
        self.assertEquals(img, HAPPY_BASE64)

    def test_get_css_str_with_base64_sprite(self):
        css_template = self.sprite.get_css_base64()
        self.assertIn("image/png", css_template)
        self.assertIn(HAPPY_BASE64, css_template)

    def test_gen_css_file_with_base64_sprite(self):
        css_path = self.sprite.do_write_css(is_base64=True)
        with open(css_path) as arq:
            css_str = arq.read()
        self.assertIn(HAPPY_BASE64, css_str)


    def test_gen_sprite_files_with_base64_sprite(self):
        css_path, image_path = self.sprite.gen_sprite(is_base64=True)
        with open(css_path) as arq:
            css_str = arq.read()
        self.assertIn(HAPPY_BASE64, css_str)
        self.assertIsNone(image_path)
