# Copyright 2014 Oliver Cope
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import sqlalchemy.orm
import sqlalchemy.orm.session

__version__ = '0.1'


class SessionWithFind(sqlalchemy.orm.session.Session):
    """
    Emulate storm style store.find, store.get to save keystrokes
    """

    def find(self, what, *args, **kwargs):
        return self.query(what).find(*args, **kwargs)

    def get(self, what, *args, **kwargs):
        return self.query(what).get(*args, **kwargs)


class QueryWithFind(sqlalchemy.orm.Query):

    def find(self, *args, **kwargs):
        q = self
        if args:
            q = q.filter(*args)
        if kwargs:
            q = q.filter_by(**kwargs)
        return q
