# Nice print stuff
TAB = 12*' '

NLTAB = ',\n'+TAB

USAGE = """usage: autoload.py [options]

Generates python code for a given database schema.

options:
    -h, --help                      Show this help
    -u URL,         --url URL       Database url (e.g.: postgres://postgres:user@password/Database)
    -o FILE,        --output FILE   Where to put the output (default is stdout)
    -s NAME,        --schema NAME   Name of the schema to output (default is 'default')
    -t T1,T2,.. ,   --tables T1,T2  Name of tables to inspect (default is 'all').
                                    Support globbing character to select more tables.
                                    ex.: -t Download* will generate a model for all tables starting with Download

    -i              --noindex       Do not generate index information
    -g              --generic-types Generate generic column types rather than database-specific type
    -e              --example       Generate code with examples how to access data
    -3              --z3c           Generate code for use with z3c.sqlalchemy
"""

HEADER = """\
# -*- coding: %(encoding)s -*-
## File autogenerated by SQLAutoCode
## see http://code.google.com/p/sqlautocode/

from sqlalchemy import *
%(dialect)s
metadata = MetaData()
"""

HEADER_Z3C = """\
# -*- coding: %(encoding)s -*-
## File autogenerated by SQLAutoCode
## see http://code.google.com/p/sqlautocode/
## Export type: z3c.sqlalchemy

from sqlalchemy import *
%(dialect)s
from z3c.sqlalchemy import Model
from z3c.sqlalchemy.mapper import MappedClassBase

def getModel(metadata):
    model = Model()
"""

FOOTER_Z3C = """
    return model
"""

FOOTER_EXAMPLE = """
# some example usage
if __name__ == '__main__':
    db = create_engine(%(url)r)
    metadata.bind = db

    # fetch first 10 items from %(tablename)s
    s = %(tablename)s.select().limit(10)
    rs = s.execute()
    for row in rs:
        print row
"""

TABLE = """ Table('%(name)s', metadata,
    %(columns)s,
    %(constraints)s
    %(schema)s
    )
"""

COLUMN = """Column(%(name)r, %(type)s%(constraints)s%(args)s)"""

FOREIGN_KEY = """ForeignKeyConstraint(%(names)s, %(specs)s, name=%(name)s)"""

INDEX = """Index(%(name)s, %(columns)s, unique=%(unique)s)"""
