/*
 * Decompiled with CFR 0.152.
 */
package net.nczonline.web.cssembed;

import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import net.nczonline.web.cssembed.CSSURLEmbedder;

public class CSSEmbed {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean verbose = false;
        String charset = null;
        String outputFilename = null;
        Writer out = null;
        InputStreamReader in = null;
        int options = 1;
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option verboseOpt = parser.addBooleanOption('v', "verbose");
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option charsetOpt = parser.addStringOption("charset");
        CmdLineParser.Option rootOpt = parser.addStringOption("root");
        CmdLineParser.Option outputFilenameOpt = parser.addStringOption('o', "output");
        CmdLineParser.Option mhtmlOpt = parser.addBooleanOption("mhtml");
        CmdLineParser.Option mhtmlRootOpt = parser.addStringOption("mhtmlroot");
        try {
            boolean mhtml;
            String[] fileArgs;
            parser.parse(args);
            Boolean help = (Boolean)parser.getOptionValue(helpOpt);
            if (help != null && help.booleanValue()) {
                CSSEmbed.usage();
                System.exit(0);
            }
            verbose = parser.getOptionValue(verboseOpt) != null;
            charset = (String)parser.getOptionValue(charsetOpt);
            if (charset == null || !Charset.isSupported(charset)) {
                charset = System.getProperty("file.encoding");
                if (charset == null) {
                    charset = "UTF-8";
                }
                if (verbose) {
                    System.err.println("\n[INFO] Using charset " + charset);
                }
            }
            if ((fileArgs = parser.getRemainingArgs()).length == 0) {
                System.err.println("[ERROR] No files specified.");
                System.exit(1);
            }
            boolean bl = mhtml = parser.getOptionValue(mhtmlOpt) != null;
            if (mhtml) {
                options = 2;
            }
            String mhtmlRoot = (String)parser.getOptionValue(mhtmlRootOpt);
            if (mhtml && mhtmlRoot == null) {
                throw new Exception("Must use --mhtmlroot when using --mhtml.");
            }
            String inputFilename = fileArgs[0];
            in = new InputStreamReader((InputStream)new FileInputStream(inputFilename), charset);
            CSSURLEmbedder embedder = new CSSURLEmbedder(in, options, verbose);
            embedder.setMHTMLRoot(mhtmlRoot);
            ((Reader)in).close();
            in = null;
            String root = (String)parser.getOptionValue(rootOpt);
            if (root == null) {
                root = new File(inputFilename).getCanonicalPath();
                root = root.substring(0, root.lastIndexOf(File.separator));
            }
            if (!root.endsWith(File.separator)) {
                root = root + File.separator;
            }
            if (verbose) {
                System.err.println("[INFO] Using '" + root + "' as root for relative file paths.");
            }
            if ((outputFilename = (String)parser.getOptionValue(outputFilenameOpt)) == null) {
                if (verbose) {
                    System.err.println("[INFO] No output file specified, defaulting to stdout.");
                }
                out = new OutputStreamWriter(System.out);
            } else {
                File outputFile = new File(outputFilename);
                if (verbose) {
                    System.err.println("[INFO] Output file is '" + outputFile.getAbsolutePath() + "'");
                }
                embedder.setFilename(outputFile.getName());
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilename), charset);
            }
            embedder.embedImages(out, root);
        }
        catch (CmdLineParser.OptionException e) {
            CSSEmbed.usage();
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("[ERROR] " + e.getMessage());
            if (verbose) {
                e.printStackTrace();
            }
            System.exit(1);
        }
        finally {
            block32: {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        System.err.println("[ERROR] " + e.getMessage());
                        if (!verbose) break block32;
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static void usage() {
        System.out.println("\nUsage: java -jar cssembed-x.y.z.jar [options] [input file]\n\nGlobal Options\n  -h, --help            Displays this information.\n  --charset <charset>   Character set of the input file.\n  --mhtml               Enable MHTML mode.\n  --mhtmlroot <root>    Use <root> as the MHTML root for the file.\n  -v, --verbose         Display informational messages and warnings.\n  --root <root>         Prepends <root> to all relative URLs.\n  -o <file>             Place the output into <file>. Defaults to stdout.");
    }
}

