/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor;

import com.googlecode.htmlcompressor.compressor.Compressor;
import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import com.googlecode.htmlcompressor.compressor.XmlCompressor;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CmdLineCompressor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option charsetOpt = parser.addStringOption("charset");
        CmdLineParser.Option outputFilenameOpt = parser.addStringOption('o', "output");
        CmdLineParser.Option patternsFilenameOpt = parser.addStringOption('p', "preserve-patterns");
        CmdLineParser.Option typeOpt = parser.addStringOption("type");
        CmdLineParser.Option preserveCommentsOpt = parser.addBooleanOption("preserve-comments");
        CmdLineParser.Option preserveIntertagSpacesOpt = parser.addBooleanOption("preserve-intertag-spaces");
        CmdLineParser.Option preserveMultiSpacesOpt = parser.addBooleanOption("preserve-multi-spaces");
        CmdLineParser.Option removeIntertagSpacesOpt = parser.addBooleanOption("remove-intertag-spaces");
        CmdLineParser.Option removeQuotesOpt = parser.addBooleanOption("remove-quotes");
        CmdLineParser.Option preservePhpTagsOpt = parser.addBooleanOption("preserve-php");
        CmdLineParser.Option preserveServerScriptTagsOpt = parser.addBooleanOption("preserve-server-script");
        CmdLineParser.Option compressJsOpt = parser.addBooleanOption("compress-js");
        CmdLineParser.Option compressCssOpt = parser.addBooleanOption("compress-css");
        CmdLineParser.Option nomungeOpt = parser.addBooleanOption("nomunge");
        CmdLineParser.Option linebreakOpt = parser.addStringOption("line-break");
        CmdLineParser.Option preserveSemiOpt = parser.addBooleanOption("preserve-semi");
        CmdLineParser.Option disableOptimizationsOpt = parser.addBooleanOption("disable-optimizations");
        Reader in = null;
        BufferedReader patternsIn = null;
        Writer out = null;
        try {
            String patternsFilename;
            String charset;
            parser.parse(args);
            Boolean help = (Boolean)parser.getOptionValue(helpOpt);
            if (help != null && help.booleanValue()) {
                CmdLineCompressor.printUsage();
                System.exit(0);
            }
            if (!((charset = (String)parser.getOptionValue(charsetOpt)) != null && Charset.isSupported(charset) || (charset = System.getProperty("file.encoding")) != null)) {
                charset = "UTF-8";
            }
            String[] fileArgs = parser.getRemainingArgs();
            String type = (String)parser.getOptionValue(typeOpt);
            if (type != null && !type.equalsIgnoreCase("html") && !type.equalsIgnoreCase("xml")) {
                CmdLineCompressor.printUsage();
                System.exit(1);
            }
            if (fileArgs.length == 0) {
                if (type == null) {
                    type = "html";
                }
                in = new InputStreamReader(System.in, charset);
            } else {
                int idx;
                String inputFilename = fileArgs[0];
                if (type == null && (idx = inputFilename.lastIndexOf(46)) >= 0 && idx < inputFilename.length() - 1) {
                    type = inputFilename.substring(idx + 1);
                }
                if (type == null || !type.equalsIgnoreCase("xml")) {
                    type = "html";
                }
                in = new InputStreamReader((InputStream)new FileInputStream(inputFilename), charset);
            }
            int linebreakpos = -1;
            String linebreakstr = (String)parser.getOptionValue(linebreakOpt);
            if (linebreakstr != null) {
                try {
                    linebreakpos = Integer.parseInt(linebreakstr, 10);
                }
                catch (NumberFormatException e) {
                    CmdLineCompressor.printUsage();
                    System.exit(1);
                }
            }
            String outputFilename = (String)parser.getOptionValue(outputFilenameOpt);
            boolean compressJavaScript = parser.getOptionValue(compressJsOpt) != null;
            boolean compressCss = parser.getOptionValue(compressCssOpt) != null;
            ArrayList<Pattern> preservePatterns = new ArrayList<Pattern>();
            if (parser.getOptionValue(preservePhpTagsOpt) != null) {
                preservePatterns.add(HtmlCompressor.PHP_TAG_PATTERN);
            }
            if (parser.getOptionValue(preserveServerScriptTagsOpt) != null) {
                preservePatterns.add(HtmlCompressor.SERVER_SCRIPT_TAG_PATTERN);
            }
            if ((patternsFilename = (String)parser.getOptionValue(patternsFilenameOpt)) != null) {
                patternsIn = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(patternsFilename), charset));
                String line = null;
                while ((line = patternsIn.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    try {
                        preservePatterns.add(Pattern.compile(line));
                    }
                    catch (PatternSyntaxException e) {
                        System.err.println("ERROR: Regular expression compilation error: " + e.getMessage());
                    }
                }
            }
            Compressor compressor = null;
            if (type.equalsIgnoreCase("html")) {
                HtmlCompressor htmlCompressor = new HtmlCompressor();
                htmlCompressor.setRemoveComments(parser.getOptionValue(preserveCommentsOpt) == null);
                htmlCompressor.setRemoveMultiSpaces(parser.getOptionValue(preserveMultiSpacesOpt) == null);
                htmlCompressor.setRemoveIntertagSpaces(parser.getOptionValue(removeIntertagSpacesOpt) != null);
                htmlCompressor.setRemoveQuotes(parser.getOptionValue(removeQuotesOpt) != null);
                htmlCompressor.setCompressJavaScript(compressJavaScript);
                htmlCompressor.setCompressCss(compressCss);
                htmlCompressor.setPreservePatterns(preservePatterns);
                htmlCompressor.setYuiJsNoMunge(parser.getOptionValue(nomungeOpt) != null);
                htmlCompressor.setYuiJsPreserveAllSemiColons(parser.getOptionValue(preserveSemiOpt) != null);
                htmlCompressor.setYuiJsDisableOptimizations(parser.getOptionValue(disableOptimizationsOpt) != null);
                htmlCompressor.setYuiJsLineBreak(linebreakpos);
                htmlCompressor.setYuiCssLineBreak(linebreakpos);
                compressor = htmlCompressor;
            } else {
                XmlCompressor xmlCompressor = new XmlCompressor();
                xmlCompressor.setRemoveComments(parser.getOptionValue(preserveCommentsOpt) == null);
                xmlCompressor.setRemoveIntertagSpaces(parser.getOptionValue(preserveIntertagSpacesOpt) == null);
                compressor = xmlCompressor;
            }
            BufferedReader input = new BufferedReader(in);
            try {
                StringBuilder source = new StringBuilder();
                String line = null;
                while ((line = input.readLine()) != null) {
                    source.append(line);
                    source.append(System.getProperty("line.separator"));
                }
                input.close();
                input = null;
                in.close();
                in = null;
                out = outputFilename == null ? new OutputStreamWriter((OutputStream)System.out, charset) : new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilename), charset);
                try {
                    String result = compressor.compress(source.toString());
                    out.write(result);
                }
                catch (NoClassDefFoundError e) {
                    System.err.println("ERROR: For JavaScript or CSS compression YUI compressor jar file \nmust be present in the same directory as HtmlCompressor jar");
                    System.exit(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (CmdLineParser.OptionException e) {
            CmdLineCompressor.printUsage();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (patternsIn != null) {
                try {
                    patternsIn.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        System.exit(0);
    }

    private static void printUsage() {
        System.err.println("Usage: java -jar htmlcompressor.jar [options] [input file]\n\n<input file>                  If not provided reads from stdin\n\nGlobal Options:\n  -o <output file>            If not provided outputs result to stdout\n  --type <html|xml>           If not provided autodetects from file extension\n  --charset <charset>         Read the input file using <charset>\n  -h, --help                  Display this screen\n\nXML Options:\n  --preserve-comments         Preserve comments\n  --preserve-intertag-spaces  Preserve intertag spaces\n\nHTML Options:\n  --preserve-comments         Preserve comments\n  --preserve-multi-spaces     Preserve multiple spaces\n  --remove-intertag-spaces    Remove intertag spaces\n  --remove-quotes             Remove unneeded quotes\n  --compress-js               Enable JavaScript compression using YUICompressor\n  --compress-css              Enable CSS compression using YUICompressor\n\nJavaScript Options (for YUI Compressor):\n  --nomunge                   Minify only, do not obfuscate\n  --preserve-semi             Preserve all semicolons\n  --disable-optimizations     Disable all micro optimizations\n  --line-break <column num>   Insert a line break after the specified column\n\nCSS Options (for YUI Compressor):\n  --line-break <column num>   Insert a line break after the specified column\n\nCustom Block Preservation Options:\n  --preserve-php              Preserve <?php ... ?> tags\n  --preserve-server-script    Preserve <% ... %> tags\n  -p <regexp patterns file>   Read regular expressions that define\n                              custom preservation rules from a file\n\nPlease note that if you enable JavaScript or Css compression parameters,\nYUI Compressor jar file must be present at the same directory as this jar.");
    }
}

