/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.taglib;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class JavaScriptCompressorTag
extends BodyTagSupport {
    private boolean enabled = true;
    private boolean yuiJsNoMunge = false;
    private boolean yuiJsPreserveAllSemiColons = false;
    private boolean yuiJsDisableOptimizations = false;
    private int yuiJsLineBreak = -1;

    public int doEndTag() throws JspException {
        BodyContent bodyContent = this.getBodyContent();
        String content = bodyContent.getString();
        try {
            if (this.enabled) {
                StringWriter result = new StringWriter();
                JavaScriptCompressor compressor = new JavaScriptCompressor(new StringReader(content), null);
                compressor.compress(result, this.yuiJsLineBreak, !this.yuiJsNoMunge, false, this.yuiJsPreserveAllSemiColons, this.yuiJsDisableOptimizations);
                bodyContent.clear();
                bodyContent.append((CharSequence)result.toString());
                bodyContent.writeOut((Writer)this.pageContext.getOut());
            } else {
                bodyContent.clear();
                bodyContent.append((CharSequence)content);
                bodyContent.writeOut((Writer)this.pageContext.getOut());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.doEndTag();
    }

    public void setYuiJsNoMunge(boolean yuiJsNoMunge) {
        this.yuiJsNoMunge = yuiJsNoMunge;
    }

    public void setYuiJsPreserveAllSemiColons(boolean yuiJsPreserveAllSemiColons) {
        this.yuiJsPreserveAllSemiColons = yuiJsPreserveAllSemiColons;
    }

    public void setYuiJsDisableOptimizations(boolean yuiJsDisableOptimizations) {
        this.yuiJsDisableOptimizations = yuiJsDisableOptimizations;
    }

    public void setYuiJsLineBreak(int yuiJsLineBreak) {
        this.yuiJsLineBreak = yuiJsLineBreak;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

