/*
 * Decompiled with CFR 0.152.
 */
package net.nczonline.web.datauri;

import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import net.nczonline.web.datauri.DataURIGenerator;

public class DataURI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean verbose = false;
        String charset = null;
        String outputFilename = null;
        Writer out = null;
        String mimeType = null;
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option verboseOpt = parser.addBooleanOption('v', "verbose");
        CmdLineParser.Option mimeTypeOpt = parser.addStringOption('m', "mime");
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option charsetOpt = parser.addStringOption("charset");
        CmdLineParser.Option outputFilenameOpt = parser.addStringOption('o', "output");
        try {
            parser.parse(args);
            Boolean help = (Boolean)parser.getOptionValue(helpOpt);
            if (help != null && help.booleanValue()) {
                DataURI.usage();
                System.exit(0);
            }
            verbose = parser.getOptionValue(verboseOpt) != null;
            charset = (String)parser.getOptionValue(charsetOpt);
            mimeType = (String)parser.getOptionValue(mimeTypeOpt);
            String[] fileArgs = parser.getRemainingArgs();
            if (fileArgs.length == 0) {
                System.err.println("[ERROR] No files specified.");
                System.exit(1);
            }
            String inputFilename = fileArgs[0];
            outputFilename = (String)parser.getOptionValue(outputFilenameOpt);
            if (outputFilename == null) {
                if (verbose) {
                    System.err.println("[INFO] No output file specified, defaulting to stdout.");
                }
                out = new OutputStreamWriter(System.out);
            } else {
                if (verbose) {
                    System.err.println("[INFO] Output file is '" + new File(outputFilename).getAbsolutePath() + "'");
                }
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilename), "UTF-8");
            }
            DataURIGenerator.setVerbose(verbose);
            if (inputFilename.startsWith("http://")) {
                DataURIGenerator.generate(new URL(inputFilename), out, mimeType);
            } else {
                DataURIGenerator.generate(new File(inputFilename), out, mimeType);
            }
        }
        catch (CmdLineParser.OptionException e) {
            DataURI.usage();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void usage() {
        System.out.println("\nUsage: java -jar datauri-x.y.z.jar [options] [input file]\n\nGlobal Options\n  -h, --help            Displays this information.\n  --charset <charset>   Character set of the input file.\n  -v, --verbose         Display informational messages and warnings.\n  -m, --mime <type>     Mime type to encode into the data URI.\n  -o <file>             Place the output into <file>. Defaults to stdout.");
    }
}

