/*
 * Decompiled with CFR 0.152.
 */
package net.nczonline.web.cssembed;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import net.nczonline.web.datauri.DataURIGenerator;

public class CSSURLEmbedder {
    public static final int DATAURI_OPTION = 1;
    public static final int MHTML_OPTION = 2;
    protected static String MHTML_SEPARATOR = "CSSEmbed_Image";
    private static HashSet<String> imageTypes = new HashSet();
    private boolean verbose = false;
    private String code = null;
    private int options = 1;
    private String mhtmlRoot = "";
    private String outputFilename = "";

    public CSSURLEmbedder(Reader in) throws IOException {
        this(in, false);
    }

    public CSSURLEmbedder(Reader in, int options) throws IOException {
        this(in, false);
    }

    public CSSURLEmbedder(Reader in, boolean verbose) throws IOException {
        this(in, 1, verbose);
    }

    public CSSURLEmbedder(Reader in, int options, boolean verbose) throws IOException {
        this.code = this.readCode(in);
        this.verbose = verbose;
        this.options = options;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean newVerbose) {
        this.verbose = newVerbose;
    }

    private boolean hasOption(int option) {
        return (this.options & option) > 0;
    }

    public String getMHTMLRoot() {
        return this.mhtmlRoot;
    }

    public void setMHTMLRoot(String mhtmlRoot) {
        this.mhtmlRoot = mhtmlRoot;
    }

    public String getFilename() {
        return this.outputFilename;
    }

    public void setFilename(String filename) {
        this.outputFilename = filename;
    }

    public void embedImages(Writer out) throws IOException {
        this.embedImages(out, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void embedImages(Writer out, String root) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(this.code));
        StringBuilder builder = new StringBuilder();
        StringBuilder mhtmlHeader = new StringBuilder();
        HashMap<String, Integer> foundMedia = new HashMap<String, Integer>();
        int lineNum = 1;
        if (this.hasOption(2)) {
            mhtmlHeader.append("/*\n");
            mhtmlHeader.append("Content-Type: multipart/related; boundary=\"");
            mhtmlHeader.append(MHTML_SEPARATOR);
            mhtmlHeader.append("\"\n\n");
        }
        while ((line = reader.readLine()) != null) {
            int start = 0;
            int pos = line.indexOf("url(", start);
            if (lineNum > 1) {
                builder.append("\n");
            }
            if (pos > -1) {
                while (pos > -1) {
                    String uriString;
                    builder.append(line.substring(start, pos += 4));
                    int npos = line.indexOf(")", pos);
                    String url = line.substring(pos, npos).trim();
                    if (url.startsWith("\"")) {
                        if (!url.endsWith("\"")) throw new IOException("Invalid CSS URL format (" + url + ") at line " + lineNum + ", col " + pos + ".");
                        url = url.substring(1, url.length() - 1);
                    } else if (url.startsWith("'")) {
                        if (!url.endsWith("'")) throw new IOException("Invalid CSS URL format (" + url + ") at line " + lineNum + ", col " + pos + ".");
                        url = url.substring(1, url.length() - 1);
                    }
                    if (foundMedia.containsKey(url) && this.verbose) {
                        System.err.println("[WARNING] Duplicate URL '" + url + "' found at line " + lineNum + ", previously declared at line " + foundMedia.get(url) + ".");
                    }
                    foundMedia.put(url, lineNum);
                    String newUrl = url;
                    if (this.verbose) {
                        System.err.println("[INFO] Found URL '" + url + "' at line " + lineNum + ", col " + pos + ".");
                    }
                    if (url.indexOf("http:") != 0 && root != null) {
                        newUrl = root + url;
                        if (this.verbose) {
                            System.err.println("[INFO] Applying root to URL, URL is now '" + newUrl + "'.");
                        }
                    }
                    if ((uriString = this.getImageURIString(newUrl, url)).startsWith("data:")) {
                        if (this.verbose && uriString.length() > 32768) {
                            System.err.println("[WARNING] File " + newUrl + " creates a data URI larger than 32KB. IE8 can't display data URI images this large.");
                        }
                        if (this.hasOption(2)) {
                            String entryName = this.getFilename(url);
                            mhtmlHeader.append("--");
                            mhtmlHeader.append(MHTML_SEPARATOR);
                            mhtmlHeader.append("\nContent-Location:");
                            mhtmlHeader.append(entryName);
                            mhtmlHeader.append("\nContent-Transfer-Encoding:base64\n\n");
                            mhtmlHeader.append(uriString.substring(uriString.indexOf(",") + 1));
                            mhtmlHeader.append("\n");
                            builder.append("mhtml:");
                            builder.append(this.getMHTMLPath());
                            builder.append("!");
                            builder.append(entryName);
                        } else if (this.hasOption(1)) {
                            builder.append(uriString);
                        }
                    } else {
                        builder.append(uriString);
                    }
                    start = npos;
                    pos = line.indexOf("url(", start);
                }
                if (start < line.length()) {
                    builder.append(line.substring(start));
                }
            } else {
                builder.append(line);
            }
            ++lineNum;
        }
        reader.close();
        if (this.hasOption(2)) {
            mhtmlHeader.append("\n--");
            mhtmlHeader.append(MHTML_SEPARATOR);
            mhtmlHeader.append("--\n");
            mhtmlHeader.append("*/\n");
            out.write(mhtmlHeader.toString());
        }
        out.write(builder.toString());
    }

    private String getImageURIString(String url, String originalUrl) throws IOException {
        String fileType = url.substring(url.lastIndexOf(".") + 1);
        if (imageTypes.contains(fileType)) {
            DataURIGenerator.setVerbose(this.verbose);
            StringWriter writer = new StringWriter();
            if (url.startsWith("http://")) {
                if (this.verbose) {
                    System.err.println("[INFO] Downloading '" + url + "' to generate data URI.");
                }
                DataURIGenerator.generate(new URL(url), (Writer)writer);
            } else {
                if (this.verbose) {
                    System.err.println("[INFO] Opening file '" + url + "' to generate data URI.");
                }
                File file = new File(url);
                if (this.verbose && !file.isFile()) {
                    System.err.println("[INFO] Could not find file '" + file.getCanonicalPath() + "'.");
                }
                DataURIGenerator.generate(new File(url), (Writer)writer);
            }
            if (this.verbose) {
                System.err.println("[INFO] Generated data URI for '" + url + "'.");
            }
            return writer.toString();
        }
        if (this.verbose) {
            System.err.println("[INFO] URL '" + originalUrl + "' is not an image, skipping.");
        }
        return originalUrl;
    }

    private String getFilename(String path) {
        if (path.indexOf("/") > -1) {
            return path.substring(path.lastIndexOf("/") + 1);
        }
        if (path.indexOf("\\") > -1) {
            return path.substring(path.lastIndexOf("\\") + 1);
        }
        return path;
    }

    private String getMHTMLPath() {
        String result = this.mhtmlRoot;
        if (!result.endsWith("/")) {
            result = result + "/";
        }
        result = result + this.outputFilename;
        return result;
    }

    private String readCode(Reader in) throws IOException {
        int c;
        StringBuilder builder = new StringBuilder();
        while ((c = in.read()) != -1) {
            builder.append((char)c);
        }
        in.close();
        return builder.toString();
    }

    static {
        imageTypes.add("jpg");
        imageTypes.add("jpeg");
        imageTypes.add("gif");
        imageTypes.add("png");
    }
}

