/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.velocity;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.runtime.parser.node.Node;

public class JavaScriptCompressorDirective
extends Directive {
    private Log log;
    private boolean enabled = true;
    private boolean yuiJsNoMunge = false;
    private boolean yuiJsPreserveAllSemiColons = false;
    private boolean yuiJsDisableOptimizations = false;
    private int yuiJsLineBreak = -1;

    public String getName() {
        return "compressJs";
    }

    public int getType() {
        return 1;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
        super.init(rs, context, node);
        this.log = rs.getLog();
        this.enabled = rs.getBoolean("userdirective.compressJs.enabled", true);
        this.yuiJsNoMunge = rs.getBoolean("userdirective.compressJs.yuiJsNoMunge", false);
        this.yuiJsPreserveAllSemiColons = rs.getBoolean("userdirective.compressJs.yuiJsPreserveAllSemiColons", false);
        this.yuiJsLineBreak = rs.getInt("userdirective.compressJs.yuiJsLineBreak", -1);
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        StringWriter content = new StringWriter();
        node.jjtGetChild(0).render(context, (Writer)content);
        if (this.enabled) {
            try {
                StringWriter result = new StringWriter();
                JavaScriptCompressor compressor = new JavaScriptCompressor(new StringReader(content.toString()), null);
                compressor.compress(result, this.yuiJsLineBreak, !this.yuiJsNoMunge, false, this.yuiJsPreserveAllSemiColons, this.yuiJsDisableOptimizations);
                writer.write(result.toString());
            }
            catch (Exception e) {
                writer.write(content.toString());
                String msg = "Failed to compress content: " + content.toString();
                this.log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        } else {
            writer.write(content.toString());
        }
        return true;
    }
}

