/*
 * Decompiled with CFR 0.152.
 */
package net.nczonline.web.cssembed;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import net.nczonline.web.cssembed.CSSURLEmbedder;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;

public class CSSEmbedTask
extends Task {
    private String charset = "UTF-8";
    private String root;
    private boolean mhtml;
    private String mhtmlRoot;
    private boolean skipMissing;
    private boolean verbose = false;
    private int maxUriLength = 0;
    private int maxImageSize = 0;
    private File srcFile;
    private File destFile;
    private Mapper mapperElement = null;
    private Vector rcs = new Vector();

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setMhtml(boolean mhtml) {
        this.mhtml = mhtml;
    }

    public void setMhtmlRoot(String mhtmlRoot) {
        this.mhtmlRoot = mhtmlRoot;
    }

    public void setSkipMissing(boolean skipMissing) {
        this.skipMissing = skipMissing;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setMaxUriLength(int maxUriLength) {
        this.maxUriLength = maxUriLength;
    }

    public void setMaxImageSize(int maxImageSize) {
        this.maxImageSize = maxImageSize;
    }

    public void setSrcFile(File srcFile) {
        this.srcFile = srcFile;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void add(ResourceCollection res) {
        this.rcs.add(res);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    private FileNameMapper getMapper() {
        Object mapper = null;
        mapper = this.mapperElement != null ? this.mapperElement.getImplementation() : new IdentityMapper();
        return mapper;
    }

    protected void validateAttributes() throws BuildException {
        if (this.rcs == null || this.rcs.size() == 0) {
            if (this.srcFile == null || !this.srcFile.exists()) {
                throw new BuildException("Must specify an input file or at least one nested resource", this.getLocation());
            }
            if (this.destFile == null) {
                throw new BuildException("Must specify an output file or at least one nested resource", this.getLocation());
            }
        }
        if (this.mhtml && this.mhtmlRoot == null) {
            throw new BuildException("Must specify mhtmlRoot in mhtml mode", this.getLocation());
        }
        if (this.mhtmlRoot != null && !this.mhtml) {
            this.log("mhtmlRoot has no effect if mhtml mode is not activated", 1);
        }
    }

    public void execute() throws BuildException {
        int options;
        this.validateAttributes();
        int n = options = this.mhtml ? 2 : 1;
        if (this.skipMissing) {
            options |= 4;
        }
        if (this.srcFile != null && this.srcFile.exists()) {
            try {
                this.embed(this.srcFile, this.destFile, options);
            }
            catch (IOException ex) {
                throw new BuildException(ex.getMessage(), (Throwable)ex);
            }
        }
        FileNameMapper mapper = this.getMapper();
        for (ResourceCollection rc : this.rcs) {
            for (FileResource fr : rc) {
                File in = fr.getFile();
                String[] mapped = mapper.mapFileName(in.getName());
                if (mapped == null || mapped.length <= 0) continue;
                for (int k = 0; k < mapped.length; ++k) {
                    File out = this.getProject().resolveFile(in.getParent() + File.separator + mapped[k]);
                    try {
                        this.embed(in, out, options);
                        continue;
                    }
                    catch (IOException ex) {
                        throw new BuildException(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        }
    }

    private void embed(File input, File output, int options) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(input), this.charset);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bytes, this.charset);
        String pathRoot = this.root;
        if (pathRoot == null) {
            pathRoot = input.getCanonicalPath();
            pathRoot = pathRoot.substring(0, pathRoot.lastIndexOf(File.separator));
        }
        if (!pathRoot.endsWith(File.separator)) {
            pathRoot = pathRoot + File.separator;
        }
        if (this.verbose) {
            this.log("[INFO] embedding images from '" + input + "'");
        }
        CSSURLEmbedder embedder = new CSSURLEmbedder(in, options, this.verbose, this.maxUriLength, this.maxImageSize);
        if (this.mhtml) {
            embedder.setMHTMLRoot(this.mhtmlRoot);
            embedder.setFilename(output.getName());
        }
        embedder.embedImages(out, pathRoot);
        ((Reader)in).close();
        ((Writer)out).close();
        if (bytes.size() > 0) {
            FileOutputStream fos = new FileOutputStream(output);
            if (this.verbose) {
                this.log("[INFO] Writing to file: " + output);
            }
            bytes.writeTo(fos);
            fos.close();
        }
    }
}

