/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.compressor;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import jargs.gnu.CmdLineParser;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class YUICompressor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option typeOpt = parser.addStringOption("type");
        CmdLineParser.Option verboseOpt = parser.addBooleanOption('v', "verbose");
        CmdLineParser.Option nomungeOpt = parser.addBooleanOption("nomunge");
        CmdLineParser.Option linebreakOpt = parser.addStringOption("line-break");
        CmdLineParser.Option preserveSemiOpt = parser.addBooleanOption("preserve-semi");
        CmdLineParser.Option disableOptimizationsOpt = parser.addBooleanOption("disable-optimizations");
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option charsetOpt = parser.addStringOption("charset");
        CmdLineParser.Option outputFilenameOpt = parser.addStringOption('o', "output");
        Reader in = null;
        Writer out = null;
        try {
            String output;
            String[] fileArgs;
            List<String> files;
            String type;
            parser.parse(args);
            Boolean help = (Boolean)parser.getOptionValue(helpOpt);
            if (help != null && help.booleanValue()) {
                YUICompressor.usage();
                System.exit(0);
            }
            boolean verbose = parser.getOptionValue(verboseOpt) != null;
            String charset = (String)parser.getOptionValue(charsetOpt);
            if (charset == null || !Charset.isSupported(charset)) {
                charset = "UTF-8";
                if (verbose) {
                    System.err.println("\n[INFO] Using charset " + charset);
                }
            }
            int linebreakpos = -1;
            String linebreakstr = (String)parser.getOptionValue(linebreakOpt);
            if (linebreakstr != null) {
                try {
                    linebreakpos = Integer.parseInt(linebreakstr, 10);
                }
                catch (NumberFormatException e) {
                    YUICompressor.usage();
                    System.exit(1);
                }
            }
            if ((type = (String)parser.getOptionValue(typeOpt)) != null && !type.equalsIgnoreCase("js") && !type.equalsIgnoreCase("css")) {
                YUICompressor.usage();
                System.exit(1);
            }
            if ((files = Arrays.asList(fileArgs = parser.getRemainingArgs())).isEmpty()) {
                if (type == null) {
                    YUICompressor.usage();
                    System.exit(1);
                }
                files = new ArrayList<String>();
                files.add("-");
            }
            String[] pattern = (output = (String)parser.getOptionValue(outputFilenameOpt)) != null ? output.split(":") : new String[]{};
            for (String inputFilename : files) {
                try {
                    Object compressor;
                    if (inputFilename.equals("-")) {
                        in = new InputStreamReader(System.in, charset);
                    } else {
                        int idx;
                        if (type == null && (idx = inputFilename.lastIndexOf(46)) >= 0 && idx < inputFilename.length() - 1) {
                            type = inputFilename.substring(idx + 1);
                        }
                        if (type == null || !type.equalsIgnoreCase("js") && !type.equalsIgnoreCase("css")) {
                            YUICompressor.usage();
                            System.exit(1);
                        }
                        in = new InputStreamReader((InputStream)new FileInputStream(inputFilename), charset);
                    }
                    String outputFilename = output;
                    if (pattern.length > 1 && files.size() > 1) {
                        outputFilename = inputFilename.replaceFirst(pattern[0], pattern[1]);
                    }
                    if (type.equalsIgnoreCase("js")) {
                        try {
                            compressor = new JavaScriptCompressor(in, new ErrorReporter(){

                                public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                    if (line < 0) {
                                        System.err.println("\n[WARNING] " + message);
                                    } else {
                                        System.err.println("\n[WARNING] " + line + ':' + lineOffset + ':' + message);
                                    }
                                }

                                public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                    if (line < 0) {
                                        System.err.println("\n[ERROR] " + message);
                                    } else {
                                        System.err.println("\n[ERROR] " + line + ':' + lineOffset + ':' + message);
                                    }
                                }

                                public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                    this.error(message, sourceName, line, lineSource, lineOffset);
                                    return new EvaluatorException(message);
                                }
                            });
                            in.close();
                            in = null;
                            out = outputFilename == null ? new OutputStreamWriter((OutputStream)System.out, charset) : new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilename), charset);
                            boolean munge = parser.getOptionValue(nomungeOpt) == null;
                            boolean preserveAllSemiColons = parser.getOptionValue(preserveSemiOpt) != null;
                            boolean disableOptimizations = parser.getOptionValue(disableOptimizationsOpt) != null;
                            ((JavaScriptCompressor)compressor).compress(out, linebreakpos, munge, verbose, preserveAllSemiColons, disableOptimizations);
                        }
                        catch (EvaluatorException e) {
                            e.printStackTrace();
                            System.exit(2);
                        }
                        continue;
                    }
                    if (!type.equalsIgnoreCase("css")) continue;
                    compressor = new CssCompressor(in);
                    in.close();
                    in = null;
                    out = outputFilename == null ? new OutputStreamWriter((OutputStream)System.out, charset) : new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilename), charset);
                    ((CssCompressor)compressor).compress(out, linebreakpos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (out == null) continue;
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (CmdLineParser.OptionException e) {
            YUICompressor.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("\nUsage: java -jar yuicompressor-2.4.6.jar [options] [input file]\n\nGlobal Options\n  -h, --help                Displays this information\n  --type <js|css>           Specifies the type of the input file\n  --charset <charset>       Read the input file using <charset>\n  --line-break <column>     Insert a line break after the specified column number\n  -v, --verbose             Display informational messages and warnings\n  -o <file>                 Place the output into <file>. Defaults to stdout.\n                            Multiple files can be processed using the following syntax:\n                            java -jar yuicompressor.jar -o '.css$:-min.css' *.css\n                            java -jar yuicompressor.jar -o '.js$:-min.js' *.js\n\nJavaScript Options\n  --nomunge                 Minify only, do not obfuscate\n  --preserve-semi           Preserve all semicolons\n  --disable-optimizations   Disable all micro optimizations\n\nIf no input file is specified, it defaults to stdin. In this case, the 'type'\noption is required. Otherwise, the 'type' option is required only if the input\nfile extension is neither 'js' nor 'css'.");
    }
}

