/*
 * Decompiled with CFR 0.152.
 */
package net.nczonline.web.datauri;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import net.nczonline.web.datauri.Base64;

public class DataURIGenerator {
    private static HashMap binaryTypes = new HashMap();
    private static HashMap textTypes = new HashMap();
    private static boolean verbose = false;

    public static boolean getVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean newVerbose) {
        verbose = newVerbose;
    }

    public static void generate(File file, Writer out) throws IOException {
        DataURIGenerator.generate(file, out, null);
    }

    public static void generate(File file, Writer out, String mimeType) throws IOException {
        DataURIGenerator.generateDataURI(file, out, mimeType);
    }

    public static void generate(URL url, Writer out) throws IOException {
        DataURIGenerator.generate(url, out, null);
    }

    public static void generate(URL url, Writer out, String mimeType) throws IOException {
        DataURIGenerator.generateDataURI(url, out, mimeType);
    }

    private static void generateDataURI(File file, Writer out, String mimeType) throws IOException {
        FileInputStream in = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        ((InputStream)in).read(bytes);
        ((InputStream)in).close();
        mimeType = DataURIGenerator.getMimeType(file.getName(), mimeType);
        DataURIGenerator.generateDataURI(bytes, out, mimeType);
    }

    private static void generateDataURI(URL url, Writer out, String mimeType) throws IOException {
        int c;
        URLConnection conn = url.openConnection();
        if (mimeType == null) {
            mimeType = DataURIGenerator.getMimeType(url.getFile(), conn.getContentType());
            if (verbose) {
                System.err.println("[INFO] No MIME type provided, using detected type of '" + mimeType + "'.");
            }
        }
        mimeType = mimeType.indexOf("; charset=") > -1 ? mimeType.replace(" ", "") : DataURIGenerator.getMimeTypeWithCharset(mimeType);
        InputStream in = conn.getInputStream();
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        while ((c = in.read()) != -1) {
            byteStream.write(c);
        }
        byteStream.flush();
        in.close();
        DataURIGenerator.generateDataURI(byteStream.toByteArray(), out, mimeType);
    }

    private static void generateDataURI(byte[] bytes, Writer out, String mimeType) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("data:");
        buffer.append(mimeType);
        buffer.append(";base64,");
        buffer.append(new String(Base64.encodeBytes(bytes)));
        out.write(buffer.toString());
    }

    private static boolean isImageFile(String filename) {
        String fileType = DataURIGenerator.getFileType(filename);
        return binaryTypes.containsKey(fileType) && binaryTypes.get(fileType).toString().startsWith("image");
    }

    private static String getFileType(String filename) {
        String type = "";
        int idx = filename.lastIndexOf(46);
        if (idx >= 0 && idx < filename.length() - 1) {
            type = filename.substring(idx + 1);
        }
        return type;
    }

    private static String getMimeType(String filename, String mimeType) throws IOException {
        if (mimeType == null) {
            String type = DataURIGenerator.getFileType(filename);
            if (binaryTypes.containsKey(type)) {
                mimeType = (String)binaryTypes.get(type);
            } else if (textTypes.containsKey(type)) {
                mimeType = (String)textTypes.get(type) + ";charset=UTF-8";
            } else {
                throw new IOException("No MIME type provided and MIME type couldn't be automatically determined.");
            }
            if (verbose) {
                System.err.println("[INFO] No MIME type provided, defaulting to '" + mimeType + "'.");
            }
        }
        return mimeType;
    }

    private static String getMimeTypeWithCharset(String mimeType) {
        if (binaryTypes.containsValue(mimeType)) {
            if (verbose) {
                System.err.println("[INFO] Image file detected, skipping charset.");
            }
            return mimeType;
        }
        if (verbose) {
            System.err.println("[INFO] Using charset 'UTF-8'.");
        }
        return mimeType + ";charset=UTF-8";
    }

    static {
        binaryTypes.put("gif", "image/gif");
        binaryTypes.put("jpg", "image/jpeg");
        binaryTypes.put("png", "image/png");
        binaryTypes.put("jpeg", "image/jpeg");
        textTypes.put("htm", "text/html");
        textTypes.put("html", "text/html");
        textTypes.put("xml", "application/xml");
        textTypes.put("xhtml", "application/xhtml+xml");
        textTypes.put("js", "application/x-javascript");
        textTypes.put("css", "text/css");
        textTypes.put("txt", "text/plain");
    }
}

