/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dijit/_editor/plugins/FontChoice":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/i18n","dojo/_base/lang","dojo/store/Memory","../../registry","../../_Widget","../../_TemplatedMixin","../../_WidgetsInTemplateMixin","../../form/FilteringSelect","../_Plugin","../range","dojo/i18n!../nls/FontChoice"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,_d,_e){var _f=_3("dijit._editor.plugins._FontDropDown",[_9,_a,_b],{label:"",plainText:false,templateString:"<span style='white-space: nowrap' class='dijit dijitReset dijitInline'>"+"<label class='dijitLeft dijitInline' for='${selectId}'>${label}</label>"+"<input data-dojo-type='../../form/FilteringSelect' required='false' "+"data-dojo-props='labelType:\"html\", labelAttr:\"label\", searchAttr:\"name\"' "+"class='${comboClass}' "+"tabIndex='-1' id='${selectId}' data-dojo-attach-point='select' value=''/>"+"</span>",contextRequire:_1,postMixInProperties:function(){this.inherited(arguments);this.strings=_5.getLocalization("dijit._editor","FontChoice");this.label=this.strings[this.command];this.id=_8.getUniqueId(this.declaredClass.replace(/\./g,"_"));this.selectId=this.id+"_select";this.inherited(arguments);},postCreate:function(){this.select.set("store",new _7({idProperty:"value",data:_2.map(this.values,function(_10){var _11=this.strings[_10]||_10;return {label:this.getLabel(_10,_11),name:_11,value:_10};},this)}));this.select.set("value","",false);this.disabled=this.select.get("disabled");},_setValueAttr:function(_12,_13){_13=_13!==false;this.select.set("value",_2.indexOf(this.values,_12)<0?"":_12,_13);if(!_13){this.select._lastValueReported=null;}},_getValueAttr:function(){return this.select.get("value");},focus:function(){this.select.focus();},_setDisabledAttr:function(_14){this._set("disabled",_14);this.select.set("disabled",_14);}});var _15=_3("dijit._editor.plugins._FontNameDropDown",_f,{generic:false,command:"fontName",comboClass:"dijitFontNameCombo",postMixInProperties:function(){if(!this.values){this.values=this.generic?["serif","sans-serif","monospace","cursive","fantasy"]:["Arial","Times New Roman","Comic Sans MS","Courier New"];}this.inherited(arguments);},getLabel:function(_16,_17){if(this.plainText){return _17;}else{return "<div style='font-family: "+_16+"'>"+_17+"</div>";}},_setValueAttr:function(_18,_19){_19=_19!==false;if(this.generic){var map={"Arial":"sans-serif","Helvetica":"sans-serif","Myriad":"sans-serif","Times":"serif","Times New Roman":"serif","Comic Sans MS":"cursive","Apple Chancery":"cursive","Courier":"monospace","Courier New":"monospace","Papyrus":"fantasy","Estrangelo Edessa":"cursive","Gabriola":"fantasy"};_18=map[_18]||_18;}this.inherited(arguments,[_18,_19]);}});var _1a=_3("dijit._editor.plugins._FontSizeDropDown",_f,{command:"fontSize",comboClass:"dijitFontSizeCombo",values:[1,2,3,4,5,6,7],getLabel:function(_1b,_1c){if(this.plainText){return _1c;}else{return "<font size="+_1b+"'>"+_1c+"</font>";}},_setValueAttr:function(_1d,_1e){_1e=_1e!==false;if(_1d.indexOf&&_1d.indexOf("px")!=-1){var _1f=parseInt(_1d,10);_1d={10:1,13:2,16:3,18:4,24:5,32:6,48:7}[_1f]||_1d;}this.inherited(arguments,[_1d,_1e]);}});var _20=_3("dijit._editor.plugins._FormatBlockDropDown",_f,{command:"formatBlock",comboClass:"dijitFormatBlockCombo",values:["noFormat","p","h1","h2","h3","pre"],postCreate:function(){this.inherited(arguments);this.set("value","noFormat",false);},getLabel:function(_21,_22){if(this.plainText||_21=="noFormat"){return _22;}else{return "<"+_21+">"+_22+"</"+_21+">";}},_execCommand:function(_23,_24,_25){if(_25==="noFormat"){var _26;var end;var sel=_e.getSelection(_23.window);if(sel&&sel.rangeCount>0){var _27=sel.getRangeAt(0);var _28,tag;if(_27){_26=_27.startContainer;end=_27.endContainer;while(_26&&_26!==_23.editNode&&_26!==_23.document.body&&_26.nodeType!==1){_26=_26.parentNode;}while(end&&end!==_23.editNode&&end!==_23.document.body&&end.nodeType!==1){end=end.parentNode;}var _29=_6.hitch(this,function(_2a,ary){if(_2a.childNodes&&_2a.childNodes.length){var i;for(i=0;i<_2a.childNodes.length;i++){var c=_2a.childNodes[i];if(c.nodeType==1){if(_23.selection.inSelection(c)){var tag=c.tagName?c.tagName.toLowerCase():"";if(_2.indexOf(this.values,tag)!==-1){ary.push(c);}_29(c,ary);}}}}});var _2b=_6.hitch(this,function(_2c){if(_2c&&_2c.length){_23.beginEditing();while(_2c.length){this._removeFormat(_23,_2c.pop());}_23.endEditing();}});var _2d=[];if(_26==end){var _2e;_28=_26;while(_28&&_28!==_23.editNode&&_28!==_23.document.body){if(_28.nodeType==1){tag=_28.tagName?_28.tagName.toLowerCase():"";if(_2.indexOf(this.values,tag)!==-1){_2e=_28;break;}}_28=_28.parentNode;}_29(_26,_2d);if(_2e){_2d=[_2e].concat(_2d);}_2b(_2d);}else{_28=_26;while(_23.selection.inSelection(_28)){if(_28.nodeType==1){tag=_28.tagName?_28.tagName.toLowerCase():"";if(_2.indexOf(this.values,tag)!==-1){_2d.push(_28);}_29(_28,_2d);}_28=_28.nextSibling;}_2b(_2d);}_23.onDisplayChanged();}}}else{_23.execCommand(_24,_25);}},_removeFormat:function(_2f,_30){if(_2f.customUndo){while(_30.firstChild){_4.place(_30.firstChild,_30,"before");}_30.parentNode.removeChild(_30);}else{_2f.selection.selectElementChildren(_30);var _31=_2f.selection.getSelectedHtml();_2f.selection.selectElement(_30);_2f.execCommand("inserthtml",_31||"");}}});var _32=_3("dijit._editor.plugins.FontChoice",_d,{useDefaultCommand:false,_initButton:function(){var _33={fontName:_15,fontSize:_1a,formatBlock:_20}[this.command],_34=this.params;if(this.params.custom){_34.values=this.params.custom;}var _35=this.editor;this.button=new _33(_6.delegate({dir:_35.dir,lang:_35.lang},_34));this.own(this.button.select.on("change",_6.hitch(this,function(_36){if(this.editor.focused){this.editor.focus();}if(this.command=="fontName"&&_36.indexOf(" ")!=-1){_36="'"+_36+"'";}if(this.button._execCommand){this.button._execCommand(this.editor,this.command,_36);}else{this.editor.execCommand(this.command,_36);}})));},updateState:function(){var _37=this.editor;var _38=this.command;if(!_37||!_37.isLoaded||!_38.length){return;}if(this.button){var _39=this.get("disabled");this.button.set("disabled",_39);if(_39){return;}var _3a;try{_3a=_37.queryCommandValue(_38)||"";}catch(e){_3a="";}var _3b=_6.isString(_3a)&&_3a.match(/'([^']*)'/);if(_3b){_3a=_3b[1];}if(_38==="formatBlock"){if(!_3a||_3a=="p"){_3a=null;var _3c;var sel=_e.getSelection(this.editor.window);if(sel&&sel.rangeCount>0){var _3d=sel.getRangeAt(0);if(_3d){_3c=_3d.endContainer;}}while(_3c&&_3c!==_37.editNode&&_3c!==_37.document){var tg=_3c.tagName?_3c.tagName.toLowerCase():"";if(tg&&_2.indexOf(this.button.values,tg)>-1){_3a=tg;break;}_3c=_3c.parentNode;}if(!_3a){_3a="noFormat";}}else{if(_2.indexOf(this.button.values,_3a)<0){_3a="noFormat";}}}if(_3a!==this.button.get("value")){this.button.set("value",_3a,false);}}}});_2.forEach(["fontName","fontSize","formatBlock"],function(_3e){_d.registry[_3e]=function(_3f){return new _32({command:_3e,plainText:_3f.plainText});};});_32._FontDropDown=_f;_32._FontNameDropDown=_15;_32._FontSizeDropDown=_1a;_32._FormatBlockDropDown=_20;return _32;});},"dijit/form/TextBox":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/dom-style","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","./_FormValueWidget","./_TextBoxMixin","dojo/text!./templates/TextBox.html","../main"],function(_40,_41,_42,_43,_44,on,has,_45,_46,_47,_48){var _49=_40("dijit.form.TextBox"+(has("dojo-bidi")?"_NoBidi":""),[_45,_46],{templateString:_47,_singleNodeTemplate:"<input class=\"dijit dijitReset dijitLeft dijitInputField\" data-dojo-attach-point=\"textbox,focusNode\" autocomplete=\"off\" type=\"${type}\" ${!nameAttrSetting} />",_buttonInputDisabled:has("ie")?"disabled":"",baseClass:"dijitTextBox",postMixInProperties:function(){var _4a=this.type.toLowerCase();if(this.templateString&&this.templateString.toLowerCase()=="input"||((_4a=="hidden"||_4a=="file")&&this.templateString==this.constructor.prototype.templateString)){this.templateString=this._singleNodeTemplate;}this.inherited(arguments);},postCreate:function(){this.inherited(arguments);if(has("ie")<9){this.defer(function(){try{var s=_42.getComputedStyle(this.domNode);if(s){var ff=s.fontFamily;if(ff){var _4b=this.domNode.getElementsByTagName("INPUT");if(_4b){for(var i=0;i<_4b.length;i++){_4b[i].style.fontFamily=ff;}}}}}catch(e){}});}},_setPlaceHolderAttr:function(v){this._set("placeHolder",v);if(!this._phspan){this._attachPoints.push("_phspan");this._phspan=_41.create("span",{onmousedown:function(e){e.preventDefault();},className:"dijitPlaceHolder dijitInputField"},this.textbox,"after");this.own(on(this._phspan,"touchend, MSPointerUp",_44.hitch(this,function(){this.focus();})));}this._phspan.innerHTML="";this._phspan.appendChild(this._phspan.ownerDocument.createTextNode(v));this._updatePlaceHolder();},_onInput:function(evt){this.inherited(arguments);this._updatePlaceHolder();},_updatePlaceHolder:function(){if(this._phspan){this._phspan.style.display=(this.placeHolder&&!this.textbox.value)?"":"none";}},_setValueAttr:function(_4c,_4d,_4e){this.inherited(arguments);this._updatePlaceHolder();},getDisplayedValue:function(){_43.deprecated(this.declaredClass+"::getDisplayedValue() is deprecated. Use get('displayedValue') instead.","","2.0");return this.get("displayedValue");},setDisplayedValue:function(_4f){_43.deprecated(this.declaredClass+"::setDisplayedValue() is deprecated. Use set('displayedValue', ...) instead.","","2.0");this.set("displayedValue",_4f);},_onBlur:function(e){if(this.disabled){return;}this.inherited(arguments);this._updatePlaceHolder();if(has("mozilla")){if(this.selectOnClick){this.textbox.selectionStart=this.textbox.selectionEnd=undefined;}}},_onFocus:function(by){if(this.disabled||this.readOnly){return;}this.inherited(arguments);this._updatePlaceHolder();}});if(has("ie")){_49.prototype._isTextSelected=function(){var _50=this.ownerDocument.selection.createRange();var _51=_50.parentElement();return _51==this.textbox&&_50.text.length>0;};_48._setSelectionRange=_46._setSelectionRange=function(_52,_53,_54){if(_52.createTextRange){var r=_52.createTextRange();r.collapse(true);r.moveStart("character",-99999);r.moveStart("character",_53);r.moveEnd("character",_54-_53);r.select();}};}if(has("dojo-bidi")){_49=_40("dijit.form.TextBox",_49,{_setPlaceHolderAttr:function(v){this.inherited(arguments);this.applyTextDir(this._phspan);}});}return _49;});},"dojo/currency":function(){define(["./_base/array","./_base/lang","./number","./i18n","./i18n!./cldr/nls/currency","./cldr/monetary"],function(_55,_56,_57,_58,_59,_5a){var _5b={};_56.setObject("dojo.currency",_5b);_5b._mixInDefaults=function(_5c){_5c=_5c||{};_5c.type="currency";var _5d=_58.getLocalization("dojo.cldr","currency",_5c.locale)||{};var iso=_5c.currency;var _5e=_5a.getData(iso);_55.forEach(["displayName","symbol","group","decimal"],function(_5f){_5e[_5f]=_5d[iso+"_"+_5f];});_5e.fractional=[true,false];return _56.mixin(_5e,_5c);};_5b.format=function(_60,_61){return _57.format(_60,_5b._mixInDefaults(_61));};_5b.regexp=function(_62){return _57.regexp(_5b._mixInDefaults(_62));};_5b.parse=function(_63,_64){return _57.parse(_63,_5b._mixInDefaults(_64));};return _5b;});},"dijit/layout/ScrollingTabController":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/_base/lang","dojo/on","dojo/query","dojo/sniff","../registry","dojo/text!./templates/ScrollingTabController.html","dojo/text!./templates/_ScrollingTabControllerButton.html","./TabController","./utils","../_WidgetsInTemplateMixin","../Menu","../MenuItem","../form/Button","../_HasDropDown","dojo/NodeList-dom","../a11yclick"],function(_65,_66,_67,_68,_69,fx,_6a,on,_6b,has,_6c,_6d,_6e,_6f,_70,_71,_72,_73,_74,_75){var _76=_66("dijit.layout.ScrollingTabController",[_6f,_71],{baseClass:"dijitTabController dijitScrollingTabController",templateString:_6d,useMenu:true,useSlider:true,tabStripClass:"",_minScroll:5,_setClassAttr:{node:"containerNode",type:"class"},buildRendering:function(){this.inherited(arguments);var n=this.domNode;this.scrollNode=this.tablistWrapper;this._initButtons();if(!this.tabStripClass){this.tabStripClass="dijitTabContainer"+this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"")+"None";_67.add(n,"tabStrip-disabled");}_67.add(this.tablistWrapper,this.tabStripClass);},onStartup:function(){this.inherited(arguments);_69.set(this.domNode,"visibility","");this._postStartup=true;this.own(on(this.containerNode,"attrmodified-label, attrmodified-iconclass",_6a.hitch(this,function(evt){if(this._dim){this.resize(this._dim);}})));},onAddChild:function(_77,_78){this.inherited(arguments);_69.set(this.containerNode,"width",(_69.get(this.containerNode,"width")+200)+"px");},onRemoveChild:function(_79,_7a){var _7b=this.pane2button(_79.id);if(this._selectedTab===_7b.domNode){this._selectedTab=null;}this.inherited(arguments);},_initButtons:function(){this._btnWidth=0;this._buttons=_6b("> .tabStripButton",this.domNode).filter(function(btn){if((this.useMenu&&btn==this._menuBtn.domNode)||(this.useSlider&&(btn==this._rightBtn.domNode||btn==this._leftBtn.domNode))){this._btnWidth+=_68.getMarginSize(btn).w;return true;}else{_69.set(btn,"display","none");return false;}},this);},_getTabsWidth:function(){var _7c=this.getChildren();if(_7c.length){var _7d=_7c[this.isLeftToRight()?0:_7c.length-1].domNode,_7e=_7c[this.isLeftToRight()?_7c.length-1:0].domNode;return _7e.offsetLeft+_7e.offsetWidth-_7d.offsetLeft;}else{return 0;}},_enableBtn:function(_7f){var _80=this._getTabsWidth();_7f=_7f||_69.get(this.scrollNode,"width");return _80>0&&_7f<_80;},resize:function(dim){this._dim=dim;this.scrollNode.style.height="auto";var cb=this._contentBox=_70.marginBox2contentBox(this.domNode,{h:0,w:dim.w});cb.h=this.scrollNode.offsetHeight;_68.setContentSize(this.domNode,cb);var _81=this._enableBtn(this._contentBox.w);this._buttons.style("display",_81?"":"none");this._leftBtn.region="left";this._rightBtn.region="right";this._menuBtn.region=this.isLeftToRight()?"right":"left";_70.layoutChildren(this.domNode,this._contentBox,[this._menuBtn,this._leftBtn,this._rightBtn,{domNode:this.scrollNode,region:"center"}]);if(this._selectedTab){if(this._anim&&this._anim.status()=="playing"){this._anim.stop();}this.scrollNode.scrollLeft=this._convertToScrollLeft(this._getScrollForSelectedTab());}this._setButtonClass(this._getScroll());this._postResize=true;return {h:this._contentBox.h,w:dim.w};},_getScroll:function(){return (this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit"))?this.scrollNode.scrollLeft:_69.get(this.containerNode,"width")-_69.get(this.scrollNode,"width")+(has("ie")>=8?-1:1)*this.scrollNode.scrollLeft;},_convertToScrollLeft:function(val){if(this.isLeftToRight()||has("ie")<8||(has("ie")&&has("quirks"))||has("webkit")){return val;}else{var _82=_69.get(this.containerNode,"width")-_69.get(this.scrollNode,"width");return (has("ie")>=8?-1:1)*(val-_82);}},onSelectChild:function(_83){var tab=this.pane2button(_83.id);if(!tab){return;}var _84=tab.domNode;if(_84!=this._selectedTab){this._selectedTab=_84;if(this._postResize){var sl=this._getScroll();if(sl>_84.offsetLeft||sl+_69.get(this.scrollNode,"width")<_84.offsetLeft+_69.get(_84,"width")){this.createSmoothScroll().play();}}}this.inherited(arguments);},_getScrollBounds:function(){var _85=this.getChildren(),_86=_69.get(this.scrollNode,"width"),_87=_69.get(this.containerNode,"width"),_88=_87-_86,_89=this._getTabsWidth();if(_85.length&&_89>_86){return {min:this.isLeftToRight()?0:_85[_85.length-1].domNode.offsetLeft,max:this.isLeftToRight()?(_85[_85.length-1].domNode.offsetLeft+_85[_85.length-1].domNode.offsetWidth)-_86:_88};}else{var _8a=this.isLeftToRight()?0:_88;return {min:_8a,max:_8a};}},_getScrollForSelectedTab:function(){var w=this.scrollNode,n=this._selectedTab,_8b=_69.get(this.scrollNode,"width"),_8c=this._getScrollBounds();var pos=(n.offsetLeft+_69.get(n,"width")/2)-_8b/2;pos=Math.min(Math.max(pos,_8c.min),_8c.max);return pos;},createSmoothScroll:function(x){if(arguments.length>0){var _8d=this._getScrollBounds();x=Math.min(Math.max(x,_8d.min),_8d.max);}else{x=this._getScrollForSelectedTab();}if(this._anim&&this._anim.status()=="playing"){this._anim.stop();}var _8e=this,w=this.scrollNode,_8f=new fx.Animation({beforeBegin:function(){if(this.curve){delete this.curve;}var _90=w.scrollLeft,_91=_8e._convertToScrollLeft(x);_8f.curve=new fx._Line(_90,_91);},onAnimate:function(val){w.scrollLeft=val;}});this._anim=_8f;this._setButtonClass(x);return _8f;},_getBtnNode:function(e){var n=e.target;while(n&&!_67.contains(n,"tabStripButton")){n=n.parentNode;}return n;},doSlideRight:function(e){this.doSlide(1,this._getBtnNode(e));},doSlideLeft:function(e){this.doSlide(-1,this._getBtnNode(e));},doSlide:function(_92,_93){if(_93&&_67.contains(_93,"dijitTabDisabled")){return;}var _94=_69.get(this.scrollNode,"width");var d=(_94*0.75)*_92;var to=this._getScroll()+d;this._setButtonClass(to);this.createSmoothScroll(to).play();},_setButtonClass:function(_95){var _96=this._getScrollBounds();this._leftBtn.set("disabled",_95<=_96.min);this._rightBtn.set("disabled",_95>=_96.max);}});var _97=_66("dijit.layout._ScrollingTabControllerButtonMixin",null,{baseClass:"dijitTab tabStripButton",templateString:_6e,tabIndex:"",isFocusable:function(){return false;}});_66("dijit.layout._ScrollingTabControllerButton",[_74,_97]);_66("dijit.layout._ScrollingTabControllerMenuButton",[_74,_75,_97],{containerId:"",tabIndex:"-1",isLoaded:function(){return false;},loadDropDown:function(_98){this.dropDown=new _72({id:this.containerId+"_menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir});var _99=_6c.byId(this.containerId);_65.forEach(_99.getChildren(),function(_9a){var _9b=new _73({id:_9a.id+"_stcMi",label:_9a.title,iconClass:_9a.iconClass,disabled:_9a.disabled,ownerDocument:this.ownerDocument,dir:_9a.dir,lang:_9a.lang,textDir:_9a.textDir||_99.textDir,onClick:function(){_99.selectChild(_9a);}});this.dropDown.addChild(_9b);},this);_98();},closeDropDown:function(_9c){this.inherited(arguments);if(this.dropDown){this._popupStateNode.removeAttribute("aria-owns");this.dropDown.destroyRecursive();delete this.dropDown;}}});return _76;});},"dijit/DialogUnderlay":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/aspect","dojo/dom-attr","dojo/dom-style","dojo/on","dojo/window","./_Widget","./_TemplatedMixin","./BackgroundIframe","./Viewport","./main"],function(_9d,_9e,_9f,_a0,_a1,on,_a2,_a3,_a4,_a5,_a6,_a7){var _a8=_9d("dijit.DialogUnderlay",[_a3,_a4],{templateString:"<div class='dijitDialogUnderlayWrapper'><div class='dijitDialogUnderlay' tabIndex='-1' data-dojo-attach-point='node'></div></div>",dialogId:"","class":"",_modalConnects:[],_setDialogIdAttr:function(id){_a0.set(this.node,"id",id+"_underlay");this._set("dialogId",id);},_setClassAttr:function(_a9){this.node.className="dijitDialogUnderlay "+_a9;this._set("class",_a9);},postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.own(on(this.domNode,"keydown",_9e.hitch(this,"_onKeyDown")));this.inherited(arguments);},layout:function(){var is=this.node.style,os=this.domNode.style;os.display="none";var _aa=_a2.getBox(this.ownerDocument);os.top=_aa.t+"px";os.left=_aa.l+"px";is.width=_aa.w+"px";is.height=_aa.h+"px";os.display="block";},show:function(){this.domNode.style.display="block";this.open=true;this.layout();this.bgIframe=new _a5(this.domNode);var win=_a2.get(this.ownerDocument);this._modalConnects=[_a6.on("resize",_9e.hitch(this,"layout")),on(win,"scroll",_9e.hitch(this,"layout"))];},hide:function(){this.bgIframe.destroy();delete this.bgIframe;this.domNode.style.display="none";while(this._modalConnects.length){(this._modalConnects.pop()).remove();}this.open=false;},destroy:function(){while(this._modalConnects.length){(this._modalConnects.pop()).remove();}this.inherited(arguments);},_onKeyDown:function(){}});_a8.show=function(_ab,_ac){var _ad=_a8._singleton;if(!_ad||_ad._destroyed){_ad=_a7._underlay=_a8._singleton=new _a8(_ab);}else{if(_ab){_ad.set(_ab);}}_a1.set(_ad.domNode,"zIndex",_ac);if(!_ad.open){_ad.show();}};_a8.hide=function(){var _ae=_a8._singleton;if(_ae&&!_ae._destroyed){_ae.hide();}};return _a8;});},"dijit/_editor/html":function(){define(["dojo/_base/array","dojo/_base/lang","dojo/sniff"],function(_af,_b0,has){var _b1={};_b0.setObject("dijit._editor.html",_b1);var _b2=_b1.escapeXml=function(str,_b3){str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");if(!_b3){str=str.replace(/'/gm,"&#39;");}return str;};_b1.getNodeHtml=function(_b4){var _b5=[];_b1.getNodeHtmlHelper(_b4,_b5);return _b5.join("");};_b1.getNodeHtmlHelper=function(_b6,_b7){switch(_b6.nodeType){case 1:var _b8=_b6.nodeName.toLowerCase();if(!_b8||_b8.charAt(0)=="/"){return "";}_b7.push("<",_b8);var _b9=[],_ba={};var _bb;if(has("dom-attributes-explicit")||has("dom-attributes-specified-flag")){var i=0;while((_bb=_b6.attributes[i++])){var n=_bb.name;if(n.substr(0,3)!=="_dj"&&(!has("dom-attributes-specified-flag")||_bb.specified)&&!(n in _ba)){var v=_bb.value;if(n=="src"||n=="href"){if(_b6.getAttribute("_djrealurl")){v=_b6.getAttribute("_djrealurl");}}if(has("ie")===8&&n==="style"){v=v.replace("HEIGHT:","height:").replace("WIDTH:","width:");}_b9.push([n,v]);_ba[n]=v;}}}else{var _bc=/^input$|^img$/i.test(_b6.nodeName)?_b6:_b6.cloneNode(false);var s=_bc.outerHTML;var _bd=/[\w-]+=("[^"]*"|'[^']*'|\S*)/gi;var _be=s.match(_bd);s=s.substr(0,s.indexOf(">"));_af.forEach(_be,function(_bf){if(_bf){var idx=_bf.indexOf("=");if(idx>0){var key=_bf.substring(0,idx);if(key.substr(0,3)!="_dj"){if(key=="src"||key=="href"){if(_b6.getAttribute("_djrealurl")){_b9.push([key,_b6.getAttribute("_djrealurl")]);return;}}var val,_c0;switch(key){case "style":val=_b6.style.cssText.toLowerCase();break;case "class":val=_b6.className;break;case "width":if(_b8==="img"){_c0=/width=(\S+)/i.exec(s);if(_c0){val=_c0[1];}break;}case "height":if(_b8==="img"){_c0=/height=(\S+)/i.exec(s);if(_c0){val=_c0[1];}break;}default:val=_b6.getAttribute(key);}if(val!=null){_b9.push([key,val.toString()]);}}}}},this);}_b9.sort(function(a,b){return a[0]<b[0]?-1:(a[0]==b[0]?0:1);});var j=0;while((_bb=_b9[j++])){_b7.push(" ",_bb[0],"=\"",(typeof _bb[1]==="string"?_b2(_bb[1],true):_bb[1]),"\"");}switch(_b8){case "br":case "hr":case "img":case "input":case "base":case "meta":case "area":case "basefont":_b7.push(" />");break;case "script":_b7.push(">",_b6.innerHTML,"</",_b8,">");break;default:_b7.push(">");if(_b6.hasChildNodes()){_b1.getChildrenHtmlHelper(_b6,_b7);}_b7.push("</",_b8,">");}break;case 4:case 3:_b7.push(_b2(_b6.nodeValue,true));break;case 8:_b7.push("<!--",_b2(_b6.nodeValue,true),"-->");break;default:_b7.push("<!-- Element not recognized - Type: ",_b6.nodeType," Name: ",_b6.nodeName,"-->");}};_b1.getChildrenHtml=function(_c1){var _c2=[];_b1.getChildrenHtmlHelper(_c1,_c2);return _c2.join("");};_b1.getChildrenHtmlHelper=function(dom,_c3){if(!dom){return;}var _c4=dom["childNodes"]||dom;var _c5=!has("ie")||_c4!==dom;var _c6,i=0;while((_c6=_c4[i++])){if(!_c5||_c6.parentNode==dom){_b1.getNodeHtmlHelper(_c6,_c3);}}};return _b1;});},"dijit/_HasDropDown":function(){define(["dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","./registry","./focus","./popup","./_FocusMixin"],function(_c7,_c8,dom,_c9,_ca,_cb,_cc,has,_cd,_ce,on,_cf,_d0,_d1,_d2,_d3){return _c7("dijit._HasDropDown",_d3,{_buttonNode:null,_arrowWrapperNode:null,_popupStateNode:null,_aroundNode:null,dropDown:null,autoWidth:true,forceWidth:false,maxHeight:-1,dropDownPosition:["below","above"],_stopClickEvents:true,_onDropDownMouseDown:function(e){if(this.disabled||this.readOnly){return;}e.preventDefault();this._docHandler=this.own(on(this.ownerDocument,_cf.release,_ce.hitch(this,"_onDropDownMouseUp")))[0];this.toggleDropDown();},_onDropDownMouseUp:function(e){if(e&&this._docHandler){this._docHandler.remove();this._docHandler=null;}var _d4=this.dropDown,_d5=false;if(e&&this._opened){var c=_cb.position(this._buttonNode,true);if(!(e.pageX>=c.x&&e.pageX<=c.x+c.w)||!(e.pageY>=c.y&&e.pageY<=c.y+c.h)){var t=e.target;while(t&&!_d5){if(_ca.contains(t,"dijitPopup")){_d5=true;}else{t=t.parentNode;}}if(_d5){t=e.target;if(_d4.onItemClick){var _d6;while(t&&!(_d6=_d0.byNode(t))){t=t.parentNode;}if(_d6&&_d6.onClick&&_d6.getParent){_d6.getParent().onItemClick(_d6,e);}}return;}}}if(this._opened){if(_d4.focus&&_d4.autoFocus!==false){this._focusDropDownTimer=this.defer(function(){_d4.focus();delete this._focusDropDownTimer;});}}else{if(this.focus){this.defer("focus");}}},_onDropDownClick:function(e){if(this._stopClickEvents){e.stopPropagation();e.preventDefault();}},buildRendering:function(){this.inherited(arguments);this._buttonNode=this._buttonNode||this.focusNode||this.domNode;this._popupStateNode=this._popupStateNode||this.focusNode||this._buttonNode;var _d7={"after":this.isLeftToRight()?"Right":"Left","before":this.isLeftToRight()?"Left":"Right","above":"Up","below":"Down","left":"Left","right":"Right"}[this.dropDownPosition[0]]||this.dropDownPosition[0]||"Down";_ca.add(this._arrowWrapperNode||this._buttonNode,"dijit"+_d7+"ArrowButton");},postCreate:function(){this.inherited(arguments);var _d8=this.focusNode||this.domNode;this.own(on(this._buttonNode,_cf.press,_ce.hitch(this,"_onDropDownMouseDown")),on(this._buttonNode,"click",_ce.hitch(this,"_onDropDownClick")),on(_d8,"keydown",_ce.hitch(this,"_onKey")),on(_d8,"keyup",_ce.hitch(this,"_onKeyUp")));},destroy:function(){if(this.dropDown){if(!this.dropDown._destroyed){this.dropDown.destroyRecursive();}delete this.dropDown;}this.inherited(arguments);},_onKey:function(e){if(this.disabled||this.readOnly){return;}var d=this.dropDown,_d9=e.target;if(d&&this._opened&&d.handleKey){if(d.handleKey(e)===false){e.stopPropagation();e.preventDefault();return;}}if(d&&this._opened&&e.keyCode==_cd.ESCAPE){this.closeDropDown();e.stopPropagation();e.preventDefault();}else{if(!this._opened&&(e.keyCode==_cd.DOWN_ARROW||((e.keyCode==_cd.ENTER||(e.keyCode==_cd.SPACE&&(!this._searchTimer||(e.ctrlKey||e.altKey||e.metaKey))))&&((_d9.tagName||"").toLowerCase()!=="input"||(_d9.type&&_d9.type.toLowerCase()!=="text"))))){this._toggleOnKeyUp=true;e.stopPropagation();e.preventDefault();}}},_onKeyUp:function(){if(this._toggleOnKeyUp){delete this._toggleOnKeyUp;this.toggleDropDown();var d=this.dropDown;if(d&&d.focus){this.defer(_ce.hitch(d,"focus"),1);}}},_onBlur:function(){this.closeDropDown(false);this.inherited(arguments);},isLoaded:function(){return true;},loadDropDown:function(_da){_da();},loadAndOpenDropDown:function(){var d=new _c8(),_db=_ce.hitch(this,function(){this.openDropDown();d.resolve(this.dropDown);});if(!this.isLoaded()){this.loadDropDown(_db);}else{_db();}return d;},toggleDropDown:function(){if(this.disabled||this.readOnly){return;}if(!this._opened){this.loadAndOpenDropDown();}else{this.closeDropDown(true);}},openDropDown:function(){var _dc=this.dropDown,_dd=_dc.domNode,_de=this._aroundNode||this.domNode,_df=this;var _e0=_d2.open({parent:this,popup:_dc,around:_de,orient:this.dropDownPosition,maxHeight:this.maxHeight,onExecute:function(){_df.closeDropDown(true);},onCancel:function(){_df.closeDropDown(true);},onClose:function(){_c9.set(_df._popupStateNode,"popupActive",false);_ca.remove(_df._popupStateNode,"dijitHasDropDownOpen");_df._set("_opened",false);}});if(this.forceWidth||(this.autoWidth&&_de.offsetWidth>_dc._popupWrapper.offsetWidth)){var _e1={w:_de.offsetWidth-(_dc._popupWrapper.offsetWidth-_dc.domNode.offsetWidth)};if(_ce.isFunction(_dc.resize)){_dc.resize(_e1);}else{_cb.setMarginBox(_dd,_e1);}}_c9.set(this._popupStateNode,"popupActive","true");_ca.add(this._popupStateNode,"dijitHasDropDownOpen");this._set("_opened",true);this._popupStateNode.setAttribute("aria-expanded","true");this._popupStateNode.setAttribute("aria-owns",_dc.id);if(_dd.getAttribute("role")!=="presentation"&&!_dd.getAttribute("aria-labelledby")){_dd.setAttribute("aria-labelledby",this.id);}return _e0;},closeDropDown:function(_e2){if(this._focusDropDownTimer){this._focusDropDownTimer.remove();delete this._focusDropDownTimer;}if(this._opened){this._popupStateNode.setAttribute("aria-expanded","false");if(_e2){this.focus();}_d2.close(this.dropDown);this._opened=false;}}});});},"dijit/tree/TreeStoreModel":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang"],function(_e3,_e4,_e5,_e6){return _e5("dijit.tree.TreeStoreModel",null,{store:null,childrenAttrs:["children"],newItemIdAttr:"id",labelAttr:"",root:null,query:null,deferItemLoadingUntilExpand:false,constructor:function(_e7){_e6.mixin(this,_e7);this.connects=[];var _e8=this.store;if(!_e8.getFeatures()["dojo.data.api.Identity"]){throw new Error("dijit.tree.TreeStoreModel: store must support dojo.data.Identity");}if(_e8.getFeatures()["dojo.data.api.Notification"]){this.connects=this.connects.concat([_e4.after(_e8,"onNew",_e6.hitch(this,"onNewItem"),true),_e4.after(_e8,"onDelete",_e6.hitch(this,"onDeleteItem"),true),_e4.after(_e8,"onSet",_e6.hitch(this,"onSetItem"),true)]);}},destroy:function(){var h;while(h=this.connects.pop()){h.remove();}},getRoot:function(_e9,_ea){if(this.root){_e9(this.root);}else{this.store.fetch({query:this.query,onComplete:_e6.hitch(this,function(_eb){if(_eb.length!=1){throw new Error("dijit.tree.TreeStoreModel: root query returned "+_eb.length+" items, but must return exactly one");}this.root=_eb[0];_e9(this.root);}),onError:_ea});}},mayHaveChildren:function(_ec){return _e3.some(this.childrenAttrs,function(_ed){return this.store.hasAttribute(_ec,_ed);},this);},getChildren:function(_ee,_ef,_f0){var _f1=this.store;if(!_f1.isItemLoaded(_ee)){var _f2=_e6.hitch(this,arguments.callee);_f1.loadItem({item:_ee,onItem:function(_f3){_f2(_f3,_ef,_f0);},onError:_f0});return;}var _f4=[];for(var i=0;i<this.childrenAttrs.length;i++){var _f5=_f1.getValues(_ee,this.childrenAttrs[i]);_f4=_f4.concat(_f5);}var _f6=0;if(!this.deferItemLoadingUntilExpand){_e3.forEach(_f4,function(_f7){if(!_f1.isItemLoaded(_f7)){_f6++;}});}if(_f6==0){_ef(_f4);}else{_e3.forEach(_f4,function(_f8,idx){if(!_f1.isItemLoaded(_f8)){_f1.loadItem({item:_f8,onItem:function(_f9){_f4[idx]=_f9;if(--_f6==0){_ef(_f4);}},onError:_f0});}});}},isItem:function(_fa){return this.store.isItem(_fa);},fetchItemByIdentity:function(_fb){this.store.fetchItemByIdentity(_fb);},getIdentity:function(_fc){return this.store.getIdentity(_fc);},getLabel:function(_fd){if(this.labelAttr){return this.store.getValue(_fd,this.labelAttr);}else{return this.store.getLabel(_fd);}},newItem:function(_fe,_ff,_100){var _101={parent:_ff,attribute:this.childrenAttrs[0]},_102;if(this.newItemIdAttr&&_fe[this.newItemIdAttr]){this.fetchItemByIdentity({identity:_fe[this.newItemIdAttr],scope:this,onItem:function(item){if(item){this.pasteItem(item,null,_ff,true,_100);}else{_102=this.store.newItem(_fe,_101);if(_102&&(_100!=undefined)){this.pasteItem(_102,_ff,_ff,false,_100);}}}});}else{_102=this.store.newItem(_fe,_101);if(_102&&(_100!=undefined)){this.pasteItem(_102,_ff,_ff,false,_100);}}},pasteItem:function(_103,_104,_105,_106,_107){var _108=this.store,_109=this.childrenAttrs[0];if(_104){_e3.forEach(this.childrenAttrs,function(attr){if(_108.containsValue(_104,attr,_103)){if(!_106){var _10a=_e3.filter(_108.getValues(_104,attr),function(x){return x!=_103;});_108.setValues(_104,attr,_10a);}_109=attr;}});}if(_105){if(typeof _107=="number"){var _10b=_108.getValues(_105,_109).slice();_10b.splice(_107,0,_103);_108.setValues(_105,_109,_10b);}else{_108.setValues(_105,_109,_108.getValues(_105,_109).concat(_103));}}},onChange:function(){},onChildrenChange:function(){},onDelete:function(){},onNewItem:function(item,_10c){if(!_10c){return;}this.getChildren(_10c.item,_e6.hitch(this,function(_10d){this.onChildrenChange(_10c.item,_10d);}));},onDeleteItem:function(item){this.onDelete(item);},onSetItem:function(item,_10e){if(_e3.indexOf(this.childrenAttrs,_10e)!=-1){this.getChildren(item,_e6.hitch(this,function(_10f){this.onChildrenChange(item,_10f);}));}else{this.onChange(item);}}});});},"dijit/_editor/plugins/EnterKeyHandling":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","../_Plugin","../RichText","../range","../../_base/focus"],function(_110,_111,keys,lang,on,has,win,_112,_113,_114,_115,_116){return _110("dijit._editor.plugins.EnterKeyHandling",_113,{blockNodeForEnter:"BR",constructor:function(args){if(args){if("blockNodeForEnter" in args){args.blockNodeForEnter=args.blockNodeForEnter.toUpperCase();}lang.mixin(this,args);}},setEditor:function(_117){if(this.editor===_117){return;}this.editor=_117;if(this.blockNodeForEnter=="BR"){this.editor.customUndo=true;_117.onLoadDeferred.then(lang.hitch(this,function(d){this.own(on(_117.document,"keydown",lang.hitch(this,function(e){if(e.keyCode==keys.ENTER){var ne=lang.mixin({},e);ne.shiftKey=true;if(!this.handleEnterKey(ne)){e.stopPropagation();e.preventDefault();}}})));if(has("ie")>=9){this.own(on(_117.document,"paste",lang.hitch(this,function(e){setTimeout(lang.hitch(this,function(){var r=this.editor.document.selection.createRange();r.move("character",-1);r.select();r.move("character",1);r.select();}),0);})));}return d;}));}else{if(this.blockNodeForEnter){var h=lang.hitch(this,"handleEnterKey");_117.addKeyHandler(13,0,0,h);_117.addKeyHandler(13,0,1,h);this.own(this.editor.on("KeyPressed",lang.hitch(this,"onKeyPressed")));}}},onKeyPressed:function(){if(this._checkListLater){if(win.withGlobal(this.editor.window,"isCollapsed",_116)){var _118=this.editor.selection.getAncestorElement("LI");if(!_118){_114.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);var _119=this.editor.selection.getAncestorElement(this.blockNodeForEnter);if(_119){_119.innerHTML=this.bogusHtmlContent;if(has("ie")<=9){var r=this.editor.document.selection.createRange();r.move("character",-1);r.select();}}else{console.error("onKeyPressed: Cannot find the new block node");}}else{if(has("mozilla")){if(_118.parentNode.parentNode.nodeName=="LI"){_118=_118.parentNode.parentNode;}}var fc=_118.firstChild;if(fc&&fc.nodeType==1&&(fc.nodeName=="UL"||fc.nodeName=="OL")){_118.insertBefore(fc.ownerDocument.createTextNode(" "),fc);var _11a=_115.create(this.editor.window);_11a.setStart(_118.firstChild,0);var _11b=_115.getSelection(this.editor.window,true);_11b.removeAllRanges();_11b.addRange(_11a);}}}this._checkListLater=false;}if(this._pressedEnterInBlock){if(this._pressedEnterInBlock.previousSibling){this.removeTrailingBr(this._pressedEnterInBlock.previousSibling);}delete this._pressedEnterInBlock;}},bogusHtmlContent:"&#160;",blockNodes:/^(?:P|H1|H2|H3|H4|H5|H6|LI)$/,handleEnterKey:function(e){var _11c,_11d,_11e,_11f,_120,_121,doc=this.editor.document,br,rs,txt;if(e.shiftKey){var _122=this.editor.selection.getParentElement();var _123=_115.getAncestor(_122,this.blockNodes);if(_123){if(_123.tagName=="LI"){return true;}_11c=_115.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);if(!_11d.collapsed){_11d.deleteContents();_11c=_115.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);}if(_115.atBeginningOfContainer(_123,_11d.startContainer,_11d.startOffset)){br=doc.createElement("br");_11e=_115.create(this.editor.window);_123.insertBefore(br,_123.firstChild);_11e.setStartAfter(br);_11c.removeAllRanges();_11c.addRange(_11e);}else{if(_115.atEndOfContainer(_123,_11d.startContainer,_11d.startOffset)){_11e=_115.create(this.editor.window);br=doc.createElement("br");_123.appendChild(br);_123.appendChild(doc.createTextNode(" "));_11e.setStart(_123.lastChild,0);_11c.removeAllRanges();_11c.addRange(_11e);}else{rs=_11d.startContainer;if(rs&&rs.nodeType==3){txt=rs.nodeValue;_11f=doc.createTextNode(txt.substring(0,_11d.startOffset));_120=doc.createTextNode(txt.substring(_11d.startOffset));_121=doc.createElement("br");if(_120.nodeValue==""&&has("webkit")){_120=doc.createTextNode(" ");}_111.place(_11f,rs,"after");_111.place(_121,_11f,"after");_111.place(_120,_121,"after");_111.destroy(rs);_11e=_115.create(this.editor.window);_11e.setStart(_120,0);_11c.removeAllRanges();_11c.addRange(_11e);return false;}return true;}}}else{_11c=_115.getSelection(this.editor.window);if(_11c.rangeCount){_11d=_11c.getRangeAt(0);if(_11d&&_11d.startContainer){if(!_11d.collapsed){_11d.deleteContents();_11c=_115.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);}rs=_11d.startContainer;if(rs&&rs.nodeType==3){var _124=false;var _125=_11d.startOffset;if(rs.length<_125){ret=this._adjustNodeAndOffset(rs,_125);rs=ret.node;_125=ret.offset;}txt=rs.nodeValue;_11f=doc.createTextNode(txt.substring(0,_125));_120=doc.createTextNode(txt.substring(_125));_121=doc.createElement("br");if(!_120.length){_120=doc.createTextNode(" ");_124=true;}if(_11f.length){_111.place(_11f,rs,"after");}else{_11f=rs;}_111.place(_121,_11f,"after");_111.place(_120,_121,"after");_111.destroy(rs);_11e=_115.create(this.editor.window);_11e.setStart(_120,0);_11e.setEnd(_120,_120.length);_11c.removeAllRanges();_11c.addRange(_11e);if(_124&&!has("webkit")){this.editor.selection.remove();}else{this.editor.selection.collapse(true);}}else{var _126;if(_11d.startOffset>=0){_126=rs.childNodes[_11d.startOffset];}var _121=doc.createElement("br");var _120=doc.createTextNode(" ");if(!_126){rs.appendChild(_121);rs.appendChild(_120);}else{_111.place(_121,_126,"before");_111.place(_120,_121,"after");}_11e=_115.create(this.editor.window);_11e.setStart(_120,0);_11e.setEnd(_120,_120.length);_11c.removeAllRanges();_11c.addRange(_11e);this.editor.selection.collapse(true);}}}else{_114.prototype.execCommand.call(this.editor,"inserthtml","<br>");}}return false;}var _127=true;_11c=_115.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);if(!_11d.collapsed){_11d.deleteContents();_11c=_115.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);}var _128=_115.getBlockAncestor(_11d.endContainer,null,this.editor.editNode);var _129=_128.blockNode;if((this._checkListLater=(_129&&(_129.nodeName=="LI"||_129.parentNode.nodeName=="LI")))){if(has("mozilla")){this._pressedEnterInBlock=_129;}if(/^(\s|&nbsp;|&#160;|\xA0|<span\b[^>]*\bclass=['"]Apple-style-span['"][^>]*>(\s|&nbsp;|&#160;|\xA0)<\/span>)?(<br>)?$/.test(_129.innerHTML)){_129.innerHTML="";if(has("webkit")){_11e=_115.create(this.editor.window);_11e.setStart(_129,0);_11c.removeAllRanges();_11c.addRange(_11e);}this._checkListLater=false;}return true;}if(!_128.blockNode||_128.blockNode===this.editor.editNode){try{_114.prototype.execCommand.call(this.editor,"formatblock",this.blockNodeForEnter);}catch(e2){}_128={blockNode:this.editor.selection.getAncestorElement(this.blockNodeForEnter),blockContainer:this.editor.editNode};if(_128.blockNode){if(_128.blockNode!=this.editor.editNode&&(!(_128.blockNode.textContent||_128.blockNode.innerHTML).replace(/^\s+|\s+$/g,"").length)){this.removeTrailingBr(_128.blockNode);return false;}}else{_128.blockNode=this.editor.editNode;}_11c=_115.getSelection(this.editor.window);_11d=_11c.getRangeAt(0);}var _12a=doc.createElement(this.blockNodeForEnter);_12a.innerHTML=this.bogusHtmlContent;this.removeTrailingBr(_128.blockNode);var _12b=_11d.endOffset;var node=_11d.endContainer;if(node.length<_12b){var ret=this._adjustNodeAndOffset(node,_12b);node=ret.node;_12b=ret.offset;}if(_115.atEndOfContainer(_128.blockNode,node,_12b)){if(_128.blockNode===_128.blockContainer){_128.blockNode.appendChild(_12a);}else{_111.place(_12a,_128.blockNode,"after");}_127=false;_11e=_115.create(this.editor.window);_11e.setStart(_12a,0);_11c.removeAllRanges();_11c.addRange(_11e);if(this.editor.height){_112.scrollIntoView(_12a);}}else{if(_115.atBeginningOfContainer(_128.blockNode,_11d.startContainer,_11d.startOffset)){_111.place(_12a,_128.blockNode,_128.blockNode===_128.blockContainer?"first":"before");if(_12a.nextSibling&&this.editor.height){_11e=_115.create(this.editor.window);_11e.setStart(_12a.nextSibling,0);_11c.removeAllRanges();_11c.addRange(_11e);_112.scrollIntoView(_12a.nextSibling);}_127=false;}else{if(_128.blockNode===_128.blockContainer){_128.blockNode.appendChild(_12a);}else{_111.place(_12a,_128.blockNode,"after");}_127=false;if(_128.blockNode.style){if(_12a.style){if(_128.blockNode.style.cssText){_12a.style.cssText=_128.blockNode.style.cssText;}}}rs=_11d.startContainer;var _12c;if(rs&&rs.nodeType==3){var _12d,_12e;_12b=_11d.endOffset;if(rs.length<_12b){ret=this._adjustNodeAndOffset(rs,_12b);rs=ret.node;_12b=ret.offset;}txt=rs.nodeValue;_11f=doc.createTextNode(txt.substring(0,_12b));_120=doc.createTextNode(txt.substring(_12b,txt.length));_111.place(_11f,rs,"before");_111.place(_120,rs,"after");_111.destroy(rs);var _12f=_11f.parentNode;while(_12f!==_128.blockNode){var tg=_12f.tagName;var _130=doc.createElement(tg);if(_12f.style){if(_130.style){if(_12f.style.cssText){_130.style.cssText=_12f.style.cssText;}}}if(_12f.tagName==="FONT"){if(_12f.color){_130.color=_12f.color;}if(_12f.face){_130.face=_12f.face;}if(_12f.size){_130.size=_12f.size;}}_12d=_120;while(_12d){_12e=_12d.nextSibling;_130.appendChild(_12d);_12d=_12e;}_111.place(_130,_12f,"after");_11f=_12f;_120=_130;_12f=_12f.parentNode;}_12d=_120;if(_12d.nodeType==1||(_12d.nodeType==3&&_12d.nodeValue)){_12a.innerHTML="";}_12c=_12d;while(_12d){_12e=_12d.nextSibling;_12a.appendChild(_12d);_12d=_12e;}}_11e=_115.create(this.editor.window);var _131;var _132=_12c;if(this.blockNodeForEnter!=="BR"){while(_132){_131=_132;_12e=_132.firstChild;_132=_12e;}if(_131&&_131.parentNode){_12a=_131.parentNode;_11e.setStart(_12a,0);_11c.removeAllRanges();_11c.addRange(_11e);if(this.editor.height){_112.scrollIntoView(_12a);}if(has("mozilla")){this._pressedEnterInBlock=_128.blockNode;}}else{_127=true;}}else{_11e.setStart(_12a,0);_11c.removeAllRanges();_11c.addRange(_11e);if(this.editor.height){_112.scrollIntoView(_12a);}if(has("mozilla")){this._pressedEnterInBlock=_128.blockNode;}}}}return _127;},_adjustNodeAndOffset:function(node,_133){while(node.length<_133&&node.nextSibling&&node.nextSibling.nodeType==3){_133=_133-node.length;node=node.nextSibling;}return {"node":node,"offset":_133};},removeTrailingBr:function(_134){var para=/P|DIV|LI/i.test(_134.tagName)?_134:this.editor.selection.getParentOfType(_134,["P","DIV","LI"]);if(!para){return;}if(para.lastChild){if((para.childNodes.length>1&&para.lastChild.nodeType==3&&/^[\s\xAD]*$/.test(para.lastChild.nodeValue))||para.lastChild.tagName=="BR"){_111.destroy(para.lastChild);}}if(!para.childNodes.length){para.innerHTML=this.bogusHtmlContent;}}});});},"dijit/_MenuBase":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/lang","dojo/mouse","dojo/on","dojo/window","./a11yclick","./registry","./_Widget","./_CssStateMixin","./_KeyNavContainer","./_TemplatedMixin"],function(_135,_136,dom,_137,_138,lang,_139,on,_13a,_13b,_13c,_13d,_13e,_13f,_140){return _136("dijit._MenuBase",[_13d,_140,_13f,_13e],{selected:null,_setSelectedAttr:function(item){if(this.selected!=item){if(this.selected){this.selected._setSelected(false);this._onChildDeselect(this.selected);}if(item){item._setSelected(true);}this._set("selected",item);}},activated:false,_setActivatedAttr:function(val){_138.toggle(this.domNode,"dijitMenuActive",val);_138.toggle(this.domNode,"dijitMenuPassive",!val);this._set("activated",val);},parentMenu:null,popupDelay:500,passivePopupDelay:Infinity,autoFocus:false,childSelector:function(node){var _141=_13c.byNode(node);return node.parentNode==this.containerNode&&_141&&_141.focus;},postCreate:function(){var self=this,_142=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");this.own(on(this.containerNode,on.selector(_142,_139.enter),function(){self.onItemHover(_13c.byNode(this));}),on(this.containerNode,on.selector(_142,_139.leave),function(){self.onItemUnhover(_13c.byNode(this));}),on(this.containerNode,on.selector(_142,_13b),function(evt){self.onItemClick(_13c.byNode(this),evt);evt.stopPropagation();evt.preventDefault();}));this.inherited(arguments);},onKeyboardSearch:function(item,evt,_143,_144){this.inherited(arguments);if(!!item&&(_144==-1||(!!item.popup&&_144==1))){this.onItemClick(item,evt);}},_keyboardSearchCompare:function(item,_145){if(!!item.shortcutKey){return _145==item.shortcutKey.toLowerCase()?-1:0;}return this.inherited(arguments)?1:0;},onExecute:function(){},onCancel:function(){},_moveToPopup:function(evt){if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){this.onItemClick(this.focusedChild,evt);}else{var _146=this._getTopMenu();if(_146&&_146._isMenuBar){_146.focusNext();}}},_onPopupHover:function(){this.set("selected",this.currentPopupItem);this._stopPendingCloseTimer();},onItemHover:function(item){if(this.activated){this.set("selected",item);if(item.popup&&!item.disabled&&!this.hover_timer){this.hover_timer=this.defer(function(){this._openItemPopup(item);},this.popupDelay);}}else{if(this.passivePopupDelay<Infinity){if(this.passive_hover_timer){this.passive_hover_timer.remove();}this.passive_hover_timer=this.defer(function(){this.onItemClick(item,{type:"click"});},this.passivePopupDelay);}}this._hoveredChild=item;item._set("hovering",true);},_onChildDeselect:function(item){this._stopPopupTimer();if(this.currentPopupItem==item){this._stopPendingCloseTimer();this._pendingClose_timer=this.defer(function(){this._pendingClose_timer=null;this.currentPopupItem=null;item._closePopup();},this.popupDelay);}},onItemUnhover:function(item){if(this._hoveredChild==item){this._hoveredChild=null;}if(this.passive_hover_timer){this.passive_hover_timer.remove();this.passive_hover_timer=null;}item._set("hovering",false);},_stopPopupTimer:function(){if(this.hover_timer){this.hover_timer=this.hover_timer.remove();}},_stopPendingCloseTimer:function(){if(this._pendingClose_timer){this._pendingClose_timer=this._pendingClose_timer.remove();}},_getTopMenu:function(){for(var top=this;top.parentMenu;top=top.parentMenu){}return top;},onItemClick:function(item,evt){if(this.passive_hover_timer){this.passive_hover_timer.remove();}this.focusChild(item);if(item.disabled){return false;}if(item.popup){this.set("selected",item);this.set("activated",true);this._openItemPopup(item,/^key/.test(evt._origType||evt.type));}else{this.onExecute();item._onClick?item._onClick(evt):item.onClick(evt);}},_openItemPopup:function(_147,_148){if(_147==this.currentPopupItem){return;}if(this.currentPopupItem){this._stopPendingCloseTimer();this.currentPopupItem._closePopup();}this._stopPopupTimer();var _149=_147.popup;_149.parentMenu=this;this.own(this._mouseoverHandle=on.once(_149.domNode,"mouseover",lang.hitch(this,"_onPopupHover")));var self=this;_147._openPopup({parent:this,orient:this._orient||["after","before"],onCancel:function(){if(_148){self.focusChild(_147);}self._cleanUp();},onExecute:lang.hitch(this,"_cleanUp",true),onClose:function(){if(self._mouseoverHandle){self._mouseoverHandle.remove();delete self._mouseoverHandle;}}},_148);this.currentPopupItem=_147;},onOpen:function(){this.isShowingNow=true;this.set("activated",true);},onClose:function(){this.set("activated",false);this.set("selected",null);this.isShowingNow=false;this.parentMenu=null;},_closeChild:function(){this._stopPopupTimer();if(this.currentPopupItem){if(this.focused){_137.set(this.selected.focusNode,"tabIndex",this.tabIndex);this.selected.focusNode.focus();}this.currentPopupItem._closePopup();this.currentPopupItem=null;}},_onItemFocus:function(item){if(this._hoveredChild&&this._hoveredChild!=item){this.onItemUnhover(this._hoveredChild);}this.set("selected",item);},_onBlur:function(){this._cleanUp(true);this.inherited(arguments);},_cleanUp:function(_14a){this._closeChild();if(typeof this.isShowingNow=="undefined"){this.set("activated",false);}if(_14a){this.set("selected",null);}}});});},"dijit/tree/ForestStoreModel":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","./TreeStoreModel"],function(_14b,_14c,_14d,lang,_14e){return _14c("dijit.tree.ForestStoreModel",_14e,{rootId:"$root$",rootLabel:"ROOT",query:null,constructor:function(_14f){this.root={store:this,root:true,id:_14f.rootId,label:_14f.rootLabel,children:_14f.rootChildren};},mayHaveChildren:function(item){return item===this.root||this.inherited(arguments);},getChildren:function(_150,_151,_152){if(_150===this.root){if(this.root.children){_151(this.root.children);}else{this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_153){this.root.children=_153;_151(_153);}),onError:_152});}}else{this.inherited(arguments);}},isItem:function(_154){return (_154===this.root)?true:this.inherited(arguments);},fetchItemByIdentity:function(_155){if(_155.identity==this.root.id){var _156=_155.scope||_14d.global;if(_155.onItem){_155.onItem.call(_156,this.root);}}else{this.inherited(arguments);}},getIdentity:function(item){return (item===this.root)?this.root.id:this.inherited(arguments);},getLabel:function(item){return (item===this.root)?this.root.label:this.inherited(arguments);},newItem:function(args,_157,_158){if(_157===this.root){this.onNewRootItem(args);return this.store.newItem(args);}else{return this.inherited(arguments);}},onNewRootItem:function(){},pasteItem:function(_159,_15a,_15b,_15c,_15d){if(_15a===this.root){if(!_15c){this.onLeaveRoot(_159);}}this.inherited(arguments,[_159,_15a===this.root?null:_15a,_15b===this.root?null:_15b,_15c,_15d]);if(_15b===this.root){this.onAddToRoot(_159);}},onAddToRoot:function(item){},onLeaveRoot:function(item){},_requeryTop:function(){var _15e=this.root.children||[];this.store.fetch({query:this.query,onComplete:lang.hitch(this,function(_15f){this.root.children=_15f;if(_15e.length!=_15f.length||_14b.some(_15e,function(item,idx){return _15f[idx]!=item;})){this.onChildrenChange(this.root,_15f);}})});},onNewItem:function(item,_160){this._requeryTop();this.inherited(arguments);},onDeleteItem:function(item){if(_14b.indexOf(this.root.children,item)!=-1){this._requeryTop();}this.inherited(arguments);},onSetItem:function(item,_161,_162,_163){this._requeryTop();this.inherited(arguments);}});});},"dijit/PopupMenuBarItem":function(){define(["dojo/_base/declare","./PopupMenuItem","./MenuBarItem"],function(_164,_165,_166){var _167=_166._MenuBarItemMixin;return _164("dijit.PopupMenuBarItem",[_165,_167],{});});},"dijit/TitlePane":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/fx","dojo/has","dojo/_base/kernel","dojo/keys","./_CssStateMixin","./_TemplatedMixin","./layout/ContentPane","dojo/text!./templates/TitlePane.html","./_base/manager","./a11yclick"],function(_168,_169,dom,_16a,_16b,_16c,_16d,has,_16e,keys,_16f,_170,_171,_172,_173){var _174=_169("dijit.TitlePane",[_171,_170,_16f],{title:"",_setTitleAttr:{node:"titleNode",type:"innerHTML"},open:true,toggleable:true,tabIndex:"0",duration:_173.defaultDuration,baseClass:"dijitTitlePane",templateString:_172,doLayout:false,_setTooltipAttr:{node:"focusNode",type:"attribute",attribute:"title"},buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.titleNode,false);},postCreate:function(){this.inherited(arguments);if(this.toggleable){this._trackMouseState(this.titleBarNode,this.baseClass+"Title");}var _175=this.hideNode,_176=this.wipeNode;this._wipeIn=_16d.wipeIn({node:_176,duration:this.duration,beforeBegin:function(){_175.style.display="";}});this._wipeOut=_16d.wipeOut({node:_176,duration:this.duration,onEnd:function(){_175.style.display="none";}});},_setOpenAttr:function(open,_177){_168.forEach([this._wipeIn,this._wipeOut],function(_178){if(_178&&_178.status()=="playing"){_178.stop();}});if(_177){var anim=this[open?"_wipeIn":"_wipeOut"];anim.play();}else{this.hideNode.style.display=this.wipeNode.style.display=open?"":"none";}if(this._started){if(open){this._onShow();}else{this.onHide();}}this.containerNode.setAttribute("aria-hidden",open?"false":"true");this.focusNode.setAttribute("aria-pressed",open?"true":"false");this._set("open",open);this._setCss();},_setToggleableAttr:function(_179){this.focusNode.setAttribute("role",_179?"button":"heading");if(_179){this.focusNode.setAttribute("aria-controls",this.id+"_pane");this.focusNode.setAttribute("tabIndex",this.tabIndex);this.focusNode.setAttribute("aria-pressed",this.open);}else{_16a.remove(this.focusNode,"aria-controls");_16a.remove(this.focusNode,"tabIndex");_16a.remove(this.focusNode,"aria-pressed");}this._set("toggleable",_179);this._setCss();},_setContentAttr:function(_17a){if(!this.open||!this._wipeOut||this._wipeOut.status()=="playing"){this.inherited(arguments);}else{if(this._wipeIn&&this._wipeIn.status()=="playing"){this._wipeIn.stop();}_16c.setMarginBox(this.wipeNode,{h:_16c.getMarginBox(this.wipeNode).h});this.inherited(arguments);if(this._wipeIn){this._wipeIn.play();}else{this.hideNode.style.display="";}}},toggle:function(){this._setOpenAttr(!this.open,true);},_setCss:function(){var node=this.titleBarNode||this.focusNode;var _17b=this._titleBarClass;this._titleBarClass=this.baseClass+"Title"+(this.toggleable?"":"Fixed")+(this.open?"Open":"Closed");_16b.replace(node,this._titleBarClass,_17b||"");_16b.replace(node,this._titleBarClass.replace("TitlePaneTitle",""),(_17b||"").replace("TitlePaneTitle",""));this.arrowNodeInner.innerHTML=this.open?"-":"+";},_onTitleKey:function(e){if(e.keyCode==keys.DOWN_ARROW&&this.open){this.containerNode.focus();e.preventDefault();}},_onTitleClick:function(){if(this.toggleable){this.toggle();}},setTitle:function(_17c){_16e.deprecated("dijit.TitlePane.setTitle() is deprecated.  Use set('title', ...) instead.","","2.0");this.set("title",_17c);}});if(has("dojo-bidi")){_174.extend({_setTitleAttr:function(_17d){this._set("title",_17d);this.titleNode.innerHTML=_17d;this.applyTextDir(this.titleNode);},_setTooltipAttr:function(_17e){this._set("tooltip",_17e);if(this.textDir){_17e=this.enforceTextDirWithUcc(null,_17e);}_16a.set(this.focusNode,"title",_17e);},_setTextDirAttr:function(_17f){if(this._created&&this.textDir!=_17f){this._set("textDir",_17f);this.set("title",this.title);this.set("tooltip",this.tooltip);}}});}return _174;});},"dijit/form/_ComboBoxMenuMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/i18n","dojo/i18n!./nls/ComboBox"],function(_180,_181,_182,has,i18n){var _183=_181("dijit.form._ComboBoxMenuMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{_messages:null,postMixInProperties:function(){this.inherited(arguments);this._messages=i18n.getLocalization("dijit.form","ComboBox",this.lang);},buildRendering:function(){this.inherited(arguments);this.previousButton.innerHTML=this._messages["previousMessage"];this.nextButton.innerHTML=this._messages["nextMessage"];},_setValueAttr:function(_184){this._set("value",_184);this.onChange(_184);},onClick:function(node){if(node==this.previousButton){this._setSelectedAttr(null);this.onPage(-1);}else{if(node==this.nextButton){this._setSelectedAttr(null);this.onPage(1);}else{this.onChange(node);}}},onChange:function(){},onPage:function(){},onClose:function(){this._setSelectedAttr(null);},_createOption:function(item,_185){var _186=this._createMenuItem();var _187=_185(item);if(_187.html){_186.innerHTML=_187.label;}else{_186.appendChild(_186.ownerDocument.createTextNode(_187.label));}if(_186.innerHTML==""){_186.innerHTML="&#160;";}return _186;},createOptions:function(_188,_189,_18a){this.items=_188;this.previousButton.style.display=(_189.start==0)?"none":"";_182.set(this.previousButton,"id",this.id+"_prev");_180.forEach(_188,function(item,i){var _18b=this._createOption(item,_18a);_18b.setAttribute("item",i);_182.set(_18b,"id",this.id+i);this.nextButton.parentNode.insertBefore(_18b,this.nextButton);},this);var _18c=false;if(_188.total&&!_188.total.then&&_188.total!=-1){if((_189.start+_189.count)<_188.total){_18c=true;}else{if((_189.start+_189.count)>_188.total&&_189.count==_188.length){_18c=true;}}}else{if(_189.count==_188.length){_18c=true;}}this.nextButton.style.display=_18c?"":"none";_182.set(this.nextButton,"id",this.id+"_next");},clearResultList:function(){var _18d=this.containerNode;while(_18d.childNodes.length>2){_18d.removeChild(_18d.childNodes[_18d.childNodes.length-2]);}this._setSelectedAttr(null);},highlightFirstOption:function(){this.selectFirstNode();},highlightLastOption:function(){this.selectLastNode();},selectFirstNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.previousButton){this.selectNextNode();}},selectLastNode:function(){this.inherited(arguments);if(this.getHighlightedOption()==this.nextButton){this.selectPreviousNode();}},getHighlightedOption:function(){return this.selected;}});if(has("dojo-bidi")){_183=_181("dijit.form._ComboBoxMenuMixin",_183,{_createOption:function(){var _18e=this.inherited(arguments);this.applyTextDir(_18e);return _18e;}});}return _183;});},"dijit/form/_SearchMixin":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","dojo/query","dojo/string","dojo/when","../registry"],function(_18f,keys,lang,_190,_191,when,_192){return _18f("dijit.form._SearchMixin",null,{pageSize:Infinity,store:null,fetchProperties:{},query:{},searchDelay:200,searchAttr:"name",queryExpr:"${0}*",ignoreCase:true,_patternToRegExp:function(_193){return new RegExp("^"+_193.replace(/(\\.)|(\*)|(\?)|\W/g,function(str,_194,star,_195){return star?".*":_195?".":_194?_194:"\\"+str;})+"$",this.ignoreCase?"mi":"m");},_abortQuery:function(){if(this.searchTimer){this.searchTimer=this.searchTimer.remove();}if(this._queryDeferHandle){this._queryDeferHandle=this._queryDeferHandle.remove();}if(this._fetchHandle){if(this._fetchHandle.abort){this._cancelingQuery=true;this._fetchHandle.abort();this._cancelingQuery=false;}if(this._fetchHandle.cancel){this._cancelingQuery=true;this._fetchHandle.cancel();this._cancelingQuery=false;}this._fetchHandle=null;}},_processInput:function(evt){if(this.disabled||this.readOnly){return;}var key=evt.charOrCode;if("type" in evt&&evt.type.substring(0,3)=="key"&&(evt.altKey||((evt.ctrlKey||evt.metaKey)&&(key!="x"&&key!="v"))||key==keys.SHIFT)){return;}var _196=false;this._prev_key_backspace=false;switch(key){case keys.DELETE:case keys.BACKSPACE:this._prev_key_backspace=true;this._maskValidSubsetError=true;_196=true;break;default:_196=typeof key=="string"||key==229;}if(_196){if(!this.store){this.onSearch();}else{this.searchTimer=this.defer("_startSearchFromInput",1);}}},onSearch:function(){},_startSearchFromInput:function(){this._startSearch(this.focusNode.value.replace(/([\\\*\?])/g,"\\$1"));},_startSearch:function(text){this._abortQuery();var _197=this,_190=lang.clone(this.query),_198={start:0,count:this.pageSize,queryOptions:{ignoreCase:this.ignoreCase,deep:true}},qs=_191.substitute(this.queryExpr,[text]),q,_199=function(){var _19a=_197._fetchHandle=_197.store.query(_190,_198);if(_197.disabled||_197.readOnly||(q!==_197._lastQuery)){return;}when(_19a,function(res){_197._fetchHandle=null;if(!_197.disabled&&!_197.readOnly&&(q===_197._lastQuery)){when(_19a.total,function(_19b){res.total=_19b;var _19c=_197.pageSize;if(isNaN(_19c)||_19c>res.total){_19c=res.total;}res.nextPage=function(_19d){_198.direction=_19d=_19d!==false;_198.count=_19c;if(_19d){_198.start+=res.length;if(_198.start>=res.total){_198.count=0;}}else{_198.start-=_19c;if(_198.start<0){_198.count=Math.max(_19c+_198.start,0);_198.start=0;}}if(_198.count<=0){res.length=0;_197.onSearch(res,_190,_198);}else{_199();}};_197.onSearch(res,_190,_198);});}},function(err){_197._fetchHandle=null;if(!_197._cancelingQuery){console.error(_197.declaredClass+" "+err.toString());}});};lang.mixin(_198,this.fetchProperties);if(this.store._oldAPI){q=qs;}else{q=this._patternToRegExp(qs);q.toString=function(){return qs;};}this._lastQuery=_190[this.searchAttr]=q;this._queryDeferHandle=this.defer(_199,this.searchDelay);},constructor:function(){this.query={};this.fetchProperties={};},postMixInProperties:function(){if(!this.store){var list=this.list;if(list){this.store=_192.byId(list);}}this.inherited(arguments);}});});},"dijit/form/ToggleButton":function(){define(["dojo/_base/declare","dojo/_base/kernel","./Button","./_ToggleButtonMixin"],function(_19e,_19f,_1a0,_1a1){return _19e("dijit.form.ToggleButton",[_1a0,_1a1],{baseClass:"dijitToggleButton",setChecked:function(_1a2){_19f.deprecated("setChecked("+_1a2+") is deprecated. Use set('checked',"+_1a2+") instead.","","2.0");this.set("checked",_1a2);}});});},"dijit/form/NumberSpinner":function(){define(["dojo/_base/declare","dojo/keys","./_Spinner","./NumberTextBox"],function(_1a3,keys,_1a4,_1a5){return _1a3("dijit.form.NumberSpinner",[_1a4,_1a5.Mixin],{baseClass:"dijitTextBox dijitSpinner dijitNumberTextBox",adjust:function(val,_1a6){var tc=this.constraints,v=isNaN(val),_1a7=!isNaN(tc.max),_1a8=!isNaN(tc.min);if(v&&_1a6!=0){val=(_1a6>0)?_1a8?tc.min:_1a7?tc.max:0:_1a7?this.constraints.max:_1a8?tc.min:0;}var _1a9=val+_1a6;if(v||isNaN(_1a9)){return val;}if(_1a7&&(_1a9>tc.max)){_1a9=tc.max;}if(_1a8&&(_1a9<tc.min)){_1a9=tc.min;}return _1a9;},_onKeyDown:function(e){if(this.disabled||this.readOnly){return;}if((e.keyCode==keys.HOME||e.keyCode==keys.END)&&!(e.ctrlKey||e.altKey||e.metaKey)&&typeof this.get("value")!="undefined"){var _1aa=this.constraints[(e.keyCode==keys.HOME?"min":"max")];if(typeof _1aa=="number"){this._setValueAttr(_1aa,false);}e.stopPropagation();e.preventDefault();}}});});},"dijit/form/Textarea":function(){define(["dojo/_base/declare","dojo/dom-style","./_ExpandingTextAreaMixin","./SimpleTextarea"],function(_1ab,_1ac,_1ad,_1ae){return _1ab("dijit.form.Textarea",[_1ae,_1ad],{baseClass:"dijitTextBox dijitTextArea dijitExpandingTextArea",cols:"",buildRendering:function(){this.inherited(arguments);_1ac.set(this.textbox,{overflowY:"hidden",overflowX:"auto",boxSizing:"border-box",MsBoxSizing:"border-box",WebkitBoxSizing:"border-box",MozBoxSizing:"border-box"});}});});},"dijit/form/DateTextBox":function(){define(["dojo/_base/declare","../Calendar","./_DateTimeTextBox"],function(_1af,_1b0,_1b1){return _1af("dijit.form.DateTextBox",_1b1,{baseClass:"dijitTextBox dijitComboBox dijitDateTextBox",popupClass:_1b0,_selector:"date",maxHeight:Infinity,value:new Date("")});});},"dijit/layout/AccordionContainer":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/topic","../focus","../_base/manager","dojo/ready","../_Widget","../_Container","../_TemplatedMixin","../_CssStateMixin","./StackContainer","./ContentPane","dojo/text!./templates/AccordionButton.html","../a11yclick"],function(_1b2,_1b3,_1b4,fx,dom,_1b5,_1b6,_1b7,_1b8,keys,lang,has,_1b9,_1ba,_1bb,_1bc,_1bd,_1be,_1bf,_1c0,_1c1,_1c2,_1c3){var _1c4=_1b4("dijit.layout._AccordionButton",[_1bd,_1bf,_1c0],{templateString:_1c3,label:"",_setLabelAttr:{node:"titleTextNode",type:"innerHTML"},title:"",_setTitleAttr:{node:"titleTextNode",type:"attribute",attribute:"title"},iconClassAttr:"",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitAccordionTitle",getParent:function(){return this.parent;},buildRendering:function(){this.inherited(arguments);var _1c5=this.id.replace(" ","_");_1b5.set(this.titleTextNode,"id",_1c5+"_title");this.focusNode.setAttribute("aria-labelledby",_1b5.get(this.titleTextNode,"id"));dom.setSelectable(this.domNode,false);},getTitleHeight:function(){return _1b8.getMarginSize(this.domNode).h;},_onTitleClick:function(){var _1c6=this.getParent();_1c6.selectChild(this.contentWidget,true);_1ba.focus(this.focusNode);},_onTitleKeyDown:function(evt){return this.getParent()._onKeyDown(evt,this.contentWidget);},_setSelectedAttr:function(_1c7){this._set("selected",_1c7);this.focusNode.setAttribute("aria-expanded",_1c7?"true":"false");this.focusNode.setAttribute("aria-selected",_1c7?"true":"false");this.focusNode.setAttribute("tabIndex",_1c7?"0":"-1");}});if(has("dojo-bidi")){_1c4.extend({_setLabelAttr:function(_1c8){this._set("label",_1c8);_1b5.set(this.titleTextNode,"innerHTML",_1c8);this.applyTextDir(this.titleTextNode);},_setTitleAttr:function(_1c9){this._set("title",_1c9);_1b5.set(this.titleTextNode,"title",_1c9);this.applyTextDir(this.titleTextNode);}});}var _1ca=_1b4("dijit.layout._AccordionInnerContainer"+(has("dojo-bidi")?"_NoBidi":""),[_1bd,_1c0],{baseClass:"dijitAccordionInnerContainer",isLayoutContainer:true,buildRendering:function(){this.domNode=_1b7.place("<div class='"+this.baseClass+"' role='presentation'>",this.contentWidget.domNode,"after");var _1cb=this.contentWidget,cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;this.button=_1cb._buttonWidget=(new cls({contentWidget:_1cb,label:_1cb.title,title:_1cb.tooltip,dir:_1cb.dir,lang:_1cb.lang,textDir:_1cb.textDir||this.textDir,iconClass:_1cb.iconClass,id:_1cb.id+"_button",parent:this.parent})).placeAt(this.domNode);this.containerNode=_1b7.place("<div class='dijitAccordionChildWrapper' role='tabpanel' style='display:none'>",this.domNode);this.containerNode.setAttribute("aria-labelledby",this.button.id);_1b7.place(this.contentWidget.domNode,this.containerNode);},postCreate:function(){this.inherited(arguments);var _1cc=this.button,cw=this.contentWidget;this._contentWidgetWatches=[cw.watch("title",lang.hitch(this,function(name,_1cd,_1ce){_1cc.set("label",_1ce);})),cw.watch("tooltip",lang.hitch(this,function(name,_1cf,_1d0){_1cc.set("title",_1d0);})),cw.watch("iconClass",lang.hitch(this,function(name,_1d1,_1d2){_1cc.set("iconClass",_1d2);}))];},_setSelectedAttr:function(_1d3){this._set("selected",_1d3);this.button.set("selected",_1d3);if(_1d3){var cw=this.contentWidget;if(cw.onSelected){cw.onSelected();}}},startup:function(){this.contentWidget.startup();},destroy:function(){this.button.destroyRecursive();_1b3.forEach(this._contentWidgetWatches||[],function(w){w.unwatch();});delete this.contentWidget._buttonWidget;delete this.contentWidget._wrapperWidget;this.inherited(arguments);},destroyDescendants:function(_1d4){this.contentWidget.destroyRecursive(_1d4);}});if(has("dojo-bidi")){_1ca=_1b4("dijit.layout._AccordionInnerContainer",_1ca,{postCreate:function(){this.inherited(arguments);var _1d5=this.button;this._contentWidgetWatches.push(this.contentWidget.watch("textDir",function(name,_1d6,_1d7){_1d5.set("textDir",_1d7);}));}});}var _1d8=_1b4("dijit.layout.AccordionContainer",_1c1,{duration:_1bb.defaultDuration,buttonWidget:_1c4,baseClass:"dijitAccordionContainer",buildRendering:function(){this.inherited(arguments);this.domNode.style.overflow="hidden";this.domNode.setAttribute("role","tablist");},startup:function(){if(this._started){return;}this.inherited(arguments);if(this.selectedChildWidget){this.selectedChildWidget._wrapperWidget.set("selected",true);}},layout:function(){var _1d9=this.selectedChildWidget;if(!_1d9){return;}var _1da=_1d9._wrapperWidget.domNode,_1db=_1b8.getMarginExtents(_1da),_1dc=_1b8.getPadBorderExtents(_1da),_1dd=_1d9._wrapperWidget.containerNode,_1de=_1b8.getMarginExtents(_1dd),_1df=_1b8.getPadBorderExtents(_1dd),_1e0=this._contentBox;var _1e1=0;_1b3.forEach(this.getChildren(),function(_1e2){if(_1e2!=_1d9){_1e1+=_1b8.getMarginSize(_1e2._wrapperWidget.domNode).h;}});this._verticalSpace=_1e0.h-_1e1-_1db.h-_1dc.h-_1de.h-_1df.h-_1d9._buttonWidget.getTitleHeight();this._containerContentBox={h:this._verticalSpace,w:this._contentBox.w-_1db.w-_1dc.w-_1de.w-_1df.w};if(_1d9){_1d9.resize(this._containerContentBox);}},_setupChild:function(_1e3){_1e3._wrapperWidget=_1ca({contentWidget:_1e3,buttonWidget:this.buttonWidget,id:_1e3.id+"_wrapper",dir:_1e3.dir,lang:_1e3.lang,textDir:_1e3.textDir||this.textDir,parent:this});this.inherited(arguments);_1b7.place(_1e3.domNode,_1e3._wrapper,"replace");},removeChild:function(_1e4){if(_1e4._wrapperWidget){_1b7.place(_1e4.domNode,_1e4._wrapperWidget.domNode,"after");_1e4._wrapperWidget.destroy();delete _1e4._wrapperWidget;}_1b6.remove(_1e4.domNode,"dijitHidden");this.inherited(arguments);},getChildren:function(){return _1b3.map(this.inherited(arguments),function(_1e5){return _1e5.declaredClass=="dijit.layout._AccordionInnerContainer"?_1e5.contentWidget:_1e5;},this);},destroy:function(){if(this._animation){this._animation.stop();}_1b3.forEach(this.getChildren(),function(_1e6){if(_1e6._wrapperWidget){_1e6._wrapperWidget.destroy();}else{_1e6.destroyRecursive();}});this.inherited(arguments);},_showChild:function(_1e7){_1e7._wrapperWidget.containerNode.style.display="block";return this.inherited(arguments);},_hideChild:function(_1e8){_1e8._wrapperWidget.containerNode.style.display="none";this.inherited(arguments);},_transition:function(_1e9,_1ea,_1eb){if(has("ie")<8){_1eb=false;}if(this._animation){this._animation.stop(true);delete this._animation;}var self=this;if(_1e9){_1e9._wrapperWidget.set("selected",true);var d=this._showChild(_1e9);if(this.doLayout&&_1e9.resize){_1e9.resize(this._containerContentBox);}}if(_1ea){_1ea._wrapperWidget.set("selected",false);if(!_1eb){this._hideChild(_1ea);}}if(_1eb){var _1ec=_1e9._wrapperWidget.containerNode,_1ed=_1ea._wrapperWidget.containerNode;var _1ee=_1e9._wrapperWidget.containerNode,_1ef=_1b8.getMarginExtents(_1ee),_1f0=_1b8.getPadBorderExtents(_1ee),_1f1=_1ef.h+_1f0.h;_1ed.style.height=(self._verticalSpace-_1f1)+"px";this._animation=new fx.Animation({node:_1ec,duration:this.duration,curve:[1,this._verticalSpace-_1f1-1],onAnimate:function(_1f2){_1f2=Math.floor(_1f2);_1ec.style.height=_1f2+"px";_1ed.style.height=(self._verticalSpace-_1f1-_1f2)+"px";},onEnd:function(){delete self._animation;_1ec.style.height="auto";_1ea._wrapperWidget.containerNode.style.display="none";_1ed.style.height="auto";self._hideChild(_1ea);}});this._animation.onStop=this._animation.onEnd;this._animation.play();}return d;},_onKeyDown:function(e,_1f3){if(this.disabled||e.altKey||!(_1f3||e.ctrlKey)){return;}var c=e.keyCode;if((_1f3&&(c==keys.LEFT_ARROW||c==keys.UP_ARROW))||(e.ctrlKey&&c==keys.PAGE_UP)){this._adjacent(false)._buttonWidget._onTitleClick();e.stopPropagation();e.preventDefault();}else{if((_1f3&&(c==keys.RIGHT_ARROW||c==keys.DOWN_ARROW))||(e.ctrlKey&&(c==keys.PAGE_DOWN||c==keys.TAB))){this._adjacent(true)._buttonWidget._onTitleClick();e.stopPropagation();e.preventDefault();}}}});if(has("dijit-legacy-requires")){_1bc(0,function(){var _1f4=["dijit/layout/AccordionPane"];_1b2(_1f4);});}_1d8._InnerContainer=_1ca;_1d8._Button=_1c4;return _1d8;});},"dijit/form/ComboButton":function(){define(["dojo/_base/declare","dojo/keys","../focus","./DropDownButton","dojo/text!./templates/ComboButton.html"],function(_1f5,keys,_1f6,_1f7,_1f8){return _1f5("dijit.form.ComboButton",_1f7,{templateString:_1f8,_setIdAttr:"",_setTabIndexAttr:["focusNode","titleNode"],_setTitleAttr:"titleNode",optionsTitle:"",baseClass:"dijitComboButton",cssStateNodes:{"buttonNode":"dijitButtonNode","titleNode":"dijitButtonContents","_popupStateNode":"dijitDownArrowButton"},_focusedNode:null,_onButtonKeyDown:function(evt){if(evt.keyCode==keys[this.isLeftToRight()?"RIGHT_ARROW":"LEFT_ARROW"]){_1f6.focus(this._popupStateNode);evt.stopPropagation();evt.preventDefault();}},_onArrowKeyDown:function(evt){if(evt.keyCode==keys[this.isLeftToRight()?"LEFT_ARROW":"RIGHT_ARROW"]){_1f6.focus(this.titleNode);evt.stopPropagation();evt.preventDefault();}},focus:function(_1f9){if(!this.disabled){_1f6.focus(_1f9=="start"?this.titleNode:this._popupStateNode);}}});});},"dijit/layout/SplitContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","../registry","../_WidgetBase","./_LayoutWidget"],function(_1fa,_1fb,_1fc,dom,_1fd,_1fe,_1ff,_200,_201,_202,lang,on,has,_203,_204,_205){var _206=_1fc("dijit.layout.SplitContainer",_205,{constructor:function(){_202.deprecated("dijit.layout.SplitContainer is deprecated","use BorderContainer with splitter instead",2);},activeSizing:false,sizerWidth:7,orientation:"horizontal",persist:true,baseClass:"dijitSplitContainer",postMixInProperties:function(){this.inherited("postMixInProperties",arguments);this.isHorizontal=(this.orientation=="horizontal");},postCreate:function(){this.inherited(arguments);this.sizers=[];if(has("mozilla")){this.domNode.style.overflow="-moz-scrollbars-none";}if(typeof this.sizerWidth=="object"){try{this.sizerWidth=parseInt(this.sizerWidth.toString());}catch(e){this.sizerWidth=7;}}var _207=this.ownerDocument.createElement("div");this.virtualSizer=_207;_207.style.position="relative";_207.style.zIndex=10;_207.className=this.isHorizontal?"dijitSplitContainerVirtualSizerH":"dijitSplitContainerVirtualSizerV";this.domNode.appendChild(_207);dom.setSelectable(_207,false);},destroy:function(){delete this.virtualSizer;if(this._ownconnects){var h;while(h=this._ownconnects.pop()){h.remove();}}this.inherited(arguments);},startup:function(){if(this._started){return;}_1fa.forEach(this.getChildren(),function(_208,i,_209){this._setupChild(_208);if(i<_209.length-1){this._addSizer();}},this);if(this.persist){this._restoreState();}this.inherited(arguments);},_setupChild:function(_20a){this.inherited(arguments);_20a.domNode.style.position="absolute";_1fd.add(_20a.domNode,"dijitSplitPane");},_onSizerMouseDown:function(e){if(e.target.id){for(var i=0;i<this.sizers.length;i++){if(this.sizers[i].id==e.target.id){break;}}if(i<this.sizers.length){this.beginSizing(e,i);}}},_addSizer:function(_20b){_20b=_20b===undefined?this.sizers.length:_20b;var _20c=this.ownerDocument.createElement("div");_20c.id=_203.getUniqueId("dijit_layout_SplitterContainer_Splitter");this.sizers.splice(_20b,0,_20c);this.domNode.appendChild(_20c);_20c.className=this.isHorizontal?"dijitSplitContainerSizerH":"dijitSplitContainerSizerV";var _20d=this.ownerDocument.createElement("div");_20d.className="thumb";_20c.appendChild(_20d);this.connect(_20c,"onmousedown","_onSizerMouseDown");dom.setSelectable(_20c,false);},removeChild:function(_20e){if(this.sizers.length){var i=_1fa.indexOf(this.getChildren(),_20e);if(i!=-1){if(i==this.sizers.length){i--;}_1fe.destroy(this.sizers[i]);this.sizers.splice(i,1);}}this.inherited(arguments);if(this._started){this.layout();}},addChild:function(_20f,_210){if(typeof _210=="undefined"||_210=="last"){_210=this.getChildren().length;}this.inherited(arguments,[_20f,_210]);if(this._started){var _211=this.getChildren();if(_211.length>1){this._addSizer(_210);}this.layout();}},layout:function(){this.paneWidth=this._contentBox.w;this.paneHeight=this._contentBox.h;var _212=this.getChildren();if(!_212.length){return;}var _213=this.isHorizontal?this.paneWidth:this.paneHeight;if(_212.length>1){_213-=this.sizerWidth*(_212.length-1);}var _214=0;_1fa.forEach(_212,function(_215){_214+=_215.sizeShare;});var _216=_213/_214;var _217=0;_1fa.forEach(_212.slice(0,_212.length-1),function(_218){var size=Math.round(_216*_218.sizeShare);_218.sizeActual=size;_217+=size;});_212[_212.length-1].sizeActual=_213-_217;this._checkSizes();var pos=0;var size=_212[0].sizeActual;this._movePanel(_212[0],pos,size);_212[0].position=pos;pos+=size;if(!this.sizers){return;}_1fa.some(_212.slice(1),function(_219,i){if(!this.sizers[i]){return true;}this._moveSlider(this.sizers[i],pos,this.sizerWidth);this.sizers[i].position=pos;pos+=this.sizerWidth;size=_219.sizeActual;this._movePanel(_219,pos,size);_219.position=pos;pos+=size;},this);},_movePanel:function(_21a,pos,size){var box;if(this.isHorizontal){_21a.domNode.style.left=pos+"px";_21a.domNode.style.top=0;box={w:size,h:this.paneHeight};if(_21a.resize){_21a.resize(box);}else{_1ff.setMarginBox(_21a.domNode,box);}}else{_21a.domNode.style.left=0;_21a.domNode.style.top=pos+"px";box={w:this.paneWidth,h:size};if(_21a.resize){_21a.resize(box);}else{_1ff.setMarginBox(_21a.domNode,box);}}},_moveSlider:function(_21b,pos,size){if(this.isHorizontal){_21b.style.left=pos+"px";_21b.style.top=0;_1ff.setMarginBox(_21b,{w:size,h:this.paneHeight});}else{_21b.style.left=0;_21b.style.top=pos+"px";_1ff.setMarginBox(_21b,{w:this.paneWidth,h:size});}},_growPane:function(_21c,pane){if(_21c>0){if(pane.sizeActual>pane.sizeMin){if((pane.sizeActual-pane.sizeMin)>_21c){pane.sizeActual=pane.sizeActual-_21c;_21c=0;}else{_21c-=pane.sizeActual-pane.sizeMin;pane.sizeActual=pane.sizeMin;}}}return _21c;},_checkSizes:function(){var _21d=0;var _21e=0;var _21f=this.getChildren();_1fa.forEach(_21f,function(_220){_21e+=_220.sizeActual;_21d+=_220.sizeMin;});if(_21d<=_21e){var _221=0;_1fa.forEach(_21f,function(_222){if(_222.sizeActual<_222.sizeMin){_221+=_222.sizeMin-_222.sizeActual;_222.sizeActual=_222.sizeMin;}});if(_221>0){var list=this.isDraggingLeft?_21f.reverse():_21f;_1fa.forEach(list,function(_223){_221=this._growPane(_221,_223);},this);}}else{_1fa.forEach(_21f,function(_224){_224.sizeActual=Math.round(_21e*(_224.sizeMin/_21d));});}},beginSizing:function(e,i){var _225=this.getChildren();this.paneBefore=_225[i];this.paneAfter=_225[i+1];this.paneBefore.sizeBeforeDrag=this.paneBefore.sizeActual;this.paneAfter.sizeBeforeDrag=this.paneAfter.sizeActual;this.paneAfter.positionBeforeDrag=this.paneAfter.position;this.isSizing=true;this.sizingSplitter=this.sizers[i];this.sizingSplitter.positionBeforeDrag=_200.get(this.sizingSplitter,(this.isHorizontal?"left":"top"));if(!this.cover){this.cover=_1fe.create("div",{style:{position:"absolute",zIndex:5,top:0,left:0,width:"100%",height:"100%"}},this.domNode);}else{this.cover.style.zIndex=5;}this.sizingSplitter.style.zIndex=6;this.startPoint=this.lastPoint=(this.isHorizontal?e.pageX:e.pageY);this.maxDelta=this.paneAfter.sizeActual-this.paneAfter.sizeMin;this.minDelta=-1*(this.paneBefore.sizeActual-this.paneBefore.sizeMin);if(!this.activeSizing){this._showSizingLine();}this._ownconnects=[on(this.ownerDocument.documentElement,"mousemove",lang.hitch(this,"changeSizing")),on(this.ownerDocument.documentElement,"mouseup",lang.hitch(this,"endSizing"))];_201.stop(e);},changeSizing:function(e){if(!this.isSizing){return;}this.lastPoint=this.isHorizontal?e.pageX:e.pageY;var _226=Math.max(Math.min(this.lastPoint-this.startPoint,this.maxDelta),this.minDelta);if(this.activeSizing){this._updateSize(_226);}else{this._moveSizingLine(_226);}_201.stop(e);},endSizing:function(){if(!this.isSizing){return;}if(this.cover){this.cover.style.zIndex=-1;}if(!this.activeSizing){this._hideSizingLine();}var _227=Math.max(Math.min(this.lastPoint-this.startPoint,this.maxDelta),this.minDelta);this._updateSize(_227);this.isSizing=false;if(this.persist){this._saveState(this);}var h;while(h=this._ownconnects.pop()){h.remove();}},_updateSize:function(_228){this.paneBefore.sizeActual=this.paneBefore.sizeBeforeDrag+_228;this.paneAfter.position=this.paneAfter.positionBeforeDrag+_228;this.paneAfter.sizeActual=this.paneAfter.sizeBeforeDrag-_228;_1fa.forEach(this.getChildren(),function(_229){_229.sizeShare=_229.sizeActual;});if(this._started){this.layout();}},_showSizingLine:function(){this._moveSizingLine(0);_1ff.setMarginBox(this.virtualSizer,this.isHorizontal?{w:this.sizerWidth,h:this.paneHeight}:{w:this.paneWidth,h:this.sizerWidth});this.virtualSizer.style.display="block";},_hideSizingLine:function(){this.virtualSizer.style.display="none";},_moveSizingLine:function(_22a){var pos=_22a+this.sizingSplitter.positionBeforeDrag;_200.set(this.virtualSizer,(this.isHorizontal?"left":"top"),pos+"px");},_getCookieName:function(i){return this.id+"_"+i;},_restoreState:function(){_1fa.forEach(this.getChildren(),function(_22b,i){var _22c=this._getCookieName(i);var _22d=_1fb(_22c);if(_22d){var pos=parseInt(_22d);if(typeof pos=="number"){_22b.sizeShare=pos;}}},this);},_saveState:function(){if(!this.persist){return;}_1fa.forEach(this.getChildren(),function(_22e,i){_1fb(this._getCookieName(i),_22e.sizeShare,{expires:365});},this);}});_206.ChildWidgetProperties={sizeMin:10,sizeShare:10};lang.extend(_204,_206.ChildWidgetProperties);return _206;});},"dijit/form/_AutoCompleterMixin":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/query","dojo/regexp","dojo/sniff","./DataList","./_TextBoxMixin","./_SearchMixin"],function(_22f,_230,_231,keys,lang,_232,_233,has,_234,_235,_236){var _237=_230("dijit.form._AutoCompleterMixin",_236,{item:null,autoComplete:true,highlightMatch:"first",labelAttr:"",labelType:"text",maxHeight:-1,_stopClickEvents:false,_getCaretPos:function(_238){var pos=0;if(typeof (_238.selectionStart)=="number"){pos=_238.selectionStart;}else{if(has("ie")){var tr=_238.ownerDocument.selection.createRange().duplicate();var ntr=_238.createTextRange();tr.move("character",0);ntr.move("character",0);try{ntr.setEndPoint("EndToEnd",tr);pos=String(ntr.text).replace(/\r/g,"").length;}catch(e){}}}return pos;},_setCaretPos:function(_239,_23a){_23a=parseInt(_23a);_235.selectInputText(_239,_23a,_23a);},_setDisabledAttr:function(_23b){this.inherited(arguments);this.domNode.setAttribute("aria-disabled",_23b?"true":"false");},_onKey:function(evt){if(evt.charCode>=32){return;}var key=evt.charCode||evt.keyCode;if(key==keys.ALT||key==keys.CTRL||key==keys.META||key==keys.SHIFT){return;}var pw=this.dropDown;var _23c=null;this._abortQuery();this.inherited(arguments);if(evt.altKey||evt.ctrlKey||evt.metaKey){return;}if(this._opened){_23c=pw.getHighlightedOption();}switch(key){case keys.PAGE_DOWN:case keys.DOWN_ARROW:case keys.PAGE_UP:case keys.UP_ARROW:if(this._opened){this._announceOption(_23c);}evt.stopPropagation();evt.preventDefault();break;case keys.ENTER:if(_23c){if(_23c==pw.nextButton){this._nextSearch(1);evt.stopPropagation();evt.preventDefault();break;}else{if(_23c==pw.previousButton){this._nextSearch(-1);evt.stopPropagation();evt.preventDefault();break;}}evt.stopPropagation();evt.preventDefault();}else{this._setBlurValue();this._setCaretPos(this.focusNode,this.focusNode.value.length);}case keys.TAB:var _23d=this.get("displayedValue");if(pw&&(_23d==pw._messages["previousMessage"]||_23d==pw._messages["nextMessage"])){break;}if(_23c){this._selectOption(_23c);}case keys.ESCAPE:if(this._opened){this._lastQuery=null;this.closeDropDown();}break;}},_autoCompleteText:function(text){var fn=this.focusNode;_235.selectInputText(fn,fn.value.length);var _23e=this.ignoreCase?"toLowerCase":"substr";if(text[_23e](0).indexOf(this.focusNode.value[_23e](0))==0){var cpos=this.autoComplete?this._getCaretPos(fn):fn.value.length;if((cpos+1)>fn.value.length){fn.value=text;_235.selectInputText(fn,cpos);}}else{fn.value=text;_235.selectInputText(fn);}},_openResultList:function(_23f,_240,_241){var _242=this.dropDown.getHighlightedOption();this.dropDown.clearResultList();if(!_23f.length&&_241.start==0){this.closeDropDown();return;}this._nextSearch=this.dropDown.onPage=lang.hitch(this,function(_243){_23f.nextPage(_243!==-1);this.focus();});this.dropDown.createOptions(_23f,_241,lang.hitch(this,"_getMenuLabelFromItem"));this._showResultList();if("direction" in _241){if(_241.direction){this.dropDown.highlightFirstOption();}else{if(!_241.direction){this.dropDown.highlightLastOption();}}if(_242){this._announceOption(this.dropDown.getHighlightedOption());}}else{if(this.autoComplete&&!this._prev_key_backspace&&!/^[*]+$/.test(_240[this.searchAttr].toString())){this._announceOption(this.dropDown.containerNode.firstChild.nextSibling);}}},_showResultList:function(){this.closeDropDown(true);this.openDropDown();this.domNode.setAttribute("aria-expanded","true");},loadDropDown:function(){this._startSearchAll();},isLoaded:function(){return false;},closeDropDown:function(){this._abortQuery();if(this._opened){this.inherited(arguments);this.domNode.setAttribute("aria-expanded","false");}},_setBlurValue:function(){var _244=this.get("displayedValue");var pw=this.dropDown;if(pw&&(_244==pw._messages["previousMessage"]||_244==pw._messages["nextMessage"])){this._setValueAttr(this._lastValueReported,true);}else{if(typeof this.item=="undefined"){this.item=null;this.set("displayedValue",_244);}else{if(this.value!=this._lastValueReported){this._handleOnChange(this.value,true);}this._refreshState();}}this.focusNode.removeAttribute("aria-activedescendant");},_setItemAttr:function(item,_245,_246){var _247="";if(item){if(!_246){_246=this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr];}_247=this._getValueField()!=this.searchAttr?this.store.getIdentity(item):_246;}this.set("value",_247,_245,_246,item);},_announceOption:function(node){if(!node){return;}var _248;if(node==this.dropDown.nextButton||node==this.dropDown.previousButton){_248=node.innerHTML;this.item=undefined;this.value="";}else{var item=this.dropDown.items[node.getAttribute("item")];_248=(this.store._oldAPI?this.store.getValue(item,this.searchAttr):item[this.searchAttr]).toString();this.set("item",item,false,_248);}this.focusNode.value=this.focusNode.value.substring(0,this._lastInput.length);this.focusNode.setAttribute("aria-activedescendant",_231.get(node,"id"));this._autoCompleteText(_248);},_selectOption:function(_249){this.closeDropDown();if(_249){this._announceOption(_249);}this._setCaretPos(this.focusNode,this.focusNode.value.length);this._handleOnChange(this.value,true);this.focusNode.removeAttribute("aria-activedescendant");},_startSearchAll:function(){this._startSearch("");},_startSearchFromInput:function(){this.item=undefined;this.inherited(arguments);},_startSearch:function(key){if(!this.dropDown){var _24a=this.id+"_popup",_24b=lang.isString(this.dropDownClass)?lang.getObject(this.dropDownClass,false):this.dropDownClass;this.dropDown=new _24b({onChange:lang.hitch(this,this._selectOption),id:_24a,dir:this.dir,textDir:this.textDir});}this._lastInput=key;this.inherited(arguments);},_getValueField:function(){return this.searchAttr;},postMixInProperties:function(){this.inherited(arguments);if(!this.store){var _24c=this.srcNodeRef;this.store=new _234({},_24c);if(!("value" in this.params)){var item=(this.item=this.store.fetchSelectedItem());if(item){var _24d=this._getValueField();this.value=this.store._oldAPI?this.store.getValue(item,_24d):item[_24d];}}}},postCreate:function(){var _24e=_232("label[for=\""+this.id+"\"]");if(_24e.length){if(!_24e[0].id){_24e[0].id=this.id+"_label";}this.domNode.setAttribute("aria-labelledby",_24e[0].id);}this.inherited(arguments);_22f.after(this,"onSearch",lang.hitch(this,"_openResultList"),true);},_getMenuLabelFromItem:function(item){var _24f=this.labelFunc(item,this.store),_250=this.labelType;if(this.highlightMatch!="none"&&this.labelType=="text"&&this._lastInput){_24f=this.doHighlight(_24f,this._lastInput);_250="html";}return {html:_250=="html",label:_24f};},doHighlight:function(_251,find){var _252=(this.ignoreCase?"i":"")+(this.highlightMatch=="all"?"g":""),i=this.queryExpr.indexOf("${0}");find=_233.escapeString(find);return this._escapeHtml(_251.replace(new RegExp((i==0?"^":"")+"("+find+")"+(i==(this.queryExpr.length-4)?"$":""),_252),"\uffff$1\uffff")).replace(/\uFFFF([^\uFFFF]+)\uFFFF/g,"<span class=\"dijitComboBoxHighlightMatch\">$1</span>");},_escapeHtml:function(str){str=String(str).replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");return str;},reset:function(){this.item=null;this.inherited(arguments);},labelFunc:function(item,_253){return (_253._oldAPI?_253.getValue(item,this.labelAttr||this.searchAttr):item[this.labelAttr||this.searchAttr]).toString();},_setValueAttr:function(_254,_255,_256,item){this._set("item",item||null);if(_254==null){_254="";}this.inherited(arguments);}});if(has("dojo-bidi")){_237.extend({_setTextDirAttr:function(_257){this.inherited(arguments);if(this.dropDown){this.dropDown._set("textDir",_257);}}});}return _237;});},"dijit/form/MappedTextBox":function(){define(["dojo/_base/declare","dojo/sniff","dojo/dom-construct","./ValidationTextBox"],function(_258,has,_259,_25a){return _258("dijit.form.MappedTextBox",_25a,{postMixInProperties:function(){this.inherited(arguments);this.nameAttrSetting="";},_setNameAttr:"valueNode",serialize:function(val){return val.toString?val.toString():"";},toString:function(){var val=this.filter(this.get("value"));return val!=null?(typeof val=="string"?val:this.serialize(val,this.constraints)):"";},validate:function(){this.valueNode.value=this.toString();return this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);this.valueNode=_259.place("<input type='hidden'"+((this.name&&!has("msapp"))?" name=\""+this.name.replace(/"/g,"&quot;")+"\"":"")+"/>",this.textbox,"after");},reset:function(){this.valueNode.value="";this.inherited(arguments);}});});},"dijit/form/ComboBoxMixin":function(){define(["dojo/_base/declare","dojo/Deferred","dojo/_base/kernel","dojo/_base/lang","dojo/store/util/QueryResults","./_AutoCompleterMixin","./_ComboBoxMenu","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(_25b,_25c,_25d,lang,_25e,_25f,_260,_261,_262){return _25b("dijit.form.ComboBoxMixin",[_261,_25f],{dropDownClass:_260,hasDownArrow:true,templateString:_262,baseClass:"dijitTextBox dijitComboBox",cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},_setHasDownArrowAttr:function(val){this._set("hasDownArrow",val);this._buttonNode.style.display=val?"":"none";},_showResultList:function(){this.displayMessage("");this.inherited(arguments);},_setStoreAttr:function(_263){if(!_263.get){lang.mixin(_263,{_oldAPI:true,get:function(id){var _264=new _25c();this.fetchItemByIdentity({identity:id,onItem:function(_265){_264.resolve(_265);},onError:function(_266){_264.reject(_266);}});return _264.promise;},query:function(_267,_268){var _269=new _25c(function(){_26a.abort&&_26a.abort();});_269.total=new _25c();var _26a=this.fetch(lang.mixin({query:_267,onBegin:function(_26b){_269.total.resolve(_26b);},onComplete:function(_26c){_269.resolve(_26c);},onError:function(_26d){_269.reject(_26d);}},_268));return _25e(_269);}});}this._set("store",_263);},postMixInProperties:function(){var _26e=this.params.store||this.store;if(_26e){this._setStoreAttr(_26e);}this.inherited(arguments);if(!this.params.store&&!this.store._oldAPI){var _26f=this.declaredClass;lang.mixin(this.store,{getValue:function(item,attr){_25d.deprecated(_26f+".store.getValue(item, attr) is deprecated for builtin store.  Use item.attr directly","","2.0");return item[attr];},getLabel:function(item){_25d.deprecated(_26f+".store.getLabel(item) is deprecated for builtin store.  Use item.label directly","","2.0");return item.name;},fetch:function(args){_25d.deprecated(_26f+".store.fetch() is deprecated for builtin store.","Use store.query()","2.0");var shim=["dojo/data/ObjectStore"];require(shim,lang.hitch(this,function(_270){new _270({objectStore:this}).fetch(args);}));}});}}});});},"dijit/form/_TextBoxMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","../main"],function(_271,_272,dom,has,keys,lang,on,_273){var _274=_272("dijit.form._TextBoxMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{trim:false,uppercase:false,lowercase:false,propercase:false,maxLength:"",selectOnClick:false,placeHolder:"",_getValueAttr:function(){return this.parse(this.get("displayedValue"),this.constraints);},_setValueAttr:function(_275,_276,_277){var _278;if(_275!==undefined){_278=this.filter(_275);if(typeof _277!="string"){if(_278!==null&&((typeof _278!="number")||!isNaN(_278))){_277=this.filter(this.format(_278,this.constraints));}else{_277="";}}}if(_277!=null&&((typeof _277)!="number"||!isNaN(_277))&&this.textbox.value!=_277){this.textbox.value=_277;this._set("displayedValue",this.get("displayedValue"));}this.inherited(arguments,[_278,_276]);},displayedValue:"",_getDisplayedValueAttr:function(){return this.filter(this.textbox.value);},_setDisplayedValueAttr:function(_279){if(_279==null){_279="";}else{if(typeof _279!="string"){_279=String(_279);}}this.textbox.value=_279;this._setValueAttr(this.get("value"),undefined);this._set("displayedValue",this.get("displayedValue"));},format:function(_27a){return _27a==null?"":(_27a.toString?_27a.toString():_27a);},parse:function(_27b){return _27b;},_refreshState:function(){},onInput:function(){},__skipInputEvent:false,_onInput:function(evt){this._processInput(evt);if(this.intermediateChanges){this.defer(function(){this._handleOnChange(this.get("value"),false);});}},_processInput:function(evt){this._refreshState();this._set("displayedValue",this.get("displayedValue"));},postCreate:function(){this.textbox.setAttribute("value",this.textbox.value);this.inherited(arguments);var _27c=function(e){var _27d;if(e.type=="keydown"){_27d=e.keyCode;switch(_27d){case keys.SHIFT:case keys.ALT:case keys.CTRL:case keys.META:case keys.CAPS_LOCK:case keys.NUM_LOCK:case keys.SCROLL_LOCK:return;}if(!e.ctrlKey&&!e.metaKey&&!e.altKey){switch(_27d){case keys.NUMPAD_0:case keys.NUMPAD_1:case keys.NUMPAD_2:case keys.NUMPAD_3:case keys.NUMPAD_4:case keys.NUMPAD_5:case keys.NUMPAD_6:case keys.NUMPAD_7:case keys.NUMPAD_8:case keys.NUMPAD_9:case keys.NUMPAD_MULTIPLY:case keys.NUMPAD_PLUS:case keys.NUMPAD_ENTER:case keys.NUMPAD_MINUS:case keys.NUMPAD_PERIOD:case keys.NUMPAD_DIVIDE:return;}if((_27d>=65&&_27d<=90)||(_27d>=48&&_27d<=57)||_27d==keys.SPACE){return;}var _27e=false;for(var i in keys){if(keys[i]===e.keyCode){_27e=true;break;}}if(!_27e){return;}}}_27d=e.charCode>=32?String.fromCharCode(e.charCode):e.charCode;if(!_27d){_27d=(e.keyCode>=65&&e.keyCode<=90)||(e.keyCode>=48&&e.keyCode<=57)||e.keyCode==keys.SPACE?String.fromCharCode(e.keyCode):e.keyCode;}if(!_27d){_27d=229;}if(e.type=="keypress"){if(typeof _27d!="string"){return;}if((_27d>="a"&&_27d<="z")||(_27d>="A"&&_27d<="Z")||(_27d>="0"&&_27d<="9")||(_27d===" ")){if(e.ctrlKey||e.metaKey||e.altKey){return;}}}if(e.type=="input"){if(this.__skipInputEvent){this.__skipInputEvent=false;return;}}else{this.__skipInputEvent=true;}var faux={faux:true},attr;for(attr in e){if(attr!="layerX"&&attr!="layerY"){var v=e[attr];if(typeof v!="function"&&typeof v!="undefined"){faux[attr]=v;}}}lang.mixin(faux,{charOrCode:_27d,_wasConsumed:false,preventDefault:function(){faux._wasConsumed=true;e.preventDefault();},stopPropagation:function(){e.stopPropagation();}});if(this.onInput(faux)===false){faux.preventDefault();faux.stopPropagation();}if(faux._wasConsumed){return;}this.defer(function(){this._onInput(faux);});};this.own(on(this.textbox,"keydown, keypress, paste, cut, input, compositionend",lang.hitch(this,_27c)));},_blankValue:"",filter:function(val){if(val===null){return this._blankValue;}if(typeof val!="string"){return val;}if(this.trim){val=lang.trim(val);}if(this.uppercase){val=val.toUpperCase();}if(this.lowercase){val=val.toLowerCase();}if(this.propercase){val=val.replace(/[^\s]+/g,function(word){return word.substring(0,1).toUpperCase()+word.substring(1);});}return val;},_setBlurValue:function(){this._setValueAttr(this.get("value"),true);},_onBlur:function(e){if(this.disabled){return;}this._setBlurValue();this.inherited(arguments);},_isTextSelected:function(){return this.textbox.selectionStart!=this.textbox.selectionEnd;},_onFocus:function(by){if(this.disabled||this.readOnly){return;}if(this.selectOnClick&&by=="mouse"){this._selectOnClickHandle=on.once(this.domNode,"mouseup, touchend",lang.hitch(this,function(evt){if(!this._isTextSelected()){_274.selectInputText(this.textbox);}}));this.own(this._selectOnClickHandle);this.defer(function(){if(this._selectOnClickHandle){this._selectOnClickHandle.remove();this._selectOnClickHandle=null;}},500);}this.inherited(arguments);this._refreshState();},reset:function(){this.textbox.value="";this.inherited(arguments);}});if(has("dojo-bidi")){_274=_272("dijit.form._TextBoxMixin",_274,{_setValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.focusNode);},_setDisplayedValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.focusNode);},_onInput:function(){this.applyTextDir(this.focusNode);this.inherited(arguments);}});}_274._setSelectionRange=_273._setSelectionRange=function(_27f,_280,stop){if(_27f.setSelectionRange){_27f.setSelectionRange(_280,stop);}};_274.selectInputText=_273.selectInputText=function(_281,_282,stop){_281=dom.byId(_281);if(isNaN(_282)){_282=0;}if(isNaN(stop)){stop=_281.value?_281.value.length:0;}try{_281.focus();_274._setSelectionRange(_281,_282,stop);}catch(e){}};return _274;});},"dijit/form/SimpleTextarea":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/sniff","./TextBox"],function(_283,_284,has,_285){return _283("dijit.form.SimpleTextarea",_285,{baseClass:"dijitTextBox dijitTextArea",rows:"3",cols:"20",templateString:"<textarea ${!nameAttrSetting} data-dojo-attach-point='focusNode,containerNode,textbox' autocomplete='off'></textarea>",postMixInProperties:function(){if(!this.value&&this.srcNodeRef){this.value=this.srcNodeRef.value;}this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);if(has("ie")&&this.cols){_284.add(this.textbox,"dijitTextAreaCols");}},filter:function(_286){if(_286){_286=_286.replace(/\r/g,"");}return this.inherited(arguments);},_onInput:function(e){if(this.maxLength){var _287=parseInt(this.maxLength);var _288=this.textbox.value.replace(/\r/g,"");var _289=_288.length-_287;if(_289>0){var _28a=this.textbox;if(_28a.selectionStart){var pos=_28a.selectionStart;var cr=0;if(has("opera")){cr=(this.textbox.value.substring(0,pos).match(/\r/g)||[]).length;}this.textbox.value=_288.substring(0,pos-_289-cr)+_288.substring(pos-cr);_28a.setSelectionRange(pos-_289,pos-_289);}else{if(this.ownerDocument.selection){_28a.focus();var _28b=this.ownerDocument.selection.createRange();_28b.moveStart("character",-_289);_28b.text="";_28b.select();}}}}this.inherited(arguments);}});});},"dijit/PopupMenuItem":function(){define(["dojo/_base/declare","dojo/dom-style","dojo/_base/lang","dojo/query","./popup","./registry","./MenuItem","./hccss"],function(_28c,_28d,lang,_28e,pm,_28f,_290){return _28c("dijit.PopupMenuItem",_290,{_fillContent:function(){if(this.srcNodeRef){var _291=_28e("*",this.srcNodeRef);this.inherited(arguments,[_291[0]]);this.dropDownContainer=this.srcNodeRef;}},_openPopup:function(_292,_293){var _294=this.popup;pm.open(lang.delegate(_292,{popup:this.popup,around:this.domNode}));if(_293&&_294.focus){_294.focus();}},_closePopup:function(){pm.close(this.popup);this.popup.parentMenu=null;},startup:function(){if(this._started){return;}this.inherited(arguments);if(!this.popup){var node=_28e("[widgetId]",this.dropDownContainer)[0];this.popup=_28f.byNode(node);}this.ownerDocumentBody.appendChild(this.popup.domNode);this.popup.startup();this.popup.domNode.style.display="none";if(this.arrowWrapper){_28d.set(this.arrowWrapper,"visibility","");}this.focusNode.setAttribute("aria-haspopup","true");},destroyDescendants:function(_295){if(this.popup){if(!this.popup._destroyed){this.popup.destroyRecursive(_295);}delete this.popup;}this.inherited(arguments);}});});},"dijit/_TimePicker":function(){define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/query","dojo/mouse","dojo/on","./_WidgetBase","./form/_ListMouseMixin"],function(_296,_297,_298,_299,_29a,_29b,_29c,_29d,keys,lang,has,_29e,_29f,on,_2a0,_2a1){var _2a2=_29a("dijit._TimePicker",[_2a0,_2a1],{baseClass:"dijitTimePicker",clickableIncrement:"T00:15:00",visibleIncrement:"T01:00:00",value:new Date(),_visibleIncrement:2,_clickableIncrement:1,_totalIncrements:10,constraints:{},serialize:_299.toISOString,buildRendering:function(){this.inherited(arguments);this.containerNode=this.domNode;this.timeMenu=this.domNode;},setValue:function(_2a3){_29d.deprecated("dijit._TimePicker:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");this.set("value",_2a3);},_setValueAttr:function(date){this._set("value",date);this._showText();},_setFilterStringAttr:function(val){this._set("filterString",val);this._showText();},isDisabledDate:function(){return false;},_getFilteredNodes:function(_2a4,_2a5,_2a6,_2a7){var _2a8=[];for(var i=0;i<this._maxIncrement;i++){var n=this._createOption(i);if(n){_2a8.push(n);}}return _2a8;},_showText:function(){var _2a9=_299.fromISOString;this.domNode.innerHTML="";this._clickableIncrementDate=_2a9(this.clickableIncrement);this._visibleIncrementDate=_2a9(this.visibleIncrement);var _2aa=function(date){return date.getHours()*60*60+date.getMinutes()*60+date.getSeconds();},_2ab=_2aa(this._clickableIncrementDate),_2ac=_2aa(this._visibleIncrementDate),time=(this.value||this.currentFocus).getTime();this._refDate=_2a9("T00:00:00");this._refDate.setFullYear(1970,0,1);this._clickableIncrement=1;this._visibleIncrement=_2ac/_2ab;this._maxIncrement=(60*60*24)/_2ab;var _2ad=this._getFilteredNodes();_296.forEach(_2ad,function(n){this.domNode.appendChild(n);},this);if(!_2ad.length&&this.filterString){this.filterString="";this._showText();}},constructor:function(){this.constraints={};},postMixInProperties:function(){this.inherited(arguments);this._setConstraintsAttr(this.constraints);},_setConstraintsAttr:function(_2ae){for(var key in _2ae){this._set(key,_2ae[key]);}if(!_2ae.locale){_2ae.locale=this.lang;}},_createOption:function(_2af){var date=new Date(this._refDate);var _2b0=this._clickableIncrementDate;date.setTime(date.getTime()+_2b0.getHours()*_2af*3600000+_2b0.getMinutes()*_2af*60000+_2b0.getSeconds()*_2af*1000);if(this.constraints.selector=="time"){date.setFullYear(1970,0,1);}var _2b1=_298.format(date,this.constraints);if(this.filterString&&_2b1.toLowerCase().indexOf(this.filterString)!==0){return null;}var div=this.ownerDocument.createElement("div");div.className=this.baseClass+"Item";div.date=date;div.idx=_2af;_29c.create("div",{"class":this.baseClass+"ItemInner",innerHTML:_2b1},div);if(_2af%this._visibleIncrement<1&&_2af%this._visibleIncrement>-1){_29b.add(div,this.baseClass+"Marker");}else{if(!(_2af%this._clickableIncrement)){_29b.add(div,this.baseClass+"Tick");}}if(this.isDisabledDate(date)){_29b.add(div,this.baseClass+"ItemDisabled");}if(this.value&&!_297.compare(this.value,date,this.constraints.selector)){div.selected=true;_29b.add(div,this.baseClass+"ItemSelected");this._selectedDiv=div;if(_29b.contains(div,this.baseClass+"Marker")){_29b.add(div,this.baseClass+"MarkerSelected");}else{_29b.add(div,this.baseClass+"TickSelected");}this._highlightOption(div,true);}return div;},onOpen:function(){this.inherited(arguments);this.set("selected",this._selectedDiv);},_onOptionSelected:function(tgt){var _2b2=tgt.target.date||tgt.target.parentNode.date;if(!_2b2||this.isDisabledDate(_2b2)){return;}this._highlighted_option=null;this.set("value",_2b2);this.onChange(_2b2);},onChange:function(){},_highlightOption:function(node,_2b3){if(!node){return;}if(_2b3){if(this._highlighted_option){this._highlightOption(this._highlighted_option,false);}this._highlighted_option=node;}else{if(this._highlighted_option!==node){return;}else{this._highlighted_option=null;}}_29b.toggle(node,this.baseClass+"ItemHover",_2b3);if(_29b.contains(node,this.baseClass+"Marker")){_29b.toggle(node,this.baseClass+"MarkerHover",_2b3);}else{_29b.toggle(node,this.baseClass+"TickHover",_2b3);}},handleKey:function(e){if(e.keyCode==keys.DOWN_ARROW){this.selectNextNode();e.stopPropagation();e.preventDefault();return false;}else{if(e.keyCode==keys.UP_ARROW){this.selectPreviousNode();e.stopPropagation();e.preventDefault();return false;}else{if(e.keyCode==keys.ENTER||e.keyCode===keys.TAB){if(!this._keyboardSelected&&e.keyCode===keys.TAB){return true;}if(this._highlighted_option){this._onOptionSelected({target:this._highlighted_option});}return e.keyCode===keys.TAB;}}}return undefined;},onHover:function(node){this._highlightOption(node,true);},onUnhover:function(node){this._highlightOption(node,false);},onSelect:function(node){this._highlightOption(node,true);},onDeselect:function(node){this._highlightOption(node,false);},onClick:function(node){this._onOptionSelected({target:node});}});return _2a2;});},"dijit/form/RadioButton":function(){define(["dojo/_base/declare","./CheckBox","./_RadioButtonMixin"],function(_2b4,_2b5,_2b6){return _2b4("dijit.form.RadioButton",[_2b5,_2b6],{baseClass:"dijitRadio"});});},"dijit/InlineEditBox":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-style","dojo/i18n","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/when","./a11yclick","./focus","./_Widget","./_TemplatedMixin","./_WidgetsInTemplateMixin","./_Container","./form/Button","./form/_TextBoxMixin","./form/TextBox","dojo/text!./templates/InlineEditBox.html","dojo/i18n!./nls/common"],function(_2b7,_2b8,_2b9,_2ba,_2bb,_2bc,_2bd,_2be,i18n,_2bf,keys,lang,on,has,when,_2c0,fm,_2c1,_2c2,_2c3,_2c4,_2c5,_2c6,_2c7,_2c8){var _2c9=_2ba("dijit._InlineEditor",[_2c1,_2c2,_2c3],{templateString:_2c8,contextRequire:_2b7,postMixInProperties:function(){this.inherited(arguments);this.messages=i18n.getLocalization("dijit","common",this.lang);_2b8.forEach(["buttonSave","buttonCancel"],function(prop){if(!this[prop]){this[prop]=this.messages[prop];}},this);},buildRendering:function(){this.inherited(arguments);var Cls=typeof this.editor=="string"?(lang.getObject(this.editor)||_2b7(this.editor)):this.editor;var _2ca=this.sourceStyle,_2cb="line-height:"+_2ca.lineHeight+";",_2cc=_2be.getComputedStyle(this.domNode);_2b8.forEach(["Weight","Family","Size","Style"],function(prop){var _2cd=_2ca["font"+prop],_2ce=_2cc["font"+prop];if(_2ce!=_2cd){_2cb+="font-"+prop+":"+_2ca["font"+prop]+";";}},this);_2b8.forEach(["marginTop","marginBottom","marginLeft","marginRight","position","left","top","right","bottom","float","clear","display"],function(prop){this.domNode.style[prop]=_2ca[prop];},this);var _2cf=this.inlineEditBox.width;if(_2cf=="100%"){_2cb+="width:100%;";this.domNode.style.display="block";}else{_2cb+="width:"+(_2cf+(Number(_2cf)==_2cf?"px":""))+";";}var _2d0=lang.delegate(this.inlineEditBox.editorParams,{style:_2cb,dir:this.dir,lang:this.lang,textDir:this.textDir});this.editWidget=new Cls(_2d0,this.editorPlaceholder);if(this.inlineEditBox.autoSave){_2bd.destroy(this.buttonContainer);}},postCreate:function(){this.inherited(arguments);var ew=this.editWidget;if(this.inlineEditBox.autoSave){this.own(_2b9.after(ew,"onChange",lang.hitch(this,"_onChange"),true),on(ew,"keydown",lang.hitch(this,"_onKeyDown")));}else{if("intermediateChanges" in ew){ew.set("intermediateChanges",true);this.own(_2b9.after(ew,"onChange",lang.hitch(this,"_onIntermediateChange"),true));this.saveButton.set("disabled",true);}}},startup:function(){this.editWidget.startup();this.inherited(arguments);},_onIntermediateChange:function(){this.saveButton.set("disabled",(this.getValue()==this._resetValue)||!this.enableSave());},destroy:function(){this.editWidget.destroy(true);this.inherited(arguments);},getValue:function(){var ew=this.editWidget;return String(ew.get(("displayedValue" in ew||"_getDisplayedValueAttr" in ew)?"displayedValue":"value"));},_onKeyDown:function(e){if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){if(e.altKey||e.ctrlKey){return;}if(e.keyCode==keys.ESCAPE){e.stopPropagation();e.preventDefault();this.cancel(true);}else{if(e.keyCode==keys.ENTER&&e.target.tagName=="INPUT"){e.stopPropagation();e.preventDefault();this._onChange();}}}},_onBlur:function(){this.inherited(arguments);if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing){if(this.getValue()==this._resetValue){this.cancel(false);}else{if(this.enableSave()){this.save(false);}}}},_onChange:function(){if(this.inlineEditBox.autoSave&&this.inlineEditBox.editing&&this.enableSave()){fm.focus(this.inlineEditBox.displayNode);}},enableSave:function(){return this.editWidget.isValid?this.editWidget.isValid():true;},focus:function(){this.editWidget.focus();if(this.editWidget.focusNode){fm._onFocusNode(this.editWidget.focusNode);if(this.editWidget.focusNode.tagName=="INPUT"){this.defer(function(){_2c6.selectInputText(this.editWidget.focusNode);});}}}});var _2d1=_2ba("dijit.InlineEditBox"+(has("dojo-bidi")?"_NoBidi":""),_2c1,{editing:false,autoSave:true,buttonSave:"",buttonCancel:"",renderAsHtml:false,editor:_2c7,editorWrapper:_2c9,editorParams:{},disabled:false,onChange:function(){},onCancel:function(){},width:"100%",value:"",noValueIndicator:has("ie")<=6?"<span style='font-family: wingdings; text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>":"<span style='text-decoration: underline;'>&#160;&#160;&#160;&#160;&#x270d;&#160;&#160;&#160;&#160;</span>",constructor:function(){this.editorParams={};},postMixInProperties:function(){this.inherited(arguments);this.displayNode=this.srcNodeRef;this.own(on(this.displayNode,_2c0,lang.hitch(this,"_onClick")),on(this.displayNode,"mouseover, focus",lang.hitch(this,"_onMouseOver")),on(this.displayNode,"mouseout, blur",lang.hitch(this,"_onMouseOut")));this.displayNode.setAttribute("role","button");if(!this.displayNode.getAttribute("tabIndex")){this.displayNode.setAttribute("tabIndex",0);}if(!this.value&&!("value" in this.params)){this.value=lang.trim(this.renderAsHtml?this.displayNode.innerHTML:(this.displayNode.innerText||this.displayNode.textContent||""));}if(!this.value){this.displayNode.innerHTML=this.noValueIndicator;}_2bc.add(this.displayNode,"dijitInlineEditBoxDisplayMode");},setDisabled:function(_2d2){_2bf.deprecated("dijit.InlineEditBox.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");this.set("disabled",_2d2);},_setDisabledAttr:function(_2d3){this.domNode.setAttribute("aria-disabled",_2d3?"true":"false");if(_2d3){this.displayNode.removeAttribute("tabIndex");}else{this.displayNode.setAttribute("tabIndex",0);}_2bc.toggle(this.displayNode,"dijitInlineEditBoxDisplayModeDisabled",_2d3);this._set("disabled",_2d3);},_onMouseOver:function(){if(!this.disabled){_2bc.add(this.displayNode,"dijitInlineEditBoxDisplayModeHover");}},_onMouseOut:function(){_2bc.remove(this.displayNode,"dijitInlineEditBoxDisplayModeHover");},_onClick:function(e){if(this.disabled){return;}if(e){e.stopPropagation();e.preventDefault();}this._onMouseOut();this.defer("edit");},edit:function(){if(this.disabled||this.editing){return;}this._set("editing",true);this._savedTabIndex=_2bb.get(this.displayNode,"tabIndex")||"0";if(!this.wrapperWidget){var _2d4=_2bd.create("span",null,this.domNode,"before");var Ewc=typeof this.editorWrapper=="string"?lang.getObject(this.editorWrapper):this.editorWrapper;this.wrapperWidget=new Ewc({value:this.value,buttonSave:this.buttonSave,buttonCancel:this.buttonCancel,dir:this.dir,lang:this.lang,tabIndex:this._savedTabIndex,editor:this.editor,inlineEditBox:this,sourceStyle:_2be.getComputedStyle(this.displayNode),save:lang.hitch(this,"save"),cancel:lang.hitch(this,"cancel"),textDir:this.textDir},_2d4);if(!this.wrapperWidget._started){this.wrapperWidget.startup();}if(!this._started){this.startup();}}var ww=this.wrapperWidget;_2bc.add(this.displayNode,"dijitOffScreen");_2bc.remove(ww.domNode,"dijitOffScreen");_2be.set(ww.domNode,{visibility:"visible"});_2bb.set(this.displayNode,"tabIndex","-1");var ew=ww.editWidget;var self=this;when(ew.onLoadDeferred,lang.hitch(ww,function(){ew.set(("displayedValue" in ew||"_setDisplayedValueAttr" in ew)?"displayedValue":"value",self.value);this.defer(function(){ww.saveButton.set("disabled","intermediateChanges" in ew);this.focus();this._resetValue=this.getValue();});}));},_onBlur:function(){this.inherited(arguments);if(!this.editing){}},destroy:function(){if(this.wrapperWidget&&!this.wrapperWidget._destroyed){this.wrapperWidget.destroy();delete this.wrapperWidget;}this.inherited(arguments);},_showText:function(_2d5){var ww=this.wrapperWidget;_2be.set(ww.domNode,{visibility:"hidden"});_2bc.add(ww.domNode,"dijitOffScreen");_2bc.remove(this.displayNode,"dijitOffScreen");_2bb.set(this.displayNode,"tabIndex",this._savedTabIndex);if(_2d5){fm.focus(this.displayNode);}},save:function(_2d6){if(this.disabled||!this.editing){return;}this._set("editing",false);var ww=this.wrapperWidget;var _2d7=ww.getValue();this.set("value",_2d7);this._showText(_2d6);},setValue:function(val){_2bf.deprecated("dijit.InlineEditBox.setValue() is deprecated.  Use set('value', ...) instead.","","2.0");return this.set("value",val);},_setValueAttr:function(val){val=lang.trim(val);var _2d8=this.renderAsHtml?val:val.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;").replace(/\n/g,"<br>");this.displayNode.innerHTML=_2d8||this.noValueIndicator;this._set("value",val);if(this._started){this.defer(function(){this.onChange(val);});}},getValue:function(){_2bf.deprecated("dijit.InlineEditBox.getValue() is deprecated.  Use get('value') instead.","","2.0");return this.get("value");},cancel:function(_2d9){if(this.disabled||!this.editing){return;}this._set("editing",false);this.defer("onCancel");this._showText(_2d9);}});if(has("dojo-bidi")){_2d1=_2ba("dijit.InlineEditBox",_2d1,{_setValueAttr:function(){this.inherited(arguments);this.applyTextDir(this.displayNode);}});}_2d1._InlineEditor=_2c9;return _2d1;});},"dojo/dnd/autoscroll":function(){define(["../_base/lang","../sniff","../_base/window","../dom-geometry","../dom-style","../window"],function(lang,has,win,_2da,_2db,_2dc){var _2dd={};lang.setObject("dojo.dnd.autoscroll",_2dd);_2dd.getViewport=_2dc.getBox;_2dd.V_TRIGGER_AUTOSCROLL=32;_2dd.H_TRIGGER_AUTOSCROLL=32;_2dd.V_AUTOSCROLL_VALUE=16;_2dd.H_AUTOSCROLL_VALUE=16;var _2de,doc=win.doc,_2df=Infinity,_2e0=Infinity;_2dd.autoScrollStart=function(d){doc=d;_2de=_2dc.getBox(doc);var html=win.body(doc).parentNode;_2df=Math.max(html.scrollHeight-_2de.h,0);_2e0=Math.max(html.scrollWidth-_2de.w,0);};_2dd.autoScroll=function(e){var v=_2de||_2dc.getBox(doc),html=win.body(doc).parentNode,dx=0,dy=0;if(e.clientX<_2dd.H_TRIGGER_AUTOSCROLL){dx=-_2dd.H_AUTOSCROLL_VALUE;}else{if(e.clientX>v.w-_2dd.H_TRIGGER_AUTOSCROLL){dx=Math.min(_2dd.H_AUTOSCROLL_VALUE,_2e0-html.scrollLeft);}}if(e.clientY<_2dd.V_TRIGGER_AUTOSCROLL){dy=-_2dd.V_AUTOSCROLL_VALUE;}else{if(e.clientY>v.h-_2dd.V_TRIGGER_AUTOSCROLL){dy=Math.min(_2dd.V_AUTOSCROLL_VALUE,_2df-html.scrollTop);}}window.scrollBy(dx,dy);};_2dd._validNodes={"div":1,"p":1,"td":1};_2dd._validOverflow={"auto":1,"scroll":1};_2dd.autoScrollNodes=function(e){var b,t,w,h,rx,ry,dx=0,dy=0,_2e1,_2e2;for(var n=e.target;n;){if(n.nodeType==1&&(n.tagName.toLowerCase() in _2dd._validNodes)){var s=_2db.getComputedStyle(n),_2e3=(s.overflow.toLowerCase() in _2dd._validOverflow),_2e4=(s.overflowX.toLowerCase() in _2dd._validOverflow),_2e5=(s.overflowY.toLowerCase() in _2dd._validOverflow);if(_2e3||_2e4||_2e5){b=_2da.getContentBox(n,s);t=_2da.position(n,true);}if(_2e3||_2e4){w=Math.min(_2dd.H_TRIGGER_AUTOSCROLL,b.w/2);rx=e.pageX-t.x;if(has("webkit")||has("opera")){rx+=win.body().scrollLeft;}dx=0;if(rx>0&&rx<b.w){if(rx<w){dx=-w;}else{if(rx>b.w-w){dx=w;}}_2e1=n.scrollLeft;n.scrollLeft=n.scrollLeft+dx;}}if(_2e3||_2e5){h=Math.min(_2dd.V_TRIGGER_AUTOSCROLL,b.h/2);ry=e.pageY-t.y;if(has("webkit")||has("opera")){ry+=win.body().scrollTop;}dy=0;if(ry>0&&ry<b.h){if(ry<h){dy=-h;}else{if(ry>b.h-h){dy=h;}}_2e2=n.scrollTop;n.scrollTop=n.scrollTop+dy;}}if(dx||dy){return;}}try{n=n.parentNode;}catch(x){n=null;}}_2dd.autoScroll(e);};return _2dd;});},"dijit/form/_RadioButtonMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/lang","dojo/query","../registry"],function(_2e6,_2e7,_2e8,lang,_2e9,_2ea){return _2e7("dijit.form._RadioButtonMixin",null,{type:"radio",_getRelatedWidgets:function(){var ary=[];_2e9("input[type=radio]",this.focusNode.form||this.ownerDocument).forEach(lang.hitch(this,function(_2eb){if(_2eb.name==this.name&&_2eb.form==this.focusNode.form){var _2ec=_2ea.getEnclosingWidget(_2eb);if(_2ec){ary.push(_2ec);}}}));return ary;},_setCheckedAttr:function(_2ed){this.inherited(arguments);if(!this._created){return;}if(_2ed){_2e6.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_2ee){if(_2ee!=this&&_2ee.checked){_2ee.set("checked",false);}}));}},_getSubmitValue:function(_2ef){return _2ef==null?"on":_2ef;},_onClick:function(e){if(this.checked||this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.readOnly){e.stopPropagation();e.preventDefault();_2e6.forEach(this._getRelatedWidgets(),lang.hitch(this,function(_2f0){_2e8.set(this.focusNode||this.domNode,"checked",_2f0.checked);}));return false;}return this.inherited(arguments);}});});},"dojo/dnd/TimedMoveable":function(){define(["../_base/declare","./Moveable"],function(_2f1,_2f2){var _2f3=_2f2.prototype.onMove;return _2f1("dojo.dnd.TimedMoveable",_2f2,{timeout:40,constructor:function(node,_2f4){if(!_2f4){_2f4={};}if(_2f4.timeout&&typeof _2f4.timeout=="number"&&_2f4.timeout>=0){this.timeout=_2f4.timeout;}},onMoveStop:function(_2f5){if(_2f5._timer){clearTimeout(_2f5._timer);_2f3.call(this,_2f5,_2f5._leftTop);}_2f2.prototype.onMoveStop.apply(this,arguments);},onMove:function(_2f6,_2f7){_2f6._leftTop=_2f7;if(!_2f6._timer){var _2f8=this;_2f6._timer=setTimeout(function(){_2f6._timer=null;_2f3.call(_2f8,_2f6,_2f6._leftTop);},this.timeout);}}});});},"dijit/layout/LinkPane":function(){define(["./ContentPane","../_TemplatedMixin","dojo/_base/declare"],function(_2f9,_2fa,_2fb){return _2fb("dijit.layout.LinkPane",[_2f9,_2fa],{templateString:"<div class=\"dijitLinkPane\" data-dojo-attach-point=\"containerNode\"></div>",postMixInProperties:function(){if(this.srcNodeRef){this.title+=this.srcNodeRef.innerHTML;}this.inherited(arguments);},_fillContent:function(){}});});},"dijit/form/_ListMouseMixin":function(){define(["dojo/_base/declare","dojo/on","dojo/touch","./_ListBase"],function(_2fc,on,_2fd,_2fe){return _2fc("dijit.form._ListMouseMixin",_2fe,{postCreate:function(){this.inherited(arguments);this.domNode.dojoClick=true;this.own(on(this.domNode,"mousedown",function(evt){evt.preventDefault();}));this._listConnect("click","_onClick");this._listConnect(_2fd.press,"_onMouseDown");this._listConnect(_2fd.release,"_onMouseUp");this._listConnect(_2fd.over,"_onMouseOver");this._listConnect(_2fd.out,"_onMouseOut");},_onClick:function(evt,_2ff){this._setSelectedAttr(_2ff);if(this._deferredClick){this._deferredClick.remove();}this._deferredClick=this.defer(function(){this._deferredClick=null;this.onClick(_2ff);});},_onMouseDown:function(evt,_300){if(this._hoveredNode){this.onUnhover(this._hoveredNode);this._hoveredNode=null;}this._isDragging=true;this._setSelectedAttr(_300);},_onMouseUp:function(evt,_301){this._isDragging=false;var _302=this.selected;var _303=this._hoveredNode;if(_302&&_301==_302){this.defer(function(){this._onClick(evt,_302);});}else{if(_303){this.defer(function(){this._onClick(evt,_303);});}}},_onMouseOut:function(evt,_304){if(this._hoveredNode){this.onUnhover(this._hoveredNode);this._hoveredNode=null;}if(this._isDragging){this._cancelDrag=(new Date()).getTime()+1000;}},_onMouseOver:function(evt,_305){if(this._cancelDrag){var time=(new Date()).getTime();if(time>this._cancelDrag){this._isDragging=false;}this._cancelDrag=null;}this._hoveredNode=_305;this.onHover(_305);if(this._isDragging){this._setSelectedAttr(_305);}}});});},"dojo/cldr/monetary":function(){define(["../_base/kernel","../_base/lang"],function(dojo,lang){var _306={};lang.setObject("dojo.cldr.monetary",_306);_306.getData=function(code){var _307={ADP:0,AFN:0,ALL:0,AMD:0,BHD:3,BIF:0,BYR:0,CLF:0,CLP:0,COP:0,CRC:0,DJF:0,ESP:0,GNF:0,GYD:0,HUF:0,IDR:0,IQD:0,IRR:3,ISK:0,ITL:0,JOD:3,JPY:0,KMF:0,KPW:0,KRW:0,KWD:3,LAK:0,LBP:0,LUF:0,LYD:3,MGA:0,MGF:0,MMK:0,MNT:0,MRO:0,MUR:0,OMR:3,PKR:0,PYG:0,RSD:0,RWF:0,SLL:0,SOS:0,STD:0,SYP:0,TMM:0,TND:3,TRL:0,TZS:0,UGX:0,UZS:0,VND:0,VUV:0,XAF:0,XOF:0,XPF:0,YER:0,ZMK:0,ZWD:0};var _308={};var _309=_307[code],_30a=_308[code];if(typeof _309=="undefined"){_309=2;}if(typeof _30a=="undefined"){_30a=0;}return {places:_309,round:_30a};};return _306;});},"dojo/cookie":function(){define(["./_base/kernel","./regexp"],function(dojo,_30b){dojo.cookie=function(name,_30c,_30d){var c=document.cookie,ret;if(arguments.length==1){var _30e=c.match(new RegExp("(?:^|; )"+_30b.escapeString(name)+"=([^;]*)"));ret=_30e?decodeURIComponent(_30e[1]):undefined;}else{_30d=_30d||{};var exp=_30d.expires;if(typeof exp=="number"){var d=new Date();d.setTime(d.getTime()+exp*24*60*60*1000);exp=_30d.expires=d;}if(exp&&exp.toUTCString){_30d.expires=exp.toUTCString();}_30c=encodeURIComponent(_30c);var _30f=name+"="+_30c,_310;for(_310 in _30d){_30f+="; "+_310;var _311=_30d[_310];if(_311!==true){_30f+="="+_311;}}document.cookie=_30f;}return ret;};dojo.cookie.isSupported=function(){if(!("cookieEnabled" in navigator)){this("__djCookieTest__","CookiesAllowed");navigator.cookieEnabled=this("__djCookieTest__")=="CookiesAllowed";if(navigator.cookieEnabled){this("__djCookieTest__","",{expires:-1});}}return navigator.cookieEnabled;};return dojo.cookie;});},"dijit/ProgressBar":function(){define(["require","dojo/_base/declare","dojo/dom-class","dojo/_base/lang","dojo/number","./_Widget","./_TemplatedMixin","dojo/text!./templates/ProgressBar.html"],function(_312,_313,_314,lang,_315,_316,_317,_318){return _313("dijit.ProgressBar",[_316,_317],{progress:"0",value:"",maximum:100,places:0,indeterminate:false,label:"",name:"",templateString:_318,_indeterminateHighContrastImagePath:_312.toUrl("./themes/a11y/indeterminate_progress.gif"),postMixInProperties:function(){this.inherited(arguments);if(!(this.params&&"value" in this.params)){this.value=this.indeterminate?Infinity:this.progress;}},buildRendering:function(){this.inherited(arguments);this.indeterminateHighContrastImage.setAttribute("src",this._indeterminateHighContrastImagePath.toString());this.update();},_setDirAttr:function(val){_314.toggle(this.domNode,"dijitProgressBarRtl",val=="rtl");this.inherited(arguments);},update:function(_319){lang.mixin(this,_319||{});var tip=this.internalProgress,ap=this.domNode;var _31a=1;if(this.indeterminate){ap.removeAttribute("aria-valuenow");}else{if(String(this.progress).indexOf("%")!=-1){_31a=Math.min(parseFloat(this.progress)/100,1);this.progress=_31a*this.maximum;}else{this.progress=Math.min(this.progress,this.maximum);_31a=this.maximum?this.progress/this.maximum:0;}ap.setAttribute("aria-valuenow",this.progress);}ap.setAttribute("aria-labelledby",this.labelNode.id);ap.setAttribute("aria-valuemin",0);ap.setAttribute("aria-valuemax",this.maximum);this.labelNode.innerHTML=this.report(_31a);_314.toggle(this.domNode,"dijitProgressBarIndeterminate",this.indeterminate);tip.style.width=(_31a*100)+"%";this.onChange();},_setValueAttr:function(v){this._set("value",v);if(v==Infinity){this.update({indeterminate:true});}else{this.update({indeterminate:false,progress:v});}},_setLabelAttr:function(_31b){this._set("label",_31b);this.update();},_setIndeterminateAttr:function(_31c){this._set("indeterminate",_31c);this.update();},report:function(_31d){return this.label?this.label:(this.indeterminate?"&#160;":_315.format(_31d,{type:"percent",places:this.places,locale:this.lang}));},onChange:function(){}});});},"dijit/form/NumberTextBox":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/number","./RangeBoundTextBox"],function(_31e,lang,_31f,_320){var _321=_31e("dijit.form.NumberTextBoxMixin",null,{pattern:function(_322){return "("+(this.focused&&this.editOptions?this._regExpGenerator(lang.delegate(_322,this.editOptions))+"|":"")+this._regExpGenerator(_322)+")";},value:NaN,editOptions:{pattern:"#.######"},_formatter:_31f.format,_regExpGenerator:_31f.regexp,postMixInProperties:function(){this.inherited(arguments);this._set("type","text");},_setConstraintsAttr:function(_323){var _324=typeof _323.places=="number"?_323.places:0;if(_324){_324++;}if(typeof _323.max!="number"){_323.max=9*Math.pow(10,15-_324);}if(typeof _323.min!="number"){_323.min=-9*Math.pow(10,15-_324);}this.inherited(arguments,[_323]);if(this.focusNode&&this.focusNode.value&&!isNaN(this.value)){this.set("value",this.value);}},_onFocus:function(){if(this.disabled){return;}var val=this.get("value");if(typeof val=="number"&&!isNaN(val)){var _325=this.format(val,this.constraints);if(_325!==undefined){this.textbox.value=_325;}}this.inherited(arguments);},format:function(_326,_327){var _328=String(_326);if(typeof _326!="number"){return _328;}if(isNaN(_326)){return "";}if(!("rangeCheck" in this&&this.rangeCheck(_326,_327))&&_327.exponent!==false&&/\de[-+]?\d/i.test(_328)){return _328;}if(this.editOptions&&this.focused){_327=lang.mixin({},_327,this.editOptions);}return this._formatter(_326,_327);},_parser:_31f.parse,parse:function(_329,_32a){var v=this._parser(_329,lang.mixin({},_32a,(this.editOptions&&this.focused)?this.editOptions:{}));if(this.editOptions&&this.focused&&isNaN(v)){v=this._parser(_329,_32a);}return v;},_getDisplayedValueAttr:function(){var v=this.inherited(arguments);return isNaN(v)?this.textbox.value:v;},filter:function(_32b){return (_32b==null||_32b==="")?NaN:this.inherited(arguments);},serialize:function(_32c,_32d){return (typeof _32c!="number"||isNaN(_32c))?"":this.inherited(arguments);},_setBlurValue:function(){var val=lang.hitch(lang.delegate(this,{focused:true}),"get")("value");this._setValueAttr(val,true);},_setValueAttr:function(_32e,_32f,_330){if(_32e!==undefined&&_330===undefined){_330=String(_32e);if(typeof _32e=="number"){if(isNaN(_32e)){_330="";}else{if(("rangeCheck" in this&&this.rangeCheck(_32e,this.constraints))||this.constraints.exponent===false||!/\de[-+]?\d/i.test(_330)){_330=undefined;}}}else{if(!_32e){_330="";_32e=NaN;}else{_32e=undefined;}}}this.inherited(arguments,[_32e,_32f,_330]);},_getValueAttr:function(){var v=this.inherited(arguments);if(isNaN(v)&&this.textbox.value!==""){if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)&&(new RegExp("^"+_31f._realNumberRegexp(lang.delegate(this.constraints))+"$").test(this.textbox.value))){var n=Number(this.textbox.value);return isNaN(n)?undefined:n;}else{return undefined;}}else{return v;}},isValid:function(_331){if(!this.focused||this._isEmpty(this.textbox.value)){return this.inherited(arguments);}else{var v=this.get("value");if(!isNaN(v)&&this.rangeCheck(v,this.constraints)){if(this.constraints.exponent!==false&&/\de[-+]?\d/i.test(this.textbox.value)){return true;}else{return this.inherited(arguments);}}else{return false;}}}});var _332=_31e("dijit.form.NumberTextBox",[_320,_321],{baseClass:"dijitTextBox dijitNumberTextBox"});_332.Mixin=_321;return _332;});},"dijit/form/TimeTextBox":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","../_TimePicker","./_DateTimeTextBox"],function(_333,keys,lang,_334,_335){return _333("dijit.form.TimeTextBox",_335,{baseClass:"dijitTextBox dijitComboBox dijitTimeTextBox",popupClass:_334,_selector:"time",value:new Date(""),maxHeight:-1,_onKey:function(evt){if(this.disabled||this.readOnly){return;}this.inherited(arguments);switch(evt.keyCode){case keys.ENTER:case keys.TAB:case keys.ESCAPE:case keys.DOWN_ARROW:case keys.UP_ARROW:break;default:this.defer(function(){var val=this.get("displayedValue");this.filterString=(val&&!this.parse(val,this.constraints))?val.toLowerCase():"";if(this._opened){this.closeDropDown();}this.openDropDown();});}}});});},"dijit/ColorPalette":function(){define(["require","dojo/text!./templates/ColorPalette.html","./_Widget","./_TemplatedMixin","./_PaletteMixin","./hccss","dojo/i18n","dojo/_base/Color","dojo/_base/declare","dojo/dom-construct","dojo/string","dojo/i18n!dojo/nls/colors","dojo/colors"],function(_336,_337,_338,_339,_33a,has,i18n,_33b,_33c,_33d,_33e){var _33f=_33c("dijit.ColorPalette",[_338,_339,_33a],{palette:"7x10",_palettes:{"7x10":[["white","seashell","cornsilk","lemonchiffon","lightyellow","palegreen","paleturquoise","lightcyan","lavender","plum"],["lightgray","pink","bisque","moccasin","khaki","lightgreen","lightseagreen","lightskyblue","cornflowerblue","violet"],["silver","lightcoral","sandybrown","orange","palegoldenrod","chartreuse","mediumturquoise","skyblue","mediumslateblue","orchid"],["gray","red","orangered","darkorange","yellow","limegreen","darkseagreen","royalblue","slateblue","mediumorchid"],["dimgray","crimson","chocolate","coral","gold","forestgreen","seagreen","blue","blueviolet","darkorchid"],["darkslategray","firebrick","saddlebrown","sienna","olive","green","darkcyan","mediumblue","darkslateblue","darkmagenta"],["black","darkred","maroon","brown","darkolivegreen","darkgreen","midnightblue","navy","indigo","purple"]],"3x4":[["white","lime","green","blue"],["silver","yellow","fuchsia","navy"],["gray","red","purple","black"]]},templateString:_337,baseClass:"dijitColorPalette",_dyeFactory:function(_340,row,col,_341){return new this._dyeClass(_340,row,col,_341);},buildRendering:function(){this.inherited(arguments);this._dyeClass=_33c(_33f._Color,{palette:this.palette});this._preparePalette(this._palettes[this.palette],i18n.getLocalization("dojo","colors",this.lang));}});_33f._Color=_33c("dijit._Color",_33b,{template:"<span class='dijitInline dijitPaletteImg'>"+"<img src='${blankGif}' alt='${alt}' title='${title}' class='dijitColorPaletteSwatch' style='background-color: ${color}'/>"+"</span>",hcTemplate:"<span class='dijitInline dijitPaletteImg' style='position: relative; overflow: hidden; height: 12px; width: 14px;'>"+"<img src='${image}' alt='${alt}' title='${title}' style='position: absolute; left: ${left}px; top: ${top}px; ${size}'/>"+"</span>",_imagePaths:{"7x10":_336.toUrl("./themes/a11y/colors7x10.png"),"3x4":_336.toUrl("./themes/a11y/colors3x4.png")},constructor:function(_342,row,col,_343){this._title=_343;this._row=row;this._col=col;this.setColor(_33b.named[_342]);},getValue:function(){return this.toHex();},fillCell:function(cell,_344){var html=_33e.substitute(has("highcontrast")?this.hcTemplate:this.template,{color:this.toHex(),blankGif:_344,alt:this._title,title:this._title,image:this._imagePaths[this.palette].toString(),left:this._col*-20-5,top:this._row*-20-5,size:this.palette=="7x10"?"height: 145px; width: 206px":"height: 64px; width: 86px"});_33d.place(html,cell);}});return _33f;});},"dijit/form/CurrencyTextBox":function(){define(["dojo/currency","dojo/_base/declare","dojo/_base/lang","./NumberTextBox"],function(_345,_346,lang,_347){return _346("dijit.form.CurrencyTextBox",_347,{currency:"",baseClass:"dijitTextBox dijitCurrencyTextBox",_formatter:_345.format,_parser:_345.parse,_regExpGenerator:_345.regexp,parse:function(_348,_349){var v=this.inherited(arguments);if(isNaN(v)&&/\d+/.test(_348)){v=lang.hitch(lang.delegate(this,{_parser:_347.prototype._parser}),"inherited")(arguments);}return v;},_setConstraintsAttr:function(_34a){if(!_34a.currency&&this.currency){_34a.currency=this.currency;}this.inherited(arguments,[_345._mixInDefaults(lang.mixin(_34a,{exponent:false}))]);}});});},"dijit/layout/LayoutContainer":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-style","dojo/_base/lang","../_WidgetBase","./_LayoutWidget","./utils"],function(_34b,_34c,_34d,_34e,lang,_34f,_350,_351){var _352=_34c("dijit.layout.LayoutContainer",_350,{design:"headline",baseClass:"dijitLayoutContainer",startup:function(){if(this._started){return;}_34b.forEach(this.getChildren(),this._setupChild,this);this.inherited(arguments);},_setupChild:function(_353){this.inherited(arguments);var _354=_353.region;if(_354){_34d.add(_353.domNode,this.baseClass+"Pane");}},_getOrderedChildren:function(){var _355=_34b.map(this.getChildren(),function(_356,idx){return {pane:_356,weight:[_356.region=="center"?Infinity:0,_356.layoutPriority,(this.design=="sidebar"?1:-1)*(/top|bottom/.test(_356.region)?1:-1),idx]};},this);_355.sort(function(a,b){var aw=a.weight,bw=b.weight;for(var i=0;i<aw.length;i++){if(aw[i]!=bw[i]){return aw[i]-bw[i];}}return 0;});return _34b.map(_355,function(w){return w.pane;});},layout:function(){_351.layoutChildren(this.domNode,this._contentBox,this._getOrderedChildren());},addChild:function(_357,_358){this.inherited(arguments);if(this._started){this.layout();}},removeChild:function(_359){this.inherited(arguments);if(this._started){this.layout();}_34d.remove(_359.domNode,this.baseClass+"Pane");_34e.set(_359.domNode,{top:"auto",bottom:"auto",left:"auto",right:"auto",position:"static"});_34e.set(_359.domNode,/top|bottom/.test(_359.region)?"width":"height","auto");}});_352.ChildWidgetProperties={region:"",layoutAlign:"",layoutPriority:0};lang.extend(_34f,_352.ChildWidgetProperties);return _352;});},"dijit/Tooltip":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_35a,_35b,fx,dom,_35c,_35d,_35e,lang,_35f,on,has,_360,_361,_362,_363,_364,_365,_366){var _367=_35b("dijit._MasterTooltip",[_362,_363],{duration:_360.defaultDuration,templateString:_365,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _364(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_368,_369,_36a,rtl,_36b){if(this.aroundNode&&this.aroundNode===_369&&this.containerNode.innerHTML==_368){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_368;if(_36b){this.set("textDir",_36b);}this.containerNode.align=rtl?"right":"left";var pos=_361.around(this.domNode,_369,_36a&&_36a.length?_36a:_36c.defaultPosition,!rtl,lang.hitch(this,"orient"));var _36d=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_36d.y+((_36d.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_36d.x+((_36d.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_35e.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_369;},orient:function(node,_36e,_36f,_370,_371){this.connectorNode.style.top="";var _372=_370.h,_373=_370.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_36e+"-"+_36f];this.domNode.style.width="auto";var size=_35d.position(this.domNode);if(has("ie")==9){size.w+=2;}var _374=Math.min((Math.max(_373,1)),size.w);_35d.setMarginBox(this.domNode,{w:_374});if(_36f.charAt(0)=="B"&&_36e.charAt(0)=="B"){var bb=_35d.position(node);var _375=this.connectorNode.offsetHeight;if(bb.h>_372){var _376=_372-((_371.h+_375)>>1);this.connectorNode.style.top=_376+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_371.h/2-_375/2,0),bb.h-_375)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_373);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_377){if(this._onDeck&&this._onDeck[1]==_377){this._onDeck=null;}else{if(this.aroundNode===_377){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});if(has("dojo-bidi")){_367.extend({_setAutoTextDir:function(node){this.applyTextDir(node);_35a.forEach(node.children,function(_378){this._setAutoTextDir(_378);},this);},_setTextDirAttr:function(_379){this._set("textDir",_379);if(_379=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});}_366.showTooltip=function(_37a,_37b,_37c,rtl,_37d){if(_37c){_37c=_35a.map(_37c,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_36c._masterTT){_366._masterTT=_36c._masterTT=new _367();}return _36c._masterTT.show(_37a,_37b,_37c,rtl,_37d);};_366.hideTooltip=function(_37e){return _36c._masterTT&&_36c._masterTT.hide(_37e);};var _36c=_35b("dijit.Tooltip",_362,{label:"",showDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_37f){_35a.forEach(this._connections||[],function(_380){_35a.forEach(_380,function(_381){_381.remove();});},this);this._connectIds=_35a.filter(lang.isArrayLike(_37f)?_37f:(_37f?[_37f]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_35a.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_382=this.selector,_383=_382?function(_384){return on.selector(_382,_384);}:function(_385){return _385;},self=this;return [on(node,_383(_35f.enter),function(){self._onHover(this);}),on(node,_383("focusin"),function(){self._onHover(this);}),on(node,_383(_35f.leave),lang.hitch(self,"_onUnHover")),on(node,_383("focusout"),lang.hitch(self,"_onUnHover"))];},this);this._set("connectId",_37f);},addTarget:function(node){var id=node.id||node;if(_35a.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_35a.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_35c.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_35a.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},_onHover:function(_386){if(!this._showTimer){this._showTimer=this.defer(function(){this.open(_386);},this.showDelay);}},_onUnHover:function(){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}this.close();},open:function(_387){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}var _388=this.getContent(_387);if(!_388){return;}_36c.show(_388,_387,this.position,!this.isLeftToRight(),this.textDir);this._connectNode=_387;this.onShow(_387,this.position);},close:function(){if(this._connectNode){_36c.hide(this._connectNode);delete this._connectNode;this.onHide();}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}},onShow:function(){},onHide:function(){},destroy:function(){this.close();_35a.forEach(this._connections||[],function(_389){_35a.forEach(_389,function(_38a){_38a.remove();});},this);this.inherited(arguments);}});_36c._MasterTooltip=_367;_36c.show=_366.showTooltip;_36c.hide=_366.hideTooltip;_36c.defaultPosition=["after-centered","before-centered"];return _36c;});},"dijit/form/VerticalSlider":function(){define(["dojo/_base/declare","./HorizontalSlider","dojo/text!./templates/VerticalSlider.html"],function(_38b,_38c,_38d){return _38b("dijit.form.VerticalSlider",_38c,{templateString:_38d,_mousePixelCoord:"pageY",_pixelCount:"h",_startingPixelCoord:"y",_handleOffsetCoord:"top",_progressPixelSize:"height",_descending:true,_isReversed:function(){return this._descending;}});});},"dijit/form/DropDownButton":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/query","../registry","../popup","./Button","../_Container","../_HasDropDown","dojo/text!./templates/DropDownButton.html"],function(_38e,lang,_38f,_390,_391,_392,_393,_394,_395){return _38e("dijit.form.DropDownButton",[_392,_393,_394],{baseClass:"dijitDropDownButton",templateString:_395,_fillContent:function(){if(this.srcNodeRef){var _396=_38f("*",this.srcNodeRef);this.inherited(arguments,[_396[0]]);this.dropDownContainer=this.srcNodeRef;}},startup:function(){if(this._started){return;}if(!this.dropDown&&this.dropDownContainer){var _397=_38f("[widgetId]",this.dropDownContainer)[0];if(_397){this.dropDown=_390.byNode(_397);}delete this.dropDownContainer;}if(this.dropDown){_391.hide(this.dropDown);}this.inherited(arguments);},isLoaded:function(){var _398=this.dropDown;return (!!_398&&(!_398.href||_398.isLoaded));},loadDropDown:function(_399){var _39a=this.dropDown;var _39b=_39a.on("load",lang.hitch(this,function(){_39b.remove();_399();}));_39a.refresh();},isFocusable:function(){return this.inherited(arguments)&&!this._mouseDown;}});});},"dojo/date":function(){define(["./has","./_base/lang"],function(has,lang){var date={};date.getDaysInMonth=function(_39c){var _39d=_39c.getMonth();var days=[31,28,31,30,31,30,31,31,30,31,30,31];if(_39d==1&&date.isLeapYear(_39c)){return 29;}return days[_39d];};date.isLeapYear=function(_39e){var year=_39e.getFullYear();return !(year%400)||(!(year%4)&&!!(year%100));};date.getTimezoneName=function(_39f){var str=_39f.toString();var tz="";var _3a0;var pos=str.indexOf("(");if(pos>-1){tz=str.substring(++pos,str.indexOf(")"));}else{var pat=/([A-Z\/]+) \d{4}$/;if((_3a0=str.match(pat))){tz=_3a0[1];}else{str=_39f.toLocaleString();pat=/ ([A-Z\/]+)$/;if((_3a0=str.match(pat))){tz=_3a0[1];}}}return (tz=="AM"||tz=="PM")?"":tz;};date.compare=function(_3a1,_3a2,_3a3){_3a1=new Date(+_3a1);_3a2=new Date(+(_3a2||new Date()));if(_3a3=="date"){_3a1.setHours(0,0,0,0);_3a2.setHours(0,0,0,0);}else{if(_3a3=="time"){_3a1.setFullYear(0,0,0);_3a2.setFullYear(0,0,0);}}if(_3a1>_3a2){return 1;}if(_3a1<_3a2){return -1;}return 0;};date.add=function(date,_3a4,_3a5){var sum=new Date(+date);var _3a6=false;var _3a7="Date";switch(_3a4){case "day":break;case "weekday":var days,_3a8;var mod=_3a5%5;if(!mod){days=(_3a5>0)?5:-5;_3a8=(_3a5>0)?((_3a5-5)/5):((_3a5+5)/5);}else{days=mod;_3a8=parseInt(_3a5/5);}var strt=date.getDay();var adj=0;if(strt==6&&_3a5>0){adj=1;}else{if(strt==0&&_3a5<0){adj=-1;}}var trgt=strt+days;if(trgt==0||trgt==6){adj=(_3a5>0)?2:-2;}_3a5=(7*_3a8)+days+adj;break;case "year":_3a7="FullYear";_3a6=true;break;case "week":_3a5*=7;break;case "quarter":_3a5*=3;case "month":_3a6=true;_3a7="Month";break;default:_3a7="UTC"+_3a4.charAt(0).toUpperCase()+_3a4.substring(1)+"s";}if(_3a7){sum["set"+_3a7](sum["get"+_3a7]()+_3a5);}if(_3a6&&(sum.getDate()<date.getDate())){sum.setDate(0);}return sum;};date.difference=function(_3a9,_3aa,_3ab){_3aa=_3aa||new Date();_3ab=_3ab||"day";var _3ac=_3aa.getFullYear()-_3a9.getFullYear();var _3ad=1;switch(_3ab){case "quarter":var m1=_3a9.getMonth();var m2=_3aa.getMonth();var q1=Math.floor(m1/3)+1;var q2=Math.floor(m2/3)+1;q2+=(_3ac*4);_3ad=q2-q1;break;case "weekday":var days=Math.round(date.difference(_3a9,_3aa,"day"));var _3ae=parseInt(date.difference(_3a9,_3aa,"week"));var mod=days%7;if(mod==0){days=_3ae*5;}else{var adj=0;var aDay=_3a9.getDay();var bDay=_3aa.getDay();_3ae=parseInt(days/7);mod=days%7;var _3af=new Date(_3a9);_3af.setDate(_3af.getDate()+(_3ae*7));var _3b0=_3af.getDay();if(days>0){switch(true){case aDay==6:adj=-1;break;case aDay==0:adj=0;break;case bDay==6:adj=-1;break;case bDay==0:adj=-2;break;case (_3b0+mod)>5:adj=-2;}}else{if(days<0){switch(true){case aDay==6:adj=0;break;case aDay==0:adj=1;break;case bDay==6:adj=2;break;case bDay==0:adj=1;break;case (_3b0+mod)<0:adj=2;}}}days+=adj;days-=(_3ae*2);}_3ad=days;break;case "year":_3ad=_3ac;break;case "month":_3ad=(_3aa.getMonth()-_3a9.getMonth())+(_3ac*12);break;case "week":_3ad=parseInt(date.difference(_3a9,_3aa,"day")/7);break;case "day":_3ad/=24;case "hour":_3ad/=60;case "minute":_3ad/=60;case "second":_3ad/=1000;case "millisecond":_3ad*=_3aa.getTime()-_3a9.getTime();}return Math.round(_3ad);};1&&lang.mixin(lang.getObject("dojo.date",true),date);return date;});},"dijit/layout/_ContentPaneResizeMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/query","dojo/sniff","../registry","../Viewport","./utils"],function(_3b1,_3b2,_3b3,_3b4,_3b5,lang,_3b6,has,_3b7,_3b8,_3b9){return _3b2("dijit.layout._ContentPaneResizeMixin",null,{doLayout:true,isLayoutContainer:true,startup:function(){if(this._started){return;}var _3ba=this.getParent();this._childOfLayoutWidget=_3ba&&_3ba.isLayoutContainer;this._needLayout=!this._childOfLayoutWidget;this.inherited(arguments);if(this._isShown()){this._onShow();}if(!this._childOfLayoutWidget){this.own(_3b8.on("resize",lang.hitch(this,"resize")));}},_checkIfSingleChild:function(){var _3bb=[],_3bc=false;_3b6("> *",this.containerNode).some(function(node){var _3bd=_3b7.byNode(node);if(_3bd&&_3bd.resize){_3bb.push(_3bd);}else{if(!/script|link|style/i.test(node.nodeName)&&node.offsetHeight){_3bc=true;}}});this._singleChild=_3bb.length==1&&!_3bc?_3bb[0]:null;_3b3.toggle(this.containerNode,this.baseClass+"SingleChild",!!this._singleChild);},resize:function(_3be,_3bf){this._resizeCalled=true;this._scheduleLayout(_3be,_3bf);},_scheduleLayout:function(_3c0,_3c1){if(this._isShown()){this._layout(_3c0,_3c1);}else{this._needLayout=true;this._changeSize=_3c0;this._resultSize=_3c1;}},_layout:function(_3c2,_3c3){delete this._needLayout;if(!this._wasShown&&this.open!==false){this._onShow();}if(_3c2){_3b4.setMarginBox(this.domNode,_3c2);}var cn=this.containerNode;if(cn===this.domNode){var mb=_3c3||{};lang.mixin(mb,_3c2||{});if(!("h" in mb)||!("w" in mb)){mb=lang.mixin(_3b4.getMarginBox(cn),mb);}this._contentBox=_3b9.marginBox2contentBox(cn,mb);}else{this._contentBox=_3b4.getContentBox(cn);}this._layoutChildren();},_layoutChildren:function(){if(this.doLayout){this._checkIfSingleChild();}if(this._singleChild&&this._singleChild.resize){var cb=this._contentBox||_3b4.getContentBox(this.containerNode);this._singleChild.resize({w:cb.w,h:cb.h});}else{var _3c4=this.getChildren(),_3c5,i=0;while(_3c5=_3c4[i++]){if(_3c5.resize){_3c5.resize();}}}},_isShown:function(){if(this._childOfLayoutWidget){if(this._resizeCalled&&"open" in this){return this.open;}return this._resizeCalled;}else{if("open" in this){return this.open;}else{var node=this.domNode,_3c6=this.domNode.parentNode;return (node.style.display!="none")&&(node.style.visibility!="hidden")&&!_3b3.contains(node,"dijitHidden")&&_3c6&&_3c6.style&&(_3c6.style.display!="none");}}},_onShow:function(){this._wasShown=true;if(this._needLayout){this._layout(this._changeSize,this._resultSize);}this.inherited(arguments);}});});},"dijit/form/RangeBoundTextBox":function(){define(["dojo/_base/declare","dojo/i18n","./MappedTextBox"],function(_3c7,i18n,_3c8){var _3c9=_3c7("dijit.form.RangeBoundTextBox",_3c8,{rangeMessage:"",rangeCheck:function(_3ca,_3cb){return ("min" in _3cb?(this.compare(_3ca,_3cb.min)>=0):true)&&("max" in _3cb?(this.compare(_3ca,_3cb.max)<=0):true);},isInRange:function(){return this.rangeCheck(this.get("value"),this.constraints);},_isDefinitelyOutOfRange:function(){var val=this.get("value");if(val==null){return false;}var _3cc=false;if("min" in this.constraints){var min=this.constraints.min;_3cc=this.compare(val,((typeof min=="number")&&min>=0&&val!=0)?0:min)<0;}if(!_3cc&&("max" in this.constraints)){var max=this.constraints.max;_3cc=this.compare(val,((typeof max!="number")||max>0)?max:0)>0;}return _3cc;},_isValidSubset:function(){return this.inherited(arguments)&&!this._isDefinitelyOutOfRange();},isValid:function(_3cd){return this.inherited(arguments)&&((this._isEmpty(this.textbox.value)&&!this.required)||this.isInRange(_3cd));},getErrorMessage:function(_3ce){var v=this.get("value");if(v!=null&&v!==""&&(typeof v!="number"||!isNaN(v))&&!this.isInRange(_3ce)){return this.rangeMessage;}return this.inherited(arguments);},postMixInProperties:function(){this.inherited(arguments);if(!this.rangeMessage){this.messages=i18n.getLocalization("dijit.form","validate",this.lang);this.rangeMessage=this.messages.rangeMessage;}}});return _3c9;});},"dijit/_editor/RichText":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/query","dojo/domReady","dojo/sniff","dojo/topic","dojo/_base/unload","dojo/_base/url","dojo/window","../_Widget","../_CssStateMixin","../selection","./range","./html","../focus","../main"],function(_3cf,_3d0,_3d1,_3d2,dom,_3d3,_3d4,_3d5,_3d6,_3d7,_3d8,keys,lang,on,_3d9,_3da,has,_3db,_3dc,_3dd,_3de,_3df,_3e0,_3e1,_3e2,_3e3,_3e4,_3e5){var _3e6=_3d1("dijit._editor.RichText",[_3df,_3e0],{constructor:function(_3e7){this.contentPreFilters=[];this.contentPostFilters=[];this.contentDomPreFilters=[];this.contentDomPostFilters=[];this.editingAreaStyleSheets=[];this.events=[].concat(this.events);this._keyHandlers={};if(_3e7&&lang.isString(_3e7.value)){this.value=_3e7.value;}this.onLoadDeferred=new _3d2();},baseClass:"dijitEditor",inheritWidth:false,focusOnLoad:false,name:"",styleSheets:"",height:"300px",minHeight:"1em",isClosed:true,isLoaded:false,_SEPARATOR:"@@**%%__RICHTEXTBOUNDRY__%%**@@",_NAME_CONTENT_SEP:"@@**%%:%%**@@",onLoadDeferred:null,isTabIndent:false,disableSpellCheck:false,postCreate:function(){if("textarea"===this.domNode.tagName.toLowerCase()){console.warn("RichText should not be used with the TEXTAREA tag.  See dijit._editor.RichText docs.");}this.contentPreFilters=[lang.hitch(this,"_preFixUrlAttributes")].concat(this.contentPreFilters);if(has("mozilla")){this.contentPreFilters=[this._normalizeFontStyle].concat(this.contentPreFilters);this.contentPostFilters=[this._removeMozBogus].concat(this.contentPostFilters);}if(has("webkit")){this.contentPreFilters=[this._removeWebkitBogus].concat(this.contentPreFilters);this.contentPostFilters=[this._removeWebkitBogus].concat(this.contentPostFilters);}if(has("ie")){this.contentPostFilters=[this._normalizeFontStyle].concat(this.contentPostFilters);this.contentDomPostFilters=[lang.hitch(this,this._stripBreakerNodes)].concat(this.contentDomPostFilters);}this.inherited(arguments);_3db.publish(_3e5._scopeName+"._editor.RichText::init",this);},startup:function(){this.inherited(arguments);this.open();this.setupDefaultShortcuts();},setupDefaultShortcuts:function(){var exec=lang.hitch(this,function(cmd,arg){return function(){return !this.execCommand(cmd,arg);};});var _3e8={b:exec("bold"),i:exec("italic"),u:exec("underline"),a:exec("selectall"),s:function(){this.save(true);},m:function(){this.isTabIndent=!this.isTabIndent;},"1":exec("formatblock","h1"),"2":exec("formatblock","h2"),"3":exec("formatblock","h3"),"4":exec("formatblock","h4"),"\\":exec("insertunorderedlist")};if(!has("ie")){_3e8.Z=exec("redo");}var key;for(key in _3e8){this.addKeyHandler(key,true,false,_3e8[key]);}},events:["onKeyDown","onKeyUp"],captureEvents:[],_editorCommandsLocalized:false,_localizeEditorCommands:function(){if(_3e6._editorCommandsLocalized){this._local2NativeFormatNames=_3e6._local2NativeFormatNames;this._native2LocalFormatNames=_3e6._native2LocalFormatNames;return;}_3e6._editorCommandsLocalized=true;_3e6._local2NativeFormatNames={};_3e6._native2LocalFormatNames={};this._local2NativeFormatNames=_3e6._local2NativeFormatNames;this._native2LocalFormatNames=_3e6._native2LocalFormatNames;var _3e9=["div","p","pre","h1","h2","h3","h4","h5","h6","ol","ul","address"];var _3ea="",_3eb,i=0;while((_3eb=_3e9[i++])){if(_3eb.charAt(1)!=="l"){_3ea+="<"+_3eb+"><span>content</span></"+_3eb+"><br/>";}else{_3ea+="<"+_3eb+"><li>content</li></"+_3eb+"><br/>";}}var _3ec={position:"absolute",top:"0px",zIndex:10,opacity:0.01};var div=_3d5.create("div",{style:_3ec,innerHTML:_3ea});this.ownerDocumentBody.appendChild(div);var _3ed=lang.hitch(this,function(){var node=div.firstChild;while(node){try{this.selection.selectElement(node.firstChild);var _3ee=node.tagName.toLowerCase();this._local2NativeFormatNames[_3ee]=document.queryCommandValue("formatblock");this._native2LocalFormatNames[this._local2NativeFormatNames[_3ee]]=_3ee;node=node.nextSibling.nextSibling;}catch(e){}}_3d5.destroy(div);});this.defer(_3ed);},open:function(_3ef){if(!this.onLoadDeferred||this.onLoadDeferred.fired>=0){this.onLoadDeferred=new _3d2();}if(!this.isClosed){this.close();}_3db.publish(_3e5._scopeName+"._editor.RichText::open",this);if(arguments.length===1&&_3ef.nodeName){this.domNode=_3ef;}var dn=this.domNode;var html;if(lang.isString(this.value)){html=this.value;delete this.value;dn.innerHTML="";}else{if(dn.nodeName&&dn.nodeName.toLowerCase()=="textarea"){var ta=(this.textarea=dn);this.name=ta.name;html=ta.value;dn=this.domNode=this.ownerDocument.createElement("div");dn.setAttribute("widgetId",this.id);ta.removeAttribute("widgetId");dn.cssText=ta.cssText;dn.className+=" "+ta.className;_3d5.place(dn,ta,"before");var _3f0=lang.hitch(this,function(){_3d7.set(ta,{display:"block",position:"absolute",top:"-1000px"});if(has("ie")){var s=ta.style;this.__overflow=s.overflow;s.overflow="hidden";}});if(has("ie")){this.defer(_3f0,10);}else{_3f0();}if(ta.form){var _3f1=ta.value;this.reset=function(){var _3f2=this.getValue();if(_3f2!==_3f1){this.replaceValue(_3f1);}};on(ta.form,"submit",lang.hitch(this,function(){_3d3.set(ta,"disabled",this.disabled);ta.value=this.getValue();}));}}else{html=_3e3.getChildrenHtml(dn);dn.innerHTML="";}}this.value=html;if(dn.nodeName&&dn.nodeName==="LI"){dn.innerHTML=" <br>";}this.header=dn.ownerDocument.createElement("div");dn.appendChild(this.header);this.editingArea=dn.ownerDocument.createElement("div");dn.appendChild(this.editingArea);this.footer=dn.ownerDocument.createElement("div");dn.appendChild(this.footer);if(!this.name){this.name=this.id+"_AUTOGEN";}if(this.name!==""&&(!_3d0["useXDomain"]||_3d0["allowXdRichTextSave"])){var _3f3=dom.byId(_3e5._scopeName+"._editor.RichText.value");if(_3f3&&_3f3.value!==""){var _3f4=_3f3.value.split(this._SEPARATOR),i=0,dat;while((dat=_3f4[i++])){var data=dat.split(this._NAME_CONTENT_SEP);if(data[0]===this.name){html=data[1];_3f4=_3f4.splice(i,1);_3f3.value=_3f4.join(this._SEPARATOR);break;}}}if(!_3e6._globalSaveHandler){_3e6._globalSaveHandler={};_3dc.addOnUnload(function(){var id;for(id in _3e6._globalSaveHandler){var f=_3e6._globalSaveHandler[id];if(lang.isFunction(f)){f();}}});}_3e6._globalSaveHandler[this.id]=lang.hitch(this,"_saveContent");}this.isClosed=false;var ifr=(this.editorObject=this.iframe=this.ownerDocument.createElement("iframe"));ifr.id=this.id+"_iframe";ifr.style.border="none";ifr.style.width="100%";if(this._layoutMode){ifr.style.height="100%";}else{if(has("ie")>=7){if(this.height){ifr.style.height=this.height;}if(this.minHeight){ifr.style.minHeight=this.minHeight;}}else{ifr.style.height=this.height?this.height:this.minHeight;}}ifr.frameBorder=0;ifr._loadFunc=lang.hitch(this,function(w){this.window=w;this.document=this.window.document;this.selection=new _3e1.SelectionManager(w);if(has("ie")){this._localizeEditorCommands();}this.onLoad(html);});var src=this._getIframeDocTxt(),s="javascript: '"+src.replace(/\\/g,"\\\\").replace(/'/g,"\\'")+"'";if(has("ie")>=9){this.editingArea.appendChild(ifr);ifr.src=s;}else{ifr.setAttribute("src",s);this.editingArea.appendChild(ifr);}if(dn.nodeName==="LI"){dn.lastChild.style.marginTop="-1.2em";}_3d4.add(this.domNode,this.baseClass);},_local2NativeFormatNames:{},_native2LocalFormatNames:{},_getIframeDocTxt:function(){var _3f5=_3d7.getComputedStyle(this.domNode);var html="";var _3f6=true;if(has("ie")||has("webkit")||(!this.height&&!has("mozilla"))){html="<div id='dijitEditorBody'></div>";_3f6=false;}else{if(has("mozilla")){this._cursorToStart=true;html="&#160;";}}var font=[_3f5.fontWeight,_3f5.fontSize,_3f5.fontFamily].join(" ");var _3f7=_3f5.lineHeight;if(_3f7.indexOf("px")>=0){_3f7=parseFloat(_3f7)/parseFloat(_3f5.fontSize);}else{if(_3f7.indexOf("em")>=0){_3f7=parseFloat(_3f7);}else{_3f7="normal";}}var _3f8="";var self=this;this.style.replace(/(^|;)\s*(line-|font-?)[^;]+/ig,function(_3f9){_3f9=_3f9.replace(/^;/ig,"")+";";var s=_3f9.split(":")[0];if(s){s=lang.trim(s);s=s.toLowerCase();var i;var sC="";for(i=0;i<s.length;i++){var c=s.charAt(i);switch(c){case "-":i++;c=s.charAt(i).toUpperCase();default:sC+=c;}}_3d7.set(self.domNode,sC,"");}_3f8+=_3f9+";";});var _3fa=_3d9("label[for=\""+this.id+"\"]");var _3fb="";if(_3fa.length){_3fb=_3fa[0].innerHTML;}else{if(this["aria-label"]){_3fb=this["aria-label"];}else{if(this["aria-labelledby"]){_3fb=dom.byId(this["aria-labelledby"]).innerHTML;}}}this.iframe.setAttribute("title",_3fb);return ["<!DOCTYPE html>",this.isLeftToRight()?"<html lang='"+this.lang+"'>\n<head>\n":"<html dir='rtl' lang='"+this.lang+"'>\n<head>\n",_3fb?"<title>"+_3fb+"</title>":"","<meta http-equiv='Content-Type' content='text/html'>\n","<style>\n","\tbody,html {\n","\t\tbackground:transparent;\n","\t\tpadding: 1px 0 0 0;\n","\t\tmargin: -1px 0 0 0;\n","\t}\n","\tbody,html, #dijitEditorBody{ outline: none; }","html { height: 100%; width: 100%; overflow: hidden; }\n",this.height?"\tbody { height: 100%; width: 100%; overflow: auto; }\n":"\tbody { min-height: "+this.minHeight+"; width: 100%; overflow-x: auto; overflow-y: hidden; }\n","\tbody{\n","\t\ttop:0px;\n","\t\tleft:0px;\n","\t\tright:0px;\n","\t\tfont:",font,";\n",((this.height||has("opera"))?"":"\t\tposition: fixed;\n"),"\t\tline-height:",_3f7,";\n","\t}\n","\tp{ margin: 1em 0; }\n","\tli > ul:-moz-first-node, li > ol:-moz-first-node{ padding-top: 1.2em; }\n",(!has("ie")?"\tli{ min-height:1.2em; }\n":""),"</style>\n",this._applyEditingAreaStyleSheets(),"\n","</head>\n<body role='main' ",(_3f6?"id='dijitEditorBody' ":""),"onload='frameElement && frameElement._loadFunc(window,document)' ","style='"+_3f8+"'>",html,"</body>\n</html>"].join("");},_applyEditingAreaStyleSheets:function(){var _3fc=[];if(this.styleSheets){_3fc=this.styleSheets.split(";");this.styleSheets="";}_3fc=_3fc.concat(this.editingAreaStyleSheets);this.editingAreaStyleSheets=[];var text="",i=0,url,_3fd=_3de.get(this.ownerDocument);while((url=_3fc[i++])){var _3fe=(new _3dd(_3fd.location,url)).toString();this.editingAreaStyleSheets.push(_3fe);text+="<link rel=\"stylesheet\" type=\"text/css\" href=\""+_3fe+"\"/>";}return text;},addStyleSheet:function(uri){var url=uri.toString(),_3ff=_3de.get(this.ownerDocument);if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){url=(new _3dd(_3ff.location,url)).toString();}if(_3cf.indexOf(this.editingAreaStyleSheets,url)>-1){return;}this.editingAreaStyleSheets.push(url);this.onLoadDeferred.then(lang.hitch(this,function(){if(this.document.createStyleSheet){this.document.createStyleSheet(url);}else{var head=this.document.getElementsByTagName("head")[0];var _400=this.document.createElement("link");_400.rel="stylesheet";_400.type="text/css";_400.href=url;head.appendChild(_400);}}));},removeStyleSheet:function(uri){var url=uri.toString(),_401=_3de.get(this.ownerDocument);if(url.charAt(0)==="."||(url.charAt(0)!=="/"&&!uri.host)){url=(new _3dd(_401.location,url)).toString();}var _402=_3cf.indexOf(this.editingAreaStyleSheets,url);if(_402===-1){return;}delete this.editingAreaStyleSheets[_402];_3d9("link[href=\""+url+"\"]",this.window.document).orphan();},disabled:false,_mozSettingProps:{"styleWithCSS":false},_setDisabledAttr:function(_403){_403=!!_403;this._set("disabled",_403);if(!this.isLoaded){return;}if(has("ie")||has("webkit")||has("opera")){var _404=has("ie")&&(this.isLoaded||!this.focusOnLoad);if(_404){this.editNode.unselectable="on";}this.editNode.contentEditable=!_403;if(_404){this.defer(function(){if(this.editNode){this.editNode.unselectable="off";}});}}else{try{this.document.designMode=(_403?"off":"on");}catch(e){return;}if(!_403&&this._mozSettingProps){var ps=this._mozSettingProps;var n;for(n in ps){if(ps.hasOwnProperty(n)){try{this.document.execCommand(n,false,ps[n]);}catch(e2){}}}}}this._disabledOK=true;},onLoad:function(html){if(!this.window.__registeredWindow){this.window.__registeredWindow=true;this._iframeRegHandle=_3e4.registerIframe(this.iframe);}if(!has("ie")&&!has("webkit")&&(this.height||has("mozilla"))){this.editNode=this.document.body;}else{this.editNode=this.document.body.firstChild;var _405=this;if(has("ie")){this.tabStop=_3d5.create("div",{tabIndex:-1},this.editingArea);this.iframe.onfocus=function(){_405.editNode.setActive();};}}this.focusNode=this.editNode;var _406=this.events.concat(this.captureEvents);var ap=this.iframe?this.document:this.editNode;this.own(_3cf.map(_406,function(item){var type=item.toLowerCase().replace(/^on/,"");on(ap,type,lang.hitch(this,item));},this));this.own(on(ap,"mouseup",lang.hitch(this,"onClick")));if(has("ie")){this.own(on(this.document,"mousedown",lang.hitch(this,"_onIEMouseDown")));this.editNode.style.zoom=1;}else{this.own(on(this.document,"mousedown",lang.hitch(this,function(){delete this._cursorToStart;})));}if(has("webkit")){this._webkitListener=this.own(on(this.document,"mouseup",lang.hitch(this,"onDisplayChanged")))[0];this.own(on(this.document,"mousedown",lang.hitch(this,function(e){var t=e.target;if(t&&(t===this.document.body||t===this.document)){this.defer("placeCursorAtEnd");}})));}if(has("ie")){try{this.document.execCommand("RespectVisibilityInDesign",true,null);}catch(e){}}this.isLoaded=true;this.set("disabled",this.disabled);var _407=lang.hitch(this,function(){this.setValue(html);if(this.onLoadDeferred){this.onLoadDeferred.resolve(true);}this.onDisplayChanged();if(this.focusOnLoad){_3da(lang.hitch(this,"defer","focus",this.updateInterval));}this.value=this.getValue(true);});if(this.setValueDeferred){this.setValueDeferred.then(_407);}else{_407();}},onKeyDown:function(e){if(e.keyCode===keys.TAB&&this.isTabIndent){e.stopPropagation();e.preventDefault();if(this.queryCommandEnabled((e.shiftKey?"outdent":"indent"))){this.execCommand((e.shiftKey?"outdent":"indent"));}}if(has("ie")){if(e.keyCode==keys.TAB&&!this.isTabIndent){if(e.shiftKey&&!e.ctrlKey&&!e.altKey){this.iframe.focus();}else{if(!e.shiftKey&&!e.ctrlKey&&!e.altKey){this.tabStop.focus();}}}else{if(e.keyCode===keys.BACKSPACE&&this.document.selection.type==="Control"){e.stopPropagation();e.preventDefault();this.execCommand("delete");}}}if(has("ff")){if(e.keyCode===keys.PAGE_UP||e.keyCode===keys.PAGE_DOWN){if(this.editNode.clientHeight>=this.editNode.scrollHeight){e.preventDefault();}}}var _408=this._keyHandlers[e.keyCode],args=arguments;if(_408&&!e.altKey){_3cf.some(_408,function(h){if(!(h.shift^e.shiftKey)&&!(h.ctrl^(e.ctrlKey||e.metaKey))){if(!h.handler.apply(this,args)){e.preventDefault();}return true;}},this);}this.defer("onKeyPressed",1);return true;},onKeyUp:function(){},setDisabled:function(_409){_3d8.deprecated("dijit.Editor::setDisabled is deprecated","use dijit.Editor::attr(\"disabled\",boolean) instead",2);this.set("disabled",_409);},_setValueAttr:function(_40a){this.setValue(_40a);},_setDisableSpellCheckAttr:function(_40b){if(this.document){_3d3.set(this.document.body,"spellcheck",!_40b);}else{this.onLoadDeferred.then(lang.hitch(this,function(){_3d3.set(this.document.body,"spellcheck",!_40b);}));}this._set("disableSpellCheck",_40b);},addKeyHandler:function(key,ctrl,_40c,_40d){if(typeof key=="string"){key=key.toUpperCase().charCodeAt(0);}if(!lang.isArray(this._keyHandlers[key])){this._keyHandlers[key]=[];}this._keyHandlers[key].push({shift:_40c||false,ctrl:ctrl||false,handler:_40d});},onKeyPressed:function(){this.onDisplayChanged();},onClick:function(e){this.onDisplayChanged(e);},_onIEMouseDown:function(){if(!this.focused&&!this.disabled){this.focus();}},_onBlur:function(e){if(has("ie")>=9){this.defer(function(){if(!_3e4.curNode){this.ownerDocumentBody.focus();}});}this.inherited(arguments);var _40e=this.getValue(true);if(_40e!==this.value){this.onChange(_40e);}this._set("value",_40e);},_onFocus:function(e){if(!this.disabled){if(!this._disabledOK){this.set("disabled",false);}this.inherited(arguments);}},blur:function(){if(!has("ie")&&this.window.document.documentElement&&this.window.document.documentElement.focus){this.window.document.documentElement.focus();}else{if(this.ownerDocumentBody.focus){this.ownerDocumentBody.focus();}}},focus:function(){if(!this.isLoaded){this.focusOnLoad=true;return;}if(this._cursorToStart){delete this._cursorToStart;if(this.editNode.childNodes){this.placeCursorAtStart();return;}}if(!has("ie")){_3e4.focus(this.iframe);}else{if(this.editNode&&this.editNode.focus){this.iframe.fireEvent("onfocus",document.createEventObject());}}},updateInterval:200,_updateTimer:null,onDisplayChanged:function(){if(this._updateTimer){this._updateTimer.remove();}this._updateTimer=this.defer("onNormalizedDisplayChanged",this.updateInterval);},onNormalizedDisplayChanged:function(){delete this._updateTimer;},onChange:function(){},_normalizeCommand:function(cmd,_40f){var _410=cmd.toLowerCase();if(_410==="formatblock"){if(has("safari")&&_40f===undefined){_410="heading";}}else{if(_410==="hilitecolor"&&!has("mozilla")){_410="backcolor";}}return _410;},_qcaCache:{},queryCommandAvailable:function(_411){var ca=this._qcaCache[_411];if(ca!==undefined){return ca;}return (this._qcaCache[_411]=this._queryCommandAvailable(_411));},_queryCommandAvailable:function(_412){var ie=1;var _413=1<<1;var _414=1<<2;var _415=1<<3;function _416(_417){return {ie:Boolean(_417&ie),mozilla:Boolean(_417&_413),webkit:Boolean(_417&_414),opera:Boolean(_417&_415)};};var _418=null;switch(_412.toLowerCase()){case "bold":case "italic":case "underline":case "subscript":case "superscript":case "fontname":case "fontsize":case "forecolor":case "hilitecolor":case "justifycenter":case "justifyfull":case "justifyleft":case "justifyright":case "delete":case "selectall":case "toggledir":_418=_416(_413|ie|_414|_415);break;case "createlink":case "unlink":case "removeformat":case "inserthorizontalrule":case "insertimage":case "insertorderedlist":case "insertunorderedlist":case "indent":case "outdent":case "formatblock":case "inserthtml":case "undo":case "redo":case "strikethrough":case "tabindent":_418=_416(_413|ie|_415|_414);break;case "blockdirltr":case "blockdirrtl":case "dirltr":case "dirrtl":case "inlinedirltr":case "inlinedirrtl":_418=_416(ie);break;case "cut":case "copy":case "paste":_418=_416(ie|_413|_414|_415);break;case "inserttable":_418=_416(_413|ie);break;case "insertcell":case "insertcol":case "insertrow":case "deletecells":case "deletecols":case "deleterows":case "mergecells":case "splitcell":_418=_416(ie|_413);break;default:return false;}return (has("ie")&&_418.ie)||(has("mozilla")&&_418.mozilla)||(has("webkit")&&_418.webkit)||(has("opera")&&_418.opera);},execCommand:function(_419,_41a){var _41b;if(this.focused){this.focus();}_419=this._normalizeCommand(_419,_41a);if(_41a!==undefined){if(_419==="heading"){throw new Error("unimplemented");}else{if((_419==="formatblock")&&has("ie")){_41a="<"+_41a+">";}}}var _41c="_"+_419+"Impl";if(this[_41c]){_41b=this[_41c](_41a);}else{_41a=arguments.length>1?_41a:null;if(_41a||_419!=="createlink"){_41b=this.document.execCommand(_419,false,_41a);}}this.onDisplayChanged();return _41b;},queryCommandEnabled:function(_41d){if(this.disabled||!this._disabledOK){return false;}_41d=this._normalizeCommand(_41d);var _41e="_"+_41d+"EnabledImpl";if(this[_41e]){return this[_41e](_41d);}else{return this._browserQueryCommandEnabled(_41d);}},queryCommandState:function(_41f){if(this.disabled||!this._disabledOK){return false;}_41f=this._normalizeCommand(_41f);try{return this.document.queryCommandState(_41f);}catch(e){return false;}},queryCommandValue:function(_420){if(this.disabled||!this._disabledOK){return false;}var r;_420=this._normalizeCommand(_420);if(has("ie")&&_420==="formatblock"){r=this._native2LocalFormatNames[this.document.queryCommandValue(_420)];}else{if(has("mozilla")&&_420==="hilitecolor"){var _421;try{_421=this.document.queryCommandValue("styleWithCSS");}catch(e){_421=false;}this.document.execCommand("styleWithCSS",false,true);r=this.document.queryCommandValue(_420);this.document.execCommand("styleWithCSS",false,_421);}else{r=this.document.queryCommandValue(_420);}}return r;},_sCall:function(name,args){return this.selection[name].apply(this.selection,args);},placeCursorAtStart:function(){this.focus();var _422=false;if(has("mozilla")){var _423=this.editNode.firstChild;while(_423){if(_423.nodeType===3){if(_423.nodeValue.replace(/^\s+|\s+$/g,"").length>0){_422=true;this.selection.selectElement(_423);break;}}else{if(_423.nodeType===1){_422=true;var tg=_423.tagName?_423.tagName.toLowerCase():"";if(/br|input|img|base|meta|area|basefont|hr|link/.test(tg)){this.selection.selectElement(_423);}else{this.selection.selectElementChildren(_423);}break;}}_423=_423.nextSibling;}}else{_422=true;this.selection.selectElementChildren(this.editNode);}if(_422){this.selection.collapse(true);}},placeCursorAtEnd:function(){this.focus();var _424=false;if(has("mozilla")){var last=this.editNode.lastChild;while(last){if(last.nodeType===3){if(last.nodeValue.replace(/^\s+|\s+$/g,"").length>0){_424=true;this.selection.selectElement(last);break;}}else{if(last.nodeType===1){_424=true;this.selection.selectElement(last.lastChild||last);break;}}last=last.previousSibling;}}else{_424=true;this.selection.selectElementChildren(this.editNode);}if(_424){this.selection.collapse(false);}},getValue:function(_425){if(this.textarea){if(this.isClosed||!this.isLoaded){return this.textarea.value;}}return this._postFilterContent(null,_425);},_getValueAttr:function(){return this.getValue(true);},setValue:function(html){if(!this.isLoaded){this.onLoadDeferred.then(lang.hitch(this,function(){this.setValue(html);}));return;}this._cursorToStart=true;if(this.textarea&&(this.isClosed||!this.isLoaded)){this.textarea.value=html;}else{html=this._preFilterContent(html);var node=this.isClosed?this.domNode:this.editNode;if(html&&has("mozilla")&&html.toLowerCase()==="<p></p>"){html="<p>&#160;</p>";}if(!html&&has("webkit")){html="&#160;";}node.innerHTML=html;this._preDomFilterContent(node);}this.onDisplayChanged();this._set("value",this.getValue(true));},replaceValue:function(html){if(this.isClosed){this.setValue(html);}else{if(this.window&&this.window.getSelection&&!has("mozilla")){this.setValue(html);}else{if(this.window&&this.window.getSelection){html=this._preFilterContent(html);this.execCommand("selectall");if(!html){this._cursorToStart=true;html="&#160;";}this.execCommand("inserthtml",html);this._preDomFilterContent(this.editNode);}else{if(this.document&&this.document.selection){this.setValue(html);}}}}this._set("value",this.getValue(true));},_preFilterContent:function(html){var ec=html;_3cf.forEach(this.contentPreFilters,function(ef){if(ef){ec=ef(ec);}});return ec;},_preDomFilterContent:function(dom){dom=dom||this.editNode;_3cf.forEach(this.contentDomPreFilters,function(ef){if(ef&&lang.isFunction(ef)){ef(dom);}},this);},_postFilterContent:function(dom,_426){var ec;if(!lang.isString(dom)){dom=dom||this.editNode;if(this.contentDomPostFilters.length){if(_426){dom=lang.clone(dom);}_3cf.forEach(this.contentDomPostFilters,function(ef){dom=ef(dom);});}ec=_3e3.getChildrenHtml(dom);}else{ec=dom;}if(!lang.trim(ec.replace(/^\xA0\xA0*/,"").replace(/\xA0\xA0*$/,"")).length){ec="";}_3cf.forEach(this.contentPostFilters,function(ef){ec=ef(ec);});return ec;},_saveContent:function(){var _427=dom.byId(_3e5._scopeName+"._editor.RichText.value");if(_427){if(_427.value){_427.value+=this._SEPARATOR;}_427.value+=this.name+this._NAME_CONTENT_SEP+this.getValue(true);}},escapeXml:function(str,_428){str=str.replace(/&/gm,"&amp;").replace(/</gm,"&lt;").replace(/>/gm,"&gt;").replace(/"/gm,"&quot;");if(!_428){str=str.replace(/'/gm,"&#39;");}return str;},getNodeHtml:function(node){_3d8.deprecated("dijit.Editor::getNodeHtml is deprecated","use dijit/_editor/html::getNodeHtml instead",2);return _3e3.getNodeHtml(node);},getNodeChildrenHtml:function(dom){_3d8.deprecated("dijit.Editor::getNodeChildrenHtml is deprecated","use dijit/_editor/html::getChildrenHtml instead",2);return _3e3.getChildrenHtml(dom);},close:function(save){if(this.isClosed){return;}if(!arguments.length){save=true;}if(save){this._set("value",this.getValue(true));}if(this.interval){clearInterval(this.interval);}if(this._webkitListener){this._webkitListener.remove();delete this._webkitListener;}if(has("ie")){this.iframe.onfocus=null;}this.iframe._loadFunc=null;if(this._iframeRegHandle){this._iframeRegHandle.remove();delete this._iframeRegHandle;}if(this.textarea){var s=this.textarea.style;s.position="";s.left=s.top="";if(has("ie")){s.overflow=this.__overflow;this.__overflow=null;}this.textarea.value=this.value;_3d5.destroy(this.domNode);this.domNode=this.textarea;}else{this.domNode.innerHTML=this.value;}delete this.iframe;_3d4.remove(this.domNode,this.baseClass);this.isClosed=true;this.isLoaded=false;delete this.editNode;delete this.focusNode;if(this.window&&this.window._frameElement){this.window._frameElement=null;}this.window=null;this.document=null;this.editingArea=null;this.editorObject=null;},destroy:function(){if(!this.isClosed){this.close(false);}if(this._updateTimer){this._updateTimer.remove();}this.inherited(arguments);if(_3e6._globalSaveHandler){delete _3e6._globalSaveHandler[this.id];}},_removeMozBogus:function(html){return html.replace(/\stype="_moz"/gi,"").replace(/\s_moz_dirty=""/gi,"").replace(/_moz_resizing="(true|false)"/gi,"");},_removeWebkitBogus:function(html){html=html.replace(/\sclass="webkit-block-placeholder"/gi,"");html=html.replace(/\sclass="apple-style-span"/gi,"");html=html.replace(/<meta charset=\"utf-8\" \/>/gi,"");return html;},_normalizeFontStyle:function(html){return html.replace(/<(\/)?strong([ \>])/gi,"<$1b$2").replace(/<(\/)?em([ \>])/gi,"<$1i$2");},_preFixUrlAttributes:function(html){return html.replace(/(?:(<a(?=\s).*?\shref=)("|')(.*?)\2)|(?:(<a\s.*?href=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2").replace(/(?:(<img(?=\s).*?\ssrc=)("|')(.*?)\2)|(?:(<img\s.*?src=)([^"'][^ >]+))/gi,"$1$4$2$3$5$2 _djrealurl=$2$3$5$2");},_browserQueryCommandEnabled:function(_429){if(!_429){return false;}var elem=has("ie")?this.document.selection.createRange():this.document;try{return elem.queryCommandEnabled(_429);}catch(e){return false;}},_createlinkEnabledImpl:function(){var _42a=true;if(has("opera")){var sel=this.window.getSelection();if(sel.isCollapsed){_42a=true;}else{_42a=this.document.queryCommandEnabled("createlink");}}else{_42a=this._browserQueryCommandEnabled("createlink");}return _42a;},_unlinkEnabledImpl:function(){var _42b=true;if(has("mozilla")||has("webkit")){_42b=this.selection.hasAncestorElement("a");}else{_42b=this._browserQueryCommandEnabled("unlink");}return _42b;},_inserttableEnabledImpl:function(){var _42c=true;if(has("mozilla")||has("webkit")){_42c=true;}else{_42c=this._browserQueryCommandEnabled("inserttable");}return _42c;},_cutEnabledImpl:function(){var _42d=true;if(has("webkit")){var sel=this.window.getSelection();if(sel){sel=sel.toString();}_42d=!!sel;}else{_42d=this._browserQueryCommandEnabled("cut");}return _42d;},_copyEnabledImpl:function(){var _42e=true;if(has("webkit")){var sel=this.window.getSelection();if(sel){sel=sel.toString();}_42e=!!sel;}else{_42e=this._browserQueryCommandEnabled("copy");}return _42e;},_pasteEnabledImpl:function(){var _42f=true;if(has("webkit")){return true;}else{_42f=this._browserQueryCommandEnabled("paste");}return _42f;},_inserthorizontalruleImpl:function(_430){if(has("ie")){return this._inserthtmlImpl("<hr>");}return this.document.execCommand("inserthorizontalrule",false,_430);},_unlinkImpl:function(_431){if((this.queryCommandEnabled("unlink"))&&(has("mozilla")||has("webkit"))){var a=this.selection.getAncestorElement("a");this.selection.selectElement(a);return this.document.execCommand("unlink",false,null);}return this.document.execCommand("unlink",false,_431);},_hilitecolorImpl:function(_432){var _433;var _434=this._handleTextColorOrProperties("hilitecolor",_432);if(!_434){if(has("mozilla")){this.document.execCommand("styleWithCSS",false,true);_433=this.document.execCommand("hilitecolor",false,_432);this.document.execCommand("styleWithCSS",false,false);}else{_433=this.document.execCommand("hilitecolor",false,_432);}}return _433;},_backcolorImpl:function(_435){if(has("ie")){_435=_435?_435:null;}var _436=this._handleTextColorOrProperties("backcolor",_435);if(!_436){_436=this.document.execCommand("backcolor",false,_435);}return _436;},_forecolorImpl:function(_437){if(has("ie")){_437=_437?_437:null;}var _438=false;_438=this._handleTextColorOrProperties("forecolor",_437);if(!_438){_438=this.document.execCommand("forecolor",false,_437);}return _438;},_inserthtmlImpl:function(_439){_439=this._preFilterContent(_439);var rv=true;if(has("ie")){var _43a=this.document.selection.createRange();if(this.document.selection.type.toUpperCase()==="CONTROL"){var n=_43a.item(0);while(_43a.length){_43a.remove(_43a.item(0));}n.outerHTML=_439;}else{_43a.pasteHTML(_439);}_43a.select();}else{if(has("mozilla")&&!_439.length){this.selection.remove();}else{rv=this.document.execCommand("inserthtml",false,_439);}}return rv;},_boldImpl:function(_43b){var _43c=false;if(has("ie")){this._adaptIESelection();_43c=this._adaptIEFormatAreaAndExec("bold");}if(!_43c){_43c=this.document.execCommand("bold",false,_43b);}return _43c;},_italicImpl:function(_43d){var _43e=false;if(has("ie")){this._adaptIESelection();_43e=this._adaptIEFormatAreaAndExec("italic");}if(!_43e){_43e=this.document.execCommand("italic",false,_43d);}return _43e;},_underlineImpl:function(_43f){var _440=false;if(has("ie")){this._adaptIESelection();_440=this._adaptIEFormatAreaAndExec("underline");}if(!_440){_440=this.document.execCommand("underline",false,_43f);}return _440;},_strikethroughImpl:function(_441){var _442=false;if(has("ie")){this._adaptIESelection();_442=this._adaptIEFormatAreaAndExec("strikethrough");}if(!_442){_442=this.document.execCommand("strikethrough",false,_441);}return _442;},_superscriptImpl:function(_443){var _444=false;if(has("ie")){this._adaptIESelection();_444=this._adaptIEFormatAreaAndExec("superscript");}if(!_444){_444=this.document.execCommand("superscript",false,_443);}return _444;},_subscriptImpl:function(_445){var _446=false;if(has("ie")){this._adaptIESelection();_446=this._adaptIEFormatAreaAndExec("subscript");}if(!_446){_446=this.document.execCommand("subscript",false,_445);}return _446;},_fontnameImpl:function(_447){var _448;if(has("ie")){_448=this._handleTextColorOrProperties("fontname",_447);}if(!_448){_448=this.document.execCommand("fontname",false,_447);}return _448;},_fontsizeImpl:function(_449){var _44a;if(has("ie")){_44a=this._handleTextColorOrProperties("fontsize",_449);}if(!_44a){_44a=this.document.execCommand("fontsize",false,_449);}return _44a;},_insertorderedlistImpl:function(_44b){var _44c=false;if(has("ie")){_44c=this._adaptIEList("insertorderedlist",_44b);}if(!_44c){_44c=this.document.execCommand("insertorderedlist",false,_44b);}return _44c;},_insertunorderedlistImpl:function(_44d){var _44e=false;if(has("ie")){_44e=this._adaptIEList("insertunorderedlist",_44d);}if(!_44e){_44e=this.document.execCommand("insertunorderedlist",false,_44d);}return _44e;},getHeaderHeight:function(){return this._getNodeChildrenHeight(this.header);},getFooterHeight:function(){return this._getNodeChildrenHeight(this.footer);},_getNodeChildrenHeight:function(node){var h=0;if(node&&node.childNodes){var i;for(i=0;i<node.childNodes.length;i++){var size=_3d6.position(node.childNodes[i]);h+=size.h;}}return h;},_isNodeEmpty:function(node,_44f){if(node.nodeType===1){if(node.childNodes.length>0){return this._isNodeEmpty(node.childNodes[0],_44f);}return true;}else{if(node.nodeType===3){return (node.nodeValue.substring(_44f)==="");}}return false;},_removeStartingRangeFromRange:function(node,_450){if(node.nextSibling){_450.setStart(node.nextSibling,0);}else{var _451=node.parentNode;while(_451&&_451.nextSibling==null){_451=_451.parentNode;}if(_451){_450.setStart(_451.nextSibling,0);}}return _450;},_adaptIESelection:function(){var _452=_3e2.getSelection(this.window);if(_452&&_452.rangeCount&&!_452.isCollapsed){var _453=_452.getRangeAt(0);var _454=_453.startContainer;var _455=_453.startOffset;while(_454.nodeType===3&&_455>=_454.length&&_454.nextSibling){_455=_455-_454.length;_454=_454.nextSibling;}var _456=null;while(this._isNodeEmpty(_454,_455)&&_454!==_456){_456=_454;_453=this._removeStartingRangeFromRange(_454,_453);_454=_453.startContainer;_455=0;}_452.removeAllRanges();_452.addRange(_453);}},_adaptIEFormatAreaAndExec:function(_457){var _458=_3e2.getSelection(this.window);var doc=this.document;var rs,ret,_459,txt,_45a,_45b,_45c,_45d;if(_457&&_458&&_458.isCollapsed){var _45e=this.queryCommandValue(_457);if(_45e){var _45f=this._tagNamesForCommand(_457);_459=_458.getRangeAt(0);var fs=_459.startContainer;if(fs.nodeType===3){var _460=_459.endOffset;if(fs.length<_460){ret=this._adjustNodeAndOffset(rs,_460);fs=ret.node;_460=ret.offset;}}var _461;while(fs&&fs!==this.editNode){var _462=fs.tagName?fs.tagName.toLowerCase():"";if(_3cf.indexOf(_45f,_462)>-1){_461=fs;break;}fs=fs.parentNode;}if(_461){rs=_459.startContainer;var _463=doc.createElement(_461.tagName);_3d5.place(_463,_461,"after");if(rs&&rs.nodeType===3){var _464,_465;var _466=_459.endOffset;if(rs.length<_466){ret=this._adjustNodeAndOffset(rs,_466);rs=ret.node;_466=ret.offset;}txt=rs.nodeValue;_45a=doc.createTextNode(txt.substring(0,_466));var _467=txt.substring(_466,txt.length);if(_467){_45b=doc.createTextNode(_467);}_3d5.place(_45a,rs,"before");if(_45b){_45c=doc.createElement("span");_45c.className="ieFormatBreakerSpan";_3d5.place(_45c,rs,"after");_3d5.place(_45b,_45c,"after");_45b=_45c;}_3d5.destroy(rs);var _468=_45a.parentNode;var _469=[];var _46a;while(_468!==_461){var tg=_468.tagName;_46a={tagName:tg};_469.push(_46a);var _46b=doc.createElement(tg);if(_468.style){if(_46b.style){if(_468.style.cssText){_46b.style.cssText=_468.style.cssText;_46a.cssText=_468.style.cssText;}}}if(_468.tagName==="FONT"){if(_468.color){_46b.color=_468.color;_46a.color=_468.color;}if(_468.face){_46b.face=_468.face;_46a.face=_468.face;}if(_468.size){_46b.size=_468.size;_46a.size=_468.size;}}if(_468.className){_46b.className=_468.className;_46a.className=_468.className;}if(_45b){_464=_45b;while(_464){_465=_464.nextSibling;_46b.appendChild(_464);_464=_465;}}if(_46b.tagName==_468.tagName){_45c=doc.createElement("span");_45c.className="ieFormatBreakerSpan";_3d5.place(_45c,_468,"after");_3d5.place(_46b,_45c,"after");}else{_3d5.place(_46b,_468,"after");}_45a=_468;_45b=_46b;_468=_468.parentNode;}if(_45b){_464=_45b;if(_464.nodeType===1||(_464.nodeType===3&&_464.nodeValue)){_463.innerHTML="";}while(_464){_465=_464.nextSibling;_463.appendChild(_464);_464=_465;}}var _46c;if(_469.length){_46a=_469.pop();var _46d=doc.createElement(_46a.tagName);if(_46a.cssText&&_46d.style){_46d.style.cssText=_46a.cssText;}if(_46a.className){_46d.className=_46a.className;}if(_46a.tagName==="FONT"){if(_46a.color){_46d.color=_46a.color;}if(_46a.face){_46d.face=_46a.face;}if(_46a.size){_46d.size=_46a.size;}}_3d5.place(_46d,_463,"before");while(_469.length){_46a=_469.pop();var _46e=doc.createElement(_46a.tagName);if(_46a.cssText&&_46e.style){_46e.style.cssText=_46a.cssText;}if(_46a.className){_46e.className=_46a.className;}if(_46a.tagName==="FONT"){if(_46a.color){_46e.color=_46a.color;}if(_46a.face){_46e.face=_46a.face;}if(_46a.size){_46e.size=_46a.size;}}_46d.appendChild(_46e);_46d=_46e;}_45d=doc.createTextNode(".");_45c.appendChild(_45d);_46d.appendChild(_45d);_46c=_3e2.create(this.window);_46c.setStart(_45d,0);_46c.setEnd(_45d,_45d.length);_458.removeAllRanges();_458.addRange(_46c);this.selection.collapse(false);_45d.parentNode.innerHTML="";}else{_45c=doc.createElement("span");_45c.className="ieFormatBreakerSpan";_45d=doc.createTextNode(".");_45c.appendChild(_45d);_3d5.place(_45c,_463,"before");_46c=_3e2.create(this.window);_46c.setStart(_45d,0);_46c.setEnd(_45d,_45d.length);_458.removeAllRanges();_458.addRange(_46c);this.selection.collapse(false);_45d.parentNode.innerHTML="";}if(!_463.firstChild){_3d5.destroy(_463);}return true;}}return false;}else{_459=_458.getRangeAt(0);rs=_459.startContainer;if(rs&&rs.nodeType===3){var _460=_459.startOffset;if(rs.length<_460){ret=this._adjustNodeAndOffset(rs,_460);rs=ret.node;_460=ret.offset;}txt=rs.nodeValue;_45a=doc.createTextNode(txt.substring(0,_460));var _467=txt.substring(_460);if(_467!==""){_45b=doc.createTextNode(txt.substring(_460));}_45c=doc.createElement("span");_45d=doc.createTextNode(".");_45c.appendChild(_45d);if(_45a.length){_3d5.place(_45a,rs,"after");}else{_45a=rs;}_3d5.place(_45c,_45a,"after");if(_45b){_3d5.place(_45b,_45c,"after");}_3d5.destroy(rs);var _46c=_3e2.create(this.window);_46c.setStart(_45d,0);_46c.setEnd(_45d,_45d.length);_458.removeAllRanges();_458.addRange(_46c);doc.execCommand(_457);_3d5.place(_45c.firstChild,_45c,"before");_3d5.destroy(_45c);_46c.setStart(_45d,0);_46c.setEnd(_45d,_45d.length);_458.removeAllRanges();_458.addRange(_46c);this.selection.collapse(false);_45d.parentNode.innerHTML="";return true;}}}else{return false;}},_adaptIEList:function(_46f){var _470=_3e2.getSelection(this.window);if(_470.isCollapsed){if(_470.rangeCount&&!this.queryCommandValue(_46f)){var _471=_470.getRangeAt(0);var sc=_471.startContainer;if(sc&&sc.nodeType==3){if(!_471.startOffset){var _472="ul";if(_46f==="insertorderedlist"){_472="ol";}var list=this.document.createElement(_472);var li=_3d5.create("li",null,list);_3d5.place(list,sc,"before");li.appendChild(sc);_3d5.create("br",null,list,"after");var _473=_3e2.create(this.window);_473.setStart(sc,0);_473.setEnd(sc,sc.length);_470.removeAllRanges();_470.addRange(_473);this.selection.collapse(true);return true;}}}}return false;},_handleTextColorOrProperties:function(_474,_475){var _476=_3e2.getSelection(this.window);var doc=this.document;var rs,ret,_477,txt,_478,_479,_47a,_47b;_475=_475||null;if(_474&&_476&&_476.isCollapsed){if(_476.rangeCount){_477=_476.getRangeAt(0);rs=_477.startContainer;if(rs&&rs.nodeType===3){var _47c=_477.startOffset;if(rs.length<_47c){ret=this._adjustNodeAndOffset(rs,_47c);rs=ret.node;_47c=ret.offset;}txt=rs.nodeValue;_478=doc.createTextNode(txt.substring(0,_47c));var _47d=txt.substring(_47c);if(_47d!==""){_479=doc.createTextNode(txt.substring(_47c));}_47a=doc.createElement("span");_47b=doc.createTextNode(".");_47a.appendChild(_47b);var _47e=doc.createElement("span");_47a.appendChild(_47e);if(_478.length){_3d5.place(_478,rs,"after");}else{_478=rs;}_3d5.place(_47a,_478,"after");if(_479){_3d5.place(_479,_47a,"after");}_3d5.destroy(rs);var _47f=_3e2.create(this.window);_47f.setStart(_47b,0);_47f.setEnd(_47b,_47b.length);_476.removeAllRanges();_476.addRange(_47f);if(has("webkit")){var _480="color";if(_474==="hilitecolor"||_474==="backcolor"){_480="backgroundColor";}_3d7.set(_47a,_480,_475);this.selection.remove();_3d5.destroy(_47e);_47a.innerHTML="&#160;";this.selection.selectElement(_47a);this.focus();}else{this.execCommand(_474,_475);_3d5.place(_47a.firstChild,_47a,"before");_3d5.destroy(_47a);_47f.setStart(_47b,0);_47f.setEnd(_47b,_47b.length);_476.removeAllRanges();_476.addRange(_47f);this.selection.collapse(false);_47b.parentNode.removeChild(_47b);}return true;}}}return false;},_adjustNodeAndOffset:function(node,_481){while(node.length<_481&&node.nextSibling&&node.nextSibling.nodeType===3){_481=_481-node.length;node=node.nextSibling;}return {"node":node,"offset":_481};},_tagNamesForCommand:function(_482){if(_482==="bold"){return ["b","strong"];}else{if(_482==="italic"){return ["i","em"];}else{if(_482==="strikethrough"){return ["s","strike"];}else{if(_482==="superscript"){return ["sup"];}else{if(_482==="subscript"){return ["sub"];}else{if(_482==="underline"){return ["u"];}}}}}}return [];},_stripBreakerNodes:function(node){if(!this.isLoaded){return;}_3d9(".ieFormatBreakerSpan",node).forEach(function(b){while(b.firstChild){_3d5.place(b.firstChild,b,"before");}_3d5.destroy(b);});return node;}});return _3e6;});},"dojo/dnd/Moveable":function(){define(["../_base/array","../_base/declare","../_base/lang","../dom","../dom-class","../Evented","../on","../topic","../touch","./common","./Mover","../_base/window"],function(_483,_484,lang,dom,_485,_486,on,_487,_488,dnd,_489,win){var _48a=_484("dojo.dnd.Moveable",[_486],{handle:"",delay:0,skip:false,constructor:function(node,_48b){this.node=dom.byId(node);if(!_48b){_48b={};}this.handle=_48b.handle?dom.byId(_48b.handle):null;if(!this.handle){this.handle=this.node;}this.delay=_48b.delay>0?_48b.delay:0;this.skip=_48b.skip;this.mover=_48b.mover?_48b.mover:_489;this.events=[on(this.handle,_488.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];},markupFactory:function(_48c,node,Ctor){return new Ctor(node,_48c);},destroy:function(){_483.forEach(this.events,function(_48d){_48d.remove();});this.events=this.node=this.handle=null;},onMouseDown:function(e){if(this.skip&&dnd.isFormElement(e)){return;}if(this.delay){this.events.push(on(this.handle,_488.move,lang.hitch(this,"onMouseMove")),on(this.handle,_488.release,lang.hitch(this,"onMouseUp")));this._lastX=e.pageX;this._lastY=e.pageY;}else{this.onDragDetected(e);}e.stopPropagation();e.preventDefault();},onMouseMove:function(e){if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){this.onMouseUp(e);this.onDragDetected(e);}e.stopPropagation();e.preventDefault();},onMouseUp:function(e){for(var i=0;i<2;++i){this.events.pop().remove();}e.stopPropagation();e.preventDefault();},onSelectStart:function(e){if(!this.skip||!dnd.isFormElement(e)){e.stopPropagation();e.preventDefault();}},onDragDetected:function(e){new this.mover(this.node,e,this);},onMoveStart:function(_48e){_487.publish("/dnd/move/start",_48e);_485.add(win.body(),"dojoMove");_485.add(this.node,"dojoMoveItem");},onMoveStop:function(_48f){_487.publish("/dnd/move/stop",_48f);_485.remove(win.body(),"dojoMove");_485.remove(this.node,"dojoMoveItem");},onFirstMove:function(){},onMove:function(_490,_491){this.onMoving(_490,_491);var s=_490.node.style;s.left=_491.l+"px";s.top=_491.t+"px";this.onMoved(_490,_491);},onMoving:function(){},onMoved:function(){}});return _48a;});},"dijit/TooltipDialog":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/has","dojo/keys","dojo/_base/lang","dojo/on","./focus","./layout/ContentPane","./_DialogMixin","./form/_FormMixin","./_TemplatedMixin","dojo/text!./templates/TooltipDialog.html","./main"],function(_492,_493,has,keys,lang,on,_494,_495,_496,_497,_498,_499,_49a){var _49b=_492("dijit.TooltipDialog",[_495,_498,_497,_496],{title:"",doLayout:false,autofocus:true,baseClass:"dijitTooltipDialog",_firstFocusItem:null,_lastFocusItem:null,templateString:_499,_setTitleAttr:"containerNode",postCreate:function(){this.inherited(arguments);this.own(on(this.containerNode,"keydown",lang.hitch(this,"_onKey")));},orient:function(node,_49c,_49d){var newC={"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft","BR-TL":"dijitTooltipBelow dijitTooltipABLeft","BL-TR":"dijitTooltipBelow dijitTooltipABRight","TL-BR":"dijitTooltipAbove dijitTooltipABRight","TR-BL":"dijitTooltipAbove dijitTooltipABLeft"}[_49c+"-"+_49d];_493.replace(this.domNode,newC,this._currentOrientClass||"");this._currentOrientClass=newC;},focus:function(){this._getFocusItems(this.containerNode);_494.focus(this._firstFocusItem);},onOpen:function(pos){this.orient(this.domNode,pos.aroundCorner,pos.corner);var _49e=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_49e.y+((_49e.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_49e.x+((_49e.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}}this._onShow();},onClose:function(){this.onHide();},_onKey:function(evt){if(evt.keyCode==keys.ESCAPE){this.defer("onCancel");evt.stopPropagation();evt.preventDefault();}else{if(evt.keyCode==keys.TAB){var node=evt.target;this._getFocusItems(this.containerNode);if(this._firstFocusItem==this._lastFocusItem){evt.stopPropagation();evt.preventDefault();}else{if(node==this._firstFocusItem&&evt.shiftKey){_494.focus(this._lastFocusItem);evt.stopPropagation();evt.preventDefault();}else{if(node==this._lastFocusItem&&!evt.shiftKey){_494.focus(this._firstFocusItem);evt.stopPropagation();evt.preventDefault();}else{evt.stopPropagation();}}}}}}});if(has("dojo-bidi")){_49b.extend({_setTitleAttr:function(_49f){this.containerNode.title=(this.textDir&&this.enforceTextDirWithUcc)?this.enforceTextDirWithUcc(null,_49f):_49f;this._set("title",_49f);},_setTextDirAttr:function(_4a0){if(!this._created||this.textDir!=_4a0){this._set("textDir",_4a0);if(this.textDir&&this.title){this.containerNode.title=this.enforceTextDirWithUcc(null,this.title);}}}});}return _49b;});},"dojo/store/util/SimpleQueryEngine":function(){define(["../../_base/array"],function(_4a1){return function(_4a2,_4a3){switch(typeof _4a2){default:throw new Error("Can not query with a "+typeof _4a2);case "object":case "undefined":var _4a4=_4a2;_4a2=function(_4a5){for(var key in _4a4){var _4a6=_4a4[key];if(_4a6&&_4a6.test){if(!_4a6.test(_4a5[key],_4a5)){return false;}}else{if(_4a6!=_4a5[key]){return false;}}}return true;};break;case "string":if(!this[_4a2]){throw new Error("No filter function "+_4a2+" was found in store");}_4a2=this[_4a2];case "function":}function _4a7(_4a8){var _4a9=_4a1.filter(_4a8,_4a2);var _4aa=_4a3&&_4a3.sort;if(_4aa){_4a9.sort(typeof _4aa=="function"?_4aa:function(a,b){for(var sort,i=0;sort=_4aa[i];i++){var _4ab=a[sort.attribute];var _4ac=b[sort.attribute];if(_4ab!=_4ac){return !!sort.descending==(_4ab==null||_4ab>_4ac)?-1:1;}}return 0;});}if(_4a3&&(_4a3.start||_4a3.count)){var _4ad=_4a9.length;_4a9=_4a9.slice(_4a3.start||0,(_4a3.start||0)+(_4a3.count||Infinity));_4a9.total=_4ad;}return _4a9;};_4a7.matches=_4a2;return _4a7;};});},"dijit/form/_ExpandingTextAreaMixin":function(){define(["dojo/_base/declare","dojo/dom-construct","dojo/has","dojo/_base/lang","dojo/on","dojo/_base/window","../Viewport"],function(_4ae,_4af,has,lang,on,win,_4b0){has.add("textarea-needs-help-shrinking",function(){var body=win.body(),te=_4af.create("textarea",{rows:"5",cols:"20",value:" ",style:{zoom:1,fontSize:"12px",height:"96px",overflow:"hidden",visibility:"hidden",position:"absolute",border:"5px solid white",margin:"0",padding:"0",boxSizing:"border-box",MsBoxSizing:"border-box",WebkitBoxSizing:"border-box",MozBoxSizing:"border-box"}},body,"last");var _4b1=te.scrollHeight>=te.clientHeight;body.removeChild(te);return _4b1;});return _4ae("dijit.form._ExpandingTextAreaMixin",null,{_setValueAttr:function(){this.inherited(arguments);this.resize();},postCreate:function(){this.inherited(arguments);var _4b2=this.textbox;_4b2.style.overflowY="hidden";this.own(on(_4b2,"focus, resize",lang.hitch(this,"_resizeLater")));},startup:function(){this.inherited(arguments);this.own(_4b0.on("resize",lang.hitch(this,"_resizeLater")));this._resizeLater();},_onInput:function(e){this.inherited(arguments);this.resize();},_estimateHeight:function(){var _4b3=this.textbox;_4b3.rows=(_4b3.value.match(/\n/g)||[]).length+1;},_resizeLater:function(){this.defer("resize");},resize:function(){var _4b4=this.textbox;function _4b5(){var _4b6=false;if(_4b4.value===""){_4b4.value=" ";_4b6=true;}var sh=_4b4.scrollHeight;if(_4b6){_4b4.value="";}return sh;};if(_4b4.style.overflowY=="hidden"){_4b4.scrollTop=0;}if(this.busyResizing){return;}this.busyResizing=true;if(_4b5()||_4b4.offsetHeight){var newH=_4b5()+Math.max(_4b4.offsetHeight-_4b4.clientHeight,0);var _4b7=newH+"px";if(_4b7!=_4b4.style.height){_4b4.style.height=_4b7;_4b4.rows=1;}if(has("textarea-needs-help-shrinking")){var _4b8=_4b5(),_4b9=_4b8,_4ba=_4b4.style.minHeight,_4bb=4,_4bc,_4bd=_4b4.scrollTop;_4b4.style.minHeight=_4b7;_4b4.style.height="auto";while(newH>0){_4b4.style.minHeight=Math.max(newH-_4bb,4)+"px";_4bc=_4b5();var _4be=_4b9-_4bc;newH-=_4be;if(_4be<_4bb){break;}_4b9=_4bc;_4bb<<=1;}_4b4.style.height=newH+"px";_4b4.style.minHeight=_4ba;_4b4.scrollTop=_4bd;}_4b4.style.overflowY=_4b5()>_4b4.clientHeight?"auto":"hidden";if(_4b4.style.overflowY=="hidden"){_4b4.scrollTop=0;}}else{this._estimateHeight();}this.busyResizing=false;}});});},"dijit/MenuItem":function(){define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/sniff","dojo/_base/lang","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_4bf,dom,_4c0,_4c1,_4c2,has,lang,_4c3,_4c4,_4c5,_4c6,_4c7){var _4c8=_4bf("dijit.MenuItem"+(has("dojo-bidi")?"_NoBidi":""),[_4c3,_4c4,_4c5,_4c6],{templateString:_4c7,baseClass:"dijitMenuItem",label:"",_setLabelAttr:function(val){this._set("label",val);var _4c9="";var text;var ndx=val.search(/{\S}/);if(ndx>=0){_4c9=val.charAt(ndx+1);var _4ca=val.substr(0,ndx);var _4cb=val.substr(ndx+3);text=_4ca+_4c9+_4cb;val=_4ca+"<span class=\"dijitMenuItemShortcutKey\">"+_4c9+"</span>"+_4cb;}else{text=val;}this.domNode.setAttribute("aria-label",text+" "+this.accelKey);this.containerNode.innerHTML=val;this._set("shortcutKey",_4c9);},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_4cc){if(_4cc&&!("label" in this.params)){this._set("label",_4cc.innerHTML);}},buildRendering:function(){this.inherited(arguments);var _4cd=this.id+"_text";_4c0.set(this.containerNode,"id",_4cd);if(this.accelKeyNode){_4c0.set(this.accelKeyNode,"id",this.id+"_accel");}dom.setSelectable(this.domNode,false);},onClick:function(){},focus:function(){try{if(has("ie")==8){this.containerNode.focus();}this.focusNode.focus();}catch(e){}},_onFocus:function(){this.getParent()._onItemFocus(this);this.inherited(arguments);},_setSelected:function(_4ce){_4c1.toggle(this.domNode,"dijitMenuItemSelected",_4ce);},setLabel:function(_4cf){_4c2.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_4cf);},setDisabled:function(_4d0){_4c2.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");this.set("disabled",_4d0);},_setDisabledAttr:function(_4d1){this.focusNode.setAttribute("aria-disabled",_4d1?"true":"false");this._set("disabled",_4d1);},_setAccelKeyAttr:function(_4d2){if(this.accelKeyNode){this.accelKeyNode.style.display=_4d2?"":"none";this.accelKeyNode.innerHTML=_4d2;_4c0.set(this.containerNode,"colSpan",_4d2?"1":"2");}this._set("accelKey",_4d2);}});if(has("dojo-bidi")){_4c8=_4bf("dijit.MenuItem",_4c8,{_setLabelAttr:function(val){this.inherited(arguments);if(this.textDir==="auto"){this.applyTextDir(this.textDirNode);}}});}return _4c8;});},"dijit/MenuBarItem":function(){define(["dojo/_base/declare","./MenuItem","dojo/text!./templates/MenuBarItem.html"],function(_4d3,_4d4,_4d5){var _4d6=_4d3("dijit._MenuBarItemMixin",null,{templateString:_4d5,_setIconClassAttr:null});var _4d7=_4d3("dijit.MenuBarItem",[_4d4,_4d6],{});_4d7._MenuBarItemMixin=_4d6;return _4d7;});},"dijit/layout/TabController":function(){define(["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/has","dojo/i18n","dojo/_base/lang","./StackController","../registry","../Menu","../MenuItem","dojo/text!./templates/_TabButton.html","dojo/i18n!../nls/common"],function(_4d8,dom,_4d9,_4da,has,i18n,lang,_4db,_4dc,Menu,_4dd,_4de){var _4df=_4d8("dijit.layout._TabButton"+(has("dojo-bidi")?"_NoBidi":""),_4db.StackButton,{baseClass:"dijitTab",cssStateNodes:{closeNode:"dijitTabCloseButton"},templateString:_4de,_setNameAttr:"focusNode",scrollOnFocus:false,buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.containerNode,false);},startup:function(){this.inherited(arguments);var n=this.domNode;this.defer(function(){n.className=n.className;},1);},_setCloseButtonAttr:function(disp){this._set("closeButton",disp);_4da.toggle(this.domNode,"dijitClosable",disp);this.closeNode.style.display=disp?"":"none";if(disp){var _4e0=i18n.getLocalization("dijit","common");if(this.closeNode){_4d9.set(this.closeNode,"title",_4e0.itemClose);}}},_setDisabledAttr:function(_4e1){this.inherited(arguments);if(this.closeNode){if(_4e1){_4d9.remove(this.closeNode,"title");}else{var _4e2=i18n.getLocalization("dijit","common");_4d9.set(this.closeNode,"title",_4e2.itemClose);}}},_setLabelAttr:function(_4e3){this.inherited(arguments);if(!this.showLabel&&!this.params.title){this.iconNode.alt=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");}}});if(has("dojo-bidi")){_4df=_4d8("dijit.layout._TabButton",_4df,{_setLabelAttr:function(_4e4){this.inherited(arguments);this.applyTextDir(this.iconNode,this.iconNode.alt);}});}var _4e5=_4d8("dijit.layout.TabController",_4db,{baseClass:"dijitTabController",templateString:"<div role='tablist' data-dojo-attach-event='onkeydown:onkeydown'></div>",tabPosition:"top",buttonWidget:_4df,buttonWidgetCloseClass:"dijitTabCloseButton",postCreate:function(){this.inherited(arguments);var _4e6=new Menu({id:this.id+"_Menu",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,targetNodeIds:[this.domNode],selector:function(node){return _4da.contains(node,"dijitClosable")&&!_4da.contains(node,"dijitTabDisabled");}});this.own(_4e6);var _4e7=i18n.getLocalization("dijit","common"),_4e8=this;_4e6.addChild(new _4dd({label:_4e7.itemClose,ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,onClick:function(evt){var _4e9=_4dc.byNode(this.getParent().currentTarget);_4e8.onCloseButtonClick(_4e9.page);}}));}});_4e5.TabButton=_4df;return _4e5;});},"dojo/cldr/supplemental":function(){define(["../_base/lang","../i18n"],function(lang,i18n){var _4ea={};lang.setObject("dojo.cldr.supplemental",_4ea);_4ea.getFirstDayOfWeek=function(_4eb){var _4ec={bd:5,mv:5,ae:6,af:6,bh:6,dj:6,dz:6,eg:6,iq:6,ir:6,jo:6,kw:6,ly:6,ma:6,om:6,qa:6,sa:6,sd:6,sy:6,ye:6,ag:0,ar:0,as:0,au:0,br:0,bs:0,bt:0,bw:0,by:0,bz:0,ca:0,cn:0,co:0,dm:0,"do":0,et:0,gt:0,gu:0,hk:0,hn:0,id:0,ie:0,il:0,"in":0,jm:0,jp:0,ke:0,kh:0,kr:0,la:0,mh:0,mm:0,mo:0,mt:0,mx:0,mz:0,ni:0,np:0,nz:0,pa:0,pe:0,ph:0,pk:0,pr:0,py:0,sg:0,sv:0,th:0,tn:0,tt:0,tw:0,um:0,us:0,ve:0,vi:0,ws:0,za:0,zw:0};var _4ed=_4ea._region(_4eb);var dow=_4ec[_4ed];return (dow===undefined)?1:dow;};_4ea._region=function(_4ee){_4ee=i18n.normalizeLocale(_4ee);var tags=_4ee.split("-");var _4ef=tags[1];if(!_4ef){_4ef={aa:"et",ab:"ge",af:"za",ak:"gh",am:"et",ar:"eg",as:"in",av:"ru",ay:"bo",az:"az",ba:"ru",be:"by",bg:"bg",bi:"vu",bm:"ml",bn:"bd",bo:"cn",br:"fr",bs:"ba",ca:"es",ce:"ru",ch:"gu",co:"fr",cr:"ca",cs:"cz",cv:"ru",cy:"gb",da:"dk",de:"de",dv:"mv",dz:"bt",ee:"gh",el:"gr",en:"us",es:"es",et:"ee",eu:"es",fa:"ir",ff:"sn",fi:"fi",fj:"fj",fo:"fo",fr:"fr",fy:"nl",ga:"ie",gd:"gb",gl:"es",gn:"py",gu:"in",gv:"gb",ha:"ng",he:"il",hi:"in",ho:"pg",hr:"hr",ht:"ht",hu:"hu",hy:"am",ia:"fr",id:"id",ig:"ng",ii:"cn",ik:"us","in":"id",is:"is",it:"it",iu:"ca",iw:"il",ja:"jp",ji:"ua",jv:"id",jw:"id",ka:"ge",kg:"cd",ki:"ke",kj:"na",kk:"kz",kl:"gl",km:"kh",kn:"in",ko:"kr",ks:"in",ku:"tr",kv:"ru",kw:"gb",ky:"kg",la:"va",lb:"lu",lg:"ug",li:"nl",ln:"cd",lo:"la",lt:"lt",lu:"cd",lv:"lv",mg:"mg",mh:"mh",mi:"nz",mk:"mk",ml:"in",mn:"mn",mo:"ro",mr:"in",ms:"my",mt:"mt",my:"mm",na:"nr",nb:"no",nd:"zw",ne:"np",ng:"na",nl:"nl",nn:"no",no:"no",nr:"za",nv:"us",ny:"mw",oc:"fr",om:"et",or:"in",os:"ge",pa:"in",pl:"pl",ps:"af",pt:"br",qu:"pe",rm:"ch",rn:"bi",ro:"ro",ru:"ru",rw:"rw",sa:"in",sd:"in",se:"no",sg:"cf",si:"lk",sk:"sk",sl:"si",sm:"ws",sn:"zw",so:"so",sq:"al",sr:"rs",ss:"za",st:"za",su:"id",sv:"se",sw:"tz",ta:"in",te:"in",tg:"tj",th:"th",ti:"et",tk:"tm",tl:"ph",tn:"za",to:"to",tr:"tr",ts:"za",tt:"ru",ty:"pf",ug:"cn",uk:"ua",ur:"pk",uz:"uz",ve:"za",vi:"vn",wa:"be",wo:"sn",xh:"za",yi:"il",yo:"ng",za:"cn",zh:"cn",zu:"za",ace:"id",ady:"ru",agq:"cm",alt:"ru",amo:"ng",asa:"tz",ast:"es",awa:"in",bal:"pk",ban:"id",bas:"cm",bax:"cm",bbc:"id",bem:"zm",bez:"tz",bfq:"in",bft:"pk",bfy:"in",bhb:"in",bho:"in",bik:"ph",bin:"ng",bjj:"in",bku:"ph",bqv:"ci",bra:"in",brx:"in",bss:"cm",btv:"pk",bua:"ru",buc:"yt",bug:"id",bya:"id",byn:"er",cch:"ng",ccp:"in",ceb:"ph",cgg:"ug",chk:"fm",chm:"ru",chp:"ca",chr:"us",cja:"kh",cjm:"vn",ckb:"iq",crk:"ca",csb:"pl",dar:"ru",dav:"ke",den:"ca",dgr:"ca",dje:"ne",doi:"in",dsb:"de",dua:"cm",dyo:"sn",dyu:"bf",ebu:"ke",efi:"ng",ewo:"cm",fan:"gq",fil:"ph",fon:"bj",fur:"it",gaa:"gh",gag:"md",gbm:"in",gcr:"gf",gez:"et",gil:"ki",gon:"in",gor:"id",grt:"in",gsw:"ch",guz:"ke",gwi:"ca",haw:"us",hil:"ph",hne:"in",hnn:"ph",hoc:"in",hoj:"in",ibb:"ng",ilo:"ph",inh:"ru",jgo:"cm",jmc:"tz",kaa:"uz",kab:"dz",kaj:"ng",kam:"ke",kbd:"ru",kcg:"ng",kde:"tz",kdt:"th",kea:"cv",ken:"cm",kfo:"ci",kfr:"in",kha:"in",khb:"cn",khq:"ml",kht:"in",kkj:"cm",kln:"ke",kmb:"ao",koi:"ru",kok:"in",kos:"fm",kpe:"lr",krc:"ru",kri:"sl",krl:"ru",kru:"in",ksb:"tz",ksf:"cm",ksh:"de",kum:"ru",lag:"tz",lah:"pk",lbe:"ru",lcp:"cn",lep:"in",lez:"ru",lif:"np",lis:"cn",lki:"ir",lmn:"in",lol:"cd",lua:"cd",luo:"ke",luy:"ke",lwl:"th",mad:"id",mag:"in",mai:"in",mak:"id",man:"gn",mas:"ke",mdf:"ru",mdh:"ph",mdr:"id",men:"sl",mer:"ke",mfe:"mu",mgh:"mz",mgo:"cm",min:"id",mni:"in",mnk:"gm",mnw:"mm",mos:"bf",mua:"cm",mwr:"in",myv:"ru",nap:"it",naq:"na",nds:"de","new":"np",niu:"nu",nmg:"cm",nnh:"cm",nod:"th",nso:"za",nus:"sd",nym:"tz",nyn:"ug",pag:"ph",pam:"ph",pap:"bq",pau:"pw",pon:"fm",prd:"ir",raj:"in",rcf:"re",rej:"id",rjs:"np",rkt:"in",rof:"tz",rwk:"tz",saf:"gh",sah:"ru",saq:"ke",sas:"id",sat:"in",saz:"in",sbp:"tz",scn:"it",sco:"gb",sdh:"ir",seh:"mz",ses:"ml",shi:"ma",shn:"mm",sid:"et",sma:"se",smj:"se",smn:"fi",sms:"fi",snk:"ml",srn:"sr",srr:"sn",ssy:"er",suk:"tz",sus:"gn",swb:"yt",swc:"cd",syl:"bd",syr:"sy",tbw:"ph",tcy:"in",tdd:"cn",tem:"sl",teo:"ug",tet:"tl",tig:"er",tiv:"ng",tkl:"tk",tmh:"ne",tpi:"pg",trv:"tw",tsg:"ph",tts:"th",tum:"mw",tvl:"tv",twq:"ne",tyv:"ru",tzm:"ma",udm:"ru",uli:"fm",umb:"ao",unr:"in",unx:"in",vai:"lr",vun:"tz",wae:"ch",wal:"et",war:"ph",xog:"ug",xsr:"np",yao:"mz",yap:"fm",yav:"cm",zza:"tr"}[tags[0]];}else{if(_4ef.length==4){_4ef=tags[2];}}return _4ef;};_4ea.getWeekend=function(_4f0){var _4f1={"in":0,af:4,dz:4,ir:4,om:4,sa:4,ye:4,ae:5,bh:5,eg:5,il:5,iq:5,jo:5,kw:5,ly:5,ma:5,qa:5,sd:5,sy:5,tn:5},_4f2={af:5,dz:5,ir:5,om:5,sa:5,ye:5,ae:6,bh:5,eg:6,il:6,iq:6,jo:6,kw:6,ly:6,ma:6,qa:6,sd:6,sy:6,tn:6},_4f3=_4ea._region(_4f0),_4f4=_4f1[_4f3],end=_4f2[_4f3];if(_4f4===undefined){_4f4=6;}if(end===undefined){end=0;}return {start:_4f4,end:end};};return _4ea;});},"dijit/MenuBar":function(){define(["dojo/_base/declare","dojo/keys","./_MenuBase","dojo/text!./templates/MenuBar.html"],function(_4f5,keys,_4f6,_4f7){return _4f5("dijit.MenuBar",_4f6,{templateString:_4f7,baseClass:"dijitMenuBar",popupDelay:0,_isMenuBar:true,_orient:["below"],_moveToPopup:function(evt){if(this.focusedChild&&this.focusedChild.popup&&!this.focusedChild.disabled){this.onItemClick(this.focusedChild,evt);}},focusChild:function(item){this.inherited(arguments);if(this.activated&&item.popup&&!item.disabled){this._openItemPopup(item,true);}},_onChildDeselect:function(item){if(this.currentPopupItem==item){this.currentPopupItem=null;item._closePopup();}this.inherited(arguments);},_onLeftArrow:function(){this.focusPrev();},_onRightArrow:function(){this.focusNext();},_onDownArrow:function(evt){this._moveToPopup(evt);},_onUpArrow:function(){},onItemClick:function(item,evt){if(item.popup&&item.popup.isShowingNow&&(!/^key/.test(evt.type)||evt.keyCode!==keys.DOWN_ARROW)){item.focusNode.focus();this._cleanUp(true);}else{this.inherited(arguments);}}});});},"dijit/ToolbarSeparator":function(){define(["dojo/_base/declare","dojo/dom","./_Widget","./_TemplatedMixin"],function(_4f8,dom,_4f9,_4fa){return _4f8("dijit.ToolbarSeparator",[_4f9,_4fa],{templateString:"<div class=\"dijitToolbarSeparator dijitInline\" role=\"presentation\"></div>",buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/layout/StackController":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","dojo/topic","../focus","../registry","../_Widget","../_TemplatedMixin","../_Container","../form/ToggleButton","dojo/touch","dojo/i18n!../nls/common"],function(_4fb,_4fc,_4fd,_4fe,keys,lang,on,_4ff,_500,_501,_502,_503,_504,_505){var _506=_4fc("dijit.layout._StackButton",_505,{tabIndex:"-1",closeButton:false,_aria_attr:"aria-selected",buildRendering:function(evt){this.inherited(arguments);(this.focusNode||this.domNode).setAttribute("role","tab");}});var _507=_4fc("dijit.layout.StackController",[_502,_503,_504],{baseClass:"dijitStackController",templateString:"<span role='tablist' data-dojo-attach-event='onkeydown'></span>",containerId:"",buttonWidget:_506,buttonWidgetCloseClass:"dijitStackCloseButton",pane2button:function(id){return _501.byId(this.id+"_"+id);},postCreate:function(){this.inherited(arguments);this.own(_4ff.subscribe(this.containerId+"-startup",lang.hitch(this,"onStartup")),_4ff.subscribe(this.containerId+"-addChild",lang.hitch(this,"onAddChild")),_4ff.subscribe(this.containerId+"-removeChild",lang.hitch(this,"onRemoveChild")),_4ff.subscribe(this.containerId+"-selectChild",lang.hitch(this,"onSelectChild")),_4ff.subscribe(this.containerId+"-containerKeyDown",lang.hitch(this,"onContainerKeyDown")));this.containerNode.dojoClick=true;this.own(on(this.containerNode,"click",lang.hitch(this,function(evt){var _508=_501.getEnclosingWidget(evt.target);if(_508!=this.containerNode&&!_508.disabled&&_508.page){for(var _509=evt.target;_509!==this.containerNode;_509=_509.parentNode){if(_4fd.contains(_509,this.buttonWidgetCloseClass)){this.onCloseButtonClick(_508.page);break;}else{if(_509==_508.domNode){this.onButtonClick(_508.page);break;}}}}})));},onStartup:function(info){this.textDir=info.textDir;_4fb.forEach(info.children,this.onAddChild,this);if(info.selected){this.onSelectChild(info.selected);}var _50a=_501.byId(this.containerId).containerNode,_50b=lang.hitch(this,"pane2button"),_50c={"title":"label","showtitle":"showLabel","iconclass":"iconClass","closable":"closeButton","tooltip":"title","disabled":"disabled","textdir":"textdir"},_50d=function(attr,_50e){return on(_50a,"attrmodified-"+attr,function(evt){var _50f=_50b(evt.detail&&evt.detail.widget&&evt.detail.widget.id);if(_50f){_50f.set(_50e,evt.detail.newValue);}});};for(var attr in _50c){this.own(_50d(attr,_50c[attr]));}},destroy:function(_510){this.destroyDescendants(_510);this.inherited(arguments);},onAddChild:function(page,_511){var Cls=lang.isString(this.buttonWidget)?lang.getObject(this.buttonWidget):this.buttonWidget;var _512=new Cls({id:this.id+"_"+page.id,name:this.id+"_"+page.id,label:page.title,disabled:page.disabled,ownerDocument:this.ownerDocument,dir:page.dir,lang:page.lang,textDir:page.textDir||this.textDir,showLabel:page.showTitle,iconClass:page.iconClass,closeButton:page.closable,title:page.tooltip,page:page});this.addChild(_512,_511);page.controlButton=_512;if(!this._currentChild){this.onSelectChild(page);}var _513=page._wrapper.getAttribute("aria-labelledby")?page._wrapper.getAttribute("aria-labelledby")+" "+_512.id:_512.id;page._wrapper.removeAttribute("aria-label");page._wrapper.setAttribute("aria-labelledby",_513);},onRemoveChild:function(page){if(this._currentChild===page){this._currentChild=null;}var _514=this.pane2button(page.id);if(_514){this.removeChild(_514);_514.destroy();}delete page.controlButton;},onSelectChild:function(page){if(!page){return;}if(this._currentChild){var _515=this.pane2button(this._currentChild.id);_515.set("checked",false);_515.focusNode.setAttribute("tabIndex","-1");}var _516=this.pane2button(page.id);_516.set("checked",true);this._currentChild=page;_516.focusNode.setAttribute("tabIndex","0");var _517=_501.byId(this.containerId);},onButtonClick:function(page){var _518=this.pane2button(page.id);_500.focus(_518.focusNode);if(this._currentChild&&this._currentChild.id===page.id){_518.set("checked",true);}var _519=_501.byId(this.containerId);_519.selectChild(page);},onCloseButtonClick:function(page){var _51a=_501.byId(this.containerId);_51a.closeChild(page);if(this._currentChild){var b=this.pane2button(this._currentChild.id);if(b){_500.focus(b.focusNode||b.domNode);}}},adjacent:function(_51b){if(!this.isLeftToRight()&&(!this.tabPosition||/top|bottom/.test(this.tabPosition))){_51b=!_51b;}var _51c=this.getChildren();var idx=_4fb.indexOf(_51c,this.pane2button(this._currentChild.id)),_51d=_51c[idx];var _51e;do{idx=(idx+(_51b?1:_51c.length-1))%_51c.length;_51e=_51c[idx];}while(_51e.disabled&&_51e!=_51d);return _51e;},onkeydown:function(e,_51f){if(this.disabled||e.altKey){return;}var _520=null;if(e.ctrlKey||!e._djpage){switch(e.keyCode){case keys.LEFT_ARROW:case keys.UP_ARROW:if(!e._djpage){_520=false;}break;case keys.PAGE_UP:if(e.ctrlKey){_520=false;}break;case keys.RIGHT_ARROW:case keys.DOWN_ARROW:if(!e._djpage){_520=true;}break;case keys.PAGE_DOWN:if(e.ctrlKey){_520=true;}break;case keys.HOME:var _521=this.getChildren();for(var idx=0;idx<_521.length;idx++){var _522=_521[idx];if(!_522.disabled){this.onButtonClick(_522.page);break;}}e.stopPropagation();e.preventDefault();break;case keys.END:var _521=this.getChildren();for(var idx=_521.length-1;idx>=0;idx--){var _522=_521[idx];if(!_522.disabled){this.onButtonClick(_522.page);break;}}e.stopPropagation();e.preventDefault();break;case keys.DELETE:case "W".charCodeAt(0):if(this._currentChild.closable&&(e.keyCode==keys.DELETE||e.ctrlKey)){this.onCloseButtonClick(this._currentChild);}e.stopPropagation();e.preventDefault();break;case keys.TAB:if(e.ctrlKey){this.onButtonClick(this.adjacent(!e.shiftKey).page);e.stopPropagation();e.preventDefault();}break;}if(_520!==null){this.onButtonClick(this.adjacent(_520).page);e.stopPropagation();e.preventDefault();}}},onContainerKeyDown:function(info){info.e._djpage=info.page;this.onkeydown(info.e);}});_507.StackButton=_506;return _507;});},"dojo/dnd/Mover":function(){define(["../_base/array","../_base/declare","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(_523,_524,lang,has,win,dom,_525,_526,_527,on,_528,dnd,_529){return _524("dojo.dnd.Mover",[_527],{constructor:function(node,e,host){this.node=dom.byId(node);this.marginBox={l:e.pageX,t:e.pageY};this.mouseButton=e.button;var h=(this.host=host),d=node.ownerDocument;function _52a(e){e.preventDefault();e.stopPropagation();};this.events=[on(d,_528.move,lang.hitch(this,"onFirstMove")),on(d,_528.move,lang.hitch(this,"onMouseMove")),on(d,_528.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",_52a),on(d.body,"selectstart",_52a)];_529.autoScrollStart(d);if(h&&h.onMoveStart){h.onMoveStart(this);}},onMouseMove:function(e){_529.autoScroll(e);var m=this.marginBox;this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);e.preventDefault();e.stopPropagation();},onMouseUp:function(e){if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){this.destroy();}e.preventDefault();e.stopPropagation();},onFirstMove:function(e){var s=this.node.style,l,t,h=this.host;switch(s.position){case "relative":case "absolute":l=Math.round(parseFloat(s.left))||0;t=Math.round(parseFloat(s.top))||0;break;default:s.position="absolute";var m=_525.getMarginBox(this.node);var b=win.doc.body;var bs=_526.getComputedStyle(b);var bm=_525.getMarginBox(b,bs);var bc=_525.getContentBox(b,bs);l=m.l-(bc.l-bm.l);t=m.t-(bc.t-bm.t);break;}this.marginBox.l=l-this.marginBox.l;this.marginBox.t=t-this.marginBox.t;if(h&&h.onFirstMove){h.onFirstMove(this,e);}this.events.shift().remove();},destroy:function(){_523.forEach(this.events,function(_52b){_52b.remove();});var h=this.host;if(h&&h.onMoveStop){h.onMoveStop(this);}this.events=this.node=this.host=null;}});});},"dijit/form/HorizontalRule":function(){define(["dojo/_base/declare","../_Widget","../_TemplatedMixin"],function(_52c,_52d,_52e){return _52c("dijit.form.HorizontalRule",[_52d,_52e],{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH\"></div>",count:3,container:"containerNode",ruleStyle:"",_positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkH\" style=\"left:",_positionSuffix:"%;",_suffix:"\"></div>",_genHTML:function(pos){return this._positionPrefix+pos+this._positionSuffix+this.ruleStyle+this._suffix;},_isHorizontal:true,buildRendering:function(){this.inherited(arguments);var _52f;if(this.count==1){_52f=this._genHTML(50,0);}else{var i;var _530=100/(this.count-1);if(!this._isHorizontal||this.isLeftToRight()){_52f=this._genHTML(0,0);for(i=1;i<this.count-1;i++){_52f+=this._genHTML(_530*i,i);}_52f+=this._genHTML(100,this.count-1);}else{_52f=this._genHTML(100,0);for(i=1;i<this.count-1;i++){_52f+=this._genHTML(100-_530*i,i);}_52f+=this._genHTML(0,this.count-1);}}this.domNode.innerHTML=_52f;}});});},"dijit/layout/TabContainer":function(){define(["dojo/_base/lang","dojo/_base/declare","./_TabContainerBase","./TabController","./ScrollingTabController"],function(lang,_531,_532,_533,_534){return _531("dijit.layout.TabContainer",_532,{useMenu:true,useSlider:true,controllerWidget:"",_makeController:function(_535){var cls=this.baseClass+"-tabs"+(this.doLayout?"":" dijitTabNoLayout"),_533=typeof this.controllerWidget=="string"?lang.getObject(this.controllerWidget):this.controllerWidget;return new _533({id:this.id+"_tablist",ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,textDir:this.textDir,tabPosition:this.tabPosition,doLayout:this.doLayout,containerId:this.id,"class":cls,nested:this.nested,useMenu:this.useMenu,useSlider:this.useSlider,tabStripClass:this.tabStrip?this.baseClass+(this.tabStrip?"":"No")+"Strip":null},_535);},postMixInProperties:function(){this.inherited(arguments);if(!this.controllerWidget){this.controllerWidget=(this.tabPosition=="top"||this.tabPosition=="bottom")&&!this.nested?_534:_533;}}});});},"dijit/form/_Spinner":function(){define(["dojo/_base/declare","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/mouse","dojo/on","../typematic","./RangeBoundTextBox","dojo/text!./templates/Spinner.html","./_TextBoxMixin"],function(_536,keys,lang,has,_537,on,_538,_539,_53a,_53b){return _536("dijit.form._Spinner",_539,{defaultTimeout:500,minimumTimeout:10,timeoutChangeRate:0.9,smallDelta:1,largeDelta:10,templateString:_53a,baseClass:"dijitTextBox dijitSpinner",cssStateNodes:{"upArrowNode":"dijitUpArrowButton","downArrowNode":"dijitDownArrowButton"},adjust:function(val){return val;},_arrowPressed:function(_53c,_53d,_53e){if(this.disabled||this.readOnly){return;}this._setValueAttr(this.adjust(this.get("value"),_53d*_53e),false);_53b.selectInputText(this.textbox,this.textbox.value.length);},_arrowReleased:function(){this._wheelTimer=null;},_typematicCallback:function(_53f,node,evt){var inc=this.smallDelta;if(node==this.textbox){var key=evt.keyCode;inc=(key==keys.PAGE_UP||key==keys.PAGE_DOWN)?this.largeDelta:this.smallDelta;node=(key==keys.UP_ARROW||key==keys.PAGE_UP)?this.upArrowNode:this.downArrowNode;}if(_53f==-1){this._arrowReleased(node);}else{this._arrowPressed(node,(node==this.upArrowNode)?1:-1,inc);}},_wheelTimer:null,_mouseWheeled:function(evt){evt.stopPropagation();evt.preventDefault();var _540=evt.wheelDelta/120;if(Math.floor(_540)!=_540){_540=evt.wheelDelta>0?1:-1;}var _541=evt.detail?(evt.detail*-1):_540;if(_541!==0){var node=this[(_541>0?"upArrowNode":"downArrowNode")];this._arrowPressed(node,_541,this.smallDelta);if(this._wheelTimer){this._wheelTimer.remove();}this._wheelTimer=this.defer(function(){this._arrowReleased(node);},50);}},_setConstraintsAttr:function(_542){this.inherited(arguments);if(this.focusNode){if(this.constraints.min!==undefined){this.focusNode.setAttribute("aria-valuemin",this.constraints.min);}else{this.focusNode.removeAttribute("aria-valuemin");}if(this.constraints.max!==undefined){this.focusNode.setAttribute("aria-valuemax",this.constraints.max);}else{this.focusNode.removeAttribute("aria-valuemax");}}},_setValueAttr:function(_543,_544){this.focusNode.setAttribute("aria-valuenow",_543);this.inherited(arguments);},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,_537.wheel,lang.hitch(this,"_mouseWheeled")),_538.addListener(this.upArrowNode,this.textbox,{keyCode:keys.UP_ARROW,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_538.addListener(this.downArrowNode,this.textbox,{keyCode:keys.DOWN_ARROW,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_538.addListener(this.upArrowNode,this.textbox,{keyCode:keys.PAGE_UP,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout),_538.addListener(this.downArrowNode,this.textbox,{keyCode:keys.PAGE_DOWN,ctrlKey:false,altKey:false,shiftKey:false,metaKey:false},this,"_typematicCallback",this.timeoutChangeRate,this.defaultTimeout,this.minimumTimeout));}});});},"dijit/form/Button":function(){define(["require","dojo/_base/declare","dojo/dom-class","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/ready","./_FormWidget","./_ButtonMixin","dojo/text!./templates/Button.html"],function(_545,_546,_547,has,_548,lang,_549,_54a,_54b,_54c){if(has("dijit-legacy-requires")){_549(0,function(){var _54d=["dijit/form/DropDownButton","dijit/form/ComboButton","dijit/form/ToggleButton"];_545(_54d);});}var _54e=_546("dijit.form.Button"+(has("dojo-bidi")?"_NoBidi":""),[_54a,_54b],{showLabel:true,iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},baseClass:"dijitButton",templateString:_54c,_setValueAttr:"valueNode",_setNameAttr:function(name){if(this.valueNode){this.valueNode.setAttribute("name",name);}},_fillContent:function(_54f){if(_54f&&(!this.params||!("label" in this.params))){var _550=lang.trim(_54f.innerHTML);if(_550){this.label=_550;}}},_setShowLabelAttr:function(val){if(this.containerNode){_547.toggle(this.containerNode,"dijitDisplayNone",!val);}this._set("showLabel",val);},setLabel:function(_551){_548.deprecated("dijit.form.Button.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_551);},_setLabelAttr:function(_552){this.inherited(arguments);if(!this.showLabel&&!("title" in this.params)){this.titleNode.title=lang.trim(this.containerNode.innerText||this.containerNode.textContent||"");}}});if(has("dojo-bidi")){_54e=_546("dijit.form.Button",_54e,{_setLabelAttr:function(_553){this.inherited(arguments);if(this.titleNode.title){this.applyTextDir(this.titleNode,this.titleNode.title);}},_setTextDirAttr:function(_554){if(this._created&&this.textDir!=_554){this._set("textDir",_554);this._setLabelAttr(this.label);}}});}return _54e;});},"dojo/dnd/move":function(){define(["../_base/declare","../dom-geometry","../dom-style","./common","./Mover","./Moveable"],function(_555,_556,_557,dnd,_558,_559){var _55a=_555("dojo.dnd.move.constrainedMoveable",_559,{constraints:function(){},within:false,constructor:function(node,_55b){if(!_55b){_55b={};}this.constraints=_55b.constraints;this.within=_55b.within;},onFirstMove:function(_55c){var c=this.constraintBox=this.constraints.call(this,_55c);c.r=c.l+c.w;c.b=c.t+c.h;if(this.within){var mb=_556.getMarginSize(_55c.node);c.r-=mb.w;c.b-=mb.h;}},onMove:function(_55d,_55e){var c=this.constraintBox,s=_55d.node.style;this.onMoving(_55d,_55e);_55e.l=_55e.l<c.l?c.l:c.r<_55e.l?c.r:_55e.l;_55e.t=_55e.t<c.t?c.t:c.b<_55e.t?c.b:_55e.t;s.left=_55e.l+"px";s.top=_55e.t+"px";this.onMoved(_55d,_55e);}});var _55f=_555("dojo.dnd.move.boxConstrainedMoveable",_55a,{box:{},constructor:function(node,_560){var box=_560&&_560.box;this.constraints=function(){return box;};}});var _561=_555("dojo.dnd.move.parentConstrainedMoveable",_55a,{area:"content",constructor:function(node,_562){var area=_562&&_562.area;this.constraints=function(){var n=this.node.parentNode,s=_557.getComputedStyle(n),mb=_556.getMarginBox(n,s);if(area=="margin"){return mb;}var t=_556.getMarginExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="border"){return mb;}t=_556.getBorderExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;if(area=="padding"){return mb;}t=_556.getPadExtents(n,s);mb.l+=t.l,mb.t+=t.t,mb.w-=t.w,mb.h-=t.h;return mb;};}});return {constrainedMoveable:_55a,boxConstrainedMoveable:_55f,parentConstrainedMoveable:_561};});},"dijit/layout/_TabContainerBase":function(){define(["dojo/text!./templates/TabContainer.html","./StackContainer","./utils","../_TemplatedMixin","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style"],function(_563,_564,_565,_566,_567,_568,_569,_56a){return _567("dijit.layout._TabContainerBase",[_564,_566],{tabPosition:"top",baseClass:"dijitTabContainer",tabStrip:false,nested:false,templateString:_563,postMixInProperties:function(){this.baseClass+=this.tabPosition.charAt(0).toUpperCase()+this.tabPosition.substr(1).replace(/-.*/,"");this.srcNodeRef&&_56a.set(this.srcNodeRef,"visibility","hidden");this.inherited(arguments);},buildRendering:function(){this.inherited(arguments);this.tablist=this._makeController(this.tablistNode);if(!this.doLayout){_568.add(this.domNode,"dijitTabContainerNoLayout");}if(this.nested){_568.add(this.domNode,"dijitTabContainerNested");_568.add(this.tablist.containerNode,"dijitTabContainerTabListNested");_568.add(this.tablistSpacer,"dijitTabContainerSpacerNested");_568.add(this.containerNode,"dijitTabPaneWrapperNested");}else{_568.add(this.domNode,"tabStrip-"+(this.tabStrip?"enabled":"disabled"));}},_setupChild:function(tab){_568.add(tab.domNode,"dijitTabPane");this.inherited(arguments);},startup:function(){if(this._started){return;}this.tablist.startup();this.inherited(arguments);},layout:function(){if(!this._contentBox||typeof (this._contentBox.l)=="undefined"){return;}var sc=this.selectedChildWidget;if(this.doLayout){var _56b=this.tabPosition.replace(/-h/,"");this.tablist.region=_56b;var _56c=[this.tablist,{domNode:this.tablistSpacer,region:_56b},{domNode:this.containerNode,region:"center"}];_565.layoutChildren(this.domNode,this._contentBox,_56c);this._containerContentBox=_565.marginBox2contentBox(this.containerNode,_56c[2]);if(sc&&sc.resize){sc.resize(this._containerContentBox);}}else{if(this.tablist.resize){var s=this.tablist.domNode.style;s.width="0";var _56d=_569.getContentBox(this.domNode).w;s.width="";this.tablist.resize({w:_56d});}if(sc&&sc.resize){sc.resize();}}},destroy:function(_56e){if(this.tablist){this.tablist.destroy(_56e);}this.inherited(arguments);}});});},"dijit/form/Form":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/_base/kernel","dojo/sniff","../_Widget","../_TemplatedMixin","./_FormMixin","../layout/_ContentPaneResizeMixin"],function(_56f,_570,_571,has,_572,_573,_574,_575){return _56f("dijit.form.Form",[_572,_573,_574,_575],{name:"",action:"",method:"",encType:"","accept-charset":"",accept:"",target:"",templateString:"<form data-dojo-attach-point='containerNode' data-dojo-attach-event='onreset:_onReset,onsubmit:_onSubmit' ${!nameAttrSetting}></form>",postMixInProperties:function(){this.nameAttrSetting=this.name?("name='"+this.name+"'"):"";this.inherited(arguments);},execute:function(){},onExecute:function(){},_setEncTypeAttr:function(_576){_570.set(this.domNode,"encType",_576);if(has("ie")){this.domNode.encoding=_576;}this._set("encType",_576);},reset:function(e){var faux={returnValue:true,preventDefault:function(){this.returnValue=false;},stopPropagation:function(){},currentTarget:e?e.target:this.domNode,target:e?e.target:this.domNode};if(!(this.onReset(faux)===false)&&faux.returnValue){this.inherited(arguments,[]);}},onReset:function(){return true;},_onReset:function(e){this.reset(e);e.stopPropagation();e.preventDefault();return false;},_onSubmit:function(e){var fp=this.constructor.prototype;if(this.execute!=fp.execute||this.onExecute!=fp.onExecute){_571.deprecated("dijit.form.Form:execute()/onExecute() are deprecated. Use onSubmit() instead.","","2.0");this.onExecute();this.execute(this.getValues());}if(this.onSubmit(e)===false){e.stopPropagation();e.preventDefault();}},onSubmit:function(){return this.isValid();},submit:function(){if(!(this.onSubmit()===false)){this.containerNode.submit();}}});});},"dojo/store/Memory":function(){define(["../_base/declare","./util/QueryResults","./util/SimpleQueryEngine"],function(_577,_578,_579){var base=null;return _577("dojo.store.Memory",base,{constructor:function(_57a){for(var i in _57a){this[i]=_57a[i];}this.setData(this.data||[]);},data:null,idProperty:"id",index:null,queryEngine:_579,get:function(id){return this.data[this.index[id]];},getIdentity:function(_57b){return _57b[this.idProperty];},put:function(_57c,_57d){var data=this.data,_57e=this.index,_57f=this.idProperty;var id=_57c[_57f]=(_57d&&"id" in _57d)?_57d.id:_57f in _57c?_57c[_57f]:Math.random();if(id in _57e){if(_57d&&_57d.overwrite===false){throw new Error("Object already exists");}data[_57e[id]]=_57c;}else{_57e[id]=data.push(_57c)-1;}return id;},add:function(_580,_581){(_581=_581||{}).overwrite=false;return this.put(_580,_581);},remove:function(id){var _582=this.index;var data=this.data;if(id in _582){data.splice(_582[id],1);this.setData(data);return true;}},query:function(_583,_584){return _578(this.queryEngine(_583,_584)(this.data));},setData:function(data){if(data.items){this.idProperty=data.identifier;data=this.data=data.items;}else{this.data=data;}this.index={};for(var i=0,l=data.length;i<l;i++){this.index[data[i][this.idProperty]]=i;}}});});},"dijit/Editor":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/Deferred","dojo/i18n","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/string","dojo/topic","./_Container","./Toolbar","./ToolbarSeparator","./layout/_LayoutWidget","./form/ToggleButton","./_editor/_Plugin","./_editor/plugins/EnterKeyHandling","./_editor/html","./_editor/range","./_editor/RichText","./main","dojo/i18n!./_editor/nls/commands"],function(_585,_586,_587,_588,i18n,_589,_58a,_58b,_58c,keys,lang,has,_58d,_58e,_58f,_590,_591,_592,_593,_594,_595,html,_596,_597,_598){var _599=_587("dijit.Editor",_597,{plugins:null,extraPlugins:null,constructor:function(){if(!lang.isArray(this.plugins)){this.plugins=["undo","redo","|","cut","copy","paste","|","bold","italic","underline","strikethrough","|","insertOrderedList","insertUnorderedList","indent","outdent","|","justifyLeft","justifyRight","justifyCenter","justifyFull",_595];}this._plugins=[];this._editInterval=this.editActionInterval*1000;if(has("ie")){this.events.push("onBeforeDeactivate");this.events.push("onBeforeActivate");}},postMixInProperties:function(){this.setValueDeferred=new _588();this.inherited(arguments);},postCreate:function(){this.inherited(arguments);this._steps=this._steps.slice(0);this._undoedSteps=this._undoedSteps.slice(0);if(lang.isArray(this.extraPlugins)){this.plugins=this.plugins.concat(this.extraPlugins);}this.commands=i18n.getLocalization("dijit._editor","commands",this.lang);if(has("webkit")){_58c.set(this.domNode,"KhtmlUserSelect","none");}},startup:function(){this.inherited(arguments);if(!this.toolbar){this.toolbar=new _590({ownerDocument:this.ownerDocument,dir:this.dir,lang:this.lang,"aria-label":this.id});this.header.appendChild(this.toolbar.domNode);}_586.forEach(this.plugins,this.addPlugin,this);this.setValueDeferred.resolve(true);_58a.add(this.iframe.parentNode,"dijitEditorIFrameContainer");_58a.add(this.iframe,"dijitEditorIFrame");_589.set(this.iframe,"allowTransparency",true);this.toolbar.startup();this.onNormalizedDisplayChanged();},destroy:function(){_586.forEach(this._plugins,function(p){if(p&&p.destroy){p.destroy();}});this._plugins=[];this.toolbar.destroyRecursive();delete this.toolbar;this.inherited(arguments);},addPlugin:function(_59a,_59b){var args=lang.isString(_59a)?{name:_59a}:lang.isFunction(_59a)?{ctor:_59a}:_59a;if(!args.setEditor){var o={"args":args,"plugin":null,"editor":this};if(args.name){if(_594.registry[args.name]){o.plugin=_594.registry[args.name](args);}else{_58e.publish(_598._scopeName+".Editor.getPlugin",o);}}if(!o.plugin){try{var pc=args.ctor||lang.getObject(args.name)||_585(args.name);if(pc){o.plugin=new pc(args);}}catch(e){throw new Error(this.id+": cannot find plugin ["+args.name+"]");}}if(!o.plugin){throw new Error(this.id+": cannot find plugin ["+args.name+"]");}_59a=o.plugin;}if(arguments.length>1){this._plugins[_59b]=_59a;}else{this._plugins.push(_59a);}_59a.setEditor(this);if(lang.isFunction(_59a.setToolbar)){_59a.setToolbar(this.toolbar);}},resize:function(size){if(size){_592.prototype.resize.apply(this,arguments);}},layout:function(){var _59c=(this._contentBox.h-(this.getHeaderHeight()+this.getFooterHeight()+_58b.getPadBorderExtents(this.iframe.parentNode).h+_58b.getMarginExtents(this.iframe.parentNode).h));this.editingArea.style.height=_59c+"px";if(this.iframe){this.iframe.style.height="100%";}this._layoutMode=true;},_onIEMouseDown:function(e){var _59d;var b=this.document.body;var _59e=b.clientWidth;var _59f=b.clientHeight;var _5a0=b.clientLeft;var _5a1=b.offsetWidth;var _5a2=b.offsetHeight;var _5a3=b.offsetLeft;if(/^rtl$/i.test(b.dir||"")){if(_59e<_5a1&&e.x>_59e&&e.x<_5a1){_59d=true;}}else{if(e.x<_5a0&&e.x>_5a3){_59d=true;}}if(!_59d){if(_59f<_5a2&&e.y>_59f&&e.y<_5a2){_59d=true;}}if(!_59d){delete this._cursorToStart;delete this._savedSelection;if(e.target.tagName=="BODY"){this.defer("placeCursorAtEnd");}this.inherited(arguments);}},onBeforeActivate:function(){this._restoreSelection();},onBeforeDeactivate:function(e){if(this.customUndo){this.endEditing(true);}if(e.target.tagName!="BODY"){this._saveSelection();}},customUndo:true,editActionInterval:3,beginEditing:function(cmd){if(!this._inEditing){this._inEditing=true;this._beginEditing(cmd);}if(this.editActionInterval>0){if(this._editTimer){this._editTimer.remove();}this._editTimer=this.defer("endEditing",this._editInterval);}},_steps:[],_undoedSteps:[],execCommand:function(cmd){if(this.customUndo&&(cmd=="undo"||cmd=="redo")){return this[cmd]();}else{if(this.customUndo){this.endEditing();this._beginEditing();}var r=this.inherited(arguments);if(this.customUndo){this._endEditing();}return r;}},_pasteImpl:function(){return this._clipboardCommand("paste");},_cutImpl:function(){return this._clipboardCommand("cut");},_copyImpl:function(){return this._clipboardCommand("copy");},_clipboardCommand:function(cmd){var r;try{r=this.document.execCommand(cmd,false,null);if(has("webkit")&&!r){throw {code:1011};}}catch(e){if(e.code==1011||(e.code==9&&has("opera"))){var sub=_58d.substitute,_5a4={cut:"X",copy:"C",paste:"V"};alert(sub(this.commands.systemShortcut,[this.commands[cmd],sub(this.commands[has("mac")?"appleKey":"ctrlKey"],[_5a4[cmd]])]));}r=false;}return r;},queryCommandEnabled:function(cmd){if(this.customUndo&&(cmd=="undo"||cmd=="redo")){return cmd=="undo"?(this._steps.length>1):(this._undoedSteps.length>0);}else{return this.inherited(arguments);}},_moveToBookmark:function(b){var _5a5=b.mark;var mark=b.mark;var col=b.isCollapsed;var r,_5a6,_5a7,sel;if(mark){if(has("ie")<9){if(lang.isArray(mark)){_5a5=[];_586.forEach(mark,function(n){_5a5.push(_596.getNode(n,this.editNode));},this);this.selection.moveToBookmark({mark:_5a5,isCollapsed:col});}else{if(mark.startContainer&&mark.endContainer){sel=_596.getSelection(this.window);if(sel&&sel.removeAllRanges){sel.removeAllRanges();r=_596.create(this.window);_5a6=_596.getNode(mark.startContainer,this.editNode);_5a7=_596.getNode(mark.endContainer,this.editNode);if(_5a6&&_5a7){r.setStart(_5a6,mark.startOffset);r.setEnd(_5a7,mark.endOffset);sel.addRange(r);}}}}}else{sel=_596.getSelection(this.window);if(sel&&sel.removeAllRanges){sel.removeAllRanges();r=_596.create(this.window);_5a6=_596.getNode(mark.startContainer,this.editNode);_5a7=_596.getNode(mark.endContainer,this.editNode);if(_5a6&&_5a7){r.setStart(_5a6,mark.startOffset);r.setEnd(_5a7,mark.endOffset);sel.addRange(r);}}}}},_changeToStep:function(from,to){this.setValue(to.text);var b=to.bookmark;if(!b){return;}this._moveToBookmark(b);},undo:function(){var ret=false;if(!this._undoRedoActive){this._undoRedoActive=true;this.endEditing(true);var s=this._steps.pop();if(s&&this._steps.length>0){this.focus();this._changeToStep(s,this._steps[this._steps.length-1]);this._undoedSteps.push(s);this.onDisplayChanged();delete this._undoRedoActive;ret=true;}delete this._undoRedoActive;}return ret;},redo:function(){var ret=false;if(!this._undoRedoActive){this._undoRedoActive=true;this.endEditing(true);var s=this._undoedSteps.pop();if(s&&this._steps.length>0){this.focus();this._changeToStep(this._steps[this._steps.length-1],s);this._steps.push(s);this.onDisplayChanged();ret=true;}delete this._undoRedoActive;}return ret;},endEditing:function(_5a8){if(this._editTimer){this._editTimer=this._editTimer.remove();}if(this._inEditing){this._endEditing(_5a8);this._inEditing=false;}},_getBookmark:function(){var b=this.selection.getBookmark();var tmp=[];if(b&&b.mark){var mark=b.mark;if(has("ie")<9){var sel=_596.getSelection(this.window);if(!lang.isArray(mark)){if(sel){var _5a9;if(sel.rangeCount){_5a9=sel.getRangeAt(0);}if(_5a9){b.mark=_5a9.cloneRange();}else{b.mark=this.selection.getBookmark();}}}else{_586.forEach(b.mark,function(n){tmp.push(_596.getIndex(n,this.editNode).o);},this);b.mark=tmp;}}try{if(b.mark&&b.mark.startContainer){tmp=_596.getIndex(b.mark.startContainer,this.editNode).o;b.mark={startContainer:tmp,startOffset:b.mark.startOffset,endContainer:b.mark.endContainer===b.mark.startContainer?tmp:_596.getIndex(b.mark.endContainer,this.editNode).o,endOffset:b.mark.endOffset};}}catch(e){b.mark=null;}}return b;},_beginEditing:function(){if(this._steps.length===0){this._steps.push({"text":html.getChildrenHtml(this.editNode),"bookmark":this._getBookmark()});}},_endEditing:function(){var v=html.getChildrenHtml(this.editNode);this._undoedSteps=[];this._steps.push({text:v,bookmark:this._getBookmark()});},onKeyDown:function(e){if(!has("ie")&&!this.iframe&&e.keyCode==keys.TAB&&!this.tabIndent){this._saveSelection();}if(!this.customUndo){this.inherited(arguments);return;}var k=e.keyCode;if(e.ctrlKey&&!e.shiftKey&&!e.altKey){if(k==90||k==122){e.stopPropagation();e.preventDefault();this.undo();return;}else{if(k==89||k==121){e.stopPropagation();e.preventDefault();this.redo();return;}}}this.inherited(arguments);switch(k){case keys.ENTER:case keys.BACKSPACE:case keys.DELETE:this.beginEditing();break;case 88:case 86:if(e.ctrlKey&&!e.altKey&&!e.metaKey){this.endEditing();if(e.keyCode==88){this.beginEditing("cut");}else{this.beginEditing("paste");}this.defer("endEditing",1);break;}default:if(!e.ctrlKey&&!e.altKey&&!e.metaKey&&(e.keyCode<keys.F1||e.keyCode>keys.F15)){this.beginEditing();break;}case keys.ALT:this.endEditing();break;case keys.UP_ARROW:case keys.DOWN_ARROW:case keys.LEFT_ARROW:case keys.RIGHT_ARROW:case keys.HOME:case keys.END:case keys.PAGE_UP:case keys.PAGE_DOWN:this.endEditing(true);break;case keys.CTRL:case keys.SHIFT:case keys.TAB:break;}},_onBlur:function(){this.inherited(arguments);this.endEditing(true);},_saveSelection:function(){try{this._savedSelection=this._getBookmark();}catch(e){}},_restoreSelection:function(){if(this._savedSelection){delete this._cursorToStart;if(this.selection.isCollapsed()){this._moveToBookmark(this._savedSelection);}delete this._savedSelection;}},onClick:function(){this.endEditing(true);this.inherited(arguments);},replaceValue:function(html){if(!this.customUndo){this.inherited(arguments);}else{if(this.isClosed){this.setValue(html);}else{this.beginEditing();if(!html){html="&#160;";}this.setValue(html);this.endEditing();}}},_setDisabledAttr:function(_5aa){this.setValueDeferred.then(lang.hitch(this,function(){if((!this.disabled&&_5aa)||(!this._buttonEnabledPlugins&&_5aa)){_586.forEach(this._plugins,function(p){p.set("disabled",true);});}else{if(this.disabled&&!_5aa){_586.forEach(this._plugins,function(p){p.set("disabled",false);});}}}));this.inherited(arguments);},_setStateClass:function(){try{this.inherited(arguments);if(this.document&&this.document.body){_58c.set(this.document.body,"color",_58c.get(this.iframe,"color"));}}catch(e){}}});function _5ab(args){return new _594({command:args.name});};function _5ac(args){return new _594({buttonClass:_593,command:args.name});};lang.mixin(_594.registry,{"undo":_5ab,"redo":_5ab,"cut":_5ab,"copy":_5ab,"paste":_5ab,"insertOrderedList":_5ab,"insertUnorderedList":_5ab,"indent":_5ab,"outdent":_5ab,"justifyCenter":_5ab,"justifyFull":_5ab,"justifyLeft":_5ab,"justifyRight":_5ab,"delete":_5ab,"selectAll":_5ab,"removeFormat":_5ab,"unlink":_5ab,"insertHorizontalRule":_5ab,"bold":_5ac,"italic":_5ac,"underline":_5ac,"strikethrough":_5ac,"subscript":_5ac,"superscript":_5ac,"|":function(){return new _594({setEditor:function(_5ad){this.editor=_5ad;this.button=new _591({ownerDocument:_5ad.ownerDocument});}});}});return _599;});},"dijit/Toolbar":function(){define(["require","dojo/_base/declare","dojo/has","dojo/keys","dojo/ready","./_Widget","./_KeyNavContainer","./_TemplatedMixin"],function(_5ae,_5af,has,keys,_5b0,_5b1,_5b2,_5b3){if(has("dijit-legacy-requires")){_5b0(0,function(){var _5b4=["dijit/ToolbarSeparator"];_5ae(_5b4);});}return _5af("dijit.Toolbar",[_5b1,_5b3,_5b2],{templateString:"<div class=\"dijit\" role=\"toolbar\" tabIndex=\"${tabIndex}\" data-dojo-attach-point=\"containerNode\">"+"</div>",baseClass:"dijitToolbar",_onLeftArrow:function(){this.focusPrev();},_onRightArrow:function(){this.focusNext();}});});},"dijit/layout/StackContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/has","dojo/_base/lang","dojo/on","dojo/ready","dojo/topic","dojo/when","../registry","../_WidgetBase","./_LayoutWidget","dojo/i18n!../nls/common"],function(_5b5,_5b6,_5b7,_5b8,_5b9,has,lang,on,_5ba,_5bb,when,_5bc,_5bd,_5be){if(has("dijit-legacy-requires")){_5ba(0,function(){var _5bf=["dijit/layout/StackController"];require(_5bf);});}var _5c0=_5b7("dijit.layout.StackContainer",_5be,{doLayout:true,persist:false,baseClass:"dijitStackContainer",buildRendering:function(){this.inherited(arguments);_5b8.add(this.domNode,"dijitLayoutContainer");},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKeyDown")));},startup:function(){if(this._started){return;}var _5c1=this.getChildren();_5b5.forEach(_5c1,this._setupChild,this);if(this.persist){this.selectedChildWidget=_5bc.byId(_5b6(this.id+"_selectedChild"));}else{_5b5.some(_5c1,function(_5c2){if(_5c2.selected){this.selectedChildWidget=_5c2;}return _5c2.selected;},this);}var _5c3=this.selectedChildWidget;if(!_5c3&&_5c1[0]){_5c3=this.selectedChildWidget=_5c1[0];_5c3.selected=true;}_5bb.publish(this.id+"-startup",{children:_5c1,selected:_5c3,textDir:this.textDir});this.inherited(arguments);},resize:function(){if(!this._hasBeenShown){this._hasBeenShown=true;var _5c4=this.selectedChildWidget;if(_5c4){this._showChild(_5c4);}}this.inherited(arguments);},_setupChild:function(_5c5){var _5c6=_5c5.domNode,_5c7=_5b9.place("<div role='tabpanel' class='"+this.baseClass+"ChildWrapper dijitHidden'>",_5c5.domNode,"replace"),_5c8=_5c5["aria-label"]||_5c5.title||_5c5.label;if(_5c8){_5c7.setAttribute("aria-label",_5c8);}_5b9.place(_5c6,_5c7);_5c5._wrapper=_5c7;this.inherited(arguments);if(_5c6.style.display=="none"){_5c6.style.display="block";}_5c5.domNode.title="";},addChild:function(_5c9,_5ca){this.inherited(arguments);if(this._started){_5bb.publish(this.id+"-addChild",_5c9,_5ca);this.layout();if(!this.selectedChildWidget){this.selectChild(_5c9);}}},removeChild:function(page){var idx=_5b5.indexOf(this.getChildren(),page);this.inherited(arguments);_5b9.destroy(page._wrapper);delete page._wrapper;if(this._started){_5bb.publish(this.id+"-removeChild",page);}if(this._descendantsBeingDestroyed){return;}if(this.selectedChildWidget===page){this.selectedChildWidget=undefined;if(this._started){var _5cb=this.getChildren();if(_5cb.length){this.selectChild(_5cb[Math.max(idx-1,0)]);}}}if(this._started){this.layout();}},selectChild:function(page,_5cc){var d;page=_5bc.byId(page);if(this.selectedChildWidget!=page){d=this._transition(page,this.selectedChildWidget,_5cc);this._set("selectedChildWidget",page);_5bb.publish(this.id+"-selectChild",page);if(this.persist){_5b6(this.id+"_selectedChild",this.selectedChildWidget.id);}}return when(d||true);},_transition:function(_5cd,_5ce){if(_5ce){this._hideChild(_5ce);}var d=this._showChild(_5cd);if(_5cd.resize){if(this.doLayout){_5cd.resize(this._containerContentBox||this._contentBox);}else{_5cd.resize();}}return d;},_adjacent:function(_5cf){var _5d0=this.getChildren();var _5d1=_5b5.indexOf(_5d0,this.selectedChildWidget);_5d1+=_5cf?1:_5d0.length-1;return _5d0[_5d1%_5d0.length];},forward:function(){return this.selectChild(this._adjacent(true),true);},back:function(){return this.selectChild(this._adjacent(false),true);},_onKeyDown:function(e){_5bb.publish(this.id+"-containerKeyDown",{e:e,page:this});},layout:function(){var _5d2=this.selectedChildWidget;if(_5d2&&_5d2.resize){if(this.doLayout){_5d2.resize(this._containerContentBox||this._contentBox);}else{_5d2.resize();}}},_showChild:function(page){var _5d3=this.getChildren();page.isFirstChild=(page==_5d3[0]);page.isLastChild=(page==_5d3[_5d3.length-1]);page._set("selected",true);if(page._wrapper){_5b8.replace(page._wrapper,"dijitVisible","dijitHidden");}return (page._onShow&&page._onShow())||true;},_hideChild:function(page){page._set("selected",false);if(page._wrapper){_5b8.replace(page._wrapper,"dijitHidden","dijitVisible");}page.onHide&&page.onHide();},closeChild:function(page){var _5d4=page.onClose&&page.onClose(this,page);if(_5d4){this.removeChild(page);page.destroyRecursive();}},destroyDescendants:function(_5d5){this._descendantsBeingDestroyed=true;this.selectedChildWidget=undefined;_5b5.forEach(this.getChildren(),function(_5d6){if(!_5d5){this.removeChild(_5d6);}_5d6.destroyRecursive(_5d5);},this);this._descendantsBeingDestroyed=false;}});_5c0.ChildWidgetProperties={selected:false,disabled:false,closable:false,iconClass:"dijitNoIcon",showTitle:true};lang.extend(_5bd,_5c0.ChildWidgetProperties);return _5c0;});},"dojo/regexp":function(){define(["./_base/kernel","./_base/lang"],function(dojo,lang){var _5d7={};lang.setObject("dojo.regexp",_5d7);_5d7.escapeString=function(str,_5d8){return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g,function(ch){if(_5d8&&_5d8.indexOf(ch)!=-1){return ch;}return "\\"+ch;});};_5d7.buildGroupRE=function(arr,re,_5d9){if(!(arr instanceof Array)){return re(arr);}var b=[];for(var i=0;i<arr.length;i++){b.push(re(arr[i]));}return _5d7.group(b.join("|"),_5d9);};_5d7.group=function(_5da,_5db){return "("+(_5db?"?:":"")+_5da+")";};return _5d7;});},"dijit/form/ComboBox":function(){define(["dojo/_base/declare","./ValidationTextBox","./ComboBoxMixin"],function(_5dc,_5dd,_5de){return _5dc("dijit.form.ComboBox",[_5dd,_5de],{});});},"dijit/_editor/plugins/LinkDialog":function(){define(["require","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/query","dojo/string","../../_Widget","../_Plugin","../../form/DropDownButton","../range"],function(_5df,_5e0,_5e1,keys,lang,on,has,_5e2,_5e3,_5e4,_5e5,_5e6,_5e7){var _5e8=_5e0("dijit._editor.plugins.LinkDialog",_5e5,{buttonClass:_5e6,useDefaultCommand:false,urlRegExp:"((https?|ftps?|file)\\://|./|../|/|)(/[a-zA-Z]{1,1}:/|)(((?:(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)\\.)*(?:[a-zA-Z](?:[-\\da-zA-Z]{0,80}[\\da-zA-Z])?)\\.?)|(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])|(0[xX]0*[\\da-fA-F]?[\\da-fA-F]\\.){3}0[xX]0*[\\da-fA-F]?[\\da-fA-F]|(0+[0-3][0-7][0-7]\\.){3}0+[0-3][0-7][0-7]|(0|[1-9]\\d{0,8}|[1-3]\\d{9}|4[01]\\d{8}|42[0-8]\\d{7}|429[0-3]\\d{6}|4294[0-8]\\d{5}|42949[0-5]\\d{4}|429496[0-6]\\d{3}|4294967[01]\\d{2}|42949672[0-8]\\d|429496729[0-5])|0[xX]0*[\\da-fA-F]{1,8}|([\\da-fA-F]{1,4}\\:){7}[\\da-fA-F]{1,4}|([\\da-fA-F]{1,4}\\:){6}((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.){3}(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])))(\\:\\d+)?(/(?:[^?#\\s/]+/)*(?:[^?#\\s/]{0,}(?:\\?[^?#\\s/]*)?(?:#.*)?)?)?",emailRegExp:"<?(mailto\\:)([!#-'*+\\-\\/-9=?A-Z^-~]+[.])*[!#-'*+\\-\\/-9=?A-Z^-~]+"+"@"+"((?:(?:[\\da-zA-Z](?:[-\\da-zA-Z]{0,61}[\\da-zA-Z])?)\\.)+(?:[a-zA-Z](?:[-\\da-zA-Z]{0,6}[\\da-zA-Z])?)\\.?)|localhost|^[^-][a-zA-Z0-9_-]*>?",htmlTemplate:"<a href=\"${urlInput}\" _djrealurl=\"${urlInput}\""+" target=\"${targetSelect}\""+">${textInput}</a>",tag:"a",_hostRxp:/^((([^\[:]+):)?([^@]+)@)?(\[([^\]]+)\]|([^\[:]*))(:([0-9]+))?$/,_userAtRxp:/^([!#-'*+\-\/-9=?A-Z^-~]+[.])*[!#-'*+\-\/-9=?A-Z^-~]+@/i,linkDialogTemplate:["<table role='presentation'><tr><td>","<label for='${id}_urlInput'>${url}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='true' "+"id='${id}_urlInput' name='urlInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_textInput'>${text}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='true' id='${id}_textInput' "+"name='textInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_targetSelect'>${target}</label>","</td><td>","<select id='${id}_targetSelect' name='targetSelect' data-dojo-type='dijit.form.Select'>","<option selected='selected' value='_self'>${currentWindow}</option>","<option value='_blank'>${newWindow}</option>","<option value='_top'>${topWindow}</option>","<option value='_parent'>${parentWindow}</option>","</select>","</td></tr><tr><td colspan='2'>","<button data-dojo-type='dijit.form.Button' type='submit' id='${id}_setButton'>${set}</button>","<button data-dojo-type='dijit.form.Button' type='button' id='${id}_cancelButton'>${buttonCancel}</button>","</td></tr></table>"].join(""),_initButton:function(){this.inherited(arguments);this.button.loadDropDown=lang.hitch(this,"_loadDropDown");this._connectTagEvents();},_loadDropDown:function(_5e9){_5df(["dojo/i18n","../../TooltipDialog","../../registry","../../form/Button","../../form/Select","../../form/ValidationTextBox","dojo/i18n!../../nls/common","dojo/i18n!../nls/LinkDialog"],lang.hitch(this,function(i18n,_5ea,_5eb){var _5ec=this;this.tag=this.command=="insertImage"?"img":"a";var _5ed=lang.delegate(i18n.getLocalization("dijit","common",this.lang),i18n.getLocalization("dijit._editor","LinkDialog",this.lang));var _5ee=(this.dropDown=this.button.dropDown=new _5ea({title:_5ed[this.command+"Title"],ownerDocument:this.editor.ownerDocument,dir:this.editor.dir,execute:lang.hitch(this,"setValue"),onOpen:function(){_5ec._onOpenDialog();_5ea.prototype.onOpen.apply(this,arguments);},onCancel:function(){setTimeout(lang.hitch(_5ec,"_onCloseDialog"),0);}}));_5ed.urlRegExp=this.urlRegExp;_5ed.id=_5eb.getUniqueId(this.editor.id);this._uniqueId=_5ed.id;this._setContent(_5ee.title+"<div style='border-bottom: 1px black solid;padding-bottom:2pt;margin-bottom:4pt'></div>"+_5e3.substitute(this.linkDialogTemplate,_5ed));_5ee.startup();this._urlInput=_5eb.byId(this._uniqueId+"_urlInput");this._textInput=_5eb.byId(this._uniqueId+"_textInput");this._setButton=_5eb.byId(this._uniqueId+"_setButton");this.own(_5eb.byId(this._uniqueId+"_cancelButton").on("click",lang.hitch(this.dropDown,"onCancel")));if(this._urlInput){this.own(this._urlInput.on("change",lang.hitch(this,"_checkAndFixInput")));}if(this._textInput){this.own(this._textInput.on("change",lang.hitch(this,"_checkAndFixInput")));}this._urlRegExp=new RegExp("^"+this.urlRegExp+"$","i");this._emailRegExp=new RegExp("^"+this.emailRegExp+"$","i");this._urlInput.isValid=lang.hitch(this,function(){var _5ef=this._urlInput.get("value");return this._urlRegExp.test(_5ef)||this._emailRegExp.test(_5ef);});this.own(on(_5ee.domNode,"keydown",lang.hitch(this,lang.hitch(this,function(e){if(e&&e.keyCode==keys.ENTER&&!e.shiftKey&&!e.metaKey&&!e.ctrlKey&&!e.altKey){if(!this._setButton.get("disabled")){_5ee.onExecute();_5ee.execute(_5ee.get("value"));}}}))));_5e9();}));},_checkAndFixInput:function(){var self=this;var url=this._urlInput.get("value");var _5f0=function(url){var _5f1=false;var _5f2=false;if(url&&url.length>1){url=lang.trim(url);if(url.indexOf("mailto:")!==0){if(url.indexOf("/")>0){if(url.indexOf("://")===-1){if(url.charAt(0)!=="/"&&url.indexOf("./")&&url.indexOf("../")!==0){if(self._hostRxp.test(url)){_5f1=true;}}}}else{if(self._userAtRxp.test(url)){_5f2=true;}}}}if(_5f1){self._urlInput.set("value","http://"+url);}if(_5f2){self._urlInput.set("value","mailto:"+url);}self._setButton.set("disabled",!self._isValid());};if(this._delayedCheck){clearTimeout(this._delayedCheck);this._delayedCheck=null;}this._delayedCheck=setTimeout(function(){_5f0(url);},250);},_connectTagEvents:function(){this.editor.onLoadDeferred.then(lang.hitch(this,function(){this.own(on(this.editor.editNode,"dblclick",lang.hitch(this,"_onDblClick")));}));},_isValid:function(){return this._urlInput.isValid()&&this._textInput.isValid();},_setContent:function(_5f3){this.dropDown.set({parserScope:"dojo",content:_5f3});},_checkValues:function(args){if(args&&args.urlInput){args.urlInput=args.urlInput.replace(/"/g,"&quot;");}return args;},setValue:function(args){this._onCloseDialog();if(has("ie")<9){var sel=_5e7.getSelection(this.editor.window);var _5f4=sel.getRangeAt(0);var a=_5f4.endContainer;if(a.nodeType===3){a=a.parentNode;}if(a&&(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){a=this.editor.selection.getSelectedElement(this.tag);}if(a&&(a.nodeName&&a.nodeName.toLowerCase()===this.tag)){if(this.editor.queryCommandEnabled("unlink")){this.editor.selection.selectElementChildren(a);this.editor.execCommand("unlink");}}}args=this._checkValues(args);this.editor.execCommand("inserthtml",_5e3.substitute(this.htmlTemplate,args));_5e2("a",this.editor.document).forEach(function(a){if(!a.innerHTML&&!_5e1.has(a,"name")){a.parentNode.removeChild(a);}},this);},_onCloseDialog:function(){if(this.editor.focused){this.editor.focus();}},_getCurrentValues:function(a){var url,text,_5f5;if(a&&a.tagName.toLowerCase()===this.tag){url=a.getAttribute("_djrealurl")||a.getAttribute("href");_5f5=a.getAttribute("target")||"_self";text=a.textContent||a.innerText;this.editor.selection.selectElement(a,true);}else{text=this.editor.selection.getSelectedText();}return {urlInput:url||"",textInput:text||"",targetSelect:_5f5||""};},_onOpenDialog:function(){var a,b,fc;if(has("ie")){var sel=_5e7.getSelection(this.editor.window);if(sel.rangeCount){var _5f6=sel.getRangeAt(0);a=_5f6.endContainer;if(a.nodeType===3){a=a.parentNode;}if(a&&(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){a=this.editor.selection.getSelectedElement(this.tag);}if(!a||(a.nodeName&&a.nodeName.toLowerCase()!==this.tag)){b=this.editor.selection.getAncestorElement(this.tag);if(b&&(b.nodeName&&b.nodeName.toLowerCase()==this.tag)){a=b;this.editor.selection.selectElement(a);}else{if(_5f6.startContainer===_5f6.endContainer){fc=_5f6.startContainer.firstChild;if(fc&&(fc.nodeName&&fc.nodeName.toLowerCase()==this.tag)){a=fc;this.editor.selection.selectElement(a);}}}}}}else{a=this.editor.selection.getAncestorElement(this.tag);}this.dropDown.reset();this._setButton.set("disabled",true);this.dropDown.set("value",this._getCurrentValues(a));},_onDblClick:function(e){if(e&&e.target){var t=e.target;var tg=t.tagName?t.tagName.toLowerCase():"";if(tg===this.tag&&_5e1.get(t,"href")){var _5f7=this.editor;this.editor.selection.selectElement(t);_5f7.onDisplayChanged();if(_5f7._updateTimer){_5f7._updateTimer.remove();delete _5f7._updateTimer;}_5f7.onNormalizedDisplayChanged();var _5f8=this.button;setTimeout(function(){_5f8.set("disabled",false);_5f8.loadAndOpenDropDown().then(function(){if(_5f8.dropDown.focus){_5f8.dropDown.focus();}});},10);}}}});var _5f9=_5e0("dijit._editor.plugins.ImgLinkDialog",[_5e8],{linkDialogTemplate:["<table role='presentation'><tr><td>","<label for='${id}_urlInput'>${url}</label>","</td><td>","<input dojoType='dijit.form.ValidationTextBox' regExp='${urlRegExp}' "+"required='true' id='${id}_urlInput' name='urlInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","<label for='${id}_textInput'>${text}</label>","</td><td>","<input data-dojo-type='dijit.form.ValidationTextBox' required='false' id='${id}_textInput' "+"name='textInput' data-dojo-props='intermediateChanges:true'/>","</td></tr><tr><td>","</td><td>","</td></tr><tr><td colspan='2'>","<button data-dojo-type='dijit.form.Button' type='submit' id='${id}_setButton'>${set}</button>","<button data-dojo-type='dijit.form.Button' type='button' id='${id}_cancelButton'>${buttonCancel}</button>","</td></tr></table>"].join(""),htmlTemplate:"<img src=\"${urlInput}\" _djrealurl=\"${urlInput}\" alt=\"${textInput}\" />",tag:"img",_getCurrentValues:function(img){var url,text;if(img&&img.tagName.toLowerCase()===this.tag){url=img.getAttribute("_djrealurl")||img.getAttribute("src");text=img.getAttribute("alt");this.editor.selection.selectElement(img,true);}else{text=this.editor.selection.getSelectedText();}return {urlInput:url||"",textInput:text||""};},_isValid:function(){return this._urlInput.isValid();},_connectTagEvents:function(){this.inherited(arguments);this.editor.onLoadDeferred.then(lang.hitch(this,function(){this.own(on(this.editor.editNode,"mousedown",lang.hitch(this,"_selectTag")));}));},_selectTag:function(e){if(e&&e.target){var t=e.target;var tg=t.tagName?t.tagName.toLowerCase():"";if(tg===this.tag){this.editor.selection.selectElement(t);}}},_checkValues:function(args){if(args&&args.urlInput){args.urlInput=args.urlInput.replace(/"/g,"&quot;");}if(args&&args.textInput){args.textInput=args.textInput.replace(/"/g,"&quot;");}return args;},_onDblClick:function(e){if(e&&e.target){var t=e.target;var tg=t.tagName?t.tagName.toLowerCase():"";if(tg===this.tag&&_5e1.get(t,"src")){var _5fa=this.editor;this.editor.selection.selectElement(t);_5fa.onDisplayChanged();if(_5fa._updateTimer){_5fa._updateTimer.remove();delete _5fa._updateTimer;}_5fa.onNormalizedDisplayChanged();var _5fb=this.button;setTimeout(function(){_5fb.set("disabled",false);_5fb.loadAndOpenDropDown().then(function(){if(_5fb.dropDown.focus){_5fb.dropDown.focus();}});},10);}}}});_5e5.registry["createLink"]=function(){return new _5e8({command:"createLink"});};_5e5.registry["insertImage"]=function(){return new _5f9({command:"insertImage"});};_5e8.ImgLinkDialog=_5f9;return _5e8;});},"dijit/DropDownMenu":function(){define(["dojo/_base/declare","dojo/keys","dojo/text!./templates/Menu.html","./_OnDijitClickMixin","./_MenuBase"],function(_5fc,keys,_5fd,_5fe,_5ff){return _5fc("dijit.DropDownMenu",[_5ff,_5fe],{templateString:_5fd,baseClass:"dijitMenu",_onUpArrow:function(){this.focusPrev();},_onDownArrow:function(){this.focusNext();},_onRightArrow:function(evt){this._moveToPopup(evt);evt.stopPropagation();evt.preventDefault();},_onLeftArrow:function(){if(this.parentMenu){if(this.parentMenu._isMenuBar){this.parentMenu.focusPrev();}else{this.onCancel(false);}}else{evt.stopPropagation();evt.preventDefault();}}});});},"dijit/form/_FormMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/window"],function(_600,_601,_602,lang,on,_603){return _601("dijit.form._FormMixin",null,{state:"",_getDescendantFormWidgets:function(_604){var res=[];_600.forEach(_604||this.getChildren(),function(_605){if("value" in _605){res.push(_605);}else{res=res.concat(this._getDescendantFormWidgets(_605.getChildren()));}},this);return res;},reset:function(){_600.forEach(this._getDescendantFormWidgets(),function(_606){if(_606.reset){_606.reset();}});},validate:function(){var _607=false;return _600.every(_600.map(this._getDescendantFormWidgets(),function(_608){_608._hasBeenBlurred=true;var _609=_608.disabled||!_608.validate||_608.validate();if(!_609&&!_607){_603.scrollIntoView(_608.containerNode||_608.domNode);_608.focus();_607=true;}return _609;}),function(item){return item;});},setValues:function(val){_602.deprecated(this.declaredClass+"::setValues() is deprecated. Use set('value', val) instead.","","2.0");return this.set("value",val);},_setValueAttr:function(obj){var map={};_600.forEach(this._getDescendantFormWidgets(),function(_60a){if(!_60a.name){return;}var _60b=map[_60a.name]||(map[_60a.name]=[]);_60b.push(_60a);});for(var name in map){if(!map.hasOwnProperty(name)){continue;}var _60c=map[name],_60d=lang.getObject(name,false,obj);if(_60d===undefined){continue;}_60d=[].concat(_60d);if(typeof _60c[0].checked=="boolean"){_600.forEach(_60c,function(w){w.set("value",_600.indexOf(_60d,w._get("value"))!=-1);});}else{if(_60c[0].multiple){_60c[0].set("value",_60d);}else{_600.forEach(_60c,function(w,i){w.set("value",_60d[i]);});}}}},getValues:function(){_602.deprecated(this.declaredClass+"::getValues() is deprecated. Use get('value') instead.","","2.0");return this.get("value");},_getValueAttr:function(){var obj={};_600.forEach(this._getDescendantFormWidgets(),function(_60e){var name=_60e.name;if(!name||_60e.disabled){return;}var _60f=_60e.get("value");if(typeof _60e.checked=="boolean"){if(/Radio/.test(_60e.declaredClass)){if(_60f!==false){lang.setObject(name,_60f,obj);}else{_60f=lang.getObject(name,false,obj);if(_60f===undefined){lang.setObject(name,null,obj);}}}else{var ary=lang.getObject(name,false,obj);if(!ary){ary=[];lang.setObject(name,ary,obj);}if(_60f!==false){ary.push(_60f);}}}else{var prev=lang.getObject(name,false,obj);if(typeof prev!="undefined"){if(lang.isArray(prev)){prev.push(_60f);}else{lang.setObject(name,[prev,_60f],obj);}}else{lang.setObject(name,_60f,obj);}}});return obj;},isValid:function(){return this.state=="";},onValidStateChange:function(){},_getState:function(){var _610=_600.map(this._descendants,function(w){return w.get("state")||"";});return _600.indexOf(_610,"Error")>=0?"Error":_600.indexOf(_610,"Incomplete")>=0?"Incomplete":"";},disconnectChildren:function(){},connectChildren:function(_611){this._descendants=this._getDescendantFormWidgets();_600.forEach(this._descendants,function(_612){if(!_612._started){_612.startup();}});if(!_611){this._onChildChange();}},_onChildChange:function(attr){if(!attr||attr=="state"||attr=="disabled"){this._set("state",this._getState());}if(!attr||attr=="value"||attr=="disabled"||attr=="checked"){if(this._onChangeDelayTimer){this._onChangeDelayTimer.remove();}this._onChangeDelayTimer=this.defer(function(){delete this._onChangeDelayTimer;this._set("value",this.get("value"));},10);}},startup:function(){this.inherited(arguments);this._descendants=this._getDescendantFormWidgets();this.value=this.get("value");this.state=this._getState();var self=this;this.own(on(this.containerNode,"attrmodified-state, attrmodified-disabled, attrmodified-value, attrmodified-checked",function(evt){if(evt.target==self.domNode){return;}self._onChildChange(evt.type.replace("attrmodified-",""));}));this.watch("state",function(attr,_613,_614){this.onValidStateChange(_614=="");});},destroy:function(){this.inherited(arguments);}});});},"dijit/Menu":function(){define(["require","dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window","dojo/window","./popup","./DropDownMenu","dojo/ready"],function(_615,_616,_617,dom,_618,_619,_61a,keys,lang,on,has,win,_61b,pm,_61c,_61d){if(has("dijit-legacy-requires")){_61d(0,function(){var _61e=["dijit/MenuItem","dijit/PopupMenuItem","dijit/CheckedMenuItem","dijit/MenuSeparator"];_615(_61e);});}return _617("dijit.Menu",_61c,{constructor:function(){this._bindings=[];},targetNodeIds:[],selector:"",contextMenuForWindow:false,leftClickToOpen:false,refocus:true,postCreate:function(){if(this.contextMenuForWindow){this.bindDomNode(this.ownerDocumentBody);}else{_616.forEach(this.targetNodeIds,this.bindDomNode,this);}this.inherited(arguments);},_iframeContentWindow:function(_61f){return _61b.get(this._iframeContentDocument(_61f))||this._iframeContentDocument(_61f)["__parent__"]||(_61f.name&&document.frames[_61f.name])||null;},_iframeContentDocument:function(_620){return _620.contentDocument||(_620.contentWindow&&_620.contentWindow.document)||(_620.name&&document.frames[_620.name]&&document.frames[_620.name].document)||null;},bindDomNode:function(node){node=dom.byId(node,this.ownerDocument);var cn;if(node.tagName.toLowerCase()=="iframe"){var _621=node,_622=this._iframeContentWindow(_621);cn=win.body(_622.document);}else{cn=(node==win.body(this.ownerDocument)?this.ownerDocument.documentElement:node);}var _623={node:node,iframe:_621};_618.set(node,"_dijitMenu"+this.id,this._bindings.push(_623));var _624=lang.hitch(this,function(cn){var _625=this.selector,_626=_625?function(_627){return on.selector(_625,_627);}:function(_628){return _628;},self=this;return [on(cn,_626(this.leftClickToOpen?"click":"contextmenu"),function(evt){evt.stopPropagation();evt.preventDefault();self._scheduleOpen(this,_621,{x:evt.pageX,y:evt.pageY});}),on(cn,_626("keydown"),function(evt){if(evt.shiftKey&&evt.keyCode==keys.F10){evt.stopPropagation();evt.preventDefault();self._scheduleOpen(this,_621);}})];});_623.connects=cn?_624(cn):[];if(_621){_623.onloadHandler=lang.hitch(this,function(){var _629=this._iframeContentWindow(_621),cn=win.body(_629.document);_623.connects=_624(cn);});if(_621.addEventListener){_621.addEventListener("load",_623.onloadHandler,false);}else{_621.attachEvent("onload",_623.onloadHandler);}}},unBindDomNode:function(_62a){var node;try{node=dom.byId(_62a,this.ownerDocument);}catch(e){return;}var _62b="_dijitMenu"+this.id;if(node&&_618.has(node,_62b)){var bid=_618.get(node,_62b)-1,b=this._bindings[bid],h;while((h=b.connects.pop())){h.remove();}var _62c=b.iframe;if(_62c){if(_62c.removeEventListener){_62c.removeEventListener("load",b.onloadHandler,false);}else{_62c.detachEvent("onload",b.onloadHandler);}}_618.remove(node,_62b);delete this._bindings[bid];}},_scheduleOpen:function(_62d,_62e,_62f){if(!this._openTimer){this._openTimer=this.defer(function(){delete this._openTimer;this._openMyself({target:_62d,iframe:_62e,coords:_62f});},1);}},_openMyself:function(args){var _630=args.target,_631=args.iframe,_632=args.coords,_633=!_632;this.currentTarget=_630;if(_632){if(_631){var ifc=_619.position(_631,true),_634=this._iframeContentWindow(_631),_635=_619.docScroll(_634.document);var cs=_61a.getComputedStyle(_631),tp=_61a.toPixelValue,left=(has("ie")&&has("quirks")?0:tp(_631,cs.paddingLeft))+(has("ie")&&has("quirks")?tp(_631,cs.borderLeftWidth):0),top=(has("ie")&&has("quirks")?0:tp(_631,cs.paddingTop))+(has("ie")&&has("quirks")?tp(_631,cs.borderTopWidth):0);_632.x+=ifc.x+left-_635.x;_632.y+=ifc.y+top-_635.y;}}else{_632=_619.position(_630,true);_632.x+=10;_632.y+=10;}var self=this;var _636=this._focusManager.get("prevNode");var _637=this._focusManager.get("curNode");var _638=!_637||(dom.isDescendant(_637,this.domNode))?_636:_637;function _639(){if(self.refocus&&_638){_638.focus();}pm.close(self);};pm.open({popup:this,x:_632.x,y:_632.y,onExecute:_639,onCancel:_639,orient:this.isLeftToRight()?"L":"R"});this.focus();if(!_633){this.defer(function(){this._cleanUp(true);});}this._onBlur=function(){this.inherited("_onBlur",arguments);pm.close(this);};},destroy:function(){_616.forEach(this._bindings,function(b){if(b){this.unBindDomNode(b.node);}},this);this.inherited(arguments);}});});},"dijit/form/_CheckBoxMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_63a,_63b){return _63a("dijit.form._CheckBoxMixin",null,{type:"checkbox",value:"on",readOnly:false,_aria_attr:"aria-checked",_setReadOnlyAttr:function(_63c){this._set("readOnly",_63c);_63b.set(this.focusNode,"readOnly",_63c);},_setLabelAttr:undefined,_getSubmitValue:function(_63d){return (_63d==null||_63d==="")?"on":_63d;},_setValueAttr:function(_63e){_63e=this._getSubmitValue(_63e);this._set("value",_63e);_63b.set(this.focusNode,"value",_63e);},reset:function(){this.inherited(arguments);this._set("value",this._getSubmitValue(this.params.value));_63b.set(this.focusNode,"value",this.value);},_onClick:function(e){if(this.readOnly){e.stopPropagation();e.preventDefault();return false;}return this.inherited(arguments);}});});},"dijit/layout/ContentPane":function(){define(["dojo/_base/kernel","dojo/_base/lang","../_Widget","../_Container","./_ContentPaneResizeMixin","dojo/string","dojo/html","dojo/i18n!../nls/loading","dojo/_base/array","dojo/_base/declare","dojo/_base/Deferred","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/_base/xhr","dojo/i18n","dojo/when"],function(_63f,lang,_640,_641,_642,_643,html,_644,_645,_646,_647,dom,_648,_649,xhr,i18n,when){return _646("dijit.layout.ContentPane",[_640,_641,_642],{href:"",content:"",extractContent:false,parseOnLoad:true,parserScope:_63f._scopeName,preventCache:false,preload:false,refreshOnShow:false,loadingMessage:"<span class='dijitContentPaneLoading'><span class='dijitInline dijitIconLoading'></span>${loadingState}</span>",errorMessage:"<span class='dijitContentPaneError'><span class='dijitInline dijitIconError'></span>${errorState}</span>",isLoaded:false,baseClass:"dijitContentPane",ioArgs:{},onLoadDeferred:null,_setTitleAttr:null,stopParser:true,template:false,markupFactory:function(_64a,node,ctor){var self=new ctor(_64a,node);return !self.href&&self._contentSetter&&self._contentSetter.parseDeferred&&!self._contentSetter.parseDeferred.isFulfilled()?self._contentSetter.parseDeferred.then(function(){return self;}):self;},create:function(_64b,_64c){if((!_64b||!_64b.template)&&_64c&&!("href" in _64b)&&!("content" in _64b)){_64c=dom.byId(_64c);var df=_64c.ownerDocument.createDocumentFragment();while(_64c.firstChild){df.appendChild(_64c.firstChild);}_64b=lang.delegate(_64b,{content:df});}this.inherited(arguments,[_64b,_64c]);},postMixInProperties:function(){this.inherited(arguments);var _64d=i18n.getLocalization("dijit","loading",this.lang);this.loadingMessage=_643.substitute(this.loadingMessage,_64d);this.errorMessage=_643.substitute(this.errorMessage,_64d);},buildRendering:function(){this.inherited(arguments);if(!this.containerNode){this.containerNode=this.domNode;}this.domNode.removeAttribute("title");},startup:function(){this.inherited(arguments);if(this._contentSetter){_645.forEach(this._contentSetter.parseResults,function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}},this);}},_startChildren:function(){_645.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});if(this._contentSetter){_645.forEach(this._contentSetter.parseResults,function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}},this);}},setHref:function(href){_63f.deprecated("dijit.layout.ContentPane.setHref() is deprecated. Use set('href', ...) instead.","","2.0");return this.set("href",href);},_setHrefAttr:function(href){this.cancel();this.onLoadDeferred=new _647(lang.hitch(this,"cancel"));this.onLoadDeferred.then(lang.hitch(this,"onLoad"));this._set("href",href);if(this.preload||(this._created&&this._isShown())){this._load();}else{this._hrefChanged=true;}return this.onLoadDeferred;},setContent:function(data){_63f.deprecated("dijit.layout.ContentPane.setContent() is deprecated.  Use set('content', ...) instead.","","2.0");this.set("content",data);},_setContentAttr:function(data){this._set("href","");this.cancel();this.onLoadDeferred=new _647(lang.hitch(this,"cancel"));if(this._created){this.onLoadDeferred.then(lang.hitch(this,"onLoad"));}this._setContent(data||"");this._isDownloaded=false;return this.onLoadDeferred;},_getContentAttr:function(){return this.containerNode.innerHTML;},cancel:function(){if(this._xhrDfd&&(this._xhrDfd.fired==-1)){this._xhrDfd.cancel();}delete this._xhrDfd;this.onLoadDeferred=null;},destroy:function(){this.cancel();this.inherited(arguments);},destroyRecursive:function(_64e){if(this._beingDestroyed){return;}this.inherited(arguments);},_onShow:function(){this.inherited(arguments);if(this.href){if(!this._xhrDfd&&(!this.isLoaded||this._hrefChanged||this.refreshOnShow)){return this.refresh();}}},refresh:function(){this.cancel();this.onLoadDeferred=new _647(lang.hitch(this,"cancel"));this.onLoadDeferred.then(lang.hitch(this,"onLoad"));this._load();return this.onLoadDeferred;},_load:function(){this._setContent(this.onDownloadStart(),true);var self=this;var _64f={preventCache:(this.preventCache||this.refreshOnShow),url:this.href,handleAs:"text"};if(lang.isObject(this.ioArgs)){lang.mixin(_64f,this.ioArgs);}var hand=(this._xhrDfd=(this.ioMethod||xhr.get)(_64f)),_650;hand.then(function(html){_650=html;try{self._isDownloaded=true;return self._setContent(html,false);}catch(err){self._onError("Content",err);}},function(err){if(!hand.canceled){self._onError("Download",err);}delete self._xhrDfd;return err;}).then(function(){self.onDownloadEnd();delete self._xhrDfd;return _650;});delete this._hrefChanged;},_onLoadHandler:function(data){this._set("isLoaded",true);try{this.onLoadDeferred.resolve(data);}catch(e){console.error("Error "+this.widgetId+" running custom onLoad code: "+e.message);}},_onUnloadHandler:function(){this._set("isLoaded",false);try{this.onUnload();}catch(e){console.error("Error "+this.widgetId+" running custom onUnload code: "+e.message);}},destroyDescendants:function(_651){if(this.isLoaded){this._onUnloadHandler();}var _652=this._contentSetter;_645.forEach(this.getChildren(),function(_653){if(_653.destroyRecursive){_653.destroyRecursive(_651);}else{if(_653.destroy){_653.destroy(_651);}}_653._destroyed=true;});if(_652){_645.forEach(_652.parseResults,function(_654){if(!_654._destroyed){if(_654.destroyRecursive){_654.destroyRecursive(_651);}else{if(_654.destroy){_654.destroy(_651);}}_654._destroyed=true;}});delete _652.parseResults;}if(!_651){_649.empty(this.containerNode);}delete this._singleChild;},_setContent:function(cont,_655){this.destroyDescendants();var _656=this._contentSetter;if(!(_656&&_656 instanceof html._ContentSetter)){_656=this._contentSetter=new html._ContentSetter({node:this.containerNode,_onError:lang.hitch(this,this._onError),onContentError:lang.hitch(this,function(e){var _657=this.onContentError(e);try{this.containerNode.innerHTML=_657;}catch(e){console.error("Fatal "+this.id+" could not change content due to "+e.message,e);}})});}var _658=lang.mixin({cleanContent:this.cleanContent,extractContent:this.extractContent,parseContent:!cont.domNode&&this.parseOnLoad,parserScope:this.parserScope,startup:false,dir:this.dir,lang:this.lang,textDir:this.textDir},this._contentSetterParams||{});var p=_656.set((lang.isObject(cont)&&cont.domNode)?cont.domNode:cont,_658);var self=this;return when(p&&p.then?p:_656.parseDeferred,function(){delete self._contentSetterParams;if(!_655){if(self._started){self._startChildren();self._scheduleLayout();}self._onLoadHandler(cont);}});},_onError:function(type,err,_659){this.onLoadDeferred.reject(err);var _65a=this["on"+type+"Error"].call(this,err);if(_659){console.error(_659,err);}else{if(_65a){this._setContent(_65a,true);}}},onLoad:function(){},onUnload:function(){},onDownloadStart:function(){return this.loadingMessage;},onContentError:function(){},onDownloadError:function(){return this.errorMessage;},onDownloadEnd:function(){}});});},"dijit/_KeyNavContainer":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/_base/kernel","dojo/keys","dojo/_base/lang","./registry","./_Container","./_FocusMixin","./_KeyNavMixin"],function(_65b,_65c,_65d,_65e,keys,lang,_65f,_660,_661,_662){return _65c("dijit._KeyNavContainer",[_661,_662,_660],{connectKeyNavHandlers:function(_663,_664){var _665=(this._keyNavCodes={});var prev=lang.hitch(this,"focusPrev");var next=lang.hitch(this,"focusNext");_65b.forEach(_663,function(code){_665[code]=prev;});_65b.forEach(_664,function(code){_665[code]=next;});_665[keys.HOME]=lang.hitch(this,"focusFirstChild");_665[keys.END]=lang.hitch(this,"focusLastChild");},startupKeyNavChildren:function(){_65e.deprecated("startupKeyNavChildren() call no longer needed","","2.0");},startup:function(){this.inherited(arguments);_65b.forEach(this.getChildren(),lang.hitch(this,"_startupChild"));},addChild:function(_666,_667){this.inherited(arguments);this._startupChild(_666);},_startupChild:function(_668){_668.set("tabIndex","-1");},_getFirst:function(){var _669=this.getChildren();return _669.length?_669[0]:null;},_getLast:function(){var _66a=this.getChildren();return _66a.length?_66a[_66a.length-1]:null;},focusNext:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,1));},focusPrev:function(){this.focusChild(this._getNextFocusableChild(this.focusedChild,-1),true);},childSelector:function(node){var node=_65f.byNode(node);return node&&node.getParent()==this;}});});},"dijit/layout/utils":function(){define(["dojo/_base/array","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang"],function(_66b,_66c,_66d,_66e,lang){function _66f(word){return word.substring(0,1).toUpperCase()+word.substring(1);};function size(_670,dim){var _671=_670.resize?_670.resize(dim):_66d.setMarginBox(_670.domNode,dim);if(_671){lang.mixin(_670,_671);}else{lang.mixin(_670,_66d.getMarginBox(_670.domNode));lang.mixin(_670,dim);}};var _672={marginBox2contentBox:function(node,mb){var cs=_66e.getComputedStyle(node);var me=_66d.getMarginExtents(node,cs);var pb=_66d.getPadBorderExtents(node,cs);return {l:_66e.toPixelValue(node,cs.paddingLeft),t:_66e.toPixelValue(node,cs.paddingTop),w:mb.w-(me.w+pb.w),h:mb.h-(me.h+pb.h)};},layoutChildren:function(_673,dim,_674,_675,_676){dim=lang.mixin({},dim);_66c.add(_673,"dijitLayoutContainer");_674=_66b.filter(_674,function(item){return item.region!="center"&&item.layoutAlign!="client";}).concat(_66b.filter(_674,function(item){return item.region=="center"||item.layoutAlign=="client";}));_66b.forEach(_674,function(_677){var elm=_677.domNode,pos=(_677.region||_677.layoutAlign);if(!pos){throw new Error("No region setting for "+_677.id);}var _678=elm.style;_678.left=dim.l+"px";_678.top=dim.t+"px";_678.position="absolute";_66c.add(elm,"dijitAlign"+_66f(pos));var _679={};if(_675&&_675==_677.id){_679[_677.region=="top"||_677.region=="bottom"?"h":"w"]=_676;}if(pos=="leading"){pos=_677.isLeftToRight()?"left":"right";}if(pos=="trailing"){pos=_677.isLeftToRight()?"right":"left";}if(pos=="top"||pos=="bottom"){_679.w=dim.w;size(_677,_679);dim.h-=_677.h;if(pos=="top"){dim.t+=_677.h;}else{_678.top=dim.t+dim.h+"px";}}else{if(pos=="left"||pos=="right"){_679.h=dim.h;size(_677,_679);dim.w-=_677.w;if(pos=="left"){dim.l+=_677.w;}else{_678.left=dim.l+dim.w+"px";}}else{if(pos=="client"||pos=="center"){size(_677,dim);}}}});}};lang.setObject("dijit.layout.utils",_672);return _672;});},"dijit/form/DataList":function(){define(["dojo/_base/declare","dojo/dom","dojo/_base/lang","dojo/query","dojo/store/Memory","../registry"],function(_67a,dom,lang,_67b,_67c,_67d){function _67e(_67f){return {id:_67f.value,value:_67f.value,name:lang.trim(_67f.innerText||_67f.textContent||"")};};return _67a("dijit.form.DataList",_67c,{constructor:function(_680,_681){this.domNode=dom.byId(_681);lang.mixin(this,_680);if(this.id){_67d.add(this);}this.domNode.style.display="none";this.inherited(arguments,[{data:_67b("option",this.domNode).map(_67e)}]);},destroy:function(){_67d.remove(this.id);},fetchSelectedItem:function(){var _682=_67b("> option[selected]",this.domNode)[0]||_67b("> option",this.domNode)[0];return _682&&_67e(_682);}});});},"dijit/form/CheckBox":function(){define(["require","dojo/_base/declare","dojo/dom-attr","dojo/has","dojo/query","dojo/ready","./ToggleButton","./_CheckBoxMixin","dojo/text!./templates/CheckBox.html","dojo/NodeList-dom","../a11yclick"],function(_683,_684,_685,has,_686,_687,_688,_689,_68a){if(has("dijit-legacy-requires")){_687(0,function(){var _68b=["dijit/form/RadioButton"];_683(_68b);});}return _684("dijit.form.CheckBox",[_688,_689],{templateString:_68a,baseClass:"dijitCheckBox",_setValueAttr:function(_68c,_68d){if(typeof _68c=="string"){this.inherited(arguments);_68c=true;}if(this._created){this.set("checked",_68c,_68d);}},_getValueAttr:function(){return this.checked&&this._get("value");},_setIconClassAttr:null,_setNameAttr:"focusNode",postMixInProperties:function(){this.inherited(arguments);this.checkedAttrSetting="";},_fillContent:function(){},_onFocus:function(){if(this.id){_686("label[for='"+this.id+"']").addClass("dijitFocusedLabel");}this.inherited(arguments);},_onBlur:function(){if(this.id){_686("label[for='"+this.id+"']").removeClass("dijitFocusedLabel");}this.inherited(arguments);}});});},"dijit/_editor/_Plugin":function(){define(["dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","../Destroyable","../form/Button"],function(_68e,_68f,lang,_690,_691){var _692=_68f("dijit._editor._Plugin",_690,{constructor:function(args){this.params=args||{};lang.mixin(this,this.params);this._attrPairNames={};},editor:null,iconClassPrefix:"dijitEditorIcon",button:null,command:"",useDefaultCommand:true,buttonClass:_691,disabled:false,getLabel:function(key){return this.editor.commands[key];},_initButton:function(){if(this.command.length){var _693=this.getLabel(this.command),_694=this.editor,_695=this.iconClassPrefix+" "+this.iconClassPrefix+this.command.charAt(0).toUpperCase()+this.command.substr(1);if(!this.button){var _696=lang.mixin({label:_693,ownerDocument:_694.ownerDocument,dir:_694.dir,lang:_694.lang,showLabel:false,iconClass:_695,dropDown:this.dropDown,tabIndex:"-1"},this.params||{});this.button=new this.buttonClass(_696);}}if(this.get("disabled")&&this.button){this.button.set("disabled",this.get("disabled"));}},destroy:function(){if(this.dropDown){this.dropDown.destroyRecursive();}this.inherited(arguments);},connect:function(o,f,tf){this.own(_68e.connect(o,f,this,tf));},updateState:function(){var e=this.editor,c=this.command,_697,_698;if(!e||!e.isLoaded||!c.length){return;}var _699=this.get("disabled");if(this.button){try{_698=!_699&&e.queryCommandEnabled(c);if(this.enabled!==_698){this.enabled=_698;this.button.set("disabled",!_698);}if(_698){if(typeof this.button.checked=="boolean"){_697=e.queryCommandState(c);if(this.checked!==_697){this.checked=_697;this.button.set("checked",e.queryCommandState(c));}}}}catch(e){}}},setEditor:function(_69a){this.editor=_69a;this._initButton();if(this.button&&this.useDefaultCommand){if(this.editor.queryCommandAvailable(this.command)){this.own(this.button.on("click",lang.hitch(this.editor,"execCommand",this.command,this.commandArg)));}else{this.button.domNode.style.display="none";}}this.own(this.editor.on("NormalizedDisplayChanged",lang.hitch(this,"updateState")));},setToolbar:function(_69b){if(this.button){_69b.addChild(this.button);}},set:function(name,_69c){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _69d=this._getAttrNames(name);if(this[_69d.s]){var _69e=this[_69d.s].apply(this,Array.prototype.slice.call(arguments,1));}else{this._set(name,_69c);}return _69e||this;},get:function(name){var _69f=this._getAttrNames(name);return this[_69f.g]?this[_69f.g]():this[name];},_setDisabledAttr:function(_6a0){this._set("disabled",_6a0);this.updateState();},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.charAt(0).toUpperCase()+name.substr(1);return (apn[name]={s:"_set"+uc+"Attr",g:"_get"+uc+"Attr"});},_set:function(name,_6a1){this[name]=_6a1;}});_692.registry={};return _692;});},"dijit/tree/_dndSelector":function(){define(["dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/kernel","dojo/_base/lang","dojo/dom","dojo/mouse","dojo/on","dojo/touch","../a11yclick","./_dndContainer"],function(_6a2,_6a3,_6a4,_6a5,lang,dom,_6a6,on,_6a7,_6a8,_6a9){return _6a4("dijit.tree._dndSelector",_6a9,{constructor:function(){this.selection={};this.anchor=null;this.events.push(on(this.tree.domNode,_6a7.press,lang.hitch(this,"onMouseDown")),on(this.tree.domNode,_6a7.release,lang.hitch(this,"onMouseUp")),on(this.tree.domNode,_6a7.move,lang.hitch(this,"onMouseMove")),on(this.tree.domNode,_6a8.press,lang.hitch(this,"onClickPress")),on(this.tree.domNode,_6a8.release,lang.hitch(this,"onClickRelease")));},singular:false,getSelectedTreeNodes:function(){var _6aa=[],sel=this.selection;for(var i in sel){_6aa.push(sel[i]);}return _6aa;},selectNone:function(){this.setSelection([]);return this;},destroy:function(){this.inherited(arguments);this.selection=this.anchor=null;},addTreeNode:function(node,_6ab){this.setSelection(this.getSelectedTreeNodes().concat([node]));if(_6ab){this.anchor=node;}return node;},removeTreeNode:function(node){var _6ac=_6a2.filter(this.getSelectedTreeNodes(),function(_6ad){return !dom.isDescendant(_6ad.domNode,node.domNode);});this.setSelection(_6ac);return node;},isTreeNodeSelected:function(node){return node.id&&!!this.selection[node.id];},setSelection:function(_6ae){var _6af=this.getSelectedTreeNodes();_6a2.forEach(this._setDifference(_6af,_6ae),lang.hitch(this,function(node){node.setSelected(false);if(this.anchor==node){delete this.anchor;}delete this.selection[node.id];}));_6a2.forEach(this._setDifference(_6ae,_6af),lang.hitch(this,function(node){node.setSelected(true);this.selection[node.id]=node;}));this._updateSelectionProperties();},_setDifference:function(xs,ys){_6a2.forEach(ys,function(y){y.__exclude__=true;});var ret=_6a2.filter(xs,function(x){return !x.__exclude__;});_6a2.forEach(ys,function(y){delete y["__exclude__"];});return ret;},_updateSelectionProperties:function(){var _6b0=this.getSelectedTreeNodes();var _6b1=[],_6b2=[],_6b3=[];_6a2.forEach(_6b0,function(node){var ary=node.getTreePath(),_6b4=this.tree.model;_6b2.push(node);_6b1.push(ary);ary=_6a2.map(ary,function(item){return _6b4.getIdentity(item);},this);_6b3.push(ary.join("/"));},this);var _6b5=_6a2.map(_6b2,function(node){return node.item;});this.tree._set("paths",_6b1);this.tree._set("path",_6b1[0]||[]);this.tree._set("selectedNodes",_6b2);this.tree._set("selectedNode",_6b2[0]||null);this.tree._set("selectedItems",_6b5);this.tree._set("selectedItem",_6b5[0]||null);},onClickPress:function(e){if(this.current&&this.current.isExpandable&&this.tree.isExpandoNode(e.target,this.current)){return;}if(_6a6.isLeft(e)){e.preventDefault();}var _6b6=e.type=="keydown"?this.tree.focusedChild:this.current;if(!_6b6){return;}var copy=_6a3.isCopyKey(e),id=_6b6.id;if(!this.singular&&!e.shiftKey&&this.selection[id]){this._doDeselect=true;return;}else{this._doDeselect=false;}this.userSelect(_6b6,copy,e.shiftKey);},onClickRelease:function(e){if(!this._doDeselect){return;}this._doDeselect=false;this.userSelect(e.type=="keyup"?this.tree.focusedChild:this.current,_6a3.isCopyKey(e),e.shiftKey);},onMouseMove:function(){this._doDeselect=false;},onMouseDown:function(){},onMouseUp:function(){},_compareNodes:function(n1,n2){if(n1===n2){return 0;}if("sourceIndex" in document.documentElement){return n1.sourceIndex-n2.sourceIndex;}else{if("compareDocumentPosition" in document.documentElement){return n1.compareDocumentPosition(n2)&2?1:-1;}else{if(document.createRange){var r1=doc.createRange();r1.setStartBefore(n1);var r2=doc.createRange();r2.setStartBefore(n2);return r1.compareBoundaryPoints(r1.END_TO_END,r2);}else{throw Error("dijit.tree._compareNodes don't know how to compare two different nodes in this browser");}}}},userSelect:function(node,_6b7,_6b8){if(this.singular){if(this.anchor==node&&_6b7){this.selectNone();}else{this.setSelection([node]);this.anchor=node;}}else{if(_6b8&&this.anchor){var cr=this._compareNodes(this.anchor.rowNode,node.rowNode),_6b9,end,_6ba=this.anchor;if(cr<0){_6b9=_6ba;end=node;}else{_6b9=node;end=_6ba;}var _6bb=[];while(_6b9!=end){_6bb.push(_6b9);_6b9=this.tree._getNext(_6b9);}_6bb.push(end);this.setSelection(_6bb);}else{if(this.selection[node.id]&&_6b7){this.removeTreeNode(node);}else{if(_6b7){this.addTreeNode(node,true);}else{this.setSelection([node]);this.anchor=node;}}}}},getItem:function(key){var _6bc=this.selection[key];return {data:_6bc,type:["treeNode"]};},forInSelectedItems:function(f,o){o=o||_6a5.global;for(var id in this.selection){f.call(o,this.getItem(id),id,this);}}});});},"dojo/html":function(){define(["./_base/kernel","./_base/lang","./_base/array","./_base/declare","./dom","./dom-construct","./parser"],function(_6bd,lang,_6be,_6bf,dom,_6c0,_6c1){var html={};lang.setObject("dojo.html",html);var _6c2=0;html._secureForInnerHtml=function(cont){return cont.replace(/(?:\s*<!DOCTYPE\s[^>]+>|<title[^>]*>[\s\S]*?<\/title>)/ig,"");};html._emptyNode=_6c0.empty;html._setNodeContent=function(node,cont){_6c0.empty(node);if(cont){if(typeof cont=="string"){cont=_6c0.toDom(cont,node.ownerDocument);}if(!cont.nodeType&&lang.isArrayLike(cont)){for(var _6c3=cont.length,i=0;i<cont.length;i=_6c3==cont.length?i+1:0){_6c0.place(cont[i],node,"last");}}else{_6c0.place(cont,node,"last");}}return node;};html._ContentSetter=_6bf("dojo.html._ContentSetter",null,{node:"",content:"",id:"",cleanContent:false,extractContent:false,parseContent:false,parserScope:_6bd._scopeName,startup:true,constructor:function(_6c4,node){lang.mixin(this,_6c4||{});node=this.node=dom.byId(this.node||node);if(!this.id){this.id=["Setter",(node)?node.id||node.tagName:"",_6c2++].join("_");}},set:function(cont,_6c5){if(undefined!==cont){this.content=cont;}if(_6c5){this._mixin(_6c5);}this.onBegin();this.setContent();var ret=this.onEnd();if(ret&&ret.then){return ret;}else{return this.node;}},setContent:function(){var node=this.node;if(!node){throw new Error(this.declaredClass+": setContent given no node");}try{node=html._setNodeContent(node,this.content);}catch(e){var _6c6=this.onContentError(e);try{node.innerHTML=_6c6;}catch(e){console.error("Fatal "+this.declaredClass+".setContent could not change content due to "+e.message,e);}}this.node=node;},empty:function(){if(this.parseDeferred){if(!this.parseDeferred.isResolved()){this.parseDeferred.cancel();}delete this.parseDeferred;}if(this.parseResults&&this.parseResults.length){_6be.forEach(this.parseResults,function(w){if(w.destroy){w.destroy();}});delete this.parseResults;}_6c0.empty(this.node);},onBegin:function(){var cont=this.content;if(lang.isString(cont)){if(this.cleanContent){cont=html._secureForInnerHtml(cont);}if(this.extractContent){var _6c7=cont.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_6c7){cont=_6c7[1];}}}this.empty();this.content=cont;return this.node;},onEnd:function(){if(this.parseContent){this._parse();}return this.node;},tearDown:function(){delete this.parseResults;delete this.parseDeferred;delete this.node;delete this.content;},onContentError:function(err){return "Error occurred setting content: "+err;},onExecError:function(err){return "Error occurred executing scripts: "+err;},_mixin:function(_6c8){var _6c9={},key;for(key in _6c8){if(key in _6c9){continue;}this[key]=_6c8[key];}},_parse:function(){var _6ca=this.node;try{var _6cb={};_6be.forEach(["dir","lang","textDir"],function(name){if(this[name]){_6cb[name]=this[name];}},this);var self=this;this.parseDeferred=_6c1.parse({rootNode:_6ca,noStart:!this.startup,inherited:_6cb,scope:this.parserScope}).then(function(_6cc){return self.parseResults=_6cc;},function(e){self._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);});}catch(e){this._onError("Content",e,"Error parsing in _ContentSetter#"+this.id);}},_onError:function(type,err,_6cd){var _6ce=this["on"+type+"Error"].call(this,err);if(_6cd){console.error(_6cd,err);}else{if(_6ce){html._setNodeContent(this.node,_6ce,true);}}}});html.set=function(node,cont,_6cf){if(undefined==cont){console.warn("dojo.html.set: no cont argument provided, using empty string");cont="";}if(!_6cf){return html._setNodeContent(node,cont,true);}else{var op=new html._ContentSetter(lang.mixin(_6cf,{content:cont,node:node}));return op.set();}};return html;});},"dijit/_PaletteMixin":function(){define(["dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/keys","dojo/_base/lang","dojo/on","./_CssStateMixin","./a11yclick","./focus","./typematic"],function(_6d0,_6d1,_6d2,_6d3,keys,lang,on,_6d4,_6d5,_6d6,_6d7){var _6d8=_6d0("dijit._PaletteMixin",_6d4,{defaultTimeout:500,timeoutChangeRate:0.9,value:"",_selectedCell:-1,tabIndex:"0",cellClass:"dijitPaletteCell",dyeClass:null,_dyeFactory:function(_6d9){var _6da=typeof this.dyeClass=="string"?lang.getObject(this.dyeClass):this.dyeClass;return new _6da(_6d9);},_preparePalette:function(_6db,_6dc){this._cells=[];var url=this._blankGif;this.own(on(this.gridNode,_6d5,lang.hitch(this,"_onCellClick")));for(var row=0;row<_6db.length;row++){var _6dd=_6d3.create("tr",{tabIndex:"-1",role:"row"},this.gridNode);for(var col=0;col<_6db[row].length;col++){var _6de=_6db[row][col];if(_6de){var _6df=this._dyeFactory(_6de,row,col,_6dc[_6de]);var _6e0=_6d3.create("td",{"class":this.cellClass,tabIndex:"-1",title:_6dc[_6de],role:"gridcell"},_6dd);_6df.fillCell(_6e0,url);_6e0.idx=this._cells.length;this._cells.push({node:_6e0,dye:_6df});}}}this._xDim=_6db[0].length;this._yDim=_6db.length;var _6e1={UP_ARROW:-this._xDim,DOWN_ARROW:this._xDim,RIGHT_ARROW:this.isLeftToRight()?1:-1,LEFT_ARROW:this.isLeftToRight()?-1:1};for(var key in _6e1){this.own(_6d7.addKeyListener(this.domNode,{keyCode:keys[key],ctrlKey:false,altKey:false,shiftKey:false},this,function(){var _6e2=_6e1[key];return function(_6e3){this._navigateByKey(_6e2,_6e3);};}(),this.timeoutChangeRate,this.defaultTimeout));}},postCreate:function(){this.inherited(arguments);this._setCurrent(this._cells[0].node);},focus:function(){_6d6.focus(this._currentFocus);},_onCellClick:function(evt){var _6e4=evt.target;while(_6e4.tagName!="TD"){if(!_6e4.parentNode||_6e4==this.gridNode){return;}_6e4=_6e4.parentNode;}var _6e5=this._getDye(_6e4).getValue();this._setCurrent(_6e4);_6d6.focus(_6e4);this._setValueAttr(_6e5,true);evt.stopPropagation();evt.preventDefault();},_setCurrent:function(node){if("_currentFocus" in this){_6d1.set(this._currentFocus,"tabIndex","-1");}this._currentFocus=node;if(node){_6d1.set(node,"tabIndex",this.tabIndex);}},_setValueAttr:function(_6e6,_6e7){if(this._selectedCell>=0){_6d2.remove(this._cells[this._selectedCell].node,this.cellClass+"Selected");}this._selectedCell=-1;if(_6e6){for(var i=0;i<this._cells.length;i++){if(_6e6==this._cells[i].dye.getValue()){this._selectedCell=i;_6d2.add(this._cells[i].node,this.cellClass+"Selected");break;}}}this._set("value",this._selectedCell>=0?_6e6:null);if(_6e7||_6e7===undefined){this.onChange(_6e6);}},onChange:function(){},_navigateByKey:function(_6e8,_6e9){if(_6e9==-1){return;}var _6ea=this._currentFocus.idx+_6e8;if(_6ea<this._cells.length&&_6ea>-1){var _6eb=this._cells[_6ea].node;this._setCurrent(_6eb);this.defer(lang.hitch(_6d6,"focus",_6eb));}},_getDye:function(cell){return this._cells[cell.idx].dye;}});return _6d8;});},"dijit/form/ValidationTextBox":function(){define(["dojo/_base/declare","dojo/_base/kernel","dojo/i18n","./TextBox","../Tooltip","dojo/text!./templates/ValidationTextBox.html","dojo/i18n!./nls/validate"],function(_6ec,_6ed,i18n,_6ee,_6ef,_6f0){var _6f1;return _6f1=_6ec("dijit.form.ValidationTextBox",_6ee,{templateString:_6f0,required:false,promptMessage:"",invalidMessage:"$_unset_$",missingMessage:"$_unset_$",message:"",constraints:{},pattern:".*",regExp:"",regExpGen:function(){},state:"",tooltipPosition:[],_deprecateRegExp:function(attr,_6f2){if(_6f2!=_6f1.prototype[attr]){_6ed.deprecated("ValidationTextBox id="+this.id+", set('"+attr+"', ...) is deprecated.  Use set('pattern', ...) instead.","","2.0");this.set("pattern",_6f2);}},_setRegExpGenAttr:function(_6f3){this._deprecateRegExp("regExpGen",_6f3);this._set("regExpGen",this._computeRegexp);},_setRegExpAttr:function(_6f4){this._deprecateRegExp("regExp",_6f4);},_setValueAttr:function(){this.inherited(arguments);this._refreshState();},validator:function(_6f5,_6f6){return (new RegExp("^(?:"+this._computeRegexp(_6f6)+")"+(this.required?"":"?")+"$")).test(_6f5)&&(!this.required||!this._isEmpty(_6f5))&&(this._isEmpty(_6f5)||this.parse(_6f5,_6f6)!==undefined);},_isValidSubset:function(){return this.textbox.value.search(this._partialre)==0;},isValid:function(){return this.validator(this.textbox.value,this.get("constraints"));},_isEmpty:function(_6f7){return (this.trim?/^\s*$/:/^$/).test(_6f7);},getErrorMessage:function(){var _6f8=this.invalidMessage=="$_unset_$"?this.messages.invalidMessage:!this.invalidMessage?this.promptMessage:this.invalidMessage;var _6f9=this.missingMessage=="$_unset_$"?this.messages.missingMessage:!this.missingMessage?_6f8:this.missingMessage;return (this.required&&this._isEmpty(this.textbox.value))?_6f9:_6f8;},getPromptMessage:function(){return this.promptMessage;},_maskValidSubsetError:true,validate:function(_6fa){var _6fb="";var _6fc=this.disabled||this.isValid(_6fa);if(_6fc){this._maskValidSubsetError=true;}var _6fd=this._isEmpty(this.textbox.value);var _6fe=!_6fc&&_6fa&&this._isValidSubset();this._set("state",_6fc?"":(((((!this._hasBeenBlurred||_6fa)&&_6fd)||_6fe)&&(this._maskValidSubsetError||(_6fe&&!this._hasBeenBlurred&&_6fa)))?"Incomplete":"Error"));this.focusNode.setAttribute("aria-invalid",_6fc?"false":"true");if(this.state=="Error"){this._maskValidSubsetError=_6fa&&_6fe;_6fb=this.getErrorMessage(_6fa);}else{if(this.state=="Incomplete"){_6fb=this.getPromptMessage(_6fa);this._maskValidSubsetError=!this._hasBeenBlurred||_6fa;}else{if(_6fd){_6fb=this.getPromptMessage(_6fa);}}}this.set("message",_6fb);return _6fc;},displayMessage:function(_6ff){if(_6ff&&this.focused){_6ef.show(_6ff,this.domNode,this.tooltipPosition,!this.isLeftToRight());}else{_6ef.hide(this.domNode);}},_refreshState:function(){if(this._created){this.validate(this.focused);}this.inherited(arguments);},constructor:function(_700){this.constraints={};this.baseClass+=" dijitValidationTextBox";},startup:function(){this.inherited(arguments);this._refreshState();},_setConstraintsAttr:function(_701){if(!_701.locale&&this.lang){_701.locale=this.lang;}this._set("constraints",_701);this._refreshState();},_setPatternAttr:function(_702){this._set("pattern",_702);},_computeRegexp:function(_703){var p=this.pattern;if(typeof p=="function"){p=p.call(this,_703);}if(p!=this._lastRegExp){var _704="";this._lastRegExp=p;if(p!=".*"){p.replace(/\\.|\[\]|\[.*?[^\\]{1}\]|\{.*?\}|\(\?[=:!]|./g,function(re){switch(re.charAt(0)){case "{":case "+":case "?":case "*":case "^":case "$":case "|":case "(":_704+=re;break;case ")":_704+="|$)";break;default:_704+="(?:"+re+"|$)";break;}});}try{"".search(_704);}catch(e){_704=this.pattern;console.warn("RegExp error in "+this.declaredClass+": "+this.pattern);}this._partialre="^(?:"+_704+")$";}return p;},postMixInProperties:function(){this.inherited(arguments);this.messages=i18n.getLocalization("dijit.form","validate",this.lang);this._setConstraintsAttr(this.constraints);},_setDisabledAttr:function(_705){this.inherited(arguments);this._refreshState();},_setRequiredAttr:function(_706){this._set("required",_706);this.focusNode.setAttribute("aria-required",_706);this._refreshState();},_setMessageAttr:function(_707){this._set("message",_707);this.displayMessage(_707);},reset:function(){this._maskValidSubsetError=true;this.inherited(arguments);},_onBlur:function(){this.displayMessage("");this.inherited(arguments);}});});},"dijit/layout/BorderContainer":function(){define(["dojo/_base/array","dojo/cookie","dojo/_base/declare","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/on","dojo/touch","../_WidgetBase","../_Widget","../_TemplatedMixin","./LayoutContainer","./utils"],function(_708,_709,_70a,_70b,_70c,_70d,_70e,keys,lang,on,_70f,_710,_711,_712,_713,_714){var _715=_70a("dijit.layout._Splitter",[_711,_712],{live:true,templateString:"<div class=\"dijitSplitter\" data-dojo-attach-event=\"onkeydown:_onKeyDown,press:_startDrag,onmouseenter:_onMouse,onmouseleave:_onMouse\" tabIndex=\"0\" role=\"separator\"><div class=\"dijitSplitterThumb\"></div></div>",constructor:function(){this._handlers=[];},postMixInProperties:function(){this.inherited(arguments);this.horizontal=/top|bottom/.test(this.region);this._factor=/top|left/.test(this.region)?1:-1;this._cookieName=this.container.id+"_"+this.region;},buildRendering:function(){this.inherited(arguments);_70b.add(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V"));if(this.container.persist){var _716=_709(this._cookieName);if(_716){this.child.domNode.style[this.horizontal?"height":"width"]=_716;}}},_computeMaxSize:function(){var dim=this.horizontal?"h":"w",_717=_70d.getMarginBox(this.child.domNode)[dim],_718=_708.filter(this.container.getChildren(),function(_719){return _719.region=="center";})[0];var _71a=_70d.getContentBox(_718.domNode)[dim]-10;return Math.min(this.child.maxSize,_717+_71a);},_startDrag:function(e){if(!this.cover){this.cover=_70c.place("<div class=dijitSplitterCover></div>",this.child.domNode,"after");}_70b.add(this.cover,"dijitSplitterCoverActive");if(this.fake){_70c.destroy(this.fake);}if(!(this._resize=this.live)){(this.fake=this.domNode.cloneNode(true)).removeAttribute("id");_70b.add(this.domNode,"dijitSplitterShadow");_70c.place(this.fake,this.domNode,"after");}_70b.add(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active");if(this.fake){_70b.remove(this.fake,"dijitSplitterHover dijitSplitter"+(this.horizontal?"H":"V")+"Hover");}var _71b=this._factor,_71c=this.horizontal,axis=_71c?"pageY":"pageX",_71d=e[axis],_71e=this.domNode.style,dim=_71c?"h":"w",_71f=_70e.getComputedStyle(this.child.domNode),_720=_70d.getMarginBox(this.child.domNode,_71f)[dim],max=this._computeMaxSize(),min=Math.max(this.child.minSize,_70d.getPadBorderExtents(this.child.domNode,_71f)[dim]+10),_721=this.region,_722=_721=="top"||_721=="bottom"?"top":"left",_723=parseInt(_71e[_722],10),_724=this._resize,_725=lang.hitch(this.container,"_layoutChildren",this.child.id),de=this.ownerDocument;this._handlers=this._handlers.concat([on(de,_70f.move,this._drag=function(e,_726){var _727=e[axis]-_71d,_728=_71b*_727+_720,_729=Math.max(Math.min(_728,max),min);if(_724||_726){_725(_729);}_71e[_722]=_727+_723+_71b*(_729-_728)+"px";}),on(de,"dragstart",function(e){e.stopPropagation();e.preventDefault();}),on(this.ownerDocumentBody,"selectstart",function(e){e.stopPropagation();e.preventDefault();}),on(de,_70f.release,lang.hitch(this,"_stopDrag"))]);e.stopPropagation();e.preventDefault();},_onMouse:function(e){var o=(e.type=="mouseover"||e.type=="mouseenter");_70b.toggle(this.domNode,"dijitSplitterHover",o);_70b.toggle(this.domNode,"dijitSplitter"+(this.horizontal?"H":"V")+"Hover",o);},_stopDrag:function(e){try{if(this.cover){_70b.remove(this.cover,"dijitSplitterCoverActive");}if(this.fake){_70c.destroy(this.fake);}_70b.remove(this.domNode,"dijitSplitterActive dijitSplitter"+(this.horizontal?"H":"V")+"Active dijitSplitterShadow");this._drag(e);this._drag(e,true);}finally{this._cleanupHandlers();delete this._drag;}if(this.container.persist){_709(this._cookieName,this.child.domNode.style[this.horizontal?"height":"width"],{expires:365});}},_cleanupHandlers:function(){var h;while(h=this._handlers.pop()){h.remove();}},_onKeyDown:function(e){this._resize=true;var _72a=this.horizontal;var tick=1;switch(e.keyCode){case _72a?keys.UP_ARROW:keys.LEFT_ARROW:tick*=-1;case _72a?keys.DOWN_ARROW:keys.RIGHT_ARROW:break;default:return;}var _72b=_70d.getMarginSize(this.child.domNode)[_72a?"h":"w"]+this._factor*tick;this.container._layoutChildren(this.child.id,Math.max(Math.min(_72b,this._computeMaxSize()),this.child.minSize));e.stopPropagation();e.preventDefault();},destroy:function(){this._cleanupHandlers();delete this.child;delete this.container;delete this.cover;delete this.fake;this.inherited(arguments);}});var _72c=_70a("dijit.layout._Gutter",[_711,_712],{templateString:"<div class=\"dijitGutter\" role=\"presentation\"></div>",postMixInProperties:function(){this.inherited(arguments);this.horizontal=/top|bottom/.test(this.region);},buildRendering:function(){this.inherited(arguments);_70b.add(this.domNode,"dijitGutter"+(this.horizontal?"H":"V"));}});var _72d=_70a("dijit.layout.BorderContainer",_713,{gutters:true,liveSplitters:true,persist:false,baseClass:"dijitBorderContainer",_splitterClass:_715,postMixInProperties:function(){if(!this.gutters){this.baseClass+="NoGutter";}this.inherited(arguments);},_setupChild:function(_72e){this.inherited(arguments);var _72f=_72e.region,ltr=_72e.isLeftToRight();if(_72f=="leading"){_72f=ltr?"left":"right";}if(_72f=="trailing"){_72f=ltr?"right":"left";}if(_72f){if(_72f!="center"&&(_72e.splitter||this.gutters)&&!_72e._splitterWidget){var _730=_72e.splitter?this._splitterClass:_72c;if(lang.isString(_730)){_730=lang.getObject(_730);}var _731=new _730({id:_72e.id+"_splitter",container:this,child:_72e,region:_72f,live:this.liveSplitters});_731.isSplitter=true;_72e._splitterWidget=_731;var _732=_72f=="bottom"||_72f==(this.isLeftToRight()?"right":"left");_70c.place(_731.domNode,_72e.domNode,_732?"before":"after");_731.startup();}}},layout:function(){this._layoutChildren();},removeChild:function(_733){var _734=_733._splitterWidget;if(_734){_734.destroy();delete _733._splitterWidget;}this.inherited(arguments);},getChildren:function(){return _708.filter(this.inherited(arguments),function(_735){return !_735.isSplitter;});},getSplitter:function(_736){return _708.filter(this.getChildren(),function(_737){return _737.region==_736;})[0]._splitterWidget;},resize:function(_738,_739){if(!this.cs||!this.pe){var node=this.domNode;this.cs=_70e.getComputedStyle(node);this.pe=_70d.getPadExtents(node,this.cs);this.pe.r=_70e.toPixelValue(node,this.cs.paddingRight);this.pe.b=_70e.toPixelValue(node,this.cs.paddingBottom);_70e.set(node,"padding","0px");}this.inherited(arguments);},_layoutChildren:function(_73a,_73b){if(!this._borderBox||!this._borderBox.h){return;}var _73c=[];_708.forEach(this._getOrderedChildren(),function(pane){_73c.push(pane);if(pane._splitterWidget){_73c.push(pane._splitterWidget);}});var dim={l:this.pe.l,t:this.pe.t,w:this._borderBox.w-this.pe.w,h:this._borderBox.h-this.pe.h};_714.layoutChildren(this.domNode,dim,_73c,_73a,_73b);},destroyRecursive:function(){_708.forEach(this.getChildren(),function(_73d){var _73e=_73d._splitterWidget;if(_73e){_73e.destroy();}delete _73d._splitterWidget;});this.inherited(arguments);}});_72d.ChildWidgetProperties={splitter:false,minSize:0,maxSize:Infinity};lang.mixin(_72d.ChildWidgetProperties,_713.ChildWidgetProperties);lang.extend(_710,_72d.ChildWidgetProperties);_72d._Splitter=_715;_72d._Gutter=_72c;return _72d;});},"dojo/number":function(){define(["./_base/lang","./i18n","./i18n!./cldr/nls/number","./string","./regexp"],function(lang,i18n,_73f,_740,_741){var _742={};lang.setObject("dojo.number",_742);_742.format=function(_743,_744){_744=lang.mixin({},_744||{});var _745=i18n.normalizeLocale(_744.locale),_746=i18n.getLocalization("dojo.cldr","number",_745);_744.customs=_746;var _747=_744.pattern||_746[(_744.type||"decimal")+"Format"];if(isNaN(_743)||Math.abs(_743)==Infinity){return null;}return _742._applyPattern(_743,_747,_744);};_742._numberPatternRE=/[#0,]*[#0](?:\.0*#*)?/;_742._applyPattern=function(_748,_749,_74a){_74a=_74a||{};var _74b=_74a.customs.group,_74c=_74a.customs.decimal,_74d=_749.split(";"),_74e=_74d[0];_749=_74d[(_748<0)?1:0]||("-"+_74e);if(_749.indexOf("%")!=-1){_748*=100;}else{if(_749.indexOf("‰")!=-1){_748*=1000;}else{if(_749.indexOf("¤")!=-1){_74b=_74a.customs.currencyGroup||_74b;_74c=_74a.customs.currencyDecimal||_74c;_749=_749.replace(/\u00a4{1,3}/,function(_74f){var prop=["symbol","currency","displayName"][_74f.length-1];return _74a[prop]||_74a.currency||"";});}else{if(_749.indexOf("E")!=-1){throw new Error("exponential notation not supported");}}}}var _750=_742._numberPatternRE;var _751=_74e.match(_750);if(!_751){throw new Error("unable to find a number expression in pattern: "+_749);}if(_74a.fractional===false){_74a.places=0;}return _749.replace(_750,_742._formatAbsolute(_748,_751[0],{decimal:_74c,group:_74b,places:_74a.places,round:_74a.round}));};_742.round=function(_752,_753,_754){var _755=10/(_754||10);return (_755*+_752).toFixed(_753)/_755;};if((0.9).toFixed()==0){var _756=_742.round;_742.round=function(v,p,m){var d=Math.pow(10,-p||0),a=Math.abs(v);if(!v||a>=d){d=0;}else{a/=d;if(a<0.5||a>=0.95){d=0;}}return _756(v,p,m)+(v>0?d:-d);};}_742._formatAbsolute=function(_757,_758,_759){_759=_759||{};if(_759.places===true){_759.places=0;}if(_759.places===Infinity){_759.places=6;}var _75a=_758.split("."),_75b=typeof _759.places=="string"&&_759.places.indexOf(","),_75c=_759.places;if(_75b){_75c=_759.places.substring(_75b+1);}else{if(!(_75c>=0)){_75c=(_75a[1]||[]).length;}}if(!(_759.round<0)){_757=_742.round(_757,_75c,_759.round);}var _75d=String(Math.abs(_757)).split("."),_75e=_75d[1]||"";if(_75a[1]||_759.places){if(_75b){_759.places=_759.places.substring(0,_75b);}var pad=_759.places!==undefined?_759.places:(_75a[1]&&_75a[1].lastIndexOf("0")+1);if(pad>_75e.length){_75d[1]=_740.pad(_75e,pad,"0",true);}if(_75c<_75e.length){_75d[1]=_75e.substr(0,_75c);}}else{if(_75d[1]){_75d.pop();}}var _75f=_75a[0].replace(",","");pad=_75f.indexOf("0");if(pad!=-1){pad=_75f.length-pad;if(pad>_75d[0].length){_75d[0]=_740.pad(_75d[0],pad);}if(_75f.indexOf("#")==-1){_75d[0]=_75d[0].substr(_75d[0].length-pad);}}var _760=_75a[0].lastIndexOf(","),_761,_762;if(_760!=-1){_761=_75a[0].length-_760-1;var _763=_75a[0].substr(0,_760);_760=_763.lastIndexOf(",");if(_760!=-1){_762=_763.length-_760-1;}}var _764=[];for(var _765=_75d[0];_765;){var off=_765.length-_761;_764.push((off>0)?_765.substr(off):_765);_765=(off>0)?_765.slice(0,off):"";if(_762){_761=_762;delete _762;}}_75d[0]=_764.reverse().join(_759.group||",");return _75d.join(_759.decimal||".");};_742.regexp=function(_766){return _742._parseInfo(_766).regexp;};_742._parseInfo=function(_767){_767=_767||{};var _768=i18n.normalizeLocale(_767.locale),_769=i18n.getLocalization("dojo.cldr","number",_768),_76a=_767.pattern||_769[(_767.type||"decimal")+"Format"],_76b=_769.group,_76c=_769.decimal,_76d=1;if(_76a.indexOf("%")!=-1){_76d/=100;}else{if(_76a.indexOf("‰")!=-1){_76d/=1000;}else{var _76e=_76a.indexOf("¤")!=-1;if(_76e){_76b=_769.currencyGroup||_76b;_76c=_769.currencyDecimal||_76c;}}}var _76f=_76a.split(";");if(_76f.length==1){_76f.push("-"+_76f[0]);}var re=_741.buildGroupRE(_76f,function(_770){_770="(?:"+_741.escapeString(_770,".")+")";return _770.replace(_742._numberPatternRE,function(_771){var _772={signed:false,separator:_767.strict?_76b:[_76b,""],fractional:_767.fractional,decimal:_76c,exponent:false},_773=_771.split("."),_774=_767.places;if(_773.length==1&&_76d!=1){_773[1]="###";}if(_773.length==1||_774===0){_772.fractional=false;}else{if(_774===undefined){_774=_767.pattern?_773[1].lastIndexOf("0")+1:Infinity;}if(_774&&_767.fractional==undefined){_772.fractional=true;}if(!_767.places&&(_774<_773[1].length)){_774+=","+_773[1].length;}_772.places=_774;}var _775=_773[0].split(",");if(_775.length>1){_772.groupSize=_775.pop().length;if(_775.length>1){_772.groupSize2=_775.pop().length;}}return "("+_742._realNumberRegexp(_772)+")";});},true);if(_76e){re=re.replace(/([\s\xa0]*)(\u00a4{1,3})([\s\xa0]*)/g,function(_776,_777,_778,_779){var prop=["symbol","currency","displayName"][_778.length-1],_77a=_741.escapeString(_767[prop]||_767.currency||"");_777=_777?"[\\s\\xa0]":"";_779=_779?"[\\s\\xa0]":"";if(!_767.strict){if(_777){_777+="*";}if(_779){_779+="*";}return "(?:"+_777+_77a+_779+")?";}return _777+_77a+_779;});}return {regexp:re.replace(/[\xa0 ]/g,"[\\s\\xa0]"),group:_76b,decimal:_76c,factor:_76d};};_742.parse=function(_77b,_77c){var info=_742._parseInfo(_77c),_77d=(new RegExp("^"+info.regexp+"$")).exec(_77b);if(!_77d){return NaN;}var _77e=_77d[1];if(!_77d[1]){if(!_77d[2]){return NaN;}_77e=_77d[2];info.factor*=-1;}_77e=_77e.replace(new RegExp("["+info.group+"\\s\\xa0"+"]","g"),"").replace(info.decimal,".");return _77e*info.factor;};_742._realNumberRegexp=function(_77f){_77f=_77f||{};if(!("places" in _77f)){_77f.places=Infinity;}if(typeof _77f.decimal!="string"){_77f.decimal=".";}if(!("fractional" in _77f)||/^0/.test(_77f.places)){_77f.fractional=[true,false];}if(!("exponent" in _77f)){_77f.exponent=[true,false];}if(!("eSigned" in _77f)){_77f.eSigned=[true,false];}var _780=_742._integerRegexp(_77f),_781=_741.buildGroupRE(_77f.fractional,function(q){var re="";if(q&&(_77f.places!==0)){re="\\"+_77f.decimal;if(_77f.places==Infinity){re="(?:"+re+"\\d+)?";}else{re+="\\d{"+_77f.places+"}";}}return re;},true);var _782=_741.buildGroupRE(_77f.exponent,function(q){if(q){return "([eE]"+_742._integerRegexp({signed:_77f.eSigned})+")";}return "";});var _783=_780+_781;if(_781){_783="(?:(?:"+_783+")|(?:"+_781+"))";}return _783+_782;};_742._integerRegexp=function(_784){_784=_784||{};if(!("signed" in _784)){_784.signed=[true,false];}if(!("separator" in _784)){_784.separator="";}else{if(!("groupSize" in _784)){_784.groupSize=3;}}var _785=_741.buildGroupRE(_784.signed,function(q){return q?"[-+]":"";},true);var _786=_741.buildGroupRE(_784.separator,function(sep){if(!sep){return "(?:\\d+)";}sep=_741.escapeString(sep);if(sep==" "){sep="\\s";}else{if(sep==" "){sep="\\s\\xa0";}}var grp=_784.groupSize,grp2=_784.groupSize2;if(grp2){var _787="(?:0|[1-9]\\d{0,"+(grp2-1)+"}(?:["+sep+"]\\d{"+grp2+"})*["+sep+"]\\d{"+grp+"})";return ((grp-grp2)>0)?"(?:"+_787+"|(?:0|[1-9]\\d{0,"+(grp-1)+"}))":_787;}return "(?:0|[1-9]\\d{0,"+(grp-1)+"}(?:["+sep+"]\\d{"+grp+"})*)";},true);return _785+_786;};return _742;});},"dijit/_WidgetsInTemplateMixin":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang","dojo/parser"],function(_788,_789,_78a,lang,_78b){return _78a("dijit._WidgetsInTemplateMixin",null,{_earlyTemplatedStartup:false,widgetsInTemplate:true,contextRequire:null,_beforeFillContent:function(){if(this.widgetsInTemplate){var node=this.domNode;if(this.containerNode&&!this.searchContainerNode){this.containerNode.stopParser=true;}_78b.parse(node,{noStart:!this._earlyTemplatedStartup,template:true,inherited:{dir:this.dir,lang:this.lang,textDir:this.textDir},propsThis:this,contextRequire:this.contextRequire,scope:"dojo"}).then(lang.hitch(this,function(_78c){this._startupWidgets=_78c;for(var i=0;i<_78c.length;i++){this._processTemplateNode(_78c[i],function(n,p){return n[p];},function(_78d,type,_78e){if(type in _78d){return _78d.connect(_78d,type,_78e);}else{return _78d.on(type,_78e,true);}});}if(this.containerNode&&this.containerNode.stopParser){delete this.containerNode.stopParser;}}));if(!this._startupWidgets){throw new Error(this.declaredClass+": parser returned unfilled promise (probably waiting for module auto-load), "+"unsupported by _WidgetsInTemplateMixin.   Must pre-load all supporting widgets before instantiation.");}}},_processTemplateNode:function(_78f,_790,_791){if(_790(_78f,"dojoType")||_790(_78f,"data-dojo-type")){return true;}return this.inherited(arguments);},startup:function(){_788.forEach(this._startupWidgets,function(w){if(w&&!w._started&&w.startup){w.startup();}});this._startupWidgets=null;this.inherited(arguments);}});});},"dijit/form/HorizontalRuleLabels":function(){define(["dojo/_base/declare","dojo/has","dojo/number","dojo/query","dojo/_base/lang","./HorizontalRule"],function(_792,has,_793,_794,lang,_795){var _796=_792("dijit.form.HorizontalRuleLabels",_795,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerH dijitRuleLabelsContainer dijitRuleLabelsContainerH\"></div>",labelStyle:"",labels:[],numericMargin:0,minimum:0,maximum:1,constraints:{pattern:"#%"},_positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerH\" style=\"left:",_labelPrefix:"\"><div class=\"dijitRuleLabel dijitRuleLabelH\">",_suffix:"</div></div>",_calcPosition:function(pos){return pos;},_genHTML:function(pos,ndx){var _797=this.labels[ndx];return this._positionPrefix+this._calcPosition(pos)+this._positionSuffix+this.labelStyle+this._genDirectionHTML(_797)+this._labelPrefix+_797+this._suffix;},_genDirectionHTML:function(_798){return "";},getLabels:function(){var _799=this.labels;if(!_799.length&&this.srcNodeRef){_799=_794("> li",this.srcNodeRef).map(function(node){return String(node.innerHTML);});}if(!_799.length&&this.count>1){var _79a=this.minimum;var inc=(this.maximum-_79a)/(this.count-1);for(var i=0;i<this.count;i++){_799.push((i<this.numericMargin||i>=(this.count-this.numericMargin))?"":_793.format(_79a,this.constraints));_79a+=inc;}}return _799;},postMixInProperties:function(){this.inherited(arguments);this.labels=this.getLabels();this.count=this.labels.length;}});if(has("dojo-bidi")){_796.extend({_setTextDirAttr:function(_79b){if(this.textDir!=_79b){this._set("textDir",_79b);_794(".dijitRuleLabelContainer",this.domNode).forEach(lang.hitch(this,function(_79c){_79c.style.direction=this.getTextDir(_79c.innerText||_79c.textContent||"");}));}},_genDirectionHTML:function(_79d){return (this.textDir?("direction:"+this.getTextDir(_79d)+";"):"");}});}return _796;});},"dijit/form/FilteringSelect":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/when","./MappedTextBox","./ComboBoxMixin"],function(_79e,lang,when,_79f,_7a0){return _79e("dijit.form.FilteringSelect",[_79f,_7a0],{required:true,_lastDisplayedValue:"",_isValidSubset:function(){return this._opened;},isValid:function(){return !!this.item||(!this.required&&this.get("displayedValue")=="");},_refreshState:function(){if(!this.searchTimer){this.inherited(arguments);}},_callbackSetLabel:function(_7a1,_7a2,_7a3,_7a4){if((_7a2&&_7a2[this.searchAttr]!==this._lastQuery)||(!_7a2&&_7a1.length&&this.store.getIdentity(_7a1[0])!=this._lastQuery)){return;}if(!_7a1.length){this.set("value","",_7a4||(_7a4===undefined&&!this.focused),this.textbox.value,null);}else{this.set("item",_7a1[0],_7a4);}},_openResultList:function(_7a5,_7a6,_7a7){if(_7a6[this.searchAttr]!==this._lastQuery){return;}this.inherited(arguments);if(this.item===undefined){this.validate(true);}},_getValueAttr:function(){return this.valueNode.value;},_getValueField:function(){return "value";},_setValueAttr:function(_7a8,_7a9,_7aa,item){if(!this._onChangeActive){_7a9=null;}if(item===undefined){if(_7a8===null||_7a8===""){_7a8="";if(!lang.isString(_7aa)){this._setDisplayedValueAttr(_7aa||"",_7a9);return;}}var self=this;this._lastQuery=_7a8;when(this.store.get(_7a8),function(item){self._callbackSetLabel(item?[item]:[],undefined,undefined,_7a9);});}else{this.valueNode.value=_7a8;this.inherited(arguments);}},_setItemAttr:function(item,_7ab,_7ac){this.inherited(arguments);this._lastDisplayedValue=this.textbox.value;},_getDisplayQueryString:function(text){return text.replace(/([\\\*\?])/g,"\\$1");},_setDisplayedValueAttr:function(_7ad,_7ae){if(_7ad==null){_7ad="";}if(!this._created){if(!("displayedValue" in this.params)){return;}_7ae=false;}if(this.store){this.closeDropDown();var _7af=lang.clone(this.query);var qs=this._getDisplayQueryString(_7ad),q;if(this.store._oldAPI){q=qs;}else{q=this._patternToRegExp(qs);q.toString=function(){return qs;};}this._lastQuery=_7af[this.searchAttr]=q;this.textbox.value=_7ad;this._lastDisplayedValue=_7ad;this._set("displayedValue",_7ad);var _7b0=this;var _7b1={ignoreCase:this.ignoreCase,deep:true};lang.mixin(_7b1,this.fetchProperties);this._fetchHandle=this.store.query(_7af,_7b1);when(this._fetchHandle,function(_7b2){_7b0._fetchHandle=null;_7b0._callbackSetLabel(_7b2||[],_7af,_7b1,_7ae);},function(err){_7b0._fetchHandle=null;if(!_7b0._cancelingQuery){console.error("dijit.form.FilteringSelect: "+err.toString());}});}},undo:function(){this.set("displayedValue",this._lastDisplayedValue);}});});},"dojo/data/util/sorter":function(){define(["../../_base/lang"],function(lang){var _7b3={};lang.setObject("dojo.data.util.sorter",_7b3);_7b3.basicComparator=function(a,b){var r=-1;if(a===null){a=undefined;}if(b===null){b=undefined;}if(a==b){r=0;}else{if(a>b||a==null){r=1;}}return r;};_7b3.createSortFunction=function(_7b4,_7b5){var _7b6=[];function _7b7(attr,dir,comp,s){return function(_7b8,_7b9){var a=s.getValue(_7b8,attr);var b=s.getValue(_7b9,attr);return dir*comp(a,b);};};var _7ba;var map=_7b5.comparatorMap;var bc=_7b3.basicComparator;for(var i=0;i<_7b4.length;i++){_7ba=_7b4[i];var attr=_7ba.attribute;if(attr){var dir=(_7ba.descending)?-1:1;var comp=bc;if(map){if(typeof attr!=="string"&&("toString" in attr)){attr=attr.toString();}comp=map[attr]||bc;}_7b6.push(_7b7(attr,dir,comp,_7b5));}}return function(rowA,rowB){var i=0;while(i<_7b6.length){var ret=_7b6[i++](rowA,rowB);if(ret!==0){return ret;}}return 0;};};return _7b3;});},"dijit/form/_ButtonMixin":function(){define(["dojo/_base/declare","dojo/dom","dojo/has","../registry"],function(_7bb,dom,has,_7bc){var _7bd=_7bb("dijit.form._ButtonMixin"+(has("dojo-bidi")?"_NoBidi":""),null,{label:"",type:"button",__onClick:function(e){e.stopPropagation();e.preventDefault();if(!this.disabled){this.valueNode.click(e);}return false;},_onClick:function(e){if(this.disabled){e.stopPropagation();e.preventDefault();return false;}if(this.onClick(e)===false){e.preventDefault();}cancelled=e.defaultPrevented;if(!cancelled&&this.type=="submit"&&!(this.valueNode||this.focusNode).form){for(var node=this.domNode;node.parentNode;node=node.parentNode){var _7be=_7bc.byNode(node);if(_7be&&typeof _7be._onSubmit=="function"){_7be._onSubmit(e);e.preventDefault();cancelled=true;break;}}}return !cancelled;},postCreate:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},onClick:function(){return true;},_setLabelAttr:function(_7bf){this._set("label",_7bf);var _7c0=this.containerNode||this.focusNode;_7c0.innerHTML=_7bf;}});if(has("dojo-bidi")){_7bd=_7bb("dijit.form._ButtonMixin",_7bd,{_setLabelAttr:function(){this.inherited(arguments);var _7c1=this.containerNode||this.focusNode;this.applyTextDir(_7c1);}});}return _7bd;});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_7c2,_7c3){var _7c4={};lang.setObject("dojo.colors",_7c4);var _7c5=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_7c2.fromRgb=function(_7c6,obj){var m=_7c6.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_7c3.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _7c2.fromArray(a,obj);}return _7c2.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_7c5(m1,m2,H+1/3)*256,_7c5(m1,m2,H)*256,_7c5(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _7c2.fromArray(a,obj);}}return null;};var _7c7=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_7c2.prototype.sanitize=function(){var t=this;t.r=Math.round(_7c7(t.r,0,255));t.g=Math.round(_7c7(t.g,0,255));t.b=Math.round(_7c7(t.b,0,255));t.a=_7c7(t.a,0,1);return this;};_7c4.makeGrey=_7c2.makeGrey=function(g,a){return _7c2.fromArray([g,g,g,a]);};lang.mixin(_7c2.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _7c2;});},"dijit/tree/_dndContainer":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom-class","dojo/_base/lang","dojo/on","dojo/touch"],function(_7c8,_7c9,_7ca,lang,on,_7cb){return _7c9("dijit.tree._dndContainer",null,{constructor:function(tree,_7cc){this.tree=tree;this.node=tree.domNode;lang.mixin(this,_7cc);this.containerState="";_7ca.add(this.node,"dojoDndContainer");this.events=[on(this.node,_7cb.enter,lang.hitch(this,"onOverEvent")),on(this.node,_7cb.leave,lang.hitch(this,"onOutEvent")),_7c8.after(this.tree,"_onNodeMouseEnter",lang.hitch(this,"onMouseOver"),true),_7c8.after(this.tree,"_onNodeMouseLeave",lang.hitch(this,"onMouseOut"),true),on(this.node,"dragstart, selectstart",function(evt){evt.preventDefault();})];},destroy:function(){var h;while(h=this.events.pop()){h.remove();}this.node=this.parent=null;},onMouseOver:function(_7cd){this.current=_7cd;},onMouseOut:function(){this.current=null;},_changeState:function(type,_7ce){var _7cf="dojoDnd"+type;var _7d0=type.toLowerCase()+"State";_7ca.replace(this.node,_7cf+_7ce,_7cf+this[_7d0]);this[_7d0]=_7ce;},_addItemClass:function(node,type){_7ca.add(node,"dojoDndItem"+type);},_removeItemClass:function(node,type){_7ca.remove(node,"dojoDndItem"+type);},onOverEvent:function(){this._changeState("Container","Over");},onOutEvent:function(){this._changeState("Container","");}});});},"dojo/date/locale":function(){define(["../_base/lang","../_base/array","../date","../cldr/supplemental","../i18n","../regexp","../string","../i18n!../cldr/nls/gregorian","module"],function(lang,_7d1,date,_7d2,i18n,_7d3,_7d4,_7d5,_7d6){var _7d7={};lang.setObject(_7d6.id.replace(/\//g,"."),_7d7);function _7d8(_7d9,_7da,_7db,_7dc){return _7dc.replace(/([a-z])\1*/ig,function(_7dd){var s,pad,c=_7dd.charAt(0),l=_7dd.length,_7de=["abbr","wide","narrow"];switch(c){case "G":s=_7da[(l<4)?"eraAbbr":"eraNames"][_7d9.getFullYear()<0?0:1];break;case "y":s=_7d9.getFullYear();switch(l){case 1:break;case 2:if(!_7db.fullYear){s=String(s);s=s.substr(s.length-2);break;}default:pad=true;}break;case "Q":case "q":s=Math.ceil((_7d9.getMonth()+1)/3);pad=true;break;case "M":case "L":var m=_7d9.getMonth();if(l<3){s=m+1;pad=true;}else{var _7df=["months",c=="L"?"standAlone":"format",_7de[l-3]].join("-");s=_7da[_7df][m];}break;case "w":var _7e0=0;s=_7d7._getWeekOfYear(_7d9,_7e0);pad=true;break;case "d":s=_7d9.getDate();pad=true;break;case "D":s=_7d7._getDayOfYear(_7d9);pad=true;break;case "e":case "c":var d=_7d9.getDay();if(l<2){s=(d-_7d2.getFirstDayOfWeek(_7db.locale)+8)%7;break;}case "E":d=_7d9.getDay();if(l<3){s=d+1;pad=true;}else{var _7e1=["days",c=="c"?"standAlone":"format",_7de[l-3]].join("-");s=_7da[_7e1][d];}break;case "a":var _7e2=_7d9.getHours()<12?"am":"pm";s=_7db[_7e2]||_7da["dayPeriods-format-wide-"+_7e2];break;case "h":case "H":case "K":case "k":var h=_7d9.getHours();switch(c){case "h":s=(h%12)||12;break;case "H":s=h;break;case "K":s=(h%12);break;case "k":s=h||24;break;}pad=true;break;case "m":s=_7d9.getMinutes();pad=true;break;case "s":s=_7d9.getSeconds();pad=true;break;case "S":s=Math.round(_7d9.getMilliseconds()*Math.pow(10,l-3));pad=true;break;case "v":case "z":s=_7d7._getZone(_7d9,true,_7db);if(s){break;}l=4;case "Z":var _7e3=_7d7._getZone(_7d9,false,_7db);var tz=[(_7e3<=0?"+":"-"),_7d4.pad(Math.floor(Math.abs(_7e3)/60),2),_7d4.pad(Math.abs(_7e3)%60,2)];if(l==4){tz.splice(0,0,"GMT");tz.splice(3,0,":");}s=tz.join("");break;default:throw new Error("dojo.date.locale.format: invalid pattern char: "+_7dc);}if(pad){s=_7d4.pad(s,l);}return s;});};_7d7._getZone=function(_7e4,_7e5,_7e6){if(_7e5){return date.getTimezoneName(_7e4);}else{return _7e4.getTimezoneOffset();}};_7d7.format=function(_7e7,_7e8){_7e8=_7e8||{};var _7e9=i18n.normalizeLocale(_7e8.locale),_7ea=_7e8.formatLength||"short",_7eb=_7d7._getGregorianBundle(_7e9),str=[],_7ec=lang.hitch(this,_7d8,_7e7,_7eb,_7e8);if(_7e8.selector=="year"){return _7ed(_7eb["dateFormatItem-yyyy"]||"yyyy",_7ec);}var _7ee;if(_7e8.selector!="date"){_7ee=_7e8.timePattern||_7eb["timeFormat-"+_7ea];if(_7ee){str.push(_7ed(_7ee,_7ec));}}if(_7e8.selector!="time"){_7ee=_7e8.datePattern||_7eb["dateFormat-"+_7ea];if(_7ee){str.push(_7ed(_7ee,_7ec));}}return str.length==1?str[0]:_7eb["dateTimeFormat-"+_7ea].replace(/\'/g,"").replace(/\{(\d+)\}/g,function(_7ef,key){return str[key];});};_7d7.regexp=function(_7f0){return _7d7._parseInfo(_7f0).regexp;};_7d7._parseInfo=function(_7f1){_7f1=_7f1||{};var _7f2=i18n.normalizeLocale(_7f1.locale),_7f3=_7d7._getGregorianBundle(_7f2),_7f4=_7f1.formatLength||"short",_7f5=_7f1.datePattern||_7f3["dateFormat-"+_7f4],_7f6=_7f1.timePattern||_7f3["timeFormat-"+_7f4],_7f7;if(_7f1.selector=="date"){_7f7=_7f5;}else{if(_7f1.selector=="time"){_7f7=_7f6;}else{_7f7=_7f3["dateTimeFormat-"+_7f4].replace(/\{(\d+)\}/g,function(_7f8,key){return [_7f6,_7f5][key];});}}var _7f9=[],re=_7ed(_7f7,lang.hitch(this,_7fa,_7f9,_7f3,_7f1));return {regexp:re,tokens:_7f9,bundle:_7f3};};_7d7.parse=function(_7fb,_7fc){var _7fd=/[\u200E\u200F\u202A\u202E]/g,info=_7d7._parseInfo(_7fc),_7fe=info.tokens,_7ff=info.bundle,re=new RegExp("^"+info.regexp.replace(_7fd,"")+"$",info.strict?"":"i"),_800=re.exec(_7fb&&_7fb.replace(_7fd,""));if(!_800){return null;}var _801=["abbr","wide","narrow"],_802=[1970,0,1,0,0,0,0],amPm="",_803=_7d1.every(_800,function(v,i){if(!i){return true;}var _804=_7fe[i-1],l=_804.length,c=_804.charAt(0);switch(c){case "y":if(l!=2&&_7fc.strict){_802[0]=v;}else{if(v<100){v=Number(v);var year=""+new Date().getFullYear(),_805=year.substring(0,2)*100,_806=Math.min(Number(year.substring(2,4))+20,99);_802[0]=(v<_806)?_805+v:_805-100+v;}else{if(_7fc.strict){return false;}_802[0]=v;}}break;case "M":case "L":if(l>2){var _807=_7ff["months-"+(c=="L"?"standAlone":"format")+"-"+_801[l-3]].concat();if(!_7fc.strict){v=v.replace(".","").toLowerCase();_807=_7d1.map(_807,function(s){return s.replace(".","").toLowerCase();});}v=_7d1.indexOf(_807,v);if(v==-1){return false;}}else{v--;}_802[1]=v;break;case "E":case "e":case "c":var days=_7ff["days-"+(c=="c"?"standAlone":"format")+"-"+_801[l-3]].concat();if(!_7fc.strict){v=v.toLowerCase();days=_7d1.map(days,function(d){return d.toLowerCase();});}v=_7d1.indexOf(days,v);if(v==-1){return false;}break;case "D":_802[1]=0;case "d":_802[2]=v;break;case "a":var am=_7fc.am||_7ff["dayPeriods-format-wide-am"],pm=_7fc.pm||_7ff["dayPeriods-format-wide-pm"];if(!_7fc.strict){var _808=/\./g;v=v.replace(_808,"").toLowerCase();am=am.replace(_808,"").toLowerCase();pm=pm.replace(_808,"").toLowerCase();}if(_7fc.strict&&v!=am&&v!=pm){return false;}amPm=(v==pm)?"p":(v==am)?"a":"";break;case "K":if(v==24){v=0;}case "h":case "H":case "k":if(v>23){return false;}_802[3]=v;break;case "m":_802[4]=v;break;case "s":_802[5]=v;break;case "S":_802[6]=v;}return true;});var _809=+_802[3];if(amPm==="p"&&_809<12){_802[3]=_809+12;}else{if(amPm==="a"&&_809==12){_802[3]=0;}}var _80a=new Date(_802[0],_802[1],_802[2],_802[3],_802[4],_802[5],_802[6]);if(_7fc.strict){_80a.setFullYear(_802[0]);}var _80b=_7fe.join(""),_80c=_80b.indexOf("d")!=-1,_80d=_80b.indexOf("M")!=-1;if(!_803||(_80d&&_80a.getMonth()>_802[1])||(_80c&&_80a.getDate()>_802[2])){return null;}if((_80d&&_80a.getMonth()<_802[1])||(_80c&&_80a.getDate()<_802[2])){_80a=date.add(_80a,"hour",1);}return _80a;};function _7ed(_80e,_80f,_810,_811){var _812=function(x){return x;};_80f=_80f||_812;_810=_810||_812;_811=_811||_812;var _813=_80e.match(/(''|[^'])+/g),_814=_80e.charAt(0)=="'";_7d1.forEach(_813,function(_815,i){if(!_815){_813[i]="";}else{_813[i]=(_814?_810:_80f)(_815.replace(/''/g,"'"));_814=!_814;}});return _811(_813.join(""));};function _7fa(_816,_817,_818,_819){_819=_7d3.escapeString(_819);if(!_818.strict){_819=_819.replace(" a"," ?a");}return _819.replace(/([a-z])\1*/ig,function(_81a){var s,c=_81a.charAt(0),l=_81a.length,p2="",p3="";if(_818.strict){if(l>1){p2="0"+"{"+(l-1)+"}";}if(l>2){p3="0"+"{"+(l-2)+"}";}}else{p2="0?";p3="0{0,2}";}switch(c){case "y":s="\\d{2,4}";break;case "M":case "L":s=(l>2)?"\\S+?":"1[0-2]|"+p2+"[1-9]";break;case "D":s="[12][0-9][0-9]|3[0-5][0-9]|36[0-6]|"+p2+"[1-9][0-9]|"+p3+"[1-9]";break;case "d":s="3[01]|[12]\\d|"+p2+"[1-9]";break;case "w":s="[1-4][0-9]|5[0-3]|"+p2+"[1-9]";break;case "E":case "e":case "c":s="\\S+";break;case "h":s="1[0-2]|"+p2+"[1-9]";break;case "k":s="1[01]|"+p2+"\\d";break;case "H":s="1\\d|2[0-3]|"+p2+"\\d";break;case "K":s="1\\d|2[0-4]|"+p2+"[1-9]";break;case "m":case "s":s="[0-5]\\d";break;case "S":s="\\d{"+l+"}";break;case "a":var am=_818.am||_817["dayPeriods-format-wide-am"],pm=_818.pm||_817["dayPeriods-format-wide-pm"];s=am+"|"+pm;if(!_818.strict){if(am!=am.toLowerCase()){s+="|"+am.toLowerCase();}if(pm!=pm.toLowerCase()){s+="|"+pm.toLowerCase();}if(s.indexOf(".")!=-1){s+="|"+s.replace(/\./g,"");}}s=s.replace(/\./g,"\\.");break;default:s=".*";}if(_816){_816.push(_81a);}return "("+s+")";}).replace(/[\xa0 ]/g,"[\\s\\xa0]");};var _81b=[];_7d7.addCustomFormats=function(_81c,_81d){_81b.push({pkg:_81c,name:_81d});};_7d7._getGregorianBundle=function(_81e){var _81f={};_7d1.forEach(_81b,function(desc){var _820=i18n.getLocalization(desc.pkg,desc.name,_81e);_81f=lang.mixin(_81f,_820);},this);return _81f;};_7d7.addCustomFormats(_7d6.id.replace(/\/date\/locale$/,".cldr"),"gregorian");_7d7.getNames=function(item,type,_821,_822){var _823,_824=_7d7._getGregorianBundle(_822),_825=[item,_821,type];if(_821=="standAlone"){var key=_825.join("-");_823=_824[key];if(_823[0]==1){_823=undefined;}}_825[1]="format";return (_823||_824[_825.join("-")]).concat();};_7d7.isWeekend=function(_826,_827){var _828=_7d2.getWeekend(_827),day=(_826||new Date()).getDay();if(_828.end<_828.start){_828.end+=7;if(day<_828.start){day+=7;}}return day>=_828.start&&day<=_828.end;};_7d7._getDayOfYear=function(_829){return date.difference(new Date(_829.getFullYear(),0,1,_829.getHours()),_829)+1;};_7d7._getWeekOfYear=function(_82a,_82b){if(arguments.length==1){_82b=0;}var _82c=new Date(_82a.getFullYear(),0,1).getDay(),adj=(_82c-_82b+7)%7,week=Math.floor((_7d7._getDayOfYear(_82a)+adj-1)/7);if(_82c==_82b){week++;}return week;};return _7d7;});},"dijit/form/VerticalRule":function(){define(["dojo/_base/declare","./HorizontalRule"],function(_82d,_82e){return _82d("dijit.form.VerticalRule",_82e,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV\"></div>",_positionPrefix:"<div class=\"dijitRuleMark dijitRuleMarkV\" style=\"top:",_isHorizontal:false});});},"dijit/form/_FormSelectWidget":function(){define(["dojo/_base/array","dojo/_base/Deferred","dojo/aspect","dojo/data/util/sorter","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/when","dojo/store/util/QueryResults","./_FormValueWidget"],function(_82f,_830,_831,_832,_833,dom,_834,_835,lang,_836,when,_837,_838){var _839=_833("dijit.form._FormSelectWidget",_838,{multiple:false,options:null,store:null,query:null,queryOptions:null,labelAttr:"",onFetch:null,sortByLabel:true,loadChildrenOnOpen:false,onLoadDeferred:null,getOptions:function(_83a){var opts=this.options||[];if(_83a==null){return opts;}if(lang.isArray(_83a)){return _82f.map(_83a,"return this.getOptions(item);",this);}if(lang.isString(_83a)){_83a={value:_83a};}if(lang.isObject(_83a)){if(!_82f.some(opts,function(_83b,idx){for(var a in _83a){if(!(a in _83b)||_83b[a]!=_83a[a]){return false;}}_83a=idx;return true;})){_83a=-1;}}if(_83a>=0&&_83a<opts.length){return opts[_83a];}return null;},addOption:function(_83c){_82f.forEach([].concat(_83c),function(i){if(i&&lang.isObject(i)){this.options.push(i);}},this);this._loadChildren();},removeOption:function(_83d){var _83e=this.getOptions([].concat(_83d));_82f.forEach(_83e,function(_83f){if(_83f){this.options=_82f.filter(this.options,function(node){return (node.value!==_83f.value||node.label!==_83f.label);});this._removeOptionItem(_83f);}},this);this._loadChildren();},updateOption:function(_840){_82f.forEach([].concat(_840),function(i){var _841=this.getOptions({value:i.value}),k;if(_841){for(k in i){_841[k]=i[k];}}},this);this._loadChildren();},setStore:function(_842,_843,_844){var _845=this.store;_844=_844||{};if(_845!==_842){var h;while((h=this._notifyConnections.pop())){h.remove();}if(!_842.get){lang.mixin(_842,{_oldAPI:true,get:function(id){var _846=new _830();this.fetchItemByIdentity({identity:id,onItem:function(_847){_846.resolve(_847);},onError:function(_848){_846.reject(_848);}});return _846.promise;},query:function(_849,_84a){var _84b=new _830(function(){if(_84c.abort){_84c.abort();}});_84b.total=new _830();var _84c=this.fetch(lang.mixin({query:_849,onBegin:function(_84d){_84b.total.resolve(_84d);},onComplete:function(_84e){_84b.resolve(_84e);},onError:function(_84f){_84b.reject(_84f);}},_84a));return new _837(_84b);}});if(_842.getFeatures()["dojo.data.api.Notification"]){this._notifyConnections=[_831.after(_842,"onNew",lang.hitch(this,"_onNewItem"),true),_831.after(_842,"onDelete",lang.hitch(this,"_onDeleteItem"),true),_831.after(_842,"onSet",lang.hitch(this,"_onSetItem"),true)];}}this._set("store",_842);}if(this.options&&this.options.length){this.removeOption(this.options);}if(this._queryRes&&this._queryRes.close){this._queryRes.close();}if(_844.query){this._set("query",_844.query);this._set("queryOptions",_844.queryOptions);}if(_842){this._loadingStore=true;this.onLoadDeferred=new _830();this._queryRes=_842.query(this.query,this.queryOptions);when(this._queryRes,lang.hitch(this,function(_850){if(this.sortByLabel&&!_844.sort&&_850.length){if(_842.getValue){_850.sort(_832.createSortFunction([{attribute:_842.getLabelAttributes(_850[0])[0]}],_842));}else{var _851=this.labelAttr;_850.sort(function(a,b){return a[_851]>b[_851]?1:b[_851]>a[_851]?-1:0;});}}if(_844.onFetch){_850=_844.onFetch.call(this,_850,_844);}_82f.forEach(_850,function(i){this._addOptionForItem(i);},this);if(this._queryRes.observe){this._queryRes.observe(lang.hitch(this,function(_852,_853,_854){if(_853==_854){this._onSetItem(_852);}else{if(_853!=-1){this._onDeleteItem(_852);}if(_854!=-1){this._onNewItem(_852);}}}),true);}this._loadingStore=false;this.set("value","_pendingValue" in this?this._pendingValue:_843);delete this._pendingValue;if(!this.loadChildrenOnOpen){this._loadChildren();}else{this._pseudoLoadChildren(_850);}this.onLoadDeferred.resolve(true);this.onSetStore();}),function(err){console.error("dijit.form.Select: "+err.toString());this.onLoadDeferred.reject(err);});}return _845;},_setValueAttr:function(_855,_856){if(!this._onChangeActive){_856=null;}if(this._loadingStore){this._pendingValue=_855;return;}if(_855==null){return;}if(lang.isArray(_855)){_855=_82f.map(_855,function(_857){return lang.isObject(_857)?_857:{value:_857};});}else{if(lang.isObject(_855)){_855=[_855];}else{_855=[{value:_855}];}}_855=_82f.filter(this.getOptions(_855),function(i){return i&&i.value;});var opts=this.getOptions()||[];if(!this.multiple&&(!_855[0]||!_855[0].value)&&!!opts.length){_855[0]=opts[0];}_82f.forEach(opts,function(opt){opt.selected=_82f.some(_855,function(v){return v.value===opt.value;});});var val=_82f.map(_855,function(opt){return opt.value;});if(typeof val=="undefined"||typeof val[0]=="undefined"){return;}var disp=_82f.map(_855,function(opt){return opt.label;});this._setDisplay(this.multiple?disp:disp[0]);this.inherited(arguments,[this.multiple?val:val[0],_856]);this._updateSelection();},_getDisplayedValueAttr:function(){var ret=_82f.map([].concat(this.get("selectedOptions")),function(v){if(v&&"label" in v){return v.label;}else{if(v){return v.value;}}return null;},this);return this.multiple?ret:ret[0];},_setDisplayedValueAttr:function(_858){this.set("value",this.getOptions(typeof _858=="string"?{label:_858}:_858));},_loadChildren:function(){if(this._loadingStore){return;}_82f.forEach(this._getChildren(),function(_859){_859.destroyRecursive();});_82f.forEach(this.options,this._addOptionItem,this);this._updateSelection();},_updateSelection:function(){this.focusedChild=null;this._set("value",this._getValueFromOpts());var val=[].concat(this.value);if(val&&val[0]){var self=this;_82f.forEach(this._getChildren(),function(_85a){var _85b=_82f.some(val,function(v){return _85a.option&&(v===_85a.option.value);});if(_85b&&!self.multiple){self.focusedChild=_85a;}_834.toggle(_85a.domNode,this.baseClass.replace(/\s+|$/g,"SelectedOption "),_85b);_85a.domNode.setAttribute("aria-selected",_85b?"true":"false");},this);}},_getValueFromOpts:function(){var opts=this.getOptions()||[];if(!this.multiple&&opts.length){var opt=_82f.filter(opts,function(i){return i.selected;})[0];if(opt&&opt.value){return opt.value;}else{opts[0].selected=true;return opts[0].value;}}else{if(this.multiple){return _82f.map(_82f.filter(opts,function(i){return i.selected;}),function(i){return i.value;})||[];}}return "";},_onNewItem:function(item,_85c){if(!_85c||!_85c.parent){this._addOptionForItem(item);}},_onDeleteItem:function(item){var _85d=this.store;this.removeOption({value:_85d.getIdentity(item)});},_onSetItem:function(item){this.updateOption(this._getOptionObjForItem(item));},_getOptionObjForItem:function(item){var _85e=this.store,_85f=(this.labelAttr&&this.labelAttr in item)?item[this.labelAttr]:_85e.getLabel(item),_860=(_85f?_85e.getIdentity(item):null);return {value:_860,label:_85f,item:item};},_addOptionForItem:function(item){var _861=this.store;if(_861.isItemLoaded&&!_861.isItemLoaded(item)){_861.loadItem({item:item,onItem:function(i){this._addOptionForItem(i);},scope:this});return;}var _862=this._getOptionObjForItem(item);this.addOption(_862);},constructor:function(_863){this._oValue=(_863||{}).value||null;this._notifyConnections=[];},buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.focusNode,false);},_fillContent:function(){if(!this.options){this.options=this.srcNodeRef?_836("> *",this.srcNodeRef).map(function(node){if(node.getAttribute("type")==="separator"){return {value:"",label:"",selected:false,disabled:false};}return {value:(node.getAttribute("data-"+_835._scopeName+"-value")||node.getAttribute("value")),label:String(node.innerHTML),selected:node.getAttribute("selected")||false,disabled:node.getAttribute("disabled")||false};},this):[];}if(!this.value){this._set("value",this._getValueFromOpts());}else{if(this.multiple&&typeof this.value=="string"){this._set("value",this.value.split(","));}}},postCreate:function(){this.inherited(arguments);_831.after(this,"onChange",lang.hitch(this,"_updateSelection"));var _864=this.store;if(_864&&(_864.getIdentity||_864.getFeatures()["dojo.data.api.Identity"])){this.store=null;this.setStore(_864,this._oValue);}},startup:function(){this._loadChildren();this.inherited(arguments);},destroy:function(){var h;while((h=this._notifyConnections.pop())){h.remove();}if(this._queryRes&&this._queryRes.close){this._queryRes.close();}this.inherited(arguments);},_addOptionItem:function(){},_removeOptionItem:function(){},_setDisplay:function(){},_getChildren:function(){return [];},_getSelectedOptionsAttr:function(){return this.getOptions({selected:true});},_pseudoLoadChildren:function(){},onSetStore:function(){}});return _839;});},"dijit/form/Select":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/dom-geometry","dojo/i18n","dojo/_base/lang","dojo/on","dojo/sniff","./_FormSelectWidget","../_HasDropDown","../DropDownMenu","../MenuItem","../MenuSeparator","../Tooltip","../_KeyNavMixin","../registry","dojo/text!./templates/Select.html","dojo/i18n!./nls/validate"],function(_865,_866,_867,_868,_869,i18n,lang,on,has,_86a,_86b,_86c,_86d,_86e,_86f,_870,_871,_872){var _873=_866("dijit.form._SelectMenu",_86c,{autoFocus:true,buildRendering:function(){this.inherited(arguments);this.domNode.setAttribute("role","listbox");},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"selectstart",function(evt){evt.preventDefault();evt.stopPropagation();}));},focus:function(){var _874=false,val=this.parentWidget.value;if(lang.isArray(val)){val=val[val.length-1];}if(val){_865.forEach(this.parentWidget._getChildren(),function(_875){if(_875.option&&(val===_875.option.value)){_874=true;this.focusChild(_875,false);}},this);}if(!_874){this.inherited(arguments);}}});var _876=_866("dijit.form.Select"+(has("dojo-bidi")?"_NoBidi":""),[_86a,_86b,_870],{baseClass:"dijitSelect dijitValidationTextBox",templateString:_872,_buttonInputDisabled:has("ie")?"disabled":"",required:false,state:"",message:"",tooltipPosition:[],emptyLabel:"&#160;",_isLoaded:false,_childrenLoaded:false,_fillContent:function(){this.inherited(arguments);if(this.options.length&&!this.value&&this.srcNodeRef){var si=this.srcNodeRef.selectedIndex||0;this._set("value",this.options[si>=0?si:0].value);}this.dropDown=new _873({id:this.id+"_menu",parentWidget:this});_868.add(this.dropDown.domNode,this.baseClass.replace(/\s+|$/g,"Menu "));},_getMenuItemForOption:function(_877){if(!_877.value&&!_877.label){return new _86e({ownerDocument:this.ownerDocument});}else{var _878=lang.hitch(this,"_setValueAttr",_877);var item=new _86d({option:_877,label:_877.label||this.emptyLabel,onClick:_878,ownerDocument:this.ownerDocument,dir:this.dir,textDir:this.textDir,disabled:_877.disabled||false});item.focusNode.setAttribute("role","option");return item;}},_addOptionItem:function(_879){if(this.dropDown){this.dropDown.addChild(this._getMenuItemForOption(_879));}},_getChildren:function(){if(!this.dropDown){return [];}return this.dropDown.getChildren();},focus:function(){if(!this.disabled&&this.focusNode.focus){try{this.focusNode.focus();}catch(e){}}},focusChild:function(_87a){if(_87a){this.set("value",_87a.option);}},_getFirst:function(){var _87b=this._getChildren();return _87b.length?_87b[0]:null;},_getLast:function(){var _87c=this._getChildren();return _87c.length?_87c[_87c.length-1]:null;},childSelector:function(node){var node=_871.byNode(node);return node&&node.getParent()==this.dropDown;},onKeyboardSearch:function(item,evt,_87d,_87e){if(item){this.focusChild(item);}},_loadChildren:function(_87f){if(_87f===true){if(this.dropDown){delete this.dropDown.focusedChild;this.focusedChild=null;}if(this.options.length){this.inherited(arguments);}else{_865.forEach(this._getChildren(),function(_880){_880.destroyRecursive();});var item=new _86d({ownerDocument:this.ownerDocument,label:this.emptyLabel});this.dropDown.addChild(item);}}else{this._updateSelection();}this._isLoaded=false;this._childrenLoaded=true;if(!this._loadingStore){this._setValueAttr(this.value,false);}},_refreshState:function(){if(this._started){this.validate(this.focused);}},startup:function(){this.inherited(arguments);this._refreshState();},_setValueAttr:function(_881){this.inherited(arguments);_867.set(this.valueNode,"value",this.get("value"));this._refreshState();},_setNameAttr:"valueNode",_setDisabledAttr:function(_882){this.inherited(arguments);this._refreshState();},_setRequiredAttr:function(_883){this._set("required",_883);this.focusNode.setAttribute("aria-required",_883);this._refreshState();},_setOptionsAttr:function(_884){this._isLoaded=false;this._set("options",_884);},_setDisplay:function(_885){var lbl=_885||this.emptyLabel;this.containerNode.innerHTML="<span role=\"option\" class=\"dijitReset dijitInline "+this.baseClass.replace(/\s+|$/g,"Label ")+"\">"+lbl+"</span>";},validate:function(_886){var _887=this.disabled||this.isValid(_886);this._set("state",_887?"":(this._hasBeenBlurred?"Error":"Incomplete"));this.focusNode.setAttribute("aria-invalid",_887?"false":"true");var _888=_887?"":this._missingMsg;if(_888&&this.focused&&this._hasBeenBlurred){_86f.show(_888,this.domNode,this.tooltipPosition,!this.isLeftToRight());}else{_86f.hide(this.domNode);}this._set("message",_888);return _887;},isValid:function(){return (!this.required||this.value===0||!(/^\s*$/.test(this.value||"")));},reset:function(){this.inherited(arguments);_86f.hide(this.domNode);this._refreshState();},postMixInProperties:function(){this.inherited(arguments);this._missingMsg=i18n.getLocalization("dijit.form","validate",this.lang).missingMessage;},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"selectstart",function(evt){evt.preventDefault();evt.stopPropagation();}));this.domNode.setAttribute("aria-expanded","false");if(has("ie")<9){this.defer(function(){try{var s=domStyle.getComputedStyle(this.domNode);if(s){var ff=s.fontFamily;if(ff){var _889=this.domNode.getElementsByTagName("INPUT");if(_889){for(var i=0;i<_889.length;i++){_889[i].style.fontFamily=ff;}}}}}catch(e){}});}},_setStyleAttr:function(_88a){this.inherited(arguments);_868.toggle(this.domNode,this.baseClass.replace(/\s+|$/g,"FixedWidth "),!!this.domNode.style.width);},isLoaded:function(){return this._isLoaded;},loadDropDown:function(_88b){this._loadChildren(true);this._isLoaded=true;_88b();},destroy:function(_88c){if(this.dropDown&&!this.dropDown._destroyed){this.dropDown.destroyRecursive(_88c);delete this.dropDown;}this.inherited(arguments);},_onFocus:function(){this.validate(true);this.inherited(arguments);},_onBlur:function(){_86f.hide(this.domNode);this.inherited(arguments);this.validate(false);}});if(has("dojo-bidi")){_876=_866("dijit.form.Select",_876,{_setDisplay:function(_88d){this.inherited(arguments);this.applyTextDir(this.containerNode);}});}_876._Menu=_873;function _88e(_88f){return function(evt){if(!this._isLoaded){this.loadDropDown(lang.hitch(this,_88f,evt));}else{this.inherited(_88f,arguments);}};};_876.prototype._onContainerKeydown=_88e("_onContainerKeydown");_876.prototype._onContainerKeypress=_88e("_onContainerKeypress");return _876;});},"dijit/_editor/range":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/lang"],function(_890,_891,lang){var _892={getIndex:function(node,_893){var ret=[],retR=[];var _894=node;var _895,n;while(node!=_893){var i=0;_895=node.parentNode;while((n=_895.childNodes[i++])){if(n===node){--i;break;}}ret.unshift(i);retR.unshift(i-_895.childNodes.length);node=_895;}if(ret.length>0&&_894.nodeType==3){n=_894.previousSibling;while(n&&n.nodeType==3){ret[ret.length-1]--;n=n.previousSibling;}n=_894.nextSibling;while(n&&n.nodeType==3){retR[retR.length-1]++;n=n.nextSibling;}}return {o:ret,r:retR};},getNode:function(_896,_897){if(!lang.isArray(_896)||_896.length==0){return _897;}var node=_897;_890.every(_896,function(i){if(i>=0&&i<node.childNodes.length){node=node.childNodes[i];}else{node=null;return false;}return true;});return node;},getCommonAncestor:function(n1,n2,root){root=root||n1.ownerDocument.body;var _898=function(n){var as=[];while(n){as.unshift(n);if(n!==root){n=n.parentNode;}else{break;}}return as;};var n1as=_898(n1);var n2as=_898(n2);var m=Math.min(n1as.length,n2as.length);var com=n1as[0];for(var i=1;i<m;i++){if(n1as[i]===n2as[i]){com=n1as[i];}else{break;}}return com;},getAncestor:function(node,_899,root){root=root||node.ownerDocument.body;while(node&&node!==root){var name=node.nodeName.toUpperCase();if(_899.test(name)){return node;}node=node.parentNode;}return null;},BlockTagNames:/^(?:P|DIV|H1|H2|H3|H4|H5|H6|ADDRESS|PRE|OL|UL|LI|DT|DE)$/,getBlockAncestor:function(node,_89a,root){root=root||node.ownerDocument.body;_89a=_89a||_892.BlockTagNames;var _89b=null,_89c;while(node&&node!==root){var name=node.nodeName.toUpperCase();if(!_89b&&_89a.test(name)){_89b=node;}if(!_89c&&(/^(?:BODY|TD|TH|CAPTION)$/).test(name)){_89c=node;}node=node.parentNode;}return {blockNode:_89b,blockContainer:_89c||node.ownerDocument.body};},atBeginningOfContainer:function(_89d,node,_89e){var _89f=false;var _8a0=(_89e==0);if(!_8a0&&node.nodeType==3){if(/^[\s\xA0]+$/.test(node.nodeValue.substr(0,_89e))){_8a0=true;}}if(_8a0){var _8a1=node;_89f=true;while(_8a1&&_8a1!==_89d){if(_8a1.previousSibling){_89f=false;break;}_8a1=_8a1.parentNode;}}return _89f;},atEndOfContainer:function(_8a2,node,_8a3){var _8a4=false;var _8a5=(_8a3==(node.length||node.childNodes.length));if(!_8a5&&node.nodeType==3){if(/^[\s\xA0]+$/.test(node.nodeValue.substr(_8a3))){_8a5=true;}}if(_8a5){var _8a6=node;_8a4=true;while(_8a6&&_8a6!==_8a2){if(_8a6.nextSibling){_8a4=false;break;}_8a6=_8a6.parentNode;}}return _8a4;},adjacentNoneTextNode:function(_8a7,next){var node=_8a7;var len=(0-_8a7.length)||0;var prop=next?"nextSibling":"previousSibling";while(node){if(node.nodeType!=3){break;}len+=node.length;node=node[prop];}return [node,len];},create:function(win){win=win||window;if(win.getSelection){return win.document.createRange();}else{return new _8a8();}},getSelection:function(_8a9,_8aa){if(_8a9.getSelection){return _8a9.getSelection();}else{var s=new ie.selection(_8a9);if(!_8aa){s._getCurrentSelection();}return s;}}};if(!window.getSelection){var ie=_892.ie={cachedSelection:{},selection:function(_8ab){this._ranges=[];this.addRange=function(r,_8ac){this._ranges.push(r);if(!_8ac){r._select();}this.rangeCount=this._ranges.length;};this.removeAllRanges=function(){this._ranges=[];this.rangeCount=0;};var _8ad=function(){var r=_8ab.document.selection.createRange();var type=_8ab.document.selection.type.toUpperCase();if(type=="CONTROL"){return new _8a8(ie.decomposeControlRange(r));}else{return new _8a8(ie.decomposeTextRange(r));}};this.getRangeAt=function(i){return this._ranges[i];};this._getCurrentSelection=function(){this.removeAllRanges();var r=_8ad();if(r){this.addRange(r,true);this.isCollapsed=r.collapsed;}else{this.isCollapsed=true;}};},decomposeControlRange:function(_8ae){var _8af=_8ae.item(0),_8b0=_8ae.item(_8ae.length-1);var _8b1=_8af.parentNode,_8b2=_8b0.parentNode;var _8b3=_892.getIndex(_8af,_8b1).o[0];var _8b4=_892.getIndex(_8b0,_8b2).o[0]+1;return [_8b1,_8b3,_8b2,_8b4];},getEndPoint:function(_8b5,end){var _8b6=_8b5.duplicate();_8b6.collapse(!end);var _8b7="EndTo"+(end?"End":"Start");var _8b8=_8b6.parentElement();var _8b9,_8ba,_8bb;if(_8b8.childNodes.length>0){_890.every(_8b8.childNodes,function(node,i){var _8bc;if(node.nodeType!=3){_8b6.moveToElementText(node);if(_8b6.compareEndPoints(_8b7,_8b5)>0){if(_8bb&&_8bb.nodeType==3){_8b9=_8bb;_8bc=true;}else{_8b9=_8b8;_8ba=i;return false;}}else{if(i==_8b8.childNodes.length-1){_8b9=_8b8;_8ba=_8b8.childNodes.length;return false;}}}else{if(i==_8b8.childNodes.length-1){_8b9=node;_8bc=true;}}if(_8bc&&_8b9){var _8bd=_892.adjacentNoneTextNode(_8b9)[0];if(_8bd){_8b9=_8bd.nextSibling;}else{_8b9=_8b8.firstChild;}var _8be=_892.adjacentNoneTextNode(_8b9);_8bd=_8be[0];var _8bf=_8be[1];if(_8bd){_8b6.moveToElementText(_8bd);_8b6.collapse(false);}else{_8b6.moveToElementText(_8b8);}_8b6.setEndPoint(_8b7,_8b5);_8ba=_8b6.text.length-_8bf;return false;}_8bb=node;return true;});}else{_8b9=_8b8;_8ba=0;}if(!end&&_8b9.nodeType==1&&_8ba==_8b9.childNodes.length){var _8c0=_8b9.nextSibling;if(_8c0&&_8c0.nodeType==3){_8b9=_8c0;_8ba=0;}}return [_8b9,_8ba];},setEndPoint:function(_8c1,_8c2,_8c3){var _8c4=_8c1.duplicate(),node,len;if(_8c2.nodeType!=3){if(_8c3>0){node=_8c2.childNodes[_8c3-1];if(node){if(node.nodeType==3){_8c2=node;_8c3=node.length;}else{if(node.nextSibling&&node.nextSibling.nodeType==3){_8c2=node.nextSibling;_8c3=0;}else{_8c4.moveToElementText(node.nextSibling?node:_8c2);var _8c5=node.parentNode;var _8c6=_8c5.insertBefore(node.ownerDocument.createTextNode(" "),node.nextSibling);_8c4.collapse(false);_8c5.removeChild(_8c6);}}}}else{_8c4.moveToElementText(_8c2);_8c4.collapse(true);}}if(_8c2.nodeType==3){var _8c7=_892.adjacentNoneTextNode(_8c2);var _8c8=_8c7[0];len=_8c7[1];if(_8c8){_8c4.moveToElementText(_8c8);_8c4.collapse(false);if(_8c8.contentEditable!="inherit"){len++;}}else{_8c4.moveToElementText(_8c2.parentNode);_8c4.collapse(true);_8c4.move("character",1);_8c4.move("character",-1);}_8c3+=len;if(_8c3>0){if(_8c4.move("character",_8c3)!=_8c3){console.error("Error when moving!");}}}return _8c4;},decomposeTextRange:function(_8c9){var _8ca=ie.getEndPoint(_8c9);var _8cb=_8ca[0],_8cc=_8ca[1];var _8cd=_8ca[0],_8ce=_8ca[1];if(_8c9.htmlText.length){if(_8c9.htmlText==_8c9.text){_8ce=_8cc+_8c9.text.length;}else{_8ca=ie.getEndPoint(_8c9,true);_8cd=_8ca[0],_8ce=_8ca[1];}}return [_8cb,_8cc,_8cd,_8ce];},setRange:function(_8cf,_8d0,_8d1,_8d2,_8d3,_8d4){var _8d5=ie.setEndPoint(_8cf,_8d0,_8d1);_8cf.setEndPoint("StartToStart",_8d5);if(!_8d4){var end=ie.setEndPoint(_8cf,_8d2,_8d3);}_8cf.setEndPoint("EndToEnd",end||_8d5);return _8cf;}};var _8a8=_892.W3CRange=_891(null,{constructor:function(){if(arguments.length>0){this.setStart(arguments[0][0],arguments[0][1]);this.setEnd(arguments[0][2],arguments[0][3]);}else{this.commonAncestorContainer=null;this.startContainer=null;this.startOffset=0;this.endContainer=null;this.endOffset=0;this.collapsed=true;}},_updateInternal:function(){if(this.startContainer!==this.endContainer){this.commonAncestorContainer=_892.getCommonAncestor(this.startContainer,this.endContainer);}else{this.commonAncestorContainer=this.startContainer;}this.collapsed=(this.startContainer===this.endContainer)&&(this.startOffset==this.endOffset);},setStart:function(node,_8d6){_8d6=parseInt(_8d6);if(this.startContainer===node&&this.startOffset==_8d6){return;}delete this._cachedBookmark;this.startContainer=node;this.startOffset=_8d6;if(!this.endContainer){this.setEnd(node,_8d6);}else{this._updateInternal();}},setEnd:function(node,_8d7){_8d7=parseInt(_8d7);if(this.endContainer===node&&this.endOffset==_8d7){return;}delete this._cachedBookmark;this.endContainer=node;this.endOffset=_8d7;if(!this.startContainer){this.setStart(node,_8d7);}else{this._updateInternal();}},setStartAfter:function(node,_8d8){this._setPoint("setStart",node,_8d8,1);},setStartBefore:function(node,_8d9){this._setPoint("setStart",node,_8d9,0);},setEndAfter:function(node,_8da){this._setPoint("setEnd",node,_8da,1);},setEndBefore:function(node,_8db){this._setPoint("setEnd",node,_8db,0);},_setPoint:function(what,node,_8dc,ext){var _8dd=_892.getIndex(node,node.parentNode).o;this[what](node.parentNode,_8dd.pop()+ext);},_getIERange:function(){var r=(this._body||this.endContainer.ownerDocument.body).createTextRange();ie.setRange(r,this.startContainer,this.startOffset,this.endContainer,this.endOffset,this.collapsed);return r;},getBookmark:function(){this._getIERange();return this._cachedBookmark;},_select:function(){var r=this._getIERange();r.select();},deleteContents:function(){var s=this.startContainer,r=this._getIERange();if(s.nodeType===3&&!this.startOffset){this.setStartBefore(s);}r.pasteHTML("");this.endContainer=this.startContainer;this.endOffset=this.startOffset;this.collapsed=true;},cloneRange:function(){var r=new _8a8([this.startContainer,this.startOffset,this.endContainer,this.endOffset]);r._body=this._body;return r;},detach:function(){this._body=null;this.commonAncestorContainer=null;this.startContainer=null;this.startOffset=0;this.endContainer=null;this.endOffset=0;this.collapsed=true;}});}lang.setObject("dijit.range",_892);return _892;});},"dijit/_KeyNavMixin":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/_base/lang","dojo/on","dijit/registry","dijit/_FocusMixin"],function(_8de,_8df,_8e0,keys,lang,on,_8e1,_8e2){return _8df("dijit._KeyNavMixin",_8e2,{tabIndex:"0",childSelector:null,postCreate:function(){this.inherited(arguments);_8e0.set(this.domNode,"tabIndex",this.tabIndex);if(!this._keyNavCodes){var _8e3=this._keyNavCodes={};_8e3[keys.HOME]=lang.hitch(this,"focusFirstChild");_8e3[keys.END]=lang.hitch(this,"focusLastChild");_8e3[this.isLeftToRight()?keys.LEFT_ARROW:keys.RIGHT_ARROW]=lang.hitch(this,"_onLeftArrow");_8e3[this.isLeftToRight()?keys.RIGHT_ARROW:keys.LEFT_ARROW]=lang.hitch(this,"_onRightArrow");_8e3[keys.UP_ARROW]=lang.hitch(this,"_onUpArrow");_8e3[keys.DOWN_ARROW]=lang.hitch(this,"_onDownArrow");}var self=this,_8e4=typeof this.childSelector=="string"?this.childSelector:lang.hitch(this,"childSelector");this.own(on(this.domNode,"keypress",lang.hitch(this,"_onContainerKeypress")),on(this.domNode,"keydown",lang.hitch(this,"_onContainerKeydown")),on(this.domNode,"focus",lang.hitch(this,"_onContainerFocus")),on(this.containerNode,on.selector(_8e4,"focusin"),function(evt){self._onChildFocus(_8e1.getEnclosingWidget(this),evt);}));},_onLeftArrow:function(){},_onRightArrow:function(){},_onUpArrow:function(){},_onDownArrow:function(){},focus:function(){this.focusFirstChild();},_getFirstFocusableChild:function(){return this._getNextFocusableChild(null,1);},_getLastFocusableChild:function(){return this._getNextFocusableChild(null,-1);},focusFirstChild:function(){this.focusChild(this._getFirstFocusableChild());},focusLastChild:function(){this.focusChild(this._getLastFocusableChild());},focusChild:function(_8e5,last){if(!_8e5){return;}if(this.focusedChild&&_8e5!==this.focusedChild){this._onChildBlur(this.focusedChild);}_8e5.set("tabIndex",this.tabIndex);_8e5.focus(last?"end":"start");},_onContainerFocus:function(evt){if(evt.target!==this.domNode||this.focusedChild){return;}this.focus();},_onFocus:function(){_8e0.set(this.domNode,"tabIndex","-1");this.inherited(arguments);},_onBlur:function(evt){_8e0.set(this.domNode,"tabIndex",this.tabIndex);if(this.focusedChild){this.focusedChild.set("tabIndex","-1");this.lastFocusedChild=this.focusedChild;this._set("focusedChild",null);}this.inherited(arguments);},_onChildFocus:function(_8e6){if(_8e6&&_8e6!=this.focusedChild){if(this.focusedChild&&!this.focusedChild._destroyed){this.focusedChild.set("tabIndex","-1");}_8e6.set("tabIndex",this.tabIndex);this.lastFocused=_8e6;this._set("focusedChild",_8e6);}},_searchString:"",multiCharSearchDuration:1000,onKeyboardSearch:function(item,evt,_8e7,_8e8){if(item){this.focusChild(item);}},_keyboardSearchCompare:function(item,_8e9){var _8ea=item.domNode,text=item.label||(_8ea.focusNode?_8ea.focusNode.label:"")||_8ea.innerText||_8ea.textContent||"",_8eb=text.replace(/^\s+/,"").substr(0,_8e9.length).toLowerCase();return (!!_8e9.length&&_8eb==_8e9)?-1:0;},_onContainerKeydown:function(evt){var func=this._keyNavCodes[evt.keyCode];if(func){func(evt,this.focusedChild);evt.stopPropagation();evt.preventDefault();this._searchString="";}else{if(evt.keyCode==keys.SPACE&&this._searchTimer&&!(evt.ctrlKey||evt.altKey)){evt.stopImmediatePropagation();evt.preventDefault();this._keyboardSearch(evt," ");}}},_onContainerKeypress:function(evt){if(evt.charCode<keys.SPACE||(evt.ctrlKey||evt.altKey)||(evt.charCode==keys.SPACE&&this._searchTimer)){return;}evt.preventDefault();evt.stopPropagation();this._keyboardSearch(evt,String.fromCharCode(evt.charCode).toLowerCase());},_keyboardSearch:function(evt,_8ec){var _8ed=null,_8ee,_8ef=0,_8f0=lang.hitch(this,function(){if(this._searchTimer){this._searchTimer.remove();}this._searchString+=_8ec;var _8f1=/^(.)\1*$/.test(this._searchString);var _8f2=_8f1?1:this._searchString.length;_8ee=this._searchString.substr(0,_8f2);this._searchTimer=this.defer(function(){this._searchTimer=null;this._searchString="";},this.multiCharSearchDuration);var _8f3=this.focusedChild||null;if(_8f2==1||!_8f3){_8f3=this._getNextFocusableChild(_8f3,1);if(!_8f3){return;}}var stop=_8f3;do{var rc=this._keyboardSearchCompare(_8f3,_8ee);if(!!rc&&_8ef++==0){_8ed=_8f3;}if(rc==-1){_8ef=-1;break;}_8f3=this._getNextFocusableChild(_8f3,1);}while(_8f3!=stop);});_8f0();this.onKeyboardSearch(_8ed,evt,_8ee,_8ef);},_onChildBlur:function(){},_getNextFocusableChild:function(_8f4,dir){var _8f5=_8f4;do{if(!_8f4){_8f4=this[dir>0?"_getFirst":"_getLast"]();if(!_8f4){break;}}else{_8f4=this._getNext(_8f4,dir);}if(_8f4!=null&&_8f4!=_8f5&&_8f4.isFocusable()){return _8f4;}}while(_8f4!=_8f5);return null;},_getFirst:function(){return null;},_getLast:function(){return null;},_getNext:function(_8f6,dir){if(_8f6){_8f6=_8f6.domNode;while(_8f6){_8f6=_8f6[dir<0?"previousSibling":"nextSibling"];if(_8f6&&"getAttribute" in _8f6){var w=_8e1.byNode(_8f6);if(w){return w;}}}}return null;}});});},"dojo/store/util/QueryResults":function(){define(["../../_base/array","../../_base/lang","../../when"],function(_8f7,lang,when){var _8f8=function(_8f9){if(!_8f9){return _8f9;}if(_8f9.then){_8f9=lang.delegate(_8f9);}function _8fa(_8fb){if(!_8f9[_8fb]){_8f9[_8fb]=function(){var args=arguments;return when(_8f9,function(_8fc){Array.prototype.unshift.call(args,_8fc);return _8f8(_8f7[_8fb].apply(_8f7,args));});};}};_8fa("forEach");_8fa("filter");_8fa("map");if(!_8f9.total){_8f9.total=when(_8f9,function(_8fd){return _8fd.length;});}return _8f9;};lang.setObject("dojo.store.util.QueryResults",_8f8);return _8f8;});},"dijit/form/_ListBase":function(){define(["dojo/_base/declare","dojo/on","dojo/window"],function(_8fe,on,_8ff){return _8fe("dijit.form._ListBase",null,{selected:null,_listConnect:function(_900,_901){var self=this;return self.own(on(self.containerNode,on.selector(function(_902,_903,_904){return _902.parentNode==_904;},_900),function(evt){evt.preventDefault();self[_901](evt,this);}));},selectFirstNode:function(){var _905=this.containerNode.firstChild;while(_905&&_905.style.display=="none"){_905=_905.nextSibling;}this._setSelectedAttr(_905);},selectLastNode:function(){var last=this.containerNode.lastChild;while(last&&last.style.display=="none"){last=last.previousSibling;}this._setSelectedAttr(last);},selectNextNode:function(){var _906=this.selected;if(!_906){this.selectFirstNode();}else{var next=_906.nextSibling;while(next&&next.style.display=="none"){next=next.nextSibling;}if(!next){this.selectFirstNode();}else{this._setSelectedAttr(next);}}},selectPreviousNode:function(){var _907=this.selected;if(!_907){this.selectLastNode();}else{var prev=_907.previousSibling;while(prev&&prev.style.display=="none"){prev=prev.previousSibling;}if(!prev){this.selectLastNode();}else{this._setSelectedAttr(prev);}}},_setSelectedAttr:function(node){if(this.selected!=node){var _908=this.selected;if(_908){this.onDeselect(_908);}if(node){_8ff.scrollIntoView(node);this.onSelect(node);}this._set("selected",node);}else{if(node){this.onSelect(node);}}}});});},"dojo/dnd/common":function(){define(["../sniff","../_base/kernel","../_base/lang","../dom"],function(has,_909,lang,dom){var _90a=lang.getObject("dojo.dnd",true);_90a.getCopyKeyState=function(evt){return evt[has("mac")?"metaKey":"ctrlKey"];};_90a._uniqueId=0;_90a.getUniqueId=function(){var id;do{id=_909._scopeName+"Unique"+(++_90a._uniqueId);}while(dom.byId(id));return id;};_90a._empty={};_90a.isFormElement=function(e){var t=e.target;if(t.nodeType==3){t=t.parentNode;}return " button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;};return _90a;});},"dijit/CalendarLite":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/cldr/supplemental","dojo/date","dojo/date/locale","dojo/date/stamp","dojo/dom","dojo/dom-class","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_WidgetBase","./_TemplatedMixin","dojo/text!./templates/Calendar.html","./a11yclick","./hccss"],function(_90b,_90c,_90d,date,_90e,_90f,dom,_910,lang,on,has,_911,_912,_913,_914){var _915=_90c("dijit.CalendarLite",[_912,_913],{templateString:_914,dowTemplateString:"<th class=\"dijitReset dijitCalendarDayLabelTemplate\" role=\"columnheader\" scope=\"col\"><span class=\"dijitCalendarDayLabel\">${d}</span></th>",dateTemplateString:"<td class=\"dijitReset\" role=\"gridcell\" data-dojo-attach-point=\"dateCells\"><span class=\"dijitCalendarDateLabel\" data-dojo-attach-point=\"dateLabels\"></span></td>",weekTemplateString:"<tr class=\"dijitReset dijitCalendarWeekTemplate\" role=\"row\">${d}${d}${d}${d}${d}${d}${d}</tr>",value:new Date(""),datePackage:"",dayWidth:"narrow",tabIndex:"0",currentFocus:new Date(),_setSummaryAttr:"gridNode",baseClass:"dijitCalendar",_isValidDate:function(_916){return _916&&!isNaN(_916)&&typeof _916=="object"&&_916.toString()!=this.constructor.prototype.value.toString();},_getValueAttr:function(){var _917=this._get("value");if(_917&&!isNaN(_917)){var _918=new this.dateClassObj(_917);_918.setHours(0,0,0,0);if(_918.getDate()<_917.getDate()){_918=this.dateModule.add(_918,"hour",1);}return _918;}else{return null;}},_setValueAttr:function(_919,_91a){if(typeof _919=="string"){_919=_90f.fromISOString(_919);}_919=this._patchDate(_919);if(this._isValidDate(_919)&&!this.isDisabledDate(_919,this.lang)){this._set("value",_919);this.set("currentFocus",_919);this._markSelectedDates([_919]);if(this._created&&(_91a||typeof _91a=="undefined")){this.onChange(this.get("value"));}}else{this._set("value",null);this._markSelectedDates([]);}},_patchDate:function(_91b){if(_91b){_91b=new this.dateClassObj(_91b);_91b.setHours(1,0,0,0);}return _91b;},_setText:function(node,text){while(node.firstChild){node.removeChild(node.firstChild);}node.appendChild(node.ownerDocument.createTextNode(text));},_populateGrid:function(){var _91c=new this.dateClassObj(this.currentFocus);_91c.setDate(1);var _91d=_91c.getDay(),_91e=this.dateModule.getDaysInMonth(_91c),_91f=this.dateModule.getDaysInMonth(this.dateModule.add(_91c,"month",-1)),_920=new this.dateClassObj(),_921=_90d.getFirstDayOfWeek(this.lang);if(_921>_91d){_921-=7;}if(!this.summary){var _922=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_91c);this.gridNode.setAttribute("summary",_922[_91c.getMonth()]);}this._date2cell={};_90b.forEach(this.dateCells,function(_923,idx){var i=idx+_921;var date=new this.dateClassObj(_91c),_924,_925="dijitCalendar",adj=0;if(i<_91d){_924=_91f-_91d+i+1;adj=-1;_925+="Previous";}else{if(i>=(_91d+_91e)){_924=i-_91d-_91e+1;adj=1;_925+="Next";}else{_924=i-_91d+1;_925+="Current";}}if(adj){date=this.dateModule.add(date,"month",adj);}date.setDate(_924);if(!this.dateModule.compare(date,_920,"date")){_925="dijitCalendarCurrentDate "+_925;}if(this.isDisabledDate(date,this.lang)){_925="dijitCalendarDisabledDate "+_925;_923.setAttribute("aria-disabled","true");}else{_925="dijitCalendarEnabledDate "+_925;_923.removeAttribute("aria-disabled");_923.setAttribute("aria-selected","false");}var _926=this.getClassForDate(date,this.lang);if(_926){_925=_926+" "+_925;}_923.className=_925+"Month dijitCalendarDateTemplate";var _927=date.valueOf();this._date2cell[_927]=_923;_923.dijitDateValue=_927;this._setText(this.dateLabels[idx],date.getDateLocalized?date.getDateLocalized(this.lang):date.getDate());},this);},_populateControls:function(){var _928=new this.dateClassObj(this.currentFocus);_928.setDate(1);this.monthWidget.set("month",_928);var y=_928.getFullYear()-1;var d=new this.dateClassObj();_90b.forEach(["previous","current","next"],function(name){d.setFullYear(y++);this._setText(this[name+"YearLabelNode"],this.dateLocaleModule.format(d,{selector:"year",locale:this.lang}));},this);},goToToday:function(){this.set("value",new this.dateClassObj());},constructor:function(_929){this.dateModule=_929.datePackage?lang.getObject(_929.datePackage,false):date;this.dateClassObj=this.dateModule.Date||Date;this.dateLocaleModule=_929.datePackage?lang.getObject(_929.datePackage+".locale",false):_90e;},_createMonthWidget:function(){return _915._MonthWidget({id:this.id+"_mddb",lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);},buildRendering:function(){var d=this.dowTemplateString,_92a=this.dateLocaleModule.getNames("days",this.dayWidth,"standAlone",this.lang),_92b=_90d.getFirstDayOfWeek(this.lang);this.dayCellsHtml=_911.substitute([d,d,d,d,d,d,d].join(""),{d:""},function(){return _92a[_92b++%7];});var r=_911.substitute(this.weekTemplateString,{d:this.dateTemplateString});this.dateRowsHtml=[r,r,r,r,r,r].join("");this.dateCells=[];this.dateLabels=[];this.inherited(arguments);dom.setSelectable(this.domNode,false);var _92c=new this.dateClassObj(this.currentFocus);this.monthWidget=this._createMonthWidget();this.set("currentFocus",_92c,false);},postCreate:function(){this.inherited(arguments);this._connectControls();},_connectControls:function(){var _92d=lang.hitch(this,function(_92e,part,_92f){return on(this[_92e],"click",lang.hitch(this,function(){this._setCurrentFocusAttr(this.dateModule.add(this.currentFocus,part,_92f));}));});this.own(_92d("incrementMonth","month",1),_92d("decrementMonth","month",-1),_92d("nextYearLabelNode","year",1),_92d("previousYearLabelNode","year",-1));},_setCurrentFocusAttr:function(date,_930){var _931=this.currentFocus,_932=this._getNodeByDate(_931);date=this._patchDate(date);this._set("currentFocus",date);if(!this._date2cell||this.dateModule.difference(_931,date,"month")!=0){this._populateGrid();this._populateControls();this._markSelectedDates([this.value]);}var _933=this._getNodeByDate(date);_933.setAttribute("tabIndex",this.tabIndex);if(this.focused||_930){_933.focus();}if(_932&&_932!=_933){if(has("webkit")){_932.setAttribute("tabIndex","-1");}else{_932.removeAttribute("tabIndex");}}},focus:function(){this._setCurrentFocusAttr(this.currentFocus,true);},_onDayClick:function(evt){evt.stopPropagation();evt.preventDefault();for(var node=evt.target;node&&!node.dijitDateValue;node=node.parentNode){}if(node&&!_910.contains(node,"dijitCalendarDisabledDate")){this.set("value",node.dijitDateValue);}},_getNodeByDate:function(_934){_934=this._patchDate(_934);return _934&&this._date2cell?this._date2cell[_934.valueOf()]:null;},_markSelectedDates:function(_935){function mark(_936,cell){_910.toggle(cell,"dijitCalendarSelectedDate",_936);cell.setAttribute("aria-selected",_936?"true":"false");};_90b.forEach(this._selectedCells||[],lang.partial(mark,false));this._selectedCells=_90b.filter(_90b.map(_935,this._getNodeByDate,this),function(n){return n;});_90b.forEach(this._selectedCells,lang.partial(mark,true));},onChange:function(){},isDisabledDate:function(){},getClassForDate:function(){}});_915._MonthWidget=_90c("dijit.CalendarLite._MonthWidget",_912,{_setMonthAttr:function(_937){var _938=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_937),_939=(has("ie")==6?"":"<div class='dijitSpacer'>"+_90b.map(_938,function(s){return "<div>"+s+"</div>";}).join("")+"</div>");this.domNode.innerHTML=_939+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_938[_937.getMonth()]+"</div>";}});return _915;});},"dijit/CheckedMenuItem":function(){define(["dojo/_base/declare","dojo/dom-class","./MenuItem","dojo/text!./templates/CheckedMenuItem.html","./hccss"],function(_93a,_93b,_93c,_93d){return _93a("dijit.CheckedMenuItem",_93c,{baseClass:"dijitCheckedMenuItem",templateString:_93d,checked:false,_setCheckedAttr:function(_93e){_93b.toggle(this.domNode,this.baseClass+"Checked",_93e);this.domNode.setAttribute("aria-checked",_93e?"true":"false");this._set("checked",_93e);},iconClass:"",role:"menuitemcheckbox",checkedChar:"&#10003;",onChange:function(){},_onClick:function(evt){if(!this.disabled){this.set("checked",!this.checked);this.onChange(this.checked);}this.onClick(evt);}});});},"dijit/form/VerticalRuleLabels":function(){define(["dojo/_base/declare","./HorizontalRuleLabels"],function(_93f,_940){return _93f("dijit.form.VerticalRuleLabels",_940,{templateString:"<div class=\"dijitRuleContainer dijitRuleContainerV dijitRuleLabelsContainer dijitRuleLabelsContainerV\"></div>",_positionPrefix:"<div class=\"dijitRuleLabelContainer dijitRuleLabelContainerV\" style=\"top:",_labelPrefix:"\"><span class=\"dijitRuleLabel dijitRuleLabelV\">",_calcPosition:function(pos){return 100-pos;},_isHorizontal:false});});},"dijit/Declaration":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/_base/lang","dojo/parser","dojo/query","./_Widget","./_TemplatedMixin","./_WidgetsInTemplateMixin","dojo/NodeList-dom"],function(_941,_942,_943,lang,_944,_945,_946,_947,_948){return _943("dijit.Declaration",_946,{_noScript:true,stopParser:true,widgetClass:"",defaults:null,mixins:[],buildRendering:function(){var src=this.srcNodeRef.parentNode.removeChild(this.srcNodeRef),_949=_945("> script[type='dojo/method']",src).orphan(),_94a=_945("> script[type='dojo/connect']",src).orphan(),_94b=_945("> script[type='dojo/aspect']",src).orphan(),_94c=src.nodeName;var _94d=this.defaults||{};_941.forEach(_949,function(s){var evt=s.getAttribute("event")||s.getAttribute("data-dojo-event"),func=_944._functionFromScript(s,"data-dojo-");if(evt){_94d[evt]=func;}else{_94b.push(s);}});if(this.mixins.length){this.mixins=_941.map(this.mixins,function(name){return lang.getObject(name);});}else{this.mixins=[_946,_947,_948];}_94d._skipNodeCache=true;_94d.templateString="<"+_94c+" class='"+src.className+"'"+" data-dojo-attach-point='"+(src.getAttribute("data-dojo-attach-point")||src.getAttribute("dojoAttachPoint")||"")+"' data-dojo-attach-event='"+(src.getAttribute("data-dojo-attach-event")||src.getAttribute("dojoAttachEvent")||"")+"' >"+src.innerHTML.replace(/\%7B/g,"{").replace(/\%7D/g,"}")+"</"+_94c+">";var wc=_943(this.widgetClass,this.mixins,_94d);_941.forEach(_94b,function(s){var _94e=s.getAttribute("data-dojo-advice")||"after",_94f=s.getAttribute("data-dojo-method")||"postscript",func=_944._functionFromScript(s);_942.after(wc.prototype,_94f,func,true);});_941.forEach(_94a,function(s){var evt=s.getAttribute("event")||s.getAttribute("data-dojo-event"),func=_944._functionFromScript(s);_942.after(wc.prototype,evt,func,true);});}});});},"dijit/MenuSeparator":function(){define(["dojo/_base/declare","dojo/dom","./_WidgetBase","./_TemplatedMixin","./_Contained","dojo/text!./templates/MenuSeparator.html"],function(_950,dom,_951,_952,_953,_954){return _950("dijit.MenuSeparator",[_951,_952,_953],{templateString:_954,buildRendering:function(){this.inherited(arguments);dom.setSelectable(this.domNode,false);},isFocusable:function(){return false;}});});},"dijit/form/_ComboBoxMenu":function(){define(["dojo/_base/declare","dojo/dom-class","dojo/dom-style","dojo/keys","../_WidgetBase","../_TemplatedMixin","./_ComboBoxMenuMixin","./_ListMouseMixin"],function(_955,_956,_957,keys,_958,_959,_95a,_95b){return _955("dijit.form._ComboBoxMenu",[_958,_959,_95b,_95a],{templateString:"<div class='dijitReset dijitMenu' data-dojo-attach-point='containerNode' style='overflow: auto; overflow-x: hidden;' role='listbox'>"+"<div class='dijitMenuItem dijitMenuPreviousButton' data-dojo-attach-point='previousButton' role='option'></div>"+"<div class='dijitMenuItem dijitMenuNextButton' data-dojo-attach-point='nextButton' role='option'></div>"+"</div>",baseClass:"dijitComboBoxMenu",postCreate:function(){this.inherited(arguments);if(!this.isLeftToRight()){_956.add(this.previousButton,"dijitMenuItemRtl");_956.add(this.nextButton,"dijitMenuItemRtl");}this.containerNode.setAttribute("role","listbox");},_createMenuItem:function(){var item=this.ownerDocument.createElement("div");item.className="dijitReset dijitMenuItem"+(this.isLeftToRight()?"":" dijitMenuItemRtl");item.setAttribute("role","option");return item;},onHover:function(node){_956.add(node,"dijitMenuItemHover");},onUnhover:function(node){_956.remove(node,"dijitMenuItemHover");},onSelect:function(node){_956.add(node,"dijitMenuItemSelected");},onDeselect:function(node){_956.remove(node,"dijitMenuItemSelected");},_page:function(up){var _95c=0;var _95d=this.domNode.scrollTop;var _95e=_957.get(this.domNode,"height");if(!this.getHighlightedOption()){this.selectNextNode();}while(_95c<_95e){var _95f=this.getHighlightedOption();if(up){if(!_95f.previousSibling||_95f.previousSibling.style.display=="none"){break;}this.selectPreviousNode();}else{if(!_95f.nextSibling||_95f.nextSibling.style.display=="none"){break;}this.selectNextNode();}var _960=this.domNode.scrollTop;_95c+=(_960-_95d)*(up?-1:1);_95d=_960;}},handleKey:function(evt){switch(evt.keyCode){case keys.DOWN_ARROW:this.selectNextNode();return false;case keys.PAGE_DOWN:this._page(false);return false;case keys.UP_ARROW:this.selectPreviousNode();return false;case keys.PAGE_UP:this._page(true);return false;default:return true;}}});});},"dijit/Dialog":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/declare","dojo/Deferred","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/fx","dojo/i18n","dojo/keys","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/window","dojo/dnd/Moveable","dojo/dnd/TimedMoveable","./focus","./_base/manager","./_Widget","./_TemplatedMixin","./_CssStateMixin","./form/_FormMixin","./_DialogMixin","./DialogUnderlay","./layout/ContentPane","dojo/text!./templates/Dialog.html","dojo/i18n!./nls/common"],function(_961,_962,_963,_964,_965,dom,_966,_967,_968,fx,i18n,keys,lang,on,_969,has,_96a,_96b,_96c,_96d,_96e,_96f,_970,_971,_972,_973,_974,_975,_976){var _977=_964("dijit._DialogBase"+(has("dojo-bidi")?"_NoBidi":""),[_970,_972,_973,_971],{templateString:_976,baseClass:"dijitDialog",cssStateNodes:{closeButtonNode:"dijitDialogCloseIcon"},_setTitleAttr:{node:"titleNode",type:"innerHTML"},open:false,duration:_96e.defaultDuration,refocus:true,autofocus:true,_firstFocusItem:null,_lastFocusItem:null,doLayout:false,draggable:true,_setDraggableAttr:function(val){this._set("draggable",val);},maxRatio:0.9,closable:true,_setClosableAttr:function(val){this.closeButtonNode.style.display=val?"":"none";this._set("closable",val);},postMixInProperties:function(){var _978=i18n.getLocalization("dijit","common");lang.mixin(this,_978);this.inherited(arguments);},postCreate:function(){_968.set(this.domNode,{display:"none",position:"absolute"});this.ownerDocumentBody.appendChild(this.domNode);this.inherited(arguments);_963.after(this,"onExecute",lang.hitch(this,"hide"),true);_963.after(this,"onCancel",lang.hitch(this,"hide"),true);this._modalconnects=[];},onLoad:function(){this._size();this._position();if(this.autofocus&&_979.isTop(this)){this._getFocusItems(this.domNode);_96d.focus(this._firstFocusItem);}this.inherited(arguments);},focus:function(){this._getFocusItems(this.domNode);_96d.focus(this._firstFocusItem);},_endDrag:function(){var _97a=_967.position(this.domNode),_97b=_96a.getBox(this.ownerDocument);_97a.y=Math.min(Math.max(_97a.y,0),(_97b.h-_97a.h));_97a.x=Math.min(Math.max(_97a.x,0),(_97b.w-_97a.w));this._relativePosition=_97a;this._position();},_setup:function(){var node=this.domNode;if(this.titleBar&&this.draggable){this._moveable=new ((has("ie")==6)?_96c:_96b)(node,{handle:this.titleBar});_963.after(this._moveable,"onMoveStop",lang.hitch(this,"_endDrag"),true);}else{_966.add(node,"dijitDialogFixed");}this.underlayAttrs={dialogId:this.id,"class":_962.map(this["class"].split(/\s/),function(s){return s+"_underlay";}).join(" "),_onKeyDown:lang.hitch(this,"_onKey"),ownerDocument:this.ownerDocument};},_size:function(){this._checkIfSingleChild();if(this._singleChild){if(typeof this._singleChildOriginalStyle!="undefined"){this._singleChild.domNode.style.cssText=this._singleChildOriginalStyle;delete this._singleChildOriginalStyle;}}else{_968.set(this.containerNode,{width:"auto",height:"auto"});}var bb=_967.position(this.domNode);var _97c=_96a.getBox(this.ownerDocument);_97c.w*=this.maxRatio;_97c.h*=this.maxRatio;if(bb.w>=_97c.w||bb.h>=_97c.h){var _97d=_967.position(this.containerNode),w=Math.min(bb.w,_97c.w)-(bb.w-_97d.w),h=Math.min(bb.h,_97c.h)-(bb.h-_97d.h);if(this._singleChild&&this._singleChild.resize){if(typeof this._singleChildOriginalStyle=="undefined"){this._singleChildOriginalStyle=this._singleChild.domNode.style.cssText;}this._singleChild.resize({w:w,h:h});}else{_968.set(this.containerNode,{width:w+"px",height:h+"px",overflow:"auto",position:"relative"});}}else{if(this._singleChild&&this._singleChild.resize){this._singleChild.resize();}}},_position:function(){if(!_966.contains(this.ownerDocumentBody,"dojoMove")){var node=this.domNode,_97e=_96a.getBox(this.ownerDocument),p=this._relativePosition,bb=p?null:_967.position(node),l=Math.floor(_97e.l+(p?p.x:(_97e.w-bb.w)/2)),t=Math.floor(_97e.t+(p?p.y:(_97e.h-bb.h)/2));_968.set(node,{left:l+"px",top:t+"px"});}},_onKey:function(evt){if(evt.keyCode==keys.TAB){this._getFocusItems(this.domNode);var node=evt.target;if(this._firstFocusItem==this._lastFocusItem){evt.stopPropagation();evt.preventDefault();}else{if(node==this._firstFocusItem&&evt.shiftKey){_96d.focus(this._lastFocusItem);evt.stopPropagation();evt.preventDefault();}else{if(node==this._lastFocusItem&&!evt.shiftKey){_96d.focus(this._firstFocusItem);evt.stopPropagation();evt.preventDefault();}}}}else{if(this.closable&&evt.keyCode==keys.ESCAPE){this.onCancel();evt.stopPropagation();evt.preventDefault();}}},show:function(){if(this.open){return;}if(!this._started){this.startup();}if(!this._alreadyInitialized){this._setup();this._alreadyInitialized=true;}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();_979.hide(this);}var win=_96a.get(this.ownerDocument);this._modalconnects.push(on(win,"scroll",lang.hitch(this,"resize")));this._modalconnects.push(on(this.domNode,"keydown",lang.hitch(this,"_onKey")));_968.set(this.domNode,{opacity:0,display:""});this._set("open",true);this._onShow();this._size();this._position();var _97f;this._fadeInDeferred=new _965(lang.hitch(this,function(){_97f.stop();delete this._fadeInDeferred;}));var _980=this._fadeInDeferred.promise;_97f=fx.fadeIn({node:this.domNode,duration:this.duration,beforeBegin:lang.hitch(this,function(){_979.show(this,this.underlayAttrs);}),onEnd:lang.hitch(this,function(){if(this.autofocus&&_979.isTop(this)){this._getFocusItems(this.domNode);_96d.focus(this._firstFocusItem);}this._fadeInDeferred.resolve(true);delete this._fadeInDeferred;})}).play();return _980;},hide:function(){if(!this._alreadyInitialized||!this.open){return;}if(this._fadeInDeferred){this._fadeInDeferred.cancel();}var _981;this._fadeOutDeferred=new _965(lang.hitch(this,function(){_981.stop();delete this._fadeOutDeferred;}));this._fadeOutDeferred.then(lang.hitch(this,"onHide"));var _982=this._fadeOutDeferred.promise;_981=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,function(){this.domNode.style.display="none";_979.hide(this);this._fadeOutDeferred.resolve(true);delete this._fadeOutDeferred;})}).play();if(this._scrollConnected){this._scrollConnected=false;}var h;while(h=this._modalconnects.pop()){h.remove();}if(this._relativePosition){delete this._relativePosition;}this._set("open",false);return _982;},resize:function(){if(this.domNode.style.display!="none"){this._size();if(!has("touch")){this._position();}}},destroy:function(){if(this._fadeInDeferred){this._fadeInDeferred.cancel();}if(this._fadeOutDeferred){this._fadeOutDeferred.cancel();}if(this._moveable){this._moveable.destroy();}var h;while(h=this._modalconnects.pop()){h.remove();}_979.hide(this);this.inherited(arguments);}});if(has("dojo-bidi")){_977=_964("dijit._DialogBase",_977,{_setTitleAttr:function(_983){this._set("title",_983);this.titleNode.innerHTML=_983;this.applyTextDir(this.titleNode);},_setTextDirAttr:function(_984){if(this._created&&this.textDir!=_984){this._set("textDir",_984);this.set("title",this.title);}}});}var _985=_964("dijit.Dialog",[_975,_977],{});_985._DialogBase=_977;var _979=_985._DialogLevelManager={_beginZIndex:950,show:function(_986,_987){ds[ds.length-1].focus=_96d.curNode;var _988=ds[ds.length-1].dialog?ds[ds.length-1].zIndex+2:_985._DialogLevelManager._beginZIndex;_968.set(_986.domNode,"zIndex",_988);_974.show(_987,_988-1);ds.push({dialog:_986,underlayAttrs:_987,zIndex:_988});},hide:function(_989){if(ds[ds.length-1].dialog==_989){ds.pop();var pd=ds[ds.length-1];if(ds.length==1){_974.hide();}else{_974.show(pd.underlayAttrs,pd.zIndex-1);}if(_989.refocus){var _98a=pd.focus;if(pd.dialog&&(!_98a||!dom.isDescendant(_98a,pd.dialog.domNode))){pd.dialog._getFocusItems(pd.dialog.domNode);_98a=pd.dialog._firstFocusItem;}if(_98a){try{_98a.focus();}catch(e){}}}}else{var idx=_962.indexOf(_962.map(ds,function(elem){return elem.dialog;}),_989);if(idx!=-1){ds.splice(idx,1);}}},isTop:function(_98b){return ds[ds.length-1].dialog==_98b;}};var ds=_985._dialogStack=[{dialog:null,focus:null,underlayAttrs:null}];_96d.watch("curNode",function(attr,_98c,node){var _98d=ds[ds.length-1].dialog;if(node&&_98d){do{if(node==_98d.domNode||_966.contains(node,"dijitPopup")){return;}}while(node=node.parentNode);_98d.focus();}});if(has("dijit-legacy-requires")){_969(0,function(){var _98e=["dijit/TooltipDialog"];_961(_98e);});}return _985;});},"dijit/form/MultiSelect":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dom-geometry","dojo/has","dojo/query","./_FormValueWidget"],function(_98f,_990,_991,has,_992,_993){var _994=_990("dijit.form.MultiSelect"+(has("dojo-bidi")?"_NoBidi":""),_993,{size:7,baseClass:"dijitMultiSelect",templateString:"<select multiple='true' ${!nameAttrSetting} data-dojo-attach-point='containerNode,focusNode' data-dojo-attach-event='onchange: _onChange'></select>",addSelected:function(_995){_995.getSelected().forEach(function(n){this.containerNode.appendChild(n);this.domNode.scrollTop=this.domNode.offsetHeight;var _996=_995.domNode.scrollTop;_995.domNode.scrollTop=0;_995.domNode.scrollTop=_996;},this);this._set("value",this.get("value"));},getSelected:function(){return _992("option",this.containerNode).filter(function(n){return n.selected;});},_getValueAttr:function(){return _98f.map(this.getSelected(),function(n){return n.value;});},multiple:true,_setValueAttr:function(_997,_998){_992("option",this.containerNode).forEach(function(n){n.selected=(_98f.indexOf(_997,n.value)!=-1);});this.inherited(arguments);},invertSelection:function(_999){var val=[];_992("option",this.containerNode).forEach(function(n){if(!n.selected){val.push(n.value);}});this._setValueAttr(val,!(_999===false||_999==null));},_onChange:function(){this._handleOnChange(this.get("value"),true);},resize:function(size){if(size){_991.setMarginBox(this.domNode,size);}},postCreate:function(){this._set("value",this.get("value"));this.inherited(arguments);}});if(has("dojo-bidi")){_994=_990("dijit.form.MultiSelect",_994,{addSelected:function(_99a){_99a.getSelected().forEach(function(n){n.text=this.enforceTextDirWithUcc(this.restoreOriginalText(n),n.text);},this);this.inherited(arguments);},_setTextDirAttr:function(_99b){if((this.textDir!=_99b||!this._created)&&this.enforceTextDirWithUcc){this._set("textDir",_99b);_992("option",this.containerNode).forEach(function(_99c){if(!this._created&&_99c.value===_99c.text){_99c.value=_99c.text;}_99c.text=this.enforceTextDirWithUcc(_99c,_99c.originalText||_99c.text);},this);}}});}return _994;});},"dijit/form/_DateTimeTextBox":function(){define(["dojo/date","dojo/date/locale","dojo/date/stamp","dojo/_base/declare","dojo/_base/lang","./RangeBoundTextBox","../_HasDropDown","dojo/text!./templates/DropDownBox.html"],function(date,_99d,_99e,_99f,lang,_9a0,_9a1,_9a2){new Date("X");var _9a3=_99f("dijit.form._DateTimeTextBox",[_9a0,_9a1],{templateString:_9a2,hasDownArrow:true,cssStateNodes:{"_buttonNode":"dijitDownArrowButton"},pattern:_99d.regexp,datePackage:"",postMixInProperties:function(){this.inherited(arguments);this._set("type","text");},compare:function(val1,val2){var _9a4=this._isInvalidDate(val1);var _9a5=this._isInvalidDate(val2);return _9a4?(_9a5?0:-1):(_9a5?1:date.compare(val1,val2,this._selector));},autoWidth:true,format:function(_9a6,_9a7){if(!_9a6){return "";}return this.dateLocaleModule.format(_9a6,_9a7);},"parse":function(_9a8,_9a9){return this.dateLocaleModule.parse(_9a8,_9a9)||(this._isEmpty(_9a8)?null:undefined);},serialize:function(val,_9aa){if(val.toGregorian){val=val.toGregorian();}return _99e.toISOString(val,_9aa);},dropDownDefaultValue:new Date(),value:new Date(""),_blankValue:null,popupClass:"",_selector:"",constructor:function(_9ab){this.dateModule=_9ab.datePackage?lang.getObject(_9ab.datePackage,false):date;this.dateClassObj=this.dateModule.Date||Date;this.dateLocaleModule=_9ab.datePackage?lang.getObject(_9ab.datePackage+".locale",false):_99d;this._set("pattern",this.dateLocaleModule.regexp);this._invalidDate=this.constructor.prototype.value.toString();},buildRendering:function(){this.inherited(arguments);if(!this.hasDownArrow){this._buttonNode.style.display="none";}if(!this.hasDownArrow){this._buttonNode=this.domNode;this.baseClass+=" dijitComboBoxOpenOnClick";}},_setConstraintsAttr:function(_9ac){_9ac.selector=this._selector;_9ac.fullYear=true;var _9ad=_99e.fromISOString;if(typeof _9ac.min=="string"){_9ac.min=_9ad(_9ac.min);}if(typeof _9ac.max=="string"){_9ac.max=_9ad(_9ac.max);}this.inherited(arguments);},_isInvalidDate:function(_9ae){return !_9ae||isNaN(_9ae)||typeof _9ae!="object"||_9ae.toString()==this._invalidDate;},_setValueAttr:function(_9af,_9b0,_9b1){if(_9af!==undefined){if(typeof _9af=="string"){_9af=_99e.fromISOString(_9af);}if(this._isInvalidDate(_9af)){_9af=null;}if(_9af instanceof Date&&!(this.dateClassObj instanceof Date)){_9af=new this.dateClassObj(_9af);}}this.inherited(arguments);if(this.value instanceof Date){this.filterString="";}if(this.dropDown){this.dropDown.set("value",_9af,false);}},_set:function(attr,_9b2){var _9b3=this._get("value");if(attr=="value"&&_9b3 instanceof Date&&this.compare(_9b2,_9b3)==0){return;}this.inherited(arguments);},_setDropDownDefaultValueAttr:function(val){if(this._isInvalidDate(val)){val=new this.dateClassObj();}this._set("dropDownDefaultValue",val);},openDropDown:function(_9b4){if(this.dropDown){this.dropDown.destroy();}var _9b5=lang.isString(this.popupClass)?lang.getObject(this.popupClass,false):this.popupClass,_9b6=this,_9b7=this.get("value");this.dropDown=new _9b5({onChange:function(_9b8){_9b6.set("value",_9b8,true);},id:this.id+"_popup",dir:_9b6.dir,lang:_9b6.lang,value:_9b7,textDir:_9b6.textDir,currentFocus:!this._isInvalidDate(_9b7)?_9b7:this.dropDownDefaultValue,constraints:_9b6.constraints,filterString:_9b6.filterString,datePackage:_9b6.params.datePackage,isDisabledDate:function(date){return !_9b6.rangeCheck(date,_9b6.constraints);}});this.inherited(arguments);},_getDisplayedValueAttr:function(){return this.textbox.value;},_setDisplayedValueAttr:function(_9b9,_9ba){this._setValueAttr(this.parse(_9b9,this.constraints),_9ba,_9b9);}});return _9a3;});},"dijit/form/_ToggleButtonMixin":function(){define(["dojo/_base/declare","dojo/dom-attr"],function(_9bb,_9bc){return _9bb("dijit.form._ToggleButtonMixin",null,{checked:false,_aria_attr:"aria-pressed",_onClick:function(evt){var _9bd=this.checked;this._set("checked",!_9bd);var ret=this.inherited(arguments);this.set("checked",ret?this.checked:_9bd);return ret;},_setCheckedAttr:function(_9be,_9bf){this._set("checked",_9be);var node=this.focusNode||this.domNode;if(this._created){if(_9bc.get(node,"checked")!=!!_9be){_9bc.set(node,"checked",!!_9be);}}node.setAttribute(this._aria_attr,String(_9be));this._handleOnChange(_9be,_9bf);},postCreate:function(){this.inherited(arguments);var node=this.focusNode||this.domNode;if(this.checked){node.setAttribute("checked","checked");}},reset:function(){this._hasBeenBlurred=false;this.set("checked",this.params.checked||false);}});});},"dijit/Calendar":function(){define(["dojo/_base/array","dojo/date","dojo/date/locale","dojo/_base/declare","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","./CalendarLite","./_Widget","./_CssStateMixin","./_TemplatedMixin","./form/DropDownButton"],function(_9c0,date,_9c1,_9c2,_9c3,_9c4,_9c5,keys,lang,on,has,_9c6,_9c7,_9c8,_9c9,_9ca){var _9cb=_9c2("dijit.Calendar",[_9c6,_9c7,_9c8],{cssStateNodes:{"decrementMonth":"dijitCalendarArrow","incrementMonth":"dijitCalendarArrow","previousYearLabelNode":"dijitCalendarPreviousYear","nextYearLabelNode":"dijitCalendarNextYear"},setValue:function(_9cc){_9c5.deprecated("dijit.Calendar:setValue() is deprecated.  Use set('value', ...) instead.","","2.0");this.set("value",_9cc);},_createMonthWidget:function(){return new _9cb._MonthDropDownButton({id:this.id+"_mddb",tabIndex:-1,onMonthSelect:lang.hitch(this,"_onMonthSelect"),lang:this.lang,dateLocaleModule:this.dateLocaleModule},this.monthNode);},postCreate:function(){this.inherited(arguments);this.own(on(this.domNode,"keydown",lang.hitch(this,"_onKeyDown")),on(this.dateRowsNode,"mouseover",lang.hitch(this,"_onDayMouseOver")),on(this.dateRowsNode,"mouseout",lang.hitch(this,"_onDayMouseOut")),on(this.dateRowsNode,"mousedown",lang.hitch(this,"_onDayMouseDown")),on(this.dateRowsNode,"mouseup",lang.hitch(this,"_onDayMouseUp")));},_onMonthSelect:function(_9cd){var date=new this.dateClassObj(this.currentFocus);date.setDate(1);date.setMonth(_9cd);var _9ce=this.dateModule.getDaysInMonth(date);var _9cf=this.currentFocus.getDate();date.setDate(Math.min(_9cf,_9ce));this._setCurrentFocusAttr(date);},_onDayMouseOver:function(evt){var node=_9c4.contains(evt.target,"dijitCalendarDateLabel")?evt.target.parentNode:evt.target;if(node&&((node.dijitDateValue&&!_9c4.contains(node,"dijitCalendarDisabledDate"))||node==this.previousYearLabelNode||node==this.nextYearLabelNode)){_9c4.add(node,"dijitCalendarHoveredDate");this._currentNode=node;}},_onDayMouseOut:function(evt){if(!this._currentNode){return;}if(evt.relatedTarget&&evt.relatedTarget.parentNode==this._currentNode){return;}var cls="dijitCalendarHoveredDate";if(_9c4.contains(this._currentNode,"dijitCalendarActiveDate")){cls+=" dijitCalendarActiveDate";}_9c4.remove(this._currentNode,cls);this._currentNode=null;},_onDayMouseDown:function(evt){var node=evt.target.parentNode;if(node&&node.dijitDateValue&&!_9c4.contains(node,"dijitCalendarDisabledDate")){_9c4.add(node,"dijitCalendarActiveDate");this._currentNode=node;}},_onDayMouseUp:function(evt){var node=evt.target.parentNode;if(node&&node.dijitDateValue){_9c4.remove(node,"dijitCalendarActiveDate");}},handleKey:function(evt){var _9d0=-1,_9d1,_9d2=this.currentFocus;switch(evt.keyCode){case keys.RIGHT_ARROW:_9d0=1;case keys.LEFT_ARROW:_9d1="day";if(!this.isLeftToRight()){_9d0*=-1;}break;case keys.DOWN_ARROW:_9d0=1;case keys.UP_ARROW:_9d1="week";break;case keys.PAGE_DOWN:_9d0=1;case keys.PAGE_UP:_9d1=evt.ctrlKey||evt.altKey?"year":"month";break;case keys.END:_9d2=this.dateModule.add(_9d2,"month",1);_9d1="day";case keys.HOME:_9d2=new this.dateClassObj(_9d2);_9d2.setDate(1);break;default:return true;}if(_9d1){_9d2=this.dateModule.add(_9d2,_9d1,_9d0);}this._setCurrentFocusAttr(_9d2);return false;},_onKeyDown:function(evt){if(!this.handleKey(evt)){evt.stopPropagation();evt.preventDefault();}},onValueSelected:function(){},onChange:function(_9d3){this.onValueSelected(_9d3);},getClassForDate:function(){}});_9cb._MonthDropDownButton=_9c2("dijit.Calendar._MonthDropDownButton",_9ca,{onMonthSelect:function(){},postCreate:function(){this.inherited(arguments);this.dropDown=new _9cb._MonthDropDown({id:this.id+"_mdd",onChange:this.onMonthSelect});},_setMonthAttr:function(_9d4){var _9d5=this.dateLocaleModule.getNames("months","wide","standAlone",this.lang,_9d4);this.dropDown.set("months",_9d5);this.containerNode.innerHTML=(has("ie")==6?"":"<div class='dijitSpacer'>"+this.dropDown.domNode.innerHTML+"</div>")+"<div class='dijitCalendarMonthLabel dijitCalendarCurrentMonthLabel'>"+_9d5[_9d4.getMonth()]+"</div>";}});_9cb._MonthDropDown=_9c2("dijit.Calendar._MonthDropDown",[_9c7,_9c9],{months:[],templateString:"<div class='dijitCalendarMonthMenu dijitMenu' "+"data-dojo-attach-event='onclick:_onClick,onmouseover:_onMenuHover,onmouseout:_onMenuHover'></div>",_setMonthsAttr:function(_9d6){this.domNode.innerHTML=_9c0.map(_9d6,function(_9d7,idx){return _9d7?"<div class='dijitCalendarMonthLabel' month='"+idx+"'>"+_9d7+"</div>":"";}).join("");},_onClick:function(evt){this.onChange(_9c3.get(evt.target,"month"));},onChange:function(){},_onMenuHover:function(evt){_9c4.toggle(evt.target,"dijitCalendarMonthLabelHover",evt.type=="mouseover");}});return _9cb;});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./aspect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_9d8,dojo,_9d9,_9da,_9db,dom,_9dc,geom,_9dd,_9de){if(!dojo.isAsync){_9dd(0,function(){var _9df=["./fx/Toggler"];_9de(_9df);});}var _9e0=dojo.fx={};var _9e1={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _9e2=function(_9e3){this._index=-1;this._animations=_9e3||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_9d9.forEach(this._animations,function(a){this.duration+=a.duration;if(a.delay){this.duration+=a.delay;}},this);};_9e2.prototype=new _9d8();lang.extend(_9e2,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){this._onAnimateCtx.remove();this._onEndCtx.remove();this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_9da.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);this._onEndCtx=_9da.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play(0,true);}},play:function(_9e4,_9e5){if(!this._current){this._current=this._animations[this._index=0];}if(!_9e5&&this._current.status()=="playing"){return this;}var _9e6=_9da.after(this._current,"beforeBegin",lang.hitch(this,function(){this._fire("beforeBegin");}),true),_9e7=_9da.after(this._current,"onBegin",lang.hitch(this,function(arg){this._fire("onBegin",arguments);}),true),_9e8=_9da.after(this._current,"onPlay",lang.hitch(this,function(arg){this._fire("onPlay",arguments);_9e6.remove();_9e7.remove();_9e8.remove();}));if(this._onAnimateCtx){this._onAnimateCtx.remove();}this._onAnimateCtx=_9da.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);if(this._onEndCtx){this._onEndCtx.remove();}this._onEndCtx=_9da.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_9da.after(this._current,"onPause",lang.hitch(this,function(arg){this._fire("onPause",arguments);e.remove();}),true);this._current.pause();}return this;},gotoPercent:function(_9e9,_9ea){this.pause();var _9eb=this.duration*_9e9;this._current=null;_9d9.some(this._animations,function(a){if(a.duration<=_9eb){this._current=a;return true;}_9eb-=a.duration;return false;});if(this._current){this._current.gotoPercent(_9eb/this._current.duration,_9ea);}return this;},stop:function(_9ec){if(this._current){if(_9ec){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_9da.after(this._current,"onStop",lang.hitch(this,function(arg){this._fire("onStop",arguments);e.remove();}),true);this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){if(this._onAnimateCtx){this._onAnimateCtx.remove();}if(this._onEndCtx){this._onEndCtx.remove();}}});lang.extend(_9e2,_9e1);_9e0.chain=function(_9ed){return new _9e2(_9ed);};var _9ee=function(_9ef){this._animations=_9ef||[];this._connects=[];this._finished=0;this.duration=0;_9d9.forEach(_9ef,function(a){var _9f0=a.duration;if(a.delay){_9f0+=a.delay;}if(this.duration<_9f0){this.duration=_9f0;}this._connects.push(_9da.after(a,"onEnd",lang.hitch(this,"_onEnd"),true));},this);this._pseudoAnimation=new _9db.Animation({curve:[0,1],duration:this.duration});var self=this;_9d9.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_9da.after(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);},true));});};lang.extend(_9ee,{_doAction:function(_9f1,args){_9d9.forEach(this._animations,function(a){a[_9f1].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_9f2,args){var t=this._pseudoAnimation;t[_9f2].apply(t,args);},play:function(_9f3,_9f4){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_9f5,_9f6){var ms=this.duration*_9f5;_9d9.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_9f6);});this._call("gotoPercent",arguments);return this;},stop:function(_9f7){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){_9d9.forEach(this._connects,function(_9f8){_9f8.remove();});}});lang.extend(_9ee,_9e1);_9e0.combine=function(_9f9){return new _9ee(_9f9);};_9e0.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_9db.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _9fa=_9dc.get(node,"height");return Math.max(_9fa,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_9da.after(anim,"onStop",fini,true);_9da.after(anim,"onEnd",fini,true);return anim;};_9e0.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_9db.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_9da.after(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";},true);var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_9da.after(anim,"onStop",fini,true);_9da.after(anim,"onEnd",fini,true);return anim;};_9e0.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_9dc.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_9db.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_9da.after(anim,"beforeBegin",init,true);return anim;};return _9e0;});},"dijit/_DialogMixin":function(){define(["dojo/_base/declare","./a11y"],function(_9fb,a11y){return _9fb("dijit._DialogMixin",null,{execute:function(){},onCancel:function(){},onExecute:function(){},_onSubmit:function(){this.onExecute();this.execute(this.get("value"));},_getFocusItems:function(){var _9fc=a11y._getTabNavigable(this.containerNode);this._firstFocusItem=_9fc.lowest||_9fc.first||this.closeButtonNode||this.domNode;this._lastFocusItem=_9fc.last||_9fc.highest||this._firstFocusItem;}});});},"dijit/Tree":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/connect","dojo/cookie","dojo/_base/declare","dojo/Deferred","dojo/promise/all","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/errors/create","dojo/fx","dojo/has","dojo/_base/kernel","dojo/keys","dojo/_base/lang","dojo/on","dojo/topic","dojo/touch","dojo/when","./a11yclick","./focus","./registry","./_base/manager","./_Widget","./_TemplatedMixin","./_Container","./_Contained","./_CssStateMixin","./_KeyNavMixin","dojo/text!./templates/TreeNode.html","dojo/text!./templates/Tree.html","./tree/TreeStoreModel","./tree/ForestStoreModel","./tree/_dndSelector","dojo/query!css2"],function(_9fd,_9fe,_9ff,_a00,_a01,_a02,all,dom,_a03,_a04,_a05,_a06,_a07,has,_a08,keys,lang,on,_a09,_a0a,when,_a0b,_a0c,_a0d,_a0e,_a0f,_a10,_a11,_a12,_a13,_a14,_a15,_a16,_a17,_a18,_a19){function _a1a(d){return lang.delegate(d.promise||d,{addCallback:function(_a1b){this.then(_a1b);},addErrback:function(_a1c){this.otherwise(_a1c);}});};var _a1d=_a01("dijit._TreeNode",[_a0f,_a10,_a11,_a12,_a13],{item:null,isTreeNode:true,label:"",_setLabelAttr:function(val){this.labelNode[this.labelType=="html"?"innerHTML":"innerText" in this.labelNode?"innerText":"textContent"]=val;this._set("label",val);},labelType:"text",isExpandable:null,isExpanded:false,state:"NotLoaded",templateString:_a15,baseClass:"dijitTreeNode",cssStateNodes:{rowNode:"dijitTreeRow"},_setTooltipAttr:{node:"rowNode",type:"attribute",attribute:"title"},buildRendering:function(){this.inherited(arguments);this._setExpando();this._updateItemClasses(this.item);if(this.isExpandable){this.labelNode.setAttribute("aria-expanded",this.isExpanded);}this.setSelected(false);},_setIndentAttr:function(_a1e){var _a1f=(Math.max(_a1e,0)*this.tree._nodePixelIndent)+"px";_a05.set(this.domNode,"backgroundPosition",_a1f+" 0px");_a05.set(this.rowNode,this.isLeftToRight()?"paddingLeft":"paddingRight",_a1f);_9fd.forEach(this.getChildren(),function(_a20){_a20.set("indent",_a1e+1);});this._set("indent",_a1e);},markProcessing:function(){this.state="Loading";this._setExpando(true);},unmarkProcessing:function(){this._setExpando(false);},_updateItemClasses:function(item){var tree=this.tree,_a21=tree.model;if(tree._v10Compat&&item===_a21.root){item=null;}this._applyClassAndStyle(item,"icon","Icon");this._applyClassAndStyle(item,"label","Label");this._applyClassAndStyle(item,"row","Row");this.tree._startPaint(true);},_applyClassAndStyle:function(item,_a22,_a23){var _a24="_"+_a22+"Class";var _a25=_a22+"Node";var _a26=this[_a24];this[_a24]=this.tree["get"+_a23+"Class"](item,this.isExpanded);_a03.replace(this[_a25],this[_a24]||"",_a26||"");_a05.set(this[_a25],this.tree["get"+_a23+"Style"](item,this.isExpanded)||{});},_updateLayout:function(){var _a27=this.getParent();if(!_a27||!_a27.rowNode||_a27.rowNode.style.display=="none"){_a03.add(this.domNode,"dijitTreeIsRoot");}else{_a03.toggle(this.domNode,"dijitTreeIsLast",!this.getNextSibling());}},_setExpando:function(_a28){var _a29=["dijitTreeExpandoLoading","dijitTreeExpandoOpened","dijitTreeExpandoClosed","dijitTreeExpandoLeaf"],_a2a=["*","-","+","*"],idx=_a28?0:(this.isExpandable?(this.isExpanded?1:2):3);_a03.replace(this.expandoNode,_a29[idx],_a29);this.expandoNodeText.innerHTML=_a2a[idx];},expand:function(){if(this._expandDeferred){return _a1a(this._expandDeferred);}if(this._collapseDeferred){this._collapseDeferred.cancel();delete this._collapseDeferred;}this.isExpanded=true;this.labelNode.setAttribute("aria-expanded","true");if(this.tree.showRoot||this!==this.tree.rootNode){this.containerNode.setAttribute("role","group");}_a03.add(this.contentNode,"dijitTreeContentExpanded");this._setExpando();this._updateItemClasses(this.item);if(this==this.tree.rootNode&&this.tree.showRoot){this.tree.domNode.setAttribute("aria-expanded","true");}var _a2b=_a07.wipeIn({node:this.containerNode,duration:_a0e.defaultDuration});var def=(this._expandDeferred=new _a02(function(){_a2b.stop();}));_9fe.after(_a2b,"onEnd",function(){def.resolve(true);},true);_a2b.play();return _a1a(def);},collapse:function(){if(this._collapseDeferred){return _a1a(this._collapseDeferred);}if(this._expandDeferred){this._expandDeferred.cancel();delete this._expandDeferred;}this.isExpanded=false;this.labelNode.setAttribute("aria-expanded","false");if(this==this.tree.rootNode&&this.tree.showRoot){this.tree.domNode.setAttribute("aria-expanded","false");}_a03.remove(this.contentNode,"dijitTreeContentExpanded");this._setExpando();this._updateItemClasses(this.item);var _a2c=_a07.wipeOut({node:this.containerNode,duration:_a0e.defaultDuration});var def=(this._collapseDeferred=new _a02(function(){_a2c.stop();}));_9fe.after(_a2c,"onEnd",function(){def.resolve(true);},true);_a2c.play();return _a1a(def);},indent:0,setChildItems:function(_a2d){var tree=this.tree,_a2e=tree.model,defs=[];var _a2f=this.getChildren();_9fd.forEach(_a2f,function(_a30){_a11.prototype.removeChild.call(this,_a30);},this);this.defer(function(){_9fd.forEach(_a2f,function(node){if(!node._destroyed&&!node.getParent()){tree.dndController.removeTreeNode(node);function _a31(node){var id=_a2e.getIdentity(node.item),ary=tree._itemNodesMap[id];if(ary.length==1){delete tree._itemNodesMap[id];}else{var _a32=_9fd.indexOf(ary,node);if(_a32!=-1){ary.splice(_a32,1);}}_9fd.forEach(node.getChildren(),_a31);};_a31(node);if(tree.persist){var _a33=_9fd.map(node.getTreePath(),function(item){return tree.model.getIdentity(item);}).join("/");for(var path in tree._openedNodes){if(path.substr(0,_a33.length)==_a33){delete tree._openedNodes[path];}}tree._saveExpandedNodes();}node.destroyRecursive();}});});this.state="Loaded";if(_a2d&&_a2d.length>0){this.isExpandable=true;_9fd.forEach(_a2d,function(item){var id=_a2e.getIdentity(item),_a34=tree._itemNodesMap[id],node;if(_a34){for(var i=0;i<_a34.length;i++){if(_a34[i]&&!_a34[i].getParent()){node=_a34[i];node.set("indent",this.indent+1);break;}}}if(!node){node=this.tree._createTreeNode({item:item,tree:tree,isExpandable:_a2e.mayHaveChildren(item),label:tree.getLabel(item),labelType:(tree.model&&tree.model.labelType)||"text",tooltip:tree.getTooltip(item),ownerDocument:tree.ownerDocument,dir:tree.dir,lang:tree.lang,textDir:tree.textDir,indent:this.indent+1});if(_a34){_a34.push(node);}else{tree._itemNodesMap[id]=[node];}}this.addChild(node);if(this.tree.autoExpand||this.tree._state(node)){defs.push(tree._expandNode(node));}},this);_9fd.forEach(this.getChildren(),function(_a35){_a35._updateLayout();});}else{this.isExpandable=false;}if(this._setExpando){this._setExpando(false);}this._updateItemClasses(this.item);var def=all(defs);this.tree._startPaint(def);return _a1a(def);},getTreePath:function(){var node=this;var path=[];while(node&&node!==this.tree.rootNode){path.unshift(node.item);node=node.getParent();}path.unshift(this.tree.rootNode.item);return path;},getIdentity:function(){return this.tree.model.getIdentity(this.item);},removeChild:function(node){this.inherited(arguments);var _a36=this.getChildren();if(_a36.length==0){this.isExpandable=false;this.collapse();}_9fd.forEach(_a36,function(_a37){_a37._updateLayout();});},makeExpandable:function(){this.isExpandable=true;this._setExpando(false);},setSelected:function(_a38){this.labelNode.setAttribute("aria-selected",_a38?"true":"false");_a03.toggle(this.rowNode,"dijitTreeRowSelected",_a38);},focus:function(){_a0c.focus(this.focusNode);}});if(has("dojo-bidi")){_a1d.extend({_setTextDirAttr:function(_a39){if(_a39&&((this.textDir!=_a39)||!this._created)){this._set("textDir",_a39);this.applyTextDir(this.labelNode);_9fd.forEach(this.getChildren(),function(_a3a){_a3a.set("textDir",_a39);},this);}}});}var Tree=_a01("dijit.Tree",[_a0f,_a14,_a10,_a13],{baseClass:"dijitTree",store:null,model:null,query:null,label:"",showRoot:true,childrenAttr:["children"],paths:[],path:[],selectedItems:null,selectedItem:null,openOnClick:false,openOnDblClick:false,templateString:_a16,persist:false,autoExpand:false,dndController:_a19,dndParams:["onDndDrop","itemCreator","onDndCancel","checkAcceptance","checkItemAcceptance","dragThreshold","betweenThreshold"],onDndDrop:null,itemCreator:null,onDndCancel:null,checkAcceptance:null,checkItemAcceptance:null,dragThreshold:5,betweenThreshold:0,_nodePixelIndent:19,_publish:function(_a3b,_a3c){_a09.publish(this.id,lang.mixin({tree:this,event:_a3b},_a3c||{}));},postMixInProperties:function(){this.tree=this;if(this.autoExpand){this.persist=false;}this._itemNodesMap={};if(!this.cookieName&&this.id){this.cookieName=this.id+"SaveStateCookie";}this.expandChildrenDeferred=new _a02();this.pendingCommandsPromise=this.expandChildrenDeferred.promise;this.inherited(arguments);},postCreate:function(){this._initState();var self=this;this.own(on(this.containerNode,on.selector(".dijitTreeNode",_a0a.enter),function(evt){self._onNodeMouseEnter(_a0d.byNode(this),evt);}),on(this.containerNode,on.selector(".dijitTreeNode",_a0a.leave),function(evt){self._onNodeMouseLeave(_a0d.byNode(this),evt);}),on(this.containerNode,_a0b,function(evt){var node=_a0d.getEnclosingWidget(evt.target);if(node.isInstanceOf(_a1d)){self._onClick(node,evt);}}),on(this.containerNode,on.selector(".dijitTreeNode","dblclick"),function(evt){self._onDblClick(_a0d.byNode(this),evt);}));if(!this.model){this._store2model();}this.own(_9fe.after(this.model,"onChange",lang.hitch(this,"_onItemChange"),true),_9fe.after(this.model,"onChildrenChange",lang.hitch(this,"_onItemChildrenChange"),true),_9fe.after(this.model,"onDelete",lang.hitch(this,"_onItemDelete"),true));this.inherited(arguments);if(this.dndController){if(lang.isString(this.dndController)){this.dndController=lang.getObject(this.dndController);}var _a3d={};for(var i=0;i<this.dndParams.length;i++){if(this[this.dndParams[i]]){_a3d[this.dndParams[i]]=this[this.dndParams[i]];}}this.dndController=new this.dndController(this,_a3d);}this._load();this.onLoadDeferred=_a1a(this.pendingCommandsPromise);this.onLoadDeferred.then(lang.hitch(this,"onLoad"));},_store2model:function(){this._v10Compat=true;_a08.deprecated("Tree: from version 2.0, should specify a model object rather than a store/query");var _a3e={id:this.id+"_ForestStoreModel",store:this.store,query:this.query,childrenAttrs:this.childrenAttr};if(this.params.mayHaveChildren){_a3e.mayHaveChildren=lang.hitch(this,"mayHaveChildren");}if(this.params.getItemChildren){_a3e.getChildren=lang.hitch(this,function(item,_a3f,_a40){this.getItemChildren((this._v10Compat&&item===this.model.root)?null:item,_a3f,_a40);});}this.model=new _a18(_a3e);this.showRoot=Boolean(this.label);},onLoad:function(){},_load:function(){this.model.getRoot(lang.hitch(this,function(item){var rn=(this.rootNode=this.tree._createTreeNode({item:item,tree:this,isExpandable:true,label:this.label||this.getLabel(item),labelType:this.model.labelType||"text",textDir:this.textDir,indent:this.showRoot?0:-1}));if(!this.showRoot){rn.rowNode.style.display="none";this.domNode.setAttribute("role","presentation");this.domNode.removeAttribute("aria-expanded");this.domNode.removeAttribute("aria-multiselectable");if(this["aria-label"]){rn.containerNode.setAttribute("aria-label",this["aria-label"]);this.domNode.removeAttribute("aria-label");}else{if(this["aria-labelledby"]){rn.containerNode.setAttribute("aria-labelledby",this["aria-labelledby"]);this.domNode.removeAttribute("aria-labelledby");}}rn.labelNode.setAttribute("role","presentation");rn.containerNode.setAttribute("role","tree");rn.containerNode.setAttribute("aria-expanded","true");rn.containerNode.setAttribute("aria-multiselectable",!this.dndController.singular);}else{this.domNode.setAttribute("aria-multiselectable",!this.dndController.singular);this.rootLoadingIndicator.style.display="none";}this.containerNode.appendChild(rn.domNode);var _a41=this.model.getIdentity(item);if(this._itemNodesMap[_a41]){this._itemNodesMap[_a41].push(rn);}else{this._itemNodesMap[_a41]=[rn];}rn._updateLayout();this._expandNode(rn).then(lang.hitch(this,function(){this.rootLoadingIndicator.style.display="none";this.expandChildrenDeferred.resolve(true);}));}),lang.hitch(this,function(err){console.error(this,": error loading root: ",err);}));},getNodesByItem:function(item){if(!item){return [];}var _a42=lang.isString(item)?item:this.model.getIdentity(item);return [].concat(this._itemNodesMap[_a42]);},_setSelectedItemAttr:function(item){this.set("selectedItems",[item]);},_setSelectedItemsAttr:function(_a43){var tree=this;return this.pendingCommandsPromise=this.pendingCommandsPromise.always(lang.hitch(this,function(){var _a44=_9fd.map(_a43,function(item){return (!item||lang.isString(item))?item:tree.model.getIdentity(item);});var _a45=[];_9fd.forEach(_a44,function(id){_a45=_a45.concat(tree._itemNodesMap[id]||[]);});this.set("selectedNodes",_a45);}));},_setPathAttr:function(path){if(path.length){return _a1a(this.set("paths",[path]).then(function(_a46){return _a46[0];}));}else{return _a1a(this.set("paths",[]).then(function(_a47){return _a47[0];}));}},_setPathsAttr:function(_a48){var tree=this;function _a49(path,_a4a){var _a4b=path.shift();var _a4c=_9fd.filter(_a4a,function(node){return node.getIdentity()==_a4b;})[0];if(!!_a4c){if(path.length){return tree._expandNode(_a4c).then(function(){return _a49(path,_a4c.getChildren());});}else{return _a4c;}}else{throw new Tree.PathError("Could not expand path at "+_a4b);}};return _a1a(this.pendingCommandsPromise=this.pendingCommandsPromise.always(function(){return all(_9fd.map(_a48,function(path){path=_9fd.map(path,function(item){return lang.isString(item)?item:tree.model.getIdentity(item);});if(path.length){return _a49(path,[tree.rootNode]);}else{throw new Tree.PathError("Empty path");}}));}).then(function setNodes(_a4d){tree.set("selectedNodes",_a4d);return tree.paths;}));},_setSelectedNodeAttr:function(node){this.set("selectedNodes",[node]);},_setSelectedNodesAttr:function(_a4e){this.dndController.setSelection(_a4e);},expandAll:function(){var _a4f=this;function _a50(node){return _a4f._expandNode(node).then(function(){var _a51=_9fd.filter(node.getChildren()||[],function(node){return node.isExpandable;});return all(_9fd.map(_a51,_a50));});};return _a1a(_a50(this.rootNode));},collapseAll:function(){var _a52=this;function _a53(node){var _a54=_9fd.filter(node.getChildren()||[],function(node){return node.isExpandable;}),defs=all(_9fd.map(_a54,_a53));if(!node.isExpanded||(node==_a52.rootNode&&!_a52.showRoot)){return defs;}else{return defs.then(function(){return _a52._collapseNode(node);});}};return _a1a(_a53(this.rootNode));},mayHaveChildren:function(){},getItemChildren:function(){},getLabel:function(item){return this.model.getLabel(item);},getIconClass:function(item,_a55){return (!item||this.model.mayHaveChildren(item))?(_a55?"dijitFolderOpened":"dijitFolderClosed"):"dijitLeaf";},getLabelClass:function(){},getRowClass:function(){},getIconStyle:function(){},getLabelStyle:function(){},getRowStyle:function(){},getTooltip:function(){return "";},_onDownArrow:function(evt,node){var _a56=this._getNext(node);if(_a56&&_a56.isTreeNode){this.focusNode(_a56);}},_onUpArrow:function(evt,node){var _a57=node.getPreviousSibling();if(_a57){node=_a57;while(node.isExpandable&&node.isExpanded&&node.hasChildren()){var _a58=node.getChildren();node=_a58[_a58.length-1];}}else{var _a59=node.getParent();if(!(!this.showRoot&&_a59===this.rootNode)){node=_a59;}}if(node&&node.isTreeNode){this.focusNode(node);}},_onRightArrow:function(evt,node){if(node.isExpandable&&!node.isExpanded){this._expandNode(node);}else{if(node.hasChildren()){node=node.getChildren()[0];if(node&&node.isTreeNode){this.focusNode(node);}}}},_onLeftArrow:function(evt,node){if(node.isExpandable&&node.isExpanded){this._collapseNode(node);}else{var _a5a=node.getParent();if(_a5a&&_a5a.isTreeNode&&!(!this.showRoot&&_a5a===this.rootNode)){this.focusNode(_a5a);}}},focusLastChild:function(){var node=this._getLast();if(node&&node.isTreeNode){this.focusNode(node);}},_getFirst:function(){return this.showRoot?this.rootNode:this.rootNode.getChildren()[0];},_getLast:function(){var node=this.rootNode;while(node.isExpanded){var c=node.getChildren();if(!c.length){break;}node=c[c.length-1];}return node;},_getNext:function(node){if(node.isExpandable&&node.isExpanded&&node.hasChildren()){return node.getChildren()[0];}else{while(node&&node.isTreeNode){var _a5b=node.getNextSibling();if(_a5b){return _a5b;}node=node.getParent();}return null;}},childSelector:".dijitTreeRow",isExpandoNode:function(node,_a5c){return dom.isDescendant(node,_a5c.expandoNode)||dom.isDescendant(node,_a5c.expandoNodeText);},_onClick:function(_a5d,e){var _a5e=e.target,_a5f=this.isExpandoNode(_a5e,_a5d);if(_a5d.isExpandable&&(this.openOnClick||_a5f)){this._onExpandoClick({node:_a5d});}else{this._publish("execute",{item:_a5d.item,node:_a5d,evt:e});this.onClick(_a5d.item,_a5d,e);this.focusNode(_a5d);}e.stopPropagation();e.preventDefault();},_onDblClick:function(_a60,e){var _a61=e.target,_a62=(_a61==_a60.expandoNode||_a61==_a60.expandoNodeText);if(_a60.isExpandable&&(this.openOnClick||_a62)){this._onExpandoClick({node:_a60});}else{this._publish("execute",{item:_a60.item,node:_a60,evt:e});this.onDblClick(_a60.item,_a60,e);this.focusNode(_a60);}e.stopPropagation();e.preventDefault();},_onExpandoClick:function(_a63){var node=_a63.node;this.focusNode(node);if(node.isExpanded){this._collapseNode(node);}else{this._expandNode(node);}},onClick:function(){},onDblClick:function(){},onOpen:function(){},onClose:function(){},_getNextNode:function(node){_a08.deprecated(this.declaredClass+"::_getNextNode(node) is deprecated. Use _getNext(node) instead.","","2.0");return this._getNext(node);},_getRootOrFirstNode:function(){_a08.deprecated(this.declaredClass+"::_getRootOrFirstNode() is deprecated. Use _getFirst() instead.","","2.0");return this._getFirst();},_collapseNode:function(node){if(node._expandNodeDeferred){delete node._expandNodeDeferred;}if(node.state=="Loading"){return;}if(node.isExpanded){var ret=node.collapse();this.onClose(node.item,node);this._state(node,false);this._startPaint(ret);return ret;}},_expandNode:function(node){if(node._expandNodeDeferred){return node._expandNodeDeferred;}var _a64=this.model,item=node.item,_a65=this;if(!node._loadDeferred){node.markProcessing();node._loadDeferred=new _a02();_a64.getChildren(item,function(_a66){node.unmarkProcessing();node.setChildItems(_a66).then(function(){node._loadDeferred.resolve(_a66);});},function(err){console.error(_a65,": error loading "+node.label+" children: ",err);node._loadDeferred.reject(err);});}var def=node._loadDeferred.then(lang.hitch(this,function(){var def2=node.expand();this.onOpen(node.item,node);this._state(node,true);return def2;}));this._startPaint(def);return def;},focusNode:function(node){this.focusChild(node);},_onNodeMouseEnter:function(){},_onNodeMouseLeave:function(){},_onItemChange:function(item){var _a67=this.model,_a68=_a67.getIdentity(item),_a69=this._itemNodesMap[_a68];if(_a69){var _a6a=this.getLabel(item),_a6b=this.getTooltip(item);_9fd.forEach(_a69,function(node){node.set({item:item,label:_a6a,tooltip:_a6b});node._updateItemClasses(item);});}},_onItemChildrenChange:function(_a6c,_a6d){var _a6e=this.model,_a6f=_a6e.getIdentity(_a6c),_a70=this._itemNodesMap[_a6f];if(_a70){_9fd.forEach(_a70,function(_a71){_a71.setChildItems(_a6d);});}},_onItemDelete:function(item){var _a72=this.model,_a73=_a72.getIdentity(item),_a74=this._itemNodesMap[_a73];if(_a74){_9fd.forEach(_a74,function(node){this.dndController.removeTreeNode(node);var _a75=node.getParent();if(_a75){_a75.removeChild(node);}node.destroyRecursive();},this);delete this._itemNodesMap[_a73];}},_initState:function(){this._openedNodes={};if(this.persist&&this.cookieName){var oreo=_a00(this.cookieName);if(oreo){_9fd.forEach(oreo.split(","),function(item){this._openedNodes[item]=true;},this);}}},_state:function(node,_a76){if(!this.persist){return false;}var path=_9fd.map(node.getTreePath(),function(item){return this.model.getIdentity(item);},this).join("/");if(arguments.length===1){return this._openedNodes[path];}else{if(_a76){this._openedNodes[path]=true;}else{delete this._openedNodes[path];}this._saveExpandedNodes();}},_saveExpandedNodes:function(){if(this.persist&&this.cookieName){var ary=[];for(var id in this._openedNodes){ary.push(id);}_a00(this.cookieName,ary.join(","),{expires:365});}},destroy:function(){if(this._curSearch){this._curSearch.timer.remove();delete this._curSearch;}if(this.rootNode){this.rootNode.destroyRecursive();}if(this.dndController&&!lang.isString(this.dndController)){this.dndController.destroy();}this.rootNode=null;this.inherited(arguments);},destroyRecursive:function(){this.destroy();},resize:function(_a77){if(_a77){_a04.setMarginBox(this.domNode,_a77);}this._nodePixelIndent=_a04.position(this.tree.indentDetector).w||this._nodePixelIndent;this.expandChildrenDeferred.then(lang.hitch(this,function(){this.rootNode.set("indent",this.showRoot?0:-1);this._adjustWidths();}));},_outstandingPaintOperations:0,_startPaint:function(p){this._outstandingPaintOperations++;if(this._adjustWidthsTimer){this._adjustWidthsTimer.remove();delete this._adjustWidthsTimer;}var oc=lang.hitch(this,function(){this._outstandingPaintOperations--;if(this._outstandingPaintOperations<=0&&!this._adjustWidthsTimer&&this._started){this._adjustWidthsTimer=this.defer("_adjustWidths");}});when(p,oc,oc);},_adjustWidths:function(){if(this._adjustWidthsTimer){this._adjustWidthsTimer.remove();delete this._adjustWidthsTimer;}this.containerNode.style.width="auto";this.containerNode.style.width=this.domNode.scrollWidth>this.domNode.offsetWidth?"auto":"100%";},_createTreeNode:function(args){return new _a1d(args);},focus:function(){if(this.lastFocusedChild){this.focusNode(this.lastFocusedChild);}else{this.focusFirstChild();}}});if(has("dojo-bidi")){Tree.extend({_setTextDirAttr:function(_a78){if(_a78&&this.textDir!=_a78){this._set("textDir",_a78);this.rootNode.set("textDir",_a78);}}});}Tree.PathError=_a06("TreePathError");Tree._TreeNode=_a1d;return Tree;});},"dijit/form/HorizontalSlider":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/dnd/move","dojo/_base/fx","dojo/dom-geometry","dojo/dom-style","dojo/keys","dojo/_base/lang","dojo/sniff","dojo/dnd/Moveable","dojo/dnd/Mover","dojo/query","dojo/mouse","dojo/on","../_base/manager","../focus","../typematic","./Button","./_FormValueWidget","../_Container","dojo/text!./templates/HorizontalSlider.html"],function(_a79,_a7a,move,fx,_a7b,_a7c,keys,lang,has,_a7d,_a7e,_a7f,_a80,on,_a81,_a82,_a83,_a84,_a85,_a86,_a87){var _a88=_a7a("dijit.form._SliderMover",_a7e,{onMouseMove:function(e){var _a89=this.widget;var _a8a=_a89._abspos;if(!_a8a){_a8a=_a89._abspos=_a7b.position(_a89.sliderBarContainer,true);_a89._setPixelValue_=lang.hitch(_a89,"_setPixelValue");_a89._isReversed_=_a89._isReversed();}var _a8b=e[_a89._mousePixelCoord]-_a8a[_a89._startingPixelCoord];_a89._setPixelValue_(_a89._isReversed_?(_a8a[_a89._pixelCount]-_a8b):_a8b,_a8a[_a89._pixelCount],false);},destroy:function(e){_a7e.prototype.destroy.apply(this,arguments);var _a8c=this.widget;_a8c._abspos=null;_a8c._setValueAttr(_a8c.value,true);}});var _a8d=_a7a("dijit.form.HorizontalSlider",[_a85,_a86],{templateString:_a87,value:0,showButtons:true,minimum:0,maximum:100,discreteValues:Infinity,pageIncrement:2,clickSelect:true,slideDuration:_a81.defaultDuration,_setIdAttr:"",_setNameAttr:"valueNode",baseClass:"dijitSlider",cssStateNodes:{incrementButton:"dijitSliderIncrementButton",decrementButton:"dijitSliderDecrementButton",focusNode:"dijitSliderThumb"},_mousePixelCoord:"pageX",_pixelCount:"w",_startingPixelCoord:"x",_handleOffsetCoord:"left",_progressPixelSize:"width",_onKeyUp:function(e){if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){return;}this._setValueAttr(this.value,true);},_onKeyDown:function(e){if(this.disabled||this.readOnly||e.altKey||e.ctrlKey||e.metaKey){return;}switch(e.keyCode){case keys.HOME:this._setValueAttr(this.minimum,false);break;case keys.END:this._setValueAttr(this.maximum,false);break;case ((this._descending||this.isLeftToRight())?keys.RIGHT_ARROW:keys.LEFT_ARROW):case (this._descending===false?keys.DOWN_ARROW:keys.UP_ARROW):case (this._descending===false?keys.PAGE_DOWN:keys.PAGE_UP):this.increment(e);break;case ((this._descending||this.isLeftToRight())?keys.LEFT_ARROW:keys.RIGHT_ARROW):case (this._descending===false?keys.UP_ARROW:keys.DOWN_ARROW):case (this._descending===false?keys.PAGE_UP:keys.PAGE_DOWN):this.decrement(e);break;default:return;}e.stopPropagation();e.preventDefault();},_onHandleClick:function(e){if(this.disabled||this.readOnly){return;}if(!has("ie")){_a82.focus(this.sliderHandle);}e.stopPropagation();e.preventDefault();},_isReversed:function(){return !this.isLeftToRight();},_onBarClick:function(e){if(this.disabled||this.readOnly||!this.clickSelect){return;}_a82.focus(this.sliderHandle);e.stopPropagation();e.preventDefault();var _a8e=_a7b.position(this.sliderBarContainer,true);var _a8f=e[this._mousePixelCoord]-_a8e[this._startingPixelCoord];this._setPixelValue(this._isReversed()?(_a8e[this._pixelCount]-_a8f):_a8f,_a8e[this._pixelCount],true);this._movable.onMouseDown(e);},_setPixelValue:function(_a90,_a91,_a92){if(this.disabled||this.readOnly){return;}var _a93=this.discreteValues;if(_a93<=1||_a93==Infinity){_a93=_a91;}_a93--;var _a94=_a91/_a93;var _a95=Math.round(_a90/_a94);this._setValueAttr(Math.max(Math.min((this.maximum-this.minimum)*_a95/_a93+this.minimum,this.maximum),this.minimum),_a92);},_setValueAttr:function(_a96,_a97){this._set("value",_a96);this.valueNode.value=_a96;this.focusNode.setAttribute("aria-valuenow",_a96);this.inherited(arguments);var _a98=(_a96-this.minimum)/(this.maximum-this.minimum);var _a99=(this._descending===false)?this.remainingBar:this.progressBar;var _a9a=(this._descending===false)?this.progressBar:this.remainingBar;if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){this._inProgressAnim.stop(true);}if(_a97&&this.slideDuration>0&&_a99.style[this._progressPixelSize]){var _a9b=this;var _a9c={};var _a9d=parseFloat(_a99.style[this._progressPixelSize]);var _a9e=this.slideDuration*(_a98-_a9d/100);if(_a9e==0){return;}if(_a9e<0){_a9e=0-_a9e;}_a9c[this._progressPixelSize]={start:_a9d,end:_a98*100,units:"%"};this._inProgressAnim=fx.animateProperty({node:_a99,duration:_a9e,onAnimate:function(v){_a9a.style[_a9b._progressPixelSize]=(100-parseFloat(v[_a9b._progressPixelSize]))+"%";},onEnd:function(){delete _a9b._inProgressAnim;},properties:_a9c});this._inProgressAnim.play();}else{_a99.style[this._progressPixelSize]=(_a98*100)+"%";_a9a.style[this._progressPixelSize]=((1-_a98)*100)+"%";}},_bumpValue:function(_a9f,_aa0){if(this.disabled||this.readOnly){return;}var s=_a7c.getComputedStyle(this.sliderBarContainer);var c=_a7b.getContentBox(this.sliderBarContainer,s);var _aa1=this.discreteValues;if(_aa1<=1||_aa1==Infinity){_aa1=c[this._pixelCount];}_aa1--;var _aa2=(this.value-this.minimum)*_aa1/(this.maximum-this.minimum)+_a9f;if(_aa2<0){_aa2=0;}if(_aa2>_aa1){_aa2=_aa1;}_aa2=_aa2*(this.maximum-this.minimum)/_aa1+this.minimum;this._setValueAttr(_aa2,_aa0);},_onClkBumper:function(val){if(this.disabled||this.readOnly||!this.clickSelect){return;}this._setValueAttr(val,true);},_onClkIncBumper:function(){this._onClkBumper(this._descending===false?this.minimum:this.maximum);},_onClkDecBumper:function(){this._onClkBumper(this._descending===false?this.maximum:this.minimum);},decrement:function(e){this._bumpValue(e.keyCode==keys.PAGE_DOWN?-this.pageIncrement:-1);},increment:function(e){this._bumpValue(e.keyCode==keys.PAGE_UP?this.pageIncrement:1);},_mouseWheeled:function(evt){evt.stopPropagation();evt.preventDefault();this._bumpValue(evt.wheelDelta<0?-1:1,true);},startup:function(){if(this._started){return;}_a79.forEach(this.getChildren(),function(_aa3){if(this[_aa3.container]!=this.containerNode){this[_aa3.container].appendChild(_aa3.domNode);}},this);this.inherited(arguments);},_typematicCallback:function(_aa4,_aa5,e){if(_aa4==-1){this._setValueAttr(this.value,true);}else{this[(_aa5==(this._descending?this.incrementButton:this.decrementButton))?"decrement":"increment"](e);}},buildRendering:function(){this.inherited(arguments);if(this.showButtons){this.incrementButton.style.display="";this.decrementButton.style.display="";}var _aa6=_a7f("label[for=\""+this.id+"\"]");if(_aa6.length){if(!_aa6[0].id){_aa6[0].id=this.id+"_label";}this.focusNode.setAttribute("aria-labelledby",_aa6[0].id);}this.focusNode.setAttribute("aria-valuemin",this.minimum);this.focusNode.setAttribute("aria-valuemax",this.maximum);},postCreate:function(){this.inherited(arguments);if(this.showButtons){this.own(_a83.addMouseListener(this.decrementButton,this,"_typematicCallback",25,500),_a83.addMouseListener(this.incrementButton,this,"_typematicCallback",25,500));}this.own(on(this.domNode,_a80.wheel,lang.hitch(this,"_mouseWheeled")));var _aa7=_a7a(_a88,{widget:this});this._movable=new _a7d(this.sliderHandle,{mover:_aa7});this._layoutHackIE7();},destroy:function(){this._movable.destroy();if(this._inProgressAnim&&this._inProgressAnim.status!="stopped"){this._inProgressAnim.stop(true);}this.inherited(arguments);}});_a8d._Mover=_a88;return _a8d;});},"url:dijit/templates/Menu.html":"<table class=\"dijit dijitMenu dijitMenuPassive dijitReset dijitMenuTable\" role=\"menu\" tabIndex=\"${tabIndex}\"\n\t   cellspacing=\"0\">\n\t<tbody class=\"dijitReset\" data-dojo-attach-point=\"containerNode\"></tbody>\n</table>\n","url:dijit/templates/TreeNode.html":"<div class=\"dijitTreeNode\" role=\"presentation\"\n\t><div data-dojo-attach-point=\"rowNode\" class=\"dijitTreeRow\" role=\"presentation\"\n\t\t><span data-dojo-attach-point=\"expandoNode\" class=\"dijitInline dijitTreeExpando\" role=\"presentation\"></span\n\t\t><span data-dojo-attach-point=\"expandoNodeText\" class=\"dijitExpandoText\" role=\"presentation\"></span\n\t\t><span data-dojo-attach-point=\"contentNode\"\n\t\t\tclass=\"dijitTreeContent\" role=\"presentation\">\n\t\t\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitTreeIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span data-dojo-attach-point=\"labelNode,focusNode\" class=\"dijitTreeLabel\" role=\"treeitem\" tabindex=\"-1\" aria-selected=\"false\"></span>\n\t\t</span\n\t></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeNodeContainer\" role=\"presentation\" style=\"display: none;\"></div>\n</div>\n","url:dijit/form/templates/Spinner.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitButtonNode dijitSpinnerButtonContainer\"\n\t\t><input class=\"dijitReset dijitInputField dijitSpinnerButtonInner\" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t/><div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitUpArrowButton\"\n\t\t\tdata-dojo-attach-point=\"upArrowNode\"\n\t\t\t><div class=\"dijitArrowButtonInner\"\n\t\t\t\t><input class=\"dijitReset dijitInputField\" value=\"&#9650; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t\t${_buttonInputDisabled}\n\t\t\t/></div\n\t\t></div\n\t\t><div class=\"dijitReset dijitLeft dijitButtonNode dijitArrowButton dijitDownArrowButton\"\n\t\t\tdata-dojo-attach-point=\"downArrowNode\"\n\t\t\t><div class=\"dijitArrowButtonInner\"\n\t\t\t\t><input class=\"dijitReset dijitInputField\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t\t${_buttonInputDisabled}\n\t\t\t/></div\n\t\t></div\n\t></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' data-dojo-attach-point=\"textbox,focusNode\" type=\"${type}\" data-dojo-attach-event=\"onkeydown:_onKeyDown\"\n\t\t\trole=\"spinbutton\" autocomplete=\"off\" ${!nameAttrSetting}\n\t/></div\n></div>\n","url:dijit/templates/MenuBar.html":"<div class=\"dijitMenuBar dijitMenuPassive\" data-dojo-attach-point=\"containerNode\" role=\"menubar\" tabIndex=\"${tabIndex}\"\n\t ></div>\n","url:dijit/layout/templates/AccordionButton.html":"<div data-dojo-attach-event='ondijitclick:_onTitleClick' class='dijitAccordionTitle' role=\"presentation\">\n\t<div data-dojo-attach-point='titleNode,focusNode' data-dojo-attach-event='onkeydown:_onTitleKeyDown'\n\t\t\tclass='dijitAccordionTitleFocus' role=\"tab\" aria-expanded=\"false\"\n\t\t><span class='dijitInline dijitAccordionArrow' role=\"presentation\"></span\n\t\t><span class='arrowTextUp' role=\"presentation\">+</span\n\t\t><span class='arrowTextDown' role=\"presentation\">-</span\n\t\t><span role=\"presentation\" class=\"dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t\t<span role=\"presentation\" data-dojo-attach-point='titleTextNode, textDirNode' class='dijitAccordionText'></span>\n\t</div>\n</div>\n","url:dijit/templates/TitlePane.html":"<div>\n\t<div data-dojo-attach-event=\"ondijitclick:_onTitleClick, onkeydown:_onTitleKey\"\n\t\t\tclass=\"dijitTitlePaneTitle\" data-dojo-attach-point=\"titleBarNode\" id=\"${id}_titleBarNode\">\n\t\t<div class=\"dijitTitlePaneTitleFocus\" data-dojo-attach-point=\"focusNode\">\n\t\t\t<span data-dojo-attach-point=\"arrowNode\" class=\"dijitInline dijitArrowNode\" role=\"presentation\"></span\n\t\t\t><span data-dojo-attach-point=\"arrowNodeInner\" class=\"dijitArrowNodeInner\"></span\n\t\t\t><span data-dojo-attach-point=\"titleNode\" class=\"dijitTitlePaneTextNode\"></span>\n\t\t</div>\n\t</div>\n\t<div class=\"dijitTitlePaneContentOuter\" data-dojo-attach-point=\"hideNode\" role=\"presentation\">\n\t\t<div class=\"dijitReset\" data-dojo-attach-point=\"wipeNode\" role=\"presentation\">\n\t\t\t<div class=\"dijitTitlePaneContentInner\" data-dojo-attach-point=\"containerNode\" role=\"region\" id=\"${id}_pane\" aria-labelledby=\"${id}_titleBarNode\">\n\t\t\t\t<!-- nested divs because wipeIn()/wipeOut() doesn't work right on node w/padding etc.  Put padding on inner div. -->\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div>\n","url:dijit/templates/MenuSeparator.html":"<tr class=\"dijitMenuSeparator\" role=\"separator\">\n\t<td class=\"dijitMenuSeparatorIconCell\">\n\t\t<div class=\"dijitMenuSeparatorTop\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n\t<td colspan=\"3\" class=\"dijitMenuSeparatorLabelCell\">\n\t\t<div class=\"dijitMenuSeparatorTop dijitMenuSeparatorLabel\"></div>\n\t\t<div class=\"dijitMenuSeparatorBottom\"></div>\n\t</td>\n</tr>\n","url:dijit/templates/ProgressBar.html":"<div class=\"dijitProgressBar dijitProgressBarEmpty\" role=\"progressbar\"\n\t><div  data-dojo-attach-point=\"internalProgress\" class=\"dijitProgressBarFull\"\n\t\t><div class=\"dijitProgressBarTile\" role=\"presentation\"></div\n\t\t><span style=\"visibility:hidden\">&#160;</span\n\t></div\n\t><div data-dojo-attach-point=\"labelNode\" class=\"dijitProgressBarLabel\" id=\"${id}_label\"></div\n\t><span data-dojo-attach-point=\"indeterminateHighContrastImage\"\n\t\t   class=\"dijitInline dijitProgressBarIndeterminateHighContrastImage\"></span\n></div>\n","url:dijit/form/templates/DropDownButton.html":"<span class=\"dijit dijitReset dijitInline\"\n\t><span class='dijitReset dijitInline dijitButtonNode'\n\t\tdata-dojo-attach-event=\"ondijitclick:__onClick\" data-dojo-attach-point=\"_buttonNode\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"focusNode,titleNode,_arrowWrapperNode,_popupStateNode\"\n\t\t\trole=\"button\" aria-haspopup=\"true\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\"\n\t\t\t\tdata-dojo-attach-point=\"iconNode\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonInner\"></span\n\t\t\t><span class=\"dijitReset dijitInline dijitArrowButtonChar\">&#9660;</span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\" tabIndex=\"-1\"\n\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\tdata-dojo-attach-point=\"valueNode\" role=\"presentation\"\n/></span>\n","url:dijit/form/templates/DropDownBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\"\n\trole=\"combobox\"\n\taria-haspopup=\"true\"\n\tdata-dojo-attach-point=\"_popupStateNode\"\n\t><div class='dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer'\n\t\tdata-dojo-attach-point=\"_buttonNode\" role=\"presentation\"\n\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"button presentation\" aria-hidden=\"true\"\n\t\t\t${_buttonInputDisabled}\n\t/></div\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class='dijitReset dijitInputInner' ${!nameAttrSetting} type=\"text\" autocomplete=\"off\"\n\t\t\tdata-dojo-attach-point=\"textbox,focusNode\" role=\"textbox\"\n\t/></div\n></div>\n","url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"${role}\" tabIndex=\"-1\" aria-checked=\"${checked}\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<span class=\"dijitInline dijitIcon dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t\t<span class=\"dijitMenuItemIconChar dijitCheckedMenuItemIconChar\">${checkedChar}</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode,textDirNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n","url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n></div>\n","url:dijit/form/templates/ValidationTextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\"\n\tid=\"widget_${id}\" role=\"presentation\"\n\t><div class='dijitReset dijitValidationContainer'\n\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t/></div\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","url:dijit/templates/InlineEditBox.html":"<span data-dojo-attach-point=\"editNode\" role=\"presentation\" class=\"dijitReset dijitInline dijitOffScreen\"\n\t><span data-dojo-attach-point=\"editorPlaceholder\"></span\n\t><span data-dojo-attach-point=\"buttonContainer\"\n\t\t><button data-dojo-type=\"./form/Button\" data-dojo-props=\"label: '${buttonSave}', 'class': 'saveButton'\"\n\t\t\tdata-dojo-attach-point=\"saveButton\" data-dojo-attach-event=\"onClick:save\"></button\n\t\t><button data-dojo-type=\"./form/Button\"  data-dojo-props=\"label: '${buttonCancel}', 'class': 'cancelButton'\"\n\t\t\tdata-dojo-attach-point=\"cancelButton\" data-dojo-attach-event=\"onClick:cancel\"></button\n\t></span\n></span>\n","url:dijit/templates/ColorPalette.html":"<div class=\"dijitInline dijitColorPalette\" role=\"grid\">\n\t<table dojoAttachPoint=\"paletteTableNode\" class=\"dijitPaletteTable\" cellSpacing=\"0\" cellPadding=\"0\" role=\"presentation\">\n\t\t<tbody data-dojo-attach-point=\"gridNode\"></tbody>\n\t</table>\n</div>\n","url:dijit/layout/templates/_ScrollingTabControllerButton.html":"<div data-dojo-attach-event=\"ondijitclick:_onClick\" class=\"dijitTabInnerDiv dijitTabContent dijitButtonContents\"  data-dojo-attach-point=\"focusNode\" role=\"button\">\n\t<span role=\"presentation\" class=\"dijitInline dijitTabStripIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t<span data-dojo-attach-point=\"containerNode,titleNode\" class=\"dijitButtonText\"></span>\n</div>","url:dijit/layout/templates/TabContainer.html":"<div class=\"dijitTabContainer\">\n\t<div class=\"dijitTabListWrapper\" data-dojo-attach-point=\"tablistNode\"></div>\n\t<div data-dojo-attach-point=\"tablistSpacer\" class=\"dijitTabSpacer ${baseClass}-spacer\"></div>\n\t<div class=\"dijitTabPaneWrapper ${baseClass}-container\" data-dojo-attach-point=\"containerNode\"></div>\n</div>\n","url:dijit/form/templates/ComboButton.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tcellspacing='0' cellpadding='0' role=\"presentation\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonNode\" data-dojo-attach-point=\"buttonNode\" data-dojo-attach-event=\"ondijitclick:__onClick,onkeydown:_onButtonKeyDown\"\n\t\t><div id=\"${id}_button\" class=\"dijitReset dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><div class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitInline dijitButtonText\" id=\"${id}_label\" data-dojo-attach-point=\"containerNode\" role=\"presentation\"></div\n\t\t></div\n\t\t></td\n\t\t><td id=\"${id}_arrow\" class='dijitReset dijitRight dijitButtonNode dijitArrowButton'\n\t\t\tdata-dojo-attach-point=\"_popupStateNode,focusNode,_buttonNode\"\n\t\t\tdata-dojo-attach-event=\"onkeydown:_onArrowKeyDown\"\n\t\t\ttitle=\"${optionsTitle}\"\n\t\t\trole=\"button\" aria-haspopup=\"true\"\n\t\t\t><div class=\"dijitReset dijitArrowButtonInner\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitArrowButtonChar\" role=\"presentation\">&#9660;</div\n\t\t></td\n\t\t><td style=\"display:none !important;\"\n\t\t\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" data-dojo-attach-point=\"valueNode\" role=\"presentation\"\n\t\t\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\t/></td></tr></tbody\n></table>\n","url:dijit/templates/Tree.html":"<div role=\"tree\">\n\t<div class=\"dijitInline dijitTreeIndent\" style=\"position: absolute; top: -9999px\" data-dojo-attach-point=\"indentDetector\"></div>\n\t<div class=\"dijitTreeExpando dijitTreeExpandoLoading\" data-dojo-attach-point=\"rootLoadingIndicator\"></div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitTreeContainer\" role=\"presentation\">\n\t</div>\n</div>\n","url:dijit/templates/Dialog.html":"<div class=\"dijitDialog\" role=\"dialog\" aria-labelledby=\"${id}_title\">\n\t<div data-dojo-attach-point=\"titleBar\" class=\"dijitDialogTitleBar\">\n\t\t<span data-dojo-attach-point=\"titleNode\" class=\"dijitDialogTitle\" id=\"${id}_title\"\n\t\t\t\trole=\"heading\" level=\"1\"></span>\n\t\t<span data-dojo-attach-point=\"closeButtonNode\" class=\"dijitDialogCloseIcon\" data-dojo-attach-event=\"ondijitclick: onCancel\" title=\"${buttonCancel}\" role=\"button\" tabindex=\"0\">\n\t\t\t<span data-dojo-attach-point=\"closeText\" class=\"closeText\" title=\"${buttonCancel}\">x</span>\n\t\t</span>\n\t</div>\n\t<div data-dojo-attach-point=\"containerNode\" class=\"dijitDialogPaneContent\"></div>\n</div>\n","url:dijit/form/templates/TextBox.html":"<div class=\"dijit dijitReset dijitInline dijitLeft\" id=\"widget_${id}\" role=\"presentation\"\n\t><div class=\"dijitReset dijitInputField dijitInputContainer\"\n\t\t><input class=\"dijitReset dijitInputInner\" data-dojo-attach-point='textbox,focusNode' autocomplete=\"off\"\n\t\t\t${!nameAttrSetting} type='${type}'\n\t/></div\n></div>\n","url:dijit/form/templates/Select.html":"<table class=\"dijit dijitReset dijitInline dijitLeft\"\n\tdata-dojo-attach-point=\"_buttonNode,tableNode,focusNode,_popupStateNode\" cellspacing='0' cellpadding='0'\n\trole=\"listbox\" aria-haspopup=\"true\"\n\t><tbody role=\"presentation\"><tr role=\"presentation\"\n\t\t><td class=\"dijitReset dijitStretch dijitButtonContents\" role=\"presentation\"\n\t\t\t><div class=\"dijitReset dijitInputField dijitButtonText\"  data-dojo-attach-point=\"containerNode,textDirNode\" role=\"presentation\"></div\n\t\t\t><div class=\"dijitReset dijitValidationContainer\"\n\t\t\t\t><input class=\"dijitReset dijitInputField dijitValidationIcon dijitValidationInner\" value=\"&#935; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t/></div\n\t\t\t><input type=\"hidden\" ${!nameAttrSetting} data-dojo-attach-point=\"valueNode\" value=\"${value}\" aria-hidden=\"true\"\n\t\t/></td\n\t\t><td class=\"dijitReset dijitRight dijitButtonNode dijitArrowButton dijitDownArrowButton dijitArrowButtonContainer\"\n\t\t\tdata-dojo-attach-point=\"titleNode\" role=\"presentation\"\n\t\t\t><input class=\"dijitReset dijitInputField dijitArrowButtonInner\" value=\"&#9660; \" type=\"text\" tabIndex=\"-1\" readonly=\"readonly\" role=\"presentation\"\n\t\t\t\t${_buttonInputDisabled}\n\t\t/></td\n\t></tr></tbody\n></table>\n","url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,textDirNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<span data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<span class=\"dijitInline dijitIcon dijitMenuExpand\"></span>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</span>\n\t</td>\n</tr>\n","url:dijit/templates/MenuBarItem.html":"<div class=\"dijitReset dijitInline dijitMenuItem dijitMenuItemLabel\" data-dojo-attach-point=\"focusNode\"\n\t \trole=\"menuitem\" tabIndex=\"-1\">\n\t<span data-dojo-attach-point=\"containerNode,textDirNode\"></span>\n</div>\n","url:dijit/layout/templates/_TabButton.html":"<div role=\"presentation\" data-dojo-attach-point=\"titleNode,innerDiv,tabContent\" class=\"dijitTabInner dijitTabContent\">\n\t<span role=\"presentation\" class=\"dijitInline dijitIcon dijitTabButtonIcon\" data-dojo-attach-point=\"iconNode\"></span>\n\t<span data-dojo-attach-point='containerNode,focusNode' class='tabLabel'></span>\n\t<span class=\"dijitInline dijitTabCloseButton dijitTabCloseIcon\" data-dojo-attach-point='closeNode'\n\t\t  role=\"presentation\">\n\t\t<span data-dojo-attach-point='closeText' class='dijitTabCloseText'>[x]</span\n\t\t\t\t></span>\n</div>\n","url:dijit/form/templates/HorizontalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderH\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeydown:_onKeyDown, onkeyup:_onKeyUp\"\n\trole=\"presentation\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"topDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationT dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderDecrementIconH\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderLeftBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><div class=\"dijitReset dijitSliderBarContainerH\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderProgressBar dijitSliderProgressBarH\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableH\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleH\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarH dijitSliderRemainingBar dijitSliderRemainingBarH\" data-dojo-attach-event=\"press:_onBarClick\"></div\n\t\t\t></div\n\t\t></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperH dijitSliderRightBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div\n\t\t></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerH\"\n\t\t\t><div class=\"dijitSliderIncrementIconH\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t\t><td data-dojo-attach-point=\"containerNode,bottomDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationB dijitSliderDecorationH\"></td\n\t\t><td class=\"dijitReset\" colspan=\"2\"></td\n\t></tr\n></table>\n","url:dijit/form/templates/CheckBox.html":"<div class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><input\n\t \t${!nameAttrSetting} type=\"${type}\" role=\"${type}\" aria-checked=\"false\" ${checkedAttrSetting}\n\t\tclass=\"dijitReset dijitCheckBoxInput\"\n\t\tdata-dojo-attach-point=\"focusNode\"\n\t \tdata-dojo-attach-event=\"ondijitclick:_onClick\"\n/></div>\n","url:dijit/form/templates/VerticalSlider.html":"<table class=\"dijit dijitReset dijitSlider dijitSliderV\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" rules=\"none\" data-dojo-attach-event=\"onkeydown:_onKeyDown,onkeyup:_onKeyUp\"\n\trole=\"presentation\"\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderIncrementIconV\" style=\"display:none\" data-dojo-attach-point=\"decrementButton\"><span class=\"dijitSliderButtonInner\">+</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderTopBumper\" data-dojo-attach-event=\"press:_onClkIncBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td data-dojo-attach-point=\"leftDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationL dijitSliderDecorationV\"></td\n\t\t><td class=\"dijitReset dijitSliderDecorationC\" style=\"height:100%;\"\n\t\t\t><input data-dojo-attach-point=\"valueNode\" type=\"hidden\" ${!nameAttrSetting}\n\t\t\t/><center class=\"dijitReset dijitSliderBarContainerV\" role=\"presentation\" data-dojo-attach-point=\"sliderBarContainer\"\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"remainingBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderRemainingBar dijitSliderRemainingBarV\" data-dojo-attach-event=\"press:_onBarClick\"><!--#5629--></div\n\t\t\t\t><div role=\"presentation\" data-dojo-attach-point=\"progressBar\" class=\"dijitSliderBar dijitSliderBarV dijitSliderProgressBar dijitSliderProgressBarV\" data-dojo-attach-event=\"press:_onBarClick\"\n\t\t\t\t\t><div class=\"dijitSliderMoveable dijitSliderMoveableV\" style=\"vertical-align:top;\"\n\t\t\t\t\t\t><div data-dojo-attach-point=\"sliderHandle,focusNode\" class=\"dijitSliderImageHandle dijitSliderImageHandleV\" data-dojo-attach-event=\"press:_onHandleClick\" role=\"slider\"></div\n\t\t\t\t\t></div\n\t\t\t\t></div\n\t\t\t></center\n\t\t></td\n\t\t><td data-dojo-attach-point=\"containerNode,rightDecoration\" class=\"dijitReset dijitSliderDecoration dijitSliderDecorationR dijitSliderDecorationV\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset\"\n\t\t\t><center><div class=\"dijitSliderBar dijitSliderBumper dijitSliderBumperV dijitSliderBottomBumper\" data-dojo-attach-event=\"press:_onClkDecBumper\"></div></center\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n\t><tr class=\"dijitReset\"\n\t\t><td class=\"dijitReset\"></td\n\t\t><td class=\"dijitReset dijitSliderButtonContainer dijitSliderButtonContainerV\"\n\t\t\t><div class=\"dijitSliderDecrementIconV\" style=\"display:none\" data-dojo-attach-point=\"incrementButton\"><span class=\"dijitSliderButtonInner\">-</span></div\n\t\t></td\n\t\t><td class=\"dijitReset\"></td\n\t></tr\n></table>\n","url:dijit/templates/Calendar.html":"<table cellspacing=\"0\" cellpadding=\"0\" class=\"dijitCalendarContainer\" role=\"grid\" aria-labelledby=\"${id}_mddb ${id}_year\" data-dojo-attach-point=\"gridNode\">\n\t<thead>\n\t\t<tr class=\"dijitReset dijitCalendarMonthContainer\" valign=\"top\">\n\t\t\t<th class='dijitReset dijitCalendarArrow' data-dojo-attach-point=\"decrementMonth\" scope=\"col\">\n\t\t\t\t<span class=\"dijitInline dijitCalendarIncrementControl dijitCalendarDecrease\" role=\"presentation\"></span>\n\t\t\t\t<span data-dojo-attach-point=\"decreaseArrowNode\" class=\"dijitA11ySideArrow\">-</span>\n\t\t\t</th>\n\t\t\t<th class='dijitReset' colspan=\"5\" scope=\"col\">\n\t\t\t\t<div data-dojo-attach-point=\"monthNode\">\n\t\t\t\t</div>\n\t\t\t</th>\n\t\t\t<th class='dijitReset dijitCalendarArrow' scope=\"col\" data-dojo-attach-point=\"incrementMonth\">\n\t\t\t\t<span class=\"dijitInline dijitCalendarIncrementControl dijitCalendarIncrease\" role=\"presentation\"></span>\n\t\t\t\t<span data-dojo-attach-point=\"increaseArrowNode\" class=\"dijitA11ySideArrow\">+</span>\n\t\t\t</th>\n\t\t</tr>\n\t\t<tr role=\"row\">\n\t\t\t${!dayCellsHtml}\n\t\t</tr>\n\t</thead>\n\t<tbody data-dojo-attach-point=\"dateRowsNode\" data-dojo-attach-event=\"ondijitclick: _onDayClick\" class=\"dijitReset dijitCalendarBodyContainer\">\n\t\t\t${!dateRowsHtml}\n\t</tbody>\n\t<tfoot class=\"dijitReset dijitCalendarYearContainer\">\n\t\t<tr>\n\t\t\t<td class='dijitReset' valign=\"top\" colspan=\"7\" role=\"presentation\">\n\t\t\t\t<div class=\"dijitCalendarYearLabel\">\n\t\t\t\t\t<span data-dojo-attach-point=\"previousYearLabelNode\" class=\"dijitInline dijitCalendarPreviousYear\" role=\"button\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"currentYearLabelNode\" class=\"dijitInline dijitCalendarSelectedYear\" role=\"button\" id=\"${id}_year\"></span>\n\t\t\t\t\t<span data-dojo-attach-point=\"nextYearLabelNode\" class=\"dijitInline dijitCalendarNextYear\" role=\"button\"></span>\n\t\t\t\t</div>\n\t\t\t</td>\n\t\t</tr>\n\t</tfoot>\n</table>\n","url:dijit/layout/templates/ScrollingTabController.html":"<div class=\"dijitTabListContainer-${tabPosition}\" style=\"visibility:hidden\">\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerMenuButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_menuBtn\"\n\t\t data-dojo-props=\"containerId: '${containerId}', iconClass: 'dijitTabStripMenuIcon',\n\t\t\t\t\tdropDownPosition: ['below-alt', 'above-alt']\"\n\t\t data-dojo-attach-point=\"_menuBtn\" showLabel=\"false\" title=\"\">&#9660;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_leftBtn\"\n\t\t data-dojo-props=\"iconClass:'dijitTabStripSlideLeftIcon', showLabel:false, title:''\"\n\t\t data-dojo-attach-point=\"_leftBtn\" data-dojo-attach-event=\"onClick: doSlideLeft\">&#9664;</div>\n\t<div data-dojo-type=\"dijit.layout._ScrollingTabControllerButton\"\n\t\t class=\"tabStripButton-${tabPosition}\"\n\t\t id=\"${id}_rightBtn\"\n\t\t data-dojo-props=\"iconClass:'dijitTabStripSlideRightIcon', showLabel:false, title:''\"\n\t\t data-dojo-attach-point=\"_rightBtn\" data-dojo-attach-event=\"onClick: doSlideRight\">&#9654;</div>\n\t<div class='dijitTabListWrapper' data-dojo-attach-point='tablistWrapper'>\n\t\t<div role='tablist' data-dojo-attach-event='onkeydown:onkeydown'\n\t\t\t data-dojo-attach-point='containerNode' class='nowrapTabStrip'></div>\n\t</div>\n</div>","url:dijit/form/templates/Button.html":"<span class=\"dijit dijitReset dijitInline\" role=\"presentation\"\n\t><span class=\"dijitReset dijitInline dijitButtonNode\"\n\t\tdata-dojo-attach-event=\"ondijitclick:__onClick\" role=\"presentation\"\n\t\t><span class=\"dijitReset dijitStretch dijitButtonContents\"\n\t\t\tdata-dojo-attach-point=\"titleNode,focusNode\"\n\t\t\trole=\"button\" aria-labelledby=\"${id}_label\"\n\t\t\t><span class=\"dijitReset dijitInline dijitIcon\" data-dojo-attach-point=\"iconNode\"></span\n\t\t\t><span class=\"dijitReset dijitToggleButtonIconChar\">&#x25CF;</span\n\t\t\t><span class=\"dijitReset dijitInline dijitButtonText\"\n\t\t\t\tid=\"${id}_label\"\n\t\t\t\tdata-dojo-attach-point=\"containerNode\"\n\t\t\t></span\n\t\t></span\n\t></span\n\t><input ${!nameAttrSetting} type=\"${type}\" value=\"${value}\" class=\"dijitOffScreen\"\n\t\tdata-dojo-attach-event=\"onclick:_onClick\"\n\t\ttabIndex=\"-1\" role=\"presentation\" data-dojo-attach-point=\"valueNode\"\n/></span>\n","url:dijit/templates/TooltipDialog.html":"<div role=\"alertdialog\" tabIndex=\"-1\">\n\t<div class=\"dijitTooltipContainer\" role=\"presentation\">\n\t\t<div class=\"dijitTooltipContents dijitTooltipFocusNode\" data-dojo-attach-point=\"containerNode\"></div>\n\t</div>\n\t<div class=\"dijitTooltipConnector\" role=\"presentation\" data-dojo-attach-point=\"connectorNode\"></div>\n</div>\n","*now":function(r){r(["dojo/i18n!*preload*dijit/nls/dijit-all*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);}}});define("dijit/dijit-all",["./main","./dijit","./ColorPalette","./Declaration","./Dialog","./DialogUnderlay","./TooltipDialog","./Editor","./_editor/plugins/FontChoice","./_editor/plugins/LinkDialog","./Menu","./MenuItem","./PopupMenuItem","./CheckedMenuItem","./MenuBar","./MenuBarItem","./PopupMenuBarItem","./MenuSeparator","./ProgressBar","./TitlePane","./Toolbar","./Tooltip","./Tree","./InlineEditBox","./form/Form","./form/Button","./form/DropDownButton","./form/ComboButton","./form/ToggleButton","./form/CheckBox","./form/RadioButton","./form/TextBox","./form/ValidationTextBox","./form/CurrencyTextBox","./form/DateTextBox","./form/TimeTextBox","./form/NumberSpinner","./form/NumberTextBox","./form/ComboBox","./form/FilteringSelect","./form/MultiSelect","./form/Select","./form/HorizontalSlider","./form/VerticalSlider","./form/HorizontalRule","./form/VerticalRule","./form/HorizontalRuleLabels","./form/VerticalRuleLabels","./form/SimpleTextarea","./form/Textarea","./layout/AccordionContainer","./layout/ContentPane","./layout/BorderContainer","./layout/LayoutContainer","./layout/LinkPane","./layout/SplitContainer","./layout/StackContainer","./layout/TabContainer"],function(_aa8){console.warn("dijit-all may include much more code than your application actually requires. We strongly recommend that you investigate a custom build or the web build tool");return _aa8;});