/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/charting/plot2d/_PlotEvents":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect"],function(_1,_2,_3,_4){return _3("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=_1.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";_2.forEach(this.chart.stack,function(_5){if(_5!==this&&_5.plotEvent){t.plot=_5;_5.plotEvent(t);}},this);},connect:function(_6,_7){this.dirty=true;return _4.connect(this,"plotEvent",_6,_7);},events:function(){return !!this.plotEvent.after;},resetEvents:function(){if(this._shapeEvents.length){_2.forEach(this._shapeEvents,function(_8){_8.shape.disconnect(_8.handle);});this._shapeEvents=[];}this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,_9){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(_9,this,function(e){o.type=_9;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){if(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");}},_reconnectEvents:function(_a){var a=this._eventSeries[_a];if(a){_2.forEach(a,this._connectEvents,this);}},fireEvent:function(_b,_c,_d,_e){var s=this._eventSeries[_b];if(s&&s.length&&_d<s.length){var o=s[_d];o.type=_c;o.event=_e||null;this.raiseEvent(o);o.event=null;}}});});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./domReady","./sniff","./_base/window"],function(_f,_10,_11,has,_12){var _13=_12.doc.documentElement,ie=has("ie"),_14=has("opera"),maj=Math.floor,ff=has("ff"),_15=_f.boxModel.replace(/-/,""),_16={"dj_quirks":has("quirks"),"dj_opera":_14,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla"),"dj_ios":has("ios"),"dj_android":has("android")};if(ie){_16["dj_ie"]=true;_16["dj_ie"+maj(ie)]=true;_16["dj_iequirks"]=has("quirks");}if(ff){_16["dj_ff"+maj(ff)]=true;}_16["dj_"+_15]=true;var _17="";for(var clz in _16){if(_16[clz]){_17+=clz+" ";}}_13.className=_10.trim(_13.className+" "+_17);_11(function(){if(!_f.isBodyLtr()){var _18="dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl ");_13.className=_10.trim(_13.className+" "+_18+"dj_rtl dijitRtl "+_17.replace(/ /g,"-rtl "));}});return has;});},"dojox/charting/axis2d/Invisible":function(){define(["dojo/_base/lang","dojo/_base/declare","./Base","../scaler/linear","dojox/lang/utils"],function(_19,_1a,_1b,lin,du){return _1a("dojox.charting.axis2d.Invisible",_1b,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1},constructor:function(_1c,_1d){this.opt=_19.clone(this.defaultParams);du.updateWithObject(this.opt,_1d);du.updateWithPattern(this.opt,_1d,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(_1e,_1f){this.scale=_1e;this.offset=_1f;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},calculate:function(min,max,_20){if(this.initialized()){return this;}var o=this.opt;this.labels=o.labels;this.scaler=lin.buildScaler(min,max,_20,o);var tsb=this.scaler.bounds;if("scale" in this){o.from=tsb.lower+this.offset;o.to=(tsb.upper-tsb.lower)/this.scale+o.from;if(!isFinite(o.from)||isNaN(o.from)||!isFinite(o.to)||isNaN(o.to)||o.to-o.from>=tsb.upper-tsb.lower){delete o.from;delete o.to;delete this.scale;delete this.offset;}else{if(o.from<tsb.lower){o.to+=tsb.lower-o.from;o.from=tsb.lower;}else{if(o.to>tsb.upper){o.from+=tsb.upper-o.to;o.to=tsb.upper;}}this.offset=o.from-tsb.lower;}this.scaler=lin.buildScaler(min,max,_20,o);tsb=this.scaler.bounds;if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;}});});},"dojox/lang/utils":function(){define(["..","dojo/_base/lang"],function(_21,_22){var du=_22.getObject("lang.utils",true,_21);var _23={},_24=Object.prototype.toString;var _25=function(o){if(o){switch(_24.call(o)){case "[object Array]":return o.slice(0);case "[object Object]":return _22.delegate(o);}}return o;};_22.mixin(du,{coerceType:function(_26,_27){switch(typeof _26){case "number":return Number(eval("("+_27+")"));case "string":return String(_27);case "boolean":return Boolean(eval("("+_27+")"));}return eval("("+_27+")");},updateWithObject:function(_28,_29,_2a){if(!_29){return _28;}for(var x in _28){if(x in _29&&!(x in _23)){var t=_28[x];if(t&&typeof t=="object"){du.updateWithObject(t,_29[x],_2a);}else{_28[x]=_2a?du.coerceType(t,_29[x]):_25(_29[x]);}}}return _28;},updateWithPattern:function(_2b,_2c,_2d,_2e){if(!_2c||!_2d){return _2b;}for(var x in _2d){if(x in _2c&&!(x in _23)){_2b[x]=_2e?du.coerceType(_2d[x],_2c[x]):_25(_2c[x]);}}return _2b;},merge:function(_2f,_30){if(_30){var _31=_24.call(_2f),_32=_24.call(_30),t,i,l,m;switch(_32){case "[object Array]":if(_32==_31){t=new Array(Math.max(_2f.length,_30.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(_2f[i],_30[i]);}return t;}return _30.slice(0);case "[object Object]":if(_32==_31&&_2f){t=_22.delegate(_2f);for(i in _30){if(i in _2f){l=_2f[i];m=_30[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=_22.clone(_30[i]);}}return t;}return _22.clone(_30);}}return _30;}});return du;});},"dojox/charting/plot2d/Pie":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","./Base","./_PlotEvents","./common","dojox/gfx","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/utils","dojo/has"],function(_33,arr,_34,_35,_36,dc,g,m,df,du,has){var _37=0.2;return _34("dojox.charting.plot2d.Pie",[_35,_36],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true,radGrad:"native",fanSize:5,startAngle:0},optionalParams:{radius:0,omitLabels:false,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",labelWiring:{}},constructor:function(_38,_39){this.opt=_33.clone(this.defaultParams);du.updateWithObject(this.opt,_39);du.updateWithPattern(this.opt,_39,this.optionalParams);this.axes=[];this.run=null;this.dyn=[];},clear:function(){this.inherited(arguments);this.dyn=[];this.run=null;return this;},setAxis:function(_3a){return this;},addSeries:function(run){this.run=run;return this;},getSeriesStats:function(){return _33.delegate(dc.defaultStats);},getRequiredColors:function(){return this.run?this.run.data.length:0;},render:function(dim,_3b){if(!this.dirty){return this;}this.resetEvents();this.dirty=false;this._eventSeries={};this.cleanGroup();var s=this.group,t=this.chart.theme;if(!this.run||!this.run.data.length){return this;}var rx=(dim.width-_3b.l-_3b.r)/2,ry=(dim.height-_3b.t-_3b.b)/2,r=Math.min(rx,ry),_3c="font" in this.opt?this.opt.font:t.series.font,_3d,_3e=m._degToRad(this.opt.startAngle),_3f=_3e,_40,_41,_42,_43,_44,run=this.run.data,_45=this.events();this.dyn=[];if("radius" in this.opt){r=this.opt.radius;_44=r-this.opt.labelOffset;}var _46={cx:_3b.l+rx,cy:_3b.t+ry,r:r};if(this.opt.shadow||t.shadow){var _47=this.opt.shadow||t.shadow;var _48=_33.clone(_46);_48.cx+=_47.dx;_48.cy+=_47.dy;s.createCircle(_48).setFill(_47.color).setStroke(_47);}if(s.setFilter&&(this.opt.filter||t.filter)){s.createCircle(_46).setFill(t.series.stroke).setFilter(this.opt.filter||t.filter);}if(typeof run[0]=="number"){_40=df.map(run,"x ? Math.max(x, 0) : 0");if(df.every(_40,"<= 0")){s.createCircle(_46).setStroke(t.series.stroke);this.dyn=arr.map(_40,function(){return {};});return this;}else{_41=df.map(_40,"/this",df.foldl(_40,"+",0));if(this.opt.labels){_42=arr.map(_41,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}}else{_40=df.map(run,"x ? Math.max(x.y, 0) : 0");if(df.every(_40,"<= 0")){s.createCircle(_46).setStroke(t.series.stroke);this.dyn=arr.map(_40,function(){return {};});return this;}else{_41=df.map(_40,"/this",df.foldl(_40,"+",0));if(this.opt.labels){_42=arr.map(_41,function(x,i){if(x<0){return "";}var v=run[i];return "text" in v?v.text:this._getLabel(x*100)+"%";},this);}}}var _49=df.map(run,function(v,i){var _4a=[this.opt,this.run];if(v!==null&&typeof v!="number"){_4a.push(v);}if(this.opt.styleFunc){_4a.push(this.opt.styleFunc(v));}return t.next("slice",_4a,true);},this);if(this.opt.labels){_3d=_3c?g.normalizedLength(g.splitFontString(_3c).size):0;_43=df.foldl1(df.map(_42,function(_4b,i){var _4c=_49[i].series.font;return g._base._getTextBox(_4b,{font:_4c}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_43,ry-_3d)+this.opt.labelOffset;}_44=r-this.opt.labelOffset;}var _4d=new Array(_41.length);arr.some(_41,function(_4e,i){if(_4e<0){return false;}if(_4e==0){this.dyn.push({fill:null,stroke:null});return false;}var v=run[i],_4f=_49[i],_50,o;if(_4e>=1){_50=this._plotFill(_4f.series.fill,dim,_3b);_50=this._shapeFill(_50,{x:_46.cx-_46.r,y:_46.cy-_46.r,width:2*_46.r,height:2*_46.r});_50=this._pseudoRadialFill(_50,{x:_46.cx,y:_46.cy},_46.r);var _51=s.createCircle(_46).setFill(_50).setStroke(_4f.series.stroke);this.dyn.push({fill:_50,stroke:_4f.series.stroke});if(_45){o={element:"slice",index:i,run:this.run,shape:_51,x:i,y:typeof v=="number"?v:v.y,cx:_46.cx,cy:_46.cy,cr:r};this._connectEvents(o);_4d[i]=o;}return false;}var end=_3f+_4e*2*Math.PI;if(i+1==_41.length){end=_3e+2*Math.PI;}var _52=end-_3f,x1=_46.cx+r*Math.cos(_3f),y1=_46.cy+r*Math.sin(_3f),x2=_46.cx+r*Math.cos(end),y2=_46.cy+r*Math.sin(end);var _53=m._degToRad(this.opt.fanSize);if(_4f.series.fill&&_4f.series.fill.type==="radial"&&this.opt.radGrad==="fan"&&_52>_53){var _54=s.createGroup(),_55=Math.ceil(_52/_53),_56=_52/_55;_50=this._shapeFill(_4f.series.fill,{x:_46.cx-_46.r,y:_46.cy-_46.r,width:2*_46.r,height:2*_46.r});for(var j=0;j<_55;++j){var _57=j==0?x1:_46.cx+r*Math.cos(_3f+(j-_37)*_56),_58=j==0?y1:_46.cy+r*Math.sin(_3f+(j-_37)*_56),_59=j==_55-1?x2:_46.cx+r*Math.cos(_3f+(j+1+_37)*_56),_5a=j==_55-1?y2:_46.cy+r*Math.sin(_3f+(j+1+_37)*_56);_54.createPath().moveTo(_46.cx,_46.cy).lineTo(_57,_58).arcTo(r,r,0,_56>Math.PI,true,_59,_5a).lineTo(_46.cx,_46.cy).closePath().setFill(this._pseudoRadialFill(_50,{x:_46.cx,y:_46.cy},r,_3f+(j+0.5)*_56,_3f+(j+0.5)*_56));}_54.createPath().moveTo(_46.cx,_46.cy).lineTo(x1,y1).arcTo(r,r,0,_52>Math.PI,true,x2,y2).lineTo(_46.cx,_46.cy).closePath().setStroke(_4f.series.stroke);_51=_54;}else{_51=s.createPath().moveTo(_46.cx,_46.cy).lineTo(x1,y1).arcTo(r,r,0,_52>Math.PI,true,x2,y2).lineTo(_46.cx,_46.cy).closePath().setStroke(_4f.series.stroke);_50=_4f.series.fill;if(_50&&_50.type==="radial"){_50=this._shapeFill(_50,{x:_46.cx-_46.r,y:_46.cy-_46.r,width:2*_46.r,height:2*_46.r});if(this.opt.radGrad==="linear"){_50=this._pseudoRadialFill(_50,{x:_46.cx,y:_46.cy},r,_3f,end);}}else{if(_50&&_50.type==="linear"){_50=this._plotFill(_50,dim,_3b);_50=this._shapeFill(_50,_51.getBoundingBox());}}_51.setFill(_50);}this.dyn.push({fill:_50,stroke:_4f.series.stroke});if(_45){o={element:"slice",index:i,run:this.run,shape:_51,x:i,y:typeof v=="number"?v:v.y,cx:_46.cx,cy:_46.cy,cr:r};this._connectEvents(o);_4d[i]=o;}_3f=end;return false;},this);if(this.opt.labels){var _5b=has("dojo-bidi")&&this.chart.isRightToLeft();if(this.opt.labelStyle=="default"){_3f=_3e;arr.some(_41,function(_5c,i){if(_5c<=0){return false;}var _5d=_49[i];if(_5c>=1){this.renderLabel(s,_46.cx,_46.cy+_3d/2,_42[i],_5d,this.opt.labelOffset>0);return true;}var end=_3f+_5c*2*Math.PI;if(i+1==_41.length){end=_3e+2*Math.PI;}if(this.opt.omitLabels&&end-_3f<0.001){return false;}var _5e=(_3f+end)/2,x=_46.cx+_44*Math.cos(_5e),y=_46.cy+_44*Math.sin(_5e)+_3d/2;this.renderLabel(s,_5b?dim.width-x:x,y,_42[i],_5d,this.opt.labelOffset>0);_3f=end;return false;},this);}else{if(this.opt.labelStyle=="columns"){_3f=_3e;var _5f=this.opt.omitLabels;var _60=[];arr.forEach(_41,function(_61,i){var end=_3f+_61*2*Math.PI;if(i+1==_41.length){end=_3e+2*Math.PI;}var _62=(_3f+end)/2;_60.push({angle:_62,left:Math.cos(_62)<0,theme:_49[i],index:i,omit:_5f?end-_3f<0.001:false});_3f=end;});var _63=g._base._getTextBox("a",{font:_3c}).h;this._getProperLabelRadius(_60,_63,_46.r*1.1);arr.forEach(_60,function(_64,i){if(!_64.omit){var _65=_46.cx-_46.r*2,_66=_46.cx+_46.r*2,_67=g._base._getTextBox(_42[i],{font:_64.theme.series.font}).w,x=_46.cx+_64.labelR*Math.cos(_64.angle),y=_46.cy+_64.labelR*Math.sin(_64.angle),_68=(_64.left)?(_65+_67):(_66-_67),_69=(_64.left)?_65:_68;var _6a=s.createPath().moveTo(_46.cx+_46.r*Math.cos(_64.angle),_46.cy+_46.r*Math.sin(_64.angle));if(Math.abs(_64.labelR*Math.cos(_64.angle))<_46.r*2-_67){_6a.lineTo(x,y);}_6a.lineTo(_68,y).setStroke(_64.theme.series.labelWiring);this.renderLabel(s,_5b?dim.width-_67-_69:_69,y,_42[i],_64.theme,false,"left");}},this);}}}var esi=0;this._eventSeries[this.run.name]=df.map(run,function(v){return v<=0?null:_4d[esi++];});if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_3b);}return this;},_getProperLabelRadius:function(_6b,_6c,_6d){var _6e,_6f,_70=1,_71=1;if(_6b.length==1){_6b[0].labelR=_6d;return;}for(var i=0;i<_6b.length;i++){var _72=Math.abs(Math.sin(_6b[i].angle));if(_6b[i].left){if(_70>=_72){_70=_72;_6e=_6b[i];}}else{if(_71>=_72){_71=_72;_6f=_6b[i];}}}_6e.labelR=_6f.labelR=_6d;this._calculateLabelR(_6e,_6b,_6c);this._calculateLabelR(_6f,_6b,_6c);},_calculateLabelR:function(_73,_74,_75){var i=_73.index,_76=_74.length,_77=_73.labelR,_78;while(!(_74[i%_76].left^_74[(i+1)%_76].left)){if(!_74[(i+1)%_76].omit){_78=(Math.sin(_74[i%_76].angle)*_77+((_74[i%_76].left)?(-_75):_75))/Math.sin(_74[(i+1)%_76].angle);_77=(_78<_73.labelR)?_73.labelR:_78;_74[(i+1)%_76].labelR=_77;}i++;}i=_73.index;var j=(i==0)?_76-1:i-1;while(!(_74[i].left^_74[j].left)){if(!_74[j].omit){_78=(Math.sin(_74[i].angle)*_77+((_74[i].left)?_75:(-_75)))/Math.sin(_74[j].angle);_77=(_78<_73.labelR)?_73.labelR:_78;_74[j].labelR=_77;}i--;j--;i=(i<0)?i+_74.length:i;j=(j<0)?j+_74.length:j;}}});});},"dijit/hccss":function(){define(["dojo/dom-class","dojo/hccss","dojo/domReady","dojo/_base/window"],function(_79,has,_7a,win){_7a(function(){if(has("highcontrast")){_79.add(win.body(),"dijit_a11y");}});return has;});},"dojox/charting/action2d/Shake":function(){define(["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojo/fx","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx"],function(hub,_7b,_7c,df,dfe,m,gf){var _7d=3;return _7b("dojox.charting.action2d.Shake",_7c,{defaultParams:{duration:400,easing:dfe.backOut,shiftX:_7d,shiftY:_7d},optionalParams:{},constructor:function(_7e,_7f,_80){if(!_80){_80={};}this.shiftX=typeof _80.shiftX=="number"?_80.shiftX:_7d;this.shiftY=typeof _80.shiftY=="number"?_80.shiftY:_7d;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}var _81=o.run.name,_82=o.index,_83=[],_84;if(_81 in this.anim){_84=this.anim[_81][_82];}else{this.anim[_81]={};}if(_84){_84.action.stop(true);}else{this.anim[_81][_82]=_84={};}var _85={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"translate",start:[this.shiftX,this.shiftY],end:[0,0]},m.identity]};if(o.shape){_83.push(gf.animateTransform(_85));}if(o.oultine){_85.shape=o.outline;_83.push(gf.animateTransform(_85));}if(o.shadow){_85.shape=o.shadow;_83.push(gf.animateTransform(_85));}if(!_83.length){delete this.anim[_81][_82];return;}_84.action=df.combine(_83);if(o.type=="onmouseout"){hub.connect(_84.action,"onEnd",this,function(){if(this.anim[_81]){delete this.anim[_81][_82];}});}_84.action.play();}});});},"dojox/lang/functional/lambda":function(){define(["../..","dojo/_base/lang","dojo/_base/array"],function(_86,_87,arr){var df=_87.getObject("lang.functional",true,_86);var _88={};var _89="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _8a=function(s){var _8b=[],_8c=_89.call(s,/\s*->\s*/m);if(_8c.length>1){while(_8c.length){s=_8c.pop();_8b=_8c.pop().split(/\s*,\s*|\s+/m);if(_8c.length){_8c.push("(function("+_8b.join(", ")+"){ return ("+s+"); })");}}}else{if(s.match(/\b_\b/)){_8b=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){_8b.push("$1");s="$1"+s;}if(r){_8b.push("$2");s=s+"$2";}}else{var _8d=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};arr.forEach(_8d,function(v){if(!t.hasOwnProperty(v)){_8b.push(v);t[v]=1;}});}}}return {args:_8b,body:s};};var _8e=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};_87.mixin(df,{rawLambda:function(s){return _8a(s);},buildLambda:function(s){var l=_8a(s);return "function("+l.args.join(",")+"){return ("+l.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _8e(s);}if(_88.hasOwnProperty(s)){return _88[s];}var l=_8a(s);return _88[s]=new Function(l.args,"return ("+l.body+");");},clearLambdaCache:function(){_88={};}});return df;});},"dojox/charting/plot2d/Candlesticks":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(_8f,_90,arr,has,_91,_92,dc,df,dfr,du,fx){var _93=dfr.lambda("item.purgeGroup()");return _90("dojox.charting.plot2d.Candlesticks",[_91,_92],{defaultParams:{gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_94,_95){this.opt=_8f.clone(this.defaultParams);du.updateWithObject(this.opt,_95);du.updateWithPattern(this.opt,_95,this.optionalParams);this.animate=this.opt.animate;},collectStats:function(_96){var _97=_8f.delegate(dc.defaultStats);for(var i=0;i<_96.length;i++){var run=_96[i];if(!run.data.length){continue;}var _98=_97.vmin,_99=_97.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_97.hmin=Math.min(_97.hmin,x);_97.hmax=Math.max(_97.hmax,x);_97.vmin=Math.min(_97.vmin,val.open,val.close,val.high,val.low);_97.vmax=Math.max(_97.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_97.vmin=Math.min(_98,run.ymin);}if("ymax" in run){_97.vmax=Math.max(_99,run.ymax);}}return _97;},getSeriesStats:function(){var _9a=this.collectStats(this.series);_9a.hmin-=0.5;_9a.hmax+=0.5;return _9a;},render:function(dim,_9b){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_9b);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_93);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(_9c){_9c.cleanGroup(s);});}var t=this.chart.theme,f,gap,_9d,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_9e=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_9d=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();s=run.group;var _9f=t.next("candlestick",[this.opt,run]),_a0=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _a1=t.addMixin(_9f,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_9b.l+gap,y=dim.height-_9b.b,_a2=vt(v.open),_a3=vt(v.close),_a4=vt(v.high),low=vt(v.low);if("mid" in v){var mid=vt(v.mid);}if(low>_a4){var tmp=_a4;_a4=low;low=tmp;}if(_9d>=1){var _a5=_a2>_a3;var _a6={x1:_9d/2,x2:_9d/2,y1:y-_a4,y2:y-low},_a7={x:0,y:y-Math.max(_a2,_a3),width:_9d,height:Math.max(_a5?_a2-_a3:_a3-_a2,1)};var _a8=s.createGroup();_a8.setTransform({dx:x,dy:0});var _a9=_a8.createGroup();_a9.createLine(_a6).setStroke(_a1.series.stroke);_a9.createRect(_a7).setStroke(_a1.series.stroke).setFill(_a5?_a1.series.fill:"white");if("mid" in v){_a9.createLine({x1:(_a1.series.stroke.width||1),x2:_9d-(_a1.series.stroke.width||1),y1:y-mid,y2:y-mid}).setStroke(_a5?"white":_a1.series.stroke);}run.dyn.fill=_a1.series.fill;run.dyn.stroke=_a1.series.stroke;if(_9e){var o={element:"candlestick",index:j,run:run,shape:_a9,x:x,y:y-Math.max(_a2,_a3),cx:_9d/2,cy:(y-Math.max(_a2,_a3))+(Math.max(_a5?_a2-_a3:_a3-_a2,1)/2),width:_9d,height:Math.max(_a5?_a2-_a3:_a3-_a2,1),data:v};this._connectEvents(o);_a0[j]=o;}}if(this.animate){this._animateCandlesticks(_a8,y-low,_a4-low);}}}this._eventSeries[run.name]=_a0;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_9b);}return this;},tooltipFunc:function(o){return "<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\" style=\"font-size:0.9em;\">"+"<tr><td>Open:</td><td align=\"right\"><strong>"+o.data.open+"</strong></td></tr>"+"<tr><td>High:</td><td align=\"right\"><strong>"+o.data.high+"</strong></td></tr>"+"<tr><td>Low:</td><td align=\"right\"><strong>"+o.data.low+"</strong></td></tr>"+"<tr><td>Close:</td><td align=\"right\"><strong>"+o.data.close+"</strong></td></tr>"+(o.data.mid!==undefined?"<tr><td>Mid:</td><td align=\"right\"><strong>"+o.data.mid+"</strong></td></tr>":"")+"</table>";},_animateCandlesticks:function(_aa,_ab,_ac){fx.animateTransform(_8f.delegate({shape:_aa,duration:1200,transform:[{name:"translate",start:[0,_ab-(_ab/_ac)],end:[0,0]},{name:"scale",start:[1,1/_ac],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/reversed":function(){define(["dojo/_base/lang","dojo/_base/kernel","./lambda"],function(_ad,_ae,df){_ad.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ae.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});return df;});},"dojox/charting/scaler/primitive":function(){define(["dojo/_base/lang"],function(_af){var _b0=_af.getObject("dojox.charting.scaler.primitive",true);return _af.mixin(_b0,{buildScaler:function(min,max,_b1,_b2){if(min==max){min-=0.5;max+=0.5;}return {bounds:{lower:min,upper:max,from:min,to:max,scale:_b1/(max-min),span:_b1},scaler:_b0};},buildTicks:function(_b3,_b4){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_b5){var _b6=_b5.bounds.from,_b7=_b5.bounds.scale;return function(x){return (x-_b6)*_b7;};},getTransformerFromPlot:function(_b8){var _b9=_b8.bounds.from,_ba=_b8.bounds.scale;return function(x){return x/_ba+_b9;};}});});},"dojox/charting/widget/Sparkline":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/query","./Chart","../themes/GreySkies","../plot2d/Lines","dojo/dom-prop"],function(_bb,_bc,_bd,_be,_bf,_c0,_c1){_bc("dojox.charting.widget.Sparkline",_be,{theme:_bf,margins:{l:0,r:0,t:0,b:0},type:"Lines",valueFn:"Number(x)",store:"",field:"",query:"",queryOptions:"",start:"0",count:"Infinity",sort:"",data:"",name:"default",buildRendering:function(){var n=this.srcNodeRef;if(!n.childNodes.length||!_bd("> .axis, > .plot, > .action, > .series",n).length){var _c2=document.createElement("div");_c1.set(_c2,{"class":"plot","name":"default","type":this.type});n.appendChild(_c2);var _c3=document.createElement("div");_c1.set(_c3,{"class":"series",plot:"default",name:this.name,start:this.start,count:this.count,valueFn:this.valueFn});_bb.forEach(["store","field","query","queryOptions","sort","data"],function(i){if(this[i].length){_c1.set(_c3,i,this[i]);}},this);n.appendChild(_c3);}this.inherited(arguments);}});});},"dojox/gfx/matrix":function(){define(["./_base","dojo/_base/lang"],function(g,_c4){var m=g.matrix={};var _c5={};m._degToRad=function(_c6){return _c5[_c6]||(_c5[_c6]=(Math.PI*_c6/180));};m._radToDeg=function(_c7){return _c7/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else{if(arg instanceof Array){if(arg.length>0){var _c8=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=_c8,r=m.normalize(arg[i]);_c8=new m.Matrix2D();_c8.xx=l.xx*r.xx+l.xy*r.yx;_c8.xy=l.xx*r.xy+l.xy*r.yy;_c8.yx=l.yx*r.xx+l.yy*r.yx;_c8.yy=l.yx*r.xy+l.yy*r.yy;_c8.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_c8.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}_c4.mixin(this,_c8);}}else{_c4.mixin(this,arg);}}}};_c4.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});_c4.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_c9){var c=Math.cos(_c9);var s=Math.sin(_c9);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_ca){return m.rotate(m._degToRad(_ca));},skewX:function(_cb){return new m.Matrix2D({xy:Math.tan(_cb)});},skewXg:function(_cc){return m.skewX(m._degToRad(_cc));},skewY:function(_cd){return new m.Matrix2D({yx:Math.tan(_cd)});},skewYg:function(_ce){return m.skewY(m._degToRad(_ce));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_cf){return (_cf instanceof m.Matrix2D)?_cf:new m.Matrix2D(_cf);},isIdentity:function(_d0){return _d0.xx==1&&_d0.xy==0&&_d0.yx==0&&_d0.yy==1&&_d0.dx==0&&_d0.dy==0;},clone:function(_d1){var obj=new m.Matrix2D();for(var i in _d1){if(typeof (_d1[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_d1[i]){obj[i]=_d1[i];}}return obj;},invert:function(_d2){var M=m.normalize(_d2),D=M.xx*M.yy-M.xy*M.yx;M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_d3,x,y){return {x:_d3.xx*x+_d3.xy*y+_d3.dx,y:_d3.yx*x+_d3.yy*y+_d3.dy};},multiplyPoint:function(_d4,a,b){var M=m.normalize(_d4);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiplyRectangle:function(_d5,_d6){var M=m.normalize(_d5);_d6=_d6||{x:0,y:0,width:0,height:0};if(m.isIdentity(M)){return {x:_d6.x,y:_d6.y,width:_d6.width,height:_d6.height};}var p0=m.multiplyPoint(M,_d6.x,_d6.y),p1=m.multiplyPoint(M,_d6.x,_d6.y+_d6.height),p2=m.multiplyPoint(M,_d6.x+_d6.width,_d6.y),p3=m.multiplyPoint(M,_d6.x+_d6.width,_d6.y+_d6.height),_d7=Math.min(p0.x,p1.x,p2.x,p3.x),_d8=Math.min(p0.y,p1.y,p2.y,p3.y),_d9=Math.max(p0.x,p1.x,p2.x,p3.x),_da=Math.max(p0.y,p1.y,p2.y,p3.y);return {x:_d7,y:_d8,width:_d9-_d7,height:_da-_d8};},multiply:function(_db){var M=m.normalize(_db);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_dc,x,y){return m.multiply(m.translate(x,y),_dc,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_dd,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_dd),a,b);}return m._sandwich(m.rotate(_dd),a.x,a.y);},rotategAt:function(_de,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_de),a,b);}return m._sandwich(m.rotateg(_de),a.x,a.y);},skewXAt:function(_df,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_df),a,b);}return m._sandwich(m.skewX(_df),a.x,a.y);},skewXgAt:function(_e0,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_e0),a,b);}return m._sandwich(m.skewXg(_e0),a.x,a.y);},skewYAt:function(_e1,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_e1),a,b);}return m._sandwich(m.skewY(_e1),a.x,a.y);},skewYgAt:function(_e2,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_e2),a,b);}return m._sandwich(m.skewYg(_e2),a.x,a.y);}});g.Matrix2D=m.Matrix2D;return m;});},"dojox/charting/plot2d/Scatter":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx","dojox/gfx/gradutils"],function(_e3,arr,_e4,has,_e5,_e6,dc,df,dfr,du,fx,_e7){var _e8=dfr.lambda("item.purgeGroup()");return _e4("dojox.charting.plot2d.Scatter",[_e5,_e6],{defaultParams:{shadows:null,animate:null},optionalParams:{markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:"",styleFunc:null},constructor:function(_e9,_ea){this.opt=_e3.clone(_e3.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_ea);du.updateWithPattern(this.opt,_ea,this.optionalParams);this.animate=this.opt.animate;},render:function(dim,_eb){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_eb);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_e8);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(_ec){_ec.cleanGroup(s);});}var t=this.chart.theme,_ed=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}var _ee=t.next("marker",[this.opt,run]),_ef,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);s=run.group;if(typeof run.data[0]=="number"){_ef=arr.map(run.data,function(v,i){return {x:ht(i+1)+_eb.l,y:dim.height-_eb.b-vt(v)};},this);}else{_ef=arr.map(run.data,function(v,i){return {x:ht(v.x)+_eb.l,y:dim.height-_eb.b-vt(v.y)};},this);}var _f0=new Array(_ef.length),_f1=new Array(_ef.length),_f2=new Array(_ef.length);arr.forEach(_ef,function(c,i){var _f3=run.data[i],_f4;if(this.opt.styleFunc||typeof _f3!="number"){var _f5=typeof _f3!="number"?[_f3]:[];if(this.opt.styleFunc){_f5.push(this.opt.styleFunc(_f3));}_f4=t.addMixin(_ee,"marker",_f5,true);}else{_f4=t.post(_ee,"marker");}var _f6="M"+c.x+" "+c.y+" "+_f4.symbol;if(_f4.marker.shadow){_f0[i]=s.createPath("M"+(c.x+_f4.marker.shadow.dx)+" "+(c.y+_f4.marker.shadow.dy)+" "+_f4.symbol).setStroke(_f4.marker.shadow).setFill(_f4.marker.shadow.color);if(this.animate){this._animateScatter(_f0[i],dim.height-_eb.b);}}if(_f4.marker.outline){var _f7=dc.makeStroke(_f4.marker.outline);_f7.width=2*_f7.width+_f4.marker.stroke.width;_f2[i]=s.createPath(_f6).setStroke(_f7);if(this.animate){this._animateScatter(_f2[i],dim.height-_eb.b);}}var _f8=dc.makeStroke(_f4.marker.stroke),_f9=this._plotFill(_f4.marker.fill,dim,_eb);if(_f9&&(_f9.type==="linear"||_f9.type=="radial")){var _fa=_e7.getColor(_f9,{x:c.x,y:c.y});if(_f8){_f8.color=_fa;}_f1[i]=s.createPath(_f6).setStroke(_f8).setFill(_fa);}else{_f1[i]=s.createPath(_f6).setStroke(_f8).setFill(_f9);}if(this.opt.labels){var _fb=_f1[i].getBoundingBox();this.createLabel(s,_f3,_fb,_f4);}if(this.animate){this._animateScatter(_f1[i],dim.height-_eb.b);}},this);if(_f1.length){run.dyn.marker=_ee.symbol;run.dyn.markerStroke=_f1[_f1.length-1].getStroke();run.dyn.markerFill=_f1[_f1.length-1].getFill();}if(_ed){var _fc=new Array(_f1.length);arr.forEach(_f1,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:_f2&&_f2[i]||null,shadow:_f0&&_f0[i]||null,cx:_ef[i].x,cy:_ef[i].y};if(typeof run.data[0]=="number"){o.x=i+1;o.y=run.data[i];}else{o.x=run.data[i].x;o.y=run.data[i].y;}this._connectEvents(o);_fc[i]=o;},this);this._eventSeries[run.name]=_fc;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_eb);}return this;},_animateScatter:function(_fd,_fe){fx.animateTransform(_e3.delegate({shape:_fd,duration:1200,transform:[{name:"translate",start:[0,_fe],end:[0,0]},{name:"scale",start:[0,0],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/scan":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_ff,lang,df){var _100={};lang.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_ff.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _100)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ff.global;f=df.lambda(f);var t,n,z,_101=true;if(lang.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(i in a){if(!(i in _100)){if(_101){t=[z=a[i]];_101=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_ff.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_ff.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});});},"dijit/Viewport":function(){define(["dojo/Evented","dojo/on","dojo/domReady","dojo/sniff","dojo/window"],function(_102,on,_103,has,_104){var _105=new _102();var _106;_103(function(){var _107=_104.getBox();_105._rlh=on(window,"resize",function(){var _108=_104.getBox();if(_107.h==_108.h&&_107.w==_108.w){return;}_107=_108;_105.emit("resize");});if(has("ie")==8){var _109=screen.deviceXDPI;setInterval(function(){if(screen.deviceXDPI!=_109){_109=screen.deviceXDPI;_105.emit("resize");}},500);}if(has("ios")){on(document,"focusin",function(evt){_106=evt.target;});on(document,"focusout",function(evt){_106=null;});}});_105.getEffectiveBox=function(doc){var box=_104.getBox(doc);var tag=_106&&_106.tagName&&_106.tagName.toLowerCase();if(has("ios")&&_106&&!_106.readOnly&&(tag=="textarea"||(tag=="input"&&/^(color|email|number|password|search|tel|text|url)$/.test(_106.type)))){box.h*=(orientation==0||orientation==180?0.66:0.4);var rect=_106.getBoundingClientRect();box.h=Math.max(box.h,rect.top+rect.height);}return box;};return _105;});},"dojox/color/_base":function(){define(["../main","dojo/_base/lang","dojo/_base/Color","dojo/colors"],function(_10a,lang,_10b,_10c){var cx=lang.getObject("color",true,_10a);cx.Color=_10b;cx.blend=_10b.blendColors;cx.fromRgb=_10b.fromRgb;cx.fromHex=_10b.fromHex;cx.fromArray=_10b.fromArray;cx.fromString=_10b.fromString;cx.greyscale=_10c.makeGrey;lang.mixin(cx,{fromCmy:function(cyan,_10d,_10e){if(lang.isArray(cyan)){_10d=cyan[1],_10e=cyan[2],cyan=cyan[0];}else{if(lang.isObject(cyan)){_10d=cyan.m,_10e=cyan.y,cyan=cyan.c;}}cyan/=100,_10d/=100,_10e/=100;var r=1-cyan,g=1-_10d,b=1-_10e;return new _10b({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,_10f,_110,_111){if(lang.isArray(cyan)){_10f=cyan[1],_110=cyan[2],_111=cyan[3],cyan=cyan[0];}else{if(lang.isObject(cyan)){_10f=cyan.m,_110=cyan.y,_111=cyan.b,cyan=cyan.c;}}cyan/=100,_10f/=100,_110/=100,_111/=100;var r,g,b;r=1-Math.min(1,cyan*(1-_111)+_111);g=1-Math.min(1,_10f*(1-_111)+_111);b=1-Math.min(1,_110*(1-_111)+_111);return new _10b({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_112,_113){if(lang.isArray(hue)){_112=hue[1],_113=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_112=hue.s,_113=hue.l,hue=hue.h;}}_112/=100;_113/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_112*Math.min(r,1)+(1-_112);g=2*_112*Math.min(g,1)+(1-_112);b=2*_112*Math.min(b,1)+(1-_112);if(_113<0.5){r*=_113,g*=_113,b*=_113;}else{r=(1-_113)*r+2*_113-1;g=(1-_113)*g+2*_113-1;b=(1-_113)*b+2*_113-1;}return new _10b({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});cx.fromHsv=function(hue,_114,_115){if(lang.isArray(hue)){_114=hue[1],_115=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_114=hue.s,_115=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_114/=100;_115/=100;var r,g,b;if(_114==0){r=_115,b=_115,g=_115;}else{var _116=hue/60,i=Math.floor(_116),f=_116-i;var p=_115*(1-_114);var q=_115*(1-(_114*f));var t=_115*(1-(_114*(1-f)));switch(i){case 0:r=_115,g=t,b=p;break;case 1:r=q,g=_115,b=p;break;case 2:r=p,g=_115,b=t;break;case 3:r=p,g=q,b=_115;break;case 4:r=t,g=p,b=_115;break;case 5:r=_115,g=p,b=q;break;}}return new _10b({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});};lang.extend(_10b,{toCmy:function(){var cyan=1-(this.r/255),_117=1-(this.g/255),_118=1-(this.b/255);return {c:Math.round(cyan*100),m:Math.round(_117*100),y:Math.round(_118*100)};},toCmyk:function(){var cyan,_119,_11a,_11b;var r=this.r/255,g=this.g/255,b=this.b/255;_11b=Math.min(1-r,1-g,1-b);cyan=(1-r-_11b)/(1-_11b);_119=(1-g-_11b)/(1-_11b);_11a=(1-b-_11b)/(1-_11b);return {c:Math.round(cyan*100),m:Math.round(_119*100),y:Math.round(_11a*100),b:Math.round(_11b*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _11c=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_11c/((l<0.5)?(2*l):(2-2*l));}if(_11c>0){if(max==r&&max!=g){h+=(g-b)/_11c;}if(max==g&&max!=b){h+=(2+(b-r)/_11c);}if(max==b&&max!=r){h+=(4+(r-g)/_11c);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _11d=max-min;var h=null,s=(max==0)?0:(_11d/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_11d;}else{if(g==max){h=120+60*(b-r)/_11d;}else{h=240+60*(r-g)/_11d;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});return cx;});},"dojox/charting/plot2d/OHLC":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_11e,has,_11f,_120,dc,df,dfr,du,fx){var _121=dfr.lambda("item.purgeGroup()");return _11e("dojox.charting.plot2d.OHLC",[_11f,_120],{defaultParams:{gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(_122,_123){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_123);du.updateWithPattern(this.opt,_123,this.optionalParams);this.animate=this.opt.animate;},collectStats:function(_124){var _125=lang.delegate(dc.defaultStats);for(var i=0;i<_124.length;i++){var run=_124[i];if(!run.data.length){continue;}var _126=_125.vmin,_127=_125.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;_125.hmin=Math.min(_125.hmin,x);_125.hmax=Math.max(_125.hmax,x);_125.vmin=Math.min(_125.vmin,val.open,val.close,val.high,val.low);_125.vmax=Math.max(_125.vmax,val.open,val.close,val.high,val.low);}});}if("ymin" in run){_125.vmin=Math.min(_126,run.ymin);}if("ymax" in run){_125.vmax=Math.max(_127,run.ymax);}}return _125;},getSeriesStats:function(){var _128=this.collectStats(this.series);_128.hmin-=0.5;_128.hmax+=0.5;return _128;},render:function(dim,_129){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_129);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_121);this._eventSeries={};this.cleanGroup();var s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,f,gap,_12a,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_12b=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;_12a=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();var _12c=t.next("candlestick",[this.opt,run]),s=run.group,_12d=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var _12e=t.addMixin(_12c,"candlestick",v,true);var x=ht(v.x||(j+0.5))+_129.l+gap,y=dim.height-_129.b,open=vt(v.open),_12f=vt(v.close),high=vt(v.high),low=vt(v.low);if(low>high){var tmp=high;high=low;low=tmp;}if(_12a>=1){var hl={x1:_12a/2,x2:_12a/2,y1:y-high,y2:y-low},op={x1:0,x2:((_12a/2)+((_12e.series.stroke.width||1)/2)),y1:y-open,y2:y-open},cl={x1:((_12a/2)-((_12e.series.stroke.width||1)/2)),x2:_12a,y1:y-_12f,y2:y-_12f};var _130=s.createGroup();_130.setTransform({dx:x,dy:0});var _131=_130.createGroup();_131.createLine(hl).setStroke(_12e.series.stroke);_131.createLine(op).setStroke(_12e.series.stroke);_131.createLine(cl).setStroke(_12e.series.stroke);run.dyn.stroke=_12e.series.stroke;if(_12b){var o={element:"candlestick",index:j,run:run,shape:_131,x:x,y:y-Math.max(open,_12f),cx:_12a/2,cy:(y-Math.max(open,_12f))+(Math.max(open>_12f?open-_12f:_12f-open,1)/2),width:_12a,height:Math.max(open>_12f?open-_12f:_12f-open,1),data:v};this._connectEvents(o);_12d[j]=o;}}if(this.animate){this._animateOHLC(_130,y-low,high-low);}}}this._eventSeries[run.name]=_12d;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_129);}return this;},_animateOHLC:function(_132,_133,_134){fx.animateTransform(lang.delegate({shape:_132,duration:1200,transform:[{name:"translate",start:[0,_133-(_133/_134)],end:[0,0]},{name:"scale",start:[1,1/_134],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/a11yclick":function(){define(["dojo/keys","dojo/mouse","dojo/on","dojo/touch"],function(keys,_135,on,_136){function _137(e){if((e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!/input|button|textarea/i.test(e.target.nodeName)){for(var node=e.target;node;node=node.parentNode){if(node.dojoClick){return true;}}}};var _138;on(document,"keydown",function(e){if(_137(e)){_138=e.target;e.preventDefault();}else{_138=null;}});on(document,"keyup",function(e){if(_137(e)&&e.target==_138){_138=null;on.emit(e.target,"click",{cancelable:true,bubbles:true,ctrlKey:e.ctrlKey,shiftKey:e.shiftKey,metaKey:e.metaKey,altKey:e.altKey,_origType:e.type});}});var _139=function(node,_13a){node.dojoClick=true;return on(node,"click",_13a);};_139.click=_139;_139.press=function(node,_13b){var _13c=on(node,_136.press,function(evt){if(evt.type=="mousedown"&&!_135.isLeft(evt)){return;}_13b(evt);}),_13d=on(node,"keydown",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_13b(evt);}});return {remove:function(){_13c.remove();_13d.remove();}};};_139.release=function(node,_13e){var _13f=on(node,_136.release,function(evt){if(evt.type=="mouseup"&&!_135.isLeft(evt)){return;}_13e(evt);}),_140=on(node,"keyup",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_13e(evt);}});return {remove:function(){_13f.remove();_140.remove();}};};_139.move=_136.move;return _139;});},"dojox/charting/plot2d/ClusteredColumns":function(){define(["dojo/_base/declare","./Columns","./common"],function(_141,_142,dc){return _141("dojox.charting.plot2d.ClusteredColumns",_142,{getBarProperties:function(){var f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,this.series.length);return {gap:f.gap,width:f.size,thickness:f.size};}});});},"dojox/charting/Chart":function(){define(["../main","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/dom-style","dojo/dom","dojo/dom-geometry","dojo/dom-construct","dojo/_base/Color","dojo/sniff","./Element","./SimpleTheme","./Series","./axis2d/common","dojox/gfx/shape","dojox/gfx","dojo/has!dojo-bidi?./bidi/Chart","dojox/lang/functional","dojox/lang/functional/fold","dojox/lang/functional/reversed"],function(_143,lang,arr,_144,_145,dom,_146,_147,_148,has,_149,_14a,_14b,_14c,_14d,g,_14e,func){var dc=lang.getObject("charting",true,_143),_14f=func.lambda("item.clear()"),_150=func.lambda("item.purgeGroup()"),_151=func.lambda("item.destroy()"),_152=func.lambda("item.dirty = false"),_153=func.lambda("item.dirty = true"),_154=func.lambda("item.name");var _155=_144(has("dojo-bidi")?"dojox.charting.NonBidiChart":"dojox.charting.Chart",null,{constructor:function(node,_156){if(!_156){_156={};}this.margins=_156.margins?_156.margins:{l:10,t:10,r:10,b:10};this.stroke=_156.stroke;this.fill=_156.fill;this.delayInMs=_156.delayInMs||200;this.title=_156.title;this.titleGap=_156.titleGap;this.titlePos=_156.titlePos;this.titleFont=_156.titleFont;this.titleFontColor=_156.titleFontColor;this.chartTitle=null;this.htmlLabels=true;if("htmlLabels" in _156){this.htmlLabels=_156.htmlLabels;}this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.node=dom.byId(node);var box=_146.getMarginBox(node);this.surface=g.createSurface(this.node,box.w||400,box.h||300);if(this.surface.declaredClass.indexOf("vml")==-1){this._nativeClip=true;}},destroy:function(){arr.forEach(this.series,_151);arr.forEach(this.stack,_151);func.forIn(this.axes,_151);this.surface.destroy();if(this.chartTitle&&this.chartTitle.tagName){_147.destroy(this.chartTitle);}},getCoords:function(){var node=this.node;var s=_145.getComputedStyle(node),_157=_146.getMarginBox(node,s);var abs=_146.position(node,true);_157.x=abs.x;_157.y=abs.y;return _157;},setTheme:function(_158){this.theme=_158.clone();this.dirty=true;return this;},addAxis:function(name,_159){var axis,_15a=_159&&_159.type||"Default";if(typeof _15a=="string"){if(!dc.axis2d||!dc.axis2d[_15a]){throw Error("Can't find axis: "+_15a+" - Check "+"require() dependencies.");}axis=new dc.axis2d[_15a](this,_159);}else{axis=new _15a(this,_159);}axis.name=name;axis.dirty=true;if(name in this.axes){this.axes[name].destroy();}this.axes[name]=axis;this.dirty=true;return this;},getAxis:function(name){return this.axes[name];},removeAxis:function(name){if(name in this.axes){this.axes[name].destroy();delete this.axes[name];this.dirty=true;}return this;},addPlot:function(name,_15b){var plot,_15c=_15b&&_15b.type||"Default";if(typeof _15c=="string"){if(!dc.plot2d||!dc.plot2d[_15c]){throw Error("Can't find plot: "+_15c+" - didn't you forget to dojo"+".require() it?");}plot=new dc.plot2d[_15c](this,_15b);}else{plot=new _15c(this,_15b);}plot.name=name;plot.dirty=true;if(name in this.plots){this.stack[this.plots[name]].destroy();this.stack[this.plots[name]]=plot;}else{this.plots[name]=this.stack.length;this.stack.push(plot);}this.dirty=true;return this;},getPlot:function(name){return this.stack[this.plots[name]];},removePlot:function(name){if(name in this.plots){var _15d=this.plots[name];delete this.plots[name];this.stack[_15d].destroy();this.stack.splice(_15d,1);func.forIn(this.plots,function(idx,name,_15e){if(idx>_15d){_15e[name]=idx-1;}});var ns=arr.filter(this.series,function(run){return run.plot!=name;});if(ns.length<this.series.length){arr.forEach(this.series,function(run){if(run.plot==name){run.destroy();}});this.runs={};arr.forEach(ns,function(run,_15f){this.runs[run.plot]=_15f;},this);this.series=ns;}this.dirty=true;}return this;},getPlotOrder:function(){return func.map(this.stack,_154);},setPlotOrder:function(_160){var _161={},_162=func.filter(_160,function(name){if(!(name in this.plots)||(name in _161)){return false;}_161[name]=1;return true;},this);if(_162.length<this.stack.length){func.forEach(this.stack,function(plot){var name=plot.name;if(!(name in _161)){_162.push(name);}});}var _163=func.map(_162,function(name){return this.stack[this.plots[name]];},this);func.forEach(_163,function(plot,i){this.plots[plot.name]=i;},this);this.stack=_163;this.dirty=true;return this;},movePlotToFront:function(name){if(name in this.plots){var _164=this.plots[name];if(_164){var _165=this.getPlotOrder();_165.splice(_164,1);_165.unshift(name);return this.setPlotOrder(_165);}}return this;},movePlotToBack:function(name){if(name in this.plots){var _166=this.plots[name];if(_166<this.stack.length-1){var _167=this.getPlotOrder();_167.splice(_166,1);_167.push(name);return this.setPlotOrder(_167);}}return this;},addSeries:function(name,data,_168){var run=new _14b(this,data,_168);run.name=name;if(name in this.runs){this.series[this.runs[name]].destroy();this.series[this.runs[name]]=run;}else{this.runs[name]=this.series.length;this.series.push(run);}this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},getSeries:function(name){return this.series[this.runs[name]];},removeSeries:function(name){if(name in this.runs){var _169=this.runs[name];delete this.runs[name];this.series[_169].destroy();this.series.splice(_169,1);func.forIn(this.runs,function(idx,name,runs){if(idx>_169){runs[name]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(name,data,_16a){if(name in this.runs){var run=this.series[this.runs[name]];run.update(data);if(_16a){this.dirty=true;}else{this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}}return this;},getSeriesOrder:function(_16b){return func.map(func.filter(this.series,function(run){return run.plot==_16b;}),_154);},setSeriesOrder:function(_16c){var _16d,_16e={},_16f=func.filter(_16c,function(name){if(!(name in this.runs)||(name in _16e)){return false;}var run=this.series[this.runs[name]];if(_16d){if(run.plot!=_16d){return false;}}else{_16d=run.plot;}_16e[name]=1;return true;},this);func.forEach(this.series,function(run){var name=run.name;if(!(name in _16e)&&run.plot==_16d){_16f.push(name);}});var _170=func.map(_16f,function(name){return this.series[this.runs[name]];},this);this.series=_170.concat(func.filter(this.series,function(run){return run.plot!=_16d;}));func.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(name){if(name in this.runs){var _171=this.runs[name],_172=this.getSeriesOrder(this.series[_171].plot);if(name!=_172[0]){_172.splice(_171,1);_172.unshift(name);return this.setSeriesOrder(_172);}}return this;},moveSeriesToBack:function(name){if(name in this.runs){var _173=this.runs[name],_174=this.getSeriesOrder(this.series[_173].plot);if(name!=_174[_174.length-1]){_174.splice(_173,1);_174.push(name);return this.setSeriesOrder(_174);}}return this;},resize:function(_175,_176){switch(arguments.length){case 1:_146.setMarginBox(this.node,_175);break;case 2:_146.setMarginBox(this.node,{w:_175,h:_176});break;}var box=_146.getMarginBox(this.node);var d=this.surface.getDimensions();if(d.width!=box.w||d.height!=box.h){this.surface.setDimensions(box.w,box.h);this.dirty=true;return this.render();}else{return this;}},getGeometry:function(){var ret={};func.forIn(this.axes,function(axis){if(axis.initialized()){ret[axis.name]={name:axis.name,vertical:axis.vertical,scaler:axis.scaler,ticks:axis.ticks};}});return ret;},setAxisWindow:function(name,_177,_178,zoom){var axis=this.axes[name];if(axis){axis.setWindow(_177,_178);arr.forEach(this.stack,function(plot){if(plot.hAxis==name||plot.vAxis==name){plot.zoom=zoom;}});}return this;},setWindow:function(sx,sy,dx,dy,zoom){if(!("plotArea" in this)){this.calculateGeometry();}func.forIn(this.axes,function(axis){var _179,_17a,_17b=axis.getScaler().bounds,s=_17b.span/(_17b.upper-_17b.lower);if(axis.vertical){_179=sy;_17a=dy/s/_179;}else{_179=sx;_17a=dx/s/_179;}axis.setWindow(_179,_17a);});arr.forEach(this.stack,function(plot){plot.zoom=zoom;});return this;},zoomIn:function(name,_17c,_17d){var axis=this.axes[name];if(axis){var _17e,_17f,_180=axis.getScaler().bounds;var _181=Math.min(_17c[0],_17c[1]);var _182=Math.max(_17c[0],_17c[1]);_181=_17c[0]<_180.lower?_180.lower:_181;_182=_17c[1]>_180.upper?_180.upper:_182;_17e=(_180.upper-_180.lower)/(_182-_181);_17f=_181-_180.lower;this.setAxisWindow(name,_17e,_17f);if(_17d){this.delayedRender();}else{this.render();}}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}var _183=arr.filter(this.stack,function(plot){return plot.dirty||(plot.hAxis&&this.axes[plot.hAxis].dirty)||(plot.vAxis&&this.axes[plot.vAxis].dirty);},this);_184(_183,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();arr.forEach(this.stack,_14f);if(!this.theme){this.setTheme(new _14a());}arr.forEach(this.series,function(run){if(!(run.plot in this.plots)){if(!dc.plot2d||!dc.plot2d.Default){throw Error("Can't find plot: Default - didn't you forget to dojo"+".require() it?");}var plot=new dc.plot2d.Default(this,{});plot.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(plot);}this.stack[this.plots[run.plot]].addSeries(run);},this);arr.forEach(this.stack,function(plot){if(plot.assignAxes){plot.assignAxes(this.axes);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=g.normalizedLength(dim.width);dim.height=g.normalizedLength(dim.height);func.forIn(this.axes,_14f);_184(this.stack,dim);var _185=this.offsets={l:0,r:0,t:0,b:0};var self=this;func.forIn(this.axes,function(axis){if(has("dojo-bidi")){self._resetLeftBottom(axis);}func.forIn(axis.getOffsets(),function(o,i){_185[i]=Math.max(o,_185[i]);});});if(this.title){this.titleGap=(this.titleGap==0)?0:this.titleGap||this.theme.chart.titleGap||20;this.titlePos=this.titlePos||this.theme.chart.titlePos||"top";this.titleFont=this.titleFont||this.theme.chart.titleFont;this.titleFontColor=this.titleFontColor||this.theme.chart.titleFontColor||"black";var _186=g.normalizedLength(g.splitFontString(this.titleFont).size);_185[this.titlePos=="top"?"t":"b"]+=(_186+this.titleGap);}func.forIn(this.margins,function(o,i){_185[i]+=o;});this.plotArea={width:dim.width-_185.l-_185.r,height:dim.height-_185.t-_185.b};func.forIn(this.axes,_14f);_184(this.stack,this.plotArea);return this;},render:function(){if(this._delayedRenderHandle){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;}if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();func.forEachRev(this.stack,function(plot){plot.render(this.dim,this.offsets);},this);func.forIn(this.axes,function(axis){axis.render(this.dim,this.offsets);},this);this._makeClean();return this;},fullRender:function(){this.fullGeometry();var _187=this.offsets,dim=this.dim;var w=Math.max(0,dim.width-_187.l-_187.r),h=Math.max(0,dim.height-_187.t-_187.b);arr.forEach(this.series,_150);func.forIn(this.axes,_150);arr.forEach(this.stack,_150);var _188=this.surface.children;if(_14d.dispose){for(var i=0;i<_188.length;++i){_14d.dispose(_188[i]);}}if(this.chartTitle&&this.chartTitle.tagName){_147.destroy(this.chartTitle);}this.surface.clear();this.chartTitle=null;this._renderChartBackground(dim,_187);if(this._nativeClip){this._renderPlotBackground(dim,_187,w,h);}else{this._renderPlotBackground(dim,_187,w,h);}func.foldr(this.stack,function(z,plot){return plot.render(dim,_187),0;},0);if(!this._nativeClip){this._renderChartBackground(dim,_187);}if(this.title){var _189=(g.renderer=="canvas")&&this.htmlLabels,_18a=_189||!has("ie")&&!has("opera")&&this.htmlLabels?"html":"gfx",_18b=g.normalizedLength(g.splitFontString(this.titleFont).size);this.chartTitle=_14c.createText[_18a](this,this.surface,dim.width/2,this.titlePos=="top"?_18b+this.margins.t:dim.height-this.margins.b,"middle",this.title,this.titleFont,this.titleFontColor);}func.forIn(this.axes,function(axis){axis.render(dim,_187);});this._makeClean();return this;},_renderChartBackground:function(dim,_18c){var t=this.theme,rect;var fill=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);var _18d=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(fill=="inherit"){var node=this.node;fill=new _148(_145.get(node,"backgroundColor"));while(fill.a==0&&node!=document.documentElement){fill=new _148(_145.get(node,"backgroundColor"));node=node.parentNode;}}if(fill){if(this._nativeClip){fill=_149.prototype._shapeFill(_149.prototype._plotFill(fill,dim),{x:0,y:0,width:dim.width+1,height:dim.height+1});this.surface.createRect({width:dim.width+1,height:dim.height+1}).setFill(fill);}else{fill=_149.prototype._plotFill(fill,dim,_18c);if(_18c.l){rect={x:0,y:0,width:_18c.l,height:dim.height+1};this.surface.createRect(rect).setFill(_149.prototype._shapeFill(fill,rect));}if(_18c.r){rect={x:dim.width-_18c.r,y:0,width:_18c.r+1,height:dim.height+2};this.surface.createRect(rect).setFill(_149.prototype._shapeFill(fill,rect));}if(_18c.t){rect={x:0,y:0,width:dim.width+1,height:_18c.t};this.surface.createRect(rect).setFill(_149.prototype._shapeFill(fill,rect));}if(_18c.b){rect={x:0,y:dim.height-_18c.b,width:dim.width+1,height:_18c.b+2};this.surface.createRect(rect).setFill(_149.prototype._shapeFill(fill,rect));}}}if(_18d){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_18d);}},_renderPlotBackground:function(dim,_18e,w,h){var t=this.theme;var fill=t.plotarea&&t.plotarea.fill;var _18f=t.plotarea&&t.plotarea.stroke;var rect={x:_18e.l-1,y:_18e.t-1,width:w+2,height:h+2};if(fill){fill=_149.prototype._shapeFill(_149.prototype._plotFill(fill,dim,_18e),rect);this.surface.createRect(rect).setFill(fill);}if(_18f){this.surface.createRect({x:_18e.l,y:_18e.t,width:w+1,height:h+1}).setStroke(_18f);}},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(lang.hitch(this,function(){this.render();}),this.delayInMs);}return this;},connectToPlot:function(name,_190,_191){return name in this.plots?this.stack[this.plots[name]].connect(_190,_191):null;},fireEvent:function(_192,_193,_194){if(_192 in this.runs){var _195=this.series[this.runs[_192]].plot;if(_195 in this.plots){var plot=this.stack[this.plots[_195]];if(plot){plot.fireEvent(_192,_193,_194);}}}return this;},_makeClean:function(){arr.forEach(this.axes,_152);arr.forEach(this.stack,_152);arr.forEach(this.series,_152);this.dirty=false;},_makeDirty:function(){arr.forEach(this.axes,_153);arr.forEach(this.stack,_153);arr.forEach(this.series,_153);this.dirty=true;},_invalidateDependentPlots:function(_196,_197){if(_196 in this.plots){var plot=this.stack[this.plots[_196]],axis,_198=_197?"vAxis":"hAxis";if(plot[_198]){axis=this.axes[plot[_198]];if(axis&&axis.dependOnData()){axis.dirty=true;arr.forEach(this.stack,function(p){if(p[_198]&&p[_198]==plot[_198]){p.dirty=true;}});}}else{plot.dirty=true;}}},setDir:function(dir){return this;},_resetLeftBottom:function(axis){},formatTruncatedLabel:function(_199,_19a,_19b){}});function _19c(_19d){return {min:_19d.hmin,max:_19d.hmax};};function _19e(_19f){return {min:_19f.vmin,max:_19f.vmax};};function _1a0(_1a1,h){_1a1.hmin=h.min;_1a1.hmax=h.max;};function _1a2(_1a3,v){_1a3.vmin=v.min;_1a3.vmax=v.max;};function _1a4(_1a5,_1a6){if(_1a5&&_1a6){_1a5.min=Math.min(_1a5.min,_1a6.min);_1a5.max=Math.max(_1a5.max,_1a6.max);}return _1a5||_1a6;};function _184(_1a7,_1a8){var _1a9={},axes={};arr.forEach(_1a7,function(plot){var _1aa=_1a9[plot.name]=plot.getSeriesStats();if(plot.hAxis){axes[plot.hAxis]=_1a4(axes[plot.hAxis],_19c(_1aa));}if(plot.vAxis){axes[plot.vAxis]=_1a4(axes[plot.vAxis],_19e(_1aa));}});arr.forEach(_1a7,function(plot){var _1ab=_1a9[plot.name];if(plot.hAxis){_1a0(_1ab,axes[plot.hAxis]);}if(plot.vAxis){_1a2(_1ab,axes[plot.vAxis]);}plot.initializeScalers(_1a8,_1ab);});};return has("dojo-bidi")?_144("dojox.charting.Chart",[_155,_14e]):_155;});},"dojox/charting/plot2d/MarkersOnly":function(){define(["dojo/_base/declare","./Default"],function(_1ac,_1ad){return _1ac("dojox.charting.plot2d.MarkersOnly",_1ad,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});});},"dojox/charting/plot2d/Areas":function(){define(["dojo/_base/declare","./Default"],function(_1ae,_1af){return _1ae("dojox.charting.plot2d.Areas",_1af,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dojox/charting/action2d/Base":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/Evented"],function(lang,_1b0,_1b1){return _1b0("dojox.charting.action2d.Base",_1b1,{constructor:function(_1b2,plot){this.chart=_1b2;this.plot=plot?(lang.isString(plot)?this.chart.getPlot(plot):plot):this.chart.getPlot("default");},connect:function(){},disconnect:function(){},destroy:function(){this.disconnect();}});});},"dojo/fx":function(){define(["./_base/lang","./Evented","./_base/kernel","./_base/array","./aspect","./_base/fx","./dom","./dom-style","./dom-geometry","./ready","require"],function(lang,_1b3,dojo,_1b4,_1b5,_1b6,dom,_1b7,geom,_1b8,_1b9){if(!dojo.isAsync){_1b8(0,function(){var _1ba=["./fx/Toggler"];_1b9(_1ba);});}var _1bb=dojo.fx={};var _1bc={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}return this;}};var _1bd=function(_1be){this._index=-1;this._animations=_1be||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;_1b4.forEach(this._animations,function(a){this.duration+=a.duration;if(a.delay){this.duration+=a.delay;}},this);};_1bd.prototype=new _1b3();lang.extend(_1bd,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){this._onAnimateCtx.remove();this._onEndCtx.remove();this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=_1b5.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);this._onEndCtx=_1b5.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play(0,true);}},play:function(_1bf,_1c0){if(!this._current){this._current=this._animations[this._index=0];}if(!_1c0&&this._current.status()=="playing"){return this;}var _1c1=_1b5.after(this._current,"beforeBegin",lang.hitch(this,function(){this._fire("beforeBegin");}),true),_1c2=_1b5.after(this._current,"onBegin",lang.hitch(this,function(arg){this._fire("onBegin",arguments);}),true),_1c3=_1b5.after(this._current,"onPlay",lang.hitch(this,function(arg){this._fire("onPlay",arguments);_1c1.remove();_1c2.remove();_1c3.remove();}));if(this._onAnimateCtx){this._onAnimateCtx.remove();}this._onAnimateCtx=_1b5.after(this._current,"onAnimate",lang.hitch(this,"_onAnimate"),true);if(this._onEndCtx){this._onEndCtx.remove();}this._onEndCtx=_1b5.after(this._current,"onEnd",lang.hitch(this,"_onEnd"),true);this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=_1b5.after(this._current,"onPause",lang.hitch(this,function(arg){this._fire("onPause",arguments);e.remove();}),true);this._current.pause();}return this;},gotoPercent:function(_1c4,_1c5){this.pause();var _1c6=this.duration*_1c4;this._current=null;_1b4.some(this._animations,function(a){if(a.duration<=_1c6){this._current=a;return true;}_1c6-=a.duration;return false;});if(this._current){this._current.gotoPercent(_1c6/this._current.duration,_1c5);}return this;},stop:function(_1c7){if(this._current){if(_1c7){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}this._current=this._animations[this._index];}var e=_1b5.after(this._current,"onStop",lang.hitch(this,function(arg){this._fire("onStop",arguments);e.remove();}),true);this._current.stop();}return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){if(this._onAnimateCtx){this._onAnimateCtx.remove();}if(this._onEndCtx){this._onEndCtx.remove();}}});lang.extend(_1bd,_1bc);_1bb.chain=function(_1c8){return new _1bd(_1c8);};var _1c9=function(_1ca){this._animations=_1ca||[];this._connects=[];this._finished=0;this.duration=0;_1b4.forEach(_1ca,function(a){var _1cb=a.duration;if(a.delay){_1cb+=a.delay;}if(this.duration<_1cb){this.duration=_1cb;}this._connects.push(_1b5.after(a,"onEnd",lang.hitch(this,"_onEnd"),true));},this);this._pseudoAnimation=new _1b6.Animation({curve:[0,1],duration:this.duration});var self=this;_1b4.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(_1b5.after(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);},true));});};lang.extend(_1c9,{_doAction:function(_1cc,args){_1b4.forEach(this._animations,function(a){a[_1cc].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(_1cd,args){var t=this._pseudoAnimation;t[_1cd].apply(t,args);},play:function(_1ce,_1cf){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(_1d0,_1d1){var ms=this.duration*_1d0;_1b4.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),_1d1);});this._call("gotoPercent",arguments);return this;},stop:function(_1d2){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){_1b4.forEach(this._connects,function(_1d3){_1d3.remove();});}});lang.extend(_1c9,_1bc);_1bb.combine=function(_1d4){return new _1c9(_1d4);};_1bb.wipeIn=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1b6.animateProperty(lang.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var _1d5=_1b7.get(node,"height");return Math.max(_1d5,1);}},end:function(){return node.scrollHeight;}}}},args));var fini=function(){s.height="auto";s.overflow=o;};_1b5.after(anim,"onStop",fini,true);_1b5.after(anim,"onEnd",fini,true);return anim;};_1bb.wipeOut=function(args){var node=args.node=dom.byId(args.node),s=node.style,o;var anim=_1b6.animateProperty(lang.mixin({properties:{height:{end:1}}},args));_1b5.after(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";},true);var fini=function(){s.overflow=o;s.height="auto";s.display="none";};_1b5.after(anim,"onStop",fini,true);_1b5.after(anim,"onEnd",fini,true);return anim;};_1bb.slideTo=function(args){var node=args.node=dom.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=_1b7.getComputedStyle(n);var pos=cs.position;top=(pos=="absolute"?n.offsetTop:parseInt(cs.top)||0);left=(pos=="absolute"?n.offsetLeft:parseInt(cs.left)||0);if(pos!="absolute"&&pos!="relative"){var ret=geom.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=_1b6.animateProperty(lang.mixin({properties:{top:args.top||0,left:args.left||0}},args));_1b5.after(anim,"beforeBegin",init,true);return anim;};return _1bb;});},"dojox/charting/action2d/PlotAction":function(){define(["dojo/_base/connect","dojo/_base/declare","./Base","dojo/fx/easing","dojox/lang/functional"],function(hub,_1d6,Base,dfe,df){var _1d7=400,_1d8=dfe.backOut;return _1d6("dojox.charting.action2d.PlotAction",Base,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_1d9,plot,_1da){this.anim={};if(!_1da){_1da={};}this.duration=_1da.duration?_1da.duration:_1d7;this.easing=_1da.easing?_1da.easing:_1d8;},connect:function(){this.handle=this.chart.connectToPlot(this.plot.name,this,"process");},disconnect:function(){if(this.handle){hub.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){this.inherited(arguments);df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});});},"dojox/charting/plot2d/commonStacked":function(){define(["dojo/_base/lang","./common"],function(lang,_1db){var _1dc=lang.getObject("dojox.charting.plot2d.commonStacked",true);return lang.mixin(_1dc,{collectStats:function(_1dd){var _1de=lang.delegate(_1db.defaultStats);for(var i=0;i<_1dd.length;++i){var run=_1dd[i];for(var j=0;j<run.data.length;j++){var x,y;if(run.data[j]!==null){if(typeof run.data[j]=="number"||!run.data[j].hasOwnProperty("x")){y=_1dc.getIndexValue(_1dd,i,j)[0];x=j+1;}else{x=run.data[j].x;if(x!==null){y=_1dc.getValue(_1dd,i,x)[0];y=y!=null&&y.y?y.y:null;}}_1de.hmin=Math.min(_1de.hmin,x);_1de.hmax=Math.max(_1de.hmax,x);_1de.vmin=Math.min(_1de.vmin,y);_1de.vmax=Math.max(_1de.vmax,y);}}}return _1de;},getIndexValue:function(_1df,i,_1e0){var _1e1=0,v,j,_1e2;for(j=0;j<=i;++j){_1e2=_1e1;v=_1df[j].data[_1e0];if(v!=null){if(isNaN(v)){v=v.y||0;}_1e1+=v;}}return [_1e1,_1e2];},getValue:function(_1e3,i,x){var _1e4=null,j,z,v,_1e5;for(j=0;j<=i;++j){for(z=0;z<_1e3[j].data.length;z++){_1e5=_1e4;v=_1e3[j].data[z];if(v!==null){if(v.x==x){if(!_1e4){_1e4={x:x};}if(v.y!=null){if(_1e4.y==null){_1e4.y=0;}_1e4.y+=v.y;}break;}else{if(v.x>x){break;}}}}}return [_1e4,_1e5];}});});},"dojox/gfx/fx":function(){define(["dojo/_base/lang","./_base","./matrix","dojo/_base/Color","dojo/_base/array","dojo/_base/fx","dojo/_base/connect","dojo/sniff"],function(lang,g,m,_1e6,arr,fx,Hub,has){var fxg=g.fx={};function _1e7(_1e8,end){this.start=_1e8,this.end=end;};_1e7.prototype.getValue=function(r){return (this.end-this.start)*r+this.start;};function _1e9(_1ea,end,_1eb){this.start=_1ea,this.end=end;this.units=_1eb;};_1e9.prototype.getValue=function(r){return (this.end-this.start)*r+this.start+this.units;};function _1ec(_1ed,end){this.start=_1ed,this.end=end;this.temp=new _1e6();};_1ec.prototype.getValue=function(r){return _1e6.blendColors(this.start,this.end,r,this.temp);};function _1ee(_1ef){this.values=_1ef;this.length=_1ef.length;};_1ee.prototype.getValue=function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];};function _1f0(_1f1,def){this.values=_1f1;this.def=def?def:{};};_1f0.prototype.getValue=function(r){var ret=lang.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;};function _1f2(_1f3,_1f4){this.stack=_1f3;this.original=_1f4;};_1f2.prototype.getValue=function(r){var ret=[];arr.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(t.name=="matrix"){if((t.start instanceof m.Matrix2D)&&(t.end instanceof m.Matrix2D)){var _1f5=new m.Matrix2D();for(var p in t.start){_1f5[p]=(t.end[p]-t.start[p])*r+t.start[p];}ret.push(_1f5);}return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=arr.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_1f6=f.apply(m,val);if(_1f6 instanceof m.Matrix2D){ret.push(_1f6);}},this);return ret;};var _1f7=new _1e6(0,0,0,0);function _1f8(prop,obj,name,def){if(prop.values){return new _1ee(prop.values);}var _1f9,_1fa,end;if(prop.start){_1fa=g.normalizeColor(prop.start);}else{_1fa=_1f9=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_1f9){_1f9=obj?(name?obj[name]:obj):def;}end=_1f9;}return new _1ec(_1fa,end);};function _1fb(prop,obj,name,def){if(prop.values){return new _1ee(prop.values);}var _1fc,_1fd,end;if(prop.start){_1fd=prop.start;}else{_1fd=_1fc=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _1fc!="number"){_1fc=obj?obj[name]:def;}end=_1fc;}return new _1e7(_1fd,end);};fxg.animateStroke=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_1fe=args.shape,_1ff;Hub.connect(anim,"beforeBegin",anim,function(){_1ff=_1fe.getStroke();var prop=args.color,_200={},_201,_202,end;if(prop){_200.color=_1f8(prop,_1ff,"color",_1f7);}prop=args.style;if(prop&&prop.values){_200.style=new _1ee(prop.values);}prop=args.width;if(prop){_200.width=_1fb(prop,_1ff,"width",1);}prop=args.cap;if(prop&&prop.values){_200.cap=new _1ee(prop.values);}prop=args.join;if(prop){if(prop.values){_200.join=new _1ee(prop.values);}else{_202=prop.start?prop.start:(_1ff&&_1ff.join||0);end=prop.end?prop.end:(_1ff&&_1ff.join||0);if(typeof _202=="number"&&typeof end=="number"){_200.join=new _1e7(_202,end);}}}this.curve=new _1f0(_200,_1ff);});Hub.connect(anim,"onAnimate",_1fe,"setStroke");return anim;};fxg.animateFill=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_203=args.shape,fill;Hub.connect(anim,"beforeBegin",anim,function(){fill=_203.getFill();var prop=args.color,_204={};if(prop){this.curve=_1f8(prop,fill,"",_1f7);}});Hub.connect(anim,"onAnimate",_203,"setFill");return anim;};fxg.animateFont=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_205=args.shape,font;Hub.connect(anim,"beforeBegin",anim,function(){font=_205.getFont();var prop=args.style,_206={},_207,_208,end;if(prop&&prop.values){_206.style=new _1ee(prop.values);}prop=args.variant;if(prop&&prop.values){_206.variant=new _1ee(prop.values);}prop=args.weight;if(prop&&prop.values){_206.weight=new _1ee(prop.values);}prop=args.family;if(prop&&prop.values){_206.family=new _1ee(prop.values);}prop=args.size;if(prop&&prop.units){_208=parseFloat(prop.start?prop.start:(_205.font&&_205.font.size||"0"));end=parseFloat(prop.end?prop.end:(_205.font&&_205.font.size||"0"));_206.size=new _1e9(_208,end,prop.units);}this.curve=new _1f0(_206,font);});Hub.connect(anim,"onAnimate",_205,"setFont");return anim;};fxg.animateTransform=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_209=args.shape,_20a;Hub.connect(anim,"beforeBegin",anim,function(){_20a=_209.getTransform();this.curve=new _1f2(args.transform,_20a);});Hub.connect(anim,"onAnimate",_209,"setTransform");if(g.renderer==="svg"&&has("ie")>=10){var _20b=[Hub.connect(anim,"onBegin",anim,function(){var _20c=_209.getParent();while(_20c&&_20c.getParent){_20c=_20c.getParent();}if(_20c){_209.__svgContainer=_20c.rawNode.parentNode;}}),Hub.connect(anim,"onAnimate",anim,function(){try{if(_209.__svgContainer){var ov=_209.__svgContainer.style.visibility;_209.__svgContainer.style.visibility="visible";var _20d=_209.__svgContainer.offsetHeight;_209.__svgContainer.style.visibility=ov;}}catch(e){}}),Hub.connect(anim,"onEnd",anim,function(){arr.forEach(_20b,Hub.disconnect);if(_209.__svgContainer){var ov=_209.__svgContainer.style.visibility;var sn=_209.__svgContainer;_209.__svgContainer.style.visibility="visible";setTimeout(function(){try{sn.style.visibility=ov;sn=null;}catch(e){}},100);}delete _209.__svgContainer;})];}return anim;};return fxg;});},"dijit/BackgroundIframe":function(){define(["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff"],function(_20e,_20f,_210,_211,_212,lang,on,has){has.add("config-bgIframe",!has("touch"));var _213=new function(){var _214=[];this.pop=function(){var _215;if(_214.length){_215=_214.pop();_215.style.display="";}else{if(has("ie")<9){var burl=_210["dojoBlankHtmlUrl"]||_20e.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_215=document.createElement(html);}else{_215=_211.create("iframe");_215.src="javascript:\"\"";_215.className="dijitBackgroundIframe";_215.setAttribute("role","presentation");_212.set(_215,"opacity",0.1);}_215.tabIndex=-1;}return _215;};this.push=function(_216){_216.style.display="none";_214.push(_216);};}();_20f.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("config-bgIframe")){var _217=(this.iframe=_213.pop());node.appendChild(_217);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,"resize",node));}else{_212.set(_217,{width:"100%",height:"100%"});}}};lang.extend(_20f.BackgroundIframe,{resize:function(node){if(this.iframe){_212.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){_213.push(this.iframe);delete this.iframe;}}});return _20f.BackgroundIframe;});},"dojox/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dojox;});},"dojox/charting/action2d/Magnify":function(){define(["dojo/_base/connect","dojo/_base/declare","./PlotAction","dojox/gfx/matrix","dojox/gfx/fx","dojo/fx","dojo/fx/easing"],function(Hub,_218,_219,m,gf,df,dfe){var _21a=2;return _218("dojox.charting.action2d.Magnify",_219,{defaultParams:{duration:400,easing:dfe.backOut,scale:_21a},optionalParams:{},constructor:function(_21b,plot,_21c){this.scale=_21c&&typeof _21c.scale=="number"?_21c.scale:_21a;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)||!("cx" in o)||!("cy" in o)){return;}if(o.element=="spider_plot"||o.element=="spider_poly"){return;}var _21d=o.run.name,_21e=o.index,_21f=[],anim,init,_220;if(_21d in this.anim){anim=this.anim[_21d][_21e];}else{this.anim[_21d]={};}if(anim){anim.action.stop(true);}else{this.anim[_21d][_21e]=anim={};}if(o.type=="onmouseover"){init=m.identity;_220=this.scale;}else{init=m.scaleAt(this.scale,o.cx,o.cy);_220=1/this.scale;}var _221={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"scaleAt",start:[1,o.cx,o.cy],end:[_220,o.cx,o.cy]},init]};if(o.shape){_21f.push(gf.animateTransform(_221));}if(o.outline){_221.shape=o.outline;_21f.push(gf.animateTransform(_221));}if(o.shadow){_221.shape=o.shadow;_21f.push(gf.animateTransform(_221));}if(!_21f.length){delete this.anim[_21d][_21e];return;}anim.action=df.combine(_21f);if(o.type=="onmouseout"){Hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_21d]){delete this.anim[_21d][_21e];}});}anim.action.play();}});});},"dojo/Stateful":function(){define(["./_base/declare","./_base/lang","./_base/array","./when"],function(_222,lang,_223,when){return _222("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});},postscript:function(_224){if(_224){this.set(_224);}},_get:function(name,_225){return typeof this[_225.g]==="function"?this[_225.g]():this[name];},get:function(name){return this._get(name,this._getAttrNames(name));},set:function(name,_226){if(typeof name==="object"){for(var x in name){if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){this.set(x,name[x]);}}return this;}var _227=this._getAttrNames(name),_228=this._get(name,_227),_229=this[_227.s],_22a;if(typeof _229==="function"){_22a=_229.apply(this,Array.prototype.slice.call(arguments,1));}else{this[name]=_226;}if(this._watchCallbacks){var self=this;when(_22a,function(){self._watchCallbacks(name,_228,_226);});}return this;},_changeAttrValue:function(name,_22b){var _22c=this.get(name);this[name]=_22b;if(this._watchCallbacks){this._watchCallbacks(name,_22c,_22b);}return this;},watch:function(name,_22d){var _22e=this._watchCallbacks;if(!_22e){var self=this;_22e=this._watchCallbacks=function(name,_22f,_230,_231){var _232=function(_233){if(_233){_233=_233.slice();for(var i=0,l=_233.length;i<l;i++){_233[i].call(self,name,_22f,_230);}}};_232(_22e["_"+name]);if(!_231){_232(_22e["*"]);}};}if(!_22d&&typeof name==="function"){_22d=name;name="*";}else{name="_"+name;}var _234=_22e[name];if(typeof _234!=="object"){_234=_22e[name]=[];}_234.push(_22d);var _235={};_235.unwatch=_235.remove=function(){var _236=_223.indexOf(_234,_22d);if(_236>-1){_234.splice(_236,1);}};return _235;}});});},"dojox/charting/plot2d/Markers":function(){define(["dojo/_base/declare","./Default"],function(_237,_238){return _237("dojox.charting.plot2d.Markers",_238,{constructor:function(){this.opt.markers=true;}});});},"dojox/charting/plot2d/Bubble":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_239,arr,has,_23a,_23b,dc,df,dfr,du,fx){var _23c=dfr.lambda("item.purgeGroup()");return _239("dojox.charting.plot2d.Bubble",[_23a,_23b],{defaultParams:{animate:null},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:""},constructor:function(_23d,_23e){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_23e);du.updateWithPattern(this.opt,_23e,this.optionalParams);if(!this.opt.labelFunc){this.opt.labelFunc=function(_23f,_240,_241){return this._getLabel(_23f.size,_240,_241);};}this.animate=this.opt.animate;},render:function(dim,_242){var s;if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_242);}this.resetEvents();this.dirty=this.isDirty();if(this.dirty){arr.forEach(this.series,_23c);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_243=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}s=run.group;var _244=t.next("circle",[this.opt,run]),_245=arr.map(run.data,function(v){return v?{x:ht(v.x)+_242.l,y:dim.height-_242.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)}:null;},this);var _246=null,_247=null,_248=null,_249=this.opt.styleFunc;var _24a=function(item){if(_249){return t.addMixin(_244,"circle",[item,_249(item)],true);}return t.addMixin(_244,"circle",item,true);};if(_244.series.shadow){_248=arr.map(_245,function(item,i){if(item!==null){var _24b=_24a(run.data[i]),_24c=_24b.series.shadow;var _24d=s.createCircle({cx:item.x+_24c.dx,cy:item.y+_24c.dy,r:item.radius}).setStroke(_24c).setFill(_24c.color);if(this.animate){this._animateBubble(_24d,dim.height-_242.b,item.radius);}return _24d;}return null;},this);if(_248.length){run.dyn.shadow=_248[_248.length-1].getStroke();}}if(_244.series.outline){_247=arr.map(_245,function(item,i){if(item!==null){var _24e=_24a(run.data[i]),_24f=dc.makeStroke(_24e.series.outline);_24f.width=2*_24f.width+_244.series.stroke.width;var _250=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(_24f);if(this.animate){this._animateBubble(_250,dim.height-_242.b,item.radius);}return _250;}return null;},this);if(_247.length){run.dyn.outline=_247[_247.length-1].getStroke();}}_246=arr.map(_245,function(item,i){if(item!==null){var _251=_24a(run.data[i]),rect={x:item.x-item.radius,y:item.y-item.radius,width:2*item.radius,height:2*item.radius};var _252=this._plotFill(_251.series.fill,dim,_242);_252=this._shapeFill(_252,rect);var _253=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setFill(_252).setStroke(_251.series.stroke);if(_253.setFilter&&_251.series.filter){_253.setFilter(_251.series.filter);}if(this.animate){this._animateBubble(_253,dim.height-_242.b,item.radius);}this.createLabel(s,run.data[i],rect,_251);return _253;}return null;},this);if(_246.length){run.dyn.fill=_246[_246.length-1].getFill();run.dyn.stroke=_246[_246.length-1].getStroke();}if(_243){var _254=new Array(_246.length);arr.forEach(_246,function(s,i){if(s!==null){var o={element:"circle",index:i,run:run,shape:s,outline:_247&&_247[i]||null,shadow:_248&&_248[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:_245[i].x,cy:_245[i].y,cr:_245[i].radius};this._connectEvents(o);_254[i]=o;}},this);this._eventSeries[run.name]=_254;}else{delete this._eventSeries[run.name];}run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_242);}return this;},_animateBubble:function(_255,_256,size){fx.animateTransform(lang.delegate({shape:_255,duration:1200,transform:[{name:"translate",start:[0,_256],end:[0,0]},{name:"scale",start:[0,1/size],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojo/touch":function(){define(["./_base/kernel","./aspect","./dom","./dom-class","./_base/lang","./on","./has","./mouse","./domReady","./_base/window"],function(dojo,_257,dom,_258,lang,on,has,_259,_25a,win){var _25b=has("touch");var ios4=has("ios")<5;var _25c=navigator.msPointerEnabled;var _25d,_25e,_25f,_260,_261,_262,_263,_264;var _265;function _266(_267,_268,_269){if(_25c&&_269){return function(node,_26a){return on(node,_269,_26a);};}else{if(_25b){return function(node,_26b){var _26c=on(node,_268,_26b),_26d=on(node,_267,function(evt){if(!_265||(new Date()).getTime()>_265+1000){_26b.call(this,evt);}});return {remove:function(){_26c.remove();_26d.remove();}};};}else{return function(node,_26e){return on(node,_267,_26e);};}}};function _26f(node){do{if(node.dojoClick){return node.dojoClick;}}while(node=node.parentNode);};function _270(e,_271,_272){_25e=!e.target.disabled&&_26f(e.target);if(_25e){_25f=e.target;_260=e.touches?e.touches[0].pageX:e.clientX;_261=e.touches?e.touches[0].pageY:e.clientY;_262=(typeof _25e=="object"?_25e.x:(typeof _25e=="number"?_25e:0))||4;_263=(typeof _25e=="object"?_25e.y:(typeof _25e=="number"?_25e:0))||4;if(!_25d){_25d=true;win.doc.addEventListener(_271,function(e){_25e=_25e&&e.target==_25f&&Math.abs((e.touches?e.touches[0].pageX:e.clientX)-_260)<=_262&&Math.abs((e.touches?e.touches[0].pageY:e.clientY)-_261)<=_263;},true);win.doc.addEventListener(_272,function(e){if(_25e){_264=(new Date()).getTime();var _273=e.target;if(_273.tagName==="LABEL"){_273=dom.byId(_273.getAttribute("for"))||_273;}setTimeout(function(){on.emit(_273,"click",{bubbles:true,cancelable:true,_dojo_click:true});});}},true);function _274(type){win.doc.addEventListener(type,function(e){if(!e._dojo_click&&(new Date()).getTime()<=_264+1000&&!(e.target.tagName=="INPUT"&&_258.contains(e.target,"dijitOffScreen"))){e.stopPropagation();e.stopImmediatePropagation&&e.stopImmediatePropagation();if(type=="click"&&(e.target.tagName!="INPUT"||e.target.type=="radio"||e.target.type=="checkbox")&&e.target.tagName!="TEXTAREA"){e.preventDefault();}}},true);};_274("click");_274("mousedown");_274("mouseup");}}};var _275;if(_25b){if(_25c){_25a(function(){win.doc.addEventListener("MSPointerDown",function(evt){_270(evt,"MSPointerMove","MSPointerUp");},true);});}else{_25a(function(){_275=win.body();win.doc.addEventListener("touchstart",function(evt){_265=(new Date()).getTime();var _276=_275;_275=evt.target;on.emit(_276,"dojotouchout",{relatedTarget:_275,bubbles:true});on.emit(_275,"dojotouchover",{relatedTarget:_276,bubbles:true});_270(evt,"touchmove","touchend");},true);function _277(evt){var _278=lang.delegate(evt,{bubbles:true});if(has("ios")>=6){_278.touches=evt.touches;_278.altKey=evt.altKey;_278.changedTouches=evt.changedTouches;_278.ctrlKey=evt.ctrlKey;_278.metaKey=evt.metaKey;_278.shiftKey=evt.shiftKey;_278.targetTouches=evt.targetTouches;}return _278;};on(win.doc,"touchmove",function(evt){_265=(new Date()).getTime();var _279=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));if(_279){if(_275!==_279){on.emit(_275,"dojotouchout",{relatedTarget:_279,bubbles:true});on.emit(_279,"dojotouchover",{relatedTarget:_275,bubbles:true});_275=_279;}on.emit(_279,"dojotouchmove",_277(evt));}});on(win.doc,"touchend",function(evt){_265=(new Date()).getTime();var node=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset))||win.body();on.emit(node,"dojotouchend",_277(evt));});});}}var _27a={press:_266("mousedown","touchstart","MSPointerDown"),move:_266("mousemove","dojotouchmove","MSPointerMove"),release:_266("mouseup","dojotouchend","MSPointerUp"),cancel:_266(_259.leave,"touchcancel",_25b?"MSPointerCancel":null),over:_266("mouseover","dojotouchover","MSPointerOver"),out:_266("mouseout","dojotouchout","MSPointerOut"),enter:_259._eventHandler(_266("mouseover","dojotouchover","MSPointerOver")),leave:_259._eventHandler(_266("mouseout","dojotouchout","MSPointerOut"))};1&&(dojo.touch=_27a);return _27a;});},"dojox/gfx/gradutils":function(){define(["./_base","dojo/_base/lang","./matrix","dojo/_base/Color"],function(g,lang,m,_27b){var _27c=g.gradutils={};function _27d(o,c){if(o<=0){return c[0].color;}var len=c.length;if(o>=1){return c[len-1].color;}for(var i=0;i<len;++i){var stop=c[i];if(stop.offset>=o){if(i){var prev=c[i-1];return _27b.blendColors(new _27b(prev.color),new _27b(stop.color),(o-prev.offset)/(stop.offset-prev.offset));}return stop.color;}}return c[len-1].color;};_27c.getColor=function(fill,pt){var o;if(fill){switch(fill.type){case "linear":var _27e=Math.atan2(fill.y2-fill.y1,fill.x2-fill.x1),_27f=m.rotate(-_27e),_280=m.project(fill.x2-fill.x1,fill.y2-fill.y1),p=m.multiplyPoint(_280,pt),pf1=m.multiplyPoint(_280,fill.x1,fill.y1),pf2=m.multiplyPoint(_280,fill.x2,fill.y2),_281=m.multiplyPoint(_27f,pf2.x-pf1.x,pf2.y-pf1.y).x;o=m.multiplyPoint(_27f,p.x-pf1.x,p.y-pf1.y).x/_281;break;case "radial":var dx=pt.x-fill.cx,dy=pt.y-fill.cy;o=Math.sqrt(dx*dx+dy*dy)/fill.r;break;}return _27d(o,fill.colors);}return new _27b(fill||[0,0,0,0]);};_27c.reverse=function(fill){if(fill){switch(fill.type){case "linear":case "radial":fill=lang.delegate(fill);if(fill.colors){var c=fill.colors,l=c.length,i=0,stop,n=fill.colors=new Array(c.length);for(;i<l;++i){stop=c[i];n[i]={offset:1-stop.offset,color:stop.color};}n.sort(function(a,b){return a.offset-b.offset;});}break;}}return fill;};return _27c;});},"dojo/hccss":function(){define(["require","./_base/config","./dom-class","./dom-style","./has","./domReady","./_base/window"],function(_282,_283,_284,_285,has,_286,win){has.add("highcontrast",function(){var div=win.doc.createElement("div");div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url("+(_283.blankGif||_282.toUrl("./resources/blank.gif"))+");";win.body().appendChild(div);var cs=_285.getComputedStyle(div),_287=cs.backgroundImage,hc=(cs.borderTopColor==cs.borderRightColor)||(_287&&(_287=="none"||_287=="url(invalid-url:)"));if(has("ie")<=8){div.outerHTML="";}else{win.body().removeChild(div);}return hc;});_286(function(){if(has("highcontrast")){_284.add(win.body(),"dj_a11y");}});return has;});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(_288,lang){var _289={};lang.setObject("dojo.string",_289);_289.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};_289.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=_289.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};_289.substitute=function(_28a,map,_28b,_28c){_28c=_28c||_288.global;_28b=_28b?lang.hitch(_28c,_28b):function(v){return v;};return _28a.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_28d,key,_28e){var _28f=lang.getObject(key,false,map);if(_28e){_28f=lang.getObject(_28e,false,_28c).call(_28c,_28f,key);}return _28b(_28f,key).toString();});};_289.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return _289;});},"dijit/_AttachMixin":function(){define(["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/mouse","dojo/on","dojo/touch","./_WidgetBase"],function(_290,_291,_292,_293,lang,_294,on,_295,_296){var _297=lang.delegate(_295,{"mouseenter":_294.enter,"mouseleave":_294.leave,"keypress":_292._keypress});var _298;var _299=_293("dijit._AttachMixin",null,{constructor:function(){this._attachPoints=[];this._attachEvents=[];},buildRendering:function(){this.inherited(arguments);this._attachTemplateNodes(this.domNode);this._beforeFillContent();},_beforeFillContent:function(){},_attachTemplateNodes:function(_29a){var node=_29a;while(true){if(node.nodeType==1&&(this._processTemplateNode(node,function(n,p){return n.getAttribute(p);},this._attach)||this.searchContainerNode)&&node.firstChild){node=node.firstChild;}else{if(node==_29a){return;}while(!node.nextSibling){node=node.parentNode;if(node==_29a){return;}}node=node.nextSibling;}}},_processTemplateNode:function(_29b,_29c,_29d){var ret=true;var _29e=this.attachScope||this,_29f=_29c(_29b,"dojoAttachPoint")||_29c(_29b,"data-dojo-attach-point");if(_29f){var _2a0,_2a1=_29f.split(/\s*,\s*/);while((_2a0=_2a1.shift())){if(lang.isArray(_29e[_2a0])){_29e[_2a0].push(_29b);}else{_29e[_2a0]=_29b;}ret=(_2a0!="containerNode");this._attachPoints.push(_2a0);}}var _2a2=_29c(_29b,"dojoAttachEvent")||_29c(_29b,"data-dojo-attach-event");if(_2a2){var _2a3,_2a4=_2a2.split(/\s*,\s*/);var trim=lang.trim;while((_2a3=_2a4.shift())){if(_2a3){var _2a5=null;if(_2a3.indexOf(":")!=-1){var _2a6=_2a3.split(":");_2a3=trim(_2a6[0]);_2a5=trim(_2a6[1]);}else{_2a3=trim(_2a3);}if(!_2a5){_2a5=_2a3;}this._attachEvents.push(_29d(_29b,_2a3,lang.hitch(_29e,_2a5)));}}}return ret;},_attach:function(node,type,func){type=type.replace(/^on/,"").toLowerCase();if(type=="dijitclick"){type=_298||(_298=_290("./a11yclick"));}else{type=_297[type]||type;}return on(node,type,func);},_detachTemplateNodes:function(){var _2a7=this.attachScope||this;_291.forEach(this._attachPoints,function(_2a8){delete _2a7[_2a8];});this._attachPoints=[];_291.forEach(this._attachEvents,function(_2a9){_2a9.remove();});this._attachEvents=[];},destroyRendering:function(){this._detachTemplateNodes();this.inherited(arguments);}});lang.extend(_296,{dojoAttachEvent:"",dojoAttachPoint:""});return _299;});},"dojox/charting/plot2d/Lines":function(){define(["dojo/_base/declare","./Default"],function(_2aa,_2ab){return _2aa("dojox.charting.plot2d.Lines",_2ab,{constructor:function(){this.opt.lines=true;}});});},"dijit/registry":function(){define(["dojo/_base/array","dojo/sniff","dojo/_base/window","./main"],function(_2ac,has,win,_2ad){var _2ae={},hash={};var _2af={length:0,add:function(_2b0){if(hash[_2b0.id]){throw new Error("Tried to register widget with id=="+_2b0.id+" but that id is already registered");}hash[_2b0.id]=_2b0;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_2b1){var id;do{id=_2b1+"_"+(_2b1 in _2ae?++_2ae[_2b1]:_2ae[_2b1]=0);}while(hash[id]);return _2ad._scopeName=="dijit"?id:_2ad._scopeName+"_"+id;},findWidgets:function(root,_2b2){var _2b3=[];function _2b4(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _2b5=node.getAttribute("widgetId");if(_2b5){var _2b6=hash[_2b5];if(_2b6){_2b3.push(_2b6);}}else{if(node!==_2b2){_2b4(node);}}}}};_2b4(root);return _2b3;},_destroyAll:function(){_2ad._curFocus=null;_2ad._prevFocus=null;_2ad._activeStack=[];_2ac.forEach(_2af.findWidgets(win.body()),function(_2b7){if(!_2b7._destroyed){if(_2b7.destroyRecursive){_2b7.destroyRecursive();}else{if(_2b7.destroy){_2b7.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.nodeType==1&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};_2ad.registry=_2af;return _2af;});},"dijit/Destroyable":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_2b8,_2b9,_2ba){return _2ba("dijit.Destroyable",null,{destroy:function(_2bb){this._destroyed=true;},own:function(){_2b8.forEach(arguments,function(_2bc){var _2bd="destroyRecursive" in _2bc?"destroyRecursive":"destroy" in _2bc?"destroy":"remove";var odh=_2b9.before(this,"destroy",function(_2be){_2bc[_2bd](_2be);});var hdh=_2b9.after(_2bc,_2bd,function(){odh.remove();hdh.remove();},true);},this);return arguments;}});});},"dojox/charting/plot2d/StackedAreas":function(){define(["dojo/_base/declare","./Stacked"],function(_2bf,_2c0){return _2bf("dojox.charting.plot2d.StackedAreas",_2c0,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});});},"dijit/_base/manager":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_2c1,_2c2,lang,_2c3,_2c4){var _2c5={};_2c1.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_2c5[name]=_2c3[name];});lang.mixin(_2c5,{defaultDuration:_2c2["defaultDuration"]||200});lang.mixin(_2c4,_2c5);return _2c4;});},"dojox/charting/plot2d/Stacked":function(){define(["dojo/_base/declare","./Default","./commonStacked"],function(_2c6,_2c7,_2c8){return _2c6("dojox.charting.plot2d.Stacked",_2c7,{getSeriesStats:function(){var _2c9=_2c8.collectStats(this.series);return _2c9;},buildSegments:function(i,_2ca){var run=this.series[i],min=_2ca?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_2ca?Math.min(run.data.length-1,Math.ceil(this._hScaler.bounds.to)):run.data.length-1,rseg=null,_2cb=[];for(var j=min;j<=max;j++){var _2cc=_2ca?_2c8.getIndexValue(this.series,i,j):_2c8.getValue(this.series,i,run.data[j]?run.data[j].x:null);if(_2cc[0]!=null&&(_2ca||_2cc[0].y!=null)){if(!rseg){rseg=[];_2cb.push({index:j,rseg:rseg});}rseg.push(_2cc[0]);}else{if(!this.opt.interpolate||_2ca){rseg=null;}}}return _2cb;}});});},"dojo/fx/easing":function(){define(["../_base/lang"],function(lang){var _2cd={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-_2cd.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return _2cd.bounceIn(n*2)/2;}return (_2cd.bounceOut(n*2-1)/2)+0.5;}};lang.setObject("dojo.fx.easing",_2cd);return _2cd;});},"dojox/charting/action2d/Highlight":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/Color","dojo/_base/connect","dojox/color/_base","./PlotAction","dojo/fx/easing","dojox/gfx/fx"],function(lang,_2ce,_2cf,hub,c,_2d0,dfe,dgf){var _2d1=100,_2d2=75,_2d3=50,cc=function(_2d4){return function(){return _2d4;};},hl=function(_2d5){var a=new c.Color(_2d5),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_2d1;if(x.l<_2d3){x.l=_2d2;}else{if(x.l>_2d2){x.l=_2d3;}else{x.l=x.l-_2d3>_2d2-x.l?_2d3:_2d2;}}}var _2d6=c.fromHsl(x);_2d6.a=a.a;return _2d6;},_2d7=function(_2d8){var r=hl(_2d8);r.a=0.7;return r;};return _2ce("dojox.charting.action2d.Highlight",_2d0,{defaultParams:{duration:400,easing:dfe.backOut},optionalParams:{highlight:"red"},constructor:function(_2d9,plot,_2da){var a=_2da&&_2da.highlight;this.colorFunc=a?(lang.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}if(o.element=="spider_circle"||o.element=="spider_plot"){return;}else{if(o.element=="spider_poly"&&this.colorFunc==hl){this.colorFunc=_2d7;}}var _2db=o.run.name,_2dc=o.index,anim;if(_2db in this.anim){anim=this.anim[_2db][_2dc];}else{this.anim[_2db]={};}if(anim){anim.action.stop(true);}else{var _2dd=o.shape.getFill();if(!_2dd||!(_2dd instanceof _2cf)){return;}this.anim[_2db][_2dc]=anim={start:_2dd,end:this.colorFunc(_2dd)};}var _2de=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_2de;_2de=end;end=t;}anim.action=dgf.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_2de,end:end}});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_2db]){delete this.anim[_2db][_2dc];}});}anim.action.play();}});});},"dojox/charting/axis2d/Base":function(){define(["dojo/_base/declare","../Element"],function(_2df,_2e0){return _2df("dojox.charting.axis2d.Base",_2e0,{constructor:function(_2e1,_2e2){this.vertical=_2e2&&_2e2.vertical;this.opt={};this.opt.min=_2e2&&_2e2.min;this.opt.max=_2e2&&_2e2.max;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_2e3){this.dirty=false;return this;}});});},"dojox/charting/plot2d/Grid":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/sniff","./CartesianBase","./common","dojox/lang/utils","dojox/gfx/fx"],function(lang,_2e4,arr,has,_2e5,dc,du,fx){var _2e6=function(a,b){return a.value-b.value;};return _2e4("dojox.charting.plot2d.Grid",_2e5,{defaultParams:{hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:false,vStripes:false,animate:null,enableCache:false,renderOnAxis:true},optionalParams:{majorHLine:{},minorHLine:{},majorVLine:{},minorVLine:{},hFill:{},vFill:{},hAlternateFill:{},vAlternateFill:{}},constructor:function(_2e7,_2e8){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_2e8);du.updateWithPattern(this.opt,_2e8,this.optionalParams);this.animate=this.opt.animate;if(this.opt.enableCache){this._lineFreePool=[];this._lineUsePool=[];this._rectFreePool=[];this._rectUsePool=[];}},addSeries:function(run){return this;},getSeriesStats:function(){return lang.delegate(dc.defaultStats);},cleanGroup:function(){this.inherited(arguments);if(this.opt.enableCache){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._rectFreePool=this._rectFreePool.concat(this._rectUsePool);this._rectUsePool=[];}},createLine:function(_2e9,_2ea){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_2ea);_2e9.add(line);}else{line=_2e9.createLine(_2ea);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},createRect:function(_2eb,_2ec){var rect;if(this.opt.enableCache&&this._rectFreePool.length>0){rect=this._rectFreePool.pop();rect.setShape(_2ec);_2eb.add(rect);}else{rect=_2eb.createRect(_2ec);}if(this.opt.enableCache){this._rectUsePool.push(rect);}return rect;},render:function(dim,_2ed){if(this.zoom){return this.performZoom(dim,_2ed);}this.dirty=this.isDirty();if(!this.dirty){return this;}this.cleanGroup();var s=this.getGroup(),ta=this.chart.theme,_2ee,_2ef;if((has("ios")&&has("ios")<6)||has("android")||(has("safari")&&!has("ios"))){var w=Math.max(0,dim.width-_2ed.l-_2ed.r),h=Math.max(0,dim.height-_2ed.t-_2ed.b);s.createRect({x:_2ed.l,y:_2ed.t,width:w,height:h});}if(this._vAxis){_2ef=this._vAxis.getTicks();var _2f0=this._vAxis.getScaler();if(_2ef!=null&&_2f0!=null){var vt=_2f0.scaler.getTransformerFromModel(_2f0);if(this.opt.hStripes){this._renderHRect(_2ef,ta.grid,dim,_2ed,_2f0,vt);}if(this.opt.hMinorLines){_2ee=this.opt.minorHLine||(ta.grid&&ta.grid.minorLine)||ta.axis.minorTick;this._renderHLines(_2ef.minor,_2ee,dim,_2ed,_2f0,vt);}if(this.opt.hMajorLines){_2ee=this.opt.majorHLine||(ta.grid&&ta.grid.majorLine)||ta.axis.majorTick;this._renderHLines(_2ef.major,_2ee,dim,_2ed,_2f0,vt);}}}if(this._hAxis){_2ef=this._hAxis.getTicks();var _2f1=this._hAxis.getScaler();if(_2ef!=null&&_2f1!=null){var ht=_2f1.scaler.getTransformerFromModel(_2f1);if(this.opt.vStripes){this._renderVRect(_2ef,ta.grid,dim,_2ed,_2f1,ht);}if(_2ef&&this.opt.vMinorLines){_2ee=this.opt.minorVLine||(ta.grid&&ta.grid.minorLine)||ta.axis.minorTick;this._renderVLines(_2ef.minor,_2ee,dim,_2ed,_2f1,ht);}if(_2ef&&this.opt.vMajorLines){_2ee=this.opt.majorVLine||(ta.grid&&ta.grid.majorLine)||ta.axis.majorTick;this._renderVLines(_2ef.major,_2ee,dim,_2ed,_2f1,ht);}}}this.dirty=false;return this;},_renderHLines:function(_2f2,_2f3,dim,_2f4,_2f5,vt){var s=this.getGroup();arr.forEach(_2f2,function(tick){if(!this.opt.renderOnAxis&&tick.value==(this._vAxis.opt.leftBottom?_2f5.bounds.from:_2f5.bounds.to)){return;}var y=dim.height-_2f4.b-vt(tick.value);var _2f6=this.createLine(s,{x1:_2f4.l,y1:y,x2:dim.width-_2f4.r,y2:y}).setStroke(_2f3);if(this.animate){this._animateGrid(_2f6,"h",_2f4.l,_2f4.r+_2f4.l-dim.width);}},this);},_renderVLines:function(_2f7,_2f8,dim,_2f9,_2fa,ht){var s=this.getGroup();arr.forEach(_2f7,function(tick){if(!this.opt.renderOnAxis&&tick.value==(this._hAxis.opt.leftBottom?_2fa.bounds.from:_2fa.bounds.to)){return;}var x=_2f9.l+ht(tick.value);var _2fb=this.createLine(s,{x1:x,y1:_2f9.t,x2:x,y2:dim.height-_2f9.b}).setStroke(_2f8);if(this.animate){this._animateGrid(_2fb,"v",dim.height-_2f9.b,dim.height-_2f9.b-_2f9.t);}},this);},_renderHRect:function(_2fc,_2fd,dim,_2fe,_2ff,vt){var fill,tick,y,y2,_300;var _301=_2fc.major.concat(_2fc.minor);_301.sort(_2e6);if(_301[0].value>_2ff.bounds.from){_301.splice(0,0,{value:_2ff.bounds.from});}if(_301[_301.length-1].value<_2ff.bounds.to){_301.push({value:_2ff.bounds.to});}var s=this.getGroup();for(var j=0;j<_301.length-1;j++){tick=_301[j];y=dim.height-_2fe.b-vt(tick.value);y2=dim.height-_2fe.b-vt(_301[j+1].value);fill=(j%2==0)?(this.opt.hAlternateFill||(_2fd&&_2fd.alternateFill)):(this.opt.hFill||(_2fd&&_2fd.fill));if(fill){_300=this.createRect(s,{x:_2fe.l,y:y,width:dim.width-_2fe.r,height:y-y2}).setFill(fill);if(this.animate){this._animateGrid(_300,"h",_2fe.l,_2fe.r+_2fe.l-dim.width);}}}},_renderVRect:function(_302,_303,dim,_304,_305,ht){var fill,tick,x,x2,_306;var _307=_302.major.concat(_302.minor);_307.sort(_2e6);if(_307[0].value>_305.bounds.from){_307.splice(0,0,{value:_305.bounds.from});}if(_307[_307.length-1].value<_305.bounds.to){_307.push({value:_305.bounds.to});}var s=this.getGroup();for(var j=0;j<_307.length-1;j++){tick=_307[j];x=_304.l+ht(tick.value);x2=_304.l+ht(_307[j+1].value);fill=(j%2==0)?(this.opt.vAlternateFill||(_303&&_303.alternateFill)):(this.opt.vFill||(_303&&_303.fill));if(fill){_306=this.createRect(s,{x:x,y:_304.t,width:x2-x,height:dim.width-_304.r}).setFill(fill);if(this.animate){this._animateGrid(_306,"v",dim.height-_304.b,dim.height-_304.b-_304.t);}}}},_animateGrid:function(_308,type,_309,size){var _30a=type=="h"?[_309,0]:[0,_309];var _30b=type=="h"?[1/size,1]:[1,1/size];fx.animateTransform(lang.delegate({shape:_308,duration:1200,transform:[{name:"translate",start:_30a,end:[0,0]},{name:"scale",start:_30b,end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dijit/a11y":function(){define(["dojo/_base/array","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/sniff","./main"],function(_30c,dom,_30d,_30e,lang,has,_30f){var a11y={_isElementShown:function(elem){var s=_30e.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_30d.get(elem,"type")!="hidden");},hasDefaultTabStop:function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _30d.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _310=elem.contentDocument;if("designMode" in _310&&_310.designMode=="on"){return true;}body=_310.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}},isTabNavigable:function(elem){if(_30d.get(elem,"disabled")){return false;}else{if(_30d.has(elem,"tabIndex")){return _30d.get(elem,"tabIndex")>=0;}else{return a11y.hasDefaultTabStop(elem);}}},_getTabNavigable:function(root){var _311,last,_312,_313,_314,_315,_316={};function _317(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _318=a11y._isElementShown,_319=a11y.isTabNavigable;var _31a=function(_31b){for(var _31c=_31b.firstChild;_31c;_31c=_31c.nextSibling){if(_31c.nodeType!=1||(has("ie")<=9&&_31c.scopeName!=="HTML")||!_318(_31c)){continue;}if(_319(_31c)){var _31d=+_30d.get(_31c,"tabIndex");if(!_30d.has(_31c,"tabIndex")||_31d==0){if(!_311){_311=_31c;}last=_31c;}else{if(_31d>0){if(!_312||_31d<_313){_313=_31d;_312=_31c;}if(!_314||_31d>=_315){_315=_31d;_314=_31c;}}}var rn=_317(_31c);if(_30d.get(_31c,"checked")&&rn){_316[rn]=_31c;}}if(_31c.nodeName.toUpperCase()!="SELECT"){_31a(_31c);}}};if(_318(root)){_31a(root);}function rs(node){return _316[_317(node)]||node;};return {first:rs(_311),last:rs(last),lowest:rs(_312),highest:rs(_314)};},getFirstInTabbingOrder:function(root,doc){var _31e=a11y._getTabNavigable(dom.byId(root,doc));return _31e.lowest?_31e.lowest:_31e.first;},getLastInTabbingOrder:function(root,doc){var _31f=a11y._getTabNavigable(dom.byId(root,doc));return _31f.last?_31f.last:_31f.highest;}};1&&lang.mixin(_30f,a11y);return a11y;});},"dojox/lang/functional/fold":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/kernel","./lambda"],function(lang,arr,_320,df){var _321={};lang.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_320.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _321)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_320.global;f=df.lambda(f);var z,i,n;if(lang.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _322=true;for(i in a){if(!(i in _321)){if(_322){z=a[i];_322=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_320.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_320.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||_320.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});});},"dojox/charting/plot2d/Spider":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/array","dojo/dom-geometry","dojo/_base/fx","dojo/fx","dojo/sniff","./Base","./_PlotEvents","./common","../axis2d/common","dojox/gfx","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/utils","dojo/fx/easing"],function(lang,_323,hub,arr,_324,_325,_326,has,Base,_327,dc,da,g,m,_328,df,du,_329){var _32a=0.2;var _32b=_323("dojox.charting.plot2d.Spider",[Base,_327],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:-10,labelStyle:"default",htmlLabels:true,startAngle:-90,divisions:3,axisColor:"",axisWidth:0,spiderColor:"",spiderWidth:0,seriesWidth:0,seriesFillAlpha:0.2,spiderOrigin:0.16,markerSize:3,spiderType:"polygon",animationType:_329.backOut,axisTickFont:"",axisTickFontColor:"",axisFont:"",axisFontColor:""},optionalParams:{radius:0,font:"",fontColor:""},constructor:function(_32c,_32d){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_32d);du.updateWithPattern(this.opt,_32d,this.optionalParams);this.dyn=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};},clear:function(){this.inherited(arguments);this.dyn=[];this.axes=[];this.datas={};this.labelKey=[];this.oldSeriePoints={};this.animations={};return this;},setAxis:function(axis){if(axis){if(axis.opt.min!=undefined){this.datas[axis.name].min=axis.opt.min;}if(axis.opt.max!=undefined){this.datas[axis.name].max=axis.opt.max;}}return this;},addSeries:function(run){this.series.push(run);var key;for(key in run.data){var val=run.data[key],data=this.datas[key];if(data){data.vlist.push(val);data.min=Math.min(data.min,val);data.max=Math.max(data.max,val);}else{var _32e="__"+key;this.axes.push(_32e);this[_32e]=key;this.datas[key]={min:val,max:val,vlist:[val]};}}if(this.labelKey.length<=0){for(key in run.data){this.labelKey.push(key);}}return this;},getSeriesStats:function(){return dc.collectSimpleStats(this.series);},render:function(dim,_32f){if(!this.dirty){return this;}this.dirty=false;this.cleanGroup();var s=this.group,t=this.chart.theme;this.resetEvents();if(!this.series||!this.series.length){return this;}var o=this.opt,ta=t.axis,rx=(dim.width-_32f.l-_32f.r)/2,ry=(dim.height-_32f.t-_32f.b)/2,r=Math.min(rx,ry),_330=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font)||"normal normal normal 7pt Tahoma",_331=o.axisFont||(ta.tick&&ta.tick.titleFont)||"normal normal normal 11pt Tahoma",_332=o.axisTickFontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"silver",_333=o.axisFontColor||(ta.tick&&ta.tick.titleFontColor)||"black",_334=o.axisColor||(ta.tick&&ta.tick.axisColor)||"silver",_335=o.spiderColor||(ta.tick&&ta.tick.spiderColor)||"silver",_336=o.axisWidth||(ta.stroke&&ta.stroke.width)||2,_337=o.spiderWidth||(ta.stroke&&ta.stroke.width)||2,_338=o.seriesWidth||(ta.stroke&&ta.stroke.width)||2,_339=g.normalizedLength(g.splitFontString(_331).size),_33a=m._degToRad(o.startAngle),_33b=_33a,_33c,_33d,_33e,_33f,_340,_341,_342,_343,ro=o.spiderOrigin,dv=o.divisions>=3?o.divisions:3,ms=o.markerSize,spt=o.spiderType,at=o.animationType,_344=o.labelOffset<-10?o.labelOffset:-10,_345=0.2,i,j,_346,len,_347,_348,_349,run,data,min,max,_34a;if(o.labels){_33c=arr.map(this.series,function(s){return s.name;},this);_33d=df.foldl1(df.map(_33c,function(_34b){var font=t.series.font;return g._base._getTextBox(_34b,{font:font}).w;},this),"Math.max(a, b)")/2;r=Math.min(rx-2*_33d,ry-_339)+_344;_33e=r-_344;}if("radius" in o){r=o.radius;_33e=r-_344;}r/=(1+_345);var _34c={cx:_32f.l+rx,cy:_32f.t+ry,r:r};for(i=this.series.length-1;i>=0;i--){_349=this.series[i];if(!this.dirty&&!_349.dirty){t.skip();continue;}_349.cleanGroup();run=_349.data;if(run!==null){len=this._getObjectLength(run);if(!_33f||_33f.length<=0){_33f=[],_340=[],_343=[];this._buildPoints(_33f,len,_34c,r,_33b,true,dim);this._buildPoints(_340,len,_34c,r*ro,_33b,true,dim);this._buildPoints(_343,len,_34c,_33e,_33b,false,dim);if(dv>2){_341=[],_342=[];for(j=0;j<dv-2;j++){_341[j]=[];this._buildPoints(_341[j],len,_34c,r*(ro+(1-ro)*(j+1)/(dv-1)),_33b,true,dim);_342[j]=r*(ro+(1-ro)*(j+1)/(dv-1));}}}}}var _34d=s.createGroup(),_34e={color:_334,width:_336},_34f={color:_335,width:_337};for(j=_33f.length-1;j>=0;--j){_346=_33f[j];var st={x:_346.x+(_346.x-_34c.cx)*_345,y:_346.y+(_346.y-_34c.cy)*_345},nd={x:_346.x+(_346.x-_34c.cx)*_345/2,y:_346.y+(_346.y-_34c.cy)*_345/2};_34d.createLine({x1:_34c.cx,y1:_34c.cy,x2:st.x,y2:st.y}).setStroke(_34e);this._drawArrow(_34d,st,nd,_34e);}var _350=s.createGroup();for(j=_343.length-1;j>=0;--j){_346=_343[j];_347=g._base._getTextBox(this.labelKey[j],{font:_331}).w||0;_348=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";var elem=da.createText[_348](this.chart,_350,(!_324.isBodyLtr()&&_348=="html")?(_346.x+_347-dim.width):_346.x,_346.y,"middle",this.labelKey[j],_331,_333);if(this.opt.htmlLabels){this.htmlElements.push(elem);}}var _351=s.createGroup();if(spt=="polygon"){_351.createPolyline(_33f).setStroke(_34f);_351.createPolyline(_340).setStroke(_34f);if(_341.length>0){for(j=_341.length-1;j>=0;--j){_351.createPolyline(_341[j]).setStroke(_34f);}}}else{_351.createCircle({cx:_34c.cx,cy:_34c.cy,r:r}).setStroke(_34f);_351.createCircle({cx:_34c.cx,cy:_34c.cy,r:r*ro}).setStroke(_34f);if(_342.length>0){for(j=_342.length-1;j>=0;--j){_351.createCircle({cx:_34c.cx,cy:_34c.cy,r:_342[j]}).setStroke(_34f);}}}len=this._getObjectLength(this.datas);var _352=s.createGroup(),k=0;for(var key in this.datas){data=this.datas[key];min=data.min;max=data.max;_34a=max-min;end=_33b+2*Math.PI*k/len;for(i=0;i<dv;i++){var text=min+_34a*i/(dv-1);_346=this._getCoordinate(_34c,r*(ro+(1-ro)*i/(dv-1)),end,dim);text=this._getLabel(text);_347=g._base._getTextBox(text,{font:_330}).w||0;_348=this.opt.htmlLabels&&g.renderer!="vml"?"html":"gfx";if(this.opt.htmlLabels){this.htmlElements.push(da.createText[_348](this.chart,_352,(!_324.isBodyLtr()&&_348=="html")?(_346.x+_347-dim.width):_346.x,_346.y,"start",text,_330,_332));}}k++;}this.chart.seriesShapes={};for(i=this.series.length-1;i>=0;i--){_349=this.series[i];run=_349.data;if(run!==null){var _353=[],_354=[];k=0;for(key in run){data=this.datas[key];min=data.min;max=data.max;_34a=max-min;var _355=run[key],end=_33b+2*Math.PI*k/len;_346=this._getCoordinate(_34c,r*(ro+(1-ro)*(_355-min)/_34a),end,dim);_353.push(_346);_354.push({sname:_349.name,key:key,data:_355});k++;}_353[_353.length]=_353[0];_354[_354.length]=_354[0];var _356=this._getBoundary(_353),_357=t.next("spider",[o,_349]),ts=_349.group,f=g.normalizeColor(_357.series.fill),sk={color:_357.series.fill,width:_338};f.a=o.seriesFillAlpha;_349.dyn={fill:f,stroke:sk};var osps=this.oldSeriePoints[_349.name];var cs=this._createSeriesEntry(ts,(osps||_340),_353,f,sk,r,ro,ms,at);this.chart.seriesShapes[_349.name]=cs;this.oldSeriePoints[_349.name]=_353;var po={element:"spider_poly",index:i,id:"spider_poly_"+_349.name,run:_349,plot:this,shape:cs.poly,parent:ts,brect:_356,cx:_34c.cx,cy:_34c.cy,cr:r,f:f,s:s};this._connectEvents(po);var so={element:"spider_plot",index:i,id:"spider_plot_"+_349.name,run:_349,plot:this,shape:_349.group};this._connectEvents(so);arr.forEach(cs.circles,function(c,i){var co={element:"spider_circle",index:i,id:"spider_circle_"+_349.name+i,run:_349,plot:this,shape:c,parent:ts,tdata:_354[i],cx:_353[i].x,cy:_353[i].y,f:f,s:s};this._connectEvents(co);},this);}}return this;},_createSeriesEntry:function(ts,osps,sps,f,sk,r,ro,ms,at){var _358=ts.createPolyline(osps).setFill(f).setStroke(sk),_359=[];for(var j=0;j<osps.length;j++){var _35a=osps[j],cr=ms;var _35b=ts.createCircle({cx:_35a.x,cy:_35a.y,r:cr}).setFill(f).setStroke(sk);_359.push(_35b);}var _35c=arr.map(sps,function(np,j){var sp=osps[j],anim=new _325.Animation({duration:1000,easing:at,curve:[sp.y,np.y]});var spl=_358,sc=_359[j];hub.connect(anim,"onAnimate",function(y){var _35d=spl.getShape();_35d.points[j].y=y;spl.setShape(_35d);var _35e=sc.getShape();_35e.cy=y;sc.setShape(_35e);});return anim;});var _35f=arr.map(sps,function(np,j){var sp=osps[j],anim=new _325.Animation({duration:1000,easing:at,curve:[sp.x,np.x]});var spl=_358,sc=_359[j];hub.connect(anim,"onAnimate",function(x){var _360=spl.getShape();_360.points[j].x=x;spl.setShape(_360);var _361=sc.getShape();_361.cx=x;sc.setShape(_361);});return anim;});var _362=_326.combine(_35c.concat(_35f));_362.play();return {group:ts,poly:_358,circles:_359};},plotEvent:function(o){if(o.element=="spider_plot"){if(o.type=="onmouseover"&&!has("ie")){o.shape.moveToFront();}}},tooltipFunc:function(o){if(o.element=="spider_circle"){return o.tdata.sname+"<br/>"+o.tdata.key+"<br/>"+o.tdata.data;}else{return null;}},_getBoundary:function(_363){var xmax=_363[0].x,xmin=_363[0].x,ymax=_363[0].y,ymin=_363[0].y;for(var i=0;i<_363.length;i++){var _364=_363[i];xmax=Math.max(_364.x,xmax);ymax=Math.max(_364.y,ymax);xmin=Math.min(_364.x,xmin);ymin=Math.min(_364.y,ymin);}return {x:xmin,y:ymin,width:xmax-xmin,height:ymax-ymin};},_drawArrow:function(s,_365,end,_366){var len=Math.sqrt(Math.pow(end.x-_365.x,2)+Math.pow(end.y-_365.y,2)),sin=(end.y-_365.y)/len,cos=(end.x-_365.x)/len,_367={x:end.x+(len/3)*(-sin),y:end.y+(len/3)*cos},_368={x:end.x+(len/3)*sin,y:end.y+(len/3)*(-cos)};s.createPolyline([_365,_367,_368]).setFill(_366.color).setStroke(_366);},_buildPoints:function(_369,_36a,_36b,_36c,_36d,_36e,dim){for(var i=0;i<_36a;i++){var end=_36d+2*Math.PI*i/_36a;_369.push(this._getCoordinate(_36b,_36c,end,dim));}if(_36e){_369.push(this._getCoordinate(_36b,_36c,_36d+2*Math.PI,dim));}},_getCoordinate:function(_36f,_370,_371,dim){var x=_36f.cx+_370*Math.cos(_371);if(has("dojo-bidi")&&this.chart.isRightToLeft()&&dim){x=dim.width-x;}return {x:x,y:_36f.cy+_370*Math.sin(_371)};},_getObjectLength:function(obj){var _372=0;if(lang.isObject(obj)){for(var key in obj){_372++;}}return _372;},_getLabel:function(_373){return dc.getLabel(_373,this.opt.fixed,this.opt.precision);}});return _32b;});},"dojox/charting/plot2d/StackedBars":function(){define(["dojo/_base/declare","./Bars","./commonStacked"],function(_374,Bars,_375){return _374("dojox.charting.plot2d.StackedBars",Bars,{getSeriesStats:function(){var _376=_375.collectStats(this.series),t;_376.hmin-=0.5;_376.hmax+=0.5;t=_376.hmin,_376.hmin=_376.vmin,_376.vmin=t;t=_376.hmax,_376.hmax=_376.vmax,_376.vmax=t;return _376;},getValue:function(_377,_378,_379,_37a){var y,x;if(_37a){x=_378;y=_375.getIndexValue(this.series,_379,x);}else{x=_377.x-1;y=_375.getValue(this.series,_379,_377.x);y=[y[0]?y[0].y:null,y[1]?y[1]:null];}return {x:x,y:y[0],py:y[1]};}});});},"dojox/charting/themes/GreySkies":function(){define(["../SimpleTheme","./common"],function(_37b,_37c){_37c.GreySkies=new _37b();return _37c.GreySkies;});},"dijit/place":function(){define(["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","./Viewport","./main"],function(_37d,_37e,_37f,_380,win,_381,_382){function _383(node,_384,_385,_386){var view=_381.getEffectiveBox(node.ownerDocument);if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){win.body(node.ownerDocument).appendChild(node);}var best=null;_37d.some(_384,function(_387){var _388=_387.corner;var pos=_387.pos;var _389=0;var _38a={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_388.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_388.charAt(0)]};var s=node.style;s.left=s.right="auto";if(_385){var res=_385(node,_387.aroundCorner,_388,_38a,_386);_389=typeof res=="undefined"?0:res;}var _38b=node.style;var _38c=_38b.display;var _38d=_38b.visibility;if(_38b.display=="none"){_38b.visibility="hidden";_38b.display="";}var bb=_37e.position(node);_38b.display=_38c;_38b.visibility=_38d;var _38e={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(bb.w>>1))-bb.w)}[_388.charAt(1)],_38f={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(bb.h>>1))-bb.h)}[_388.charAt(0)],_390=Math.max(view.l,_38e),_391=Math.max(view.t,_38f),endX=Math.min(view.l+view.w,_38e+bb.w),endY=Math.min(view.t+view.h,_38f+bb.h),_392=endX-_390,_393=endY-_391;_389+=(bb.w-_392)+(bb.h-_393);if(best==null||_389<best.overflow){best={corner:_388,aroundCorner:_387.aroundCorner,x:_390,y:_391,w:_392,h:_393,overflow:_389,spaceAvailable:_38a};}return !_389;});if(best.overflow&&_385){_385(node,best.aroundCorner,best.corner,best.spaceAvailable,_386);}var l=_37e.isBodyLtr(node.ownerDocument),top=best.y,side=l?best.x:view.w-best.x-best.w;if(/relative|absolute/.test(_37f.get(win.body(node.ownerDocument),"position"))){top-=_37f.get(win.body(node.ownerDocument),"marginTop");side-=(l?1:-1)*_37f.get(win.body(node.ownerDocument),l?"marginLeft":"marginRight");}var s=node.style;s.top=top+"px";s[l?"left":"right"]=side+"px";s[l?"right":"left"]="auto";return best;};var _394={"TL":"BR","TR":"BL","BL":"TR","BR":"TL"};var _395={at:function(node,pos,_396,_397,_398){var _399=_37d.map(_396,function(_39a){var c={corner:_39a,aroundCorner:_394[_39a],pos:{x:pos.x,y:pos.y}};if(_397){c.pos.x+=_39a.charAt(1)=="L"?_397.x:-_397.x;c.pos.y+=_39a.charAt(0)=="T"?_397.y:-_397.y;}return c;});return _383(node,_399,_398);},around:function(node,_39b,_39c,_39d,_39e){var _39f;if(typeof _39b=="string"||"offsetWidth" in _39b){_39f=_37e.position(_39b,true);if(/^(above|below)/.test(_39c[0])){var _3a0=_37e.getBorderExtents(_39b),_3a1=_39b.firstChild?_37e.getBorderExtents(_39b.firstChild):{t:0,l:0,b:0,r:0},_3a2=_37e.getBorderExtents(node),_3a3=node.firstChild?_37e.getBorderExtents(node.firstChild):{t:0,l:0,b:0,r:0};_39f.y+=Math.min(_3a0.t+_3a1.t,_3a2.t+_3a3.t);_39f.h-=Math.min(_3a0.t+_3a1.t,_3a2.t+_3a3.t)+Math.min(_3a0.b+_3a1.b,_3a2.b+_3a3.b);}}else{_39f=_39b;}if(_39b.parentNode){var _3a4=_37f.getComputedStyle(_39b).position=="absolute";var _3a5=_39b.parentNode;while(_3a5&&_3a5.nodeType==1&&_3a5.nodeName!="BODY"){var _3a6=_37e.position(_3a5,true),pcs=_37f.getComputedStyle(_3a5);if(/relative|absolute/.test(pcs.position)){_3a4=false;}if(!_3a4&&/hidden|auto|scroll/.test(pcs.overflow)){var _3a7=Math.min(_39f.y+_39f.h,_3a6.y+_3a6.h);var _3a8=Math.min(_39f.x+_39f.w,_3a6.x+_3a6.w);_39f.x=Math.max(_39f.x,_3a6.x);_39f.y=Math.max(_39f.y,_3a6.y);_39f.h=_3a7-_39f.y;_39f.w=_3a8-_39f.x;}if(pcs.position=="absolute"){_3a4=true;}_3a5=_3a5.parentNode;}}var x=_39f.x,y=_39f.y,_3a9="w" in _39f?_39f.w:(_39f.w=_39f.width),_3aa="h" in _39f?_39f.h:(_380.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_39f.height+", width:"+_3a9+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_39f.height+", w:"+_3a9+" }","","2.0"),_39f.h=_39f.height);var _3ab=[];function push(_3ac,_3ad){_3ab.push({aroundCorner:_3ac,corner:_3ad,pos:{x:{"L":x,"R":x+_3a9,"M":x+(_3a9>>1)}[_3ac.charAt(1)],y:{"T":y,"B":y+_3aa,"M":y+(_3aa>>1)}[_3ac.charAt(0)]}});};_37d.forEach(_39c,function(pos){var ltr=_39d;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after-centered":ltr=!ltr;case "before-centered":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "after":ltr=!ltr;case "before":push(ltr?"TL":"TR",ltr?"TR":"TL");push(ltr?"BL":"BR",ltr?"BR":"BL");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _3ae=_383(node,_3ab,_39e,{w:_3a9,h:_3aa});_3ae.aroundNodePos=_39f;return _3ae;}};return _382.place=_395;});},"dojox/charting/plot2d/Columns":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_3af,has,_3b0,_3b1,dc,df,dfr,du,fx){var _3b2=dfr.lambda("item.purgeGroup()");return _3af("dojox.charting.plot2d.Columns",[_3b0,_3b1],{defaultParams:{gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:""},constructor:function(_3b3,_3b4){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_3b4);du.updateWithPattern(this.opt,_3b4,this.optionalParams);this.animate=this.opt.animate;},getSeriesStats:function(){var _3b5=dc.collectSimpleStats(this.series);_3b5.hmin-=0.5;_3b5.hmax+=0.5;return _3b5;},createRect:function(run,_3b6,_3b7){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_3b7);_3b6.add(rect);}else{rect=_3b6.createRect(_3b7);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_3b8){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_3b8);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_3b2);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_3b9=Math.max(0,this._vScaler.bounds.lower),_3ba=vt(_3b9),_3bb=this.events();var bar=this.getBarProperties();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _3bc=t.next("column",[this.opt,run]),_3bd=new Array(run.data.length);s=run.group;var _3be=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var min=_3be?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0;var max=_3be?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length;for(var j=min;j<max;++j){var _3bf=run.data[j];if(_3bf!=null){var val=this.getValue(_3bf,j,i,_3be),vv=vt(val.y),h=Math.abs(vv-_3ba),_3c0,_3c1;if(this.opt.styleFunc||typeof _3bf!="number"){var _3c2=typeof _3bf!="number"?[_3bf]:[];if(this.opt.styleFunc){_3c2.push(this.opt.styleFunc(_3bf));}_3c0=t.addMixin(_3bc,"column",_3c2,true);}else{_3c0=t.post(_3bc,"column");}if(bar.width>=1&&h>=0){var rect={x:_3b8.l+ht(val.x+0.5)+bar.gap+bar.thickness*i,y:dim.height-_3b8.b-(val.y>_3b9?vv:_3ba),width:bar.width,height:h};if(_3c0.series.shadow){var _3c3=lang.clone(rect);_3c3.x+=_3c0.series.shadow.dx;_3c3.y+=_3c0.series.shadow.dy;_3c1=this.createRect(run,s,_3c3).setFill(_3c0.series.shadow.color).setStroke(_3c0.series.shadow);if(this.animate){this._animateColumn(_3c1,dim.height-_3b8.b+_3ba,h);}}var _3c4=this._plotFill(_3c0.series.fill,dim,_3b8);_3c4=this._shapeFill(_3c4,rect);var _3c5=this.createRect(run,s,rect).setFill(_3c4).setStroke(_3c0.series.stroke);if(_3c5.setFilter&&_3c0.series.filter){_3c5.setFilter(_3c0.series.filter);}run.dyn.fill=_3c5.getFill();run.dyn.stroke=_3c5.getStroke();if(_3bb){var o={element:"column",index:j,run:run,shape:_3c5,shadow:_3c1,cx:val.x+0.5,cy:val.y,x:_3be?j:run.data[j].x,y:_3be?run.data[j]:run.data[j].y};this._connectEvents(o);_3bd[j]=o;}if(!isNaN(val.py)&&val.py>_3b9){rect.height=vv-vt(val.py);}this.createLabel(s,_3bf,rect,_3c0);if(this.animate){this._animateColumn(_3c5,dim.height-_3b8.b-_3ba,h);}}}}this._eventSeries[run.name]=_3bd;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_3b8);}return this;},getValue:function(_3c6,j,_3c7,_3c8){var y,x;if(_3c8){if(typeof _3c6=="number"){y=_3c6;}else{y=_3c6.y;}x=j;}else{y=_3c6.y;x=_3c6.x-1;}return {x:x,y:y};},getBarProperties:function(){var f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);return {gap:f.gap,width:f.size,thickness:0};},_animateColumn:function(_3c9,_3ca,_3cb){if(_3cb==0){_3cb=1;}fx.animateTransform(lang.delegate({shape:_3c9,duration:1200,transform:[{name:"translate",start:[0,_3ca-(_3ca/_3cb)],end:[0,0]},{name:"scale",start:[1,1/_3cb],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/lang/functional/array":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","./lambda"],function(_3cc,lang,arr,df){var _3cd={};lang.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3cc.global;f=df.lambda(f);var t=[],v,i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _3cd)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3cc.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _3cd)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3cc.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _3cd)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3cc.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _3cd)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_3cc.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _3cd)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});return df;});},"dojox/charting/themes/common":function(){define(["dojo/_base/lang"],function(lang){return lang.getObject("dojox.charting.themes",true);});},"dojox/charting/plot2d/common":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojox/gfx","dojox/lang/functional","../scaler/common"],function(lang,arr,_3ce,g,df,sc){var _3cf=lang.getObject("dojox.charting.plot2d.common",true);return lang.mixin(_3cf,{doIfLoaded:sc.doIfLoaded,makeStroke:function(_3d0){if(!_3d0){return _3d0;}if(typeof _3d0=="string"||_3d0 instanceof _3ce){_3d0={color:_3d0};}return g.makeParameters(g.defaultStroke,_3d0);},augmentColor:function(_3d1,_3d2){var t=new _3ce(_3d1),c=new _3ce(_3d2);c.a=t.a;return c;},augmentStroke:function(_3d3,_3d4){var s=_3cf.makeStroke(_3d3);if(s){s.color=_3cf.augmentColor(s.color,_3d4);}return s;},augmentFill:function(fill,_3d5){var fc,c=new _3ce(_3d5);if(typeof fill=="string"||fill instanceof _3ce){return _3cf.augmentColor(fill,_3d5);}return fill;},defaultStats:{vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY,hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_3d6){var _3d7=lang.delegate(_3cf.defaultStats);for(var i=0;i<_3d6.length;++i){var run=_3d6[i];for(var j=0;j<run.data.length;j++){if(run.data[j]!==null){if(typeof run.data[j]=="number"){var _3d8=_3d7.vmin,_3d9=_3d7.vmax;if(!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x=i+1,y=val;if(isNaN(y)){y=0;}_3d7.hmin=Math.min(_3d7.hmin,x);_3d7.hmax=Math.max(_3d7.hmax,x);_3d7.vmin=Math.min(_3d7.vmin,y);_3d7.vmax=Math.max(_3d7.vmax,y);}});}if("ymin" in run){_3d7.vmin=Math.min(_3d8,run.ymin);}if("ymax" in run){_3d7.vmax=Math.max(_3d9,run.ymax);}}else{var _3da=_3d7.hmin,_3db=_3d7.hmax,_3d8=_3d7.vmin,_3d9=_3d7.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(val!==null){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_3d7.hmin=Math.min(_3d7.hmin,x);_3d7.hmax=Math.max(_3d7.hmax,x);_3d7.vmin=Math.min(_3d7.vmin,y);_3d7.vmax=Math.max(_3d7.vmax,y);}});}if("xmin" in run){_3d7.hmin=Math.min(_3da,run.xmin);}if("xmax" in run){_3d7.hmax=Math.max(_3db,run.xmax);}if("ymin" in run){_3d7.vmin=Math.min(_3d8,run.ymin);}if("ymax" in run){_3d7.vmax=Math.max(_3d9,run.ymax);}}break;}}}return _3d7;},calculateBarSize:function(_3dc,opt,_3dd){if(!_3dd){_3dd=1;}var gap=opt.gap,size=(_3dc-2*gap)/_3dd;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_3dc-size*_3dd)/2;return {size:size,gap:gap};},collectStackedStats:function(_3de){var _3df=lang.clone(_3cf.defaultStats);if(_3de.length){_3df.hmin=Math.min(_3df.hmin,1);_3df.hmax=df.foldl(_3de,"seed, run -> Math.max(seed, run.data.length)",_3df.hmax);for(var i=0;i<_3df.hmax;++i){var v=_3de[0].data[i];v=v&&(typeof v=="number"?v:v.y);if(isNaN(v)){v=0;}_3df.vmin=Math.min(_3df.vmin,v);for(var j=1;j<_3de.length;++j){var t=_3de[j].data[i];t=t&&(typeof t=="number"?t:t.y);if(isNaN(t)){t=0;}v+=t;}_3df.vmax=Math.max(_3df.vmax,v);}}return _3df;},curve:function(a,_3e0){var _3e1=a.slice(0);if(_3e0=="x"){_3e1[_3e1.length]=_3e1[0];}var p=arr.map(_3e1,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_3e0)){var dx=item.x-_3e1[i-1].x,dy=_3e1[i-1].y;return "C"+(item.x-(_3e0-1)*(dx/_3e0))+","+dy+" "+(item.x-(dx/_3e0))+","+item.y+" "+item.x+","+item.y;}else{if(_3e0=="X"||_3e0=="x"||_3e0=="S"){var p0,p1=_3e1[i-1],p2=_3e1[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_3e0=="x"){p0=_3e1[_3e1.length-2];}else{p0=p1;}f=1/3;}else{p0=_3e1[i-2];}if(i==(_3e1.length-1)){if(_3e0=="x"){p3=_3e1[1];}else{p3=p2;}f=1/3;}else{p3=_3e1[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _3e2=p0p2*f;var _3e3=p1p3*f;if(_3e2>p1p2/2&&_3e3>p1p2/2){_3e2=p1p2/2;_3e3=p1p2/2;}else{if(_3e2>p1p2/2){_3e2=p1p2/2;_3e3=p1p2/2*p1p3/p0p2;}else{if(_3e3>p1p2/2){_3e3=p1p2/2;_3e2=p1p2/2*p0p2/p1p3;}}}if(_3e0=="S"){if(p0==p1){_3e2=0;}if(p2==p3){_3e3=0;}}bz1x=p1.x+_3e2*(p2.x-p0.x)/p0p2;bz1y=p1.y+_3e2*(p2.y-p0.y)/p0p2;bz2x=p2.x-_3e3*(p3.x-p1.x)/p1p3;bz2y=p2.y-_3e3*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");},getLabel:function(_3e4,_3e5,_3e6){return sc.doIfLoaded("dojo/number",function(_3e7){return (_3e5?_3e7.format(_3e4,{places:_3e6}):_3e7.format(_3e4))||"";},function(){return _3e5?_3e4.toFixed(_3e6):_3e4.toString();});}});});},"dijit/_Widget":function(){define(["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_3e8,_3e9,_3ea,_3eb,has,_3ec,lang,_3ed,_3ee,_3ef,_3f0,_3f1,_3f2){function _3f3(){};function _3f4(_3f5){return function(obj,_3f6,_3f7,_3f8){if(obj&&typeof _3f6=="string"&&obj[_3f6]==_3f3){return obj.on(_3f6.substring(2).toLowerCase(),lang.hitch(_3f7,_3f8));}return _3f5.apply(_3ea,arguments);};};_3e8.around(_3ea,"connect",_3f4);if(_3ec.connect){_3e8.around(_3ec,"connect",_3f4);}var _3f9=_3eb("dijit._Widget",[_3f0,_3f1,_3f2],{onClick:_3f3,onDblClick:_3f3,onKeyDown:_3f3,onKeyPress:_3f3,onKeyUp:_3f3,onMouseDown:_3f3,onMouseMove:_3f3,onMouseOut:_3f3,onMouseOver:_3f3,onMouseLeave:_3f3,onMouseEnter:_3f3,onMouseUp:_3f3,constructor:function(_3fa){this._toConnect={};for(var name in _3fa){if(this[name]===_3f3){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_3fa[name];delete _3fa[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_3f3){return _3ea.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_3fb){_3ec.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_3fb);},attr:function(name,_3fc){if(_3e9.isDebug){var _3fd=arguments.callee._ach||(arguments.callee._ach={}),_3fe=(arguments.callee.caller||"unknown caller").toString();if(!_3fd[_3fe]){_3ec.deprecated(this.declaredClass+"::attr() is deprecated. Use get() or set() instead, called from "+_3fe,"","2.0");_3fd[_3fe]=true;}}var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_3ec.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_3ed("[widgetId]",this.containerNode).map(_3ef.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(has("dijit-legacy-requires")){_3ee(0,function(){var _3ff=["dijit/_base"];require(_3ff);});}return _3f9;});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo){return dojo.cache;});},"dijit/_FocusMixin":function(){define(["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_400,_401,_402,lang){lang.extend(_401,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _402("dijit._FocusMixin",null,{_focusManager:_400});});},"dijit/_OnDijitClickMixin":function(){define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","./a11yclick"],function(on,_403,keys,_404,has,_405){var ret=_404("dijit._OnDijitClickMixin",null,{connect:function(obj,_406,_407){return this.inherited(arguments,[obj,_406=="ondijitclick"?_405:_406,_407]);}});ret.a11yclick=_405;return ret;});},"dojox/charting/plot2d/Bars":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/gfx/fx","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/reversed"],function(lang,arr,_408,has,_409,_40a,dc,fx,du,df,dfr){var _40b=dfr.lambda("item.purgeGroup()");return _408("dojox.charting.plot2d.Bars",[_409,_40a],{defaultParams:{gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:""},constructor:function(_40c,_40d){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_40d);du.updateWithPattern(this.opt,_40d,this.optionalParams);this.animate=this.opt.animate;},getSeriesStats:function(){var _40e=dc.collectSimpleStats(this.series),t;_40e.hmin-=0.5;_40e.hmax+=0.5;t=_40e.hmin,_40e.hmin=_40e.vmin,_40e.vmin=t;t=_40e.hmax,_40e.hmax=_40e.vmax,_40e.vmax=t;return _40e;},createRect:function(run,_40f,_410){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_410);_40f.add(rect);}else{rect=_40f.createRect(_410);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},createLabel:function(_411,_412,bbox,_413){if(this.opt.labels&&this.opt.labelStyle=="outside"){var y=bbox.y+bbox.height/2;var x=bbox.x+bbox.width+this.opt.labelOffset;this.renderLabel(_411,x,y,this._getLabel(isNaN(_412.y)?_412:_412.y),_413,"start");}else{this.inherited(arguments);}},render:function(dim,_414){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_414);}this.dirty=this.isDirty();this.resetEvents();var s;if(this.dirty){arr.forEach(this.series,_40b);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_415=Math.max(0,this._hScaler.bounds.lower),_416=ht(_415),_417=this.events();var bar=this.getBarProperties();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _418=t.next("bar",[this.opt,run]),_419=new Array(run.data.length);s=run.group;var _41a=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var min=_41a?Math.max(0,Math.floor(this._vScaler.bounds.from-1)):0;var max=_41a?Math.min(run.data.length,Math.ceil(this._vScaler.bounds.to)):run.data.length;for(var j=min;j<max;++j){var _41b=run.data[j];if(_41b!=null){var val=this.getValue(_41b,j,i,_41a),hv=ht(val.y),w=Math.abs(hv-_416),_41c,_41d;if(this.opt.styleFunc||typeof _41b!="number"){var _41e=typeof _41b!="number"?[_41b]:[];if(this.opt.styleFunc){_41e.push(this.opt.styleFunc(_41b));}_41c=t.addMixin(_418,"bar",_41e,true);}else{_41c=t.post(_418,"bar");}if(w>=0&&bar.height>=1){var rect={x:_414.l+(val.y<_415?hv:_416),y:dim.height-_414.b-vt(val.x+1.5)+bar.gap+bar.thickness*(this.series.length-i-1),width:w,height:bar.height};if(_41c.series.shadow){var _41f=lang.clone(rect);_41f.x+=_41c.series.shadow.dx;_41f.y+=_41c.series.shadow.dy;_41d=this.createRect(run,s,_41f).setFill(_41c.series.shadow.color).setStroke(_41c.series.shadow);if(this.animate){this._animateBar(_41d,_414.l+_416,-w);}}var _420=this._plotFill(_41c.series.fill,dim,_414);_420=this._shapeFill(_420,rect);var _421=this.createRect(run,s,rect).setFill(_420).setStroke(_41c.series.stroke);if(_421.setFilter&&_41c.series.filter){_421.setFilter(_41c.series.filter);}run.dyn.fill=_421.getFill();run.dyn.stroke=_421.getStroke();if(_417){var o={element:"bar",index:j,run:run,shape:_421,shadow:_41d,cx:val.y,cy:val.x+1.5,x:_41a?j:run.data[j].x,y:_41a?run.data[j]:run.data[j].y};this._connectEvents(o);_419[j]=o;}if(!isNaN(val.py)&&val.py>_415){rect.x+=ht(val.py);rect.width-=ht(val.py);}this.createLabel(s,_41b,rect,_41c);if(this.animate){this._animateBar(_421,_414.l+_416,-w);}}}}this._eventSeries[run.name]=_419;run.dirty=false;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_414);}return this;},getValue:function(_422,j,_423,_424){var y,x;if(_424){if(typeof _422=="number"){y=_422;}else{y=_422.y;}x=j;}else{y=_422.y;x=_422.x-1;}return {y:y,x:x};},getBarProperties:function(){var f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);return {gap:f.gap,height:f.size,thickness:0};},_animateBar:function(_425,_426,_427){if(_427==0){_427=1;}fx.animateTransform(lang.delegate({shape:_425,duration:1200,transform:[{name:"translate",start:[_426-(_426/_427),0],end:[0,0]},{name:"scale",start:[1/_427,1],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/gfx/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(_428,lang,_429,has,win,arr,dom,_42a,_42b){var g=lang.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(node,_42c){var cls=node.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_42c+" ")>=0;};g._addClass=function(node,_42d){var cls=node.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_42d+" ")<0){node.setAttribute("className",cls+(cls?" ":"")+_42d);}};g._removeClass=function(node,_42e){var cls=node.getAttribute("className");if(cls){node.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_42e+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _42f={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p;if(has("ie")){win.doc.documentElement.style.fontSize="100%";}var div=_42a.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _42f){div.style.fontSize=p;_42f[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}win.body().removeChild(div);return _42f;};var _430=null;b._getCachedFontMeasurements=function(_431){if(_431||!_430){_430=b._getFontMeasurements();}return _430;};var _432=null,_433={};b._getTextBox=function(text,_434,_435){var m,s,al=arguments.length;var i;if(!_432){_432=_42a.create("div",{style:{position:"absolute",top:"-10000px",left:"0"}},win.body());}m=_432;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_434){for(i in _434){if(i in _433){continue;}s[i]=_434[i];}}if(al>2&&_435){m.className=_435;}m.innerHTML=text;if(m["getBoundingClientRect"]){var bcr=m.getBoundingClientRect();return {l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{return _42b.getMarginBox(m);}};b._computeTextLocation=function(_436,_437,_438,_439){var loc={},_43a=_436.align;switch(_43a){case "end":loc.x=_436.x-_437;break;case "middle":loc.x=_436.x-_437/2;break;default:loc.x=_436.x;break;}var c=_439?0.75:1;loc.y=_436.y-_438*c;return loc;};b._computeTextBoundingBox=function(s){if(!g._base._isRendered(s)){return {x:0,y:0,width:0,height:0};}var loc,_43b=s.getShape(),font=s.getFont()||g.defaultFont,w=s.getTextWidth(),h=g.normalizedLength(font.size);loc=b._computeTextLocation(_43b,w,h,true);return {x:loc.x,y:loc.y,width:w,height:h};};b._isRendered=function(s){var p=s.parent;while(p&&p.getParent){p=p.parent;}return p!==null;};var _43c=0;b._getUniqueId=function(){var id;do{id=_428._scopeName+"xUnique"+(++_43c);}while(dom.byId(id));return id;};b._fixMsTouchAction=function(_43d){var r=_43d.rawNode;if(typeof r.style.msTouchAction!="undefined"){r.style.msTouchAction="none";}};lang.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _43e={};return function(type){var t=_43e[type];if(t){return new t();}t=_43e[type]=new Function();t.prototype=g["default"+type];return new t();};})(),normalizeColor:function(_43f){return (_43f instanceof _429)?_43f:new _429(_43f);},normalizeParameters:function(_440,_441){var x;if(_441){var _442={};for(x in _440){if(x in _441&&!(x in _442)){_440[x]=_441[x];}}}return _440;},makeParameters:function(_443,_444){var i=null;if(!_444){return lang.delegate(_443);}var _445={};for(i in _443){if(!(i in _445)){_445[i]=lang.clone((i in _444)?_444[i]:_443[i]);}}return _445;},formatNumber:function(x,_446){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _447=val.indexOf(".");if(_447>=0&&val.length-_447>5){val=x.toFixed(4);}}if(x<0){return val;}return _446?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _448=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_448;case "in":return val*72*_448;case "pc":return val*12*_448;case "mm":return val*g.mm_in_pt*_448;case "cm":return val*g.cm_in_pt*_448;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_449){var ns=typeof _449=="string"?g[_449]:_449;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(name){g[name]=ns[name];});if(typeof _449=="string"){g.renderer=_449;}else{arr.some(["svg","vml","canvas","canvasWithEvents","silverlight"],function(r){return (g.renderer=g[r]&&g[r].Surface===g.Surface?r:null);});}}}});return g;});},"dojox/charting/plot2d/CartesianBase":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/has","./Base","../scaler/primitive","dojox/gfx","dojox/gfx/fx","dojox/lang/utils"],function(lang,_44a,hub,has,Base,_44b,gfx,fx,du){return _44a("dojox.charting.plot2d.CartesianBase",Base,{baseParams:{hAxis:"x",vAxis:"y",labels:false,labelOffset:10,fixed:true,precision:1,labelStyle:"inside",htmlLabels:true,omitLabels:true},constructor:function(_44c,_44d){this.axes=["hAxis","vAxis"];this.zoom=null;this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};this.hAxis=(_44d&&_44d.hAxis)||"x";this.vAxis=(_44d&&_44d.vAxis)||"y";this.series=[];this.opt=lang.clone(this.baseParams);du.updateWithObject(this.opt,_44d);},clear:function(){this.inherited(arguments);this._hAxis=null;this._vAxis=null;return this;},cleanGroup:function(_44e,_44f){this.inherited(arguments);if(!_44f&&this.chart._nativeClip){var _450=this.chart.offsets,dim=this.chart.dim;var w=Math.max(0,dim.width-_450.l-_450.r),h=Math.max(0,dim.height-_450.t-_450.b);this.group.setClip({x:_450.l,y:_450.t,width:w,height:h});if(!this._clippedGroup){this._clippedGroup=this.group.createGroup();}}},purgeGroup:function(){this.inherited(arguments);this._clippedGroup=null;},getGroup:function(){return this._clippedGroup||this.group;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},toPage:function(_451){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromModel(sh),tv=sv.scaler.getTransformerFromModel(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_452){var r={};r.x=th(_452[ah.name])+c.x+o.l;r.y=c.y+dim.height-o.b-tv(_452[av.name]);return r;};return _451?t(_451):t;},toData:function(_453){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromPlot(sh),tv=sv.scaler.getTransformerFromPlot(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_454){var r={};r[ah.name]=th(_454.x-c.x-o.l);r[av.name]=tv(c.y+dim.height-_454.y-o.b);return r;};return _453?t(_453):t;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},createLabel:function(_455,_456,bbox,_457){if(this.opt.labels){var x,y,_458=this.opt.labelFunc?this.opt.labelFunc.apply(this,[_456,this.opt.fixed,this.opt.precision]):this._getLabel(isNaN(_456.y)?_456:_456.y);if(this.opt.labelStyle=="inside"){var lbox=gfx._base._getTextBox(_458,{font:_457.series.font});x=bbox.x+bbox.width/2;y=bbox.y+bbox.height/2+lbox.h/4;if(lbox.w>bbox.width||lbox.h>bbox.height){return;}}else{x=bbox.x+bbox.width/2;y=bbox.y-this.opt.labelOffset;}this.renderLabel(_455,x,y,_458,_457,this.opt.labelStyle=="inside");}},performZoom:function(dim,_459){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_45a=dim.height-_459.b,_45b=this._hScaler.bounds,_45c=(_45b.from-_45b.lower)*_45b.scale,_45d=this._vScaler.bounds,_45e=(_45d.from-_45d.lower)*_45d.scale,_45f=vs/this.lastWindow.vscale,_460=hs/this.lastWindow.hscale,_461=(this.lastWindow.xoffset-_45c)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),_462=(_45e-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),_463=this.getGroup(),anim=fx.animateTransform(lang.delegate({shape:_463,duration:1200,transform:[{name:"translate",start:[0,0],end:[_459.l*(1-_460),_45a*(1-_45f)]},{name:"scale",start:[1,1],end:[_460,_45f]},{name:"original"},{name:"translate",start:[0,0],end:[_461,_462]}]},this.zoom));lang.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_45c,yoffset:_45e});this.zoomQueue.push(anim);hub.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},initializeScalers:function(dim,_464){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_464.hmin,_464.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=_44b.buildScaler(_464.hmin,_464.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_464.vmin,_464.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=_44b.buildScaler(_464.vmin,_464.vmax,dim.height);}return this;}});});},"dijit/focus":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/domReady","dojo/sniff","dojo/Stateful","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_465,_466,dom,_467,_468,_469,lang,on,_46a,has,_46b,win,_46c,a11y,_46d,_46e){var _46f;var _470=_466([_46b,_469],{curNode:null,activeStack:[],constructor:function(){var _471=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_465.before(_468,"empty",_471);_465.before(_468,"destroy",_471);},registerIframe:function(_472){return this.registerWin(_472.contentWindow,_472);},registerWin:function(_473,_474){var _475=this,body=_473.document&&_473.document.body;if(body){var mdh=on(_473.document,"mousedown, touchstart",function(evt){_475._justMouseDowned=true;setTimeout(function(){_475._justMouseDowned=false;},0);if(evt&&evt.target&&evt.target.parentNode==null){return;}_475._onTouchNode(_474||evt.target,"mouse");});var fih=on(body,"focusin",function(evt){_46f=(new Date()).getTime();if(!evt.target.tagName){return;}var tag=evt.target.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isTabNavigable(evt.target)){_475._onFocusNode(_474||evt.target);}else{_475._onTouchNode(_474||evt.target);}});var foh=on(body,"focusout",function(evt){if((new Date()).getTime()<_46f+100){return;}_475._onBlurNode(_474||evt.target);});return {remove:function(){mdh.remove();fih.remove();foh.remove();mdh=fih=foh=null;body=null;}};}},_onBlurNode:function(node){if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);}this._clearFocusTimer=setTimeout(lang.hitch(this,function(){this.set("prevNode",this.curNode);this.set("curNode",null);}),0);if(this._justMouseDowned){return;}if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);}),0);},_onTouchNode:function(node,by){if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}var _476=[];try{while(node){var _477=_467.get(node,"dijitPopupParent");if(_477){node=_46d.byId(_477).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_46c.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_478=id&&_46d.byId(id);if(_478&&!(by=="mouse"&&_478.get("disabled"))){_476.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_476,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);delete this._clearFocusTimer;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("prevNode",this.curNode);this.set("curNode",node);},_setStack:function(_479,by){var _47a=this.activeStack,_47b=_47a.length-1,_47c=_479.length-1;if(_479[_47c]==_47a[_47b]){return;}this.set("activeStack",_479);var _47d,i;for(i=_47b;i>=0&&_47a[i]!=_479[i];i--){_47d=_46d.byId(_47a[i]);if(_47d){_47d._hasBeenBlurred=true;_47d.set("focused",false);if(_47d._focusManager==this){_47d._onBlur(by);}this.emit("widget-blur",_47d,by);}}for(i++;i<=_47c;i++){_47d=_46d.byId(_479[i]);if(_47d){_47d.set("focused",true);if(_47d._focusManager==this){_47d._onFocus(by);}this.emit("widget-focus",_47d,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _47e=new _470();_46a(function(){var _47f=_47e.registerWin(_46c.get(document));if(has("ie")){on(window,"unload",function(){if(_47f){_47f.remove();_47f=null;}});}});_46e.focus=function(node){_47e.focus(node);};for(var attr in _47e){if(!/^_/.test(attr)){_46e.focus[attr]=typeof _47e[attr]=="function"?lang.hitch(_47e,attr):_47e[attr];}}_47e.watch(function(attr,_480,_481){_46e.focus[attr]=_481;});return _47e;});},"dojox/charting/widget/Legend":function(){define(["dojo/_base/declare","dijit/_WidgetBase","dojox/gfx","dojo/_base/array","dojo/has","dojo/has!dojo-bidi?../bidi/widget/Legend","dojox/lang/functional","dojo/dom","dojo/dom-construct","dojo/dom-class","dijit/registry"],function(_482,_483,gfx,arr,has,_484,df,dom,_485,_486,_487){var _488=_482(has("dojo-bidi")?"dojox.charting.widget.NonBidiLegend":"dojox.charting.widget.Legend",_483,{chartRef:"",horizontal:true,swatchSize:18,legendBody:null,postCreate:function(){if(!this.chart&&this.chartRef){this.chart=_487.byId(this.chartRef)||_487.byNode(dom.byId(this.chartRef));if(!this.chart){}}this.chart=this.chart.chart||this.chart;this.refresh();},buildRendering:function(){this.domNode=_485.create("table",{role:"group","aria-label":"chart legend","class":"dojoxLegendNode"});this.legendBody=_485.create("tbody",null,this.domNode);this.inherited(arguments);},destroy:function(){if(this._surfaces){arr.forEach(this._surfaces,function(_489){_489.destroy();});}this.inherited(arguments);},refresh:function(){if(this._surfaces){arr.forEach(this._surfaces,function(_48a){_48a.destroy();});}this._surfaces=[];while(this.legendBody.lastChild){_485.destroy(this.legendBody.lastChild);}if(this.horizontal){_486.add(this.domNode,"dojoxLegendHorizontal");this._tr=_485.create("tr",null,this.legendBody);this._inrow=0;}var s=this.series||this.chart.series;if(s.length==0){return;}if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var _48b=df.map(t.run.data,"Math.max(x, 0)");var _48c=df.map(_48b,"/this",df.foldl(_48b,"+",0));arr.forEach(_48c,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{arr.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{arr.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,_48d){var _48e=_485.create("td"),icon=_485.create("div",null,_48e),text=_485.create("label",null,_48e),div=_485.create("div",{style:{"width":this.swatchSize+"px","height":this.swatchSize+"px","float":"left"}},icon);_486.add(icon,"dojoxLegendIcon dijitInline");_486.add(text,"dojoxLegendText");if(this._tr){this._tr.appendChild(_48e);if(++this._inrow===this.horizontal){this._tr=_485.create("tr",null,this.legendBody);this._inrow=0;}}else{var tr=_485.create("tr",null,this.legendBody);tr.appendChild(_48e);}this._makeIcon(div,dyn);text.innerHTML=String(_48d);if(has("dojo-bidi")){text.dir=this.getTextDir(_48d,text.dir);}},_makeIcon:function(div,dyn){var mb={h:this.swatchSize,w:this.swatchSize};var _48f=gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(_48f);if(dyn.fill){_48f.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else{if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){_48f.createLine(line).setStroke(dyn.stroke);}if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};_48f.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.markerFill).setStroke(dyn.markerStroke);}}else{_48f.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");_48f.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");_48f.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}}});return has("dojo-bidi")?_482("dojox.charting.widget.Legend",[_488,_484]):_488;});},"dojox/charting/plot2d/StackedLines":function(){define(["dojo/_base/declare","./Stacked"],function(_490,_491){return _490("dojox.charting.plot2d.StackedLines",_491,{constructor:function(){this.opt.lines=true;}});});},"dojox/charting/plot2d/StackedColumns":function(){define(["dojo/_base/declare","./Columns","./commonStacked"],function(_492,_493,_494){return _492("dojox.charting.plot2d.StackedColumns",_493,{getSeriesStats:function(){var _495=_494.collectStats(this.series);_495.hmin-=0.5;_495.hmax+=0.5;return _495;},getValue:function(_496,_497,_498,_499){var x,y;if(_499){x=_497;y=_494.getIndexValue(this.series,_498,x);}else{x=_496.x-1;y=_494.getValue(this.series,_498,_496.x);y=[y[0]?y[0].y:null,y[1]?y[1]:null];}return {x:x,y:y[0],py:y[1]};}});});},"dojox/charting/Series":function(){define(["dojo/_base/lang","dojo/_base/declare","./Element"],function(lang,_49a,_49b){return _49a("dojox.charting.Series",_49b,{constructor:function(_49c,data,_49d){lang.mixin(this,_49d);if(typeof this.plot!="string"){this.plot="default";}this.update(data);},clear:function(){this.dyn={};},update:function(data){if(lang.isArray(data)){this.data=data;}else{this.source=data;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}this.dirty=true;this.clear();}});});},"dojox/charting/plot2d/Default":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/functional/reversed","dojox/lang/utils","dojox/gfx/fx"],function(lang,_49e,arr,has,_49f,_4a0,dc,df,dfr,du,fx){var _4a1=dfr.lambda("item.purgeGroup()");var _4a2=1200;return _49e("dojox.charting.plot2d.Default",[_49f,_4a0],{defaultParams:{lines:true,areas:false,markers:false,tension:"",animate:false,enableCache:false,interpolate:false},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",marker:"",markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(_4a3,_4a4){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_4a4);du.updateWithPattern(this.opt,_4a4,this.optionalParams);this.animate=this.opt.animate;},createPath:function(run,_4a5,_4a6){var path;if(this.opt.enableCache&&run._pathFreePool.length>0){path=run._pathFreePool.pop();path.setShape(_4a6);_4a5.add(path);}else{path=_4a5.createPath(_4a6);}if(this.opt.enableCache){run._pathUsePool.push(path);}return path;},buildSegments:function(i,_4a7){var run=this.series[i],min=_4a7?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_4a7?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length,rseg=null,_4a8=[];for(var j=min;j<max;j++){if(run.data[j]!=null&&(_4a7||run.data[j].y!=null)){if(!rseg){rseg=[];_4a8.push({index:j,rseg:rseg});}rseg.push((_4a7&&run.data[j].hasOwnProperty("y"))?run.data[j].y:run.data[j]);}else{if(!this.opt.interpolate||_4a7){rseg=null;}}}return _4a8;},render:function(dim,_4a9){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_4a9);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,_4a1);this._eventSeries={};this.cleanGroup();this.getGroup().setTransform(null);s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_4aa,_4ab,_4ac=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._pathFreePool=(run._pathFreePool?run._pathFreePool:[]).concat(run._pathUsePool?run._pathUsePool:[]);run._pathUsePool=[];}if(!run.data.length){run.dirty=false;t.skip();continue;}var _4ad=t.next(this.opt.areas?"area":"line",[this.opt,run],true),_4ae,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_4af=this._eventSeries[run.name]=new Array(run.data.length);s=run.group;var _4b0=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var _4b1=this.buildSegments(i,_4b0);for(var seg=0;seg<_4b1.length;seg++){var _4b2=_4b1[seg];if(_4b0){_4ae=arr.map(_4b2.rseg,function(v,i){return {x:ht(i+_4b2.index+1)+_4a9.l,y:dim.height-_4a9.b-vt(v),data:v};},this);}else{_4ae=arr.map(_4b2.rseg,function(v){return {x:ht(v.x)+_4a9.l,y:dim.height-_4a9.b-vt(v.y),data:v};},this);}if(_4b0&&this.opt.interpolate){while(seg<_4b1.length){seg++;_4b2=_4b1[seg];if(_4b2){_4ae=_4ae.concat(arr.map(_4b2.rseg,function(v,i){return {x:ht(i+_4b2.index+1)+_4a9.l,y:dim.height-_4a9.b-vt(v),data:v};},this));}}}var _4b3=this.opt.tension?dc.curve(_4ae,this.opt.tension):"";if(this.opt.areas&&_4ae.length>1){var fill=this._plotFill(_4ad.series.fill,dim,_4a9),_4b4=lang.clone(_4ae);if(this.opt.tension){var _4b5="L"+_4b4[_4b4.length-1].x+","+(dim.height-_4a9.b)+" L"+_4b4[0].x+","+(dim.height-_4a9.b)+" L"+_4b4[0].x+","+_4b4[0].y;run.dyn.fill=s.createPath(_4b3+" "+_4b5).setFill(fill).getFill();}else{_4b4.push({x:_4ae[_4ae.length-1].x,y:dim.height-_4a9.b});_4b4.push({x:_4ae[0].x,y:dim.height-_4a9.b});_4b4.push(_4ae[0]);run.dyn.fill=s.createPolyline(_4b4).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_4aa=_4ad.series.stroke;if(_4ad.series.outline){_4ab=run.dyn.outline=dc.makeStroke(_4ad.series.outline);_4ab.width=2*_4ab.width+_4aa.width;}}if(this.opt.markers){run.dyn.marker=_4ad.symbol;}var _4b6=null,_4b7=null,_4b8=null;if(_4aa&&_4ad.series.shadow&&_4ae.length>1){var _4b9=_4ad.series.shadow,_4ba=arr.map(_4ae,function(c){return {x:c.x+_4b9.dx,y:c.y+_4b9.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_4ba,this.opt.tension)).setStroke(_4b9).getStroke();}else{run.dyn.shadow=s.createPolyline(_4ba).setStroke(_4b9).getStroke();}}if(this.opt.markers&&_4ad.marker.shadow){_4b9=_4ad.marker.shadow;_4b8=arr.map(_4ba,function(c){return this.createPath(run,s,"M"+c.x+" "+c.y+" "+_4ad.symbol).setStroke(_4b9).setFill(_4b9.color);},this);}}if(this.opt.lines&&_4ae.length>1){var _4bb;if(_4ab){if(this.opt.tension){run.dyn.outline=s.createPath(_4b3).setStroke(_4ab).getStroke();}else{run.dyn.outline=s.createPolyline(_4ae).setStroke(_4ab).getStroke();}}if(this.opt.tension){run.dyn.stroke=(_4bb=s.createPath(_4b3)).setStroke(_4aa).getStroke();}else{run.dyn.stroke=(_4bb=s.createPolyline(_4ae)).setStroke(_4aa).getStroke();}if(_4bb.setFilter&&_4ad.series.filter){_4bb.setFilter(_4ad.series.filter);}}var _4bc=null;if(this.opt.markers){var _4bd=_4ad;_4b6=new Array(_4ae.length);_4b7=new Array(_4ae.length);_4ab=null;if(_4bd.marker.outline){_4ab=dc.makeStroke(_4bd.marker.outline);_4ab.width=2*_4ab.width+(_4bd.marker.stroke?_4bd.marker.stroke.width:0);}arr.forEach(_4ae,function(c,i){if(this.opt.styleFunc||typeof c.data!="number"){var _4be=typeof c.data!="number"?[c.data]:[];if(this.opt.styleFunc){_4be.push(this.opt.styleFunc(c.data));}_4bd=t.addMixin(_4ad,"marker",_4be,true);}else{_4bd=t.post(_4ad,"marker");}var path="M"+c.x+" "+c.y+" "+_4bd.symbol;if(_4ab){_4b7[i]=this.createPath(run,s,path).setStroke(_4ab);}_4b6[i]=this.createPath(run,s,path).setStroke(_4bd.marker.stroke).setFill(_4bd.marker.fill);},this);run.dyn.markerFill=_4bd.marker.fill;run.dyn.markerStroke=_4bd.marker.stroke;if(!_4bc&&this.opt.labels){_4bc=_4b6[0].getBoundingBox();}if(_4ac){arr.forEach(_4b6,function(s,i){var o={element:"marker",index:i+_4b2.index,run:run,shape:s,outline:_4b7[i]||null,shadow:_4b8&&_4b8[i]||null,cx:_4ae[i].x,cy:_4ae[i].y};if(_4b0){o.x=i+_4b2.index+1;o.y=run.data[i+_4b2.index];}else{o.x=_4b2.rseg[i].x;o.y=run.data[i+_4b2.index].y;}this._connectEvents(o);_4af[i+_4b2.index]=o;},this);}else{delete this._eventSeries[run.name];}}if(this.opt.labels){var _4bf=_4bc?_4bc.width:2;var _4c0=_4bc?_4bc.height:2;arr.forEach(_4ae,function(c,i){if(this.opt.styleFunc||typeof c.data!="number"){var _4c1=typeof c.data!="number"?[c.data]:[];if(this.opt.styleFunc){_4c1.push(this.opt.styleFunc(c.data));}_4bd=t.addMixin(_4ad,"marker",_4c1,true);}else{_4bd=t.post(_4ad,"marker");}this.createLabel(s,_4b2.rseg[i],{x:c.x-_4bf/2,y:c.y-_4c0/2,width:_4bf,height:_4c0},_4bd);},this);}}run.dirty=false;}if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_4a9);}if(this.animate){var _4c2=this.getGroup();fx.animateTransform(lang.delegate({shape:_4c2,duration:_4a2,transform:[{name:"translate",start:[0,dim.height-_4a9.b],end:[0,0]},{name:"scale",start:[1,0],end:[1,1]},{name:"original"}]},this.animate)).play();}this.dirty=false;return this;}});});},"dijit/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dojox/charting/plot2d/Base":function(){define(["dojo/_base/declare","dojo/_base/array","dojox/gfx","../Element","./common","../axis2d/common","dojo/has"],function(_4c3,arr,gfx,_4c4,_4c5,ac,has){var Base=_4c3("dojox.charting.plot2d.Base",_4c4,{constructor:function(_4c6,_4c7){if(_4c7&&_4c7.tooltipFunc){this.tooltipFunc=_4c7.tooltipFunc;}},clear:function(){this.series=[];this.dirty=true;return this;},setAxis:function(axis){return this;},assignAxes:function(axes){arr.forEach(this.axes,function(axis){if(this[axis]){this.setAxis(axes[this[axis]]);}},this);},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return _4c5.collectSimpleStats(this.series);},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},initializeScalers:function(){return this;},isDataDirty:function(){return arr.some(this.series,function(item){return item.dirty;});},render:function(dim,_4c8){return this;},renderLabel:function(_4c9,x,y,_4ca,_4cb,_4cc,_4cd){var elem=ac.createText[this.opt.htmlLabels&&gfx.renderer!="vml"?"html":"gfx"](this.chart,_4c9,x,y,_4cd?_4cd:"middle",_4ca,_4cb.series.font,_4cb.series.fontColor);if(_4cc){if(this.opt.htmlLabels&&gfx.renderer!="vml"){elem.style.pointerEvents="none";}else{if(elem.rawNode){elem.rawNode.style.pointerEvents="none";}}}if(this.opt.htmlLabels&&gfx.renderer!="vml"){this.htmlElements.push(elem);}return elem;},getRequiredColors:function(){return this.series.length;},_getLabel:function(_4ce){return _4c5.getLabel(_4ce,this.opt.fixed,this.opt.precision);}});if(has("dojo-bidi")){Base.extend({_checkOrientation:function(_4cf,dim,_4d0){this.chart.applyMirroring(this.group,dim,_4d0);}});}return Base;});},"dojox/charting/action2d/Tooltip":function(){define(["dijit/Tooltip","dojo/_base/lang","dojo/_base/declare","dojo/_base/window","dojo/_base/connect","dojo/dom-style","./PlotAction","dojox/gfx/matrix","dojo/has","dojo/has!dojo-bidi?../bidi/action2d/Tooltip","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(_4d1,lang,_4d2,win,hub,_4d3,_4d4,m,has,_4d5,df){var _4d6=function(o,plot){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t!="number"&&(t.tooltip||t.text)){return t.tooltip||t.text;}if(plot.tooltipFunc){return plot.tooltipFunc(o);}else{return o.y;}};var pi4=Math.PI/4,pi2=Math.PI/2;var _4d7=_4d2(has("dojo-bidi")?"dojox.charting.action2d.NonBidiTooltip":"dojox.charting.action2d.Tooltip",_4d4,{defaultParams:{text:_4d6,mouseOver:true},optionalParams:{},constructor:function(_4d8,plot,_4d9){this.text=_4d9&&_4d9.text?_4d9.text:_4d6;this.mouseOver=_4d9&&_4d9.mouseOver!=undefined?_4d9.mouseOver:true;this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){_4d1.hide(this.aroundRect);this.aroundRect=null;if(o.type==="onplotreset"){delete this.angles;}return;}if(!o.shape||(this.mouseOver&&o.type!=="onmouseover")||(!this.mouseOver&&o.type!=="onclick")){return;}var _4da={type:"rect"},_4db=["after-centered","before-centered"];switch(o.element){case "marker":_4da.x=o.cx;_4da.y=o.cy;_4da.w=_4da.h=1;break;case "circle":_4da.x=o.cx-o.cr;_4da.y=o.cy-o.cr;_4da.w=_4da.h=2*o.cr;break;case "spider_circle":_4da.x=o.cx;_4da.y=o.cy;_4da.w=_4da.h=1;break;case "spider_plot":return;case "column":_4db=["above-centered","below-centered"];case "bar":_4da=lang.clone(o.shape.getShape());_4da.w=_4da.width;_4da.h=_4da.height;break;case "candlestick":_4da.x=o.x;_4da.y=o.y;_4da.w=o.width;_4da.h=o.height;break;default:if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}var _4dc=m._degToRad(o.plot.opt.startAngle),_4dd=(this.angles[o.index]+this.angles[o.index+1])/2+_4dc;_4da.x=o.cx+o.cr*Math.cos(_4dd);_4da.y=o.cy+o.cr*Math.sin(_4dd);_4da.w=_4da.h=1;if(_4dc&&(_4dd<0||_4dd>2*Math.PI)){_4dd=Math.abs(2*Math.PI-Math.abs(_4dd));}if(_4dd<pi4){}else{if(_4dd<pi2+pi4){_4db=["below-centered","above-centered"];}else{if(_4dd<Math.PI+pi4){_4db=["before-centered","after-centered"];}else{if(_4dd<2*Math.PI-pi4){_4db=["above-centered","below-centered"];}}}}break;}if(has("dojo-bidi")){this._recheckPosition(o,_4da,_4db);}var lt=this.chart.getCoords();_4da.x+=lt.x;_4da.y+=lt.y;_4da.x=Math.round(_4da.x);_4da.y=Math.round(_4da.y);_4da.w=Math.ceil(_4da.w);_4da.h=Math.ceil(_4da.h);this.aroundRect=_4da;var _4de=this.text(o,this.plot);if(_4de){_4d1.show(this._format(_4de),this.aroundRect,_4db);}if(!this.mouseOver){this._handle=hub.connect(win.doc,"onclick",this,"onClick");}},onClick:function(){this.process({type:"onmouseout"});},_recheckPosition:function(obj,rect,_4df){},_format:function(_4e0){return _4e0;}});return has("dojo-bidi")?_4d2("dojox.charting.action2d.Tooltip",[_4d7,_4d5]):_4d7;});},"dojox/gfx":function(){define(["dojo/_base/lang","./gfx/_base","./gfx/renderer!"],function(lang,_4e1,_4e2){_4e1.switchTo(_4e2);return _4e1;});},"dojox/gfx/shape":function(){define(["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/kernel","dojo/_base/sniff","dojo/on","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,lang,_4e3,_4e4,has,on,arr,_4e5,_4e6,_4e7){var _4e8=g.shape={};_4e8.Shape=_4e3("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;if(has("gfxRegistry")){var uid=_4e8.register(this);this.getUID=function(){return uid;};}},destroy:function(){if(has("gfxRegistry")){_4e8.dispose(this);}if(this.rawNode&&"__gfxObject__" in this.rawNode){this.rawNode.__gfxObject__=null;}this.rawNode=null;},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_4e7;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setClip:function(clip){this.clip=clip;},getClip:function(){return this.clip;},setShape:function(_4e9){this.shape=g.makeParameters(this.shape,_4e9);this.bbox=null;return this;},setFill:function(fill){if(!fill){this.fillStyle=null;return this;}var f=null;if(typeof (fill)=="object"&&"type" in fill){switch(fill.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,fill);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,fill);break;case "pattern":f=g.makeParameters(g.defaultPattern,fill);break;}}else{f=g.normalizeColor(fill);}this.fillStyle=f;return this;},setStroke:function(_4ea){if(!_4ea){this.strokeStyle=null;return this;}if(typeof _4ea=="string"||lang.isArray(_4ea)||_4ea instanceof _4e6){_4ea={color:_4ea};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_4ea);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_4eb){this.matrix=_4e7.clone(_4eb?_4e7.normalize(_4eb):_4e7.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_4ec){return _4ec?this.setTransform([this.matrix,_4ec]):this;},applyLeftTransform:function(_4ed){return _4ed?this.setTransform([_4ed,this.matrix]):this;},applyTransform:function(_4ee){return _4ee?this.setTransform([this.matrix,_4ee]):this;},removeShape:function(_4ef){if(this.parent){this.parent.remove(this,_4ef);}return this;},_setParent:function(_4f0,_4f1){this.parent=_4f0;return this._updateParentMatrix(_4f1);},_updateParentMatrix:function(_4f2){this.parentMatrix=_4f2?_4e7.clone(_4f2):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_4e7.multiply(p.matrix,m);}p=p.parent;}return m;}});_4e8._eventsProcessing={on:function(type,_4f3){return on(this.getEventSource(),type,_4e8.fixCallback(this,g.fixTarget,_4f3));},connect:function(name,_4f4,_4f5){if(name.substring(0,2)=="on"){name=name.substring(2);}return this.on(name,_4f5?lang.hitch(_4f4,_4f5):_4f4);},disconnect:function(_4f6){return _4f6.remove();}};_4e8.fixCallback=function(_4f7,_4f8,_4f9,_4fa){if(!_4fa){_4fa=_4f9;_4f9=null;}if(lang.isString(_4fa)){_4f9=_4f9||_4e4.global;if(!_4f9[_4fa]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_4fa,"\"] is null (scope=\"",_4f9,"\")"].join(""));}return function(e){return _4f8(e,_4f7)?_4f9[_4fa].apply(_4f9,arguments||[]):undefined;};}return !_4f9?function(e){return _4f8(e,_4f7)?_4fa.apply(_4f9,arguments):undefined;}:function(e){return _4f8(e,_4f7)?_4fa.apply(_4f9,arguments||[]):undefined;};};lang.extend(_4e8.Shape,_4e8._eventsProcessing);_4e8.Container={_init:function(){this.children=[];this._batch=0;},openBatch:function(){return this;},closeBatch:function(){return this;},add:function(_4fb){var _4fc=_4fb.getParent();if(_4fc){_4fc.remove(_4fb,true);}this.children.push(_4fb);return _4fb._setParent(this,this._getRealMatrix());},remove:function(_4fd,_4fe){for(var i=0;i<this.children.length;++i){if(this.children[i]==_4fd){if(_4fe){}else{_4fd.parent=null;_4fd.parentMatrix=null;}this.children.splice(i,1);break;}}return this;},clear:function(_4ff){var _500;for(var i=0;i<this.children.length;++i){_500=this.children[i];_500.parent=null;_500.parentMatrix=null;if(_4ff){_500.destroy();}}this.children=[];return this;},getBoundingBox:function(){if(this.children){var _501=null;arr.forEach(this.children,function(_502){var bb=_502.getBoundingBox();if(bb){var ct=_502.getTransform();if(ct){bb=_4e7.multiplyRectangle(ct,bb);}if(_501){_501.x=Math.min(_501.x,bb.x);_501.y=Math.min(_501.y,bb.y);_501.endX=Math.max(_501.endX,bb.x+bb.width);_501.endY=Math.max(_501.endY,bb.y+bb.height);}else{_501={x:bb.x,y:bb.y,endX:bb.x+bb.width,endY:bb.y+bb.height};}}});if(_501){_501.width=_501.endX-_501.x;_501.height=_501.endY-_501.y;}return _501;}return null;},_moveChildToFront:function(_503){for(var i=0;i<this.children.length;++i){if(this.children[i]==_503){this.children.splice(i,1);this.children.push(_503);break;}}return this;},_moveChildToBack:function(_504){for(var i=0;i<this.children.length;++i){if(this.children[i]==_504){this.children.splice(i,1);this.children.unshift(_504);break;}}return this;}};_4e8.Surface=_4e3("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){arr.forEach(this._nodes,_4e5.destroy);this._nodes=[];arr.forEach(this._events,function(h){if(h){h.remove();}});this._events=[];this.rawNode=null;if(has("ie")){while(this._parent.lastChild){_4e5.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_505){},whenLoaded:function(_506,_507){var f=lang.hitch(_506,_507);if(this.isLoaded){f(this);}else{on.once(this,"load",function(_508){f(_508);});}}});lang.extend(_4e8.Surface,_4e8._eventsProcessing);_4e8.Rect=_4e3("dojox.gfx.shape.Rect",_4e8.Shape,{constructor:function(_509){this.shape=g.getDefault("Rect");this.rawNode=_509;},getBoundingBox:function(){return this.shape;}});_4e8.Ellipse=_4e3("dojox.gfx.shape.Ellipse",_4e8.Shape,{constructor:function(_50a){this.shape=g.getDefault("Ellipse");this.rawNode=_50a;},getBoundingBox:function(){if(!this.bbox){var _50b=this.shape;this.bbox={x:_50b.cx-_50b.rx,y:_50b.cy-_50b.ry,width:2*_50b.rx,height:2*_50b.ry};}return this.bbox;}});_4e8.Circle=_4e3("dojox.gfx.shape.Circle",_4e8.Shape,{constructor:function(_50c){this.shape=g.getDefault("Circle");this.rawNode=_50c;},getBoundingBox:function(){if(!this.bbox){var _50d=this.shape;this.bbox={x:_50d.cx-_50d.r,y:_50d.cy-_50d.r,width:2*_50d.r,height:2*_50d.r};}return this.bbox;}});_4e8.Line=_4e3("dojox.gfx.shape.Line",_4e8.Shape,{constructor:function(_50e){this.shape=g.getDefault("Line");this.rawNode=_50e;},getBoundingBox:function(){if(!this.bbox){var _50f=this.shape;this.bbox={x:Math.min(_50f.x1,_50f.x2),y:Math.min(_50f.y1,_50f.y2),width:Math.abs(_50f.x2-_50f.x1),height:Math.abs(_50f.y2-_50f.y1)};}return this.bbox;}});_4e8.Polyline=_4e3("dojox.gfx.shape.Polyline",_4e8.Shape,{constructor:function(_510){this.shape=g.getDefault("Polyline");this.rawNode=_510;},setShape:function(_511,_512){if(_511&&_511 instanceof Array){this.inherited(arguments,[{points:_511}]);if(_512&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_511]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _513=[];for(var i=0;i<l;i+=2){_513.push({x:p[i],y:p[i+1]});}this.shape.points=_513;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var bbox={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(bbox.l>t.x){bbox.l=t.x;}if(bbox.r<t.x){bbox.r=t.x;}if(bbox.t>t.y){bbox.t=t.y;}if(bbox.b<t.y){bbox.b=t.y;}}this.bbox={x:bbox.l,y:bbox.t,width:bbox.r-bbox.l,height:bbox.b-bbox.t};}return this.bbox;}});_4e8.Image=_4e3("dojox.gfx.shape.Image",_4e8.Shape,{constructor:function(_514){this.shape=g.getDefault("Image");this.rawNode=_514;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_4e8.Text=_4e3(_4e8.Shape,{constructor:function(_515){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_515;},getFont:function(){return this.fontStyle;},setFont:function(_516){this.fontStyle=typeof _516=="string"?g.splitFontString(_516):g.makeParameters(g.defaultFont,_516);this._setFont();return this;},getBoundingBox:function(){var bbox=null,s=this.getShape();if(s.text){bbox=g._base._computeTextBoundingBox(this);}return bbox;}});_4e8.Creator={createShape:function(_517){switch(_517.type){case g.defaultPath.type:return this.createPath(_517);case g.defaultRect.type:return this.createRect(_517);case g.defaultCircle.type:return this.createCircle(_517);case g.defaultEllipse.type:return this.createEllipse(_517);case g.defaultLine.type:return this.createLine(_517);case g.defaultPolyline.type:return this.createPolyline(_517);case g.defaultImage.type:return this.createImage(_517);case g.defaultText.type:return this.createText(_517);case g.defaultTextPath.type:return this.createTextPath(_517);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(rect){return this.createObject(g.Rect,rect);},createEllipse:function(_518){return this.createObject(g.Ellipse,_518);},createCircle:function(_519){return this.createObject(g.Circle,_519);},createLine:function(line){return this.createObject(g.Line,line);},createPolyline:function(_51a){return this.createObject(g.Polyline,_51a);},createImage:function(_51b){return this.createObject(g.Image,_51b);},createText:function(text){return this.createObject(g.Text,text);},createPath:function(path){return this.createObject(g.Path,path);},createTextPath:function(text){return this.createObject(g.TextPath,{}).setText(text);},createObject:function(_51c,_51d){return null;}};return _4e8;});},"dojox/charting/Chart2D":function(){define(["dojo/_base/kernel","dojo/_base/lang","..","./Chart","./axis2d/Default","./axis2d/Invisible","./plot2d/Default","./plot2d/Lines","./plot2d/Areas","./plot2d/Markers","./plot2d/MarkersOnly","./plot2d/Scatter","./plot2d/Stacked","./plot2d/StackedLines","./plot2d/StackedAreas","./plot2d/Columns","./plot2d/StackedColumns","./plot2d/ClusteredColumns","./plot2d/Bars","./plot2d/StackedBars","./plot2d/ClusteredBars","./plot2d/Grid","./plot2d/Pie","./plot2d/Bubble","./plot2d/Candlesticks","./plot2d/OHLC","./plot2d/Spider"],function(_51e,lang,_51f,_520){_51e.deprecated("dojox.charting.Chart2D","Use dojox.charting.Chart instead and require all other components explicitly","2.0");return lang.setObject("dojox.charting.Chart2D",_520);});},"dojox/charting/scaler/linear":function(){define(["dojo/_base/lang","./common"],function(lang,_521){var _522=lang.getObject("dojox.charting.scaler.linear",true);var _523=3,_524=_521.getNumericLabel;function _525(val,text){val=val.toLowerCase();for(var i=text.length-1;i>=0;--i){if(val===text[i]){return true;}}return false;};var _526=function(min,max,_527,_528,_529,_52a,span){_527=lang.delegate(_527);if(!_528){if(_527.fixUpper=="major"){_527.fixUpper="minor";}if(_527.fixLower=="major"){_527.fixLower="minor";}}if(!_529){if(_527.fixUpper=="minor"){_527.fixUpper="micro";}if(_527.fixLower=="minor"){_527.fixLower="micro";}}if(!_52a){if(_527.fixUpper=="micro"){_527.fixUpper="none";}if(_527.fixLower=="micro"){_527.fixLower="none";}}var _52b=_525(_527.fixLower,["major"])?Math.floor(_527.min/_528)*_528:_525(_527.fixLower,["minor"])?Math.floor(_527.min/_529)*_529:_525(_527.fixLower,["micro"])?Math.floor(_527.min/_52a)*_52a:_527.min,_52c=_525(_527.fixUpper,["major"])?Math.ceil(_527.max/_528)*_528:_525(_527.fixUpper,["minor"])?Math.ceil(_527.max/_529)*_529:_525(_527.fixUpper,["micro"])?Math.ceil(_527.max/_52a)*_52a:_527.max;if(_527.useMin){min=_52b;}if(_527.useMax){max=_52c;}var _52d=(!_528||_527.useMin&&_525(_527.fixLower,["major"]))?min:Math.ceil(min/_528)*_528,_52e=(!_529||_527.useMin&&_525(_527.fixLower,["major","minor"]))?min:Math.ceil(min/_529)*_529,_52f=(!_52a||_527.useMin&&_525(_527.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_52a)*_52a,_530=!_528?0:(_527.useMax&&_525(_527.fixUpper,["major"])?Math.round((max-_52d)/_528):Math.floor((max-_52d)/_528))+1,_531=!_529?0:(_527.useMax&&_525(_527.fixUpper,["major","minor"])?Math.round((max-_52e)/_529):Math.floor((max-_52e)/_529))+1,_532=!_52a?0:(_527.useMax&&_525(_527.fixUpper,["major","minor","micro"])?Math.round((max-_52f)/_52a):Math.floor((max-_52f)/_52a))+1,_533=_529?Math.round(_528/_529):0,_534=_52a?Math.round(_529/_52a):0,_535=_528?Math.floor(Math.log(_528)/Math.LN10):0,_536=_529?Math.floor(Math.log(_529)/Math.LN10):0,_537=span/(max-min);if(!isFinite(_537)){_537=1;}return {bounds:{lower:_52b,upper:_52c,from:min,to:max,scale:_537,span:span},major:{tick:_528,start:_52d,count:_530,prec:_535},minor:{tick:_529,start:_52e,count:_531,prec:_536},micro:{tick:_52a,start:_52f,count:_532,prec:0},minorPerMajor:_533,microPerMinor:_534,scaler:_522};};return lang.mixin(_522,{buildScaler:function(min,max,span,_538,_539,_53a){var h={fixUpper:"none",fixLower:"none",natural:false};if(_538){if("fixUpper" in _538){h.fixUpper=String(_538.fixUpper);}if("fixLower" in _538){h.fixLower=String(_538.fixLower);}if("natural" in _538){h.natural=Boolean(_538.natural);}}_53a=!_53a||_53a<_523?_523:_53a;if("min" in _538){min=_538.min;}if("max" in _538){max=_538.max;}if(_538.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _538){min=_538.from;h.useMin=false;}if("to" in _538){max=_538.to;h.useMax=false;}if(max<=min){return _526(min,max,h,0,0,0,span);}if(!_539){_539=max-min;}var mag=Math.floor(Math.log(_539)/Math.LN10),_53b=_538&&("majorTickStep" in _538)?_538.majorTickStep:Math.pow(10,mag),_53c=0,_53d=0,_53e;if(_538&&("minorTickStep" in _538)){_53c=_538.minorTickStep;}else{do{_53c=_53b/10;if(!h.natural||_53c>0.9){_53e=_526(min,max,h,_53b,_53c,0,span);if(_53e.bounds.scale*_53e.minor.tick>_53a){break;}}_53c=_53b/5;if(!h.natural||_53c>0.9){_53e=_526(min,max,h,_53b,_53c,0,span);if(_53e.bounds.scale*_53e.minor.tick>_53a){break;}}_53c=_53b/2;if(!h.natural||_53c>0.9){_53e=_526(min,max,h,_53b,_53c,0,span);if(_53e.bounds.scale*_53e.minor.tick>_53a){break;}}return _526(min,max,h,_53b,0,0,span);}while(false);}if(_538&&("microTickStep" in _538)){_53d=_538.microTickStep;_53e=_526(min,max,h,_53b,_53c,_53d,span);}else{do{_53d=_53c/10;if(!h.natural||_53d>0.9){_53e=_526(min,max,h,_53b,_53c,_53d,span);if(_53e.bounds.scale*_53e.micro.tick>_523){break;}}_53d=_53c/5;if(!h.natural||_53d>0.9){_53e=_526(min,max,h,_53b,_53c,_53d,span);if(_53e.bounds.scale*_53e.micro.tick>_523){break;}}_53d=_53c/2;if(!h.natural||_53d>0.9){_53e=_526(min,max,h,_53b,_53c,_53d,span);if(_53e.bounds.scale*_53e.micro.tick>_523){break;}}_53d=0;}while(false);}return _53d?_53e:_526(min,max,h,_53b,_53c,0,span);},buildTicks:function(_53f,_540){var step,next,tick,_541=_53f.major.start,_542=_53f.minor.start,_543=_53f.micro.start;if(_540.microTicks&&_53f.micro.tick){step=_53f.micro.tick,next=_543;}else{if(_540.minorTicks&&_53f.minor.tick){step=_53f.minor.tick,next=_542;}else{if(_53f.major.tick){step=_53f.major.tick,next=_541;}else{return null;}}}var _544=1/_53f.bounds.scale;if(_53f.bounds.to<=_53f.bounds.from||isNaN(_544)||!isFinite(_544)||step<=0||isNaN(step)||!isFinite(step)){return null;}var _545=[],_546=[],_547=[];while(next<=_53f.bounds.to+_544){if(Math.abs(_541-next)<step/2){tick={value:_541};if(_540.majorLabels){tick.label=_524(_541,_53f.major.prec,_540);}_545.push(tick);_541+=_53f.major.tick;_542+=_53f.minor.tick;_543+=_53f.micro.tick;}else{if(Math.abs(_542-next)<step/2){if(_540.minorTicks){tick={value:_542};if(_540.minorLabels&&(_53f.minMinorStep<=_53f.minor.tick*_53f.bounds.scale)){tick.label=_524(_542,_53f.minor.prec,_540);}_546.push(tick);}_542+=_53f.minor.tick;_543+=_53f.micro.tick;}else{if(_540.microTicks){_547.push({value:_543});}_543+=_53f.micro.tick;}}next+=step;}return {major:_545,minor:_546,micro:_547};},getTransformerFromModel:function(_548){var _549=_548.bounds.from,_54a=_548.bounds.scale;return function(x){return (x-_549)*_54a;};},getTransformerFromPlot:function(_54b){var _54c=_54b.bounds.from,_54d=_54b.bounds.scale;return function(x){return x/_54d+_54c;};}});});},"dojox/gfx/renderer":function(){define(["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,lang,has,win,_54e){var _54f=null;has.add("vml",function(_550,_551,_552){_552.innerHTML="<v:shape adj=\"1\"/>";var _553=("adj" in _552.firstChild);_552.innerHTML="";return _553;});return {load:function(id,_554,load){if(_54f&&id!="force"){load(_54f);return;}var _555=_54e.forceGfxRenderer,_556=!_555&&(lang.isString(_54e.gfxRenderer)?_54e.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_557,_558;while(!_555&&_556.length){switch(_556.shift()){case "svg":if("SVGAngle" in win.global){_555="svg";}break;case "vml":if(has("vml")){_555="vml";}break;case "silverlight":try{if(has("ie")){_557=new ActiveXObject("AgControl.AgControl");if(_557&&_557.IsVersionSupported("1.0")){_558=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_558=true;}}}catch(e){_558=false;}finally{_557=null;}if(_558){_555="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_555="canvas";}break;}}if(_555==="canvas"&&_54e.canvasEvents!==false){_555="canvasWithEvents";}if(_54e.isDebug){}function _559(){_554(["dojox/gfx/"+_555],function(_55a){g.renderer=_555;_54f=_55a;load(_55a);});};if(_555=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_559);}else{_559();}}};});},"dojox/charting/widget/Chart":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","dojo/dom-attr","dojo/_base/declare","dojo/query","dijit/_WidgetBase","../Chart","dojo/has","dojo/has!dojo-bidi?../bidi/widget/Chart","dojox/lang/utils","dojox/lang/functional","dojox/lang/functional/lambda"],function(_55b,lang,arr,_55c,_55d,_55e,_55f,_560,has,_561,du,df,dfl){var _562,_563,_564,_565,_566,_567=function(o){return o;},dc=lang.getObject("dojox.charting");_562=function(node,type,kw){var dp=eval("("+type+".prototype.defaultParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}var op=eval("("+type+".prototype.optionalParams)");for(x in op){if(x in kw){continue;}attr=node.getAttribute(x);if(attr!=null){kw[x]=du.coerceType(op[x],attr);}}};_563=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.axis2d[type]){type=_55b._scopeName+"x.charting.axis2d."+type;}var axis=eval("("+type+")");if(axis){kw.type=axis;}}else{type=_55b._scopeName+"x.charting.axis2d.Default";}_562(node,type,kw);if(kw.font||kw.fontColor){if(!kw.tick){kw.tick={};}if(kw.font){kw.tick.font=kw.font;}if(kw.fontColor){kw.tick.fontColor=kw.fontColor;}}return o;};_564=function(node){var name=node.getAttribute("name"),type=node.getAttribute("type");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.plot2d&&dc.plot2d[type]){type=_55b._scopeName+"x.charting.plot2d."+type;}var plot=eval("("+type+")");if(plot){kw.type=plot;}}else{type=_55b._scopeName+"x.charting.plot2d.Default";}_562(node,type,kw);var dp=eval("("+type+".prototype.baseParams)");var x,attr;for(x in dp){if(x in kw){continue;}attr=node.getAttribute(x);kw[x]=du.coerceType(dp[x],attr==null||typeof attr=="undefined"?dp[x]:attr);}return o;};_565=function(node){var plot=node.getAttribute("plot"),type=node.getAttribute("type");if(!plot){plot="default";}var o={plot:plot,kwArgs:{}},kw=o.kwArgs;if(type){if(dc.action2d[type]){type=_55b._scopeName+"x.charting.action2d."+type;}var _568=eval("("+type+")");if(!_568){return null;}o.action=_568;}else{return null;}_562(node,type,kw);return o;};_566=function(node){var ga=lang.partial(_55c.get,node);var name=ga("name");if(!name){return null;}var o={name:name,kwArgs:{}},kw=o.kwArgs,t;t=ga("plot");if(t!=null){kw.plot=t;}t=ga("marker");if(t!=null){kw.marker=t;}t=ga("stroke");if(t!=null){kw.stroke=eval("("+t+")");}t=ga("outline");if(t!=null){kw.outline=eval("("+t+")");}t=ga("shadow");if(t!=null){kw.shadow=eval("("+t+")");}t=ga("fill");if(t!=null){kw.fill=eval("("+t+")");}t=ga("font");if(t!=null){kw.font=t;}t=ga("fontColor");if(t!=null){kw.fontColor=eval("("+t+")");}t=ga("legend");if(t!=null){kw.legend=t;}t=ga("data");if(t!=null){o.type="data";o.data=t?arr.map(String(t).split(","),Number):[];return o;}t=ga("array");if(t!=null){o.type="data";o.data=eval("("+t+")");return o;}t=ga("store");if(t!=null){o.type="store";o.data=eval("("+t+")");t=ga("field");o.field=t!=null?t:"value";t=ga("query");if(!!t){kw.query=t;}t=ga("queryOptions");if(!!t){kw.queryOptions=eval("("+t+")");}t=ga("start");if(!!t){kw.start=Number(t);}t=ga("count");if(!!t){kw.count=Number(t);}t=ga("sort");if(!!t){kw.sort=eval("("+t+")");}t=ga("valueFn");if(!!t){kw.valueFn=dfl.lambda(t);}return o;}return null;};var _569=_55d(has("dojo-bidi")?"dojox.charting.widget.NonBidiChart":"dojox.charting.widget.Chart",_55f,{theme:null,margins:null,stroke:undefined,fill:undefined,buildRendering:function(){this.inherited(arguments);var n=this.domNode;var axes=_55e("> .axis",n).map(_563).filter(_567),_56a=_55e("> .plot",n).map(_564).filter(_567),_56b=_55e("> .action",n).map(_565).filter(_567),_56c=_55e("> .series",n).map(_566).filter(_567);n.innerHTML="";var c=this.chart=new _560(n,{margins:this.margins,stroke:this.stroke,fill:this.fill,textDir:this.textDir});if(this.theme){c.setTheme(this.theme);}axes.forEach(function(axis){c.addAxis(axis.name,axis.kwArgs);});_56a.forEach(function(plot){c.addPlot(plot.name,plot.kwArgs);});this.actions=_56b.map(function(_56d){return new _56d.action(c,_56d.plot,_56d.kwArgs);});var _56e=df.foldl(_56c,function(_56f,_570){if(_570.type=="data"){c.addSeries(_570.name,_570.data,_570.kwArgs);_56f=true;}else{c.addSeries(_570.name,[0],_570.kwArgs);var kw={};du.updateWithPattern(kw,_570.kwArgs,{"query":"","queryOptions":null,"start":0,"count":1},true);if(_570.kwArgs.sort){kw.sort=lang.clone(_570.kwArgs.sort);}lang.mixin(kw,{onComplete:function(data){var _571;if("valueFn" in _570.kwArgs){var fn=_570.kwArgs.valueFn;_571=arr.map(data,function(x){return fn(_570.data.getValue(x,_570.field,0));});}else{_571=arr.map(data,function(x){return _570.data.getValue(x,_570.field,0);});}c.addSeries(_570.name,_571,_570.kwArgs).render();}});_570.data.fetch(kw);}return _56f;},false);if(_56e){c.render();}},destroy:function(){this.chart.destroy();this.inherited(arguments);},resize:function(box){this.chart.resize.apply(this.chart,arguments);}});return has("dojo-bidi")?_55d("dojox.charting.widget.Chart",[_569,_561]):_569;});},"dojox/lang/functional":function(){define(["./functional/lambda","./functional/array","./functional/object"],function(df){return df;});},"dojox/charting/scaler/common":function(){define(["dojo/_base/lang"],function(lang){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};var _572=lang.getObject("dojox.charting.scaler.common",true);var _573={};return lang.mixin(_572,{doIfLoaded:function(_574,_575,_576){if(_573[_574]==undefined){try{_573[_574]=require(_574);}catch(e){_573[_574]=null;}}if(_573[_574]){return _575(_573[_574]);}else{return _576();}},getNumericLabel:function(_577,_578,_579){var def="";_572.doIfLoaded("dojo/number",function(_57a){def=(_579.fixed?_57a.format(_577,{places:_578<0?-_578:0}):_57a.format(_577))||"";},function(){def=_579.fixed?_577.toFixed(_578<0?-_578:0):_577.toString();});if(_579.labelFunc){var r=_579.labelFunc(def,_577,_578);if(r){return r;}}if(_579.labels){var l=_579.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_577){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_577)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_577)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_577)){return l[lo].text;}}return def;}});});},"dojox/charting/axis2d/common":function(){define(["dojo/_base/lang","dojo/_base/window","dojo/dom-geometry","dojox/gfx","dojo/has"],function(lang,win,_57b,g,has){var _57c=lang.getObject("dojox.charting.axis2d.common",true);var _57d=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _57e=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return _57b.getMarginBox(n).w;}};return lang.mixin(_57c,{createText:{gfx:function(_57f,_580,x,y,_581,text,font,_582){return _580.createText({x:x,y:y,text:text,align:_581}).setFont(font).setFill(_582);},html:function(_583,_584,x,y,_585,text,font,_586,_587){var p=win.doc.createElement("div"),s=p.style,_588;if(_583.getTextDir){p.dir=_583.getTextDir(text);}_57d(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_586;s.position="absolute";s.left="-10000px";win.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!_587){_588=_57e(p);}if(p.dir=="rtl"){x+=_587?_587:_588;}win.body().removeChild(p);s.position="relative";if(_587){s.width=_587+"px";switch(_585){case "middle":s.textAlign="center";s.left=(x-_587/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_587)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(_585){case "middle":s.left=Math.floor(x-_588/2)+"px";break;case "end":s.left=Math.floor(x-_588)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=win.doc.createElement("div"),w=wrap.style;_57d(w);w.width="0px";w.height="0px";wrap.appendChild(p);_583.node.insertBefore(wrap,_583.node.firstChild);if(has("dojo-bidi")){_583.htmlElementsRegistry.push([wrap,x,y,_585,text,font,_586]);}return wrap;}}});});},"dijit/_TemplatedMixin":function(){define(["dojo/cache","dojo/_base/declare","dojo/dom-construct","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_AttachMixin"],function(_589,_58a,_58b,lang,on,has,_58c,_58d){var _58e=_58a("dijit._TemplatedMixin",_58d,{templateString:null,templatePath:null,_skipNodeCache:false,searchContainerNode:true,_stringRepl:function(tmpl){var _58f=this.declaredClass,_590=this;return _58c.substitute(tmpl,this,function(_591,key){if(key.charAt(0)=="!"){_591=lang.getObject(key.substr(1),false,_590);}if(typeof _591=="undefined"){throw new Error(_58f+" template:"+key);}if(_591==null){return "";}return key.charAt(0)=="!"?_591:_591.toString().replace(/"/g,"&quot;");},this);},buildRendering:function(){if(!this._rendered){if(!this.templateString){this.templateString=_589(this.templatePath,{sanitize:true});}var _592=_58e.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);var node;if(lang.isString(_592)){node=_58b.toDom(this._stringRepl(_592),this.ownerDocument);if(node.nodeType!=1){throw new Error("Invalid template: "+_592);}}else{node=_592.cloneNode(true);}this.domNode=node;}this.inherited(arguments);if(!this._rendered){this._fillContent(this.srcNodeRef);}this._rendered=true;},_fillContent:function(_593){var dest=this.containerNode;if(_593&&dest){while(_593.hasChildNodes()){dest.appendChild(_593.firstChild);}}}});_58e._templateCache={};_58e.getCachedTemplate=function(_594,_595,doc){var _596=_58e._templateCache;var key=_594;var _597=_596[key];if(_597){try{if(!_597.ownerDocument||_597.ownerDocument==(doc||document)){return _597;}}catch(e){}_58b.destroy(_597);}_594=_58c.trim(_594);if(_595||_594.match(/\$\{([^\}]+)\}/g)){return (_596[key]=_594);}else{var node=_58b.toDom(_594,doc);if(node.nodeType!=1){throw new Error("Invalid template: "+_594);}return (_596[key]=node);}};if(has("ie")){on(window,"unload",function(){var _598=_58e._templateCache;for(var key in _598){var _599=_598[key];if(typeof _599=="object"){_58b.destroy(_599);}delete _598[key];}});}return _58e;});},"dojox/lang/functional/object":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_59a,lang,df){var _59b={};lang.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _59b)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _59b)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||_59a.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _59b)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||_59a.global;f=df.lambda(f);for(var i in obj){if(!(i in _59b)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||_59a.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _59b)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});return df;});},"dojo/window":function(){define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style","./dom-construct"],function(lang,has,_59c,dom,geom,_59d,_59e){has.add("rtl-adjust-position-for-verticalScrollBar",function(win,doc){var body=_59c.body(doc),_59f=_59e.create("div",{style:{overflow:"scroll",overflowX:"visible",direction:"rtl",visibility:"hidden",position:"absolute",left:"0",top:"0",width:"64px",height:"64px"}},body,"last"),div=_59e.create("div",{style:{overflow:"hidden",direction:"ltr"}},_59f,"last"),ret=geom.position(div).x!=0;_59f.removeChild(div);body.removeChild(_59f);return ret;});has.add("position-fixed-support",function(win,doc){var body=_59c.body(doc),_5a0=_59e.create("span",{style:{visibility:"hidden",position:"fixed",left:"1px",top:"1px"}},body,"last"),_5a1=_59e.create("span",{style:{position:"fixed",left:"0",top:"0"}},_5a0,"last"),ret=geom.position(_5a1).x!=geom.position(_5a0).x;_5a0.removeChild(_5a1);body.removeChild(_5a0);return ret;});var _5a2={getBox:function(doc){doc=doc||_59c.doc;var _5a3=(doc.compatMode=="BackCompat")?_59c.body(doc):doc.documentElement,_5a4=geom.docScroll(doc),w,h;if(has("touch")){var _5a5=_5a2.get(doc);w=_5a5.innerWidth||_5a3.clientWidth;h=_5a5.innerHeight||_5a3.clientHeight;}else{w=_5a3.clientWidth;h=_5a3.clientHeight;}return {l:_5a4.x,t:_5a4.y,w:w,h:h};},get:function(doc){if(has("ie")&&_5a2!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;},scrollIntoView:function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_59c.doc,body=_59c.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");if(node==body||node==html){return;}if(!(has("mozilla")||isIE||isWK||has("opera"))&&("scrollIntoView" in node)){node.scrollIntoView(false);return;}var _5a6=doc.compatMode=="BackCompat",_5a7=Math.min(body.clientWidth||html.clientWidth,html.clientWidth||body.clientWidth),_5a8=Math.min(body.clientHeight||html.clientHeight,html.clientHeight||body.clientHeight),_5a9=(isWK||_5a6)?body:html,_5aa=pos||geom.position(node),el=node.parentNode,_5ab=function(el){return (isIE<=6||(isIE==7&&_5a6))?false:(has("position-fixed-support")&&(_59d.get(el,"position").toLowerCase()=="fixed"));};if(_5ab(node)){return;}while(el){if(el==body){el=_5a9;}var _5ac=geom.position(el),_5ad=_5ab(el),rtl=_59d.getComputedStyle(el).direction.toLowerCase()=="rtl";if(el==_5a9){_5ac.w=_5a7;_5ac.h=_5a8;if(_5a9==html&&isIE&&rtl){_5ac.x+=_5a9.offsetWidth-_5ac.w;}if(_5ac.x<0||!isIE||isIE>=9){_5ac.x=0;}if(_5ac.y<0||!isIE||isIE>=9){_5ac.y=0;}}else{var pb=geom.getPadBorderExtents(el);_5ac.w-=pb.w;_5ac.h-=pb.h;_5ac.x+=pb.l;_5ac.y+=pb.t;var _5ae=el.clientWidth,_5af=_5ac.w-_5ae;if(_5ae>0&&_5af>0){if(rtl&&has("rtl-adjust-position-for-verticalScrollBar")){_5ac.x+=_5af;}_5ac.w=_5ae;}_5ae=el.clientHeight;_5af=_5ac.h-_5ae;if(_5ae>0&&_5af>0){_5ac.h=_5ae;}}if(_5ad){if(_5ac.y<0){_5ac.h+=_5ac.y;_5ac.y=0;}if(_5ac.x<0){_5ac.w+=_5ac.x;_5ac.x=0;}if(_5ac.y+_5ac.h>_5a8){_5ac.h=_5a8-_5ac.y;}if(_5ac.x+_5ac.w>_5a7){_5ac.w=_5a7-_5ac.x;}}var l=_5aa.x-_5ac.x,t=_5aa.y-_5ac.y,r=l+_5aa.w-_5ac.w,bot=t+_5aa.h-_5ac.h;var s,old;if(r*l>0&&(!!el.scrollLeft||el==_5a9||el.scrollWidth>el.offsetHeight)){s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_5a6)||isIE>=9)){s=-s;}old=el.scrollLeft;el.scrollLeft+=s;s=el.scrollLeft-old;_5aa.x-=s;}if(bot*t>0&&(!!el.scrollTop||el==_5a9||el.scrollHeight>el.offsetHeight)){s=Math.ceil(Math[t<0?"max":"min"](t,bot));old=el.scrollTop;el.scrollTop+=s;s=el.scrollTop-old;_5aa.y-=s;}el=(el!=_5a9)&&!_5ad&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}}};1&&lang.setObject("dojo.window",_5a2);return _5a2;});},"dojox/charting/axis2d/Default":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/sniff","dojo/_base/declare","dojo/_base/connect","dojo/dom-geometry","./Invisible","../scaler/linear","./common","dojox/gfx","dojox/lang/utils","dojox/lang/functional","dojo/has!dojo-bidi?../bidi/axis2d/Default"],function(lang,arr,has,_5b0,_5b1,_5b2,_5b3,lin,_5b4,g,du,df,_5b5){var _5b6=45;var _5b7=_5b0(has("dojo-bidi")?"dojox.charting.axis2d.NonBidiDefault":"dojox.charting.axis2d.Default",_5b3,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0,htmlLabels:true,enableCache:false,dropLabels:true,labelSizeChange:false},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,maxLabelCharCount:0,trailingSymbol:null,stroke:{},majorTick:{},minorTick:{},microTick:{},tick:{},font:"",fontColor:"",title:"",titleGap:0,titleFont:"",titleFontColor:"",titleOrientation:""},constructor:function(_5b8,_5b9){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_5b9);du.updateWithPattern(this.opt,_5b9,this.optionalParams);if(this.opt.enableCache){this._textFreePool=[];this._lineFreePool=[];this._textUsePool=[];this._lineUsePool=[];}this._invalidMaxLabelSize=true;},setWindow:function(_5ba,_5bb){if(_5ba!=this.scale){this._invalidMaxLabelSize=true;}return this.inherited(arguments);},_groupLabelWidth:function(_5bc,font,_5bd){if(!_5bc.length){return 0;}if(_5bc.length>50){_5bc.length=50;}if(lang.isObject(_5bc[0])){_5bc=df.map(_5bc,function(_5be){return _5be.text;});}if(_5bd){_5bc=df.map(_5bc,function(_5bf){return lang.trim(_5bf).length==0?"":_5bf.substring(0,_5bd)+this.trailingSymbol;},this);}var s=_5bc.join("<br>");return g._base._getTextBox(s,{font:font}).w||0;},_getMaxLabelSize:function(min,max,span,_5c0,font,size){if(this._maxLabelSize==null&&arguments.length==6){var o=this.opt;this.scaler.minMinorStep=this._prevMinMinorStep=0;var ob=lang.clone(o);delete ob.to;delete ob.from;var sb=lin.buildScaler(min,max,span,ob,o.to-o.from);sb.minMinorStep=0;this._majorStart=sb.major.start;var tb=lin.buildTicks(sb,o);if(size&&tb){var _5c1=0,_5c2=0;var _5c3=function(tick){if(tick.label){this.push(tick.label);}};var _5c4=[];if(this.opt.majorLabels){arr.forEach(tb.major,_5c3,_5c4);_5c1=this._groupLabelWidth(_5c4,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_5c1=Math.min(ob.maxLabelSize,_5c1);}}_5c4=[];if(this.opt.dropLabels&&this.opt.minorLabels){arr.forEach(tb.minor,_5c3,_5c4);_5c2=this._groupLabelWidth(_5c4,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_5c2=Math.min(ob.maxLabelSize,_5c2);}}this._maxLabelSize={majLabelW:_5c1,minLabelW:_5c2,majLabelH:size,minLabelH:size};}else{this._maxLabelSize=null;}}return this._maxLabelSize;},calculate:function(min,max,span){this.inherited(arguments);this.scaler.minMinorStep=this._prevMinMinorStep;if((this._invalidMaxLabelSize||span!=this._oldSpan)&&(min!=Infinity&&max!=-Infinity)){this._invalidMaxLabelSize=false;if(this.opt.labelSizeChange){this._maxLabelSize=null;}this._oldSpan=span;var o=this.opt;var ta=this.chart.theme.axis,_5c5=o.rotation%360,_5c6=this.chart.theme.axis.tick.labelGap,font=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),size=font?g.normalizedLength(g.splitFontString(font).size):0,_5c7=this._getMaxLabelSize(min,max,span,_5c5,font,size);if(typeof _5c6!="number"){_5c6=4;}if(_5c7&&o.dropLabels){var cosr=Math.abs(Math.cos(_5c5*Math.PI/180)),sinr=Math.abs(Math.sin(_5c5*Math.PI/180));var _5c8,_5c9;if(_5c5<0){_5c5+=360;}switch(_5c5){case 0:case 180:if(this.vertical){_5c8=_5c9=size;}else{_5c8=_5c7.majLabelW;_5c9=_5c7.minLabelW;}break;case 90:case 270:if(this.vertical){_5c8=_5c7.majLabelW;_5c9=_5c7.minLabelW;}else{_5c8=_5c9=size;}break;default:_5c8=this.vertical?Math.min(_5c7.majLabelW,size/cosr):Math.min(_5c7.majLabelW,size/sinr);var gap1=Math.sqrt(_5c7.minLabelW*_5c7.minLabelW+size*size),gap2=this.vertical?size*cosr+_5c7.minLabelW*sinr:_5c7.minLabelW*cosr+size*sinr;_5c9=Math.min(gap1,gap2);break;}this.scaler.minMinorStep=this._prevMinMinorStep=Math.max(_5c8,_5c9)+_5c6;var _5ca=this.scaler.minMinorStep<=this.scaler.minor.tick*this.scaler.bounds.scale;if(!_5ca){this._skipInterval=Math.floor((_5c8+_5c6)/(this.scaler.major.tick*this.scaler.bounds.scale));}else{this._skipInterval=0;}}else{this._skipInterval=0;}}this.ticks=lin.buildTicks(this.scaler,this.opt);return this;},getOffsets:function(){var s=this.scaler,_5cb={l:0,r:0,t:0,b:0};if(!s){return _5cb;}var o=this.opt,ta=this.chart.theme.axis,_5cc=this.chart.theme.axis.tick.labelGap,_5cd=o.titleFont||(ta.title&&ta.title.font),_5ce=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap),_5cf=this.chart.theme.getTick("major",o),_5d0=this.chart.theme.getTick("minor",o),_5d1=_5cd?g.normalizedLength(g.splitFontString(_5cd).size):0,_5d2=o.rotation%360,_5d3=o.leftBottom,cosr=Math.abs(Math.cos(_5d2*Math.PI/180)),sinr=Math.abs(Math.sin(_5d2*Math.PI/180));this.trailingSymbol=(o.trailingSymbol===undefined||o.trailingSymbol===null)?this.trailingSymbol:o.trailingSymbol;if(typeof _5cc!="number"){_5cc=4;}if(_5d2<0){_5d2+=360;}var _5d4=this._getMaxLabelSize();if(_5d4){var side;var _5d5=Math.ceil(Math.max(_5d4.majLabelW,_5d4.minLabelW))+1,size=Math.ceil(Math.max(_5d4.majLabelH,_5d4.minLabelH))+1;if(this.vertical){side=_5d3?"l":"r";switch(_5d2){case 0:case 180:_5cb[side]=_5d5;_5cb.t=_5cb.b=size/2;break;case 90:case 270:_5cb[side]=size;_5cb.t=_5cb.b=_5d5/2;break;default:if(_5d2<=_5b6||(180<_5d2&&_5d2<=(180+_5b6))){_5cb[side]=size*sinr/2+_5d5*cosr;_5cb[_5d3?"t":"b"]=size*cosr/2+_5d5*sinr;_5cb[_5d3?"b":"t"]=size*cosr/2;}else{if(_5d2>(360-_5b6)||(180>_5d2&&_5d2>(180-_5b6))){_5cb[side]=size*sinr/2+_5d5*cosr;_5cb[_5d3?"b":"t"]=size*cosr/2+_5d5*sinr;_5cb[_5d3?"t":"b"]=size*cosr/2;}else{if(_5d2<90||(180<_5d2&&_5d2<270)){_5cb[side]=size*sinr+_5d5*cosr;_5cb[_5d3?"t":"b"]=size*cosr+_5d5*sinr;}else{_5cb[side]=size*sinr+_5d5*cosr;_5cb[_5d3?"b":"t"]=size*cosr+_5d5*sinr;}}}break;}_5cb[side]+=_5cc+Math.max(_5cf.length>0?_5cf.length:0,_5d0.length>0?_5d0.length:0)+(o.title?(_5d1+_5ce):0);}else{side=_5d3?"b":"t";switch(_5d2){case 0:case 180:_5cb[side]=size;_5cb.l=_5cb.r=_5d5/2;break;case 90:case 270:_5cb[side]=_5d5;_5cb.l=_5cb.r=size/2;break;default:if((90-_5b6)<=_5d2&&_5d2<=90||(270-_5b6)<=_5d2&&_5d2<=270){_5cb[side]=size*cosr/2+_5d5*sinr;_5cb[_5d3?"r":"l"]=size*sinr/2+_5d5*cosr;_5cb[_5d3?"l":"r"]=size*sinr/2;}else{if(90<=_5d2&&_5d2<=(90+_5b6)||270<=_5d2&&_5d2<=(270+_5b6)){_5cb[side]=size*cosr/2+_5d5*sinr;_5cb[_5d3?"l":"r"]=size*sinr/2+_5d5*cosr;_5cb[_5d3?"r":"l"]=size*sinr/2;}else{if(_5d2<_5b6||(180<_5d2&&_5d2<(180+_5b6))){_5cb[side]=size*cosr+_5d5*sinr;_5cb[_5d3?"r":"l"]=size*sinr+_5d5*cosr;}else{_5cb[side]=size*cosr+_5d5*sinr;_5cb[_5d3?"l":"r"]=size*sinr+_5d5*cosr;}}}break;}_5cb[side]+=_5cc+Math.max(_5cf.length>0?_5cf.length:0,_5d0.length>0?_5d0.length:0)+(o.title?(_5d1+_5ce):0);}}return _5cb;},cleanGroup:function(_5d6){if(this.opt.enableCache&&this.group){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._textFreePool=this._textFreePool.concat(this._textUsePool);this._textUsePool=[];}this.inherited(arguments);},createText:function(_5d7,_5d8,x,y,_5d9,_5da,font,_5db,_5dc){if(!this.opt.enableCache||_5d7=="html"){return _5b4.createText[_5d7](this.chart,_5d8,x,y,_5d9,_5da,font,_5db,_5dc);}var text;if(this._textFreePool.length>0){text=this._textFreePool.pop();text.setShape({x:x,y:y,text:_5da,align:_5d9});_5d8.add(text);}else{text=_5b4.createText[_5d7](this.chart,_5d8,x,y,_5d9,_5da,font,_5db);}this._textUsePool.push(text);return text;},createLine:function(_5dd,_5de){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_5de);_5dd.add(line);}else{line=_5dd.createLine(_5de);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_5df){var _5e0=this._isRtl();if(!this.dirty||!this.scaler){return this;}var o=this.opt,ta=this.chart.theme.axis,_5e1=o.leftBottom,_5e2=o.rotation%360,_5e3,stop,_5e4,_5e5=0,_5e6,_5e7,_5e8,_5e9,_5ea,_5eb,_5ec=this.chart.theme.axis.tick.labelGap,_5ed=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_5ee=o.titleFont||(ta.title&&ta.title.font),_5ef=o.fontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"black",_5f0=o.titleFontColor||(ta.title&&ta.title.fontColor)||"black",_5f1=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap)||15,_5f2=o.titleOrientation||(ta.title&&ta.title.orientation)||"axis",_5f3=this.chart.theme.getTick("major",o),_5f4=this.chart.theme.getTick("minor",o),_5f5=this.chart.theme.getTick("micro",o),_5f6="stroke" in o?o.stroke:ta.stroke,size=_5ed?g.normalizedLength(g.splitFontString(_5ed).size):0,cosr=Math.abs(Math.cos(_5e2*Math.PI/180)),sinr=Math.abs(Math.sin(_5e2*Math.PI/180)),_5f7=_5ee?g.normalizedLength(g.splitFontString(_5ee).size):0;if(typeof _5ec!="number"){_5ec=4;}if(_5e2<0){_5e2+=360;}var _5f8=this._getMaxLabelSize();_5f8=_5f8&&_5f8.majLabelW;if(this.vertical){_5e3={y:dim.height-_5df.b};stop={y:_5df.t};_5e4={y:(dim.height-_5df.b+_5df.t)/2};_5e6=size*sinr+(_5f8||0)*cosr+_5ec+Math.max(_5f3.length>0?_5f3.length:0,_5f4.length>0?_5f4.length:0)+_5f7+_5f1;_5e7={x:0,y:-1};_5ea={x:0,y:0};_5e8={x:1,y:0};_5e9={x:_5ec,y:0};switch(_5e2){case 0:_5eb="end";_5ea.y=size*0.4;break;case 90:_5eb="middle";_5ea.x=-size;break;case 180:_5eb="start";_5ea.y=-size*0.4;break;case 270:_5eb="middle";break;default:if(_5e2<_5b6){_5eb="end";_5ea.y=size*0.4;}else{if(_5e2<90){_5eb="end";_5ea.y=size*0.4;}else{if(_5e2<(180-_5b6)){_5eb="start";}else{if(_5e2<(180+_5b6)){_5eb="start";_5ea.y=-size*0.4;}else{if(_5e2<270){_5eb="start";_5ea.x=_5e1?0:size*0.4;}else{if(_5e2<(360-_5b6)){_5eb="end";_5ea.x=_5e1?0:size*0.4;}else{_5eb="end";_5ea.y=size*0.4;}}}}}}}if(_5e1){_5e3.x=stop.x=_5df.l;_5e5=(_5f2&&_5f2=="away")?90:270;_5e4.x=_5df.l-_5e6+(_5e5==270?_5f7:0);_5e8.x=-1;_5e9.x=-_5e9.x;}else{_5e3.x=stop.x=dim.width-_5df.r;_5e5=(_5f2&&_5f2=="axis")?90:270;_5e4.x=dim.width-_5df.r+_5e6-(_5e5==270?0:_5f7);switch(_5eb){case "start":_5eb="end";break;case "end":_5eb="start";break;case "middle":_5ea.x+=size;break;}}}else{_5e3={x:_5df.l};stop={x:dim.width-_5df.r};_5e4={x:(dim.width-_5df.r+_5df.l)/2};_5e6=size*cosr+(_5f8||0)*sinr+_5ec+Math.max(_5f3.length>0?_5f3.length:0,_5f4.length>0?_5f4.length:0)+_5f7+_5f1;_5e7={x:_5e0?-1:1,y:0};_5ea={x:0,y:0};_5e8={x:0,y:1};_5e9={x:0,y:_5ec};switch(_5e2){case 0:_5eb="middle";_5ea.y=size;break;case 90:_5eb="start";_5ea.x=-size*0.4;break;case 180:_5eb="middle";break;case 270:_5eb="end";_5ea.x=size*0.4;break;default:if(_5e2<(90-_5b6)){_5eb="start";_5ea.y=_5e1?size:0;}else{if(_5e2<(90+_5b6)){_5eb="start";_5ea.x=-size*0.4;}else{if(_5e2<180){_5eb="start";_5ea.y=_5e1?0:-size;}else{if(_5e2<(270-_5b6)){_5eb="end";_5ea.y=_5e1?0:-size;}else{if(_5e2<(270+_5b6)){_5eb="end";_5ea.y=_5e1?size*0.4:0;}else{_5eb="end";_5ea.y=_5e1?size:0;}}}}}}if(_5e1){_5e3.y=stop.y=dim.height-_5df.b;_5e5=(_5f2&&_5f2=="axis")?180:0;_5e4.y=dim.height-_5df.b+_5e6-(_5e5?_5f7:0);}else{_5e3.y=stop.y=_5df.t;_5e5=(_5f2&&_5f2=="away")?180:0;_5e4.y=_5df.t-_5e6+(_5e5?0:_5f7);_5e8.y=-1;_5e9.y=-_5e9.y;switch(_5eb){case "start":_5eb="end";break;case "end":_5eb="start";break;case "middle":_5ea.y-=size;break;}}}this.cleanGroup();var s=this.group,c=this.scaler,t=this.ticks,f=lin.getTransformerFromModel(this.scaler),_5f9=(!o.title||!_5e5)&&!_5e2&&this.opt.htmlLabels&&!has("ie")&&!has("opera")?"html":"gfx",dx=_5e8.x*_5f3.length,dy=_5e8.y*_5f3.length,skip=this._skipInterval;s.createLine({x1:_5e3.x,y1:_5e3.y,x2:stop.x,y2:stop.y}).setStroke(_5f6);if(o.title){var _5fa=_5b4.createText[_5f9](this.chart,s,_5e4.x,_5e4.y,"middle",o.title,_5ee,_5f0);if(_5f9=="html"){this.htmlElements.push(_5fa);}else{_5fa.setTransform(g.matrix.rotategAt(_5e5,_5e4.x,_5e4.y));}}if(t==null){this.dirty=false;return this;}var rel=(t.major.length>0)?(t.major[0].value-this._majorStart)/c.major.tick:0;var _5fb=this.opt.majorLabels;arr.forEach(t.major,function(tick,i){var _5fc=f(tick.value),elem,x=(_5e0?stop.x:_5e3.x)+_5e7.x*_5fc,y=_5e3.y+_5e7.y*_5fc;i+=rel;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_5f3);if(tick.label&&(!skip||(i-(1+skip))%(1+skip)==0)){var _5fd=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_5ed,o.maxLabelCharCount):{text:tick.label,truncated:false};_5fd=o.maxLabelSize?this.getTextWithLimitLength(_5fd.text,_5ed,o.maxLabelSize,_5fd.truncated):_5fd;elem=this.createText(_5f9,s,x+(_5f3.length>0?dx:0)+_5e9.x+(_5e2?0:_5ea.x),y+(_5f3.length>0?dy:0)+_5e9.y+(_5e2?0:_5ea.y),_5eb,_5fd.text,_5ed,_5ef);if(_5fd.truncated){this.chart.formatTruncatedLabel(elem,tick.label,_5f9);}_5fd.truncated&&this.labelTooltip(elem,this.chart,tick.label,_5fd.text,_5ed,_5f9);if(_5f9=="html"){this.htmlElements.push(elem);}else{if(_5e2){elem.setTransform([{dx:_5ea.x,dy:_5ea.y},g.matrix.rotategAt(_5e2,x+(_5f3.length>0?dx:0)+_5e9.x,y+(_5f3.length>0?dy:0)+_5e9.y)]);}}}},this);dx=_5e8.x*_5f4.length;dy=_5e8.y*_5f4.length;_5fb=this.opt.minorLabels&&c.minMinorStep<=c.minor.tick*c.bounds.scale;arr.forEach(t.minor,function(tick){var _5fe=f(tick.value),elem,x=(_5e0?stop.x:_5e3.x)+_5e7.x*_5fe,y=_5e3.y+_5e7.y*_5fe;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_5f4);if(_5fb&&tick.label){var _5ff=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_5ed,o.maxLabelCharCount):{text:tick.label,truncated:false};_5ff=o.maxLabelSize?this.getTextWithLimitLength(_5ff.text,_5ed,o.maxLabelSize,_5ff.truncated):_5ff;elem=this.createText(_5f9,s,x+(_5f4.length>0?dx:0)+_5e9.x+(_5e2?0:_5ea.x),y+(_5f4.length>0?dy:0)+_5e9.y+(_5e2?0:_5ea.y),_5eb,_5ff.text,_5ed,_5ef);if(_5ff.truncated){this.chart.formatTruncatedLabel(elem,tick.label,_5f9);}_5ff.truncated&&this.labelTooltip(elem,this.chart,tick.label,_5ff.text,_5ed,_5f9);if(_5f9=="html"){this.htmlElements.push(elem);}else{if(_5e2){elem.setTransform([{dx:_5ea.x,dy:_5ea.y},g.matrix.rotategAt(_5e2,x+(_5f4.length>0?dx:0)+_5e9.x,y+(_5f4.length>0?dy:0)+_5e9.y)]);}}}},this);dx=_5e8.x*_5f5.length;dy=_5e8.y*_5f5.length;arr.forEach(t.micro,function(tick){var _600=f(tick.value),x=_5e3.x+_5e7.x*_600,y=_5e3.y+_5e7.y*_600;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_5f5);},this);this.dirty=false;return this;},labelTooltip:function(elem,_601,_602,_603,font,_604){var _605=["dijit/Tooltip"];var _606={type:"rect"},_607=["above","below"],_608=g._base._getTextBox(_603,{font:font}).w||0,_609=font?g.normalizedLength(g.splitFontString(font).size):0;if(_604=="html"){lang.mixin(_606,_5b2.position(elem.firstChild,true));_606.width=Math.ceil(_608);_606.height=Math.ceil(_609);this._events.push({shape:dojo,handle:_5b1.connect(elem.firstChild,"onmouseover",this,function(e){require(_605,function(_60a){_60a.show(_602,_606,_607);});})});this._events.push({shape:dojo,handle:_5b1.connect(elem.firstChild,"onmouseout",this,function(e){require(_605,function(_60b){_60b.hide(_606);});})});}else{var shp=elem.getShape(),lt=_601.getCoords();_606=lang.mixin(_606,{x:shp.x-_608/2,y:shp.y});_606.x+=lt.x;_606.y+=lt.y;_606.x=Math.round(_606.x);_606.y=Math.round(_606.y);_606.width=Math.ceil(_608);_606.height=Math.ceil(_609);this._events.push({shape:elem,handle:elem.connect("onmouseenter",this,function(e){require(_605,function(_60c){_60c.show(_602,_606,_607);});})});this._events.push({shape:elem,handle:elem.connect("onmouseleave",this,function(e){require(_605,function(_60d){_60d.hide(_606);});})});}},_isRtl:function(){return false;}});return has("dojo-bidi")?_5b0("dojox.charting.axis2d.Default",[_5b7,_5b5]):_5b7;});},"dojox/charting/plot2d/ClusteredBars":function(){define(["dojo/_base/declare","./Bars","./common"],function(_60e,Bars,dc){return _60e("dojox.charting.plot2d.ClusteredBars",Bars,{getBarProperties:function(){var f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,this.series.length);return {gap:f.gap,height:f.size,thickness:f.size};}});});},"dojox/charting/action2d/MoveSlice":function(){define(["dojo/_base/connect","dojo/_base/declare","dojo/_base/array","./PlotAction","dojo/fx/easing","dojox/gfx/matrix","dojox/gfx/fx","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(hub,_60f,_610,_611,dfe,m,gf,df){var _612=1.05,_613=7;return _60f("dojox.charting.action2d.MoveSlice",_611,{defaultParams:{duration:400,easing:dfe.backOut,scale:_612,shift:_613},optionalParams:{},constructor:function(_614,plot,_615){if(!_615){_615={};}this.scale=typeof _615.scale=="number"?_615.scale:_612;this.shift=typeof _615.shift=="number"?_615.shift:_613;this.connect();},process:function(o){if(!o.shape||o.element!="slice"||!(o.type in this.overOutEvents)){return;}if(!this.angles){var _616=m._degToRad(o.plot.opt.startAngle);if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}this.angles=_610.map(this.angles,function(item){return item+_616;});}var _617=o.index,anim,_618,_619,_61a,_61b,_61c=(this.angles[_617]+this.angles[_617+1])/2,_61d=m.rotateAt(-_61c,o.cx,o.cy),_61e=m.rotateAt(_61c,o.cx,o.cy);anim=this.anim[_617];if(anim){anim.action.stop(true);}else{this.anim[_617]=anim={};}if(o.type=="onmouseover"){_61a=0;_61b=this.shift;_618=1;_619=this.scale;}else{_61a=this.shift;_61b=0;_618=this.scale;_619=1;}anim.action=gf.animateTransform({shape:o.shape,duration:this.duration,easing:this.easing,transform:[_61e,{name:"translate",start:[_61a,0],end:[_61b,0]},{name:"scaleAt",start:[_618,o.cx,o.cy],end:[_619,o.cx,o.cy]},_61d]});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){delete this.anim[_617];});}anim.action.play();},reset:function(){delete this.angles;}});});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_61f,_620){var _621={};lang.setObject("dojo.colors",_621);var _622=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_61f.fromRgb=function(_623,obj){var m=_623.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_620.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _61f.fromArray(a,obj);}return _61f.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_622(m1,m2,H+1/3)*256,_622(m1,m2,H)*256,_622(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _61f.fromArray(a,obj);}}return null;};var _624=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_61f.prototype.sanitize=function(){var t=this;t.r=Math.round(_624(t.r,0,255));t.g=Math.round(_624(t.g,0,255));t.b=Math.round(_624(t.b,0,255));t.a=_624(t.a,0,1);return this;};_621.makeGrey=_61f.makeGrey=function(g,a){return _61f.fromArray([g,g,g,a]);};lang.mixin(_61f.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _61f;});},"dojox/charting/SimpleTheme":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/Color","dojox/lang/utils","dojox/gfx/gradutils"],function(lang,arr,_625,_626,dlu,dgg){var _627=_625("dojox.charting.SimpleTheme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(_628){_628=_628||{};var def=_627.defaultTheme;arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){this[name]=lang.delegate(def[name],_628[name]);},this);if(_628.seriesThemes&&_628.seriesThemes.length){this.colors=null;this.seriesThemes=_628.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(_628.colors||_627.defaultColors).slice(0);}this.markerThemes=null;if(_628.markerThemes&&_628.markerThemes.length){this.markerThemes=_628.markerThemes.slice(0);}this.markers=_628.markers?lang.clone(_628.markers):lang.delegate(_627.defaultMarkers);this.noGradConv=_628.noGradConv;this.noRadialConv=_628.noRadialConv;if(_628.reverseFills){this.reverseFills();}this._current=0;this._buildMarkerArray();},clone:function(){var _629=new this.constructor({chart:this.chart,plotarea:this.plotarea,axis:this.axis,grid:this.grid,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,indicator:this.indicator,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv});arr.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(name){if(this.hasOwnProperty(name)){_629[name]=this[name];}},this);return _629;},clear:function(){this._current=0;},next:function(_62a,_62b,_62c){var _62d=dlu.merge,_62e,_62f;if(this.colors){_62e=lang.delegate(this.series);_62f=lang.delegate(this.marker);var _630=new _626(this.colors[this._current%this.colors.length]),old;if(_62e.stroke&&_62e.stroke.color){_62e.stroke=lang.delegate(_62e.stroke);old=new _626(_62e.stroke.color);_62e.stroke.color=new _626(_630);_62e.stroke.color.a=old.a;}else{_62e.stroke={color:_630};}if(_62f.stroke&&_62f.stroke.color){_62f.stroke=lang.delegate(_62f.stroke);old=new _626(_62f.stroke.color);_62f.stroke.color=new _626(_630);_62f.stroke.color.a=old.a;}else{_62f.stroke={color:_630};}if(!_62e.fill||_62e.fill.type){_62e.fill=_630;}else{old=new _626(_62e.fill);_62e.fill=new _626(_630);_62e.fill.a=old.a;}if(!_62f.fill||_62f.fill.type){_62f.fill=_630;}else{old=new _626(_62f.fill);_62f.fill=new _626(_630);_62f.fill.a=old.a;}}else{_62e=this.seriesThemes?_62d(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;_62f=this.markerThemes?_62d(this.marker,this.markerThemes[this._current%this.markerThemes.length]):_62e;}var _631=_62f&&_62f.symbol||this._markers[this._current%this._markers.length];var _632={series:_62e,marker:_62f,symbol:_631};++this._current;if(_62b){_632=this.addMixin(_632,_62a,_62b);}if(_62c){_632=this.post(_632,_62a);}return _632;},skip:function(){++this._current;},addMixin:function(_633,_634,_635,_636){if(lang.isArray(_635)){arr.forEach(_635,function(m){_633=this.addMixin(_633,_634,m);},this);}else{var t={};if("color" in _635){if(_634=="line"||_634=="area"){lang.setObject("series.stroke.color",_635.color,t);lang.setObject("marker.stroke.color",_635.color,t);}else{lang.setObject("series.fill",_635.color,t);}}arr.forEach(["stroke","outline","shadow","fill","filter","font","fontColor","labelWiring"],function(name){var _637="marker"+name.charAt(0).toUpperCase()+name.substr(1),b=_637 in _635;if(name in _635){lang.setObject("series."+name,_635[name],t);if(!b){lang.setObject("marker."+name,_635[name],t);}}if(b){lang.setObject("marker."+name,_635[_637],t);}});if("marker" in _635){t.symbol=_635.marker;t.symbol=_635.marker;}_633=dlu.merge(_633,t);}if(_636){_633=this.post(_633,_634);}return _633;},post:function(_638,_639){var fill=_638.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[fill.space]&&fill.type=="linear"){if(_639=="bar"){t={x1:fill.y1,y1:fill.x1,x2:fill.y2,y2:fill.x2};}else{if(!this.noRadialConv&&fill.space=="shape"&&(_639=="slice"||_639=="circle")){t={type:"radial",cx:0,cy:0,r:100};}}if(t){return dlu.merge(_638,{series:{fill:t}});}}return _638;},getTick:function(name,_63a){var tick=this.axis.tick,_63b=name+"Tick",_63c=dlu.merge;if(tick){if(this.axis[_63b]){tick=_63c(tick,this.axis[_63b]);}}else{tick=this.axis[_63b];}if(_63a){if(tick){if(_63a[_63b]){tick=_63c(tick,_63a[_63b]);}}else{tick=_63a[_63b];}}return tick;},inspectObjects:function(f){arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){f(this[name]);},this);if(this.seriesThemes){arr.forEach(this.seriesThemes,f);}if(this.markerThemes){arr.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dgg.reverse(o.fill);}});},addMarker:function(name,_63d){this.markers[name]=_63d;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});lang.mixin(_627,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null,titleGap:20,titlePos:"top",titleFont:"normal normal bold 14pt Tahoma",titleFontColor:"#333"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333",labelGap:4},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1},title:{gap:15,font:"normal normal normal 11pt Tahoma",fontColor:"#333",orientation:"axis"}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000",labelWiring:{width:1,color:"#ccc"}},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},indicator:{lineStroke:{width:1.5,color:"#333"},lineOutline:{width:0.1,color:"#ccc"},lineShadow:null,lineFill:null,stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",radius:3,font:"normal normal normal 10pt Tahoma",fontColor:"#000",markerFill:"#ccc",markerSymbol:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",markerStroke:{width:1.5,color:"#333"},markerOutline:{width:0.1,color:"#ccc"},markerShadow:null}}});return _627;});},"dijit/Tooltip":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_63e,_63f,fx,dom,_640,_641,_642,lang,_643,on,has,_644,_645,_646,_647,_648,_649,_64a){var _64b=_63f("dijit._MasterTooltip",[_646,_647],{duration:_644.defaultDuration,templateString:_649,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _648(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_64c,_64d,_64e,rtl,_64f){if(this.aroundNode&&this.aroundNode===_64d&&this.containerNode.innerHTML==_64c){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_64c;if(_64f){this.set("textDir",_64f);}this.containerNode.align=rtl?"right":"left";var pos=_645.around(this.domNode,_64d,_64e&&_64e.length?_64e:_650.defaultPosition,!rtl,lang.hitch(this,"orient"));var _651=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_651.y+((_651.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_651.x+((_651.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_642.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_64d;},orient:function(node,_652,_653,_654,_655){this.connectorNode.style.top="";var _656=_654.h,_657=_654.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_652+"-"+_653];this.domNode.style.width="auto";var size=_641.position(this.domNode);if(has("ie")==9){size.w+=2;}var _658=Math.min((Math.max(_657,1)),size.w);_641.setMarginBox(this.domNode,{w:_658});if(_653.charAt(0)=="B"&&_652.charAt(0)=="B"){var bb=_641.position(node);var _659=this.connectorNode.offsetHeight;if(bb.h>_656){var _65a=_656-((_655.h+_659)>>1);this.connectorNode.style.top=_65a+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_655.h/2-_659/2,0),bb.h-_659)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_657);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_65b){if(this._onDeck&&this._onDeck[1]==_65b){this._onDeck=null;}else{if(this.aroundNode===_65b){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});if(has("dojo-bidi")){_64b.extend({_setAutoTextDir:function(node){this.applyTextDir(node);_63e.forEach(node.children,function(_65c){this._setAutoTextDir(_65c);},this);},_setTextDirAttr:function(_65d){this._set("textDir",_65d);if(_65d=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});}_64a.showTooltip=function(_65e,_65f,_660,rtl,_661){if(_660){_660=_63e.map(_660,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_650._masterTT){_64a._masterTT=_650._masterTT=new _64b();}return _650._masterTT.show(_65e,_65f,_660,rtl,_661);};_64a.hideTooltip=function(_662){return _650._masterTT&&_650._masterTT.hide(_662);};var _650=_63f("dijit.Tooltip",_646,{label:"",showDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_663){_63e.forEach(this._connections||[],function(_664){_63e.forEach(_664,function(_665){_665.remove();});},this);this._connectIds=_63e.filter(lang.isArrayLike(_663)?_663:(_663?[_663]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_63e.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_666=this.selector,_667=_666?function(_668){return on.selector(_666,_668);}:function(_669){return _669;},self=this;return [on(node,_667(_643.enter),function(){self._onHover(this);}),on(node,_667("focusin"),function(){self._onHover(this);}),on(node,_667(_643.leave),lang.hitch(self,"_onUnHover")),on(node,_667("focusout"),lang.hitch(self,"_onUnHover"))];},this);this._set("connectId",_663);},addTarget:function(node){var id=node.id||node;if(_63e.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_63e.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_640.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_63e.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},_onHover:function(_66a){if(!this._showTimer){this._showTimer=this.defer(function(){this.open(_66a);},this.showDelay);}},_onUnHover:function(){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}this.close();},open:function(_66b){if(this._showTimer){this._showTimer.remove();delete this._showTimer;}var _66c=this.getContent(_66b);if(!_66c){return;}_650.show(_66c,_66b,this.position,!this.isLeftToRight(),this.textDir);this._connectNode=_66b;this.onShow(_66b,this.position);},close:function(){if(this._connectNode){_650.hide(this._connectNode);delete this._connectNode;this.onHide();}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}},onShow:function(){},onHide:function(){},destroy:function(){this.close();_63e.forEach(this._connections||[],function(_66d){_63e.forEach(_66d,function(_66e){_66e.remove();});},this);this.inherited(arguments);}});_650._MasterTooltip=_64b;_650.show=_64a.showTooltip;_650.hide=_64a.hideTooltip;_650.defaultPosition=["after-centered","before-centered"];return _650;});},"dojox/charting/Element":function(){define(["dojo/_base/array","dojo/dom-construct","dojo/_base/declare","dojox/gfx","dojox/gfx/shape"],function(arr,_66f,_670,gfx,_671){return _670("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,constructor:function(_672){this.chart=_672;this.group=null;this.htmlElements=[];this.dirty=true;this.trailingSymbol="...";this._events=[];},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.getGroup().removeShape();var _673=this.getGroup().children;if(_671.dispose){for(var i=0;i<_673.length;++i){_671.dispose(_673[i],true);}}if(this.getGroup().rawNode){_66f.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_671.dispose){_671.dispose(this.getGroup(),true);}if(this.getGroup()!=this.group){if(this.group.rawNode){_66f.empty(this.group.rawNode);}this.group.clear();if(_671.dispose){_671.dispose(this.group,true);}}this.group=null;}this.dirty=true;if(this._events.length){arr.forEach(this._events,function(item){item.shape.disconnect(item.handle);});this._events=[];}return this;},cleanGroup:function(_674){this.destroyHtmlElements();if(!_674){_674=this.chart.surface;}if(this.group){var _675;var _676=this.getGroup().children;if(_671.dispose){for(var i=0;i<_676.length;++i){_671.dispose(_676[i],true);}}if(this.getGroup().rawNode){_675=this.getGroup().bgNode;_66f.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_675){this.getGroup().rawNode.appendChild(_675);}}else{this.group=_674.createGroup();}this.dirty=true;return this;},getGroup:function(){return this.group;},destroyHtmlElements:function(){if(this.htmlElements.length){arr.forEach(this.htmlElements,_66f.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},getTextWidth:function(s,font){return gfx._base._getTextBox(s,{font:font}).w||0;},getTextWithLimitLength:function(s,font,_677,_678){if(!s||s.length<=0){return {text:"",truncated:_678||false};}if(!_677||_677<=0){return {text:s,truncated:_678||false};}var _679=2,_67a=0.618,_67b=s.substring(0,1)+this.trailingSymbol,_67c=this.getTextWidth(_67b,font);if(_677<=_67c){return {text:_67b,truncated:true};}var _67d=this.getTextWidth(s,font);if(_67d<=_677){return {text:s,truncated:_678||false};}else{var _67e=0,end=s.length;while(_67e<end){if(end-_67e<=_679){while(this.getTextWidth(s.substring(0,_67e)+this.trailingSymbol,font)>_677){_67e-=1;}return {text:(s.substring(0,_67e)+this.trailingSymbol),truncated:true};}var _67f=_67e+Math.round((end-_67e)*_67a),_680=this.getTextWidth(s.substring(0,_67f),font);if(_680<_677){_67e=_67f;end=end;}else{_67e=_67e;end=_67f;}}}},getTextWithLimitCharCount:function(s,font,_681,_682){if(!s||s.length<=0){return {text:"",truncated:_682||false};}if(!_681||_681<=0||s.length<=_681){return {text:s,truncated:_682||false};}return {text:s.substring(0,_681)+this.trailingSymbol,truncated:true};},_plotFill:function(fill,dim,_683){if(!fill||!fill.type||!fill.space){return fill;}var _684=fill.space,span;switch(fill.type){case "linear":if(_684==="plot"||_684==="shapeX"||_684==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_684;if(_684==="plot"||_684==="shapeX"){span=dim.height-_683.t-_683.b;fill.y1=_683.t+span*fill.y1/100;fill.y2=_683.t+span*fill.y2/100;}if(_684==="plot"||_684==="shapeY"){span=dim.width-_683.l-_683.r;fill.x1=_683.l+span*fill.x1/100;fill.x2=_683.l+span*fill.x2/100;}}break;case "radial":if(_684==="plot"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_684;var _685=dim.width-_683.l-_683.r,_686=dim.height-_683.t-_683.b;fill.cx=_683.l+_685*fill.cx/100;fill.cy=_683.t+_686*fill.cy/100;fill.r=fill.r*Math.sqrt(_685*_685+_686*_686)/200;}break;case "pattern":if(_684==="plot"||_684==="shapeX"||_684==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_684;if(_684==="plot"||_684==="shapeX"){span=dim.height-_683.t-_683.b;fill.y=_683.t+span*fill.y/100;fill.height=span*fill.height/100;}if(_684==="plot"||_684==="shapeY"){span=dim.width-_683.l-_683.r;fill.x=_683.l+span*fill.x/100;fill.width=span*fill.width/100;}}break;}return fill;},_shapeFill:function(fill,bbox){if(!fill||!fill.space){return fill;}var _687=fill.space,span;switch(fill.type){case "linear":if(_687==="shape"||_687==="shapeX"||_687==="shapeY"){fill=gfx.makeParameters(gfx.defaultLinearGradient,fill);fill.space=_687;if(_687==="shape"||_687==="shapeX"){span=bbox.width;fill.x1=bbox.x+span*fill.x1/100;fill.x2=bbox.x+span*fill.x2/100;}if(_687==="shape"||_687==="shapeY"){span=bbox.height;fill.y1=bbox.y+span*fill.y1/100;fill.y2=bbox.y+span*fill.y2/100;}}break;case "radial":if(_687==="shape"){fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_687;fill.cx=bbox.x+bbox.width/2;fill.cy=bbox.y+bbox.height/2;fill.r=fill.r*bbox.width/200;}break;case "pattern":if(_687==="shape"||_687==="shapeX"||_687==="shapeY"){fill=gfx.makeParameters(gfx.defaultPattern,fill);fill.space=_687;if(_687==="shape"||_687==="shapeX"){span=bbox.width;fill.x=bbox.x+span*fill.x/100;fill.width=span*fill.width/100;}if(_687==="shape"||_687==="shapeY"){span=bbox.height;fill.y=bbox.y+span*fill.y/100;fill.height=span*fill.height/100;}}break;}return fill;},_pseudoRadialFill:function(fill,_688,_689,_68a,end){if(!fill||fill.type!=="radial"||fill.space!=="shape"){return fill;}var _68b=fill.space;fill=gfx.makeParameters(gfx.defaultRadialGradient,fill);fill.space=_68b;if(arguments.length<4){fill.cx=_688.x;fill.cy=_688.y;fill.r=fill.r*_689/100;return fill;}var _68c=arguments.length<5?_68a:(end+_68a)/2;return {type:"linear",x1:_688.x,y1:_688.y,x2:_688.x+fill.r*_689*Math.cos(_68c)/100,y2:_688.y+fill.r*_689*Math.sin(_68c)/100,colors:fill.colors};}});});},"dijit/_WidgetBase":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","dojo/has!dojo-bidi?./_BidiMixin","./registry"],function(_68d,_68e,_68f,_690,_691,_692,dom,_693,_694,_695,_696,_697,has,_698,lang,on,_699,_69a,_69b,win,_69c,_69d,_69e){has.add("dijit-legacy-requires",!_698.isAsync);has.add("dojo-bidi",false);if(has("dijit-legacy-requires")){_699(0,function(){var _69f=["dijit/_base/manager"];_68d(_69f);});}var _6a0={};function _6a1(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _6a2(attr){return function(val){_693[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};var _6a3=_692("dijit._WidgetBase",[_69a,_69c],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_6a2("lang"),dir:"",_setDirAttr:_6a2("dir"),"class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){this._set("ownerDocument",val);},attributeMap:{},_blankGif:_690.blankGif||_68d.toUrl("dojo/resources/blank.gif"),_introspect:function(){var ctor=this.constructor;if(!ctor._setterAttrs){var _6a4=ctor.prototype,_6a5=ctor._setterAttrs=[],_6a6=(ctor._onMap={});for(var name in _6a4.attributeMap){_6a5.push(name);}for(name in _6a4){if(/^on/.test(name)){_6a6[name.substring(2).toLowerCase()]=name;}if(/^_set[A-Z](.*)Attr$/.test(name)){name=name.charAt(4).toLowerCase()+name.substr(5,name.length-9);if(!_6a4.attributeMap||!(name in _6a4.attributeMap)){_6a5.push(name);}}}}},postscript:function(_6a7,_6a8){this.create(_6a7,_6a8);},create:function(_6a9,_6aa){this._introspect();this.srcNodeRef=dom.byId(_6aa);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_6a9){this.params=_6a9;lang.mixin(this,_6a9);}this.postMixInProperties();if(!this.id){this.id=_69e.getUniqueId(this.declaredClass.replace(/\./g,"_"));if(this.params){delete this.params.id;}}this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:document);this.ownerDocumentBody=win.body(this.ownerDocument);_69e.add(this);this.buildRendering();var _6ab;if(this.domNode){this._applyAttributes();var _6ac=this.srcNodeRef;if(_6ac&&_6ac.parentNode&&this.domNode!==_6ac){_6ac.parentNode.replaceChild(this.domNode,_6ac);_6ab=true;}this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(_6ab){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var _6ad={};for(var key in this.params||{}){_6ad[key]=this._get(key);}_68e.forEach(this.constructor._setterAttrs,function(key){if(!(key in _6ad)){var val=this._get(key);if(val){this.set(key,val);}}},this);for(key in _6ad){this.set(key,_6ad[key]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");}if(this.baseClass){var _6ae=this.baseClass.split(" ");if(!this.isLeftToRight()){_6ae=_6ae.concat(_68e.map(_6ae,function(name){return name+"Rtl";}));}_694.add(this.domNode,_6ae);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_68e.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_6af){this._beingDestroyed=true;this.destroyDescendants(_6af);this.destroy(_6af);},destroy:function(_6b0){this._beingDestroyed=true;this.uninitialize();function _6b1(w){if(w.destroyRecursive){w.destroyRecursive(_6b0);}else{if(w.destroy){w.destroy(_6b0);}}};_68e.forEach(this._connects,lang.hitch(this,"disconnect"));_68e.forEach(this._supportingWidgets,_6b1);if(this.domNode){_68e.forEach(_69e.findWidgets(this.domNode,this.containerNode),_6b1);}this.destroyRendering(_6b0);_69e.remove(this.id);this._destroyed=true;},destroyRendering:function(_6b2){if(this.bgIframe){this.bgIframe.destroy(_6b2);delete this.bgIframe;}if(this.domNode){if(_6b2){_693.remove(this.domNode,"widgetId");}else{_695.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_6b2){_695.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_6b3){_68e.forEach(this.getChildren(),function(_6b4){if(_6b4.destroyRecursive){_6b4.destroyRecursive(_6b3);}});},uninitialize:function(){return false;},_setStyleAttr:function(_6b5){var _6b6=this.domNode;if(lang.isObject(_6b5)){_697.set(_6b6,_6b5);}else{if(_6b6.style.cssText){_6b6.style.cssText+="; "+_6b5;}else{_6b6.style.cssText=_6b5;}}this._set("style",_6b5);},_attrToDom:function(attr,_6b7,_6b8){_6b8=arguments.length>=3?_6b8:this.attributeMap[attr];_68e.forEach(lang.isArray(_6b8)?_6b8:[_6b8],function(_6b9){var _6ba=this[_6b9.node||_6b9||"domNode"];var type=_6b9.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_6b7)){_6b7=lang.hitch(this,_6b7);}var _6bb=_6b9.attribute?_6b9.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);if(_6ba.tagName){_693.set(_6ba,_6bb,_6b7);}else{_6ba.set(_6bb,_6b7);}break;case "innerText":_6ba.innerHTML="";_6ba.appendChild(this.ownerDocument.createTextNode(_6b7));break;case "innerHTML":_6ba.innerHTML=_6b7;break;case "class":_694.replace(_6ba,_6b7,this[attr]);break;}},this);},get:function(name){var _6bc=this._getAttrNames(name);return this[_6bc.g]?this[_6bc.g]():this._get(name);},set:function(name,_6bd){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _6be=this._getAttrNames(name),_6bf=this[_6be.s];if(lang.isFunction(_6bf)){var _6c0=_6bf.apply(this,Array.prototype.slice.call(arguments,1));}else{var _6c1=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_6c1]&&this[_6c1].tagName,_6c2=tag&&(_6a0[tag]||(_6a0[tag]=_6a1(this[_6c1]))),map=name in this.attributeMap?this.attributeMap[name]:_6be.s in this?this[_6be.s]:((_6c2&&_6be.l in _6c2&&typeof _6bd!="function")||/^aria-|^data-|^role$/.test(name))?_6c1:null;if(map!=null){this._attrToDom(name,_6bd,map);}this._set(name,_6bd);}return _6c0||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_6c3){var _6c4=this[name];this[name]=_6c3;if(this._created&&_6c3!==_6c4){if(this._watchCallbacks){this._watchCallbacks(name,_6c4,_6c3);}this.emit("attrmodified-"+name,{detail:{prevValue:_6c4,newValue:_6c3}});}},_get:function(name){return this[name];},emit:function(type,_6c5,_6c6){_6c5=_6c5||{};if(_6c5.bubbles===undefined){_6c5.bubbles=true;}if(_6c5.cancelable===undefined){_6c5.cancelable=true;}if(!_6c5.detail){_6c5.detail={};}_6c5.detail.widget=this;var ret,_6c7=this["on"+type];if(_6c7){ret=_6c7.apply(this,_6c6?_6c6:[_6c5]);}if(this._started&&!this._beingDestroyed){on.emit(this.domNode,type.toLowerCase(),_6c5);}return ret;},on:function(type,func){var _6c8=this._onMap(type);if(_6c8){return _68f.after(this,_6c8,func,true);}return this.own(on(this.domNode,type,func))[0];},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[typeof type=="string"&&type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_69e.findWidgets(this.containerNode):[];},getParent:function(){return _69e.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_6c9,_6ca){return this.own(_691.connect(obj,_6c9,this,_6ca))[0];},disconnect:function(_6cb){_6cb.remove();},subscribe:function(t,_6cc){return this.own(_69b.subscribe(t,lang.hitch(this,_6cc)))[0];},unsubscribe:function(_6cd){_6cd.remove();},isLeftToRight:function(){return this.dir?(this.dir=="ltr"):_696.isBodyLtr(this.ownerDocument);},isFocusable:function(){return this.focus&&(_697.get(this.domNode,"display")!="none");},placeAt:function(_6ce,_6cf){var _6d0=!_6ce.tagName&&_69e.byId(_6ce);if(_6d0&&_6d0.addChild&&(!_6cf||typeof _6cf==="number")){_6d0.addChild(this,_6cf);}else{var ref=_6d0?(_6d0.containerNode&&!/after|before|replace/.test(_6cf||"")?_6d0.containerNode:_6d0.domNode):dom.byId(_6ce,this.ownerDocument);_695.place(this.domNode,ref,_6cf);if(!this._started&&(this.getParent()||{})._started){this.startup();}}return this;},defer:function(fcn,_6d1){var _6d2=setTimeout(lang.hitch(this,function(){if(!_6d2){return;}_6d2=null;if(!this._destroyed){lang.hitch(this,fcn)();}}),_6d1||0);return {remove:function(){if(_6d2){clearTimeout(_6d2);_6d2=null;}return null;}};}});if(has("dojo-bidi")){_6a3.extend(_69d);}return _6a3;});},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\"\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n></div>\n"}});define("dojox/charting/widget/Chart2D",["dojo/_base/kernel","dojo/_base/lang","./Chart","../Chart2D","../action2d/Highlight","../action2d/Magnify","../action2d/MoveSlice","../action2d/Shake","../action2d/Tooltip"],function(_6d3,lang,_6d4){_6d3.deprecated("dojox.charting.widget.Chart2D","Use dojo.charting.widget.Chart instead and require all other components explicitly","2.0");return lang.setObject("dojox.charting.widget.Chart2D",_6d4);});