/*
	Copyright (c) 2004-2011, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/dtl/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojox/string/tokenize","dojo/_base/json","dojo/dom","dojo/_base/xhr","dojox/string/Builder","dojo/_base/Deferred"],function(_1,_2,_3,_4,_5,_6,_7,_8){_1.experimental("dojox.dtl");var dd=_2.getObject("dojox.dtl",true);dd._base={};dd.TOKEN_BLOCK=-1;dd.TOKEN_VAR=-2;dd.TOKEN_COMMENT=-3;dd.TOKEN_TEXT=3;dd._Context=_2.extend(function(_9){if(_9){_2._mixin(this,_9);if(_9.get){this._getter=_9.get;delete this.get;}}},{push:function(){var _a=this;var _b=_2.delegate(this);_b.pop=function(){return _a;};return _b;},pop:function(){throw new Error("pop() called on empty Context");},get:function(_c,_d){var n=this._normalize;if(this._getter){var _e=this._getter(_c);if(_e!==undefined){return n(_e);}}if(this[_c]!==undefined){return n(this[_c]);}return _d;},_normalize:function(_f){if(_f instanceof Date){_f.year=_f.getFullYear();_f.month=_f.getMonth()+1;_f.day=_f.getDate();_f.date=_f.year+"-"+("0"+_f.month).slice(-2)+"-"+("0"+_f.day).slice(-2);_f.hour=_f.getHours();_f.minute=_f.getMinutes();_f.second=_f.getSeconds();_f.microsecond=_f.getMilliseconds();}return _f;},update:function(_10){var _11=this.push();if(_10){_2._mixin(this,_10);}return _11;}});var _12=/("(?:[^"\\]*(?:\\.[^"\\]*)*)"|'(?:[^'\\]*(?:\\.[^'\\]*)*)'|[^\s]+)/g;var _13=/\s+/g;var _14=function(_15,_16){_15=_15||_13;if(!(_15 instanceof RegExp)){_15=new RegExp(_15,"g");}if(!_15.global){throw new Error("You must use a globally flagged RegExp with split "+_15);}_15.exec("");var _17,_18=[],_19=0,i=0;while((_17=_15.exec(this))){_18.push(this.slice(_19,_15.lastIndex-_17[0].length));_19=_15.lastIndex;if(_16&&(++i>_16-1)){break;}}_18.push(this.slice(_19));return _18;};dd.Token=function(_1a,_1b){this.token_type=_1a;this.contents=new String(_2.trim(_1b));this.contents.split=_14;this.split=function(){return String.prototype.split.apply(this.contents,arguments);};};dd.Token.prototype.split_contents=function(_1c){var bit,_1d=[],i=0;_1c=_1c||999;while(i++<_1c&&(bit=_12.exec(this.contents))){bit=bit[0];if(bit.charAt(0)=="\""&&bit.slice(-1)=="\""){_1d.push("\""+bit.slice(1,-1).replace("\\\"","\"").replace("\\\\","\\")+"\"");}else{if(bit.charAt(0)=="'"&&bit.slice(-1)=="'"){_1d.push("'"+bit.slice(1,-1).replace("\\'","'").replace("\\\\","\\")+"'");}else{_1d.push(bit);}}}return _1d;};var ddt=dd.text={_get:function(_1e,_1f,_20){var _21=dd.register.get(_1e,_1f.toLowerCase(),_20);if(!_21){if(!_20){throw new Error("No tag found for "+_1f);}return null;}var fn=_21[1];var _22=_21[2];var _23;if(fn.indexOf(":")!=-1){_23=fn.split(":");fn=_23.pop();}var mod=_22;if(/\./.test(_22)){_22=_22.replace(/\./g,"/");}require([_22],function(){});var _24=_2.getObject(mod);return _24[fn||_1f]||_24[_1f+"_"]||_24[fn+"_"];},getTag:function(_25,_26){return ddt._get("tag",_25,_26);},getFilter:function(_27,_28){return ddt._get("filter",_27,_28);},getTemplate:function(_29){return new dd.Template(ddt.getTemplateString(_29));},getTemplateString:function(_2a){return _6._getText(_2a.toString())||"";},_resolveLazy:function(_2b,_2c,_2d){if(_2c){if(_2d){return _2d.fromJson(_6._getText(_2b))||{};}else{return dd.text.getTemplateString(_2b);}}else{return _6.get({handleAs:_2d?"json":"text",url:_2b});}},_resolveTemplateArg:function(arg,_2e){if(ddt._isTemplate(arg)){if(!_2e){var d=new _8();d.callback(arg);return d;}return arg;}return ddt._resolveLazy(arg,_2e);},_isTemplate:function(arg){return (arg===undefined)||(typeof arg=="string"&&(arg.match(/^\s*[<{]/)||arg.indexOf(" ")!=-1));},_resolveContextArg:function(arg,_2f){if(arg.constructor==Object){if(!_2f){var d=new _8;d.callback(arg);return d;}return arg;}return ddt._resolveLazy(arg,_2f,true);},_re:/(?:\{\{\s*(.+?)\s*\}\}|\{%\s*(load\s*)?(.+?)\s*%\})/g,tokenize:function(str){return _3(str,ddt._re,ddt._parseDelims);},_parseDelims:function(_30,_31,tag){if(_30){return [dd.TOKEN_VAR,_30];}else{if(_31){var _32=_2.trim(tag).split(/\s+/g);for(var i=0,_33;_33=_32[i];i++){if(/\./.test(_33)){_33=_33.replace(/\./g,"/");}require([_33]);}}else{return [dd.TOKEN_BLOCK,tag];}}}};dd.Template=_2.extend(function(_34,_35){var str=_35?_34:ddt._resolveTemplateArg(_34,true)||"";var _36=ddt.tokenize(str);var _37=new dd._Parser(_36);this.nodelist=_37.parse();},{update:function(_38,_39){return ddt._resolveContextArg(_39).addCallback(this,function(_3a){var _3b=this.render(new dd._Context(_3a));if(_38.forEach){_38.forEach(function(_3c){_3c.innerHTML=_3b;});}else{_5.byId(_38).innerHTML=_3b;}return this;});},render:function(_3d,_3e){_3e=_3e||this.getBuffer();_3d=_3d||new dd._Context({});return this.nodelist.render(_3d,_3e)+"";},getBuffer:function(){return new _7();}});var _3f=/\{\{\s*(.+?)\s*\}\}/g;dd.quickFilter=function(str){if(!str){return new dd._NodeList();}if(str.indexOf("{%")==-1){return new dd._QuickNodeList(_3(str,_3f,function(_40){return new dd._Filter(_40);}));}};dd._QuickNodeList=_2.extend(function(_41){this.contents=_41;},{render:function(_42,_43){for(var i=0,l=this.contents.length;i<l;i++){if(this.contents[i].resolve){_43=_43.concat(this.contents[i].resolve(_42));}else{_43=_43.concat(this.contents[i]);}}return _43;},dummyRender:function(_44){return this.render(_44,dd.Template.prototype.getBuffer()).toString();},clone:function(_45){return this;}});dd._Filter=_2.extend(function(_46){if(!_46){throw new Error("Filter must be called with variable name");}this.contents=_46;var _47=this._cache[_46];if(_47){this.key=_47[0];this.filters=_47[1];}else{this.filters=[];_3(_46,this._re,this._tokenize,this);this._cache[_46]=[this.key,this.filters];}},{_cache:{},_re:/(?:^_\("([^\\"]*(?:\\.[^\\"])*)"\)|^"([^\\"]*(?:\\.[^\\"]*)*)"|^([a-zA-Z0-9_.]+)|\|(\w+)(?::(?:_\("([^\\"]*(?:\\.[^\\"])*)"\)|"([^\\"]*(?:\\.[^\\"]*)*)"|([a-zA-Z0-9_.]+)|'([^\\']*(?:\\.[^\\']*)*)'))?|^'([^\\']*(?:\\.[^\\']*)*)')/g,_values:{0:"\"",1:"\"",2:"",8:"\""},_args:{4:"\"",5:"\"",6:"",7:"'"},_tokenize:function(){var pos,arg;for(var i=0,has=[];i<arguments.length;i++){has[i]=(arguments[i]!==undefined&&typeof arguments[i]=="string"&&arguments[i]);}if(!this.key){for(pos in this._values){if(has[pos]){this.key=this._values[pos]+arguments[pos]+this._values[pos];break;}}}else{for(pos in this._args){if(has[pos]){var _48=arguments[pos];if(this._args[pos]=="'"){_48=_48.replace(/\\'/g,"'");}else{if(this._args[pos]=="\""){_48=_48.replace(/\\"/g,"\"");}}arg=[!this._args[pos],_48];break;}}var fn=ddt.getFilter(arguments[3]);if(!_2.isFunction(fn)){throw new Error(arguments[3]+" is not registered as a filter");}this.filters.push([fn,arg]);}},getExpression:function(){return this.contents;},resolve:function(_49){if(this.key===undefined){return "";}var str=this.resolvePath(this.key,_49);for(var i=0,_4a;_4a=this.filters[i];i++){if(_4a[1]){if(_4a[1][0]){str=_4a[0](str,this.resolvePath(_4a[1][1],_49));}else{str=_4a[0](str,_4a[1][1]);}}else{str=_4a[0](str);}}return str;},resolvePath:function(_4b,_4c){var _4d,_4e;var _4f=_4b.charAt(0);var _50=_4b.slice(-1);if(!isNaN(parseInt(_4f))){_4d=(_4b.indexOf(".")==-1)?parseInt(_4b):parseFloat(_4b);}else{if(_4f=="\""&&_4f==_50){_4d=_4b.slice(1,-1);}else{if(_4b=="true"){return true;}if(_4b=="false"){return false;}if(_4b=="null"||_4b=="None"){return null;}_4e=_4b.split(".");_4d=_4c.get(_4e[0]);if(_2.isFunction(_4d)){var _51=_4c.getThis&&_4c.getThis();if(_4d.alters_data){_4d="";}else{if(_51){_4d=_4d.call(_51);}else{_4d="";}}}for(var i=1;i<_4e.length;i++){var _52=_4e[i];if(_4d){var _53=_4d;if(_2.isObject(_4d)&&_52=="items"&&_4d[_52]===undefined){var _54=[];for(var key in _4d){_54.push([key,_4d[key]]);}_4d=_54;continue;}if(_4d.get&&_2.isFunction(_4d.get)&&_4d.get.safe){_4d=_4d.get(_52);}else{if(_4d[_52]===undefined){_4d=_4d[_52];break;}else{_4d=_4d[_52];}}if(_2.isFunction(_4d)){if(_4d.alters_data){_4d="";}else{_4d=_4d.call(_53);}}else{if(_4d instanceof Date){_4d=dd._Context.prototype._normalize(_4d);}}}else{return "";}}}}return _4d;}});dd._TextNode=dd._Node=_2.extend(function(obj){this.contents=obj;},{set:function(_55){this.contents=_55;return this;},render:function(_56,_57){return _57.concat(this.contents);},isEmpty:function(){return !_2.trim(this.contents);},clone:function(){return this;}});dd._NodeList=_2.extend(function(_58){this.contents=_58||[];this.last="";},{push:function(_59){this.contents.push(_59);return this;},concat:function(_5a){this.contents=this.contents.concat(_5a);return this;},render:function(_5b,_5c){for(var i=0;i<this.contents.length;i++){_5c=this.contents[i].render(_5b,_5c);if(!_5c){throw new Error("Template must return buffer");}}return _5c;},dummyRender:function(_5d){return this.render(_5d,dd.Template.prototype.getBuffer()).toString();},unrender:function(){return arguments[1];},clone:function(){return this;},rtrim:function(){while(1){i=this.contents.length-1;if(this.contents[i] instanceof dd._TextNode&&this.contents[i].isEmpty()){this.contents.pop();}else{break;}}return this;}});dd._VarNode=_2.extend(function(str){this.contents=new dd._Filter(str);},{render:function(_5e,_5f){var str=this.contents.resolve(_5e);if(!str.safe){str=dd._base.escape(""+str);}return _5f.concat(str);}});dd._noOpNode=new function(){this.render=this.unrender=function(){return arguments[1];};this.clone=function(){return this;};};dd._Parser=_2.extend(function(_60){this.contents=_60;},{i:0,parse:function(_61){var _62={},_63;_61=_61||[];for(var i=0;i<_61.length;i++){_62[_61[i]]=true;}var _64=new dd._NodeList();while(this.i<this.contents.length){_63=this.contents[this.i++];if(typeof _63=="string"){_64.push(new dd._TextNode(_63));}else{var _65=_63[0];var _66=_63[1];if(_65==dd.TOKEN_VAR){_64.push(new dd._VarNode(_66));}else{if(_65==dd.TOKEN_BLOCK){if(_62[_66]){--this.i;return _64;}var cmd=_66.split(/\s+/g);if(cmd.length){cmd=cmd[0];var fn=ddt.getTag(cmd);if(fn){_64.push(fn(this,new dd.Token(_65,_66)));}}}}}}if(_61.length){throw new Error("Could not find closing tag(s): "+_61.toString());}this.contents.length=0;return _64;},next_token:function(){var _67=this.contents[this.i++];return new dd.Token(_67[0],_67[1]);},delete_first_token:function(){this.i++;},skip_past:function(_68){while(this.i<this.contents.length){var _69=this.contents[this.i++];if(_69[0]==dd.TOKEN_BLOCK&&_69[1]==_68){return;}}throw new Error("Unclosed tag found when looking for "+_68);},create_variable_node:function(_6a){return new dd._VarNode(_6a);},create_text_node:function(_6b){return new dd._TextNode(_6b||"");},getTemplate:function(_6c){return new dd.Template(_6c);}});dd.register={_registry:{attributes:[],tags:[],filters:[]},get:function(_6d,_6e){var _6f=dd.register._registry[_6d+"s"];for(var i=0,_70;_70=_6f[i];i++){if(typeof _70[0]=="string"){if(_70[0]==_6e){return _70;}}else{if(_6e.match(_70[0])){return _70;}}}},getAttributeTags:function(){var _71=[];var _72=dd.register._registry.attributes;for(var i=0,_73;_73=_72[i];i++){if(_73.length==3){_71.push(_73);}else{var fn=_2.getObject(_73[1]);if(fn&&_2.isFunction(fn)){_73.push(fn);_71.push(_73);}}}return _71;},_any:function(_74,_75,_76){for(var _77 in _76){for(var i=0,fn;fn=_76[_77][i];i++){var key=fn;if(_2.isArray(fn)){key=fn[0];fn=fn[1];}if(typeof key=="string"){if(key.substr(0,5)=="attr:"){var _78=fn;if(_78.substr(0,5)=="attr:"){_78=_78.slice(5);}dd.register._registry.attributes.push([_78.toLowerCase(),_75+"."+_77+"."+_78]);}key=key.toLowerCase();}dd.register._registry[_74].push([key,fn,_75+"."+_77]);}}},tags:function(_79,_7a){dd.register._any("tags",_79,_7a);},filters:function(_7b,_7c){dd.register._any("filters",_7b,_7c);}};var _7d=/&/g;var _7e=/</g;var _7f=/>/g;var _80=/'/g;var _81=/"/g;dd._base.escape=function(_82){return dd.mark_safe(_82.replace(_7d,"&amp;").replace(_7e,"&lt;").replace(_7f,"&gt;").replace(_81,"&quot;").replace(_80,"&#39;"));};dd._base.safe=function(_83){if(typeof _83=="string"){_83=new String(_83);}if(typeof _83=="object"){_83.safe=true;}return _83;};dd.mark_safe=dd._base.safe;dd.register.tags("dojox.dtl.tag",{"date":["now"],"logic":["if","for","ifequal","ifnotequal"],"loader":["extends","block","include","load","ssi"],"misc":["comment","debug","filter","firstof","spaceless","templatetag","widthratio","with"],"loop":["cycle","ifchanged","regroup"]});dd.register.filters("dojox.dtl.filter",{"dates":["date","time","timesince","timeuntil"],"htmlstrings":["linebreaks","linebreaksbr","removetags","striptags"],"integers":["add","get_digit"],"lists":["dictsort","dictsortreversed","first","join","length","length_is","random","slice","unordered_list"],"logic":["default","default_if_none","divisibleby","yesno"],"misc":["filesizeformat","pluralize","phone2numeric","pprint"],"strings":["addslashes","capfirst","center","cut","fix_ampersands","floatformat","iriencode","linenumbers","ljust","lower","make_list","rjust","slugify","stringformat","title","truncatewords","truncatewords_html","upper","urlencode","urlize","urlizetrunc","wordcount","wordwrap"]});dd.register.filters("dojox.dtl",{"_base":["escape","safe"]});return dd;});},"dojox/dtl/utils/date":function(){define(["dojo/_base/lang","dojox/date/php","../_base"],function(_84,ddp,dd){var _85=_84.getObject("utils.date",true,dd);_85.DateFormat=ddp.DateFormat;_84.extend(_85.DateFormat,ddp.DateFormat.prototype,{f:function(){return (!this.date.getMinutes())?this.g():this.g()+":"+this.i();},N:function(){return _85._months_ap[this.date.getMonth()];},P:function(){if(!this.date.getMinutes()&&!this.date.getHours()){return "midnight";}if(!this.date.getMinutes()&&this.date.getHours()==12){return "noon";}return this.f()+" "+this.a();}});_84.mixin(dojox.dtl.utils.date,{format:function(_86,_87){var df=new dojox.dtl.utils.date.DateFormat(_87);return df.format(_86);},timesince:function(d,now){if(!(d instanceof Date)){d=new Date(d.year,d.month,d.day);}if(!now){now=new Date();}var _88=Math.abs(now.getTime()-d.getTime());for(var i=0,_89;_89=dojox.dtl.utils.date._chunks[i];i++){var _8a=Math.floor(_88/_89[0]);if(_8a){break;}}return _8a+" "+_89[1](_8a);},_chunks:[[60*60*24*365*1000,function(n){return (n==1)?"year":"years";}],[60*60*24*30*1000,function(n){return (n==1)?"month":"months";}],[60*60*24*7*1000,function(n){return (n==1)?"week":"weeks";}],[60*60*24*1000,function(n){return (n==1)?"day":"days";}],[60*60*1000,function(n){return (n==1)?"hour":"hours";}],[60*1000,function(n){return (n==1)?"minute":"minutes";}]],_months_ap:["Jan.","Feb.","March","April","May","June","July","Aug.","Sept.","Oct.","Nov.","Dec."]});return _85;});},"dojox/dtl/tag/date":function(){define(["dojo/_base/lang","../_base","../utils/date"],function(_8b,dd,_8c){var _8d=_8b.getObject("tag.date",true,dd);_8d.NowNode=function(_8e,_8f){this._format=_8e;this.format=new _8c.DateFormat(_8e);this.contents=_8f;};_8b.extend(_8d.NowNode,{render:function(_90,_91){this.contents.set(this.format.format(new Date()));return this.contents.render(_90,_91);},unrender:function(_92,_93){return this.contents.unrender(_92,_93);},clone:function(_94){return new this.constructor(this._format,this.contents.clone(_94));}});_8d.now=function(_95,_96){var _97=_96.split_contents();if(_97.length!=2){throw new Error("'now' statement takes one argument");}return new _8d.NowNode(_97[1].slice(1,-1),_95.create_text_node());};return _8d;});},"dojox/dtl/tag/loader":function(){define(["dojo/_base/lang","../_base","dojo/_base/array","dojo/_base/connect"],function(_98,dd,_99,_9a){var _9b=_98.getObject("tag.loader",true,dd);_9b.BlockNode=_98.extend(function(_9c,_9d){this.name=_9c;this.nodelist=_9d;},{"super":function(){if(this.parent){var _9e=this.parent.nodelist.dummyRender(this.context,null,true);if(typeof _9e=="string"){_9e=new String(_9e);}_9e.safe=true;return _9e;}return "";},render:function(_9f,_a0){var _a1=this.name;var _a2=this.nodelist;var _a3;if(_a0.blocks){var _a4=_a0.blocks[_a1];if(_a4){_a3=_a4.parent;_a2=_a4.nodelist;_a4.used=true;}}this.rendered=_a2;_9f=_9f.push();this.context=_9f;this.parent=null;if(_a2!=this.nodelist){this.parent=this;}_9f.block=this;if(_a0.getParent){var _a5=_a0.getParent();var _a6=_9a.connect(_a0,"onSetParent",function(_a7,up,_a8){if(up&&_a8){_a0.setParent(_a5);}});}_a0=_a2.render(_9f,_a0,this);_a6&&_9a.disconnect(_a6);_9f=_9f.pop();return _a0;},unrender:function(_a9,_aa){return this.rendered.unrender(_a9,_aa);},clone:function(_ab){return new this.constructor(this.name,this.nodelist.clone(_ab));},toString:function(){return "dojox.dtl.tag.loader.BlockNode";}});_9b.ExtendsNode=_98.extend(function(_ac,_ad,_ae,_af,key){this.getTemplate=_ac;this.nodelist=_ad;this.shared=_ae;this.parent=_af;this.key=key;},{parents:{},getParent:function(_b0){var _b1=this.parent;if(!_b1){var _b2;_b1=this.parent=_b0.get(this.key,false);if(!_b1){throw new Error("extends tag used a variable that did not resolve");}if(typeof _b1=="object"){var url=_b1.url||_b1.templatePath;if(_b1.shared){this.shared=true;}if(url){_b1=this.parent=url.toString();}else{if(_b1.templateString){_b2=_b1.templateString;_b1=this.parent=" ";}else{_b1=this.parent=this.parent.toString();}}}if(_b1&&_b1.indexOf("shared:")===0){this.shared=true;_b1=this.parent=_b1.substring(7,_b1.length);}}if(!_b1){throw new Error("Invalid template name in 'extends' tag.");}if(_b1.render){return _b1;}if(this.parents[_b1]){return this.parents[_b1];}this.parent=this.getTemplate(_b2||dojox.dtl.text.getTemplateString(_b1));if(this.shared){this.parents[_b1]=this.parent;}return this.parent;},render:function(_b3,_b4){var _b5=this.getParent(_b3);_b5.blocks=_b5.blocks||{};_b4.blocks=_b4.blocks||{};for(var i=0,_b6;_b6=this.nodelist.contents[i];i++){if(_b6 instanceof dojox.dtl.tag.loader.BlockNode){var old=_b5.blocks[_b6.name];if(old&&old.nodelist!=_b6.nodelist){_b4=old.nodelist.unrender(_b3,_b4);}_b5.blocks[_b6.name]=_b4.blocks[_b6.name]={shared:this.shared,nodelist:_b6.nodelist,used:false};}}this.rendered=_b5;return _b5.nodelist.render(_b3,_b4,this);},unrender:function(_b7,_b8){return this.rendered.unrender(_b7,_b8,this);},toString:function(){return "dojox.dtl.block.ExtendsNode";}});_9b.IncludeNode=_98.extend(function(_b9,_ba,_bb,_bc,_bd){this._path=_b9;this.constant=_ba;this.path=(_ba)?_b9:new dd._Filter(_b9);this.getTemplate=_bb;this.text=_bc;this.parsed=(arguments.length==5)?_bd:true;},{_cache:[{},{}],render:function(_be,_bf){var _c0=((this.constant)?this.path:this.path.resolve(_be)).toString();var _c1=Number(this.parsed);var _c2=false;if(_c0!=this.last){_c2=true;if(this.last){_bf=this.unrender(_be,_bf);}this.last=_c0;}var _c3=this._cache[_c1];if(_c1){if(!_c3[_c0]){_c3[_c0]=dd.text._resolveTemplateArg(_c0,true);}if(_c2){var _c4=this.getTemplate(_c3[_c0]);this.rendered=_c4.nodelist;}return this.rendered.render(_be,_bf,this);}else{if(this.text instanceof dd._TextNode){if(_c2){this.rendered=this.text;this.rendered.set(dd.text._resolveTemplateArg(_c0,true));}return this.rendered.render(_be,_bf);}else{if(!_c3[_c0]){var _c5=[];var div=document.createElement("div");div.innerHTML=dd.text._resolveTemplateArg(_c0,true);var _c6=div.childNodes;while(_c6.length){var _c7=div.removeChild(_c6[0]);_c5.push(_c7);}_c3[_c0]=_c5;}if(_c2){this.nodelist=[];var _c8=true;for(var i=0,_c9;_c9=_c3[_c0][i];i++){this.nodelist.push(_c9.cloneNode(true));}}for(var i=0,_ca;_ca=this.nodelist[i];i++){_bf=_bf.concat(_ca);}}}return _bf;},unrender:function(_cb,_cc){if(this.rendered){_cc=this.rendered.unrender(_cb,_cc);}if(this.nodelist){for(var i=0,_cd;_cd=this.nodelist[i];i++){_cc=_cc.remove(_cd);}}return _cc;},clone:function(_ce){return new this.constructor(this._path,this.constant,this.getTemplate,this.text.clone(_ce),this.parsed);}});_98.mixin(_9b,{block:function(_cf,_d0){var _d1=_d0.contents.split();var _d2=_d1[1];_cf._blocks=_cf._blocks||{};_cf._blocks[_d2]=_cf._blocks[_d2]||[];_cf._blocks[_d2].push(_d2);var _d3=_cf.parse(["endblock","endblock "+_d2]).rtrim();_cf.next_token();return new dojox.dtl.tag.loader.BlockNode(_d2,_d3);},extends_:function(_d4,_d5){var _d6=_d5.contents.split();var _d7=false;var _d8=null;var key=null;if(_d6[1].charAt(0)=="\""||_d6[1].charAt(0)=="'"){_d8=_d6[1].substring(1,_d6[1].length-1);}else{key=_d6[1];}if(_d8&&_d8.indexOf("shared:")==0){_d7=true;_d8=_d8.substring(7,_d8.length);}var _d9=_d4.parse();return new dojox.dtl.tag.loader.ExtendsNode(_d4.getTemplate,_d9,_d7,_d8,key);},include:function(_da,_db){var _dc=_db.contents.split();if(_dc.length!=2){throw new Error(_dc[0]+" tag takes one argument: the name of the template to be included");}var _dd=_dc[1];var _de=false;if((_dd.charAt(0)=="\""||_dd.slice(-1)=="'")&&_dd.charAt(0)==_dd.slice(-1)){_dd=_dd.slice(1,-1);_de=true;}return new _9b.IncludeNode(_dd,_de,_da.getTemplate,_da.create_text_node());},ssi:function(_df,_e0){var _e1=_e0.contents.split();var _e2=false;if(_e1.length==3){_e2=(_e1.pop()=="parsed");if(!_e2){throw new Error("Second (optional) argument to ssi tag must be 'parsed'");}}var _e3=_9b.include(_df,new dd.Token(_e0.token_type,_e1.join(" ")));_e3.parsed=_e2;return _e3;}});return _9b;});},"dojox/dtl/Context":function(){define(["dojo/_base/lang","./_base"],function(_e4,dd){return dd.Context=_e4.extend(function(_e5){this._this={};dd._Context.call(this,_e5);},dd._Context.prototype,{getKeys:function(){var _e6=[];for(var key in this){if(this.hasOwnProperty(key)&&key!="_this"){_e6.push(key);}}return _e6;},extend:function(obj){return _e4.delegate(this,obj);},filter:function(_e7){var _e8=new dd.Context();var _e9=[];var i,arg;if(_e7 instanceof dd.Context){_e9=_e7.getKeys();}else{if(typeof _e7=="object"){for(var key in _e7){_e9.push(key);}}else{for(i=0;arg=arguments[i];i++){if(typeof arg=="string"){_e9.push(arg);}}}}for(i=0,key;key=_e9[i];i++){_e8[key]=this[key];}return _e8;},setThis:function(_ea){this._this=_ea;},getThis:function(){return this._this;},hasKey:function(key){if(this._getter){var got=this._getter(key);if(typeof got!="undefined"){return true;}}if(typeof this[key]!="undefined"){return true;}return false;}});});},"dojox/string/tokenize":function(){define(["dojo/_base/lang","dojo/_base/sniff"],function(_eb,has){var _ec=_eb.getObject("dojox.string",true).tokenize;_ec=function(str,re,_ed,_ee){var _ef=[];var _f0,_f1,_f2=0;while(_f0=re.exec(str)){_f1=str.slice(_f2,re.lastIndex-_f0[0].length);if(_f1.length){_ef.push(_f1);}if(_ed){if(has("opera")){var _f3=_f0.slice(0);while(_f3.length<_f0.length){_f3.push(null);}_f0=_f3;}var _f4=_ed.apply(_ee,_f0.slice(1).concat(_ef.length));if(typeof _f4!="undefined"){_ef.push(_f4);}}_f2=re.lastIndex;}_f1=str.slice(_f2);if(_f1.length){_ef.push(_f1);}return _ef;};return _ec;});},"dojox/dtl/tag/misc":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/connect","../_base"],function(_f5,_f6,_f7,dd){var _f8=_f5.getObject("tag.misc",true,dd);_f8.DebugNode=_f5.extend(function(_f9){this.text=_f9;},{render:function(_fa,_fb){var _fc=_fa.getKeys();var _fd=[];var _fe={};for(var i=0,key;key=_fc[i];i++){_fe[key]=_fa[key];_fd+="["+key+": "+typeof _fa[key]+"]\n";}return this.text.set(_fd).render(_fa,_fb,this);},unrender:function(_ff,_100){return _100;},clone:function(_101){return new this.constructor(this.text.clone(_101));},toString:function(){return "ddtm.DebugNode";}});_f8.FilterNode=_f5.extend(function(_102,_103){this._varnode=_102;this._nodelist=_103;},{render:function(_104,_105){var _106=this._nodelist.render(_104,new dojox.string.Builder());_104=_104.update({"var":_106.toString()});var _107=this._varnode.render(_104,_105);_104=_104.pop();return _105;},unrender:function(_108,_109){return _109;},clone:function(_10a){return new this.constructor(this._expression,this._nodelist.clone(_10a));}});_f8.FirstOfNode=_f5.extend(function(vars,text){this._vars=vars;this.vars=_f6.map(vars,function(item){return new dojox.dtl._Filter(item);});this.contents=text;},{render:function(_10b,_10c){for(var i=0,item;item=this.vars[i];i++){var _10d=item.resolve(_10b);if(typeof _10d!="undefined"){if(_10d===null){_10d="null";}this.contents.set(_10d);return this.contents.render(_10b,_10c);}}return this.contents.unrender(_10b,_10c);},unrender:function(_10e,_10f){return this.contents.unrender(_10e,_10f);},clone:function(_110){return new this.constructor(this._vars,this.contents.clone(_110));}});_f8.SpacelessNode=_f5.extend(function(_111,text){this.nodelist=_111;this.contents=text;},{render:function(_112,_113){if(_113.getParent){var _114=[_f7.connect(_113,"onAddNodeComplete",this,"_watch"),_f7.connect(_113,"onSetParent",this,"_watchParent")];_113=this.nodelist.render(_112,_113);_f7.disconnect(_114[0]);_f7.disconnect(_114[1]);}else{var _115=this.nodelist.dummyRender(_112);this.contents.set(_115.replace(/>\s+</g,"><"));_113=this.contents.render(_112,_113);}return _113;},unrender:function(_116,_117){return this.nodelist.unrender(_116,_117);},clone:function(_118){return new this.constructor(this.nodelist.clone(_118),this.contents.clone(_118));},_isEmpty:function(node){return (node.nodeType==3&&!node.data.match(/[^\s\n]/));},_watch:function(node){if(this._isEmpty(node)){var _119=false;if(node.parentNode.firstChild==node){node.parentNode.removeChild(node);}}else{var _11a=node.parentNode.childNodes;if(node.nodeType==1&&_11a.length>2){for(var i=2,_11b;_11b=_11a[i];i++){if(_11a[i-2].nodeType==1&&this._isEmpty(_11a[i-1])){node.parentNode.removeChild(_11a[i-1]);return;}}}}},_watchParent:function(node){var _11c=node.childNodes;if(_11c.length){while(node.childNodes.length){var last=node.childNodes[node.childNodes.length-1];if(!this._isEmpty(last)){return;}node.removeChild(last);}}}});_f8.TemplateTagNode=_f5.extend(function(tag,text){this.tag=tag;this.contents=text;},{mapping:{openblock:"{%",closeblock:"%}",openvariable:"{{",closevariable:"}}",openbrace:"{",closebrace:"}",opencomment:"{#",closecomment:"#}"},render:function(_11d,_11e){this.contents.set(this.mapping[this.tag]);return this.contents.render(_11d,_11e);},unrender:function(_11f,_120){return this.contents.unrender(_11f,_120);},clone:function(_121){return new this.constructor(this.tag,this.contents.clone(_121));}});_f8.WidthRatioNode=_f5.extend(function(_122,max,_123,text){this.current=new dd._Filter(_122);this.max=new dd._Filter(max);this.width=_123;this.contents=text;},{render:function(_124,_125){var _126=+this.current.resolve(_124);var max=+this.max.resolve(_124);if(typeof _126!="number"||typeof max!="number"||!max){this.contents.set("");}else{this.contents.set(""+Math.round((_126/max)*this.width));}return this.contents.render(_124,_125);},unrender:function(_127,_128){return this.contents.unrender(_127,_128);},clone:function(_129){return new this.constructor(this.current.getExpression(),this.max.getExpression(),this.width,this.contents.clone(_129));}});_f8.WithNode=_f5.extend(function(_12a,_12b,_12c){this.target=new dd._Filter(_12a);this.alias=_12b;this.nodelist=_12c;},{render:function(_12d,_12e){var _12f=this.target.resolve(_12d);_12d=_12d.push();_12d[this.alias]=_12f;_12e=this.nodelist.render(_12d,_12e);_12d=_12d.pop();return _12e;},unrender:function(_130,_131){return _131;},clone:function(_132){return new this.constructor(this.target.getExpression(),this.alias,this.nodelist.clone(_132));}});_f5.mixin(_f8,{comment:function(_133,_134){_133.skip_past("endcomment");return dd._noOpNode;},debug:function(_135,_136){return new _f8.DebugNode(_135.create_text_node());},filter:function(_137,_138){var rest=_138.contents.split(null,1)[1];var _139=_137.create_variable_node("var|"+rest);var _13a=_137.parse(["endfilter"]);_137.next_token();return new _f8.FilterNode(_139,_13a);},firstof:function(_13b,_13c){var _13d=_13c.split_contents().slice(1);if(!_13d.length){throw new Error("'firstof' statement requires at least one argument");}return new _f8.FirstOfNode(_13d,_13b.create_text_node());},spaceless:function(_13e,_13f){var _140=_13e.parse(["endspaceless"]);_13e.delete_first_token();return new _f8.SpacelessNode(_140,_13e.create_text_node());},templatetag:function(_141,_142){var _143=_142.contents.split();if(_143.length!=2){throw new Error("'templatetag' statement takes one argument");}var tag=_143[1];var _144=_f8.TemplateTagNode.prototype.mapping;if(!_144[tag]){var keys=[];for(var key in _144){keys.push(key);}throw new Error("Invalid templatetag argument: '"+tag+"'. Must be one of: "+keys.join(", "));}return new _f8.TemplateTagNode(tag,_141.create_text_node());},widthratio:function(_145,_146){var _147=_146.contents.split();if(_147.length!=4){throw new Error("widthratio takes three arguments");}var _148=+_147[3];if(typeof _148!="number"){throw new Error("widthratio final argument must be an integer");}return new _f8.WidthRatioNode(_147[1],_147[2],_148,_145.create_text_node());},with_:function(_149,_14a){var _14b=_14a.split_contents();if(_14b.length!=4||_14b[2]!="as"){throw new Error("do_width expected format as 'with value as name'");}var _14c=_149.parse(["endwith"]);_149.next_token();return new _f8.WithNode(_14b[1],_14b[3],_14c);}});return _f8;});},"dojox/string/Builder":function(){define(["dojo/_base/lang"],function(lang){var _14d=lang.getObject("string",true,dojox).Builder=function(str){var b="";this.length=0;this.append=function(s){if(arguments.length>1){var tmp="",l=arguments.length;switch(l){case 9:tmp=""+arguments[8]+tmp;case 8:tmp=""+arguments[7]+tmp;case 7:tmp=""+arguments[6]+tmp;case 6:tmp=""+arguments[5]+tmp;case 5:tmp=""+arguments[4]+tmp;case 4:tmp=""+arguments[3]+tmp;case 3:tmp=""+arguments[2]+tmp;case 2:b+=""+arguments[0]+arguments[1]+tmp;break;default:var i=0;while(i<arguments.length){tmp+=arguments[i++];}b+=tmp;}}else{b+=s;}this.length=b.length;return this;};this.concat=function(s){return this.append.apply(this,arguments);};this.appendArray=function(_14e){return this.append.apply(this,_14e);};this.clear=function(){b="";this.length=0;return this;};this.replace=function(_14f,_150){b=b.replace(_14f,_150);this.length=b.length;return this;};this.remove=function(_151,len){if(len===undefined){len=b.length;}if(len==0){return this;}b=b.substr(0,_151)+b.substr(_151+len);this.length=b.length;return this;};this.insert=function(_152,str){if(_152==0){b=str+b;}else{b=b.slice(0,_152)+str+b.slice(_152);}this.length=b.length;return this;};this.toString=function(){return b;};if(str){this.append(str);}};return _14d;});},"dojox/dtl/ext-dojo/NodeList":function(){define(["dojo/_base/lang","dojo/query","../_base"],function(lang,_153,dd){var nl=lang.getObject("dojox.dtl.ext-dojo.NodeList",true);var _154=_153.NodeList;lang.extend(_154,{dtl:function(_155,_156){var d=dd,self=this;var _157=function(_158,_159){var _15a=_158.render(new d._Context(_159));self.forEach(function(node){node.innerHTML=_15a;});};d.text._resolveTemplateArg(_155).addCallback(function(_15b){_155=new d.Template(_15b);d.text._resolveContextArg(_156).addCallback(function(_15c){_157(_155,_15c);});});return this;}});return _154;});},"dojox/dtl/tag/logic":function(){define(["dojo/_base/lang","../_base"],function(lang,dd){var ddtl=lang.getObject("tag.logic",true,dd);var ddt=dd.text;ddtl.IfNode=lang.extend(function(_15d,_15e,_15f,type){this.bools=_15d;this.trues=_15e;this.falses=_15f;this.type=type;},{render:function(_160,_161){var i,bool,_162,_163,_164;if(this.type=="or"){for(i=0;bool=this.bools[i];i++){_162=bool[0];_163=bool[1];_164=_163.resolve(_160);if((_164&&!_162)||(_162&&!_164)){if(this.falses){_161=this.falses.unrender(_160,_161);}return (this.trues)?this.trues.render(_160,_161,this):_161;}}if(this.trues){_161=this.trues.unrender(_160,_161);}return (this.falses)?this.falses.render(_160,_161,this):_161;}else{for(i=0;bool=this.bools[i];i++){_162=bool[0];_163=bool[1];_164=_163.resolve(_160);if(_164==_162){if(this.trues){_161=this.trues.unrender(_160,_161);}return (this.falses)?this.falses.render(_160,_161,this):_161;}}if(this.falses){_161=this.falses.unrender(_160,_161);}return (this.trues)?this.trues.render(_160,_161,this):_161;}return _161;},unrender:function(_165,_166){_166=(this.trues)?this.trues.unrender(_165,_166):_166;_166=(this.falses)?this.falses.unrender(_165,_166):_166;return _166;},clone:function(_167){var _168=(this.trues)?this.trues.clone(_167):null;var _169=(this.falses)?this.falses.clone(_167):null;return new this.constructor(this.bools,_168,_169,this.type);}});ddtl.IfEqualNode=lang.extend(function(var1,var2,_16a,_16b,_16c){this.var1=new dd._Filter(var1);this.var2=new dd._Filter(var2);this.trues=_16a;this.falses=_16b;this.negate=_16c;},{render:function(_16d,_16e){var var1=this.var1.resolve(_16d);var var2=this.var2.resolve(_16d);var1=(typeof var1!="undefined")?var1:"";var2=(typeof var1!="undefined")?var2:"";if((this.negate&&var1!=var2)||(!this.negate&&var1==var2)){if(this.falses){_16e=this.falses.unrender(_16d,_16e,this);}return (this.trues)?this.trues.render(_16d,_16e,this):_16e;}if(this.trues){_16e=this.trues.unrender(_16d,_16e,this);}return (this.falses)?this.falses.render(_16d,_16e,this):_16e;},unrender:function(_16f,_170){return ddtl.IfNode.prototype.unrender.call(this,_16f,_170);},clone:function(_171){var _172=this.trues?this.trues.clone(_171):null;var _173=this.falses?this.falses.clone(_171):null;return new this.constructor(this.var1.getExpression(),this.var2.getExpression(),_172,_173,this.negate);}});ddtl.ForNode=lang.extend(function(_174,loop,_175,_176){this.assign=_174;this.loop=new dd._Filter(loop);this.reversed=_175;this.nodelist=_176;this.pool=[];},{render:function(_177,_178){var i,j,k;var _179=false;var _17a=this.assign;for(k=0;k<_17a.length;k++){if(typeof _177[_17a[k]]!="undefined"){_179=true;_177=_177.push();break;}}if(!_179&&_177.forloop){_179=true;_177=_177.push();}var _17b=this.loop.resolve(_177)||[];var _17c=lang.isObject(_17b)&&!lang.isArrayLike(_17b);var _17d=[];if(_17c){for(var key in _17b){_17d.push(_17b[key]);}}else{_17d=_17b;}for(i=_17d.length;i<this.pool.length;i++){this.pool[i].unrender(_177,_178,this);}if(this.reversed){_17d=_17d.slice(0).reverse();}var _17e=_177.forloop={parentloop:_177.get("forloop",{})};var j=0;for(i=0;i<_17d.length;i++){var item=_17d[i];_17e.counter0=j;_17e.counter=j+1;_17e.revcounter0=_17d.length-j-1;_17e.revcounter=_17d.length-j;_17e.first=!j;_17e.last=(j==_17d.length-1);if(_17a.length>1&&lang.isArrayLike(item)){if(!_179){_179=true;_177=_177.push();}var _17f={};for(k=0;k<item.length&&k<_17a.length;k++){_17f[_17a[k]]=item[k];}lang.mixin(_177,_17f);}else{_177[_17a[0]]=item;}if(j+1>this.pool.length){this.pool.push(this.nodelist.clone(_178));}_178=this.pool[j++].render(_177,_178,this);}delete _177.forloop;if(_179){_177=_177.pop();}else{for(k=0;k<_17a.length;k++){delete _177[_17a[k]];}}return _178;},unrender:function(_180,_181){for(var i=0,pool;pool=this.pool[i];i++){_181=pool.unrender(_180,_181);}return _181;},clone:function(_182){return new this.constructor(this.assign,this.loop.getExpression(),this.reversed,this.nodelist.clone(_182));}});lang.mixin(ddtl,{if_:function(_183,_184){var i,part,type,_185=[],_186=_184.contents.split();_186.shift();_184=_186.join(" ");_186=_184.split(" and ");if(_186.length==1){type="or";_186=_184.split(" or ");}else{type="and";for(i=0;i<_186.length;i++){if(_186[i].indexOf(" or ")!=-1){throw new Error("'if' tags can't mix 'and' and 'or'");}}}for(i=0;part=_186[i];i++){var not=false;if(part.indexOf("not ")==0){part=part.slice(4);not=true;}_185.push([not,new dd._Filter(part)]);}var _187=_183.parse(["else","endif"]);var _188=false;var _184=_183.next_token();if(_184.contents=="else"){_188=_183.parse(["endif"]);_183.next_token();}return new ddtl.IfNode(_185,_187,_188,type);},_ifequal:function(_189,_18a,_18b){var _18c=_18a.split_contents();if(_18c.length!=3){throw new Error(_18c[0]+" takes two arguments");}var end="end"+_18c[0];var _18d=_189.parse(["else",end]);var _18e=false;var _18a=_189.next_token();if(_18a.contents=="else"){_18e=_189.parse([end]);_189.next_token();}return new ddtl.IfEqualNode(_18c[1],_18c[2],_18d,_18e,_18b);},ifequal:function(_18f,_190){return ddtl._ifequal(_18f,_190);},ifnotequal:function(_191,_192){return ddtl._ifequal(_191,_192,true);},for_:function(_193,_194){var _195=_194.contents.split();if(_195.length<4){throw new Error("'for' statements should have at least four words: "+_194.contents);}var _196=_195[_195.length-1]=="reversed";var _197=(_196)?-3:-2;if(_195[_195.length+_197]!="in"){throw new Error("'for' tag received an invalid argument: "+_194.contents);}var _198=_195.slice(1,_197).join(" ").split(/ *, */);for(var i=0;i<_198.length;i++){if(!_198[i]||_198[i].indexOf(" ")!=-1){throw new Error("'for' tag received an invalid argument: "+_194.contents);}}var _199=_193.parse(["endfor"]);_193.next_token();return new ddtl.ForNode(_198,_195[_195.length+_197+1],_196,_199);}});return ddtl;});},"dojox/date/php":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/date","dojox/string/tokenize"],function(dojo,_19a,_19b,dxst){var php=dojo.getObject("date.php",true,dojox);php.format=function(date,_19c){var df=new php.DateFormat(_19c);return df.format(date);};php.DateFormat=function(_19d){if(!this.regex){var keys=[];for(var key in this.constructor.prototype){if(dojo.isString(key)&&key.length==1&&dojo.isFunction(this[key])){keys.push(key);}}this.constructor.prototype.regex=new RegExp("(?:(\\\\.)|(["+keys.join("")+"]))","g");}var _19e=[];this.tokens=dxst(_19d,this.regex,function(_19f,_1a0,i){if(_1a0){_19e.push([i,_1a0]);return _1a0;}if(_19f){return _19f.charAt(1);}});this.replacements=_19e;};dojo.extend(php.DateFormat,{weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],weekdays_3:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],months_3:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],monthdays:[31,28,31,30,31,30,31,31,30,31,30,31],format:function(date){this.date=date;for(var i=0,_1a1;_1a1=this.replacements[i];i++){this.tokens[_1a1[0]]=this[_1a1[1]]();}return this.tokens.join("");},d:function(){var j=this.j();return (j.length==1)?"0"+j:j;},D:function(){return this.weekdays_3[this.date.getDay()];},j:function(){return this.date.getDate()+"";},l:function(){return this.weekdays[this.date.getDay()];},N:function(){var w=this.w();return (!w)?7:w;},S:function(){switch(this.date.getDate()){case 11:case 12:case 13:return "th";case 1:case 21:case 31:return "st";case 2:case 22:return "nd";case 3:case 23:return "rd";default:return "th";}},w:function(){return this.date.getDay()+"";},z:function(){var _1a2=this.date.getTime()-new Date(this.date.getFullYear(),0,1).getTime();return Math.floor(_1a2/86400000)+"";},W:function(){var week;var _1a3=new Date(this.date.getFullYear(),0,1).getDay()+1;var w=this.date.getDay()+1;var z=parseInt(this.z());if(z<=(8-_1a3)&&_1a3>4){var _1a4=new Date(this.date.getFullYear()-1,this.date.getMonth(),this.date.getDate());if(_1a3==5||(_1a3==6&&_19b.isLeapYear(_1a4))){week=53;}else{week=52;}}else{var i;if(Boolean(this.L())){i=366;}else{i=365;}if((i-z)<(4-w)){week=1;}else{var j=z+(7-w)+(_1a3-1);week=Math.ceil(j/7);if(_1a3>4){--week;}}}return week;},F:function(){return this.months[this.date.getMonth()];},m:function(){var n=this.n();return (n.length==1)?"0"+n:n;},M:function(){return this.months_3[this.date.getMonth()];},n:function(){return this.date.getMonth()+1+"";},t:function(){return (Boolean(this.L())&&this.date.getMonth()==1)?29:this.monthdays[this.getMonth()];},L:function(){return (_19b.isLeapYear(this.date))?"1":"0";},o:function(){},Y:function(){return this.date.getFullYear()+"";},y:function(){return this.Y().slice(-2);},a:function(){return this.date.getHours()>=12?"pm":"am";},b:function(){return this.a().toUpperCase();},B:function(){var off=this.date.getTimezoneOffset()+60;var secs=(this.date.getHours()*3600)+(this.date.getMinutes()*60)+this.getSeconds()+(off*60);var beat=Math.abs(Math.floor(secs/86.4)%1000)+"";while(beat.length<2){beat="0"+beat;}return beat;},g:function(){return (this.date.getHours()%12||12)+"";},G:function(){return this.date.getHours()+"";},h:function(){var g=this.g();return (g.length==1)?"0"+g:g;},H:function(){var G=this.G();return (G.length==1)?"0"+G:G;},i:function(){var mins=this.date.getMinutes()+"";return (mins.length==1)?"0"+mins:mins;},s:function(){var secs=this.date.getSeconds()+"";return (secs.length==1)?"0"+secs:secs;},e:function(){return _19b.getTimezoneName(this.date);},I:function(){},O:function(){var off=Math.abs(this.date.getTimezoneOffset());var _1a5=Math.floor(off/60)+"";var mins=(off%60)+"";if(_1a5.length==1){_1a5="0"+_1a5;}if(mins.length==1){_1a5="0"+mins;}return ((this.date.getTimezoneOffset()<0)?"+":"-")+_1a5+mins;},P:function(){var O=this.O();return O.substring(0,2)+":"+O.substring(2,4);},T:function(){return this.e().substring(0,3);},Z:function(){return this.date.getTimezoneOffset()*-60;},c:function(){return this.Y()+"-"+this.m()+"-"+this.d()+"T"+this.h()+":"+this.i()+":"+this.s()+this.P();},r:function(){return this.D()+", "+this.d()+" "+this.M()+" "+this.Y()+" "+this.H()+":"+this.i()+":"+this.s()+" "+this.O();},U:function(){return Math.floor(this.date.getTime()/1000);}});return php;});},"dojo/date":function(){define(["./has","./_base/lang"],function(has,lang){var date={};date.getDaysInMonth=function(_1a6){var _1a7=_1a6.getMonth();var days=[31,28,31,30,31,30,31,31,30,31,30,31];if(_1a7==1&&date.isLeapYear(_1a6)){return 29;}return days[_1a7];};date.isLeapYear=function(_1a8){var year=_1a8.getFullYear();return !(year%400)||(!(year%4)&&!!(year%100));};date.getTimezoneName=function(_1a9){var str=_1a9.toString();var tz="";var _1aa;var pos=str.indexOf("(");if(pos>-1){tz=str.substring(++pos,str.indexOf(")"));}else{var pat=/([A-Z\/]+) \d{4}$/;if((_1aa=str.match(pat))){tz=_1aa[1];}else{str=_1a9.toLocaleString();pat=/ ([A-Z\/]+)$/;if((_1aa=str.match(pat))){tz=_1aa[1];}}}return (tz=="AM"||tz=="PM")?"":tz;};date.compare=function(_1ab,_1ac,_1ad){_1ab=new Date(+_1ab);_1ac=new Date(+(_1ac||new Date()));if(_1ad=="date"){_1ab.setHours(0,0,0,0);_1ac.setHours(0,0,0,0);}else{if(_1ad=="time"){_1ab.setFullYear(0,0,0);_1ac.setFullYear(0,0,0);}}if(_1ab>_1ac){return 1;}if(_1ab<_1ac){return -1;}return 0;};date.add=function(date,_1ae,_1af){var sum=new Date(+date);var _1b0=false;var _1b1="Date";switch(_1ae){case "day":break;case "weekday":var days,_1b2;var mod=_1af%5;if(!mod){days=(_1af>0)?5:-5;_1b2=(_1af>0)?((_1af-5)/5):((_1af+5)/5);}else{days=mod;_1b2=parseInt(_1af/5);}var strt=date.getDay();var adj=0;if(strt==6&&_1af>0){adj=1;}else{if(strt==0&&_1af<0){adj=-1;}}var trgt=strt+days;if(trgt==0||trgt==6){adj=(_1af>0)?2:-2;}_1af=(7*_1b2)+days+adj;break;case "year":_1b1="FullYear";_1b0=true;break;case "week":_1af*=7;break;case "quarter":_1af*=3;case "month":_1b0=true;_1b1="Month";break;default:_1b1="UTC"+_1ae.charAt(0).toUpperCase()+_1ae.substring(1)+"s";}if(_1b1){sum["set"+_1b1](sum["get"+_1b1]()+_1af);}if(_1b0&&(sum.getDate()<date.getDate())){sum.setDate(0);}return sum;};date.difference=function(_1b3,_1b4,_1b5){_1b4=_1b4||new Date();_1b5=_1b5||"day";var _1b6=_1b4.getFullYear()-_1b3.getFullYear();var _1b7=1;switch(_1b5){case "quarter":var m1=_1b3.getMonth();var m2=_1b4.getMonth();var q1=Math.floor(m1/3)+1;var q2=Math.floor(m2/3)+1;q2+=(_1b6*4);_1b7=q2-q1;break;case "weekday":var days=Math.round(date.difference(_1b3,_1b4,"day"));var _1b8=parseInt(date.difference(_1b3,_1b4,"week"));var mod=days%7;if(mod==0){days=_1b8*5;}else{var adj=0;var aDay=_1b3.getDay();var bDay=_1b4.getDay();_1b8=parseInt(days/7);mod=days%7;var _1b9=new Date(_1b3);_1b9.setDate(_1b9.getDate()+(_1b8*7));var _1ba=_1b9.getDay();if(days>0){switch(true){case aDay==6:adj=-1;break;case aDay==0:adj=0;break;case bDay==6:adj=-1;break;case bDay==0:adj=-2;break;case (_1ba+mod)>5:adj=-2;}}else{if(days<0){switch(true){case aDay==6:adj=0;break;case aDay==0:adj=1;break;case bDay==6:adj=2;break;case bDay==0:adj=1;break;case (_1ba+mod)<0:adj=2;}}}days+=adj;days-=(_1b8*2);}_1b7=days;break;case "year":_1b7=_1b6;break;case "month":_1b7=(_1b4.getMonth()-_1b3.getMonth())+(_1b6*12);break;case "week":_1b7=parseInt(date.difference(_1b3,_1b4,"day")/7);break;case "day":_1b7/=24;case "hour":_1b7/=60;case "minute":_1b7/=60;case "second":_1b7/=1000;case "millisecond":_1b7*=_1b4.getTime()-_1b3.getTime();}return Math.round(_1b7);};1&&lang.mixin(lang.getObject("dojo.date",true),date);return date;});},"dojox/dtl/tag/loop":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/json","../_base","dojox/string/tokenize"],function(lang,_1bb,json,dd,_1bc){var ddtl=lang.getObject("tag.loop",true,dd);ddtl.CycleNode=lang.extend(function(_1bd,name,text,_1be){this.cyclevars=_1bd;this.name=name;this.contents=text;this.shared=_1be||{counter:-1,map:{}};},{render:function(_1bf,_1c0){if(_1bf.forloop&&!_1bf.forloop.counter0){this.shared.counter=-1;}++this.shared.counter;var _1c1=this.cyclevars[this.shared.counter%this.cyclevars.length];var map=this.shared.map;if(!map[_1c1]){map[_1c1]=new dd._Filter(_1c1);}_1c1=map[_1c1].resolve(_1bf,_1c0);if(this.name){_1bf[this.name]=_1c1;}this.contents.set(_1c1);return this.contents.render(_1bf,_1c0);},unrender:function(_1c2,_1c3){return this.contents.unrender(_1c2,_1c3);},clone:function(_1c4){return new this.constructor(this.cyclevars,this.name,this.contents.clone(_1c4),this.shared);}});ddtl.IfChangedNode=lang.extend(function(_1c5,vars,_1c6){this.nodes=_1c5;this._vars=vars;this.shared=_1c6||{last:null,counter:0};this.vars=_1bb.map(vars,function(item){return new dojox.dtl._Filter(item);});},{render:function(_1c7,_1c8){if(_1c7.forloop){if(_1c7.forloop.counter<=this.shared.counter){this.shared.last=null;}this.shared.counter=_1c7.forloop.counter;}var _1c9;if(this.vars.length){_1c9=json.toJson(_1bb.map(this.vars,function(item){return item.resolve(_1c7);}));}else{_1c9=this.nodes.dummyRender(_1c7,_1c8);}if(_1c9!=this.shared.last){var _1ca=(this.shared.last===null);this.shared.last=_1c9;_1c7=_1c7.push();_1c7.ifchanged={firstloop:_1ca};_1c8=this.nodes.render(_1c7,_1c8);_1c7=_1c7.pop();}else{_1c8=this.nodes.unrender(_1c7,_1c8);}return _1c8;},unrender:function(_1cb,_1cc){return this.nodes.unrender(_1cb,_1cc);},clone:function(_1cd){return new this.constructor(this.nodes.clone(_1cd),this._vars,this.shared);}});ddtl.RegroupNode=lang.extend(function(_1ce,key,_1cf){this._expression=_1ce;this.expression=new dd._Filter(_1ce);this.key=key;this.alias=_1cf;},{_push:function(_1d0,_1d1,_1d2){if(_1d2.length){_1d0.push({grouper:_1d1,list:_1d2});}},render:function(_1d3,_1d4){_1d3[this.alias]=[];var list=this.expression.resolve(_1d3);if(list){var last=null;var _1d5=[];for(var i=0;i<list.length;i++){var id=list[i][this.key];if(last!==id){this._push(_1d3[this.alias],last,_1d5);last=id;_1d5=[list[i]];}else{_1d5.push(list[i]);}}this._push(_1d3[this.alias],last,_1d5);}return _1d4;},unrender:function(_1d6,_1d7){return _1d7;},clone:function(_1d8,_1d9){return this;}});lang.mixin(ddtl,{cycle:function(_1da,_1db){var args=_1db.split_contents();if(args.length<2){throw new Error("'cycle' tag requires at least two arguments");}if(args[1].indexOf(",")!=-1){var vars=args[1].split(",");args=[args[0]];for(var i=0;i<vars.length;i++){args.push("\""+vars[i]+"\"");}}if(args.length==2){var name=args[args.length-1];if(!_1da._namedCycleNodes){throw new Error("No named cycles in template: '"+name+"' is not defined");}if(!_1da._namedCycleNodes[name]){throw new Error("Named cycle '"+name+"' does not exist");}return _1da._namedCycleNodes[name];}if(args.length>4&&args[args.length-2]=="as"){var name=args[args.length-1];var node=new ddtl.CycleNode(args.slice(1,args.length-2),name,_1da.create_text_node());if(!_1da._namedCycleNodes){_1da._namedCycleNodes={};}_1da._namedCycleNodes[name]=node;}else{node=new ddtl.CycleNode(args.slice(1),null,_1da.create_text_node());}return node;},ifchanged:function(_1dc,_1dd){var _1de=_1dd.contents.split();var _1df=_1dc.parse(["endifchanged"]);_1dc.delete_first_token();return new ddtl.IfChangedNode(_1df,_1de.slice(1));},regroup:function(_1e0,_1e1){var _1e2=_1bc(_1e1.contents,/(\s+)/g,function(_1e3){return _1e3;});if(_1e2.length<11||_1e2[_1e2.length-3]!="as"||_1e2[_1e2.length-7]!="by"){throw new Error("Expected the format: regroup list by key as newList");}var _1e4=_1e2.slice(2,-8).join("");var key=_1e2[_1e2.length-5];var _1e5=_1e2[_1e2.length-1];return new ddtl.RegroupNode(_1e4,key,_1e5);}});return ddtl;});}}});define("dojox/dtl",["./dtl/_base"],function(_1e6){return _1e6;});