var iso639 = [
["aar", "aar", "aar", "aa", "I", "L", "Afar"],
["abk", "abk", "abk", "ab", "I", "L", "Abkhazian"],
["ace", "ace", "ace", "I", "L", "Achinese"],
["ach", "ach", "ach", "I", "L", "Acoli"],
["ada", "ada", "ada", "I", "L", "Adangme"],
["ady", "ady", "ady", "I", "L", "Adyghe"],
["afh", "afh", "afh", "I", "C", "Afrihili"],
["afr", "afr", "afr", "af", "I", "L", "Afrikaans"],
["ain", "ain", "ain", "I", "L", "Ainu (Japan)"],
["aka", "aka", "aka", "ak", "M", "L", "Akan"],
["akk", "akk", "akk", "I", "A", "Akkadian"],
["ale", "ale", "ale", "I", "L", "Aleut"],
["alt", "alt", "alt", "I", "L", "Southern Altai"],
["amh", "amh", "amh", "am", "I", "L", "Amharic"],
["ang", "ang", "ang", "I", "H", "Old English (ca. 450-1100)"],
["anp", "anp", "anp", "I", "L", "Angika"],
["ara", "ara", "ara", "ar", "M", "L", "Arabic"],
["arc", "arc", "arc", "I", "A", "Official Aramaic (700-300 BCE)"],
["arg", "arg", "arg", "an", "I", "L", "Aragonese"],
["arn", "arn", "arn", "I", "L", "Mapudungun"],
["arp", "arp", "arp", "I", "L", "Arapaho"],
["arw", "arw", "arw", "I", "L", "Arawak"],
["asm", "asm", "asm", "as", "I", "L", "Assamese"],
["ast", "ast", "ast", "I", "L", "Asturian"],
["ava", "ava", "ava", "av", "I", "L", "Avaric"],
["ave", "ave", "ave", "ae", "I", "A", "Avestan"],
["awa", "awa", "awa", "I", "L", "Awadhi"],
["aym", "aym", "aym", "ay", "M", "L", "Aymara"],
["aze", "aze", "aze", "az", "M", "L", "Azerbaijani"],
["bak", "bak", "bak", "ba", "I", "L", "Bashkir"],
["bal", "bal", "bal", "M", "L", "Baluchi"],
["bam", "bam", "bam", "bm", "I", "L", "Bambara"],
["ban", "ban", "ban", "I", "L", "Balinese"],
["bas", "bas", "bas", "I", "L", "Basa (Cameroon)"],
["bej", "bej", "bej", "I", "L", "Beja"],
["bel", "bel", "bel", "be", "I", "L", "Belarusian"],
["bem", "bem", "bem", "I", "L", "Bemba (Zambia)"],
["ben", "ben", "ben", "bn", "I", "L", "Bengali"],
["bho", "bho", "bho", "I", "L", "Bhojpuri"],
["bik", "bik", "bik", "M", "L", "Bikol"],
["bin", "bin", "bin", "I", "L", "Bini"],
["bis", "bis", "bis", "bi", "I", "L", "Bislama"],
["bla", "bla", "bla", "I", "L", "Siksika"],
["bod", "tib", "bod", "bo", "I", "L", "Tibetan"],
["bos", "bos", "bos", "bs", "I", "L", "Bosnian"],
["bra", "bra", "bra", "I", "L", "Braj"],
["bre", "bre", "bre", "br", "I", "L", "Breton"],
["bua", "bua", "bua", "M", "L", "Buriat"],
["bug", "bug", "bug", "I", "L", "Buginese"],
["bul", "bul", "bul", "bg", "I", "L", "Bulgarian"],
["byn", "byn", "byn", "I", "L", "Bilin"],
["cad", "cad", "cad", "I", "L", "Caddo"],
["car", "car", "car", "I", "L", "Galibi Carib"],
["cat", "cat", "cat", "ca", "I", "L", "Catalan"],
["ceb", "ceb", "ceb", "I", "L", "Cebuano"],
["ces", "cze", "ces", "cs", "I", "L", "Czech"],
["cha", "cha", "cha", "ch", "I", "L", "Chamorro"],
["chb", "chb", "chb", "I", "E", "Chibcha"],
["che", "che", "che", "ce", "I", "L", "Chechen"],
["chg", "chg", "chg", "I", "E", "Chagatai"],
["chk", "chk", "chk", "I", "L", "Chuukese"],
["chm", "chm", "chm", "M", "L", "Mari (Russia)"],
["chn", "chn", "chn", "I", "L", "Chinook jargon"],
["cho", "cho", "cho", "I", "L", "Choctaw"],
["chp", "chp", "chp", "I", "L", "Chipewyan"],
["chr", "chr", "chr", "I", "L", "Cherokee"],
["chu", "chu", "chu", "cu", "I", "A", "Church Slavic"],
["chv", "chv", "chv", "cv", "I", "L", "Chuvash"],
["chy", "chy", "chy", "I", "L", "Cheyenne"],
["cop", "cop", "cop", "I", "E", "Coptic"],
["cor", "cor", "cor", "kw", "I", "L", "Cornish"],
["cos", "cos", "cos", "co", "I", "L", "Corsican"],
["cre", "cre", "cre", "cr", "M", "L", "Cree"],
["crh", "crh", "crh", "I", "L", "Crimean Tatar"],
["csb", "csb", "csb", "I", "L", "Kashubian"],
["cym", "wel", "cym", "cy", "I", "L", "Welsh"],
["dak", "dak", "dak", "I", "L", "Dakota"],
["dan", "dan", "dan", "da", "I", "L", "Danish"],
["dar", "dar", "dar", "I", "L", "Dargwa"],
["del", "del", "del", "M", "L", "Delaware"],
["den", "den", "den", "M", "L", "Slave (Athapascan)"],
["deu", "ger", "deu", "de", "I", "L", "German"],
["dgr", "dgr", "dgr", "I", "L", "Dogrib"],
["din", "din", "din", "M", "L", "Dinka"],
["div", "div", "div", "dv", "I", "L", "Dhivehi"],
["doi", "doi", "doi", "M", "L", "Dogri (macrolanguage)"],
["dsb", "dsb", "dsb", "I", "L", "Lower Sorbian"],
["dua", "dua", "dua", "I", "L", "Duala"],
["dum", "dum", "dum", "I", "H", "Middle Dutch (ca. 1050-1350)"],
["dyu", "dyu", "dyu", "I", "L", "Dyula"],
["dzo", "dzo", "dzo", "dz", "I", "L", "Dzongkha"],
["efi", "efi", "efi", "I", "L", "Efik"],
["egy", "egy", "egy", "I", "A", "Egyptian (Ancient)"],
["eka", "eka", "eka", "I", "L", "Ekajuk"],
["ell", "gre", "ell", "el", "I", "L", "Modern Greek (1453-)"],
["elx", "elx", "elx", "I", "A", "Elamite"],
["eng", "eng", "eng", "en", "I", "L", "English"],
["enm", "enm", "enm", "I", "H", "Middle English (1100-1500)"],
["epo", "epo", "epo", "eo", "I", "C", "Esperanto"],
["est", "est", "est", "et", "M", "L", "Estonian"],
["eus", "baq", "eus", "eu", "I", "L", "Basque"],
["ewe", "ewe", "ewe", "ee", "I", "L", "Ewe"],
["ewo", "ewo", "ewo", "I", "L", "Ewondo"],
["fan", "fan", "fan", "I", "L", "Fang (Equatorial Guinea)"],
["fao", "fao", "fao", "fo", "I", "L", "Faroese"],
["fas", "per", "fas", "fa", "M", "L", "Persian"],
["fat", "fat", "fat", "I", "L", "Fanti"],
["fij", "fij", "fij", "fj", "I", "L", "Fijian"],
["fil", "fil", "fil", "I", "L", "Filipino"],
["fin", "fin", "fin", "fi", "I", "L", "Finnish"],
["fon", "fon", "fon", "I", "L", "Fon"],
["fra", "fre", "fra", "fr", "I", "L", "French"],
["frm", "frm", "frm", "I", "H", "Middle French (ca. 1400-1600)"],
["fro", "fro", "fro", "I", "H", "Old French (842-ca. 1400)"],
["frr", "frr", "frr", "I", "L", "Northern Frisian"],
["frs", "frs", "frs", "I", "L", "Eastern Frisian"],
["fry", "fry", "fry", "fy", "I", "L", "Western Frisian"],
["ful", "ful", "ful", "ff", "M", "L", "Fulah"],
["fur", "fur", "fur", "I", "L", "Friulian"],
["gaa", "gaa", "gaa", "I", "L", "Ga"],
["gay", "gay", "gay", "I", "L", "Gayo"],
["gba", "gba", "gba", "M", "L", "Gbaya (Central African Republic)"],
["gez", "gez", "gez", "I", "A", "Geez"],
["gil", "gil", "gil", "I", "L", "Gilbertese"],
["gla", "gla", "gla", "gd", "I", "L", "Scottish Gaelic"],
["gle", "gle", "gle", "ga", "I", "L", "Irish"],
["glg", "glg", "glg", "gl", "I", "L", "Galician"],
["glv", "glv", "glv", "gv", "I", "L", "Manx"],
["gmh", "gmh", "gmh", "I", "H", "Middle High German (ca. 1050-1500)"],
["goh", "goh", "goh", "I", "H", "Old High German (ca. 750-1050)"],
["gon", "gon", "gon", "M", "L", "Gondi"],
["gor", "gor", "gor", "I", "L", "Gorontalo"],
["got", "got", "got", "I", "A", "Gothic"],
["grb", "grb", "grb", "M", "L", "Grebo"],
["grc", "grc", "grc", "I", "H", "Ancient Greek (to 1453)"],
["grn", "grn", "grn", "gn", "M", "L", "Guarani"],
["gsw", "gsw", "gsw", "I", "L", "Swiss German"],
["guj", "guj", "guj", "gu", "I", "L", "Gujarati"],
["gwi", "gwi", "gwi", "I", "L", "Gwich??????in"],
["hai", "hai", "hai", "M", "L", "Haida"],
["hat", "hat", "hat", "ht", "I", "L", "Haitian"],
["hau", "hau", "hau", "ha", "I", "L", "Hausa"],
["haw", "haw", "haw", "I", "L", "Hawaiian"],
["heb", "heb", "heb", "he", "I", "L", "Hebrew"],
["her", "her", "her", "hz", "I", "L", "Herero"],
["hil", "hil", "hil", "I", "L", "Hiligaynon"],
["hin", "hin", "hin", "hi", "I", "L", "Hindi"],
["hit", "hit", "hit", "I", "A", "Hittite"],
["hmn", "hmn", "hmn", "M", "L", "Hmong"],
["hmo", "hmo", "hmo", "ho", "I", "L", "Hiri Motu"],
["hrv", "hrv", "hrv", "hr", "I", "L", "Croatian"],
["hsb", "hsb", "hsb", "I", "L", "Upper Sorbian"],
["hun", "hun", "hun", "hu", "I", "L", "Hungarian"],
["hup", "hup", "hup", "I", "L", "Hupa"],
["hye", "arm", "hye", "hy", "I", "L", "Armenian"],
["iba", "iba", "iba", "I", "L", "Iban"],
["ibo", "ibo", "ibo", "ig", "I", "L", "Igbo"],
["ido", "ido", "ido", "io", "I", "C", "Ido"],
["iii", "iii", "iii", "ii", "I", "L", "Sichuan Yi"],
["iku", "iku", "iku", "iu", "M", "L", "Inuktitut"],
["ile", "ile", "ile", "ie", "I", "C", "Interlingue"],
["ilo", "ilo", "ilo", "I", "L", "Iloko"],
["ina", "ina", "ina", "ia", "I", "C", "Interlingua (International Auxiliary Language Association)"],
["ind", "ind", "ind", "id", "I", "L", "Indonesian"],
["inh", "inh", "inh", "I", "L", "Ingush"],
["ipk", "ipk", "ipk", "ik", "M", "L", "Inupiaq"],
["isl", "ice", "isl", "is", "I", "L", "Icelandic"],
["ita", "ita", "ita", "it", "I", "L", "Italian"],
["jav", "jav", "jav", "jv", "I", "L", "Javanese"],
["jbo", "jbo", "jbo", "I", "C", "Lojban"],
["jpn", "jpn", "jpn", "ja", "I", "L", "Japanese"],
["jpr", "jpr", "jpr", "I", "L", "Judeo-Persian"],
["jrb", "jrb", "jrb", "M", "L", "Judeo-Arabic"],
["kaa", "kaa", "kaa", "I", "L", "Kara-Kalpak"],
["kab", "kab", "kab", "I", "L", "Kabyle"],
["kac", "kac", "kac", "I", "L", "Kachin"],
["kal", "kal", "kal", "kl", "I", "L", "Kalaallisut"],
["kam", "kam", "kam", "I", "L", "Kamba (Kenya)"],
["kan", "kan", "kan", "kn", "I", "L", "Kannada"],
["kas", "kas", "kas", "ks", "I", "L", "Kashmiri"],
["kat", "geo", "kat", "ka", "I", "L", "Georgian"],
["kau", "kau", "kau", "kr", "M", "L", "Kanuri"],
["kaw", "kaw", "kaw", "I", "A", "Kawi"],
["kaz", "kaz", "kaz", "kk", "I", "L", "Kazakh"],
["kbd", "kbd", "kbd", "I", "L", "Kabardian"],
["kha", "kha", "kha", "I", "L", "Khasi"],
["khm", "khm", "khm", "km", "I", "L", "Central Khmer"],
["kho", "kho", "kho", "I", "A", "Khotanese"],
["kik", "kik", "kik", "ki", "I", "L", "Kikuyu"],
["kin", "kin", "kin", "rw", "I", "L", "Kinyarwanda"],
["kir", "kir", "kir", "ky", "I", "L", "Kirghiz"],
["kmb", "kmb", "kmb", "I", "L", "Kimbundu"],
["kok", "kok", "kok", "M", "L", "Konkani (macrolanguage)"],
["kom", "kom", "kom", "kv", "M", "L", "Komi"],
["kon", "kon", "kon", "kg", "M", "L", "Kongo"],
["kor", "kor", "kor", "ko", "I", "L", "Korean"],
["kos", "kos", "kos", "I", "L", "Kosraean"],
["kpe", "kpe", "kpe", "M", "L", "Kpelle"],
["krc", "krc", "krc", "I", "L", "Karachay-Balkar"],
["krl", "krl", "krl", "I", "L", "Karelian"],
["kru", "kru", "kru", "I", "L", "Kurukh"],
["kua", "kua", "kua", "kj", "I", "L", "Kuanyama"],
["kum", "kum", "kum", "I", "L", "Kumyk"],
["kur", "kur", "kur", "ku", "M", "L", "Kurdish"],
["kut", "kut", "kut", "I", "L", "Kutenai"],
["lad", "lad", "lad", "I", "L", "Ladino"],
["lah", "lah", "lah", "M", "L", "Lahnda"],
["lam", "lam", "lam", "I", "L", "Lamba"],
["lao", "lao", "lao", "lo", "I", "L", "Lao"],
["lat", "lat", "lat", "la", "I", "A", "Latin"],
["lav", "lav", "lav", "lv", "M", "L", "Latvian"],
["lez", "lez", "lez", "I", "L", "Lezghian"],
["lim", "lim", "lim", "li", "I", "L", "Limburgan"],
["lin", "lin", "lin", "ln", "I", "L", "Lingala"],
["lit", "lit", "lit", "lt", "I", "L", "Lithuanian"],
["lol", "lol", "lol", "I", "L", "Mongo"],
["loz", "loz", "loz", "I", "L", "Lozi"],
["ltz", "ltz", "ltz", "lb", "I", "L", "Luxembourgish"],
["lua", "lua", "lua", "I", "L", "Luba-Lulua"],
["lub", "lub", "lub", "lu", "I", "L", "Luba-Katanga"],
["lug", "lug", "lug", "lg", "I", "L", "Ganda"],
["lui", "lui", "lui", "I", "L", "Luiseno"],
["lun", "lun", "lun", "I", "L", "Lunda"],
["luo", "luo", "luo", "I", "L", "Luo (Kenya and Tanzania)"],
["lus", "lus", "lus", "I", "L", "Lushai"],
["mad", "mad", "mad", "I", "L", "Madurese"],
["mag", "mag", "mag", "I", "L", "Magahi"],
["mah", "mah", "mah", "mh", "I", "L", "Marshallese"],
["mai", "mai", "mai", "I", "L", "Maithili"],
["mak", "mak", "mak", "I", "L", "Makasar"],
["mal", "mal", "mal", "ml", "I", "L", "Malayalam"],
["man", "man", "man", "M", "L", "Mandingo"],
["mar", "mar", "mar", "mr", "I", "L", "Marathi"],
["mas", "mas", "mas", "I", "L", "Masai"],
["mdf", "mdf", "mdf", "I", "L", "Moksha"],
["mdr", "mdr", "mdr", "I", "L", "Mandar"],
["men", "men", "men", "I", "L", "Mende (Sierra Leone)"],
["mga", "mga", "mga", "I", "H", "Middle Irish (900-1200)"],
["mic", "mic", "mic", "I", "L", "Mi'kmaq"],
["min", "min", "min", "I", "L", "Minangkabau"],
["mis", "mis", "mis", "S", "S", "Uncoded languages"],
["mkd", "mac", "mkd", "mk", "I", "L", "Macedonian"],
["mlg", "mlg", "mlg", "mg", "M", "L", "Malagasy"],
["mlt", "mlt", "mlt", "mt", "I", "L", "Maltese"],
["mnc", "mnc", "mnc", "I", "L", "Manchu"],
["mni", "mni", "mni", "I", "L", "Manipuri"],
["moh", "moh", "moh", "I", "L", "Mohawk"],
["mon", "mon", "mon", "mn", "M", "L", "Mongolian"],
["mos", "mos", "mos", "I", "L", "Mossi"],
["mri", "mao", "mri", "mi", "I", "L", "Maori"],
["msa", "may", "msa", "ms", "M", "L", "Malay (macrolanguage)"],
["mul", "mul", "mul", "S", "S", "Multiple languages"],
["mus", "mus", "mus", "I", "L", "Creek"],
["mwl", "mwl", "mwl", "I", "L", "Mirandese"],
["mwr", "mwr", "mwr", "M", "L", "Marwari"],
["mya", "bur", "mya", "my", "I", "L", "Burmese"],
["myv", "myv", "myv", "I", "L", "Erzya"],
["nap", "nap", "nap", "I", "L", "Neapolitan"],
["nau", "nau", "nau", "na", "I", "L", "Nauru"],
["nav", "nav", "nav", "nv", "I", "L", "Navajo"],
["nbl", "nbl", "nbl", "nr", "I", "L", "South Ndebele"],
["nde", "nde", "nde", "nd", "I", "L", "North Ndebele"],
["ndo", "ndo", "ndo", "ng", "I", "L", "Ndonga"],
["nds", "nds", "nds", "I", "L", "Low German"],
["nep", "nep", "nep", "ne", "M", "L", "Nepali (macrolanguage)"],
["new", "new", "new", "I", "L", "Newari"],
["nia", "nia", "nia", "I", "L", "Nias"],
["niu", "niu", "niu", "I", "L", "Niuean"],
["nld", "dut", "nld", "nl", "I", "L", "Dutch"],
["nno", "nno", "nno", "nn", "I", "L", "Norwegian Nynorsk"],
["nob", "nob", "nob", "nb", "I", "L", "Norwegian Bokm??????l"],
["nog", "nog", "nog", "I", "L", "Nogai"],
["non", "non", "non", "I", "H", "Old Norse"],
["nor", "nor", "nor", "no", "M", "L", "Norwegian"],
["nqo", "nqo", "nqo", "I", "L", "N'Ko"],
["nso", "nso", "nso", "I", "L", "Pedi"],
["nwc", "nwc", "nwc", "I", "H", "Classical Newari"],
["nya", "nya", "nya", "ny", "I", "L", "Nyanja"],
["nym", "nym", "nym", "I", "L", "Nyamwezi"],
["nyn", "nyn", "nyn", "I", "L", "Nyankole"],
["nyo", "nyo", "nyo", "I", "L", "Nyoro"],
["nzi", "nzi", "nzi", "I", "L", "Nzima"],
["oci", "oci", "oci", "oc", "I", "L", "Occitan (post 1500)"],
["oji", "oji", "oji", "oj", "M", "L", "Ojibwa"],
["ori", "ori", "ori", "or", "M", "L", "Oriya (macrolanguage)"],
["orm", "orm", "orm", "om", "M", "L", "Oromo"],
["osa", "osa", "osa", "I", "L", "Osage"],
["oss", "oss", "oss", "os", "I", "L", "Ossetian"],
["ota", "ota", "ota", "I", "H", "Ottoman Turkish (1500-1928)"],
["pag", "pag", "pag", "I", "L", "Pangasinan"],
["pal", "pal", "pal", "I", "A", "Pahlavi"],
["pam", "pam", "pam", "I", "L", "Pampanga"],
["pan", "pan", "pan", "pa", "I", "L", "Panjabi"],
["pap", "pap", "pap", "I", "L", "Papiamento"],
["pau", "pau", "pau", "I", "L", "Palauan"],
["peo", "peo", "peo", "I", "H", "Old Persian (ca. 600-400 B.C.)"],
["phn", "phn", "phn", "I", "A", "Phoenician"],
["pli", "pli", "pli", "pi", "I", "A", "Pali"],
["pol", "pol", "pol", "pl", "I", "L", "Polish"],
["pon", "pon", "pon", "I", "L", "Pohnpeian"],
["por", "por", "por", "pt", "I", "L", "Portuguese"],
["pro", "pro", "pro", "I", "H", "Old Proven??????al (to 1500)"],
["pus", "pus", "pus", "ps", "M", "L", "Pushto"],
["que", "que", "que", "qu", "M", "L", "Quechua"],
["raj", "raj", "raj", "M", "L", "Rajasthani"],
["rap", "rap", "rap", "I", "L", "Rapanui"],
["rar", "rar", "rar", "I", "L", "Rarotongan"],
["roh", "roh", "roh", "rm", "I", "L", "Romansh"],
["rom", "rom", "rom", "M", "L", "Romany"],
["ron", "rum", "ron", "ro", "I", "L", "Romanian"],
["run", "run", "run", "rn", "I", "L", "Rundi"],
["rup", "rup", "rup", "I", "L", "Macedo-Romanian"],
["rus", "rus", "rus", "ru", "I", "L", "Russian"],
["sad", "sad", "sad", "I", "L", "Sandawe"],
["sag", "sag", "sag", "sg", "I", "L", "Sango"],
["sah", "sah", "sah", "I", "L", "Yakut"],
["sam", "sam", "sam", "I", "E", "Samaritan Aramaic"],
["san", "san", "san", "sa", "I", "A", "Sanskrit"],
["sas", "sas", "sas", "I", "L", "Sasak"],
["sat", "sat", "sat", "I", "L", "Santali"],
["scn", "scn", "scn", "I", "L", "Sicilian"],
["sco", "sco", "sco", "I", "L", "Scots"],
["sel", "sel", "sel", "I", "L", "Selkup"],
["sga", "sga", "sga", "I", "H", "Old Irish (to 900)"],
["shn", "shn", "shn", "I", "L", "Shan"],
["sid", "sid", "sid", "I", "L", "Sidamo"],
["sin", "sin", "sin", "si", "I", "L", "Sinhala"],
["slk", "slo", "slk", "sk", "I", "L", "Slovak"],
["slv", "slv", "slv", "sl", "I", "L", "Slovenian"],
["sma", "sma", "sma", "I", "L", "Southern Sami"],
["sme", "sme", "sme", "se", "I", "L", "Northern Sami"],
["smj", "smj", "smj", "I", "L", "Lule Sami"],
["smn", "smn", "smn", "I", "L", "Inari Sami"],
["smo", "smo", "smo", "sm", "I", "L", "Samoan"],
["sms", "sms", "sms", "I", "L", "Skolt Sami"],
["sna", "sna", "sna", "sn", "I", "L", "Shona"],
["snd", "snd", "snd", "sd", "I", "L", "Sindhi"],
["snk", "snk", "snk", "I", "L", "Soninke"],
["sog", "sog", "sog", "I", "A", "Sogdian"],
["som", "som", "som", "so", "I", "L", "Somali"],
["sot", "sot", "sot", "st", "I", "L", "Southern Sotho"],
["spa", "spa", "spa", "es", "I", "L", "Spanish"],
["sqi", "alb", "sqi", "sq", "M", "L", "Albanian"],
["srd", "srd", "srd", "sc", "M", "L", "Sardinian"],
["srn", "srn", "srn", "I", "L", "Sranan Tongo"],
["srp", "srp", "srp", "sr", "I", "L", "Serbian"],
["srr", "srr", "srr", "I", "L", "Serer"],
["ssw", "ssw", "ssw", "ss", "I", "L", "Swati"],
["suk", "suk", "suk", "I", "L", "Sukuma"],
["sun", "sun", "sun", "su", "I", "L", "Sundanese"],
["sus", "sus", "sus", "I", "L", "Susu"],
["sux", "sux", "sux", "I", "A", "Sumerian"],
["swa", "swa", "swa", "sw", "M", "L", "Swahili (macrolanguage)"],
["swe", "swe", "swe", "sv", "I", "L", "Swedish"],
["syc", "syc", "syc", "I", "H", "Classical Syriac"],
["syr", "syr", "syr", "M", "L", "Syriac"],
["tah", "tah", "tah", "ty", "I", "L", "Tahitian"],
["tam", "tam", "tam", "ta", "I", "L", "Tamil"],
["tat", "tat", "tat", "tt", "I", "L", "Tatar"],
["tel", "tel", "tel", "te", "I", "L", "Telugu"],
["tem", "tem", "tem", "I", "L", "Timne"],
["ter", "ter", "ter", "I", "L", "Tereno"],
["tet", "tet", "tet", "I", "L", "Tetum"],
["tgk", "tgk", "tgk", "tg", "I", "L", "Tajik"],
["tgl", "tgl", "tgl", "tl", "I", "L", "Tagalog"],
["tha", "tha", "tha", "th", "I", "L", "Thai"],
["tig", "tig", "tig", "I", "L", "Tigre"],
["tir", "tir", "tir", "ti", "I", "L", "Tigrinya"],
["tiv", "tiv", "tiv", "I", "L", "Tiv"],
["tkl", "tkl", "tkl", "I", "L", "Tokelau"],
["tlh", "tlh", "tlh", "I", "C", "Klingon"],
["tli", "tli", "tli", "I", "L", "Tlingit"],
["tmh", "tmh", "tmh", "M", "L", "Tamashek"],
["tog", "tog", "tog", "I", "L", "Tonga (Nyasa)"],
["ton", "ton", "ton", "to", "I", "L", "Tonga (Tonga Islands)"],
["tpi", "tpi", "tpi", "I", "L", "Tok Pisin"],
["tsi", "tsi", "tsi", "I", "L", "Tsimshian"],
["tsn", "tsn", "tsn", "tn", "I", "L", "Tswana"],
["tso", "tso", "tso", "ts", "I", "L", "Tsonga"],
["tuk", "tuk", "tuk", "tk", "I", "L", "Turkmen"],
["tum", "tum", "tum", "I", "L", "Tumbuka"],
["tur", "tur", "tur", "tr", "I", "L", "Turkish"],
["tvl", "tvl", "tvl", "I", "L", "Tuvalu"],
["twi", "twi", "twi", "tw", "I", "L", "Twi"],
["tyv", "tyv", "tyv", "I", "L", "Tuvinian"],
["udm", "udm", "udm", "I", "L", "Udmurt"],
["uga", "uga", "uga", "I", "A", "Ugaritic"],
["uig", "uig", "uig", "ug", "I", "L", "Uighur"],
["ukr", "ukr", "ukr", "uk", "I", "L", "Ukrainian"],
["umb", "umb", "umb", "I", "L", "Umbundu"],
["und", "und", "und", "S", "S", "Undetermined"],
["urd", "urd", "urd", "ur", "I", "L", "Urdu"],
["uzb", "uzb", "uzb", "uz", "M", "L", "Uzbek"],
["vai", "vai", "vai", "I", "L", "Vai"],
["ven", "ven", "ven", "ve", "I", "L", "Venda"],
["vie", "vie", "vie", "vi", "I", "L", "Vietnamese"],
["vol", "vol", "vol", "vo", "I", "C", "Volap??????k"],
["vot", "vot", "vot", "I", "L", "Votic"],
["wal", "wal", "wal", "I", "L", "Wolaytta"],
["war", "war", "war", "I", "L", "Waray (Philippines)"],
["was", "was", "was", "I", "L", "Washo"],
["wln", "wln", "wln", "wa", "I", "L", "Walloon"],
["wol", "wol", "wol", "wo", "I", "L", "Wolof"],
["xal", "xal", "xal", "I", "L", "Kalmyk"],
["xho", "xho", "xho", "xh", "I", "L", "Xhosa"],
["yao", "yao", "yao", "I", "L", "Yao"],
["yap", "yap", "yap", "I", "L", "Yapese"],
["yid", "yid", "yid", "yi", "M", "L", "Yiddish"],
["yor", "yor", "yor", "yo", "I", "L", "Yoruba"],
["zap", "zap", "zap", "M", "L", "Zapotec"],
["zbl", "zbl", "zbl", "I", "C", "Blissymbols"],
["zen", "zen", "zen", "I", "L", "Zenaga"],
["zha", "zha", "zha", "za", "M", "L", "Zhuang"],
["zho", "chi", "zho", "zh", "M", "L", "Chinese"],
["zul", "zul", "zul", "zu", "I", "L", "Zulu"],
["zun", "zun", "zun", "I", "L", "Zuni"],
["zxx", "zxx", "zxx", "S", "S", "No linguistic content"],
["zza", "zza", "zza", "M", "L", "Zaza"]
];

function lookupLanguage(code) {
    var i;
    for ( i = 0; i < iso639.length; i++ ) {
            if ( iso639[i][1] == code ) {
                    return iso639[i][3];
            }
    }
    return "en";
}
function reverseLookupLanguage(code) {
    var i;
    for ( i = 0; i < iso639.length; i++ ) {
            // doDebug(iso639[i][1]);
            if ( iso639[i][3] == code ) {
                    return iso639[i][1];
            }
    }
    return "en";
}
function getLanguageName(code) {
    // 2-letter code
    var i;
    for ( i = 0; i < iso639.length; i++ ) {
            // doDebug(iso639[i][1]);
            if ( iso639[i][3] == code ) {
                    return iso639[i][6];
            }
    }
    return "No linguistic content";
}
