import re
from django.conf import settings
from staticgenerator import StaticGenerator

class StaticGeneratorMiddleware(object):
    """
    This requires settings.STATIC_GENERATOR_URLS tuple to match on URLs
    
    Example::
        
        STATIC_GENERATOR_URLS = (
            r'^/$',
            r'^/blog',
        )
        
    """
    urls = tuple([re.compile(url) for url in settings.STATIC_GENERATOR_URLS])
    
    def process_response(self, request, response):
        if response.status_code == 200:
            for url in self.urls:
                if url.match(request.path):
                    gen = StaticGenerator()
                    gen.publish_from_path(request.path, response.content)
                    break
        return response