
import os

from ..utils import *

class _CatFileIterator(object):
    def __init__(self, ctx, paths):
        self.ctx = ctx
        self.paths = paths

    def __iter__(self):
        for path in self.paths:
            if path.startswith("#"):
                continue

            with self.ctx.open(path, "rb") as f:
                for chunk in iter_file_chunks(f):
                    yield chunk

class CatFile(object):
    def __init__(self):
        pass

    def __call__(self, context, filename):
        try:
            with context.open(filename, "r", encoding='utf-8', errors='replace') as catfile:
                lines = (line.strip() for line in catfile)
                paths = [os.path.join(os.path.dirname(filename), line)
                         for line in lines if not line.startswith("#")]
                return _CatFileIterator(context, paths)
        except FileNotFoundError:
            return
