
from __future__ import absolute_import

import mako.lookup
from mako.template import Template as MakoTemplate

class Mako(object):
    def __init__(self, lookup=None, include=()):
        self.lookup = lookup
        self.include = include

    def __call__(self, context, filename):
        if self.lookup is None:
            dirs = [context.root]
            dirs.extend(self.include)
            self.lookup = mako.lookup.TemplateLookup(directories=dirs)

        tpl = MakoTemplate(filename=filename, lookup=self.lookup)
        return [tpl.render()]
        
