
import hashlib
import os
import subprocess

from ..utils import *

class Sass(object):
    def __init__(self, cache_dir=None, include=(), sass="sass"):
        self.sass = sass
        self.include = include
        self.cache_dir = cache_dir

    def __call__(self, context, filename):
        cache_dir = self.cache_dir

        if os.path.basename(filename).startswith("_"):
            return None        # TODO make a settings variable?

        inpath = context.resolve(filename)
        if inpath is None:
            return None

        cmd = [self.sass]

        for path in self.include:
            cmd.extend(['-I', path])
        cmd.extend(['-I', os.path.join(context.root, os.path.dirname(filename))])

        if cache_dir is not None and len(cache_dir) > 0:
            cmd.extend(["--cache-location", os.path.join(cache_dir, "cache")])

            outpath = os.path.join(cache_dir, "output", filename)
            mkdir_p(os.path.dirname(outpath))

            if not os.path.isfile(outpath):
                cmd.extend([inpath, outpath])
            else:
                cmd.extend(["--update", "%s:%s"%(inpath, outpath, )])

            subprocess.call(cmd)

            return context.static_iterator(outpath, 'rb', virtual=False)
        else:
            itr = TmpFileIterator()
            try:
                cmd.extend([inpath, itr.name])
                subprocess.call(cmd)
            except:
                itr.close()
                raise
            return itr
