

import os

from ..utils import *

class Less(object):
    def __init__(self, include=(), lessc="lessc"):
        self.lessc = lessc
        self.include = include

    def __call__(self, context, filename):
        cmd = [self.lessc]

        paths = list(self.include) + [os.path.join(context.root, os.path.dirname(filename))]
        cmd.append('--include-path=' + ";".join(paths))

        cmd.append("-")

        return CmdIterator(cmd, stdin=context.static_iterator(filename, "rb"))
