# -*- coding: utf-8 -*-
# vi:si:et:sw=4:sts=4:ts=4

##
## Copyright (C) 2006-2012 Async Open Source
##
## This program is free software; you can redistribute it and/or
## modify it under the terms of the GNU Lesser General Public License
## as published by the Free Software Foundation; either version 2
## of the License, or (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU Lesser General Public License for more details.
##
## You should have received a copy of the GNU Lesser General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., or visit: http://www.gnu.org/.
##
##
## Author(s): Stoq Team <stoq-devel@async.com.br>
##

import locale
import operator

from stoqlib.lib.translation import dgettext, locale_sorted


# The country list is part of the evolution source code:
# evolution/addressbook/gui/contact-editor/e-contact-editor-address.c
countries = ["Afghanistan",
             "Åland Islands",
             "Albania",
             "Algeria",
             "American Samoa",
             "Andorra",
             "Angola",
             "Anguilla",
             "Antarctica",
             "Antigua and Barbuda",
             "Argentina",
             "Armenia",
             "Aruba",
             "Australia",
             "Austria",
             "Azerbaijan",
             "Bahamas",
             "Bahrain",
             "Bangladesh",
             "Barbados",
             "Belarus",
             "Belgium",
             "Belize",
             "Benin",
             "Bermuda",
             "Bhutan",
             "Bolivia",
             "Bolivia, Plurinational State of",
             "Bonaire, Sint Eustatius and Saba",
             "Bosnia and Herzegovina",
             "Botswana",
             "Bouvet Island",
             "Brazil",
             "British Indian Ocean Territory",
             "Brunei Darussalam",
             "Bulgaria",
             "Burkina Faso",
             "Burundi",
             "Cambodia",
             "Cameroon",
             "Canada",
             "Cape Verde",
             "Cayman Islands",
             "Central African Republic",
             "Chad",
             "Chile",
             "China",
             "Christmas Island",
             "Cocos (Keeling) Islands",
             "Colombia",
             "Comoros",
             "Congo",
             "Congo, The Democratic Republic of the",
             "Cook Islands",
             "Costa Rica",
             "Côte d'Ivoire",
             "Croatia",
             "Cuba",
             "Curaçao",
             "Cyprus",
             "Czech Republic",
             "Denmark",
             "Djibouti",
             "Dominica",
             "Dominican Republic",
             "Ecuador",
             "Egypt",
             "El Salvador",
             "Equatorial Guinea",
             "Eritrea",
             "Estonia",
             "Ethiopia",
             "Falkland Islands (Malvinas)",
             "Faroe Islands",
             "Fiji",
             "Finland",
             "France",
             "French Guiana",
             "French Polynesia",
             "French Southern Territories",
             "Gabon",
             "Gambia",
             "Georgia",
             "Germany",
             "Ghana",
             "Gibraltar",
             "Greece",
             "Greenland",
             "Grenada",
             "Guadeloupe",
             "Guam",
             "Guatemala",
             "Guernsey",
             "Guinea",
             "Guinea-Bissau",
             "Guyana",
             "Haiti",
             "Heard Island and McDonald Islands",
             "Holy See (Vatican City State)",
             "Honduras",
             "Hong Kong",
             "Hungary",
             "Iceland",
             "India",
             "Indonesia",
             "Iran, Islamic Republic of",
             "Iraq",
             "Ireland",
             "Isle of Man",
             "Israel",
             "Italy",
             "Jamaica",
             "Japan",
             "Jersey",
             "Jordan",
             "Kazakhstan",
             "Kenya",
             "Kiribati",
             "Korea, Democratic People's Republic of",
             "Korea, Republic of",
             "Kuwait",
             "Kyrgyzstan",
             "Lao People's Democratic Republic",
             "Latvia",
             "Lebanon",
             "Lesotho",
             "Liberia",
             "Libya",
             "Libyan Arab Jamahiriya",
             "Liechtenstein",
             "Lithuania",
             "Luxembourg",
             "Macao",
             "Macedonia, Republic of",
             "Madagascar",
             "Malawi",
             "Malaysia",
             "Maldives",
             "Mali",
             "Malta",
             "Marshall Islands",
             "Martinique",
             "Mauritania",
             "Mauritius",
             "Mayotte",
             "Mexico",
             "Micronesia, Federated States of",
             "Moldova",
             "Moldova, Republic of",
             "Monaco",
             "Mongolia",
             "Montenegro",
             "Montserrat",
             "Morocco",
             "Mozambique",
             "Myanmar",
             "Namibia",
             "Nauru",
             "Nepal",
             "Netherlands",
             "New Caledonia",
             "New Zealand",
             "Nicaragua",
             "Niger",
             "Nigeria",
             "Niue",
             "Norfolk Island",
             "Northern Mariana Islands",
             "Norway",
             "Oman",
             "Pakistan",
             "Palau",
             "Palestinian Territory, Occupied",
             "Panama",
             "Papua New Guinea",
             "Paraguay",
             "Peru",
             "Philippines",
             "Pitcairn",
             "Poland",
             "Portugal",
             "Puerto Rico",
             "Qatar",
             "Reunion",
             "Romania",
             "Russian Federation",
             "Rwanda",
             "Saint Barthélemy",
             "Saint Helena, Ascension and Tristan da Cunha",
             "Saint Kitts and Nevis",
             "Saint Lucia",
             "Saint Martin (French part)",
             "Saint Pierre and Miquelon",
             "Saint Vincent and the Grenadines",
             "Samoa",
             "San Marino",
             "Sao Tome and Principe",
             "Saudi Arabia",
             "Senegal",
             "Serbia",
             "Seychelles",
             "Sierra Leone",
             "Singapore",
             "Sint Maarten",
             "Slovakia",
             "Slovenia",
             "Solomon Islands",
             "Somalia",
             "South Africa",
             "South Georgia and the South Sandwich Islands",
             "Spain",
             "Sri Lanka",
             "Sudan",
             "Suriname",
             "Svalbard and Jan Mayen",
             "Swaziland",
             "Sweden",
             "Switzerland",
             "Syrian Arab Republic",
             "Taiwan",
             "Taiwan, Province of China",
             "Tajikistan",
             "Tanzania, United Republic of",
             "Thailand",
             "Timor-Leste",
             "Togo",
             "Tokelau",
             "Tonga",
             "Trinidad and Tobago",
             "Tunisia",
             "Turkey",
             "Turkmenistan",
             "Turks and Caicos Islands",
             "Tuvalu",
             "Uganda",
             "Ukraine",
             "United Arab Emirates",
             "United Kingdom",
             "United States",
             "United States Minor Outlying Islands",
             "Uruguay",
             "Uzbekistan",
             "Vanuatu",
             "Venezuela",
             "Venezuela, Bolivarian republic of",
             "Viet Nam",
             "Virgin Islands, British",
             "Virgin Islands, U.S.",
             "Wallis and Futuna",
             "Western Sahara",
             "Yemen",
             "Zambia",
             "Zimbabwe"]


def get_countries():
    """Fetch a list of translated/untranslated countries suitable for usage
    within combo.prefill();

    >>> [(translated label, label), ...]

    :returns: a list of tuples
    """
    # FIXME: Get this lazely from /usr/share/xml/iso-codes/iso_3166.xml
    #        as pointed out on bug 5100.
    def cmp_func(a, b):
        return locale.strcoll(a[0], b[0])
    # We store translated country names in a set to ensure
    # there are no dupes because the combo expects that.
    items = set()
    for country in countries:
        items.add((dgettext("iso_3166", country), country))
    return locale_sorted(items, key=operator.itemgetter(0))
