# -*- Mode: Python; coding: utf-8 -*-
# vi:si:et:sw=4:sts=4:ts=4

##
## Copyright (C) 2007 Async Open Source <http://www.async.com.br>
## All rights reserved
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., or visit: http://www.gnu.org/.
##
## Author(s): Stoq Team <stoq-devel@async.com.br>
##

from pydispatch.dispatcher import connect, disconnect, send
from kiwi.log import Logger

log = Logger('stoqlib.events')


class Event(object):
    returnclass = None

    @classmethod
    def emit(cls, *args, **kwargs):
        log.info('emitting event %s %r %r' % (cls.__name__,
                                              args, kwargs))
        rv = send(cls, cls, *args, **kwargs)
        # Pick the last return value which is not None
        for func, retval in reversed(rv):
            if retval is not None:
                if (cls.returnclass and type(retval) != cls.returnclass
                    and not isinstance(retval, cls.returnclass)):
                    raise TypeError('Expected return value to be %s, got %s'
                                    % (cls.returnclass, type(retval)))
                return retval

    @classmethod
    def connect(cls, callback):
        connect(callback, signal=cls)

    @classmethod
    def disconnect(cls, callback):
        disconnect(callback, signal=cls)
