# -*- coding: utf-8 -*-
# vi:si:et:sw=4:sts=4:ts=4

##
## Copyright (C) 2006-2012 Async Open Source
##
## This program is free software; you can redistribute it and/or
## modify it under the terms of the GNU Lesser General Public License
## as published by the Free Software Foundation; either version 2
## of the License, or (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU Lesser General Public License for more details.
##
## You should have received a copy of the GNU Lesser General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., or visit: http://www.gnu.org/.
##
##
## Author(s): Stoq Team <stoq-devel@async.com.br>
##

import locale
import operator

from stoqlib.lib.translation import dgettext, locale_sorted


# The country list is part of the evolution source code:
# evolution/addressbook/gui/contact-editor/e-contact-editor-address.c
countries = [u"Afghanistan",
             u"Åland Islands",
             u"Albania",
             u"Algeria",
             u"American Samoa",
             u"Andorra",
             u"Angola",
             u"Anguilla",
             u"Antarctica",
             u"Antigua and Barbuda",
             u"Argentina",
             u"Armenia",
             u"Aruba",
             u"Australia",
             u"Austria",
             u"Azerbaijan",
             u"Bahamas",
             u"Bahrain",
             u"Bangladesh",
             u"Barbados",
             u"Belarus",
             u"Belgium",
             u"Belize",
             u"Benin",
             u"Bermuda",
             u"Bhutan",
             u"Bolivia",
             u"Bolivia, Plurinational State of",
             u"Bonaire, Sint Eustatius and Saba",
             u"Bosnia and Herzegovina",
             u"Botswana",
             u"Bouvet Island",
             u"Brazil",
             u"British Indian Ocean Territory",
             u"Brunei Darussalam",
             u"Bulgaria",
             u"Burkina Faso",
             u"Burundi",
             u"Cambodia",
             u"Cameroon",
             u"Canada",
             u"Cape Verde",
             u"Cayman Islands",
             u"Central African Republic",
             u"Chad",
             u"Chile",
             u"China",
             u"Christmas Island",
             u"Cocos (Keeling) Islands",
             u"Colombia",
             u"Comoros",
             u"Congo",
             u"Congo, The Democratic Republic of the",
             u"Cook Islands",
             u"Costa Rica",
             u"Côte d'Ivoire",
             u"Croatia",
             u"Cuba",
             u"Curaçao",
             u"Cyprus",
             u"Czech Republic",
             u"Denmark",
             u"Djibouti",
             u"Dominica",
             u"Dominican Republic",
             u"Ecuador",
             u"Egypt",
             u"El Salvador",
             u"Equatorial Guinea",
             u"Eritrea",
             u"Estonia",
             u"Ethiopia",
             u"Falkland Islands (Malvinas)",
             u"Faroe Islands",
             u"Fiji",
             u"Finland",
             u"France",
             u"French Guiana",
             u"French Polynesia",
             u"French Southern Territories",
             u"Gabon",
             u"Gambia",
             u"Georgia",
             u"Germany",
             u"Ghana",
             u"Gibraltar",
             u"Greece",
             u"Greenland",
             u"Grenada",
             u"Guadeloupe",
             u"Guam",
             u"Guatemala",
             u"Guernsey",
             u"Guinea",
             u"Guinea-Bissau",
             u"Guyana",
             u"Haiti",
             u"Heard Island and McDonald Islands",
             u"Holy See (Vatican City State)",
             u"Honduras",
             u"Hong Kong",
             u"Hungary",
             u"Iceland",
             u"India",
             u"Indonesia",
             u"Iran, Islamic Republic of",
             u"Iraq",
             u"Ireland",
             u"Isle of Man",
             u"Israel",
             u"Italy",
             u"Jamaica",
             u"Japan",
             u"Jersey",
             u"Jordan",
             u"Kazakhstan",
             u"Kenya",
             u"Kiribati",
             u"Korea, Democratic People's Republic of",
             u"Korea, Republic of",
             u"Kuwait",
             u"Kyrgyzstan",
             u"Lao People's Democratic Republic",
             u"Latvia",
             u"Lebanon",
             u"Lesotho",
             u"Liberia",
             u"Libya",
             u"Libyan Arab Jamahiriya",
             u"Liechtenstein",
             u"Lithuania",
             u"Luxembourg",
             u"Macao",
             u"Macedonia, Republic of",
             u"Madagascar",
             u"Malawi",
             u"Malaysia",
             u"Maldives",
             u"Mali",
             u"Malta",
             u"Marshall Islands",
             u"Martinique",
             u"Mauritania",
             u"Mauritius",
             u"Mayotte",
             u"Mexico",
             u"Micronesia, Federated States of",
             u"Moldova",
             u"Moldova, Republic of",
             u"Monaco",
             u"Mongolia",
             u"Montenegro",
             u"Montserrat",
             u"Morocco",
             u"Mozambique",
             u"Myanmar",
             u"Namibia",
             u"Nauru",
             u"Nepal",
             u"Netherlands",
             u"New Caledonia",
             u"New Zealand",
             u"Nicaragua",
             u"Niger",
             u"Nigeria",
             u"Niue",
             u"Norfolk Island",
             u"Northern Mariana Islands",
             u"Norway",
             u"Oman",
             u"Pakistan",
             u"Palau",
             u"Palestinian Territory, Occupied",
             u"Panama",
             u"Papua New Guinea",
             u"Paraguay",
             u"Peru",
             u"Philippines",
             u"Pitcairn",
             u"Poland",
             u"Portugal",
             u"Puerto Rico",
             u"Qatar",
             u"Reunion",
             u"Romania",
             u"Russian Federation",
             u"Rwanda",
             u"Saint Barthélemy",
             u"Saint Helena, Ascension and Tristan da Cunha",
             u"Saint Kitts and Nevis",
             u"Saint Lucia",
             u"Saint Martin (French part)",
             u"Saint Pierre and Miquelon",
             u"Saint Vincent and the Grenadines",
             u"Samoa",
             u"San Marino",
             u"Sao Tome and Principe",
             u"Saudi Arabia",
             u"Senegal",
             u"Serbia",
             u"Seychelles",
             u"Sierra Leone",
             u"Singapore",
             u"Sint Maarten",
             u"Slovakia",
             u"Slovenia",
             u"Solomon Islands",
             u"Somalia",
             u"South Africa",
             u"South Georgia and the South Sandwich Islands",
             u"Spain",
             u"Sri Lanka",
             u"Sudan",
             u"Suriname",
             u"Svalbard and Jan Mayen",
             u"Swaziland",
             u"Sweden",
             u"Switzerland",
             u"Syrian Arab Republic",
             u"Taiwan",
             u"Taiwan, Province of China",
             u"Tajikistan",
             u"Tanzania, United Republic of",
             u"Thailand",
             u"Timor-Leste",
             u"Togo",
             u"Tokelau",
             u"Tonga",
             u"Trinidad and Tobago",
             u"Tunisia",
             u"Turkey",
             u"Turkmenistan",
             u"Turks and Caicos Islands",
             u"Tuvalu",
             u"Uganda",
             u"Ukraine",
             u"United Arab Emirates",
             u"United Kingdom",
             u"United States",
             u"United States Minor Outlying Islands",
             u"Uruguay",
             u"Uzbekistan",
             u"Vanuatu",
             u"Venezuela",
             u"Venezuela, Bolivarian republic of",
             u"Viet Nam",
             u"Virgin Islands, British",
             u"Virgin Islands, U.S.",
             u"Wallis and Futuna",
             u"Western Sahara",
             u"Yemen",
             u"Zambia",
             u"Zimbabwe"]


def get_countries():
    """Fetch a list of translated/untranslated countries suitable for usage
    within combo.prefill()::

    [(translated label, label), ...]

    :returns: a list of tuples
    """
    # FIXME: Get this lazely from /usr/share/xml/iso-codes/iso_3166.xml
    #        as pointed out on bug 5100.
    def cmp_func(a, b):
        return locale.strcoll(a[0], b[0])
    # We store translated country names in a set to ensure
    # there are no dupes because the combo expects that.
    items = set()
    for country in countries:
        items.add((dgettext("iso_3166", country), country))
    return locale_sorted(items, key=operator.itemgetter(0))
