/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.lang.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceRegistry<K, S> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Map<K, S> services = new HashMap<K, S>();

    protected ServiceRegistry(Class<S> serviceClass) {
        Iterator<S> services = javax.imageio.spi.ServiceRegistry.lookupProviders(serviceClass, serviceClass.getClassLoader());
        while (true) {
            try {
                while (services.hasNext()) {
                    S service = services.next();
                    S oldService = this.add(service);
                    if (oldService != null) {
                        this.logger.warn("New service {} replaces existing service {}", (Object)service.getClass(), (Object)oldService.getClass());
                    }
                    this.logger.debug("Registered service class {}", (Object)service.getClass().getName());
                }
            }
            catch (Error e) {
                this.logger.error("Failed to instantiate service", e);
                continue;
            }
            break;
        }
    }

    public S add(S service) {
        return this.services.put(this.getKey(service), service);
    }

    public void remove(S service) {
        this.services.remove(this.getKey(service));
    }

    public S get(K key) {
        return this.services.get(key);
    }

    public boolean has(K key) {
        return this.services.containsKey(key);
    }

    public Collection<S> getAll() {
        return Collections.unmodifiableCollection(this.services.values());
    }

    public Set<K> getKeys() {
        return Collections.unmodifiableSet(this.services.keySet());
    }

    protected abstract K getKey(S var1);
}

