/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.helpers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.RDFHandlerWrapper;

public class BufferedGroupingRDFHandler
extends RDFHandlerWrapper {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private final int bufferSize;
    private final Graph bufferedStatements;
    private final Set<Resource> contexts;
    private final Object bufferLock = new Object();

    public BufferedGroupingRDFHandler(RDFHandler ... handlers) {
        this(1024, handlers);
    }

    public BufferedGroupingRDFHandler(int bufferSize, RDFHandler ... handlers) {
        super(handlers);
        this.bufferSize = bufferSize;
        this.bufferedStatements = new GraphImpl();
        this.contexts = new HashSet<Resource>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleStatement(Statement st) throws RDFHandlerException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.bufferedStatements.add(st);
            this.contexts.add(st.getContext());
            if (this.bufferedStatements.size() >= this.bufferSize) {
                this.processBuffer();
            }
        }
    }

    private void processBuffer() throws RDFHandlerException {
        for (Resource context : this.contexts) {
            Set<Resource> subjects = GraphUtil.getSubjects(this.bufferedStatements, null, null, context);
            for (Resource subject : subjects) {
                HashSet<URI> processedPredicates = new HashSet<URI>();
                Iterator<Statement> typeStatements = this.bufferedStatements.match(subject, RDF.TYPE, null, context);
                while (typeStatements.hasNext()) {
                    Statement typeStatement = typeStatements.next();
                    super.handleStatement(typeStatement);
                }
                processedPredicates.add(RDF.TYPE);
                Iterator<Statement> subjectStatements = this.bufferedStatements.match(subject, null, null, context);
                while (subjectStatements.hasNext()) {
                    Statement subjectStatement = subjectStatements.next();
                    URI predicate = subjectStatement.getPredicate();
                    if (processedPredicates.contains(predicate)) continue;
                    Iterator<Statement> toWrite = this.bufferedStatements.match(subject, predicate, null, context);
                    while (toWrite.hasNext()) {
                        Statement toWriteSt = toWrite.next();
                        super.handleStatement(toWriteSt);
                    }
                    processedPredicates.add(predicate);
                }
            }
        }
        this.bufferedStatements.clear();
        this.contexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRDF() throws RDFHandlerException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.processBuffer();
        }
        super.endRDF();
    }
}

