/*
 * Decompiled with CFR 0.152.
 */
package eu.stratuslab.marketplace.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public final class MetadataNamespaceContext
implements NamespaceContext {
    public static final String MARKETPLACE_URI = "http://mp.stratuslab.eu/";
    public static final String RDF_NS_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String DCTERMS_NS_URI = "http://purl.org/dc/terms/";
    public static final String SLTERMS_NS_URI = "http://mp.stratuslab.eu/slterms#";
    public static final String SLREQ_NS_URI = "http://mp.stratuslab.eu/slreq#";
    public static final String RDF_PREFIX = "rdf";
    public static final String DCTERMS_PREFIX = "dcterms";
    public static final String SLTERMS_PREFIX = "slterms";
    public static final String SLREQ_PREFIX = "slreq";
    public static final String XMLDSIG_PREFIX = "xmldsig";
    private static final Map<String, String> PREFIX_TO_NS = new HashMap<String, String>();
    private static final Map<String, String> NS_TO_PREFIX = new HashMap<String, String>();
    private static final MetadataNamespaceContext INSTANCE = new MetadataNamespaceContext();

    private MetadataNamespaceContext() {
    }

    public static MetadataNamespaceContext getInstance() {
        return INSTANCE;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        String value = PREFIX_TO_NS.get(prefix);
        return value != null ? value : "";
    }

    @Override
    public String getPrefix(String nsUri) {
        if (nsUri == null) {
            throw new IllegalArgumentException();
        }
        return NS_TO_PREFIX.get(nsUri);
    }

    @Override
    public Iterator<String> getPrefixes(String nsUri) {
        String prefix = this.getPrefix(nsUri);
        ArrayList<String> prefixes = new ArrayList<String>();
        if (prefix != null) {
            prefixes.add(prefix);
        }
        return Collections.unmodifiableList(prefixes).iterator();
    }

    static {
        PREFIX_TO_NS.put("", "");
        PREFIX_TO_NS.put("xml", "http://www.w3.org/XML/1998/namespace");
        PREFIX_TO_NS.put("xmlns", "http://www.w3.org/2000/xmlns/");
        PREFIX_TO_NS.put(RDF_PREFIX, RDF_NS_URI);
        PREFIX_TO_NS.put(DCTERMS_PREFIX, DCTERMS_NS_URI);
        PREFIX_TO_NS.put(SLTERMS_PREFIX, SLTERMS_NS_URI);
        PREFIX_TO_NS.put(SLREQ_PREFIX, SLREQ_NS_URI);
        PREFIX_TO_NS.put(XMLDSIG_PREFIX, "http://www.w3.org/2000/09/xmldsig#");
        NS_TO_PREFIX.put("", "");
        NS_TO_PREFIX.put("http://www.w3.org/XML/1998/namespace", "xml");
        NS_TO_PREFIX.put("http://www.w3.org/2000/xmlns/", "xmlns");
        NS_TO_PREFIX.put(RDF_NS_URI, RDF_PREFIX);
        NS_TO_PREFIX.put(DCTERMS_NS_URI, DCTERMS_PREFIX);
        NS_TO_PREFIX.put(SLTERMS_NS_URI, SLTERMS_PREFIX);
        NS_TO_PREFIX.put(SLREQ_NS_URI, SLREQ_PREFIX);
        NS_TO_PREFIX.put("http://www.w3.org/2000/09/xmldsig#", XMLDSIG_PREFIX);
    }
}

