/*
 * Decompiled with CFR 0.152.
 */
package eu.stratuslab.marketplace;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtils {
    private static final Integer DEFAULT_INDENT = 4;

    private XMLUtils() {
    }

    public static DocumentBuilder newDocumentBuilder() {
        return XMLUtils.newDocumentBuilder(true);
    }

    public static DocumentBuilder newDocumentBuilder(boolean validating) {
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            dbfac.setNamespaceAware(true);
            dbfac.setValidating(validating);
            return dbfac.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document newDocument() {
        DocumentBuilder db = XMLUtils.newDocumentBuilder();
        return db.newDocument();
    }

    public static Transformer newTransformer(boolean indented) {
        String indentFlag = indented ? "yes" : "no";
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", DEFAULT_INDENT);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", indentFlag);
            transformer.setOutputProperty("method", "xml");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String documentToString(Document doc) {
        return XMLUtils.documentToString(doc, false);
    }

    public static Document documentFromString(String xml) throws SAXException, IOException {
        StringReader reader = new StringReader(xml);
        InputSource source = new InputSource(reader);
        DocumentBuilder db = XMLUtils.newDocumentBuilder(false);
        return db.parse(source);
    }

    public static String documentToString(Document doc, boolean indented) {
        try {
            Transformer transformer = XMLUtils.newTransformer(indented);
            StringWriter sw = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }
}

