/*
 * Decompiled with CFR 0.152.
 */
package eu.stratuslab.marketplace.metadata;

import eu.stratuslab.marketplace.XMLUtils;
import eu.stratuslab.marketplace.metadata.MetadataException;
import eu.stratuslab.marketplace.metadata.MetadataUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.openrdf.OpenRDFException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.w3c.dom.Document;

public final class ValidateRDFModel {
    private ValidateRDFModel() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void validate(Document doc) {
        StringReader reader = null;
        try {
            Document copy = (Document)doc.cloneNode(true);
            MetadataUtils.stripSignatureElements(copy);
            String rdfEntry = XMLUtils.documentToString(copy);
            reader = new StringReader(rdfEntry);
            RDFParser rdfParser = Rio.createParser(RDFFormat.RDFXML);
            rdfParser.setRDFHandler(new RDFHandlerBase());
            rdfParser.parse(reader, "http://example.org/metadata");
        }
        catch (OpenRDFException e) {
            try {
                throw new MetadataException(e.getMessage());
                catch (IOException e2) {
                    throw new MetadataException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                ValidateRDFModel.closeReader(reader);
                throw throwable;
            }
        }
        ValidateRDFModel.closeReader(reader);
    }

    public static void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

