/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.util.Namespaces;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class ContextStatementCollector
extends RDFHandlerBase {
    private Collection<Statement> statements;
    private Map<String, String> namespaces;
    private Resource[] contexts;
    private ValueFactory vf;

    public ContextStatementCollector(ValueFactory vf, Resource ... contexts) {
        this(new ArrayList<Statement>(), vf, contexts);
    }

    public ContextStatementCollector(Collection<Statement> statements, ValueFactory vf, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.namespaces = statements instanceof Model ? Namespaces.wrap(((Model)statements).getNamespaces()) : new LinkedHashMap<String, String>();
        this.statements = statements;
        this.vf = vf;
        this.contexts = contexts;
    }

    public ContextStatementCollector(Collection<Statement> statements, Map<String, String> namespaces, ValueFactory vf, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.statements = statements;
        this.namespaces = namespaces;
        this.vf = vf;
        this.contexts = contexts;
    }

    public void clear() {
        this.statements.clear();
    }

    public Collection<Statement> getStatements() {
        return this.statements;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        if (!this.namespaces.containsKey(prefix)) {
            this.namespaces.put(prefix, uri);
        }
    }

    @Override
    public void handleStatement(Statement st) {
        if (this.contexts.length == 0) {
            this.statements.add(st);
        } else {
            for (Resource nextContext : this.contexts) {
                this.statements.add(this.vf.createStatement(st.getSubject(), st.getPredicate(), st.getObject(), nextContext));
            }
        }
    }
}

