/*
 * Decompiled with CFR 0.152.
 */
package eu.stratuslab.marketplace;

import eu.stratuslab.marketplace.X509Info;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class X509Utils {
    private X509Utils() {
    }

    public static KeyStore pkcs12ToKeyStore(File file, String password) throws FileNotFoundException {
        return X509Utils.pkcs12ToKeyStore(new FileInputStream(file), password);
    }

    public static KeyStore pkcs12ToKeyStore(InputStream is, String password) {
        try {
            char[] pwchars = password.toCharArray();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(is, pwchars);
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException consumed) {}
            }
        }
    }

    public static X509Info x509FromKeyStore(KeyStore keyStore, String password) {
        try {
            char[] pwchars = password.toCharArray();
            X509Certificate cert = null;
            Key key = null;
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                key = keyStore.getKey(alias, pwchars);
                if (!(key instanceof PrivateKey)) continue;
                cert = (X509Certificate)keyStore.getCertificate(alias);
            }
            return new X509Info(cert, (PrivateKey)key);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void signDocument(X509Info x509Info, Document doc) {
        try {
            doc.normalizeDocument();
            XMLSignatureFactory factory = X509Utils.newXMLSignatureFactory();
            SignedInfo si = X509Utils.newSignedInfo(factory);
            KeyInfoFactory kif = factory.getKeyInfoFactory();
            KeyPair kp = x509Info.getKeyPair();
            KeyInfo ki = x509Info.getKeyInfo(kif);
            DOMSignContext dsc = new DOMSignContext(kp.getPrivate(), (Node)doc.getDocumentElement());
            XMLSignature signature = factory.newXMLSignature(si, ki);
            signature.sign(dsc);
        }
        catch (MarshalException e) {
            throw new RuntimeException(e);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException(e);
        }
    }

    private static XMLSignatureFactory newXMLSignatureFactory() {
        return XMLSignatureFactory.getInstance("DOM");
    }

    private static SignedInfo newSignedInfo(XMLSignatureFactory factory) {
        try {
            DigestMethod method = factory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
            Transform transform = factory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
            List<Transform> transforms = Collections.singletonList(transform);
            Reference ref = factory.newReference("", method, transforms, null, null);
            List<Reference> refs = Collections.singletonList(ref);
            CanonicalizationMethod cmethod = factory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null);
            SignatureMethod smethod = factory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
            return factory.newSignedInfo(cmethod, smethod, refs);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
    }
}

