/*
 * Decompiled with CFR 0.152.
 */
package eu.stratuslab.marketplace.metadata;

import eu.stratuslab.marketplace.metadata.MetadataException;
import eu.stratuslab.marketplace.metadata.MetadataUtils;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ValidateXMLSignature {
    private ValidateXMLSignature() {
    }

    public static String validate(Document doc) {
        boolean isValid = true;
        Map<String, String> endorserInfo = ValidateXMLSignature.getEndorserInfo(doc);
        Node signature = ValidateXMLSignature.extractSignature(doc);
        Object[] result = MetadataUtils.isSignatureOK(endorserInfo, signature);
        isValid = (Boolean)result[0];
        String message = (String)result[1];
        if (isValid) {
            return message;
        }
        throw new MetadataException(message);
    }

    private static Map<String, String> getEndorserInfo(Document doc) {
        String[] names;
        HashMap<String, String> info = new HashMap<String, String>();
        for (String name : names = new String[]{"email", "subject", "issuer"}) {
            String value = ValidateXMLSignature.extractTextContent(doc, name);
            if (name == null) continue;
            info.put(name, value);
        }
        return info;
    }

    private static Node extractSignature(Document doc) {
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        Node node = null;
        if (nl.getLength() <= 0) {
            throw new MetadataException("no signature");
        }
        node = nl.item(0);
        return node;
    }

    private static String extractTextContent(Document doc, String name) {
        NodeList nl = doc.getElementsByTagNameNS("http://mp.stratuslab.eu/slreq#", name);
        if (nl.getLength() > 0) {
            return nl.item(0).getTextContent();
        }
        return null;
    }
}

