#
# Autogenerated by Thrift Compiler (0.9.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:new_style,slots
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException

from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class OffsetType(object):
  """
  Offset and OffsetType are used by Annotation to identify the
  portion of a ContentItem that a human labeled with a tag.
  """
  LINES = 0
  BYTES = 1
  CHARS = 2

  _VALUES_TO_NAMES = {
    0: "LINES",
    1: "BYTES",
    2: "CHARS",
  }

  _NAMES_TO_VALUES = {
    "LINES": 0,
    "BYTES": 1,
    "CHARS": 2,
  }

class EntityType(object):
  """
  Different tagging tools have different strings for labeling the
  various common entity types.  To avoid ambiguity, we define a
  canonical list here, which we will surely have to expand over time
  as new taggers recognize new types of entities.
  """
  PER = 0
  ORG = 1
  LOC = 2
  MALE_PRONOUN = 3
  FEMALE_PRONOUN = 4
  TIME = 5
  DATE = 6
  MONEY = 7
  PERCENT = 8
  MISC = 9
  GPE = 10
  FAC = 11
  VEH = 12
  WEA = 13
  phone = 14
  email = 15
  URL = 16

  _VALUES_TO_NAMES = {
    0: "PER",
    1: "ORG",
    2: "LOC",
    3: "MALE_PRONOUN",
    4: "FEMALE_PRONOUN",
    5: "TIME",
    6: "DATE",
    7: "MONEY",
    8: "PERCENT",
    9: "MISC",
    10: "GPE",
    11: "FAC",
    12: "VEH",
    13: "WEA",
    14: "phone",
    15: "email",
    16: "URL",
  }

  _NAMES_TO_VALUES = {
    "PER": 0,
    "ORG": 1,
    "LOC": 2,
    "MALE_PRONOUN": 3,
    "FEMALE_PRONOUN": 4,
    "TIME": 5,
    "DATE": 6,
    "MONEY": 7,
    "PERCENT": 8,
    "MISC": 9,
    "GPE": 10,
    "FAC": 11,
    "VEH": 12,
    "WEA": 13,
    "phone": 14,
    "email": 15,
    "URL": 16,
  }

class Versions(object):
  """
  Versions of this protocol are enumerated so that when we expand,
  everybody can see which version a particular data file used.

  v0_1_0 refers to the kba.thrift definition, which was before
  Versions was included in the spec.
  """
  v0_2_0 = 0

  _VALUES_TO_NAMES = {
    0: "v0_2_0",
  }

  _NAMES_TO_VALUES = {
    "v0_2_0": 0,
  }


class StreamTime(object):
  """
  StreamTime is a timestamp measured in seconds since the 1970 epoch.
  epoch_ticks is always in the UTC timezone.  This is used in several
  structs below to record various moments in history.

  Implementations of these interfaces in various languages may
  provide convenience methods for insuring that these two fields are
  consistent with each other.

  Attributes:
   - epoch_ticks
   - zulu_timestamp
  """

  __slots__ = [ 
    'epoch_ticks',
    'zulu_timestamp',
   ]

  thrift_spec = (
    None, # 0
    (1, TType.DOUBLE, 'epoch_ticks', None, None, ), # 1
    (2, TType.STRING, 'zulu_timestamp', None, None, ), # 2
  )

  def __init__(self, epoch_ticks=None, zulu_timestamp=None,):
    self.epoch_ticks = epoch_ticks
    self.zulu_timestamp = zulu_timestamp

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.DOUBLE:
          self.epoch_ticks = iprot.readDouble();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.zulu_timestamp = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('StreamTime')
    if self.epoch_ticks is not None:
      oprot.writeFieldBegin('epoch_ticks', TType.DOUBLE, 1)
      oprot.writeDouble(self.epoch_ticks)
      oprot.writeFieldEnd()
    if self.zulu_timestamp is not None:
      oprot.writeFieldBegin('zulu_timestamp', TType.STRING, 2)
      oprot.writeString(self.zulu_timestamp)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, getattr(self, key))
      for key in self.__slots__]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    if not isinstance(other, self.__class__):
      return False
    for attr in self.__slots__:
      my_val = getattr(self, attr)
      other_val = getattr(other, attr)
      if my_val != other_val:
        return False
    return True

  def __ne__(self, other):
    return not (self == other)


class Annotator(object):
  """
  An Annotator object describes a human (or possibly a set of humans)
  who generated the data stored in a Label or Rating object.

  Attributes:
   - annotator_id
   - annotation_time: Approximate time when annotations/judgments/labels was rendered
  by human.  If this is missing, it means that the time was not
  recorded, which often happens when the author made the
  annotation.
  """

  __slots__ = [ 
    'annotator_id',
    'annotation_time',
   ]

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'annotator_id', None, None, ), # 1
    (2, TType.STRUCT, 'annotation_time', (StreamTime, StreamTime.thrift_spec), None, ), # 2
  )

  def __init__(self, annotator_id=None, annotation_time=None,):
    self.annotator_id = annotator_id
    self.annotation_time = annotation_time

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.annotator_id = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.annotation_time = StreamTime()
          self.annotation_time.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Annotator')
    if self.annotator_id is not None:
      oprot.writeFieldBegin('annotator_id', TType.STRING, 1)
      oprot.writeString(self.annotator_id)
      oprot.writeFieldEnd()
    if self.annotation_time is not None:
      oprot.writeFieldBegin('annotation_time', TType.STRUCT, 2)
      self.annotation_time.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, getattr(self, key))
      for key in self.__slots__]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    if not isinstance(other, self.__class__):
      return False
    for attr in self.__slots__:
      my_val = getattr(self, attr)
      other_val = getattr(other, attr)
      if my_val != other_val:
        return False
    return True

  def __ne__(self, other):
    return not (self == other)


class Offset(object):
  """
  Offset specifies a range within a field of data in this ContentItem

  Attributes:
   - type: see comments on OffsetType
   - first: actual offset, which could be measured in bytes, chars, or lines.
  The data element identified by 'first' is included, and that
  identified by first+length is also included.

  In set notation,
      [first:first+length-1]

  or equivalently
      [first:first+length)

  or in list slicing, like python's:
      [first:first+length]

  While thrift treats these as signed integers, negative values are
  meaningless in this context, i.e. we do not end wrap.
   - length
   - xpath: if xpath is not empty, then annotation applies to an offset
  within data that starts with an XPATH query into XHTML or XML
   - content_form: name of the data element inside a ContentItem to which this label
  applies, e.g. 'raw' 'clean_html' or 'clean_visible'.  Defaults to
  clean_visible, which is the most common case.
   - value: bytes specified by this offset extracted from the original; just
  to assist in debugging
  """

  __slots__ = [ 
    'type',
    'first',
    'length',
    'xpath',
    'content_form',
    'value',
   ]

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'type', None, None, ), # 1
    (2, TType.I64, 'first', None, None, ), # 2
    (3, TType.I32, 'length', None, None, ), # 3
    (4, TType.STRING, 'xpath', None, None, ), # 4
    (5, TType.STRING, 'content_form', None, "clean_visible", ), # 5
    (6, TType.STRING, 'value', None, None, ), # 6
  )

  def __init__(self, type=None, first=None, length=None, xpath=None, content_form=thrift_spec[5][4], value=None,):
    self.type = type
    self.first = first
    self.length = length
    self.xpath = xpath
    self.content_form = content_form
    self.value = value

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.type = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I64:
          self.first = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I32:
          self.length = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.xpath = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.content_form = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRING:
          self.value = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Offset')
    if self.type is not None:
      oprot.writeFieldBegin('type', TType.I32, 1)
      oprot.writeI32(self.type)
      oprot.writeFieldEnd()
    if self.first is not None:
      oprot.writeFieldBegin('first', TType.I64, 2)
      oprot.writeI64(self.first)
      oprot.writeFieldEnd()
    if self.length is not None:
      oprot.writeFieldBegin('length', TType.I32, 3)
      oprot.writeI32(self.length)
      oprot.writeFieldEnd()
    if self.xpath is not None:
      oprot.writeFieldBegin('xpath', TType.STRING, 4)
      oprot.writeString(self.xpath)
      oprot.writeFieldEnd()
    if self.content_form is not None:
      oprot.writeFieldBegin('content_form', TType.STRING, 5)
      oprot.writeString(self.content_form)
      oprot.writeFieldEnd()
    if self.value is not None:
      oprot.writeFieldBegin('value', TType.STRING, 6)
      oprot.writeString(self.value)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, getattr(self, key))
      for key in self.__slots__]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    if not isinstance(other, self.__class__):
      return False
    for attr in self.__slots__:
      my_val = getattr(self, attr)
      other_val = getattr(other, attr)
      if my_val != other_val:
        return False
    return True

  def __ne__(self, other):
    return not (self == other)


class Target(object):
  """
  Targets are "informationt targets," such as entities or topics,
  usually from a knowledge base, such as Wikipedia.

  Attributes:
   - target_id: unique string identifier, usually a URL into Wikipedia, Freebase,
  or some other structured reference system for info targets.
   - kb_id: kb_id is usually redundant if the target_id is a full URL,
  e.g. en.wikipedia.org
   - kb_snapshot_time: moment in history that the target_kb was accessed
  """

  __slots__ = [ 
    'target_id',
    'kb_id',
    'kb_snapshot_time',
   ]

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'target_id', None, None, ), # 1
    (2, TType.STRING, 'kb_id', None, None, ), # 2
    (3, TType.STRUCT, 'kb_snapshot_time', (StreamTime, StreamTime.thrift_spec), None, ), # 3
  )

  def __init__(self, target_id=None, kb_id=None, kb_snapshot_time=None,):
    self.target_id = target_id
    self.kb_id = kb_id
    self.kb_snapshot_time = kb_snapshot_time

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.target_id = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.kb_id = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.kb_snapshot_time = StreamTime()
          self.kb_snapshot_time.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Target')
    if self.target_id is not None:
      oprot.writeFieldBegin('target_id', TType.STRING, 1)
      oprot.writeString(self.target_id)
      oprot.writeFieldEnd()
    if self.kb_id is not None:
      oprot.writeFieldBegin('kb_id', TType.STRING, 2)
      oprot.writeString(self.kb_id)
      oprot.writeFieldEnd()
    if self.kb_snapshot_time is not None:
      oprot.writeFieldBegin('kb_snapshot_time', TType.STRUCT, 3)
      self.kb_snapshot_time.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, getattr(self, key))
      for key in self.__slots__]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    if not isinstance(other, self.__class__):
      return False
    for attr in self.__slots__:
      my_val = getattr(self, attr)
      other_val = getattr(other, attr)
      if my_val != other_val:
        return False
    return True

  def __ne__(self, other):
    return not (self == other)


class Label(object):
  """
  Labels are human generated assertions about a portion of a document
  For example, a human author might label their own text by inserting
  hyperlinks to Wikipedia, or a NIST assessor might record which
  tokens in a text mention a target entity.

  Label instances can be attached in three palces:
   -  Token.labels  list
   -  Sentence.labels  list
   -  ContentItem.labels  map

  Attributes:
   - annotator: identifies the source of this Label
   - target: identifies the information need assessed by annotator
   - offsets: pointers to data to which this label applies.  If empty, then
  label applies to the entire Token, Sentence, or ContentItem to
  which it is attached.
  """

  __slots__ = [ 
    'annotator',
    'target',
    'offsets',
   ]

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'annotator', (Annotator, Annotator.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'target', (Target, Target.thrift_spec), None, ), # 2
    (3, TType.MAP, 'offsets', (TType.I32,None,TType.STRUCT,(Offset, Offset.thrift_spec)), {
    }, ), # 3
  )

  def __init__(self, annotator=None, target=None, offsets=thrift_spec[3][4],):
    self.annotator = annotator
    self.target = target
    if offsets is self.thrift_spec[3][4]:
      offsets = {
    }
    self.offsets = offsets

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.annotator = Annotator()
          self.annotator.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.target = Target()
          self.target.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.offsets = {}
          (_ktype1, _vtype2, _size0 ) = iprot.readMapBegin() 
          for _i4 in xrange(_size0):
            _key5 = iprot.readI32();
            _val6 = Offset()
            _val6.read(iprot)
            self.offsets[_key5] = _val6
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Label')
    if self.annotator is not None:
      oprot.writeFieldBegin('annotator', TType.STRUCT, 1)
      self.annotator.write(oprot)
      oprot.writeFieldEnd()
    if self.target is not None:
      oprot.writeFieldBegin('target', TType.STRUCT, 2)
      self.target.write(oprot)
      oprot.writeFieldEnd()
    if self.offsets is not None:
      oprot.writeFieldBegin('offsets', TType.MAP, 3)
      oprot.writeMapBegin(TType.I32, TType.STRUCT, len(self.offsets))
      for kiter7,viter8 in self.offsets.items():
        oprot.writeI32(kiter7)
        viter8.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, getattr(self, key))
      for key in self.__slots__]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    if not isinstance(other, self.__class__):
      return False
    for attr in self.__slots__:
      my_val = getattr(self, attr)
      other_val = getattr(other, attr)
      if my_val != other_val:
        return False
    return True

  def __ne__(self, other):
    return not (self == other)


class Token(object):
  """
  Textual tokens identified by an NLP pipeline and marked up with
  metadata from automatic taggers and possibly also Labels from
  humans.

  Attributes:
   - token_num: zero-based index into the stream of tokens from a document
   - token: actual token string, must always be a UTF8 encoded string, not a
  unicode string, because thrift stores them as 8-bit.
   - offsets: offsets into the original data (see Offset.content_form)
   - sentence_pos: zero-based index into the sentence, which is used for dependency
  parsed data
   - lemma: lemmatization of the token, again must be UTF8
   - pos: part of speech labels defined by Penn TreeBank:
  http://www.ling.upenn.edu/courses/Fall_2003/ling001/penn_treebank_pos.html
  Should probably convert this to an enum, analogous to EntityType
   - entity_type: entity type from named entity recognizer (classifier)
   - mention_id: Identifier for a each mention in a sentence.  Must be zero-based
  within each sentence, so is not unique at the document level.
  Serves two purposes:

    1) Distinguishing multi-token mention.  Needed when the
    entity_type and equiv_id do not change between tokens that are
    part of separate mentions, e.g. "The senator is known to his
    friends as David, Davy, Zeus, and Mr. Elephant."

    2) Refering to mentions used in Relation objects.  Used in
    conjunction with sentence_id
   - equiv_id: Within-doc coref chain ID.  That is, identifier of equivalence
  class of co-referent tokens.  Default is -1, meaning None.
   - parent_id: parent sentence_pos in dependency parse. Default is -1, ie None
   - dependency_path: grammatical relation label on path to parent in dependency parse,
  defined by whatever tagger was used -- should pick a canonical
  definition here and convert it to an enum.
   - labels: Labels attached to this token, defaults to an empty map
  """

  __slots__ = [ 
    'token_num',
    'token',
    'offsets',
    'sentence_pos',
    'lemma',
    'pos',
    'entity_type',
    'mention_id',
    'equiv_id',
    'parent_id',
    'dependency_path',
    'labels',
   ]

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'token_num', None, None, ), # 1
    (2, TType.STRING, 'token', None, None, ), # 2
    (3, TType.MAP, 'offsets', (TType.I32,None,TType.STRUCT,(Offset, Offset.thrift_spec)), {
    }, ), # 3
    (4, TType.I32, 'sentence_pos', None, -1, ), # 4
    (5, TType.STRING, 'lemma', None, None, ), # 5
    (6, TType.STRING, 'pos', None, None, ), # 6
    (7, TType.I32, 'entity_type', None, None, ), # 7
    (8, TType.I16, 'mention_id', None, -1, ), # 8
    (9, TType.I32, 'equiv_id', None, -1, ), # 9
    (10, TType.I32, 'parent_id', None, -1, ), # 10
    (11, TType.STRING, 'dependency_path', None, None, ), # 11
    (12, TType.MAP, 'labels', (TType.STRING,None,TType.LIST,(TType.STRUCT,(Label, Label.thrift_spec))), {
    }, ), # 12
  )

  def __init__(self, token_num=None, token=None, offsets=thrift_spec[3][4], sentence_pos=thrift_spec[4][4], lemma=None, pos=None, entity_type=None, mention_id=thrift_spec[8][4], equiv_id=thrift_spec[9][4], parent_id=thrift_spec[10][4], dependency_path=None, labels=thrift_spec[12][4],):
    self.token_num = token_num
    self.token = token
    if offsets is self.thrift_spec[3][4]:
      offsets = {
    }
    self.offsets = offsets
    self.sentence_pos = sentence_pos
    self.lemma = lemma
    self.pos = pos
    self.entity_type = entity_type
    if mention_id is self.thrift_spec[8][4]:
      mention_id = -1
    self.mention_id = mention_id
    self.equiv_id = equiv_id
    self.parent_id = parent_id
    self.dependency_path = dependency_path
    if labels is self.thrift_spec[12][4]:
      labels = {
    }
    self.labels = labels

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.token_num = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.token = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.offsets = {}
          (_ktype10, _vtype11, _size9 ) = iprot.readMapBegin() 
          for _i13 in xrange(_size9):
            _key14 = iprot.readI32();
            _val15 = Offset()
            _val15.read(iprot)
            self.offsets[_key14] = _val15
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.sentence_pos = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.lemma = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRING:
          self.pos = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.I32:
          self.entity_type = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.I16:
          self.mention_id = iprot.readI16();
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.I32:
          self.equiv_id = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.I32:
          self.parent_id = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.STRING:
          self.dependency_path = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.MAP:
          self.labels = {}
          (_ktype17, _vtype18, _size16 ) = iprot.readMapBegin() 
          for _i20 in xrange(_size16):
            _key21 = iprot.readString();
            _val22 = []
            (_etype26, _size23) = iprot.readListBegin()
            for _i27 in xrange(_size23):
              _elem28 = Label()
              _elem28.read(iprot)
              _val22.append(_elem28)
            iprot.readListEnd()
            self.labels[_key21] = _val22
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Token')
    if self.token_num is not None:
      oprot.writeFieldBegin('token_num', TType.I32, 1)
      oprot.writeI32(self.token_num)
      oprot.writeFieldEnd()
    if self.token is not None:
      oprot.writeFieldBegin('token', TType.STRING, 2)
      oprot.writeString(self.token)
      oprot.writeFieldEnd()
    if self.offsets is not None:
      oprot.writeFieldBegin('offsets', TType.MAP, 3)
      oprot.writeMapBegin(TType.I32, TType.STRUCT, len(self.offsets))
      for kiter29,viter30 in self.offsets.items():
        oprot.writeI32(kiter29)
        viter30.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.sentence_pos is not None:
      oprot.writeFieldBegin('sentence_pos', TType.I32, 4)
      oprot.writeI32(self.sentence_pos)
      oprot.writeFieldEnd()
    if self.lemma is not None:
      oprot.writeFieldBegin('lemma', TType.STRING, 5)
      oprot.writeString(self.lemma)
      oprot.writeFieldEnd()
    if self.pos is not None:
      oprot.writeFieldBegin('pos', TType.STRING, 6)
      oprot.writeString(self.pos)
      oprot.writeFieldEnd()
    if self.entity_type is not None:
      oprot.writeFieldBegin('entity_type', TType.I32, 7)
      oprot.writeI32(self.entity_type)
      oprot.writeFieldEnd()
    if self.mention_id is not None:
      oprot.writeFieldBegin('mention_id', TType.I16, 8)
      oprot.writeI16(self.mention_id)
      oprot.writeFieldEnd()
    if self.equiv_id is not None:
      oprot.writeFieldBegin('equiv_id', TType.I32, 9)
      oprot.writeI32(self.equiv_id)
      oprot.writeFieldEnd()
    if self.parent_id is not None:
      oprot.writeFieldBegin('parent_id', TType.I32, 10)
      oprot.writeI32(self.parent_id)
      oprot.writeFieldEnd()
    if self.dependency_path is not None:
      oprot.writeFieldBegin('dependency_path', TType.STRING, 11)
      oprot.writeString(self.dependency_path)
      oprot.writeFieldEnd()
    if self.labels is not None:
      oprot.writeFieldBegin('labels', TType.MAP, 12)
      oprot.writeMapBegin(TType.STRING, TType.LIST, len(self.labels))
      for kiter31,viter32 in self.labels.items():
        oprot.writeString(kiter31)
        oprot.writeListBegin(TType.STRUCT, len(viter32))
        for iter33 in viter32:
          iter33.write(oprot)
        oprot.writeListEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, getattr(self, key))
      for key in self.__slots__]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    if not isinstance(other, self.__class__):
      return False
    for attr in self.__slots__:
      my_val = getattr(self, attr)
      other_val = getattr(other, attr)
      if my_val != other_val:
        return False
    return True

  def __ne__(self, other):
    return not (self == other)


class Sentence(object):
  """
  Attributes:
   - tokens: tokens in this sentence
   - labels: array of instances of Label attached to this sentence, defaults to
  an empty map
  """

  __slots__ = [ 
    'tokens',
    'labels',
   ]

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'tokens', (TType.STRUCT,(Token, Token.thrift_spec)), [
    ], ), # 1
    (2, TType.MAP, 'labels', (TType.STRING,None,TType.LIST,(TType.STRUCT,(Label, Label.thrift_spec))), {
    }, ), # 2
  )

  def __init__(self, tokens=thrift_spec[1][4], labels=thrift_spec[2][4],):
    if tokens is self.thrift_spec[1][4]:
      tokens = [
    ]
    self.tokens = tokens
    if labels is self.thrift_spec[2][4]:
      labels = {
    }
    self.labels = labels

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.tokens = []
          (_etype37, _size34) = iprot.readListBegin()
          for _i38 in xrange(_size34):
            _elem39 = Token()
            _elem39.read(iprot)
            self.tokens.append(_elem39)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.MAP:
          self.labels = {}
          (_ktype41, _vtype42, _size40 ) = iprot.readMapBegin() 
          for _i44 in xrange(_size40):
            _key45 = iprot.readString();
            _val46 = []
            (_etype50, _size47) = iprot.readListBegin()
            for _i51 in xrange(_size47):
              _elem52 = Label()
              _elem52.read(iprot)
              _val46.append(_elem52)
            iprot.readListEnd()
            self.labels[_key45] = _val46
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Sentence')
    if self.tokens is not None:
      oprot.writeFieldBegin('tokens', TType.LIST, 1)
      oprot.writeListBegin(TType.STRUCT, len(self.tokens))
      for iter53 in self.tokens:
        iter53.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.labels is not None:
      oprot.writeFieldBegin('labels', TType.MAP, 2)
      oprot.writeMapBegin(TType.STRING, TType.LIST, len(self.labels))
      for kiter54,viter55 in self.labels.items():
        oprot.writeString(kiter54)
        oprot.writeListBegin(TType.STRUCT, len(viter55))
        for iter56 in viter55:
          iter56.write(oprot)
        oprot.writeListEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, getattr(self, key))
      for key in self.__slots__]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    if not isinstance(other, self.__class__):
      return False
    for attr in self.__slots__:
      my_val = getattr(self, attr)
      other_val = getattr(other, attr)
      if my_val != other_val:
        return False
    return True

  def __ne__(self, other):
    return not (self == other)


class Tagging(object):
  """
  Attributes:
   - tagger_id
   - raw_tagging: raw output of the tagging tool
   - tagger_config: short human-readable description of configuration parameters
   - tagger_version: short human-readable version string of the tagging tool
   - generation_time: time that tagging was generated
  """

  __slots__ = [ 
    'tagger_id',
    'raw_tagging',
    'tagger_config',
    'tagger_version',
    'generation_time',
   ]

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tagger_id', None, None, ), # 1
    (2, TType.STRING, 'raw_tagging', None, None, ), # 2
    (3, TType.STRING, 'tagger_config', None, None, ), # 3
    (4, TType.STRING, 'tagger_version', None, None, ), # 4
    (5, TType.STRUCT, 'generation_time', (StreamTime, StreamTime.thrift_spec), None, ), # 5
  )

  def __init__(self, tagger_id=None, raw_tagging=None, tagger_config=None, tagger_version=None, generation_time=None,):
    self.tagger_id = tagger_id
    self.raw_tagging = raw_tagging
    self.tagger_config = tagger_config
    self.tagger_version = tagger_version
    self.generation_time = generation_time

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tagger_id = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.raw_tagging = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.tagger_config = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.tagger_version = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRUCT:
          self.generation_time = StreamTime()
          self.generation_time.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Tagging')
    if self.tagger_id is not None:
      oprot.writeFieldBegin('tagger_id', TType.STRING, 1)
      oprot.writeString(self.tagger_id)
      oprot.writeFieldEnd()
    if self.raw_tagging is not None:
      oprot.writeFieldBegin('raw_tagging', TType.STRING, 2)
      oprot.writeString(self.raw_tagging)
      oprot.writeFieldEnd()
    if self.tagger_config is not None:
      oprot.writeFieldBegin('tagger_config', TType.STRING, 3)
      oprot.writeString(self.tagger_config)
      oprot.writeFieldEnd()
    if self.tagger_version is not None:
      oprot.writeFieldBegin('tagger_version', TType.STRING, 4)
      oprot.writeString(self.tagger_version)
      oprot.writeFieldEnd()
    if self.generation_time is not None:
      oprot.writeFieldBegin('generation_time', TType.STRUCT, 5)
      self.generation_time.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, getattr(self, key))
      for key in self.__slots__]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    if not isinstance(other, self.__class__):
      return False
    for attr in self.__slots__:
      my_val = getattr(self, attr)
      other_val = getattr(other, attr)
      if my_val != other_val:
        return False
    return True

  def __ne__(self, other):
    return not (self == other)


class Relation(object):
  """
  Description of a relation between two entities that a tagger
  discovered in the text.

  Attributes:
   - relation_name:    * A string describing the relation.  We may convert these to an
     * enumeration, which would then be called relation_type
     *
     * Here is a list of ACE relation (and event) types that might
     * appear in relation_name
     * http://projects.ldc.upenn.edu/ace/docs/English-Events-Guidelines_v5.4.3.pdf

  PHYS.Located
  PHYS.Near
  PART-WHOLE.Geographical
  PART-WHOLE.Subsidiary
  PART-WHOLE.Artifact
  PER-SOC.Business
  PER-SOC.Family
  PER-SOC.Lasting-Personal
  ORG-AFF.Employment
  ORG-AFF.Ownership
  ORG-AFF.Founder
  ORG-AFF.Student-Alum
  ORG-AFF.Sports-Affiliation
  ORG-AFF.Investor-Shareholder
  ORG-AFF.Membership
  ART.User-Owner-Inventor-Manufacturer
  GEN-AFF.Citizen-Resident-Religion-Ethnicity
  GEN-AFF.Org-Location


  Business.Declare-Bankruptcy
  Business.End-Org
  Business.Merge-Org
  Business.Start-Org
  Conflict.Attack
  Conflict.Demonstrate
  Contact.Phone-Write
  Contact.Meet
  Justice.Acquit
  Justice.Appeal
  Justice.Arrest-Jail
  Justice.Charge-Indict
  Justice.Convict
  Justice.Execute
  Justice.Extradite
  Justice.Fine
  Justice.Pardon
  Justice.Release-Parole
  Justice.Sentence
  Justice.Sue
  Justice.Trial-Hearing
  Life.Be-Born
  Life.Die
  Life.Divorce
  Life.Injure
  Life.Marry
  Movement.Transport
  Personnel.Elect
  Personnel.End-Position
  Personnel.Nominate
  Personnel.Start-Position
  Transaction.Transfer-Money
  Transaction.Transfer-Ownership

   - sentence_id_1: Zero-based index into the sentences array for this TaggerID
   - mention_id_1: Zero-based index into the mentions in that sentence.  This
  identifies the origin of the relation.  For example, the relation
     (Bob, PHYS.Located, Chicago)
  would have mention_id_1 point to Bob.
   - sentence_id_2: Zero-based index into the sentences array for this TaggerID
   - mention_id_2: Zero-based index into the mentions in that sentence. This
  identifies the origin of the relation.  For example, the relation
     (Bob, PHYS.Located, Chicago)
  would have mention_id_2 point to Chicago.
  """

  __slots__ = [ 
    'relation_name',
    'sentence_id_1',
    'mention_id_1',
    'sentence_id_2',
    'mention_id_2',
   ]

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'relation_name', None, None, ), # 1
    (2, TType.I32, 'sentence_id_1', None, None, ), # 2
    (3, TType.I16, 'mention_id_1', None, None, ), # 3
    (4, TType.I32, 'sentence_id_2', None, None, ), # 4
    (5, TType.I16, 'mention_id_2', None, None, ), # 5
  )

  def __init__(self, relation_name=None, sentence_id_1=None, mention_id_1=None, sentence_id_2=None, mention_id_2=None,):
    self.relation_name = relation_name
    self.sentence_id_1 = sentence_id_1
    self.mention_id_1 = mention_id_1
    self.sentence_id_2 = sentence_id_2
    self.mention_id_2 = mention_id_2

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.relation_name = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.sentence_id_1 = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I16:
          self.mention_id_1 = iprot.readI16();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.sentence_id_2 = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I16:
          self.mention_id_2 = iprot.readI16();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Relation')
    if self.relation_name is not None:
      oprot.writeFieldBegin('relation_name', TType.STRING, 1)
      oprot.writeString(self.relation_name)
      oprot.writeFieldEnd()
    if self.sentence_id_1 is not None:
      oprot.writeFieldBegin('sentence_id_1', TType.I32, 2)
      oprot.writeI32(self.sentence_id_1)
      oprot.writeFieldEnd()
    if self.mention_id_1 is not None:
      oprot.writeFieldBegin('mention_id_1', TType.I16, 3)
      oprot.writeI16(self.mention_id_1)
      oprot.writeFieldEnd()
    if self.sentence_id_2 is not None:
      oprot.writeFieldBegin('sentence_id_2', TType.I32, 4)
      oprot.writeI32(self.sentence_id_2)
      oprot.writeFieldEnd()
    if self.mention_id_2 is not None:
      oprot.writeFieldBegin('mention_id_2', TType.I16, 5)
      oprot.writeI16(self.mention_id_2)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, getattr(self, key))
      for key in self.__slots__]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    if not isinstance(other, self.__class__):
      return False
    for attr in self.__slots__:
      my_val = getattr(self, attr)
      other_val = getattr(other, attr)
      if my_val != other_val:
        return False
    return True

  def __ne__(self, other):
    return not (self == other)


class Language(object):
  """
  Description of a natural language used in text

  Attributes:
   - code: two letter code for the language
   - name
  """

  __slots__ = [ 
    'code',
    'name',
   ]

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'code', None, None, ), # 1
    (2, TType.STRING, 'name', None, None, ), # 2
  )

  def __init__(self, code=None, name=None,):
    self.code = code
    self.name = name

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.code = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.name = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Language')
    if self.code is not None:
      oprot.writeFieldBegin('code', TType.STRING, 1)
      oprot.writeString(self.code)
      oprot.writeFieldEnd()
    if self.name is not None:
      oprot.writeFieldBegin('name', TType.STRING, 2)
      oprot.writeString(self.name)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, getattr(self, key))
      for key in self.__slots__]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    if not isinstance(other, self.__class__):
      return False
    for attr in self.__slots__:
      my_val = getattr(self, attr)
      other_val = getattr(other, attr)
      if my_val != other_val:
        return False
    return True

  def __ne__(self, other):
    return not (self == other)


class ContentItem(object):
  """
  ContentItem contains raw data, an indication of its character
  encoding, and various transformed versions of the raw data.

  Attributes:
   - raw: original download, raw byte array
   - encoding: guessed from raw and/or headers, e.g. by python-requests.org
   - media_type: Content-type header from fetching the data, or MIME type
   - clean_html: HTML-formatted version of raw with UTF8 encoding and no broken
  tags.  All HTML-escaped characters are converted to their UTF8
  equivalents.  < > & are escaped.
   - clean_visible: All tags stripped from clean_html and replaced with whitespace,
  so they have the same byte offsets.  The only escaped characters
  are < > &, so that this can be treated as Character Data in XML:
  http://www.w3.org/TR/xml/#syntax

  Again: must be UTF8
   - logs: Logs generated from processing pipeline, for forensics
   - taggings: A set of auto-generated taggings, such as a One-Word-Per-Line
  (OWLP) tokenization and sentence chunking with part-of-speech,
  lemmatization, and NER classification.  The string name should be
  the same as the tagger_id and also corresponds to the key in
  sentences or sentence_blobs, which get generated by transforming
  a Tagging.raw_tagging into Sentence and Token instances

  Taggings are generated from 'clean_visible' so offsets (byte,
  char, line) refer to clean_visible and clean_html -- not raw.
   - labels: sets of annotations
   - sentences: parsed Sentence objects generated by an NLP pipeline identified
  by the string name, which is a tagger_id that connects this
  Sentences instance to the Tagging struct from which it came
   - sentence_blobs: same as 'sentences' except the array of Sentence instances are
  serialized into a binary string that can be read by the Thrift's
  binary protocol.  This allows lazy deserialization via an
  iterator -- one sentence at a time.  This might be totally
  unnecessary, because at least some of the Thrift language
  implementations have lazy object construction, e.g. --gen
  py:dynamic,slots
   - language: indication of which natural language is used in the text
   - relations: List of relations discovered in clean_visible
  """

  __slots__ = [ 
    'raw',
    'encoding',
    'media_type',
    'clean_html',
    'clean_visible',
    'logs',
    'taggings',
    'labels',
    'sentences',
    'sentence_blobs',
    'language',
    'relations',
   ]

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'raw', None, None, ), # 1
    (2, TType.STRING, 'encoding', None, None, ), # 2
    (3, TType.STRING, 'media_type', None, None, ), # 3
    (4, TType.STRING, 'clean_html', None, None, ), # 4
    (5, TType.STRING, 'clean_visible', None, None, ), # 5
    (6, TType.LIST, 'logs', (TType.STRING,None), [
    ], ), # 6
    (7, TType.MAP, 'taggings', (TType.STRING,None,TType.STRUCT,(Tagging, Tagging.thrift_spec)), {
    }, ), # 7
    (8, TType.MAP, 'labels', (TType.STRING,None,TType.LIST,(TType.STRUCT,(Label, Label.thrift_spec))), {
    }, ), # 8
    (9, TType.MAP, 'sentences', (TType.STRING,None,TType.LIST,(TType.STRUCT,(Sentence, Sentence.thrift_spec))), {
    }, ), # 9
    (10, TType.MAP, 'sentence_blobs', (TType.STRING,None,TType.STRING,None), {
    }, ), # 10
    (11, TType.STRUCT, 'language', (Language, Language.thrift_spec), None, ), # 11
    (12, TType.MAP, 'relations', (TType.STRING,None,TType.LIST,(TType.STRUCT,(Relation, Relation.thrift_spec))), {
    }, ), # 12
  )

  def __init__(self, raw=None, encoding=None, media_type=None, clean_html=None, clean_visible=None, logs=thrift_spec[6][4], taggings=thrift_spec[7][4], labels=thrift_spec[8][4], sentences=thrift_spec[9][4], sentence_blobs=thrift_spec[10][4], language=None, relations=thrift_spec[12][4],):
    self.raw = raw
    self.encoding = encoding
    self.media_type = media_type
    self.clean_html = clean_html
    self.clean_visible = clean_visible
    if logs is self.thrift_spec[6][4]:
      logs = [
    ]
    self.logs = logs
    if taggings is self.thrift_spec[7][4]:
      taggings = {
    }
    self.taggings = taggings
    if labels is self.thrift_spec[8][4]:
      labels = {
    }
    self.labels = labels
    if sentences is self.thrift_spec[9][4]:
      sentences = {
    }
    self.sentences = sentences
    if sentence_blobs is self.thrift_spec[10][4]:
      sentence_blobs = {
    }
    self.sentence_blobs = sentence_blobs
    self.language = language
    if relations is self.thrift_spec[12][4]:
      relations = {
    }
    self.relations = relations

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.raw = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.encoding = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.media_type = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.clean_html = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.clean_visible = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.LIST:
          self.logs = []
          (_etype60, _size57) = iprot.readListBegin()
          for _i61 in xrange(_size57):
            _elem62 = iprot.readString();
            self.logs.append(_elem62)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.MAP:
          self.taggings = {}
          (_ktype64, _vtype65, _size63 ) = iprot.readMapBegin() 
          for _i67 in xrange(_size63):
            _key68 = iprot.readString();
            _val69 = Tagging()
            _val69.read(iprot)
            self.taggings[_key68] = _val69
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.MAP:
          self.labels = {}
          (_ktype71, _vtype72, _size70 ) = iprot.readMapBegin() 
          for _i74 in xrange(_size70):
            _key75 = iprot.readString();
            _val76 = []
            (_etype80, _size77) = iprot.readListBegin()
            for _i81 in xrange(_size77):
              _elem82 = Label()
              _elem82.read(iprot)
              _val76.append(_elem82)
            iprot.readListEnd()
            self.labels[_key75] = _val76
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.MAP:
          self.sentences = {}
          (_ktype84, _vtype85, _size83 ) = iprot.readMapBegin() 
          for _i87 in xrange(_size83):
            _key88 = iprot.readString();
            _val89 = []
            (_etype93, _size90) = iprot.readListBegin()
            for _i94 in xrange(_size90):
              _elem95 = Sentence()
              _elem95.read(iprot)
              _val89.append(_elem95)
            iprot.readListEnd()
            self.sentences[_key88] = _val89
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.MAP:
          self.sentence_blobs = {}
          (_ktype97, _vtype98, _size96 ) = iprot.readMapBegin() 
          for _i100 in xrange(_size96):
            _key101 = iprot.readString();
            _val102 = iprot.readString();
            self.sentence_blobs[_key101] = _val102
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.STRUCT:
          self.language = Language()
          self.language.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.MAP:
          self.relations = {}
          (_ktype104, _vtype105, _size103 ) = iprot.readMapBegin() 
          for _i107 in xrange(_size103):
            _key108 = iprot.readString();
            _val109 = []
            (_etype113, _size110) = iprot.readListBegin()
            for _i114 in xrange(_size110):
              _elem115 = Relation()
              _elem115.read(iprot)
              _val109.append(_elem115)
            iprot.readListEnd()
            self.relations[_key108] = _val109
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('ContentItem')
    if self.raw is not None:
      oprot.writeFieldBegin('raw', TType.STRING, 1)
      oprot.writeString(self.raw)
      oprot.writeFieldEnd()
    if self.encoding is not None:
      oprot.writeFieldBegin('encoding', TType.STRING, 2)
      oprot.writeString(self.encoding)
      oprot.writeFieldEnd()
    if self.media_type is not None:
      oprot.writeFieldBegin('media_type', TType.STRING, 3)
      oprot.writeString(self.media_type)
      oprot.writeFieldEnd()
    if self.clean_html is not None:
      oprot.writeFieldBegin('clean_html', TType.STRING, 4)
      oprot.writeString(self.clean_html)
      oprot.writeFieldEnd()
    if self.clean_visible is not None:
      oprot.writeFieldBegin('clean_visible', TType.STRING, 5)
      oprot.writeString(self.clean_visible)
      oprot.writeFieldEnd()
    if self.logs is not None:
      oprot.writeFieldBegin('logs', TType.LIST, 6)
      oprot.writeListBegin(TType.STRING, len(self.logs))
      for iter116 in self.logs:
        oprot.writeString(iter116)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.taggings is not None:
      oprot.writeFieldBegin('taggings', TType.MAP, 7)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.taggings))
      for kiter117,viter118 in self.taggings.items():
        oprot.writeString(kiter117)
        viter118.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.labels is not None:
      oprot.writeFieldBegin('labels', TType.MAP, 8)
      oprot.writeMapBegin(TType.STRING, TType.LIST, len(self.labels))
      for kiter119,viter120 in self.labels.items():
        oprot.writeString(kiter119)
        oprot.writeListBegin(TType.STRUCT, len(viter120))
        for iter121 in viter120:
          iter121.write(oprot)
        oprot.writeListEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.sentences is not None:
      oprot.writeFieldBegin('sentences', TType.MAP, 9)
      oprot.writeMapBegin(TType.STRING, TType.LIST, len(self.sentences))
      for kiter122,viter123 in self.sentences.items():
        oprot.writeString(kiter122)
        oprot.writeListBegin(TType.STRUCT, len(viter123))
        for iter124 in viter123:
          iter124.write(oprot)
        oprot.writeListEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.sentence_blobs is not None:
      oprot.writeFieldBegin('sentence_blobs', TType.MAP, 10)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.sentence_blobs))
      for kiter125,viter126 in self.sentence_blobs.items():
        oprot.writeString(kiter125)
        oprot.writeString(viter126)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.language is not None:
      oprot.writeFieldBegin('language', TType.STRUCT, 11)
      self.language.write(oprot)
      oprot.writeFieldEnd()
    if self.relations is not None:
      oprot.writeFieldBegin('relations', TType.MAP, 12)
      oprot.writeMapBegin(TType.STRING, TType.LIST, len(self.relations))
      for kiter127,viter128 in self.relations.items():
        oprot.writeString(kiter127)
        oprot.writeListBegin(TType.STRUCT, len(viter128))
        for iter129 in viter128:
          iter129.write(oprot)
        oprot.writeListEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, getattr(self, key))
      for key in self.__slots__]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    if not isinstance(other, self.__class__):
      return False
    for attr in self.__slots__:
      my_val = getattr(self, attr)
      other_val = getattr(other, attr)
      if my_val != other_val:
        return False
    return True

  def __ne__(self, other):
    return not (self == other)


class Rating(object):
  """
  Ratings are buman generated assertions about a entire document's
  utility for a particular topic or entity in a reference KB.

  Attributes:
   - annotator: identifies the source of this Rating
   - target: identifies the information need assessed by annotator
   - relevance: numerical score assigned by annotator to "judge" or "rate" the
  utility of this StreamItem to addressing the target information
  need.  The range and interpretation of relevance numbers depends
  on the annotator.  relevance can represent a rank ordering or an
  enumeration such as -1=Garbage, 0=Neutral, 1=Useful, 2=Vital
   - contains_mention: true|false indication of whether the document mentions the target
  entity.  This is only partially correlated with relevance.  For
  example, a document might mention the entity only in chrome text
  on the side such that it is a Garbage-rated text for that entity.
   - comments: Save notes from Annotator about this Rating
   - mentions: Record strings that are "mentions" of the target in this text
  """

  __slots__ = [ 
    'annotator',
    'target',
    'relevance',
    'contains_mention',
    'comments',
    'mentions',
   ]

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'annotator', (Annotator, Annotator.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'target', (Target, Target.thrift_spec), None, ), # 2
    (3, TType.I16, 'relevance', None, None, ), # 3
    (4, TType.BOOL, 'contains_mention', None, None, ), # 4
    (5, TType.STRING, 'comments', None, None, ), # 5
    (6, TType.LIST, 'mentions', (TType.STRING,None), None, ), # 6
  )

  def __init__(self, annotator=None, target=None, relevance=None, contains_mention=None, comments=None, mentions=None,):
    self.annotator = annotator
    self.target = target
    self.relevance = relevance
    self.contains_mention = contains_mention
    self.comments = comments
    self.mentions = mentions

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.annotator = Annotator()
          self.annotator.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.target = Target()
          self.target.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I16:
          self.relevance = iprot.readI16();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.BOOL:
          self.contains_mention = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.comments = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.LIST:
          self.mentions = []
          (_etype133, _size130) = iprot.readListBegin()
          for _i134 in xrange(_size130):
            _elem135 = iprot.readString();
            self.mentions.append(_elem135)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('Rating')
    if self.annotator is not None:
      oprot.writeFieldBegin('annotator', TType.STRUCT, 1)
      self.annotator.write(oprot)
      oprot.writeFieldEnd()
    if self.target is not None:
      oprot.writeFieldBegin('target', TType.STRUCT, 2)
      self.target.write(oprot)
      oprot.writeFieldEnd()
    if self.relevance is not None:
      oprot.writeFieldBegin('relevance', TType.I16, 3)
      oprot.writeI16(self.relevance)
      oprot.writeFieldEnd()
    if self.contains_mention is not None:
      oprot.writeFieldBegin('contains_mention', TType.BOOL, 4)
      oprot.writeBool(self.contains_mention)
      oprot.writeFieldEnd()
    if self.comments is not None:
      oprot.writeFieldBegin('comments', TType.STRING, 5)
      oprot.writeString(self.comments)
      oprot.writeFieldEnd()
    if self.mentions is not None:
      oprot.writeFieldBegin('mentions', TType.LIST, 6)
      oprot.writeListBegin(TType.STRING, len(self.mentions))
      for iter136 in self.mentions:
        oprot.writeString(iter136)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, getattr(self, key))
      for key in self.__slots__]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    if not isinstance(other, self.__class__):
      return False
    for attr in self.__slots__:
      my_val = getattr(self, attr)
      other_val = getattr(other, attr)
      if my_val != other_val:
        return False
    return True

  def __ne__(self, other):
    return not (self == other)


class StreamItem(object):
  """
  This is the primary interface to the corpus data.  It is called
  StreamItem rather than CorpusItem and has a required StreamTime
  attribute, because even for a static corpus, each document was
  captured at a particular time in Earth history and might have been
  different if captured earlier or later.  All corpora are stream
  corpora, even if they were not explicitly created as such.

  stream_id is the unique identifier for documents in the corpus.

  This is similar to the StreamItem defined in kba.thrift for TREC
  KBA 2012, however it removes the 'title' and 'anchor' fields, which
  can now be represented in other_content.  This means that code that
  was written to read messages from kba.thrift must be updated.

  Attributes:
   - version: must provide a version number here
   - doc_id: md5 hash of the abs_url
   - abs_url: normalized form of the original_url, should be a valid URL
   - schost: scheme://hostname parsed from abs_url
   - original_url: string obtain from some source.  Only present if not a valid URL,
  in which case abs_url was derived from original_url
   - source: string uniquely identifying this data set, should start with a
  year string, such as 'news' or 'social'
   - body: primary content
   - source_metadata: see above for explanation of the values that can appear in this
  dictionary of metadata info from the source.  The string keys in
  this map should be short, descriptive, and free of whitespace.
   - stream_id: stream_id is actual unique identifier for a StreamItem.  The
  format is:

  stream_id = '%d-%s' % (int(stream_time.epoch_ticks), doc_id)
   - stream_time: earliest time that this content was known to exist.  Usually,
  body.raw was also saved at the time of that first observation.
   - other_content: such as title, anchor, extracted, etc.  When present, 'anchor',
  is a single anchor text of a URL pointing to this doc.  Note that
  this does not have metadata like the URL of the page that
  contained this anchor.  Such general link graph data may
  eventually motivate an extension to this thrift interface.
   - ratings: doc-level judgments relating entire StreamItem to a Target
  """

  __slots__ = [ 
    'version',
    'doc_id',
    'abs_url',
    'schost',
    'original_url',
    'source',
    'body',
    'source_metadata',
    'stream_id',
    'stream_time',
    'other_content',
    'ratings',
   ]

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'version', None, None, ), # 1
    (2, TType.STRING, 'doc_id', None, None, ), # 2
    (3, TType.STRING, 'abs_url', None, None, ), # 3
    (4, TType.STRING, 'schost', None, None, ), # 4
    (5, TType.STRING, 'original_url', None, None, ), # 5
    (6, TType.STRING, 'source', None, None, ), # 6
    (7, TType.STRUCT, 'body', (ContentItem, ContentItem.thrift_spec), None, ), # 7
    (8, TType.MAP, 'source_metadata', (TType.STRING,None,TType.STRING,None), {
    }, ), # 8
    (9, TType.STRING, 'stream_id', None, None, ), # 9
    (10, TType.STRUCT, 'stream_time', (StreamTime, StreamTime.thrift_spec), None, ), # 10
    (11, TType.MAP, 'other_content', (TType.STRING,None,TType.STRUCT,(ContentItem, ContentItem.thrift_spec)), {
    }, ), # 11
    (12, TType.MAP, 'ratings', (TType.STRING,None,TType.LIST,(TType.STRUCT,(Rating, Rating.thrift_spec))), {
    }, ), # 12
  )

  def __init__(self, version=None, doc_id=None, abs_url=None, schost=None, original_url=None, source=None, body=None, source_metadata=thrift_spec[8][4], stream_id=None, stream_time=None, other_content=thrift_spec[11][4], ratings=thrift_spec[12][4],):
    self.version = version
    self.doc_id = doc_id
    self.abs_url = abs_url
    self.schost = schost
    self.original_url = original_url
    self.source = source
    self.body = body
    if source_metadata is self.thrift_spec[8][4]:
      source_metadata = {
    }
    self.source_metadata = source_metadata
    self.stream_id = stream_id
    self.stream_time = stream_time
    if other_content is self.thrift_spec[11][4]:
      other_content = {
    }
    self.other_content = other_content
    if ratings is self.thrift_spec[12][4]:
      ratings = {
    }
    self.ratings = ratings

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.version = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.doc_id = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.abs_url = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.STRING:
          self.schost = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.original_url = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRING:
          self.source = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.STRUCT:
          self.body = ContentItem()
          self.body.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 8:
        if ftype == TType.MAP:
          self.source_metadata = {}
          (_ktype138, _vtype139, _size137 ) = iprot.readMapBegin() 
          for _i141 in xrange(_size137):
            _key142 = iprot.readString();
            _val143 = iprot.readString();
            self.source_metadata[_key142] = _val143
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 9:
        if ftype == TType.STRING:
          self.stream_id = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 10:
        if ftype == TType.STRUCT:
          self.stream_time = StreamTime()
          self.stream_time.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 11:
        if ftype == TType.MAP:
          self.other_content = {}
          (_ktype145, _vtype146, _size144 ) = iprot.readMapBegin() 
          for _i148 in xrange(_size144):
            _key149 = iprot.readString();
            _val150 = ContentItem()
            _val150.read(iprot)
            self.other_content[_key149] = _val150
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 12:
        if ftype == TType.MAP:
          self.ratings = {}
          (_ktype152, _vtype153, _size151 ) = iprot.readMapBegin() 
          for _i155 in xrange(_size151):
            _key156 = iprot.readString();
            _val157 = []
            (_etype161, _size158) = iprot.readListBegin()
            for _i162 in xrange(_size158):
              _elem163 = Rating()
              _elem163.read(iprot)
              _val157.append(_elem163)
            iprot.readListEnd()
            self.ratings[_key156] = _val157
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('StreamItem')
    if self.version is not None:
      oprot.writeFieldBegin('version', TType.I32, 1)
      oprot.writeI32(self.version)
      oprot.writeFieldEnd()
    if self.doc_id is not None:
      oprot.writeFieldBegin('doc_id', TType.STRING, 2)
      oprot.writeString(self.doc_id)
      oprot.writeFieldEnd()
    if self.abs_url is not None:
      oprot.writeFieldBegin('abs_url', TType.STRING, 3)
      oprot.writeString(self.abs_url)
      oprot.writeFieldEnd()
    if self.schost is not None:
      oprot.writeFieldBegin('schost', TType.STRING, 4)
      oprot.writeString(self.schost)
      oprot.writeFieldEnd()
    if self.original_url is not None:
      oprot.writeFieldBegin('original_url', TType.STRING, 5)
      oprot.writeString(self.original_url)
      oprot.writeFieldEnd()
    if self.source is not None:
      oprot.writeFieldBegin('source', TType.STRING, 6)
      oprot.writeString(self.source)
      oprot.writeFieldEnd()
    if self.body is not None:
      oprot.writeFieldBegin('body', TType.STRUCT, 7)
      self.body.write(oprot)
      oprot.writeFieldEnd()
    if self.source_metadata is not None:
      oprot.writeFieldBegin('source_metadata', TType.MAP, 8)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.source_metadata))
      for kiter164,viter165 in self.source_metadata.items():
        oprot.writeString(kiter164)
        oprot.writeString(viter165)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.stream_id is not None:
      oprot.writeFieldBegin('stream_id', TType.STRING, 9)
      oprot.writeString(self.stream_id)
      oprot.writeFieldEnd()
    if self.stream_time is not None:
      oprot.writeFieldBegin('stream_time', TType.STRUCT, 10)
      self.stream_time.write(oprot)
      oprot.writeFieldEnd()
    if self.other_content is not None:
      oprot.writeFieldBegin('other_content', TType.MAP, 11)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.other_content))
      for kiter166,viter167 in self.other_content.items():
        oprot.writeString(kiter166)
        viter167.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.ratings is not None:
      oprot.writeFieldBegin('ratings', TType.MAP, 12)
      oprot.writeMapBegin(TType.STRING, TType.LIST, len(self.ratings))
      for kiter168,viter169 in self.ratings.items():
        oprot.writeString(kiter168)
        oprot.writeListBegin(TType.STRUCT, len(viter169))
        for iter170 in viter169:
          iter170.write(oprot)
        oprot.writeListEnd()
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, getattr(self, key))
      for key in self.__slots__]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    if not isinstance(other, self.__class__):
      return False
    for attr in self.__slots__:
      my_val = getattr(self, attr)
      other_val = getattr(other, attr)
      if my_val != other_val:
        return False
    return True

  def __ne__(self, other):
    return not (self == other)

