from conf import DEFAULT_CHARS
from exception import BadBaseError
from helpers import div, pretty

def encode(a, c=DEFAULT_CHARS):
    base = len(c)
    if base < 2:
        raise BadBaseError
    out = ""
    while a:
        a,b = div(a, base)
        out += c[b]
    return pretty(out[::-1])

def decode(a, c=DEFAULT_CHARS):
    base = len(c)
    if base < 2:
        raise BadBaseError
    out = 0
    i = 0
    for b in a[::-1]:
        out += c.index(b)*base**i
        i += 1
    return out