# -*- coding: utf-8 -*-
from glob import glob
from os.path import dirname, join
import re
from sublime import active_window,error_message,packages_path
from envoy import run
import its
import cls


def package_path():
    """return this package path"""
    filename=glob(join(packages_path(),"*",__name__))[0]
    return dirname(filename)

def thread(function,callback=None,status=""):
    """create running thread with passed arguments"""
    if function is not None:
        cls.progress(
            cls.thread(function),
            callback,
            status
        )


def syntax(lang,view=None):
    """return True is current syntax is "lang"""
    if view is None:
        active_window().active_view()
    return bool(re.search(lang, view.settings().get('syntax'), re.I))

def javascript(view=None):
    """return True is current syntax is JavaScript"""
    return syntax('JavaScript',view)

def json(view=None):
    """return True is current syntax is JSON"""
    return syntax('Json',view)

def markdown(view=None):
    """return True is current syntax is Markdown"""
    return syntax('Markdown',view)

def python(view=None):
    """return True is current syntax is Python"""
    return syntax('Python',view)