from threading import Thread
from sublime import error_message, set_timeout, status_message

class thread(Thread):
    function      = None
    finished = None
    def __init__(self,function):
        self.finished = False
        self.function = function
        Thread.__init__(self)

    def run(self):
        try:
            self.function()
            self.finished=True
        except Exception, e:
            error_message(str(e))

class progress:
    callback = None
    status = None
    def __init__(self,thread,callback=None,status=""):
        self.thread     = thread
        self.callback   = callback
        self.status   = status
        self.addend = 1
        self.size = 8
        self.thread.start()
        set_timeout(lambda: self.run(0), 100)

    def run(self, i):
        if not self.thread.is_alive():
            status_message("")
            if self.thread.finished:
                if self.callback:
                    self.callback()
            return

        before = i % self.size
        after = (self.size - 1) - before
        status = '%s[%s=%s]' % \
        (self.status, ' ' * before, ' ' * after)
        status_message(status)
        if not after:
            self.addend = -1
        if not before:
            self.addend = 1
        i += self.addend
        set_timeout(lambda: self.run(i), 100)