#!/usr/bin/env python
"""
WordAPI.py
Copyright 2012 Wordnik, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from models import *


class LocationsApi(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient

    
    def getAllLocations(self, api_key, **kwargs):
        """Get all of your locations

        Args:
            api_key, str: Subtledata API Key (required)
            use_cache, bool: Utilize Cached Data (optional)
            
        Returns: list[Location]
        """

        allParams = ['api_key', 'use_cache']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getAllLocations" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('use_cache' in params):
            queryParams['use_cache'] = self.apiClient.toPathValue(params['use_cache'])
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[Location]')
        return responseObject
        
        
    def getLocationsNear(self, api_key, latitude, longitude, radius, **kwargs):
        """Get locations near a GPS coordinate

        Args:
            api_key, str: Subtledata API Key (required)
            use_cache, bool: Utilize Cached Data (optional)
            latitude, float: Latitude floating point value of search coordinate (required)
            longitude, float: Longitude floating point value of search coordinate (required)
            radius, float: Distance (in miles) to search near coordinate (required)
            
        Returns: list[Location]
        """

        allParams = ['api_key', 'use_cache', 'latitude', 'longitude', 'radius']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getLocationsNear" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/filter/near'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('use_cache' in params):
            queryParams['use_cache'] = self.apiClient.toPathValue(params['use_cache'])
        if ('latitude' in params):
            queryParams['latitude'] = self.apiClient.toPathValue(params['latitude'])
        if ('longitude' in params):
            queryParams['longitude'] = self.apiClient.toPathValue(params['longitude'])
        if ('radius' in params):
            queryParams['radius'] = self.apiClient.toPathValue(params['radius'])
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[Location]')
        return responseObject
        
        
    def getLocation(self, location_id, api_key, **kwargs):
        """Get a location by ID

        Args:
            location_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            use_cache, bool: Utilize Cached Data (optional)
            
        Returns: Location
        """

        allParams = ['location_id', 'api_key', 'use_cache']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getLocation" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('use_cache' in params):
            queryParams['use_cache'] = self.apiClient.toPathValue(params['use_cache'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'Location')
        return responseObject
        
        
    def getLocationMenu(self, location_id, api_key, **kwargs):
        """Get a location's Menu

        Args:
            location_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            use_cache, bool: Utilize Cached Data (optional)
            
        Returns: list[Category]
        """

        allParams = ['location_id', 'api_key', 'use_cache']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getLocationMenu" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/menu'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('use_cache' in params):
            queryParams['use_cache'] = self.apiClient.toPathValue(params['use_cache'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[Category]')
        return responseObject
        
        
    def getLocationPOSMenu(self, location_id, api_key, **kwargs):
        """Get a location's POS Menu

        Args:
            location_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            use_cache, bool: Utilize Cached Data (optional)
            
        Returns: list[POSCategory]
        """

        allParams = ['location_id', 'api_key', 'use_cache']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getLocationPOSMenu" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/pos_menu'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('use_cache' in params):
            queryParams['use_cache'] = self.apiClient.toPathValue(params['use_cache'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[POSCategory]')
        return responseObject
        
        
    def getMenuItem(self, location_id, item_id, api_key, **kwargs):
        """Get details about a menu item

        Args:
            location_id, int: Subtledata Location ID (required)
            item_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            use_cache, bool: Utilize Cached Data (optional)
            
        Returns: MenuItem
        """

        allParams = ['location_id', 'item_id', 'api_key', 'use_cache']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getMenuItem" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/menu/items/{item_id}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('use_cache' in params):
            queryParams['use_cache'] = self.apiClient.toPathValue(params['use_cache'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        if ('item_id' in params):
            replacement = str(self.apiClient.toPathValue(params['item_id']))
            resourcePath = resourcePath.replace('{' + 'item_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'MenuItem')
        return responseObject
        
        
    def getLocationEmployees(self, location_id, api_key, manager_id, **kwargs):
        """Get a list of employees by location ID

        Args:
            location_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            manager_id, int:  (required)
            revenue_center_id, int:  (optional)
            
        Returns: list[Employee]
        """

        allParams = ['location_id', 'api_key', 'manager_id', 'revenue_center_id']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getLocationEmployees" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/employees'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('manager_id' in params):
            queryParams['manager_id'] = self.apiClient.toPathValue(params['manager_id'])
        if ('revenue_center_id' in params):
            queryParams['revenue_center_id'] = self.apiClient.toPathValue(params['revenue_center_id'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[Employee]')
        return responseObject
        
        
    def getTableList(self, location_id, api_key, **kwargs):
        """Get a list of tables by location ID

        Args:
            location_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            use_cache, bool: Utilize Cached Data (optional)
            
        Returns: list[TableMinimal]
        """

        allParams = ['location_id', 'api_key', 'use_cache']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getTableList" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tables'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('use_cache' in params):
            queryParams['use_cache'] = self.apiClient.toPathValue(params['use_cache'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[TableMinimal]')
        return responseObject
        
        
    def getTickets(self, location_id, api_key, **kwargs):
        """Get a list of tickets by location ID

        Args:
            location_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            condensed, bool: Remove ticket details (optional)
            
        Returns: list[Ticket]
        """

        allParams = ['location_id', 'api_key', 'condensed']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getTickets" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tickets'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('condensed' in params):
            queryParams['condensed'] = self.apiClient.toPathValue(params['condensed'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[Ticket]')
        return responseObject
        
        
    def createTicket(self, location_id, api_key, body, **kwargs):
        """Create a ticket

        Args:
            location_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            ticket_type, str: Order Type (optional)
            body, NewTicket: New Ticket Object (required)
            
        Returns: TicketStatus
        """

        allParams = ['location_id', 'api_key', 'ticket_type', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method createTicket" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tickets'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('ticket_type' in params):
            queryParams['ticket_type'] = self.apiClient.toPathValue(params['ticket_type'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'TicketStatus')
        return responseObject
        
        
    def getTabs(self, location_id, api_key, **kwargs):
        """Get a list of tabs by location ID

        Args:
            location_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            
        Returns: list[Tab]
        """

        allParams = ['location_id', 'api_key']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getTabs" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tabs'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[Tab]')
        return responseObject
        
        
    def getTable(self, location_id, table_id, api_key, **kwargs):
        """Get a table by location ID and unique ID

        Args:
            location_id, int: Subtledata Location ID (required)
            table_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            
        Returns: TableDetails
        """

        allParams = ['location_id', 'table_id', 'api_key']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getTable" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tables/{table_id}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        if ('table_id' in params):
            replacement = str(self.apiClient.toPathValue(params['table_id']))
            resourcePath = resourcePath.replace('{' + 'table_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'TableDetails')
        return responseObject
        
        
    def getTicket(self, location_id, ticket_id, api_key, **kwargs):
        """Get a ticket by ID

        Args:
            location_id, int: SubtleData Location ID (required)
            ticket_id, int: SubtleData Location ID (required)
            api_key, str: Subtledata API Key (required)
            user_id, int:  (optional)
            
        Returns: Ticket
        """

        allParams = ['location_id', 'ticket_id', 'api_key', 'user_id']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getTicket" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tickets/{ticket_id}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('user_id' in params):
            queryParams['user_id'] = self.apiClient.toPathValue(params['user_id'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        if ('ticket_id' in params):
            replacement = str(self.apiClient.toPathValue(params['ticket_id']))
            resourcePath = resourcePath.replace('{' + 'ticket_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'Ticket')
        return responseObject
        
        
    def voidTicket(self, location_id, ticket_id, api_key, **kwargs):
        """Void a ticket

        Args:
            location_id, int: SubtleData Location ID (required)
            ticket_id, int: SubtleData Location ID (required)
            api_key, str: Subtledata API Key (required)
            user_id, int:  (optional)
            
        Returns: Status
        """

        allParams = ['location_id', 'ticket_id', 'api_key', 'user_id']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method voidTicket" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tickets/{ticket_id}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('user_id' in params):
            queryParams['user_id'] = self.apiClient.toPathValue(params['user_id'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        if ('ticket_id' in params):
            replacement = str(self.apiClient.toPathValue(params['ticket_id']))
            resourcePath = resourcePath.replace('{' + 'ticket_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'Status')
        return responseObject
        
        
    def getTicketWithPOS_ID(self, location_id, pos_ticket_id, api_key, **kwargs):
        """Get a ticket by POS ID

        Args:
            location_id, int: SubtleData Location ID (required)
            pos_ticket_id, int: SubtleData Location ID (required)
            api_key, str: Subtledata API Key (required)
            user_id, int:  (optional)
            
        Returns: Ticket
        """

        allParams = ['location_id', 'pos_ticket_id', 'api_key', 'user_id']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getTicketWithPOS_ID" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tickets/pos/{pos_ticket_id}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('user_id' in params):
            queryParams['user_id'] = self.apiClient.toPathValue(params['user_id'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        if ('pos_ticket_id' in params):
            replacement = str(self.apiClient.toPathValue(params['pos_ticket_id']))
            resourcePath = resourcePath.replace('{' + 'pos_ticket_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'Ticket')
        return responseObject
        
        
    def submitOrder(self, location_id, ticket_id, user_id, api_key, **kwargs):
        """Order the currently staged items

        Args:
            location_id, int: SubtleData Location ID (required)
            ticket_id, int: SubtleData Location ID (required)
            user_id, int: SubtleData Location ID (required)
            api_key, str: Subtledata API Key (required)
            
        Returns: OrderResults
        """

        allParams = ['location_id', 'ticket_id', 'user_id', 'api_key']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method submitOrder" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tickets/{ticket_id}/users/{user_id}/order'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        if ('ticket_id' in params):
            replacement = str(self.apiClient.toPathValue(params['ticket_id']))
            resourcePath = resourcePath.replace('{' + 'ticket_id' + '}',
                                                replacement)
        if ('user_id' in params):
            replacement = str(self.apiClient.toPathValue(params['user_id']))
            resourcePath = resourcePath.replace('{' + 'user_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'OrderResults')
        return responseObject
        
        
    def addItemsToOrder(self, location_id, ticket_id, user_id, api_key, body, **kwargs):
        """Add items to currently staged order on a ticket

        Args:
            location_id, int: SubtleData Location ID (required)
            ticket_id, int: SubtleData Location ID (required)
            user_id, int: SubtleData Location ID (required)
            api_key, str: Subtledata API Key (required)
            body, ItemToAdd: The Item object to Add (required)
            
        Returns: Status
        """

        allParams = ['location_id', 'ticket_id', 'user_id', 'api_key', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method addItemsToOrder" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tickets/{ticket_id}/users/{user_id}/order'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        if ('ticket_id' in params):
            replacement = str(self.apiClient.toPathValue(params['ticket_id']))
            resourcePath = resourcePath.replace('{' + 'ticket_id' + '}',
                                                replacement)
        if ('user_id' in params):
            replacement = str(self.apiClient.toPathValue(params['user_id']))
            resourcePath = resourcePath.replace('{' + 'user_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'Status')
        return responseObject
        
        
    def getUsersConnectedToTicket(self, location_id, ticket_id, api_key, **kwargs):
        """Get users connected to a ticket

        Args:
            location_id, int: SubtleData Location ID (required)
            ticket_id, int: SubtleData Location ID (required)
            api_key, str: Subtledata API Key (required)
            
        Returns: list[User]
        """

        allParams = ['location_id', 'ticket_id', 'api_key']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getUsersConnectedToTicket" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tickets/{ticket_id}/users'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        if ('ticket_id' in params):
            replacement = str(self.apiClient.toPathValue(params['ticket_id']))
            resourcePath = resourcePath.replace('{' + 'ticket_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[User]')
        return responseObject
        
        
    def connectUserToTicket(self, location_id, ticket_id, api_key, body, **kwargs):
        """Connect a user to a ticket

        Args:
            location_id, int: SubtleData Location ID (required)
            ticket_id, int: SubtleData Location ID (required)
            api_key, str: Subtledata API Key (required)
            body, NewConnection: Into used to connect the user (required)
            
        Returns: ConnectStatus
        """

        allParams = ['location_id', 'ticket_id', 'api_key', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method connectUserToTicket" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tickets/{ticket_id}/users'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        if ('ticket_id' in params):
            replacement = str(self.apiClient.toPathValue(params['ticket_id']))
            resourcePath = resourcePath.replace('{' + 'ticket_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'ConnectStatus')
        return responseObject
        
        
    def discountTicket(self, location_id, ticket_id, api_key, body, **kwargs):
        """Discount a ticket

        Args:
            location_id, int: SubtleData Location ID (required)
            ticket_id, int: SubtleData Location ID (required)
            api_key, str: Subtledata API Key (required)
            body, DiscountInfo: Details regarding the discount (required)
            
        Returns: Status
        """

        allParams = ['location_id', 'ticket_id', 'api_key', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method discountTicket" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tickets/{ticket_id}/discount'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        if ('ticket_id' in params):
            replacement = str(self.apiClient.toPathValue(params['ticket_id']))
            resourcePath = resourcePath.replace('{' + 'ticket_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'Status')
        return responseObject
        
        
    def addPaymentToTicket(self, location_id, ticket_id, api_key, body, **kwargs):
        """Add a credit card payment to a ticket

        Args:
            location_id, int: SubtleData Location ID (required)
            ticket_id, int: SubtleData Location ID (required)
            api_key, str: Subtledata API Key (required)
            body, NewPayment: Info used for payment (required)
            
        Returns: PaymentStatus
        """

        allParams = ['location_id', 'ticket_id', 'api_key', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method addPaymentToTicket" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tickets/{ticket_id}/payments'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        if ('ticket_id' in params):
            replacement = str(self.apiClient.toPathValue(params['ticket_id']))
            resourcePath = resourcePath.replace('{' + 'ticket_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'PaymentStatus')
        return responseObject
        
        
    def addExternalPaymentToTicket(self, location_id, ticket_id, api_key, body, **kwargs):
        """Add an external payment to a ticket

        Args:
            location_id, int: SubtleData Location ID (required)
            ticket_id, int: SubtleData Location ID (required)
            api_key, str: Subtledata API Key (required)
            body, NewExternalPayment: Info used for payment (required)
            
        Returns: ExternalPaymentStatus
        """

        allParams = ['location_id', 'ticket_id', 'api_key', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method addExternalPaymentToTicket" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tickets/{ticket_id}/payments/external'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        if ('ticket_id' in params):
            replacement = str(self.apiClient.toPathValue(params['ticket_id']))
            resourcePath = resourcePath.replace('{' + 'ticket_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'ExternalPaymentStatus')
        return responseObject
        
        
    


