#!/usr/bin/env python
"""
WordAPI.py
Copyright 2012 Wordnik, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from models import *


class LocationsApi(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient

    
    def getLocation(self, location_id, api_key, **kwargs):
        """Get a location by ID

        Args:
            location_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            use_cache, bool: Utilize Cached Data (optional)
            debug, bool: Internal Use Only (optional)
            
        Returns: Location
        """

        allParams = ['location_id', 'api_key', 'use_cache', 'debug']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getLocation" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('use_cache' in params):
            queryParams['use_cache'] = self.apiClient.toPathValue(params['use_cache'])
        if ('debug' in params):
            queryParams['debug'] = self.apiClient.toPathValue(params['debug'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'Location')
        return responseObject
        
        
    def updateLocation(self, location_id, api_key, **kwargs):
        """Update a location

        Args:
            location_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            debug, bool: Internal Use Only (optional)
            
        Returns: Status
        """

        allParams = ['location_id', 'api_key', 'debug']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method updateLocation" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('debug' in params):
            queryParams['debug'] = self.apiClient.toPathValue(params['debug'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'Status')
        return responseObject
        
        
    def deleteLocation(self, location_id, api_key, **kwargs):
        """Delete a location

        Args:
            location_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            debug, bool: Internal Use Only (optional)
            
        Returns: Status
        """

        allParams = ['location_id', 'api_key', 'debug']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method deleteLocation" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('debug' in params):
            queryParams['debug'] = self.apiClient.toPathValue(params['debug'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'Status')
        return responseObject
        
        
    def getLocationMenu(self, location_id, api_key, **kwargs):
        """Get a location's Menu

        Args:
            location_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            use_cache, bool: Utilize Cached Data (optional)
            debug, bool: Internal Use Only (optional)
            
        Returns: list[Category]
        """

        allParams = ['location_id', 'api_key', 'use_cache', 'debug']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method getLocationMenu" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/menu'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('use_cache' in params):
            queryParams['use_cache'] = self.apiClient.toPathValue(params['use_cache'])
        if ('debug' in params):
            queryParams['debug'] = self.apiClient.toPathValue(params['debug'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'list[Category]')
        return responseObject
        
        
    def createTicket(self, location_id, api_key, ticket_type, body, **kwargs):
        """Create a ticket

        Args:
            location_id, int: Subtledata Location ID (required)
            api_key, str: Subtledata API Key (required)
            ticket_type, str: Order Type (required)
            debug, bool: Internal Use Only (optional)
            body, NewTicket: New Ticket Object (required)
            
        Returns: TicketStatus
        """

        allParams = ['location_id', 'api_key', 'ticket_type', 'debug', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method createTicket" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/locations/{location_id}/tickets'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('ticket_type' in params):
            queryParams['ticket_type'] = self.apiClient.toPathValue(params['ticket_type'])
        if ('debug' in params):
            queryParams['debug'] = self.apiClient.toPathValue(params['debug'])
        if ('location_id' in params):
            replacement = str(self.apiClient.toPathValue(params['location_id']))
            resourcePath = resourcePath.replace('{' + 'location_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'TicketStatus')
        return responseObject
        
        
    


