#!/usr/bin/env python
"""
WordAPI.py
Copyright 2012 Wordnik, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from models import *


class TicketsApi(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient

    
    def submitOrder(self, ticket_id, user_id, api_key, body, **kwargs):
        """Order the currently staged items

        Args:
            ticket_id, int: Subtledata Ticket ID (required)
            user_id, int: Subtledata Ticket ID (required)
            api_key, str: Subtledata API Key (required)
            debug, bool: Internal Use Only (optional)
            body, SendTicket: Send the ticket (required)
            
        Returns: OrderResults
        """

        allParams = ['ticket_id', 'user_id', 'api_key', 'debug', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method submitOrder" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/tickets/{ticket_id}/users/{user_id}/order'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('debug' in params):
            queryParams['debug'] = self.apiClient.toPathValue(params['debug'])
        if ('ticket_id' in params):
            replacement = str(self.apiClient.toPathValue(params['ticket_id']))
            resourcePath = resourcePath.replace('{' + 'ticket_id' + '}',
                                                replacement)
        if ('user_id' in params):
            replacement = str(self.apiClient.toPathValue(params['user_id']))
            resourcePath = resourcePath.replace('{' + 'user_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'OrderResults')
        return responseObject
        
        
    def addItemsToOrder(self, ticket_id, user_id, api_key, body, **kwargs):
        """Add items to currently staged order on a ticket

        Args:
            ticket_id, int: Subtledata Ticket ID (required)
            user_id, int: Subtledata Ticket ID (required)
            api_key, str: Subtledata API Key (required)
            debug, bool: Internal Use Only (optional)
            body, ItemToAdd: The Item object to Add (required)
            
        Returns: Status
        """

        allParams = ['ticket_id', 'user_id', 'api_key', 'debug', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method addItemsToOrder" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/tickets/{ticket_id}/users/{user_id}/order'
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('api_key' in params):
            queryParams['api_key'] = self.apiClient.toPathValue(params['api_key'])
        if ('debug' in params):
            queryParams['debug'] = self.apiClient.toPathValue(params['debug'])
        if ('ticket_id' in params):
            replacement = str(self.apiClient.toPathValue(params['ticket_id']))
            resourcePath = resourcePath.replace('{' + 'ticket_id' + '}',
                                                replacement)
        if ('user_id' in params):
            replacement = str(self.apiClient.toPathValue(params['user_id']))
            resourcePath = resourcePath.replace('{' + 'user_id' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'Status')
        return responseObject
        
        
    


