class cachedproperty:

    # Public

    def __init__(self, fget=None, fset=None, fdel=None, doc=None):
        self.__fget = fget
        self.__fset = fset
        self.__fdel = fdel
        self.__doc = doc

    def __get__(self, obj, cls):
        if self.fget is None:
            raise AttributeError('can\'t get attribute')
        name = self.__get_name(obj)
        cache = self.__get_cache(obj)
        if name not in cache:
            cache[self.__name] = self.fget(obj)
        return cache[self.__name]

    def __set__(self, obj, value):
        if self.fset is None:
            raise AttributeError('can\'t set attribute')
        name = self.__get_name(obj)
        cache = self.__get_cache(obj)
        self.fset(obj, cache, name, value)

    def __delete__(self, obj):
        if self.fdel is None:
            raise AttributeError('can\'t delete attribute')
        name = self.__get_name(obj)
        cache = self.__get_cache(obj)
        self.fdel(obj, cache, name)

    @property
    def __doc__(self):
        if self.__doc is not None:
            return self.__doc
        if self.fget is not None:
            return self.fget.__doc__
        return None

    @property
    def fget(self):
        return self.__fget

    @property
    def fset(self):
        return self.__fset

    @property
    def fdel(self):
        return self.__fdel

    def getter(self, fget):
        self.__fget = fget
        return self

    def setter(self, fset):
        self.__fset = fset
        return self

    def deleter(self, fdel):
        self.__fdel = fdel
        return self

    # Private

    __name = None
    __cache = '_sugarbowl_cachedproperty'

    def __get_name(self, obj):
        if self.__name is None:
            for cls in type(obj).mro():
                for name, value in vars(cls).items():
                    if self is value:
                        self.__name = name
        return self.__name

    def __get_cache(self, obj):
        return obj.__dict__.setdefault(self.__cache, {})
