import unittest
from functools import partial
from importlib import import_module
component = import_module('sugarbowl.stylize')


class stylize_Test(unittest.TestCase):

    # Actions

    def setUp(self):
        self.stylize = partial(component.stylize, 'test')

    # Tests

    def test_1(self):
        result = self.stylize(bold=True)
        self.assertEqual(result, '\x1b[1mtest\x1b[0m')

    def test_2(self):
        result = self.stylize(foreground='red')
        self.assertEqual(result, '\x1b[31mtest\x1b[0m')

    def test_with_error(self):
        self.assertRaises(ValueError, self.stylize, error='error')
