import datetime 
import pytz 

full_text_entries = \
[{'article_html': u'<p>Conservative billionaire Charles Koch\'s eponymous charitable foundation today <a href="http://bigstory.ap.org/article/apnewsbreak-uncf-receive-25-million-koch-gift">announced</a> it\'s giving the United Negro College Fund $25 million to primarily fund thousands of merit-based scholarships.</p>\n\n<p>While the development may come as a shock to some Democrats and liberals, particularly those like Senate Majority Leader Harry Reid who\'ve <a href="http://www.politico.com/story/2014/05/harry-reid-koch-brothers-climate-change-106441.html">sought</a> <a href="http://www.nationaljournal.com/congress/harry-reid-s-koch-brothers-addiction-in-two-charts-20140409">to</a> <a href="http://www.washingtonpost.com/blogs/the-fix/wp/2014/03/04/harry-reid-really-hates-the-koch-brothers/">vilify</a> Charles Koch and brother David as self-centered industrialists bent on buying elections, it\'s status quo for the elder Koch sibling.</p>\n\n<p>As the Center for Public Integrity <a href="https://www.publicintegrity.org/2014/03/27/14497/inside-koch-brothers-campus-crusade">reported in March</a>:</p>\n\n<p class="rteindent1"><em>In all, two of the six&nbsp;<a href="http://www.irs.gov/Charities-&amp;-Non-Profits/Private-Foundations/Life-Cycle-of-a-Private-Foundation" style="text-decoration: none; color: red;">private charitable foundations</a>&nbsp;the Koch brothers control and personally fund combined in 2012 to infuse colleges and universities with more than $12.7 million, according to a&nbsp;<a href="http://www.publicintegrity.org/" style="text-decoration: none; color: red;">Center for Public Integrity</a>&nbsp;analysis of Internal Revenue Service tax filings.</em></p>\n\n<p class="rteindent1"><em>The vast majority of this cash was&nbsp;<a href="http://k007.kiwi6.com/hotlink/duoy3b8tok/CKF2012.pdf" style="text-decoration: none; color: red;">spread among</a>&nbsp;163 U.S. colleges and universities \u2014 many with reputations for liberal faculty and left-leaning patrons \u2014 throughout 41 states and the District of Columbia. It came on top of tens of millions of dollars more Koch foundations have given colleges and universities during the past decade, tax filings show.</em></p>\n\n<p>Various Koch-backed charitable foundations have <a href="https://www.publicintegrity.org/2014/03/27/14497/inside-koch-brothers-campus-crusade">also made</a> massive contributions to medicine and the arts as well as sizable grants to a variety of politics- and government-focused outfits.</p>\n\n<p>The Kochs separate network of nonprofit trade associations and "social welfare" nonprofits have <a href="http://www.washingtonpost.com/politics/koch-backed-political-network-built-to-shield-donors-raised-400-million-in-2012-elections/2014/01/05/9e7cfd9a-719b-11e3-9389-09ef9944065e_story.html">pumped</a> hundreds of millions of dollars into issue advertisements and direct advocacy for and against political candidates \u2014 activity that <a href="http://www.politico.com/story/2014/01/koch-brothers-2014-elections-102555.html">continues</a> today at a torrid pace as the nation heads toward congressional elections in November.</p>\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/ku8jkAVGliA" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/ku8jkAVGliA'],
  'article_links': ['http://www.politico.com/story/2014/05/harry-reid-koch-brothers-climate-change-106441.html',
   'http://www.irs.gov/Charities-&-Non-Profits/Private-Foundations/Life-Cycle-of-a-Private-Foundation',
   'http://www.washingtonpost.com/blogs/the-fix/wp/2014/03/04/harry-reid-really-hates-the-koch-brothers',
   'http://bigstory.ap.org/article/apnewsbreak-uncf-receive-25-million-koch-gift',
   'http://www.politico.com/story/2014/01/koch-brothers-2014-elections-102555.html',
   'https://www.publicintegrity.org/2014/03/27/14497/inside-koch-brothers-campus-crusade',
   'http://k007.kiwi6.com/hotlink/duoy3b8tok/CKF2012.pdf',
   'http://www.nationaljournal.com/congress/harry-reid-s-koch-brothers-addiction-in-two-charts-20140409',
   'http://www.washingtonpost.com/politics/koch-backed-political-network-built-to-shield-donors-raised-400-million-in-2012-elections/2014/01/05/9e7cfd9a-719b-11e3-9389-09ef9944065e_story.html',
   'http://www.publicintegrity.org'],
  'authors': [u'Dave Levinthal'],
  'datetime': datetime.datetime(2014, 6, 6, 16, 40, 26, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Politics', u'Primary Source'],
  'text': u'Conservative billionaire Charles Koch\'s eponymous charitable foundation today announced it\'s giving the United Negro College Fund $25 million to primarily fund thousands of merit-based scholarships. While the development may come as a shock to some Democrats and liberals, particularly those like Senate Majority Leader Harry Reid who\'ve sought to vilify Charles Koch and brother David as self-centered industrialists bent on buying elections, it\'s status quo for the elder Koch sibling. As the Center for Public Integrity reported in March: In all, two of the sixprivate charitable foundationsthe Koch brothers control and personally fund combined in 2012 to infuse colleges and universities with more than $12.7 million, according to aCenter for Public Integrityanalysis of Internal Revenue Service tax filings. The vast majority of this cash wasspread among163 U.S. colleges and universities \u2014 many with reputations for liberal faculty and left-leaning patrons \u2014 throughout 41 states and the District of Columbia. It came on top of tens of millions of dollars more Koch foundations have given colleges and universities during the past decade, tax filings show. Various Koch-backed charitable foundations have also made massive contributions to medicine and the arts as well as sizable grants to a variety of politics- and government-focused outfits. The Kochs separate network of nonprofit trade associations and "social welfare" nonprofits have pumped hundreds of millions of dollars into issue advertisements and direct advocacy for and against political candidates \u2014 activity that continues today at a torrid pace as the nation heads toward congressional elections in November.',
  'title': u"Charles Koch's long history of education funding",
  'url': u'http://www.publicintegrity.org/2014/06/06/14905/charles-kochs-long-history-education-funding'},
 {'article_html': u'<p>Sprint Corp. and T-Mobile USA Inc., which only weeks ago were arguing that the government should increase competition in the wireless market by allocating new airwaves to smaller companies like them, are switching sides and looking to join the giants through a merger.</p>\n\n<p>Sprint\u2019s plan to <a href="http://online.wsj.com/articles/sprint-t-mobile-generally-agree-on-merger-terms-1401919219?mod=WSJ_hp_LEFTWhatsNewsCollection" style="line-height: 1.6;">buy</a> T-Mobile for $32 billion is aimed at making the combined company a more formidable competitor to giants Verizon Communications Inc. and AT&amp;T Inc., which together claim 68 percent of U.S. wireless subscribers, respectively. The purchase of T-Mobile would almost double Sprint\u2019s market share to about 30 percent.</p>\n\n<p>Just last month, T-Mobile and Sprint succeeded in convincing the Federal Communications Commission to ensure that smaller wireless companies had a shot a buying valuable new wireless airwaves by limiting how much Verizon and AT&amp;T can buy at an auction next year.&nbsp;</p>\n\n<p>Now the rules that Sprint and T-Mobile fought for may come back to hurt them. Adding T-Mobile\u2019s spectrum holdings with Sprint\u2019s may put the combined company over the limit that bars it from bidding on the reserved portion of spectrum, which comprises prime frequencies that can travel long distances and penetrate buildings. The Center for Public Integrity reported on the high stakes of the <a href="https://www.publicintegrity.org/2014/03/21/14433/wireless-companies-fight-their-futures">spectrum auction</a> in March.</p>\n\n<p>The Sprint purchase of T-Mobile \u201ccertainly would impact the combined company\'s ability to bid,\u201d Matt Wood, policy director at Free Press, an advocacy group in Washington, D.C., that supports the spectrum limits, said in an email.</p>\n\n<p>Jeff Silva, an independent telecommunications analyst in Washington, D.C., agreed that the merger could make Sprint too big to bid on the reserved frequencies.</p>\n\n<p>\u201cThat means they won\u2019t get as much spectrum,\u201d he said.&nbsp;</p>\n\n<p>The purchase would also eliminate T-Mobile, the one company that has put pressure on carriers to lower prices. In the last year T-Mobile has cut prices, eliminated two-year contracts and roaming charges, and offered to pay early termination fees for customers who switch from a competitor. Since the company began offering the promotions in the second quarter of 2013, the number of its subscribers increased 11 percent to 49 million compared with a 3.2 percent growth to 122 million for Verizon and a 7.5 percent increase to 116 million for AT&amp;T during the same period, according to data compiled by Strategy Analytics, a technology consulting firm.<br />\n<br />\nDespite the possibility of less competition, the FCC may be enticed by Sprint to approve the purchase with a sweetener, such as a guarantee that it will spend billions of dollars in the spectrum auction, said Todd O\u2019Boyle, program director for media and democracy at Common Cause, an advocacy group in Washington, D.C., that opposes wireless industry consolidation.</p>\n\n<p>That\u2019s what AT&amp;T did last month when it pledged to spend $9 billion in the auction if the FCC approved its proposed <a href="http://online.wsj.com/news/articles/SB10001424052702304908304579568590603893048">purchase</a> of DirectTV. The promise is aimed directly at FCC Chairman Tom Wheeler, who views the success of the auction as the determining factor on how his chairmanship will be judged, analysts say. And the auction\u2019s success will not be based on whether it promotes competition, but rather how much money is raised, O\u2019Boyle said.</p>\n\n<p>\u201cWheeler has said over and over again that his mantra is \u2018competition, competition, competition,\u2019\u201d O\u2019Boyle said. \u201cBut it\u2019s likely that he would be willing to allow less competition if he had a guarantee that the auction would be a success.\u201d<br />\n<br />\nNext year\u2019s spectrum sale, together with a previous auction held this year and another scheduled in November, needs to bring about $30 billion for the FCC to meet the goals Congress set in the law authorizing the sale, telecommunications analysts said. The FCC expects to raise about $11.5 billion from two auctions this year. Add to that AT&amp;T\u2019s promise to spend $9 billion, and the agency can reach a total of $20 billion.</p>\n\n<p>\u201cIf Sprint puts a serious $10 billion commitment on the table, you are home free,\u201d O\u2019Boyle said. \u201cWhatever Verizon and other smaller carriers and hedge funds bid on for the remaining spectrum goes straight to the Treasury, and Wheeler can then tell Congress what a great job he did. They will all be happy with him. That kind of promise from Sprint may sway Wheeler to approve the deal.\u201d</p>\n\n<p>The merger, if approved, may cause the FCC to rewrite the auction plan altogether. In the <a href="http://www.fcc.gov/document/mobile-spectrum-holdings-report-and-order">rules</a> it adopted in May, the commission said if there were \u201ca proposed transaction \u2026 affecting the top four nationwide providers and their spectrum holdings, we will revisit our decisions here regarding the reserved spectrum provisions.\u201d</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/M7z0mKF3HKM" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/M7z0mKF3HKM'],
  'article_links': ['http://online.wsj.com/news/articles/SB10001424052702304908304579568590603893048',
   'http://online.wsj.com/articles/sprint-t-mobile-generally-agree-on-merger-terms-1401919219',
   'https://www.publicintegrity.org/2014/03/21/14433/wireless-companies-fight-their-futures',
   'http://www.fcc.gov/document/mobile-spectrum-holdings-report-and-order'],
  'authors': [u'Allan Holmes'],
  'datetime': datetime.datetime(2014, 6, 6, 13, 44, 42, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Broadband', u'Business'],
  'text': u"Sprint Corp. and T-Mobile USA Inc., which only weeks ago were arguing that the government should increase competition in the wireless market by allocating new airwaves to smaller companies like them, are switching sides and looking to join the giants through a merger. Sprint\u2019s plan to buy T-Mobile for $32 billion is aimed at making the combined company a more formidable competitor to giants Verizon Communications Inc. and ATT Inc., which together claim 68 percent of U.S. wireless subscribers, respectively. The purchase of T-Mobile would almost double Sprint\u2019s market share to about 30 percent. Just last month, T-Mobile and Sprint succeeded in convincing the Federal Communications Commission to ensure that smaller wireless companies had a shot a buying valuable new wireless airwaves by limiting how much Verizon and ATT can buy at an auction next year. Now the rules that Sprint and T-Mobile fought for may come back to hurt them. Adding T-Mobile\u2019s spectrum holdings with Sprint\u2019s may put the combined company over the limit that bars it from bidding on the reserved portion of spectrum, which comprises prime frequencies that can travel long distances and penetrate buildings. The Center for Public Integrity reported on the high stakes of the spectrum auction in March. The Sprint purchase of T-Mobile \u201ccertainly would impact the combined company's ability to bid,\u201d Matt Wood, policy director at Free Press, an advocacy group in Washington, D.C., that supports the spectrum limits, said in an email. Jeff Silva, an independent telecommunications analyst in Washington, D.C., agreed that the merger could make Sprint too big to bid on the reserved frequencies. \u201cThat means they won\u2019t get as much spectrum,\u201d he said. The purchase would also eliminate T-Mobile, the one company that has put pressure on carriers to lower prices. In the last year T-Mobile has cut prices, eliminated two-year contracts and roaming charges, and offered to pay early termination fees for customers who switch from a competitor. Since the company began offering the promotions in the second quarter of 2013, the number of its subscribers increased 11 percent to 49 million compared with a 3.2 percent growth to 122 million for Verizon and a 7.5 percent increase to 116 million for ATT during the same period, according to data compiled by Strategy Analytics, a technology consulting firm. Despite the possibility of less competition, the FCC may be enticed by Sprint to approve the purchase with a sweetener, such as a guarantee that it will spend billions of dollars in the spectrum auction, said Todd O\u2019Boyle, program director for media and democracy at Common Cause, an advocacy group in Washington, D.C., that opposes wireless industry consolidation. That\u2019s what ATT did last month when it pledged to spend $9 billion in the auction if the FCC approved its proposed purchase of DirectTV. The promise is aimed directly at FCC Chairman Tom Wheeler, who views the success of the auction as the determining factor on how his chairmanship will be judged, analysts say. And the auction\u2019s success will not be based on whether it promotes competition, but rather how much money is raised, O\u2019Boyle said. \u201cWheeler has said over and over again that his mantra is \u2018competition, competition, competition,\u2019\u201d O\u2019Boyle said. \u201cBut it\u2019s likely that he would be willing to allow less competition if he had a guarantee that the auction would be a success.\u201d Next year\u2019s spectrum sale, together with a previous auction held this year and another scheduled in November, needs to bring about $30 billion for the FCC to meet the goals Congress set in the law authorizing the sale, telecommunications analysts said. The FCC expects to raise about $11.5 billion from two auctions this year. Add to that ATT\u2019s promise to spend $9 billion, and the agency can reach a total of $20 billion. \u201cIf Sprint puts a serious $10 billion commitment on the table, you are home free,\u201d O\u2019Boyle said. \u201cWhatever Verizon and other smaller carriers and hedge funds bid on for the remaining spectrum goes straight to the Treasury, and Wheeler can then tell Congress what a great job he did. They will all be happy with him. That kind of promise from Sprint may sway Wheeler to approve the deal.\u201d The merger, if approved, may cause the FCC to rewrite the auction plan altogether. In the rules it adopted in May, the commission said if there were \u201ca proposed transaction \u2026 affecting the top four nationwide providers and their spectrum holdings, we will revisit our decisions here regarding the reserved spectrum provisions.\u201d",
  'title': u'Potential Sprint, T-Mobile marriage threatens consumer gains',
  'url': u'http://www.publicintegrity.org/2014/06/06/14903/potential-sprint-t-mobile-marriage-threatens-consumer-gains'},
 {'article_html': u'<p>A payday lending business with ties to Indian tribes successfully dodged allegations for years that it violated state lending laws. But now, a U.S. district judge has dealt the online business a defeat, <a href="http://www.ftc.gov/system/files/documents/cases/140604amgorder.pdf">ruling</a> in a lawsuit that the company broke federal law by deceiving borrowers about how much they\u2019d have to repay.</p>\n\n<p>The Federal Trade Commission, which brought the lawsuit, will now ask U.S. District Court Judge Gloria M. Navarro of Nevada to order the company and others involved to repay borrowers tens of millions of dollars in illegal charges.</p>\n\n<p>The Center for Public Integrity and CBS News <a href="http://www.publicintegrity.org/2011/09/26/6605/payday-lending-bankrolls-auto-racers-fortune">exposed</a> in 2011 that Scott Tucker, a convicted felon turned professional race-car driver, started the online lending business, now known as AMG Services of Overland Park, Kan. Tucker turned to three Indian tribes in Oklahoma and Nebraska when the attorney general of Colorado tried to shut his business down.</p>\n\n<p>The Miami and Modoc tribes of Oklahoma and Santee Sioux of Nebraska successfully argued in state courts they have sovereign immunity, so states cannot take their businesses to court, even if operated off the reservation or over the Internet.</p>\n\n<p>However, the FTC in 2012 filed a lawsuit against AMG Services, Tucker and others arguing that tribal sovereign immunity doesn\u2019t apply to the federal courts. Navarro recently <a href="http://www.ftc.gov/news-events/press-releases/2014/03/us-district-judge-finds-ftc-can-sue-deceptive-payday-loan">sided</a> with the FTC on that point.</p>\n\n<p>On May 28, Navarro ruled further that AMG Services violated the Truth-in-Lending Act by misleading borrowers about the interest they would owe. In a typical case, the company would tell someone borrowing $500 that they would only have to repay $650. But in reality, the company would rely on confusing language deep in the fine print to automatically renew loans borrowers thought they were paying off, the judge ruled. So a $500 loan could actually cost the borrower $1,925.</p>\n\n<p>Navarro noted that the company\u2019s own training material encouraged employees not to explain the true cost of the loan to borrowers.</p>\n\n<p>\u201cI think we should leave out terms like renew and pay down,\u201d a company trainer wrote in an <a href="https://www.documentcloud.org/documents/1183676-training-email-for-amg-services.html">email</a>. \u201cWe don\u2019t want to complicate things if we are trying to get them to get a loan.\u201d</p>\n\n<p>\u201cLike any other contract, payday lending contracts must disclose the true cost consumers will pay,\u201d Jessica Rich, head of the FTC\u2019s Bureau of Consumer Protection, said in a statement. \u201cThis is especially important because many consumers who take out payday loans calculate the amount they can afford to pay down to the dollar.\u201d</p>\n\n<p>Attorneys for AMG Services did not respond to requests for comment.</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/o5L9gAXtFTM" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/o5L9gAXtFTM'],
  'article_links': ['http://www.ftc.gov/system/files/documents/cases/140604amgorder.pdf',
   'http://www.publicintegrity.org/2011/09/26/6605/payday-lending-bankrolls-auto-racers-fortune',
   'https://www.documentcloud.org/documents/1183676-training-email-for-amg-services.html',
   'http://www.ftc.gov/news-events/press-releases/2014/03/us-district-judge-finds-ftc-can-sue-deceptive-payday-loan'],
  'authors': [u'David Heath'],
  'datetime': datetime.datetime(2014, 6, 6, 14, 36, 12, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Debt Deception?', u'Finance'],
  'text': u'A payday lending business with ties to Indian tribes successfully dodged allegations for years that it violated state lending laws. But now, a U.S. district judge has dealt the online business a defeat, ruling in a lawsuit that the company broke federal law by deceiving borrowers about how much they\u2019d have to repay. The Federal Trade Commission, which brought the lawsuit, will now ask U.S. District Court Judge Gloria M. Navarro of Nevada to order the company and others involved to repay borrowers tens of millions of dollars in illegal charges. The Center for Public Integrity and CBS News exposed in 2011 that Scott Tucker, a convicted felon turned professional race-car driver, started the online lending business, now known as AMG Services of Overland Park, Kan. Tucker turned to three Indian tribes in Oklahoma and Nebraska when the attorney general of Colorado tried to shut his business down. The Miami and Modoc tribes of Oklahoma and Santee Sioux of Nebraska successfully argued in state courts they have sovereign immunity, so states cannot take their businesses to court, even if operated off the reservation or over the Internet. However, the FTC in 2012 filed a lawsuit against AMG Services, Tucker and others arguing that tribal sovereign immunity doesn\u2019t apply to the federal courts. Navarro recently sided with the FTC on that point. On May 28, Navarro ruled further that AMG Services violated the Truth-in-Lending Act by misleading borrowers about the interest they would owe. In a typical case, the company would tell someone borrowing $500 that they would only have to repay $650. But in reality, the company would rely on confusing language deep in the fine print to automatically renew loans borrowers thought they were paying off, the judge ruled. So a $500 loan could actually cost the borrower $1,925. Navarro noted that the company\u2019s own training material encouraged employees not to explain the true cost of the loan to borrowers. \u201cI think we should leave out terms like renew and pay down,\u201d a company trainer wrote in an email. \u201cWe don\u2019t want to complicate things if we are trying to get them to get a loan.\u201d \u201cLike any other contract, payday lending contracts must disclose the true cost consumers will pay,\u201d Jessica Rich, head of the FTC\u2019s Bureau of Consumer Protection, said in a statement. \u201cThis is especially important because many consumers who take out payday loans calculate the amount they can afford to pay down to the dollar.\u201d Attorneys for AMG Services did not respond to requests for comment.',
  'title': u"Race-car driver's payday lending business 'deceived borrowers'",
  'url': u'http://www.publicintegrity.org/2014/06/06/14902/race-car-drivers-payday-lending-business-deceived-borrowers'},
 {'article_html': u'<p>Republican officials will soon file a complaint with the Federal Election Commission against Rep. Chris Van Hollen, D-Md., that accuses him of illegally accepting <em>pro bono </em>legal services, a senior party officer tells the <a href="http://www.publicintegrity.org">Center for Public Integrity</a>.</p>\n\n<p>The pending complaint, which a Van Hollen spokeswoman blasted as a "frivolous action," will argue that the congressman failed to disclose as campaign contributions free legal help he\'s received from several campaign reform groups as part of a federal lawsuit he\'s brought against the FEC. The complaint will also call into question the very legality of the <em>pro bono</em> assistance.</p>\n\n<p>Republicans\' rationale for the complaint: Van Hollen has <a href="http://ia600603.us.archive.org/29/items/gov.uscourts.dcd.147716/gov.uscourts.dcd.147716.20.1.pdf">stated in court documents</a> that his political campaign would be directly affected by the outcome of <a href="http://www.fec.gov/law/litigation/van_hollen_dc_memo_opinion3.pdf">ongoing</a> case&nbsp;<a href="http://www.fec.gov/law/litigation/van_hollen.shtml"><em>Van Hollen v. FEC</em></a>, which <a href="http://www.politico.com/politicoinfluence/0912/politicoinfluence349.html">aimed</a> to <a href="http://sunlightfoundation.com/blog/2013/03/08/court-case-looming-fec-has-trouble-deciding-how-say-it-cant-deci/">reveal</a> <a href="http://www.businessweek.com/news/2012-09-18/court-reinstates-rule-on-issue-ad-donors-secrecy">donors</a> behind certain kinds of political attack ads that secretive nonprofit organizations sponsored. Thus, the free legal aid to affect the outcome of the case should be reported as in-kind campaign contributions.</p>\n\n<p>The GOP party officer who confirmed the complaint declined to say who in the Republican party would specifically file it.</p>\n\n<p>The National Republican Congressional Committee, for its part, cheered the pending complaint, although officials there would not confirm whether the committee would itself sign on.</p>\n\n<p>\u201cIt is beyond ironic for the former head of the [Democratic Congressional Campaign Committee] to file a lawsuit asking for stricter regulations on reporting political campaign finances and then fail to adhere to existing federal election campaign guidelines," NRCC spokeswoman Andrea Bozek said. "Guess Congressman Van Hollen is putting new meaning to the phrase put your money where your mouth is."</p>\n\n<p>Republican National Committee spokeswoman Kirsten Kukowski said her committee is not involved in the complaint, and therefore, has no comment on the matter.</p>\n\n<p>Van Hollen spokeswoman Bridgett Frey said the pending complaint illustrates how "desperate Republican partisans are to keep a torrent of secret money flowing in political election campaigns."</p>\n\n<p>She added: "This is a good sign that they are afraid that legal efforts to promote transparency and disclosure are making headway."</p>\n\n<p>Both Frey and the three campaign reform groups \u2014 the Campaign Legal Center, Democracy 21 and Public Citizen&nbsp;\u2014&nbsp;also argued in nearly identical statements to the Center for Public Integrity that <em>pro bono </em>efforts to fight against the FEC "are not contributions for the purpose of influencing a federal election and are therefore not covered" by laws that govern campaign contributions.</p>\n\n<p>In a joint statement, the Campaign Legal Center, Democracy 21 and Public Citizen further asserted that "Van Hollen has not violated any federal law, nor have we. The objective of the lawsuit in question is to ensure that elections are conducted under regulations that comply with the federal campaign finance laws, not to influence the outcome of any federal election."</p>\n\n<p>They continued: "We are confident that the FEC will dismiss such a complaint if it is filed."</p>\n\n<p>Investigations into complaints filed with the FEC \u2014 and their resolution \u2014 are often themselves secretive matters. Months, even years may elapse without the FEC acknowleding a complaint\'s existence. "To protect the interests of those involved in a complaint, the law requires that any commission action ... be kept strictly confidential until the case is resolved," the agency <a href="http://www.fec.gov/pages/brochures/complain.shtml#confidentiality">explains</a>.</p>\n\n<p>Within 30 days after the involved parties are notified of a resolution, the FEC publicly releases the outcomes and case files of the investigations. Complainants and respondents are, however, allowed to waive their rights to secrecy and speak publicly about a case if they so choose.</p>\n\n<p>The six-member commission \u2014 three Republican appointees, three Democratic appointees \u2014 often <a href="https://www.publicintegrity.org/2013/12/17/13996/how-washington-starves-its-election-watchdog">deadlocks</a> along ideological lines, meaning there\'s little guarantee any complaint before the body will garner a majority decision.</p>\n\n<p>Van Hollen, a <a href="http://vanhollen.house.gov/media-center/press-releases/van-hollen-reintroduces-disclose-act">leading</a> <a href="http://washingtonexaminer.com/chris-van-hollens-unsolvable-dark-money-disclosure-dilemma/article/2547995">liberal</a> <a href="http://www.c-span.org/video/?307227-3/representative-van-hollen-campaign-finance-disclosure">voice</a> on political disclosure issues who\'s captured at least 62 percent of votes cast during his past five elections, is likely to win a seventh term in November. He faces what\'s so far token <a href="http://docquery.fec.gov/pdf/225/14031234225/14031234225.pdf">opposition</a> from Republican businessman David Wallace.</p>\n\n<p>Van Hollen also boasts one of the House\'s more well-funded campaigns this election cycle, reporting more than $1.8 million cash on hand through March 31,&nbsp;<a href="http://docquery.fec.gov/cgi-bin/dcdev/forms/C00366096/926364/">according to</a>&nbsp;campaign finance disclosures.</p>\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/Smk-8acPkp4" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/Smk-8acPkp4'],
  'article_links': ['http://ia600603.us.archive.org/29/items/gov.uscourts.dcd.147716/gov.uscourts.dcd.147716.20.1.pdf',
   'http://www.c-span.org/video',
   'http://washingtonexaminer.com/chris-van-hollens-unsolvable-dark-money-disclosure-dilemma/article/2547995',
   'http://www.politico.com/politicoinfluence/0912/politicoinfluence349.html',
   'http://www.fec.gov/law/litigation/van_hollen_dc_memo_opinion3.pdf',
   'https://www.publicintegrity.org/2013/12/17/13996/how-washington-starves-its-election-watchdog',
   'http://www.publicintegrity.org',
   'http://www.fec.gov/pages/brochures/complain.shtml',
   'http://docquery.fec.gov/pdf/225/14031234225/14031234225.pdf',
   'http://www.businessweek.com/news/2012-09-18/court-reinstates-rule-on-issue-ad-donors-secrecy',
   'http://www.fec.gov/law/litigation/van_hollen.shtml',
   'http://docquery.fec.gov/cgi-bin/dcdev/forms/C00366096/926364',
   'http://vanhollen.house.gov/media-center/press-releases/van-hollen-reintroduces-disclose-act',
   'http://sunlightfoundation.com/blog/2013/03/08/court-case-looming-fec-has-trouble-deciding-how-say-it-cant-deci'],
  'authors': [u'Dave Levinthal'],
  'datetime': datetime.datetime(2014, 6, 5, 18, 9, 9, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Politics', u'Primary Source'],
  'text': u'Republican officials will soon file a complaint with the Federal Election Commission against Rep. Chris Van Hollen, D-Md., that accuses him of illegally accepting pro bono legal services, a senior party officer tells the Center for Public Integrity. The pending complaint, which a Van Hollen spokeswoman blasted as a "frivolous action," will argue that the congressman failed to disclose as campaign contributions free legal help he\'s received from several campaign reform groups as part of a federal lawsuit he\'s brought against the FEC. The complaint will also call into question the very legality of the pro bono assistance. Republicans\' rationale for the complaint: Van Hollen has stated in court documents that his political campaign would be directly affected by the outcome of ongoing caseVan Hollen v. FEC, which aimed to reveal donors behind certain kinds of political attack ads that secretive nonprofit organizations sponsored. Thus, the free legal aid to affect the outcome of the case should be reported as in-kind campaign contributions. The GOP party officer who confirmed the complaint declined to say who in the Republican party would specifically file it. The National Republican Congressional Committee, for its part, cheered the pending complaint, although officials there would not confirm whether the committee would itself sign on. \u201cIt is beyond ironic for the former head of the [Democratic Congressional Campaign Committee] to file a lawsuit asking for stricter regulations on reporting political campaign finances and then fail to adhere to existing federal election campaign guidelines," NRCC spokeswoman Andrea Bozek said. "Guess Congressman Van Hollen is putting new meaning to the phrase put your money where your mouth is." Republican National Committee spokeswoman Kirsten Kukowski said her committee is not involved in the complaint, and therefore, has no comment on the matter. Van Hollen spokeswoman Bridgett Frey said the pending complaint illustrates how "desperate Republican partisans are to keep a torrent of secret money flowing in political election campaigns." She added: "This is a good sign that they are afraid that legal efforts to promote transparency and disclosure are making headway." Both Frey and the three campaign reform groups \u2014 the Campaign Legal Center, Democracy 21 and Public Citizen\u2014also argued in nearly identical statements to the Center for Public Integrity that pro bono efforts to fight against the FEC "are not contributions for the purpose of influencing a federal election and are therefore not covered" by laws that govern campaign contributions. In a joint statement, the Campaign Legal Center, Democracy 21 and Public Citizen further asserted that "Van Hollen has not violated any federal law, nor have we. The objective of the lawsuit in question is to ensure that elections are conducted under regulations that comply with the federal campaign finance laws, not to influence the outcome of any federal election." They continued: "We are confident that the FEC will dismiss such a complaint if it is filed." Investigations into complaints filed with the FEC \u2014 and their resolution \u2014 are often themselves secretive matters. Months, even years may elapse without the FEC acknowleding a complaint\'s existence. "To protect the interests of those involved in a complaint, the law requires that any commission action ... be kept strictly confidential until the case is resolved," the agency explains. Within 30 days after the involved parties are notified of a resolution, the FEC publicly releases the outcomes and case files of the investigations. Complainants and respondents are, however, allowed to waive their rights to secrecy and speak publicly about a case if they so choose. The six-member commission \u2014 three Republican appointees, three Democratic appointees \u2014 often deadlocks along ideological lines, meaning there\'s little guarantee any complaint before the body will garner a majority decision. Van Hollen, a leading liberal voice on political disclosure issues who\'s captured at least 62 percent of votes cast during his past five elections, is likely to win a seventh term in November. He faces what\'s so far token opposition from Republican businessman David Wallace. Van Hollen also boasts one of the House\'s more well-funded campaigns this election cycle, reporting more than $1.8 million cash on hand through March 31,according tocampaign finance disclosures.',
  'title': u'Republicans to target Van Hollen in FEC complaint',
  'url': u'http://www.publicintegrity.org/2014/06/05/14874/republicans-target-van-hollen-fec-complaint'},
 {'article_html': u'<p><em>Eleven years ago, Congress created private Medicare Advantage health plans to help control health care spending on the elderly. The plans now cover nearly 16 million seniors at an estimated cost to taxpayers of more than $150 billion this year, but our latest investigation found that manipulation of a Medicare Advantage payment tool called a \u201crisk score\u201d is adding billions to the program\'s cost. Our Multimedia Editor Eleanor Bell sat down with the project reporter Fred Schulte to talk about some of his findings.</em></p>\n\n<p><strong>Eleanor Bell:</strong>&nbsp;The government is wasting tens of billions of dollars by overpaying private health insurers that inflate how sick their patients are.&nbsp;</p>\n\n<p>That\'s the key finding of&nbsp;<a href="https://www.publicintegrity.org/health/medicare/medicare-advantage-money-grab">a new Center report</a>&nbsp;by journalist Fred Schulte.</p>\n\n<p>For more than a year, he\u2019s been investigating Medicare Advantage, the government-backed alternative to Medicare for seniors run mostly by private companies.</p>\n\n<p>At the heart of the story are allegations that some big insurers are ripping off the taxpayer and questions about why the government is doing so little to stop it.</p>\n\n<p>The report finds that not only has Washington known about this for years, but it has records of&nbsp;who\u2019s responsible and refuses to release them.</p>\n\n<p>Now the Center for Public Integrity is suing to make those files public.</p>\n\n<p>We\u2019ll have more about that in a moment, but firstly Fred, let\u2019s start from the beginning:</p>\n\n<p>Medicare Advantage was introduced by Congress more than a decade ago to stabilize health care costs, has it been effective?</p>\n\n<p><strong>Fred Schulte:</strong>&nbsp;Well it\u2019s been very effective for many patients. Witness the fact that it\u2019s grown dramatically and now has over 16 million members in various Medicare Advantage plans. Many people like it because it costs them less out of pocket than the standard Medicare and so it\u2019s expected to grow even further. So it\u2019s a very effective program for many people.</p>\n\n<p>What we were looking at was more the financial aspects of it \u2014 as to whether the payments are being made properly and whether some of the health plans are being overpaid and whether too much taxpayer money is going down the tube.</p>\n\n<p><strong>EB:</strong>&nbsp;And what did you find?</p>\n\n<p><strong>FS:</strong>&nbsp;Well we found that there\u2019s considerable evidence that billions of dollars have in fact been improperly paid to these plans over the years and that\u2019s the government\u2019s own estimates.</p>\n\n<p><strong>EB:</strong>&nbsp;We\u2019re actually talking about 70 billion dollars of improper payments across the board aren\u2019t we?</p>\n\n<p><strong>FS:</strong>&nbsp;- Right</p>\n\n<p><strong>EB:</strong>&nbsp;\u2026 Those that are being overcharged as well as those that are being potentially being undercharged. Where does the balance tip, there?</p>\n\n<p><strong>FS:</strong>&nbsp;Well, the allegations revolve around how the government pays the programs and whether they\u2019re paying them too much. The Medicare Advantage programs are paid under a very complicated formula in which they determine what they call a risk score which is supposed to pay higher rates for sicker patients and lower rates for the healthier people but what\u2019s happened over the years is that the government\u2019s had a difficult time keeping the risk scores from going up and some of the plans from being paid too much.&nbsp;</p>\n\n<p>Every year they sample the enrollment of Medicare Advantage patients and they try to determine whether the patients actually have the diseases that the plans say they have, or if they\u2019re as serious as the plans say they have. And they\u2019ve typically found that in many cases the plans can\u2019t justify that the patients are as sick as they say and they those call those improper payments and a good deal of that amount is an overpayment and those overpayments have come up to tens of billions of dollars over the last five years.</p>\n<p><strong>EB:</strong>&nbsp;Now you mention that these payments are calculated by a complex formula called a \u201crisk score.\u201d How does that work?</p>\n\n<p><strong>FS:</strong>&nbsp;Well it isn\u2019t working so well actually. I mean it\u2019s a very, very, complicated system. Normally Medicare pays on what\u2019s called a \u201cfee for service\u201d system and that would be that every doctor bills for every service every time. With the Medicare Advantage there aren\u2019t any bills, there\u2019s just the establishment that a person has a certain illness and they\u2019re paid based on having that illness \u2026 or not having an illness. It\u2019s very difficult for the government to keep track.</p>\n\n<p><strong>EB:</strong>&nbsp;Say you have an enlarged prostate, would you know what your risk score is on the basis of having that particular illness?</p>\n\n<p><strong>FS:</strong>&nbsp;No, this is something that goes on completely behind the curtain. Patients have no idea what\u2019s going on, and many people inside the healthcare industry don\u2019t even claim to understand the complexities of the system. But it\u2019s not something that patients would even know about.</p>\n\n<p><strong>EB:</strong>&nbsp;Some might say that we\u2019re just talking about an ageing population that\u2019s living longer and getting sicker. Is that the case here?</p>\n\n<p><strong>FS:</strong>&nbsp;Many people don\u2019t believe that the Medicare Advantage is attracting the sicker patients than the Medicare population as a whole but that\u2019s one of the things we\u2019re trying to get our hands on.</p>\n\n<p><strong>EB:</strong>&nbsp;To a certain extent though, the government has been transparent. I mean it has released all this billing data.</p>\n\n<p><strong>FS:</strong>&nbsp;Right. They have recently released the Medicare billing data for doctors and a number of media outlets have been doing stories about how doctors are being paid. But what they have not released is the Medicare Advantage data. I mean this is the billing data the government doesn\u2019t want you to see. And that\u2019s why we want people to be able to see it.</p>\n\n<p><strong>EB:</strong> Is this why you\u2019re suing?</p>\n\n<p><strong>FS:</strong> Well that\u2019s one of the reasons. We\u2019re asking not only for that; we\u2019re asking for the names of companies, and big insurance companies that have been billing and how they\u2019ve been billing and who\u2019s been found to have overbilled. And we think that that information ought to be available to taxpayers. The government has said that they were, their main reason for not releasing doctors\u2019 specific billing data, over the years, has been privacy reasons: that they didn\u2019t want to invade the privacy of a doctor.&nbsp; But when you\u2019re talking about huge insurance companies we don\u2019t see how that, how there should be any privacy there.</p>\n\n<p><strong>EB:</strong> And we\u2019re not sure that they\u2019re not doing their own investigation into these companies at the moment?</p>\n\n<p><strong>FS:</strong> Well no. Because the program is like a black box and there\u2019s no way for anyone to get any insight into how they\u2019re running the program because when you ask them questions they refuse to answer. We\u2019ve tried repeatedly to get interviews with CMS officials. We tried to submit questions to them in writing and it\u2019s just a total stonewall. And we think that when you\u2019re running 150 billion dollar program that uses taxpayers\u2019 money, that there should be some accountability.</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/KfSMP00M2bQ" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/KfSMP00M2bQ'],
  'article_links': ['https://www.publicintegrity.org/health/medicare/medicare-advantage-money-grab'],
  'authors': [u'Eleanor Bell'],
  'datetime': datetime.datetime(2014, 6, 6, 13, 39, 8, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Medicare', u'Medicare Advantage Money Grab'],
  'text': u"Eleven years ago, Congress created private Medicare Advantage health plans to help control health care spending on the elderly. The plans now cover nearly 16 million seniors at an estimated cost to taxpayers of more than $150 billion this year, but our latest investigation found that manipulation of a Medicare Advantage payment tool called a \u201crisk score\u201d is adding billions to the program's cost. Our Multimedia Editor Eleanor Bell sat down with the project reporter Fred Schulte to talk about some of his findings. Eleanor Bell:The government is wasting tens of billions of dollars by overpaying private health insurers that inflate how sick their patients are. That's the key finding ofa new Center reportby journalist Fred Schulte. For more than a year, he\u2019s been investigating Medicare Advantage, the government-backed alternative to Medicare for seniors run mostly by private companies. At the heart of the story are allegations that some big insurers are ripping off the taxpayer and questions about why the government is doing so little to stop it. The report finds that not only has Washington known about this for years, but it has records ofwho\u2019s responsible and refuses to release them. Now the Center for Public Integrity is suing to make those files public. We\u2019ll have more about that in a moment, but firstly Fred, let\u2019s start from the beginning: Medicare Advantage was introduced by Congress more than a decade ago to stabilize health care costs, has it been effective? Fred Schulte:Well it\u2019s been very effective for many patients. Witness the fact that it\u2019s grown dramatically and now has over 16 million members in various Medicare Advantage plans. Many people like it because it costs them less out of pocket than the standard Medicare and so it\u2019s expected to grow even further. So it\u2019s a very effective program for many people. What we were looking at was more the financial aspects of it \u2014 as to whether the payments are being made properly and whether some of the health plans are being overpaid and whether too much taxpayer money is going down the tube. EB:And what did you find? FS:Well we found that there\u2019s considerable evidence that billions of dollars have in fact been improperly paid to these plans over the years and that\u2019s the government\u2019s own estimates. EB:We\u2019re actually talking about 70 billion dollars of improper payments across the board aren\u2019t we? FS:- Right EB:\u2026 Those that are being overcharged as well as those that are being potentially being undercharged. Where does the balance tip, there? FS:Well, the allegations revolve around how the government pays the programs and whether they\u2019re paying them too much. The Medicare Advantage programs are paid under a very complicated formula in which they determine what they call a risk score which is supposed to pay higher rates for sicker patients and lower rates for the healthier people but what\u2019s happened over the years is that the government\u2019s had a difficult time keeping the risk scores from going up and some of the plans from being paid too much. Every year they sample the enrollment of Medicare Advantage patients and they try to determine whether the patients actually have the diseases that the plans say they have, or if they\u2019re as serious as the plans say they have. And they\u2019ve typically found that in many cases the plans can\u2019t justify that the patients are as sick as they say and they those call those improper payments and a good deal of that amount is an overpayment and those overpayments have come up to tens of billions of dollars over the last five years. EB:Now you mention that these payments are calculated by a complex formula called a \u201crisk score.\u201d How does that work? FS:Well it isn\u2019t working so well actually. I mean it\u2019s a very, very, complicated system. Normally Medicare pays on what\u2019s called a \u201cfee for service\u201d system and that would be that every doctor bills for every service every time. With the Medicare Advantage there aren\u2019t any bills, there\u2019s just the establishment that a person has a certain illness and they\u2019re paid based on having that illness \u2026 or not having an illness. It\u2019s very difficult for the government to keep track. EB:Say you have an enlarged prostate, would you know what your risk score is on the basis of having that particular illness? FS:No, this is something that goes on completely behind the curtain. Patients have no idea what\u2019s going on, and many people inside the healthcare industry don\u2019t even claim to understand the complexities of the system. But it\u2019s not something that patients would even know about. EB:Some might say that we\u2019re just talking about an ageing population that\u2019s living longer and getting sicker. Is that the case here? FS:Many people don\u2019t believe that the Medicare Advantage is attracting the sicker patients than the Medicare population as a whole but that\u2019s one of the things we\u2019re trying to get our hands on. EB:To a certain extent though, the government has been transparent. I mean it has released all this billing data. FS:Right. They have recently released the Medicare billing data for doctors and a number of media outlets have been doing stories about how doctors are being paid. But what they have not released is the Medicare Advantage data. I mean this is the billing data the government doesn\u2019t want you to see. And that\u2019s why we want people to be able to see it. EB: Is this why you\u2019re suing? FS: Well that\u2019s one of the reasons. We\u2019re asking not only for that; we\u2019re asking for the names of companies, and big insurance companies that have been billing and how they\u2019ve been billing and who\u2019s been found to have overbilled. And we think that that information ought to be available to taxpayers. The government has said that they were, their main reason for not releasing doctors\u2019 specific billing data, over the years, has been privacy reasons: that they didn\u2019t want to invade the privacy of a doctor. But when you\u2019re talking about huge insurance companies we don\u2019t see how that, how there should be any privacy there. EB: And we\u2019re not sure that they\u2019re not doing their own investigation into these companies at the moment? FS: Well no. Because the program is like a black box and there\u2019s no way for anyone to get any insight into how they\u2019re running the program because when you ask them questions they refuse to answer. We\u2019ve tried repeatedly to get interviews with CMS officials. We tried to submit questions to them in writing and it\u2019s just a total stonewall. And we think that when you\u2019re running 150 billion dollar program that uses taxpayers\u2019 money, that there should be some accountability.",
  'title': u'150 billion reasons Medicare Advantage matters',
  'url': u'http://www.publicintegrity.org/2014/06/05/14895/150-billion-reasons-medicare-advantage-matters'},
 {'article_html': u'<p>The reverberations from a Center for Public Integrity/ABC News <a href="http://www.publicintegrity.org/2013/10/30/13637/johns-hopkins-medical-unit-rarely-finds-black-lung-helping-coal-industry-defeat" target="_blank">investigation</a> continued this week as the U.S. Department of Labor warned its officials to view with skepticism any X-ray readings by a Johns Hopkins University doctor who virtually never diagnoses black lung, a deadly disease that afflicts coal miners.</p>\n\n<p>The news organizations reported last fall that Dr. Paul Wheeler, an associate professor of radiology at the Johns Hopkins Medical Institutions often hired by coal companies to weigh miners\u2019 claims for federal benefits, had never found the most severe form of the disease among more than 1,500 claims. Johns Hopkins suspended its black lung X-ray reading program promptly after the story was published.</p>\n\n<p>On Monday, in a development <a href="http://abcnews.go.com/Blotter/breath-hope-coal-miners-seeking-black-lung-benefits/story?id=23981826" target="_blank">first reported</a> by ABC News, the Labor Department issued a <a href="https://www.documentcloud.org/documents/1183009-weighing-chest-x-ray-evidence-by-dr-wheeler-u-s.html" target="_blank">bulletin</a> instructing district directors in the department\u2019s Office of Workers\u2019 Compensation Programs to \u201ctake notice\u201d of the journalists\u2019 work and assume Wheeler\u2019s findings in black lung cases are suspect.</p>\n\n<p>\u201cThe CPI and ABC News reports, and Johns Hopkins\u2019 investigation and suspension of its black lung reading program, are relevant, material and probative evidence regarding Dr. Wheeler\u2019s qualifications,\u201d the bulletin says. \u201cSuch a consistent record of never diagnosing complicated [black lung] and almost never diagnosing simple [black lung] undermines the credibility of his conclusions and renders them less credible than a positive reading. In addition, the reports demonstrate that Dr. Wheeler\u2019s diagnoses have been wrong many times.\u201d</p>\n\n<p>In an emailed statement Wednesday, Johns Hopkins spokeswoman Kim Hoppe wrote, "We take these allegations very seriously and are still conducting the investigation into the [X-ray reading] program."&nbsp; Hoppe wrote&nbsp;that "nobody at Hopkins \u2014 including Dr. Wheeler" is&nbsp;doing such readings while the inquiry is ongoing.</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/OG_NWks_yqA" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/OG_NWks_yqA'],
  'article_links': ['http://abcnews.go.com/Blotter/breath-hope-coal-miners-seeking-black-lung-benefits/story',
   'https://www.documentcloud.org/documents/1183009-weighing-chest-x-ray-evidence-by-dr-wheeler-u-s.html',
   'http://www.publicintegrity.org/2013/10/30/13637/johns-hopkins-medical-unit-rarely-finds-black-lung-helping-coal-industry-defeat'],
  'authors': [u'The Center For Public Integrity'],
  'datetime': datetime.datetime(2014, 6, 5, 18, 47, 1, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Environment', u'Breathless and Burdened'],
  'text': u'The reverberations from a Center for Public Integrity/ABC News investigation continued this week as the U.S. Department of Labor warned its officials to view with skepticism any X-ray readings by a Johns Hopkins University doctor who virtually never diagnoses black lung, a deadly disease that afflicts coal miners. The news organizations reported last fall that Dr. Paul Wheeler, an associate professor of radiology at the Johns Hopkins Medical Institutions often hired by coal companies to weigh miners\u2019 claims for federal benefits, had never found the most severe form of the disease among more than 1,500 claims. Johns Hopkins suspended its black lung X-ray reading program promptly after the story was published. On Monday, in a development first reported by ABC News, the Labor Department issued a bulletin instructing district directors in the department\u2019s Office of Workers\u2019 Compensation Programs to \u201ctake notice\u201d of the journalists\u2019 work and assume Wheeler\u2019s findings in black lung cases are suspect. \u201cThe CPI and ABC News reports, and Johns Hopkins\u2019 investigation and suspension of its black lung reading program, are relevant, material and probative evidence regarding Dr. Wheeler\u2019s qualifications,\u201d the bulletin says. \u201cSuch a consistent record of never diagnosing complicated [black lung] and almost never diagnosing simple [black lung] undermines the credibility of his conclusions and renders them less credible than a positive reading. In addition, the reports demonstrate that Dr. Wheeler\u2019s diagnoses have been wrong many times.\u201d In an emailed statement Wednesday, Johns Hopkins spokeswoman Kim Hoppe wrote, "We take these allegations very seriously and are still conducting the investigation into the [X-ray reading] program." Hoppe wrotethat "nobody at Hopkins \u2014 including Dr. Wheeler" isdoing such readings while the inquiry is ongoing.',
  'title': u"Labor Department issues warning about Hopkins doctor's findings on black lung claims",
  'url': u'http://www.publicintegrity.org/2014/06/04/14897/labor-department-issues-warning-about-hopkins-doctors-findings-black-lung-claims'},
 {'article_html': u'<p>A U.S. Senate primary dominated by super PACs and nonprofit groups is headed into overtime.</p>\n\n<p>Neither incumbent Sen. Thad Cochran, R-Miss., nor Chris McDaniel, his tea party challenger, on Tuesday&nbsp;<a href="http://www.politico.com/story/2014/06/primary-elections-2014-mississippi-california-new-jersey-iowa-107388.html">mustered</a> the requisite 50 percent of votes <a href="http://www.politico.com/2014-election/results/map/senate/mississippi/">needed</a>&nbsp;to propel them from one of the nation\'s most <a href="http://www.businessinsider.com/mississippi-senate-primary-cochran-mcdaniel-runoff-results2014-6">contentious</a> <a href="http://www.politico.com/story/2014/06/primary-elections-2014-mississippi-california-new-jersey-iowa-107388.html">intramural</a> <a href="http://www.latimes.com/nation/politics/politicsnow/la-pn-mississippi-senate-20140603-story.html">battles</a> toward an likely trip to Capitol Hill.</p>\n\n<p>Unless a final batch of uncounted votes dramatically swing they way of one candidate over the other today, Cochran and McDaniel now&nbsp;<a href="http://blogs.wsj.com/washwire/2014/06/03/mississippi-gop-primary-runoff-possible/">square off again</a> in a June 24 runoff emblematic of a <a href="https://www.publicintegrity.org/2014/05/08/14732/gop-civil-war-rages-senate-primary-battles">broader GOP civil war</a> pitting party standard bearers against tea party insurgents.</p>\n\n<p>That likely means three more weeks of freewheeling spending by a gaggle of outside organizations \u2014 some with few ties to Mississippi, a state of fewer than 3 million people \u2014 that have dominated the race.</p>\n\n<p>Super PACs, nonprofit groups and other political committees spent more than $8 million to beat down or boost up their candidate of choice, generally through television, radio, mail and phone ads, according to a <a href="http://www.publicintegrity.org/">Center for Public Integrity</a> analysis of federal disclosures.</p>\n\n<p>Cochran and McDaniel together controlled less than two-fifths of the $13.4 million that poured into their primary fracas.</p>\n\n<p>Nevertheless, when the money the candidates themselves raised for their primary campaigns is added to the money spent by supportive outside groups, the results are nearly even: Team Cochran controlled about $6.9 million, Team McDaniel about $6.5 million.</p>\n\n<p>Most of the outside spending in Mississippi\'s Senate primary \u2014 $5.26 million \u2014 benefited McDaniel, with tea party super PACs Club for Growth Action, Senate Conservatives Action and FreedomWorks for America investing the most.</p>\n\n<p>But their often negative ad barrages forced Cochran, seeking a seventh term, to kick his own campaign operation into fundraising hyperdrive to keep pace.</p>\n\n<p>Cochran had little choice, as outside organizations supporting his re-election spent barely half of what pro-McDaniel groups did.</p>\n\n<p>Of particular note: In the three weeks leading up to today\'s vote, Cochran amassed more than $335,100 in four-figure campaign contributions \u2014 he won\'t report his smaller donations until later this month \u2014 and <a href="http://docquery.fec.gov/pdf/015/14020404015/14020404015.pdf">personally secured</a> a $150,000 loan to his campaign from a Mississippi bank.</p>\n\n<p>McDaniel\'s campaign, meanwhile, generated less than $60,000 in such contributions, federal records indicate.</p>\n\n<p>The incumbent\'s most generous air cover came from the Mississippi Conservatives Fund super PAC, the mainstream Republican-backing U.S. Chamber of Commerce, the National Association of Realtors Congressional Fund and the American Hospital Association PAC, federal records show.</p>\n\n<p>During the entirety of the race, Cochran\'s campaign committee outraised McDaniel\'s campaign committee by a more than 3-to-1 margin: $4.1 million versus $1.22 million.</p>\n\n<p>Mississippi\'s imbalance between candidate and special interest spending is remarkable for its rarity.</p>\n\n<p>During the 2012 election cycle, outside political groups didn\'t once outspend candidates in their own U.S. Senate primary races, according to data provided to the Center for Public Integrity by the <a href="http://opensecrets.org/">Center for Responsive Politics</a>. It happened just one time \u2014 in Arkansas \u2014 in 2010.</p>\n\n<p>It\'s easier than ever for non-candidate committees to act as prominent forces in political races thanks to the Supreme Court\'s 2010 decision in <em><a href="https://www.publicintegrity.org/2012/10/18/11527/citizens-united-decision-and-why-it-matters">Citizens United v. Federal Election Commission</a></em>, which allowed corporations, nonprofits, unions and special interests to raise and spend unlimited amounts of money to advocate for or against politicians.</p>\n\n<p>Mississippi\'s primary slugfest also marks a far cry from 2008, when Cochran raised just $2.7 million during his entire re-election campaign.</p>\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/jnhmQ4d8LBw" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/jnhmQ4d8LBw'],
  'article_links': ['http://www.latimes.com/nation/politics/politicsnow/la-pn-mississippi-senate-20140603-story.html',
   'http://docquery.fec.gov/pdf/015/14020404015/14020404015.pdf',
   'https://www.publicintegrity.org/2012/10/18/11527/citizens-united-decision-and-why-it-matters',
   'http://opensecrets.org',
   'http://www.businessinsider.com/mississippi-senate-primary-cochran-mcdaniel-runoff-results2014-6',
   'https://www.publicintegrity.org/2014/05/08/14732/gop-civil-war-rages-senate-primary-battles',
   'http://www.politico.com/story/2014/06/primary-elections-2014-mississippi-california-new-jersey-iowa-107388.html',
   'http://www.politico.com/2014-election/results/map/senate/mississippi',
   'http://www.publicintegrity.org',
   'http://blogs.wsj.com/washwire/2014/06/03/mississippi-gop-primary-runoff-possible'],
  'authors': [u'Dave Levinthal'],
  'datetime': datetime.datetime(2014, 6, 4, 13, 31, 37, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Politics', u'Primary Source'],
  'text': u"A U.S. Senate primary dominated by super PACs and nonprofit groups is headed into overtime. Neither incumbent Sen. Thad Cochran, R-Miss., nor Chris McDaniel, his tea party challenger, on Tuesdaymustered the requisite 50 percent of votes neededto propel them from one of the nation's most contentious intramural battles toward an likely trip to Capitol Hill. Unless a final batch of uncounted votes dramatically swing they way of one candidate over the other today, Cochran and McDaniel nowsquare off again in a June 24 runoff emblematic of a broader GOP civil war pitting party standard bearers against tea party insurgents. That likely means three more weeks of freewheeling spending by a gaggle of outside organizations \u2014 some with few ties to Mississippi, a state of fewer than 3 million people \u2014 that have dominated the race. Super PACs, nonprofit groups and other political committees spent more than $8 million to beat down or boost up their candidate of choice, generally through television, radio, mail and phone ads, according to a Center for Public Integrity analysis of federal disclosures. Cochran and McDaniel together controlled less than two-fifths of the $13.4 million that poured into their primary fracas. Nevertheless, when the money the candidates themselves raised for their primary campaigns is added to the money spent by supportive outside groups, the results are nearly even: Team Cochran controlled about $6.9 million, Team McDaniel about $6.5 million. Most of the outside spending in Mississippi's Senate primary \u2014 $5.26 million \u2014 benefited McDaniel, with tea party super PACs Club for Growth Action, Senate Conservatives Action and FreedomWorks for America investing the most. But their often negative ad barrages forced Cochran, seeking a seventh term, to kick his own campaign operation into fundraising hyperdrive to keep pace. Cochran had little choice, as outside organizations supporting his re-election spent barely half of what pro-McDaniel groups did. Of particular note: In the three weeks leading up to today's vote, Cochran amassed more than $335,100 in four-figure campaign contributions \u2014 he won't report his smaller donations until later this month \u2014 and personally secured a $150,000 loan to his campaign from a Mississippi bank. McDaniel's campaign, meanwhile, generated less than $60,000 in such contributions, federal records indicate. The incumbent's most generous air cover came from the Mississippi Conservatives Fund super PAC, the mainstream Republican-backing U.S. Chamber of Commerce, the National Association of Realtors Congressional Fund and the American Hospital Association PAC, federal records show. During the entirety of the race, Cochran's campaign committee outraised McDaniel's campaign committee by a more than 3-to-1 margin: $4.1 million versus $1.22 million. Mississippi's imbalance between candidate and special interest spending is remarkable for its rarity. During the 2012 election cycle, outside political groups didn't once outspend candidates in their own U.S. Senate primary races, according to data provided to the Center for Public Integrity by the Center for Responsive Politics. It happened just one time \u2014 in Arkansas \u2014 in 2010. It's easier than ever for non-candidate committees to act as prominent forces in political races thanks to the Supreme Court's 2010 decision in Citizens United v. Federal Election Commission, which allowed corporations, nonprofits, unions and special interests to raise and spend unlimited amounts of money to advocate for or against politicians. Mississippi's primary slugfest also marks a far cry from 2008, when Cochran raised just $2.7 million during his entire re-election campaign.",
  'title': u"Mississippi's super PAC-dominated Senate slugfest not over yet",
  'url': u'http://www.publicintegrity.org/2014/06/04/14891/mississippis-super-pac-dominated-senate-slugfest-not-over-yet'},
 {'article_html': u'<p>For <a href="https://www.publicintegrity.org/health/medicare/medicare-advantage-money-grab">this series</a>, the Center for Public Integrity analyzed Medicare Advantage (MA) data obtained from the Centers for Medicare and Medicaid Services (CMS). The data contained enrollment and payment information for MA contract-plans and Fee-For-Service (FFS or traditional Medicare) payment data by county, downloaded from three CMS web pages: <a href="http://www.cms.gov/Medicare/Medicare-Advantage/Plan-Payment/Plan-Payment-Data.html">CMS Plan Payment Data</a>,&nbsp;<a href="http://www.cms.gov/Research-Statistics-Data-and-Systems/Statistics-Trends-and-Reports/MCRAdvPartDEnrolData/Monthly-Enrollment-by-Contract-Plan-State-County.html">CMS Monthly Enrollment</a>&nbsp;and&nbsp;<a href="http://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/FFS-Data.html">Fee-For-Service Data</a>.</p>\n\n<p>Brian Biles, an MD and professor in the Department of Health Policy at George Washington University, and Giselle Casillas, an MPP and senior research assistant at the GWU, offered methodology advice and helped guide parts of the analysis.</p>\n\n<p>The Center used monthly enrollment data from March as enrollment remains relatively stable that month. Because of regulations in the Health Insurance Portability and Accountability Act (HIPAA), small Medicare Advantage plans with 10 or less people are omitted from the data so that patient identities remain private. These CMS public data contain no patient-level information other than aggregated enrollment figures.</p>\n\n<p>We analyzed data covering 2007 to 2011. After the Center completed its analysis, CMS released 2012 data.</p>\n\n<p>A key to understanding cost differences between MA and traditional Medicare lies in comparing the risk score in each plan and each county. To accomplish the comparison, MA data were weighted by insurance plan county enrollment as Fee-For-Service (FFS) risk score data was only available on the county level. Weighted risk scores were calculated by taking county total enrollment, further broken down by the MA providers\u2019 total enrollment in that county, and weighting the risk score by that number. We weighted the payments by county enrollments, similar to methodology used by the Medicare Payment Advisory Commission (MedPAC).</p>\n\n<p>To compare annual payments instead of monthly costs between MA and traditional Medicare, the weighted base payment for each county for MA plans and the FFS base payments were multiplied by twelve.</p>\n\n<p>For the annual payments at the national level, the Center excluded payments in Puerto Rico, as do most researchers working with MA data, due to significantly different Medicare billing there.</p>\n\n<p>Other limitations include CMS calculations of the traditional FFS risk scores, which are done on a rolling basis in 5-year groups rather than the single year calculation for MA risk scores. Small risk scores changes and differences, though, can significantly add to costs to the taxpayer. The analysis only highlights plans with a wide gap between their risk scores and comparable FFS risk scores, or uses other descriptive measures, such as percentage change in MA risk scores. Also, many of the aggregated calculations are rounded down to eliminate any over estimations.</p>\n\n<p>The data behind the <a href="https://www.publicintegrity.org/2014/06/04/14866/how-risk-scores-changed">interactive graphic</a> comes from the same CMS data. The Center used the raw data or simple descriptive percentage change in MA risk score to highlight MA trends from 2007-2011.</p>\n\n<p>Calculating a national trend in risk scores is difficult at best. Limitations include the nature of the aggregated data provided by CMS and lack of more specific attributes related to patients who remain in the program through the years as compared with new enrollees. From the CMS data, calculations suggest the average risk score grew slightly under 2 percent. But a report from MedPAC suggest a projected 3 percent growth overall between just two of the years in the data. Finally, a Government Accountability Office Report suggests it could be higher. A 3 percent average is a conservative estimate for comparison purposes only.</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/4VNB-UBZXpA" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/4VNB-UBZXpA'],
  'article_links': ['http://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/FFS-Data.html',
   'http://www.cms.gov/Research-Statistics-Data-and-Systems/Statistics-Trends-and-Reports/MCRAdvPartDEnrolData/Monthly-Enrollment-by-Contract-Plan-State-County.html',
   'https://www.publicintegrity.org/2014/06/04/14866/how-risk-scores-changed',
   'http://www.cms.gov/Medicare/Medicare-Advantage/Plan-Payment/Plan-Payment-Data.html',
   'https://www.publicintegrity.org/health/medicare/medicare-advantage-money-grab'],
  'authors': [u'Erin Durkin', u'David Donald'],
  'datetime': datetime.datetime(2014, 6, 5, 15, 8, 46, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Medicare', u'Medicare Advantage Money Grab'],
  'text': u'For this series, the Center for Public Integrity analyzed Medicare Advantage (MA) data obtained from the Centers for Medicare and Medicaid Services (CMS). The data contained enrollment and payment information for MA contract-plans and Fee-For-Service (FFS or traditional Medicare) payment data by county, downloaded from three CMS web pages: CMS Plan Payment Data,CMS Monthly EnrollmentandFee-For-Service Data. Brian Biles, an MD and professor in the Department of Health Policy at George Washington University, and Giselle Casillas, an MPP and senior research assistant at the GWU, offered methodology advice and helped guide parts of the analysis. The Center used monthly enrollment data from March as enrollment remains relatively stable that month. Because of regulations in the Health Insurance Portability and Accountability Act (HIPAA), small Medicare Advantage plans with 10 or less people are omitted from the data so that patient identities remain private. These CMS public data contain no patient-level information other than aggregated enrollment figures. We analyzed data covering 2007 to 2011. After the Center completed its analysis, CMS released 2012 data. A key to understanding cost differences between MA and traditional Medicare lies in comparing the risk score in each plan and each county. To accomplish the comparison, MA data were weighted by insurance plan county enrollment as Fee-For-Service (FFS) risk score data was only available on the county level. Weighted risk scores were calculated by taking county total enrollment, further broken down by the MA providers\u2019 total enrollment in that county, and weighting the risk score by that number. We weighted the payments by county enrollments, similar to methodology used by the Medicare Payment Advisory Commission (MedPAC). To compare annual payments instead of monthly costs between MA and traditional Medicare, the weighted base payment for each county for MA plans and the FFS base payments were multiplied by twelve. For the annual payments at the national level, the Center excluded payments in Puerto Rico, as do most researchers working with MA data, due to significantly different Medicare billing there. Other limitations include CMS calculations of the traditional FFS risk scores, which are done on a rolling basis in 5-year groups rather than the single year calculation for MA risk scores. Small risk scores changes and differences, though, can significantly add to costs to the taxpayer. The analysis only highlights plans with a wide gap between their risk scores and comparable FFS risk scores, or uses other descriptive measures, such as percentage change in MA risk scores. Also, many of the aggregated calculations are rounded down to eliminate any over estimations. The data behind the interactive graphic comes from the same CMS data. The Center used the raw data or simple descriptive percentage change in MA risk score to highlight MA trends from 2007-2011. Calculating a national trend in risk scores is difficult at best. Limitations include the nature of the aggregated data provided by CMS and lack of more specific attributes related to patients who remain in the program through the years as compared with new enrollees. From the CMS data, calculations suggest the average risk score grew slightly under 2 percent. But a report from MedPAC suggest a projected 3 percent growth overall between just two of the years in the data. Finally, a Government Accountability Office Report suggests it could be higher. A 3 percent average is a conservative estimate for comparison purposes only.',
  'title': u"Methodology for 'Medicare Advantage Money Grab'",
  'url': u'http://www.publicintegrity.org/2014/06/04/14877/methodology-medicare-advantage-money-grab'},
 {'article_html': u'<p><strong>What is the difference between Medicare Advantage and Medicare?</strong></p>\n\n<p>They\u2019re two sides of the same coin. By choosing standard Medicare, people can visit any doctor they want. But they may have to buy supplemental insurance to cover gaps in what Medicare will pay for. This option is called \u201cfee-for-service.\u201d</p>\n\n<p>By contrast, Medicare Advantage plans accept a set fee from the government for covering a person\u2019s health care. The plans may provide extra benefits, including gym memberships and eyeglasses and cost patients less out of pocket than standard Medicare. Medicare Advantage is growing rapidly and now serves about 16 million people, about a third of all people on Medicare.</p>\n\n<p><strong>I\'m a taxpayer. Why does this matter to me?</strong></p>\n\n<p>It matters because it costs taxpayers $150 billion a year. Medicare costs are threatening to swamp the federal treasury and policymakers agree the program can ill afford waste and billing abuses. Young people should care about this spending so that Medicare will be there for them when they need it.</p>\n\n<p><strong>What are risk scores?</strong></p>\n\n<p>A risk score is a formula the government uses <a href="https://www.publicintegrity.org/2014/06/04/14866/how-risk-scores-changed">to pay Medicare Advantage plans</a>. The system is supposed <a href="https://www.publicintegrity.org/2014/06/04/14865/how-risk-scores-work">to pay higher rates for sicker patients</a> that are likely to require more costly medical services and less for healthy people.</p>\n\n<p><strong>Why were risk scores adopted?&nbsp;</strong></p>\n\n<p>Congress wanted to make sure health plans wouldn\u2019t shy away from taking sicker patients who could cost them more to treat.</p>\n\n<p><strong>I\'m covered under Medicare Advantage. Can I look up how my doctor uses risk scores?</strong></p>\n\n<p>No. The process goes on behind the scenes and it\u2019s so complicated many people in the health care industry don\u2019t fully understand how it works.</p>\n\n<p><strong>As the baby boomer generation ages, isn\'t it possible that the U.S. population is just sicker and requires more costly care?&nbsp;</strong></p>\n\n<p>It\u2019s hard to say definitively without knowing a lot of medical details about individual patients. The government has not made this sort of data available. We are hoping that <a href="https://www.publicintegrity.org/2014/05/27/14805/center-sues-effort-make-medicare-advantage-files-public">our lawsuit</a> will shed some light on this.</p>\n\n<p><strong>What does this alleged overbilling mean for Obamacare?</strong></p>\n\n<p>The Affordable Care Act is using risk scoring and some policy experts worry that the system will prove extremely difficult to police \u2014 especially given the government\u2019s history with Medicare Advantage.</p>\n\n<p><strong>Is there any chance of recouping any of the $70 billion in "improper" payments?</strong></p>\n\n<p>The Centers for Medicare and Medicaid Services, which runs the program, has broad authority to recoup overpayments, but has shown little interest in doing so. Instead, health plans suspected of overbilling have paid little penalty and can count on the government to keep their identities secret.</p>\n\n<p><strong>How did you come up with the idea of doing this investigation?</strong></p>\n\n<p>In 2012, we published the series <a href="http://www.publicintegrity.org/health/medicare/cracking-codes">Cracking the Codes</a>, which exposed how thousands of doctors had steadily billed higher rates over the past decade, costing taxpayers billions of dollars. After that, I wanted to look at Medicare Advantage because it has grown so quickly, costs taxpayers a bundle and has been the focus of much less scrutiny both from government and the media. For instance, Medicare officials have recently released vast amounts of billing data for fee-for-service Medicare, but are keeping Medicare Advantage data under wraps.</p>\n\n<p><strong>If you <a href="http://www.publicintegrity.org/2014/05/27/14805/center-sues-effort-make-medicare-advantage-files-public">didn\u2019t get a response</a> from your FOIA request, where did the data for this investigation come from?</strong></p>\n\n<p>Months and months of searching public records, including federal and state court records and websites, and interviewing experts. Given the sheer complexity of Medicare Advantage, federal officials must post a good deal of information online.</p>\n\n<p>There are also many health lawyers who advise the industry and data companies that assist with billing who discuss these issues online.&nbsp;</p>\n\n<p>CMS posted some limited Medicare Advantage data online (2007 through 2011) after a researcher sued them.</p>\n\n<p><strong>How would you augment this investigation if you were to receive records from your FOIA request?</strong></p>\n\n<p>We want to tell people how CMS makes decisions and how well it safeguards taxpayer dollars. That\u2019s very hard to gauge right now because the agency is secretive, won\u2019t grant interviews to the media and pretty much ignores requests for public information.</p>\n\n<p>We also want to know about political and lobbying pressures officials face \u2014 basically the same sort of accountability journalism we\u2019ve been doing at the Center for Public Integrity for years.</p>\n\n<p><strong>What\u2019s coming next?</strong></p>\n\n<p>We are committed to covering this program and <strong>greatly appreciate hearing from anyone</strong> with a story to tell about how it works.</p>\n\n<p>Are you a health professional or medical coder and have a story to tell about Medicare Advantage billing issues or \u201crisk scores\u201d?</p>\n\n<p>Or are you a patient in a Medicare Advantage plan and have been scheduled for a "home visit"? Let us know if the visit was helpful to you or not.</p>\n\n<p>Please email me at <a href="mailto:fschulte@publicintegrity.org">fschulte@publicintegrity.org</a> or call 202-481-1210.</p>\n\n<p><em>Have your own question for Fred? Leave it in the comments below, and if we can answer it, we\'ll do so and add it here.</em></p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/55JOCD8Dyz8" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/55JOCD8Dyz8'],
  'article_links': ['http://www.publicintegrity.org/2014/05/27/14805/center-sues-effort-make-medicare-advantage-files-public',
   'mailto:fschulte@publicintegrity.org',
   'http://www.publicintegrity.org/health/medicare/cracking-codes',
   'https://www.publicintegrity.org/2014/06/04/14866/how-risk-scores-changed',
   'https://www.publicintegrity.org/2014/06/04/14865/how-risk-scores-work',
   'https://www.publicintegrity.org/2014/05/27/14805/center-sues-effort-make-medicare-advantage-files-public'],
  'authors': [u'Fred Schulte', u'Sarah Whitmire'],
  'datetime': datetime.datetime(2014, 6, 6, 20, 8, 44, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Medicare', u'Medicare Advantage Money Grab'],
  'text': u'What is the difference between Medicare Advantage and Medicare? They\u2019re two sides of the same coin. By choosing standard Medicare, people can visit any doctor they want. But they may have to buy supplemental insurance to cover gaps in what Medicare will pay for. This option is called \u201cfee-for-service.\u201d By contrast, Medicare Advantage plans accept a set fee from the government for covering a person\u2019s health care. The plans may provide extra benefits, including gym memberships and eyeglasses and cost patients less out of pocket than standard Medicare. Medicare Advantage is growing rapidly and now serves about 16 million people, about a third of all people on Medicare. I\'m a taxpayer. Why does this matter to me? It matters because it costs taxpayers $150 billion a year. Medicare costs are threatening to swamp the federal treasury and policymakers agree the program can ill afford waste and billing abuses. Young people should care about this spending so that Medicare will be there for them when they need it. What are risk scores? A risk score is a formula the government uses to pay Medicare Advantage plans. The system is supposed to pay higher rates for sicker patients that are likely to require more costly medical services and less for healthy people. Why were risk scores adopted? Congress wanted to make sure health plans wouldn\u2019t shy away from taking sicker patients who could cost them more to treat. I\'m covered under Medicare Advantage. Can I look up how my doctor uses risk scores? No. The process goes on behind the scenes and it\u2019s so complicated many people in the health care industry don\u2019t fully understand how it works. As the baby boomer generation ages, isn\'t it possible that the U.S. population is just sicker and requires more costly care? It\u2019s hard to say definitively without knowing a lot of medical details about individual patients. The government has not made this sort of data available. We are hoping that our lawsuit will shed some light on this. What does this alleged overbilling mean for Obamacare? The Affordable Care Act is using risk scoring and some policy experts worry that the system will prove extremely difficult to police \u2014 especially given the government\u2019s history with Medicare Advantage. Is there any chance of recouping any of the $70 billion in "improper" payments? The Centers for Medicare and Medicaid Services, which runs the program, has broad authority to recoup overpayments, but has shown little interest in doing so. Instead, health plans suspected of overbilling have paid little penalty and can count on the government to keep their identities secret. How did you come up with the idea of doing this investigation? In 2012, we published the series Cracking the Codes, which exposed how thousands of doctors had steadily billed higher rates over the past decade, costing taxpayers billions of dollars. After that, I wanted to look at Medicare Advantage because it has grown so quickly, costs taxpayers a bundle and has been the focus of much less scrutiny both from government and the media. For instance, Medicare officials have recently released vast amounts of billing data for fee-for-service Medicare, but are keeping Medicare Advantage data under wraps. If you didn\u2019t get a response from your FOIA request, where did the data for this investigation come from? Months and months of searching public records, including federal and state court records and websites, and interviewing experts. Given the sheer complexity of Medicare Advantage, federal officials must post a good deal of information online. There are also many health lawyers who advise the industry and data companies that assist with billing who discuss these issues online. CMS posted some limited Medicare Advantage data online (2007 through 2011) after a researcher sued them. How would you augment this investigation if you were to receive records from your FOIA request? We want to tell people how CMS makes decisions and how well it safeguards taxpayer dollars. That\u2019s very hard to gauge right now because the agency is secretive, won\u2019t grant interviews to the media and pretty much ignores requests for public information. We also want to know about political and lobbying pressures officials face \u2014 basically the same sort of accountability journalism we\u2019ve been doing at the Center for Public Integrity for years. What\u2019s coming next? We are committed to covering this program and greatly appreciate hearing from anyone with a story to tell about how it works. Are you a health professional or medical coder and have a story to tell about Medicare Advantage billing issues or \u201crisk scores\u201d? Or are you a patient in a Medicare Advantage plan and have been scheduled for a "home visit"? Let us know if the visit was helpful to you or not. Please email me at fschulte@publicintegrity.org or call 202-481-1210. Have your own question for Fred? Leave it in the comments below, and if we can answer it, we\'ll do so and add it here.',
  'title': u'Explaining Medicare Advantage, and why it matters to you',
  'url': u'http://www.publicintegrity.org/2014/06/04/14876/explaining-medicare-advantage-and-why-it-matters-you'},
 {'article_html': u'<p>Josh Valdez took an executive level job in April 2010 expecting to improve medical services at two Puerto Rican Medicare Advantage health plans owned by a subsidiary of New Jersey company: Aveta Inc.</p>\n\n<p>But a few months after coming on board, the former government health official claims, he discovered that the plans \u2014 MMM Healthcare and PMC Medicare Choice \u2014 had been cheating Medicare out of hundreds of millions of dollars for years, <a href="https://www.documentcloud.org/documents/1177134-valdez-lawsuit-against-aveta.html">according to a whistleblower lawsuit</a> he filed in federal court.</p>\n\n<p>Valdez accuses the health plans of \u201crampant fraud,\u201d alleging they overcharged Medicare $300 million to $350 million a year from 2007 through 2010. He claims that Aveta Chief Executive Officer Richard Shinto fired him \u201cin retaliation for his outspoken opposition to these illegal practices.\u201d Valdez filed the lawsuit in Santa Ana, California, in April 2011, but it remained under court seal until February of this year. The case is pending.</p>\n\n<p>In a May 23 statement to the Center for Public Integrity, the health plans called Valdez a \u201cformer disgruntled employee\u201d and added that the company \u201ccategorically denies the allegations in the former employee\u2019s lawsuit and is highly confident that it will prevail in the case.\u201d</p>\n\n<p>Valdez is a veteran health care executive and consultant who headed the California regional office of the U.S. Department of Health and Human Services from 2001 through 2003 under President George W. Bush. He also was a health policy adviser to Republican Mitt Romney during the 2012 presidential race.</p>\n\n<p>Valdez said in court papers that he served as president of MSO of Puerto Rico, also owned by a subsidiary of Aveta, for eight months until his dismissal in December 2010. MSO worked with local doctors to coordinate coverage for some 230,000 elderly and disabled people then enrolled in those two Aveta-related Medicare Advantage health plans. In a press release touting his hire, Aveta said Valdez would enhance medical care while \u201ceffectively managing healthcare costs.\u201d</p>\n\n<p>Aveta\u2019s Puerto Rico health plans and MSO are now operated by InnovaCare Health Solutions, according to the firm\u2019s website. InnovoCare has the same Fort Lee, N.J. office and phone number as Aveta. Several members of the Aveta board, including founding principal investor Daniel E. Straus, have been affiliated with both companies. Innovacare general counsel Christopher J. Joyce declined to discuss the corporate structure.</p>\n\n<p>Straus, a prominent investor in several health-care businesses, also has worked with hedge funds and as a New York City real estate developer. Joyce said Straus would have no comment.</p>\n\n<p>The whistleblower suit is significant not only for the magnitude of overbilling it alleges. It also raises questions about federal oversight of billing practices by health plans that contract with the government to cover nearly 16 million Americans, at a cost expected to top $150 billion this year.</p>\n\n<p>The federal government paid the two Puerto Rico plans a total of between $1 billion and $1.8 billion annually from January 2007 through December 2010, according to the suit. Up to $350 million a year was for bills that were \u201cimproperly inflated,\u201d according to Valdez.</p>\n\n<p>Valdez argues that the health plans sought out chronically ill patients, who command the highest Medicare payment rates, but overcharged for them by manipulating a billing formula known as a \u201crisk score.\u201d Medicare sets risk scores for all patients based on medical data submitted by the health plans that indicates how sick patients are. Sicker patients mean higher rates.</p>\n\n<p>These scores \u201cwere false or fraudulent because they were based on diagnosis codes that were not substantiated by the medical records or by the medical conditions of the Medicare beneficiaries served by the plans,\u201d the suit states.</p>\n\n<p>Valdez said he was told by top executive Shinto in May 2010 that an internal audit of medical records had confirmed that two-thirds of patient risk scores could not be supported.</p>\n\n<p>According to Valdez, the audit results were discussed at several executive-level meetings, including some at which top brass talked about setting up a reserve fund in case federal officials should conduct their own review and demand refunds.</p>\n\n<p>At a July 2010 meeting, Penelope Kokkinides, Aveta\u2019s chief operating officer, allegedly said the company would be \u201cscrewed\u201d if it was audited by the federal Centers for Medicare and Medicaid Services, especially if the review reached back to 2007. She said overcharges had been \u201cparticularly egregious\u201d that year, as the suit paraphrased her alleged remarks.</p>\n\n<p>Kokkinides estimated the liability to the government was as high as 20 percent of its total Medicare payment, or about $350 million a year, Valdez alleges. Kokkinides would not comment on the suit.</p>\n\n<p>During his tenure there, Valdez said, company officials gave no indication they would \u201cnotify CMS of the problem or return the improperly obtained funds to the government,\u201d according to the suit. CMS regulations not only require Medicare Advantage plans to attest that risk data they present for payment are accurate but also obligate them to return any overpayments they discover.</p>\n\n<p>Still, CMS largely trusts the nation\u2019s 700 Medicare Advantage plans to report risk scores accurately and honestly \u2014 and conducts only a smattering of yearly audits. There\u2019s no indication that CMS officials reviewed the risk scores for the two Puerto Rican plans. In its 2012 annual financial report to insurance officials in Puerto Rico, MMM Healthcare stated that it had not been subject to a CMS payment audit.</p>\n\n<p>However, in late March of 2011, Valdez said he took his allegations to the U.S. Attorney\u2019s Office for the central district of California, which has since launched an investigation. That investigation \u201chas not been completed,\u201d government lawyers wrote in a January 2014 court filing.</p>\n\n<p>Valdez blamed the faulty risk scores on errors in \u201cmedical status visit\u201d forms filled out by the plans\u2019 doctors. The visits were done to help identify \u201chigh risk\u201d members and maximize payments for them. Doctors participated in a profit sharing arrangement that paid them 50 percent to 60 percent of surplus money that came in from Medicare as a result of the annual visits, according to the suit.</p>\n\n<p>The lawsuit alleges that company officials failed to take \u201ccorrective measures to delete or filter out\u201d inaccurate codes, although they knew the doctors had an incentive to inflate them.</p>\n\n<p>In July 2010, executives decided to hold onto millions of dollars in these payments to the doctors in case CMS auditors required the company to repay money, according to the suit.</p>\n\n<p>That concern didn\u2019t dissuade company officials from borrowing $100 million, which was used to pay a dividend to investors, \u201cthe largest of whom was founder and Chairman Daniel E. Straus,\u201d according to the suit. Valdez said he objected to paying the dividend while the potential liability to the government \u201cremained unaddressed.\u201d</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/4ZYZNXTipCo" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/4ZYZNXTipCo'],
  'article_links': ['https://www.documentcloud.org/documents/1177134-valdez-lawsuit-against-aveta.html'],
  'authors': [u'Fred Schulte'],
  'datetime': datetime.datetime(2014, 6, 6, 14, 55, 20, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Medicare', u'Medicare Advantage Money Grab'],
  'text': u'Josh Valdez took an executive level job in April 2010 expecting to improve medical services at two Puerto Rican Medicare Advantage health plans owned by a subsidiary of New Jersey company: Aveta Inc. But a few months after coming on board, the former government health official claims, he discovered that the plans \u2014 MMM Healthcare and PMC Medicare Choice \u2014 had been cheating Medicare out of hundreds of millions of dollars for years, according to a whistleblower lawsuit he filed in federal court. Valdez accuses the health plans of \u201crampant fraud,\u201d alleging they overcharged Medicare $300 million to $350 million a year from 2007 through 2010. He claims that Aveta Chief Executive Officer Richard Shinto fired him \u201cin retaliation for his outspoken opposition to these illegal practices.\u201d Valdez filed the lawsuit in Santa Ana, California, in April 2011, but it remained under court seal until February of this year. The case is pending. In a May 23 statement to the Center for Public Integrity, the health plans called Valdez a \u201cformer disgruntled employee\u201d and added that the company \u201ccategorically denies the allegations in the former employee\u2019s lawsuit and is highly confident that it will prevail in the case.\u201d Valdez is a veteran health care executive and consultant who headed the California regional office of the U.S. Department of Health and Human Services from 2001 through 2003 under President George W. Bush. He also was a health policy adviser to Republican Mitt Romney during the 2012 presidential race. Valdez said in court papers that he served as president of MSO of Puerto Rico, also owned by a subsidiary of Aveta, for eight months until his dismissal in December 2010. MSO worked with local doctors to coordinate coverage for some 230,000 elderly and disabled people then enrolled in those two Aveta-related Medicare Advantage health plans. In a press release touting his hire, Aveta said Valdez would enhance medical care while \u201ceffectively managing healthcare costs.\u201d Aveta\u2019s Puerto Rico health plans and MSO are now operated by InnovaCare Health Solutions, according to the firm\u2019s website. InnovoCare has the same Fort Lee, N.J. office and phone number as Aveta. Several members of the Aveta board, including founding principal investor Daniel E. Straus, have been affiliated with both companies. Innovacare general counsel Christopher J. Joyce declined to discuss the corporate structure. Straus, a prominent investor in several health-care businesses, also has worked with hedge funds and as a New York City real estate developer. Joyce said Straus would have no comment. The whistleblower suit is significant not only for the magnitude of overbilling it alleges. It also raises questions about federal oversight of billing practices by health plans that contract with the government to cover nearly 16 million Americans, at a cost expected to top $150 billion this year. The federal government paid the two Puerto Rico plans a total of between $1 billion and $1.8 billion annually from January 2007 through December 2010, according to the suit. Up to $350 million a year was for bills that were \u201cimproperly inflated,\u201d according to Valdez. Valdez argues that the health plans sought out chronically ill patients, who command the highest Medicare payment rates, but overcharged for them by manipulating a billing formula known as a \u201crisk score.\u201d Medicare sets risk scores for all patients based on medical data submitted by the health plans that indicates how sick patients are. Sicker patients mean higher rates. These scores \u201cwere false or fraudulent because they were based on diagnosis codes that were not substantiated by the medical records or by the medical conditions of the Medicare beneficiaries served by the plans,\u201d the suit states. Valdez said he was told by top executive Shinto in May 2010 that an internal audit of medical records had confirmed that two-thirds of patient risk scores could not be supported. According to Valdez, the audit results were discussed at several executive-level meetings, including some at which top brass talked about setting up a reserve fund in case federal officials should conduct their own review and demand refunds. At a July 2010 meeting, Penelope Kokkinides, Aveta\u2019s chief operating officer, allegedly said the company would be \u201cscrewed\u201d if it was audited by the federal Centers for Medicare and Medicaid Services, especially if the review reached back to 2007. She said overcharges had been \u201cparticularly egregious\u201d that year, as the suit paraphrased her alleged remarks. Kokkinides estimated the liability to the government was as high as 20 percent of its total Medicare payment, or about $350 million a year, Valdez alleges. Kokkinides would not comment on the suit. During his tenure there, Valdez said, company officials gave no indication they would \u201cnotify CMS of the problem or return the improperly obtained funds to the government,\u201d according to the suit. CMS regulations not only require Medicare Advantage plans to attest that risk data they present for payment are accurate but also obligate them to return any overpayments they discover. Still, CMS largely trusts the nation\u2019s 700 Medicare Advantage plans to report risk scores accurately and honestly \u2014 and conducts only a smattering of yearly audits. There\u2019s no indication that CMS officials reviewed the risk scores for the two Puerto Rican plans. In its 2012 annual financial report to insurance officials in Puerto Rico, MMM Healthcare stated that it had not been subject to a CMS payment audit. However, in late March of 2011, Valdez said he took his allegations to the U.S. Attorney\u2019s Office for the central district of California, which has since launched an investigation. That investigation \u201chas not been completed,\u201d government lawyers wrote in a January 2014 court filing. Valdez blamed the faulty risk scores on errors in \u201cmedical status visit\u201d forms filled out by the plans\u2019 doctors. The visits were done to help identify \u201chigh risk\u201d members and maximize payments for them. Doctors participated in a profit sharing arrangement that paid them 50 percent to 60 percent of surplus money that came in from Medicare as a result of the annual visits, according to the suit. The lawsuit alleges that company officials failed to take \u201ccorrective measures to delete or filter out\u201d inaccurate codes, although they knew the doctors had an incentive to inflate them. In July 2010, executives decided to hold onto millions of dollars in these payments to the doctors in case CMS auditors required the company to repay money, according to the suit. That concern didn\u2019t dissuade company officials from borrowing $100 million, which was used to pay a dividend to investors, \u201cthe largest of whom was founder and Chairman Daniel E. Straus,\u201d according to the suit. Valdez said he objected to paying the dividend while the potential liability to the government \u201cremained unaddressed.\u201d',
  'title': u'Whistleblower suit says health plan cheated government out of more than $1 billion',
  'url': u'http://www.publicintegrity.org/2014/06/04/14841/whistleblower-suit-says-health-plan-cheated-government-out-more-1-billion'},
 {'article_html': u'<p><em>First in a three-part <a href="https://www.publicintegrity.org/health/medicare/medicare-advantage-money-grab">series</a>.</em></p>\n\n<p>In South Florida, one of the nation\u2019s top privately-run Medicare insurance plans faces a federal investigation into allegations that it overbilled the government by exaggerating how sick some of its patients were.</p>\n\n<p>In the Las Vegas area, private health care plans for seniors ran up more than $100 million in added Medicare charges after asserting patients they signed up also were much sicker than normal \u2014 a claim many experts have challenged.</p>\n\n<p>In Rochester, New York, a Medicare plan was paid $41 million to treat people with serious diseases \u2014 even though the plan couldn\u2019t prove the patients in fact had those diseases.</p>\n\n<p>These health plans and hundreds of others are part of Medicare Advantage, a program created by Congress in 2003 to help stabilize health care spending on the elderly. But the plans have sharply driven up costs in many parts of the United States \u2014 larding on tens of billions of dollars in overcharges and other suspect billings based in part on inflated assessments of how sick patients are, an investigation by the <a href="http://www.publicintegrity.org">Center for Public Integrity</a> has found.</p>\n\n<p>Dominated by private insurers, Medicare Advantage now covers nearly 16 million Americans at a cost expected to top $150 billion this year. Many seniors choose the managed-care Medicare Advantage option instead of the traditional government-run Medicare program because it fills gaps in coverage, can cost less in out-of-pocket expenses and offers extra benefits, such as dental and eye care.</p>\n\n<p>But billions of tax dollars are misspent every year through billing errors linked to a payment tool called a \u201crisk score,\u201d which is supposed to pay Medicare Advantage plans higher rates for sicker patients and less for those in good health.</p>\n\n<p>Government officials have struggled for years to halt health plans from running up patient risk scores and, in many cases, wresting higher Medicare payments than they deserve, records show.</p>\n\n<p>The Center\u2019s findings are based on an analysis of Medicare Advantage enrollment data from 2007 through 2011, as well as thousands of pages of government audits, research papers and other documents.</p>\n\n<p>Federal officials who run the Medicare program repeatedly refused to be interviewed or answer written questions.</p>\n\n<p>Among the findings:</p>\n\n<ul>\n\t<li>Risk score errors triggered nearly $70 billion in \u201cimproper\u201d payments to Medicare Advantage plans from 2008 through 2013 \u2014 mostly overbillings, according to government estimates.&nbsp;Federal officials refused to identify health plans suspected of overcharging Medicare, citing agency policy that keeps many business records confidential. The Center <a href="https://www.publicintegrity.org/2014/05/27/14805/center-sues-effort-make-medicare-advantage-files-public">is suing to make these records public</a>.</li>\n\t<li>Risk scores of Medicare Advantage patients rose sharply in plans in at least 1,000 counties nationwide between 2007 and 2011, boosting taxpayer costs by more than $36 billion over estimated costs for caring for patients in standard Medicare.</li>\n\t<li>In more than 200 of these counties, the cost of some Medicare Advantage plans was&nbsp;<a href="https://www.publicintegrity.org/2014/06/04/14866/how-risk-scores-changed">at least 25 percent higher</a> than the cost of providing standard Medicare coverage. The wide swing in costs was most evident in five states: South Dakota, New Mexico, Colorado, Texas and Arkansas.</li>\n</ul>\n<p>Some academic experts and researchers believe the increase in risk scores is more likely to reflect aggressive billing than a rapid deterioration in patients\u2019 health.</p>\n\n<p>Industry executives don\u2019t dispute that billing errors occur. But they deny that they charge too much, arguing they only want to be paid fairly for their services.</p>\n\n<p>Clare Krusing, director of communications for America\u2019s Health Insurance Plans, said that the industry trade group is \u201cworking together\u201d with federal health officials to improve reporting of risk score data.</p>\n\n<p>In the South Florida case, government lawyers have been investigating Humana, Inc. for several years as they try to determine if the company and some of its medical clinics manipulated the complex Medicare Advantage billing system. Humana says it is cooperating with the investigation.</p>\n\n<p>In a separate civil case, a former Bush administration health official alleges in a whistleblower lawsuit unsealed earlier this year that two Puerto Rico health plans cheated Medicare out of as much as $1 billion by inflating patient risk scores. The plans, which at the time were owned by a subsidiary of New-Jersey based Aveta, Inc., <a href="https://www.publicintegrity.org/2014/06/04/14841/whistleblower-suit-says-health-plan-cheated-government-out-more-1-billion">denied the allegations</a>.</p>\n\n<p>Government audits and research reports have warned for years that Medicare\u2019s risk scoring formula breeds overbilling, but efforts to hold the industry accountable have met with little success. Federal officials have yet to recoup hundreds of millions of dollars in suspected overpayments to health plans that date back as far as 2007.</p>\n\n<p>Excellus Health Plan, the Rochester, New York, health plan that federal auditors said may have overbilled by as much as $41 million in 2007 for treating patients with serious diseases, paid but a fraction of that amount back years later. A company spokesman said the plan settled the matter by paying the government $157,777 in December 2013.</p>\n\n<p>Some critics expect little to change unless federal officials disclose Medicare Advantage plans\u2019 full service and billing histories \u2014 as they have recently&nbsp;<a href="http://blog.cms.gov/2014/04/23/interactive-tool-allows-easier-access-data-on-physicians/">done</a>&nbsp;with Medicare fees paid to more than 880,000 individual doctors and others.</p>\n\n<p>\u201cThe [Medicare Advantage] plans don\u2019t want the data out,\u201d said&nbsp;<a href="http://publichealth.gwu.edu/faculty/index.cfm?empName=%20Brian%20Biles&amp;employeeID=24">Dr. Brian Biles</a>, a professor in the Department of Health Policy at George Washington University, whose Freedom of Information Act lawsuits shook loose limited enrollment records used in this project. (Biles assisted Center for Public Integrity reporters with the analysis.)</p>\n\n<p><a href="http://tdi.dartmouth.edu/faculty/david-wennberg-mph">Dr. David Wennberg</a>, a Dartmouth Institute researcher who has studied the payment issue, said that with billions of tax dollars at stake federal officials need to hit the \u201creset button\u201d on risk scoring.</p>\n\n<p>Wennberg said Medicare Advantage \u201cis a very large program with lots of money flowing through it. There are always vested interests in protecting the status quo.\u201d</p>\n<p><strong>Health care politics</strong></p>\n\n<p>The Affordable Care Act, or Obamacare, orders deep rate cuts in Medicare Advantage, partly to cover millions of uninsured people. That\u2019s consistent with an early Obama administration promise to reduce payments to the health insurers.</p>\n\n<p>But support for Medicare Advantage in Congress has snowballed as it has attracted more and more seniors who are happy with their care and the price they pay for it. Earlier this year, the insurance industry mounted a fierce media campaign to block the rate cuts, enlisting support from more than 200 members of Congress and forcing the administration to partially back off.</p>\n\n<p>The debate over how best to pay Medicare Advantage health plans \u2014 and how to curb overcharging \u2014 has been contentious for years.</p>\n\n<p>As far back as the 1980s, Congress hoped that carving a bigger role for managed care plans like Medicare Advantage would help curtail overall Medicare spending and ward off waste and fraud that can pop up when doctors and hospitals are paid for each and every service they perform.</p>\n\n<p>To that end, Medicare decided to pay health plans a set monthly rate for patients regardless of how much care they needed. But some health plans stacked the deck by signing up people who were healthier than average, a marketing ploy known in insurance circles as \u201ccherry picking.\u201d</p>\n\n<p>That led to a \u201clot of game playing\u201d and \u201cdumping patients who were ill,\u201d said Laurence Bishoff, a Boston health care consultant.</p>\n\n<p>Congress thought it saw a remedy in the Medicare Modernization Act of 2003. The law created Medicare Advantage and phased in \u201crisk adjusted\u201d payments starting a year later.</p>\n<p><a href="http://www.alston.com/professionals/thomas-scully/">Thomas Scully</a>, who helped get the program running under President George W. Bush, said rates were generous in hopes of enticing insurers to expand their Medicare business and not shy away from people in poor health.</p>\n\n<p>\u201cWe very intentionally tried to overpay them a little bit,\u201d said Scully, now a Washington lobbyist with numerous health care industry clients.</p>\n\n<p>Health status was added to other factors such as sex, race and age in setting rates. Plans that took on the greatest risk by accepting the sickest patients were paid the most.</p>\n\n<p>But turning to risk scores as the way to adjust payments ushered in a new form of Medicare billing abuse: Some health plans misstated how sick their patients were or failed to document they had treated illnesses Medicare paid them to treat, the Center\u2019s investigation found.</p>\n\n<p>By 2009, government officials were estimating that just over 15 percent of total Medicare Advantage payments were inaccurate, about $12 billion that year.</p>\n\n<p>By the end of 2013, officials reported the error rate had dropped to nine percent, which still added up to $11.8 billion for the year. Nearly 80 percent of that \u2014 $9.3 billion \u2014 was overcharges, records show.</p>\n<p>The Medicare Advantage billing error rate has averaged 12 percent over the past six years, at times outpacing that of standard government-run Medicare, which federal officials assert is highly vulnerable to billing fraud and abuse.</p>\n\n<p>Medicare Advantage has faced much less scrutiny. The federal Centers for Medicare and Medicaid Services didn\u2019t try to recoup overpayments until 2012, eight years after phasing in risk scoring. And when it did, it won back only $3.4 million \u2014 a tiny fraction of the estimated losses, according to government records. Though the agency is beefing up collection efforts starting this year, most health plans won\u2019t see federal auditors for years.</p>\n\n<p><a href="http://www.hks.harvard.edu/about/faculty-staff-directory/malcolm-sparrow">Malcolm Sparrow</a>, a professor at Harvard University\u2019s John F. Kennedy School of Government and health fraud expert, said officials are \u201casking for trouble\u201d by allowing health plans to generate the data on which risk scores and their revenues are based.</p>\n\n<p>\u201cYou want to make sure this is audited rigorously,\u201d Sparrow said. \u201cIt\u2019s much more expensive [to taxpayers] not to.\u201d</p>\n\n<p><strong>Federal probe</strong></p>\n\n<p>Four of the ten major Medicare Advantage plans with the highest average risk scores nationally are in Puerto Rico.</p>\n\n<p>Medicare Advantage plans, which control 70 percent of the island market, argue their patients are poorer and sicker than average. They also say that cuts required under the Affordable Care Act have hit them hard, prompting cuts in benefits and higher premiums for patients who can ill afford to pay more.</p>\n<p>Risk scores at the two Aveta-related health plans, MMM Healthcare and Preferred Medical Choice, shot up by an average of 11 percent from 2007 through 2011. Nationwide, the growth rate averaged three percent over the same period. The company had no comment.</p>\n\n<p>San Juan-based Medical Card System, known by the initials MCS, reported a 5 percent rise in the scores over the same time \u2014 nearly twice the national average.</p>\n\n<p>The billing practices also have attracted legal scrutiny. The whistleblower lawsuit filed against Aveta by former executive Jose R. \u201cJosh\u201d Valdez alleges that the company overbilled Medicare by as much as $1 billion by inflating risk scores.</p>\n\n<p>Valdez alleges that Aveta paid its stockholders a $100 million dividend during the time that it was overcharging Medicare.</p>\n\n<p>MCS has faced its troubles over risk scores, too.</p>\n\n<p>Federal agents searched the MCS tower headquarters on Oct. 13, 2011. MCS said in a 2012 financial statement that it had received four grand jury subpoenas as part of a U.S. Attorney\u2019s Office investigation of its \u201crisk adjustment data reporting.\u201d</p>\n\n<p>MCS said the company conducted an \u201cinternal review\u201d that found no wrongdoing, but prompted it to return an \u201cimmaterial\u201d amount of money to Medicare.</p>\n\n<p>In an April interview inside the MCS tower in San Juan\u2019s Hato Rey financial district, Chief Executive Officer Jim O\u2019Drobinak said the federal probe has ended and MCS has been cleared.</p>\n\n<p>\u201cNothing came of it,\u201d he said, blaming the investigation on a \u201cdisgruntled former employee.\u201d Law enforcement sources confirmed that the investigation has been closed.</p>\n\n<p>Dr. In\xe9s Hern\xe1ndez, MCS chief medical officer, said that the health plan has moved aggressively to treat patients in their homes and identify diseases so they can be treated in the early stages.</p>\n\n<p>\u201cWe\u2019re not just getting information for risk scores,\u201d she said.</p>\n\n<p>But CMS officials have been concerned that home visits and other health assessments by health plans can contribute to higher risk scores \u2014 and drive up costs without benefiting patients by providing them with more care.</p>\n<p><strong>Over/under</strong></p>\n\n<p>Congressional auditors and some lawmakers have asserted for years that overpayments to Medicare Advantage plans may be much higher than federal officials have acknowledged.</p>\n\n<p>Among the most steadfast critics is Rep. Henry Waxman, D-Calif. In a March 6, 2009, letter to an agency official, he argued that Medicare Advantage plans were a bad deal for taxpayers because each illness they discover, \u201cwhether it is treated or not can increase the payment the plan receives from CMS.\u201d</p>\n\n<p>Waxman, who then chaired the House Energy and Commerce Committee, criticized health plans for figuring out how to \u201cmanipulate\u201d risk scores to wrest money they didn\u2019t deserve from Medicare.</p>\n\n<p>CMS officials have conceded that risk scores rose much faster for Medicare Advantage patients than for those in standard Medicare and that the rise couldn\u2019t be explained away by saying that the health plan members were sicker.</p>\n\n<p>Starting in 2010, they stepped in and cut payments to Medicare Advantage plans to offset rising risk scores.</p>\n\n<p>Yet in January 2012 the Government Accountability Office, the watchdog arm of Congress,&nbsp;<a href="http://www.gao.gov/assets/590/587637.pdf">said</a>&nbsp;that the cuts weren\u2019t deep enough and opined that Medicare could have saved as much as $3 billion a year by reducing risk scores further.</p>\n\n<p>A year later, the GAO went a step further. A January 2013&nbsp;<a href="http://www.gao.gov/assets/660/651712.pdf">report</a>&nbsp;said CMS made \u201cexcess payments\u201d to Medicare Advantage plans of between $3.2 billion and $5.1 billion between 2010 and the end of 2012 because risk scores were higher than justified.</p>\n\n<p>The Center for Public Integrity data analysis found that Medicare Advantage can cost the government as much as 25 percent more than standard Medicare in some areas.</p>\n\n<p>The data analysis also found that seemingly tiny variations in risk scores can boost taxpayer costs enormously \u2014 especially in health plans that are growing fast.</p>\n\n<p>Industry officials have a different take.</p>\n\n<p>They argue that their members tend to have lower incomes than the elderly population as a whole and have a higher risk of needing expensive medical care.</p>\n\n<p>\u201cThey have looked healthier because of incompleteness of this data,\u201d said&nbsp;<a href="https://www.gormanhealthgroup.com/who-we-are/our-people/executive-team/john-gorman">John Gorman</a>, a former federal health official who is now a prominent Medicare Advantage consultant.</p>\n\n<p>Others blame the sheer complexity of risk-scoring for causing confusion about billing.</p>\n\n<p>Jim Redmond, a vice president at Excellus Health Plan, which federal auditors in 2012 said couldn\u2019t always document illnesses it was paid to treat, denied any impropriety. He said the billing system was \u201cestablished with good intentions\u201d but \u201cdidn\u2019t fully recognize\u201d how difficult it would be for health plans to oversee.</p>\n\n<p>\u201cWe have more than 18,000 physicians submitting claims to us every day. We audit a portion of the claims and medical records for accuracy, completeness and consistency,\u201d Redmond wrote in an email.&nbsp;</p>\n\n<p>\u201cHowever, the medical delivery system would grind to a halt if we made every provider submit all of the documentation for each and every claim they file on behalf of members.\u201d&nbsp;</p>\n\n<p>Court records show that the billing system\u2019s complexity has stymied government investigators reviewing a whistleblower lawsuit filed in 2010 by physician Olivia Graves against Humana.</p>\n\n<p>Graves, who has practiced in South Florida for more than three decades,&nbsp;<a href="http://www.publicintegrity.org/2014/05/16/14772/feds-investigating-allegations-humana-inc-overcharged-medicare-advantage-program">alleges</a>&nbsp;that a Humana-owned clinic diagnosed patients with conditions such as diabetes with complications, which boosted Medicare payments. She alleged that those diagnoses were \u201cnot supported by the medical records.\u201d Her suit alleges that Humana knew about the alleged overcharging and did nothing to stop it..</p>\n\n<p>The U.S. Attorney\u2019s Office declined to join the South Florida case even though a federal judge granted it 11 requests for more time to investigate. They argued lawyers and other government personnel \u201chad little or no experience in the applicable regulations and operations of the [Medicare Advantage] program\u201d However, government lawyers said their investigation is continuing.</p>\n\n<p>The case was unsealed in May and is pending.</p>\n\n<p>Humana also faces other investigations into allegations that it overbilled the government, including a criminal investigation by the Department of Justice in Washington and a criminal case involving the U.S. Attorney\u2019s branch office in West Palm Beach, Florida, according to court records. Humana spokesman Tom Noland said \u201cHumana to our knowledge is not the subject of a criminal investigation.\u201d</p>\n<p><strong>\u2018Black box\u2019</strong></p>\n\n<p>Many researchers are hoping that CMS will make public detailed Medicare Advantage billing and service data that might allow them to assess how well risk scoring is doing in predicting costs. They also want to study industry claims that they are treating lower income and sicker patients.</p>\n\n<p>But that\u2019s not yet possible because CMS has shown little interest in making Medicare Advantage data public.</p>\n\n<p>That\u2019s quite a different stance than the agency took in April, when it released detailed information about how much individual doctors were paid by Medicare. The decision drew criticism from the American Medical Association, which has argued that it violated the privacy of doctors. CMS principal deputy administrator Jonathan Blum, who left the agency in May, previously announced on his&nbsp;<a href="http://blog.cms.gov/2014/04/02/next-steps-in-medicare-data-transparency/">blog</a>&nbsp;that data \u201ccan shine a light on how care is delivered in the Medicare program.\u201d</p>\n\n<p>Sparrow, the fraud expert from Harvard, said that it should be easier for the government to cough up information about huge health care corporations than about individual physicians. The doctor billing data covers about $77 billion in taxpayer spending for 2012, about half the Medicare Advantage price tag.</p>\n\n<p>\u201cAnything that starts with a \u2018b\u2019 seems like a lot of money to me,\u201d Sparrow said, adding that Medicare Advantage financial data and other records \u201cought to be a matter of ordinary public record.\u201d</p>\n\n<p>Medicare Advantage is a \u201cblack box,\u201d added James Cosgrove, who heads health investigations for the GAO, the audit arm of Congress.</p>\n\n<p>\u201cWe know what services they say they will provide \u2026 but we never know exactly what services are being provided,\u201d Cosgrove said.</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/Ko5bS0OKaR4" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/Ko5bS0OKaR4'],
  'article_links': ['http://www.alston.com/professionals/thomas-scully',
   'http://www.gao.gov/assets/590/587637.pdf',
   'http://www.publicintegrity.org/2014/05/16/14772/feds-investigating-allegations-humana-inc-overcharged-medicare-advantage-program',
   'https://www.publicintegrity.org/2014/06/04/14841/whistleblower-suit-says-health-plan-cheated-government-out-more-1-billion',
   'https://www.publicintegrity.org/2014/06/04/14866/how-risk-scores-changed',
   'http://www.gao.gov/assets/660/651712.pdf',
   'http://publichealth.gwu.edu/faculty/index.cfm',
   'http://www.publicintegrity.org',
   'http://blog.cms.gov/2014/04/02/next-steps-in-medicare-data-transparency',
   'https://www.gormanhealthgroup.com/who-we-are/our-people/executive-team/john-gorman',
   'http://www.hks.harvard.edu/about/faculty-staff-directory/malcolm-sparrow',
   'http://tdi.dartmouth.edu/faculty/david-wennberg-mph',
   'http://blog.cms.gov/2014/04/23/interactive-tool-allows-easier-access-data-on-physicians',
   'https://www.publicintegrity.org/health/medicare/medicare-advantage-money-grab',
   'https://www.publicintegrity.org/2014/05/27/14805/center-sues-effort-make-medicare-advantage-files-public'],
  'authors': [u'Erin Durkin', u'Fred Schulte', u'David Donald'],
  'datetime': datetime.datetime(2014, 6, 4, 9, 0, 1, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Medicare', u'Medicare Advantage Money Grab'],
  'text': u'First in a three-part series. In South Florida, one of the nation\u2019s top privately-run Medicare insurance plans faces a federal investigation into allegations that it overbilled the government by exaggerating how sick some of its patients were. In the Las Vegas area, private health care plans for seniors ran up more than $100 million in added Medicare charges after asserting patients they signed up also were much sicker than normal \u2014 a claim many experts have challenged. In Rochester, New York, a Medicare plan was paid $41 million to treat people with serious diseases \u2014 even though the plan couldn\u2019t prove the patients in fact had those diseases. These health plans and hundreds of others are part of Medicare Advantage, a program created by Congress in 2003 to help stabilize health care spending on the elderly. But the plans have sharply driven up costs in many parts of the United States \u2014 larding on tens of billions of dollars in overcharges and other suspect billings based in part on inflated assessments of how sick patients are, an investigation by the Center for Public Integrity has found. Dominated by private insurers, Medicare Advantage now covers nearly 16 million Americans at a cost expected to top $150 billion this year. Many seniors choose the managed-care Medicare Advantage option instead of the traditional government-run Medicare program because it fills gaps in coverage, can cost less in out-of-pocket expenses and offers extra benefits, such as dental and eye care. But billions of tax dollars are misspent every year through billing errors linked to a payment tool called a \u201crisk score,\u201d which is supposed to pay Medicare Advantage plans higher rates for sicker patients and less for those in good health. Government officials have struggled for years to halt health plans from running up patient risk scores and, in many cases, wresting higher Medicare payments than they deserve, records show. The Center\u2019s findings are based on an analysis of Medicare Advantage enrollment data from 2007 through 2011, as well as thousands of pages of government audits, research papers and other documents. Federal officials who run the Medicare program repeatedly refused to be interviewed or answer written questions. Among the findings: Risk score errors triggered nearly $70 billion in \u201cimproper\u201d payments to Medicare Advantage plans from 2008 through 2013 \u2014 mostly overbillings, according to government estimates.Federal officials refused to identify health plans suspected of overcharging Medicare, citing agency policy that keeps many business records confidential. The Center is suing to make these records public. Risk scores of Medicare Advantage patients rose sharply in plans in at least 1,000 counties nationwide between 2007 and 2011, boosting taxpayer costs by more than $36 billion over estimated costs for caring for patients in standard Medicare. In more than 200 of these counties, the cost of some Medicare Advantage plans wasat least 25 percent higher than the cost of providing standard Medicare coverage. The wide swing in costs was most evident in five states: South Dakota, New Mexico, Colorado, Texas and Arkansas. Some academic experts and researchers believe the increase in risk scores is more likely to reflect aggressive billing than a rapid deterioration in patients\u2019 health. Industry executives don\u2019t dispute that billing errors occur. But they deny that they charge too much, arguing they only want to be paid fairly for their services. Clare Krusing, director of communications for America\u2019s Health Insurance Plans, said that the industry trade group is \u201cworking together\u201d with federal health officials to improve reporting of risk score data. In the South Florida case, government lawyers have been investigating Humana, Inc. for several years as they try to determine if the company and some of its medical clinics manipulated the complex Medicare Advantage billing system. Humana says it is cooperating with the investigation. In a separate civil case, a former Bush administration health official alleges in a whistleblower lawsuit unsealed earlier this year that two Puerto Rico health plans cheated Medicare out of as much as $1 billion by inflating patient risk scores. The plans, which at the time were owned by a subsidiary of New-Jersey based Aveta, Inc., denied the allegations. Government audits and research reports have warned for years that Medicare\u2019s risk scoring formula breeds overbilling, but efforts to hold the industry accountable have met with little success. Federal officials have yet to recoup hundreds of millions of dollars in suspected overpayments to health plans that date back as far as 2007. Excellus Health Plan, the Rochester, New York, health plan that federal auditors said may have overbilled by as much as $41 million in 2007 for treating patients with serious diseases, paid but a fraction of that amount back years later. A company spokesman said the plan settled the matter by paying the government $157,777 in December 2013. Some critics expect little to change unless federal officials disclose Medicare Advantage plans\u2019 full service and billing histories \u2014 as they have recentlydonewith Medicare fees paid to more than 880,000 individual doctors and others. \u201cThe [Medicare Advantage] plans don\u2019t want the data out,\u201d saidDr. Brian Biles, a professor in the Department of Health Policy at George Washington University, whose Freedom of Information Act lawsuits shook loose limited enrollment records used in this project. (Biles assisted Center for Public Integrity reporters with the analysis.) Dr. David Wennberg, a Dartmouth Institute researcher who has studied the payment issue, said that with billions of tax dollars at stake federal officials need to hit the \u201creset button\u201d on risk scoring. Wennberg said Medicare Advantage \u201cis a very large program with lots of money flowing through it. There are always vested interests in protecting the status quo.\u201d Health care politics The Affordable Care Act, or Obamacare, orders deep rate cuts in Medicare Advantage, partly to cover millions of uninsured people. That\u2019s consistent with an early Obama administration promise to reduce payments to the health insurers. But support for Medicare Advantage in Congress has snowballed as it has attracted more and more seniors who are happy with their care and the price they pay for it. Earlier this year, the insurance industry mounted a fierce media campaign to block the rate cuts, enlisting support from more than 200 members of Congress and forcing the administration to partially back off. The debate over how best to pay Medicare Advantage health plans \u2014 and how to curb overcharging \u2014 has been contentious for years. As far back as the 1980s, Congress hoped that carving a bigger role for managed care plans like Medicare Advantage would help curtail overall Medicare spending and ward off waste and fraud that can pop up when doctors and hospitals are paid for each and every service they perform. To that end, Medicare decided to pay health plans a set monthly rate for patients regardless of how much care they needed. But some health plans stacked the deck by signing up people who were healthier than average, a marketing ploy known in insurance circles as \u201ccherry picking.\u201d That led to a \u201clot of game playing\u201d and \u201cdumping patients who were ill,\u201d said Laurence Bishoff, a Boston health care consultant. Congress thought it saw a remedy in the Medicare Modernization Act of 2003. The law created Medicare Advantage and phased in \u201crisk adjusted\u201d payments starting a year later. Thomas Scully, who helped get the program running under President George W. Bush, said rates were generous in hopes of enticing insurers to expand their Medicare business and not shy away from people in poor health. \u201cWe very intentionally tried to overpay them a little bit,\u201d said Scully, now a Washington lobbyist with numerous health care industry clients. Health status was added to other factors such as sex, race and age in setting rates. Plans that took on the greatest risk by accepting the sickest patients were paid the most. But turning to risk scores as the way to adjust payments ushered in a new form of Medicare billing abuse: Some health plans misstated how sick their patients were or failed to document they had treated illnesses Medicare paid them to treat, the Center\u2019s investigation found. By 2009, government officials were estimating that just over 15 percent of total Medicare Advantage payments were inaccurate, about $12 billion that year. By the end of 2013, officials reported the error rate had dropped to nine percent, which still added up to $11.8 billion for the year. Nearly 80 percent of that \u2014 $9.3 billion \u2014 was overcharges, records show. The Medicare Advantage billing error rate has averaged 12 percent over the past six years, at times outpacing that of standard government-run Medicare, which federal officials assert is highly vulnerable to billing fraud and abuse. Medicare Advantage has faced much less scrutiny. The federal Centers for Medicare and Medicaid Services didn\u2019t try to recoup overpayments until 2012, eight years after phasing in risk scoring. And when it did, it won back only $3.4 million \u2014 a tiny fraction of the estimated losses, according to government records. Though the agency is beefing up collection efforts starting this year, most health plans won\u2019t see federal auditors for years. Malcolm Sparrow, a professor at Harvard University\u2019s John F. Kennedy School of Government and health fraud expert, said officials are \u201casking for trouble\u201d by allowing health plans to generate the data on which risk scores and their revenues are based. \u201cYou want to make sure this is audited rigorously,\u201d Sparrow said. \u201cIt\u2019s much more expensive [to taxpayers] not to.\u201d Federal probe Four of the ten major Medicare Advantage plans with the highest average risk scores nationally are in Puerto Rico. Medicare Advantage plans, which control 70 percent of the island market, argue their patients are poorer and sicker than average. They also say that cuts required under the Affordable Care Act have hit them hard, prompting cuts in benefits and higher premiums for patients who can ill afford to pay more. Risk scores at the two Aveta-related health plans, MMM Healthcare and Preferred Medical Choice, shot up by an average of 11 percent from 2007 through 2011. Nationwide, the growth rate averaged three percent over the same period. The company had no comment. San Juan-based Medical Card System, known by the initials MCS, reported a 5 percent rise in the scores over the same time \u2014 nearly twice the national average. The billing practices also have attracted legal scrutiny. The whistleblower lawsuit filed against Aveta by former executive Jose R. \u201cJosh\u201d Valdez alleges that the company overbilled Medicare by as much as $1 billion by inflating risk scores. Valdez alleges that Aveta paid its stockholders a $100 million dividend during the time that it was overcharging Medicare. MCS has faced its troubles over risk scores, too. Federal agents searched the MCS tower headquarters on Oct. 13, 2011. MCS said in a 2012 financial statement that it had received four grand jury subpoenas as part of a U.S. Attorney\u2019s Office investigation of its \u201crisk adjustment data reporting.\u201d MCS said the company conducted an \u201cinternal review\u201d that found no wrongdoing, but prompted it to return an \u201cimmaterial\u201d amount of money to Medicare. In an April interview inside the MCS tower in San Juan\u2019s Hato Rey financial district, Chief Executive Officer Jim O\u2019Drobinak said the federal probe has ended and MCS has been cleared. \u201cNothing came of it,\u201d he said, blaming the investigation on a \u201cdisgruntled former employee.\u201d Law enforcement sources confirmed that the investigation has been closed. Dr. In\xe9s Hern\xe1ndez, MCS chief medical officer, said that the health plan has moved aggressively to treat patients in their homes and identify diseases so they can be treated in the early stages. \u201cWe\u2019re not just getting information for risk scores,\u201d she said. But CMS officials have been concerned that home visits and other health assessments by health plans can contribute to higher risk scores \u2014 and drive up costs without benefiting patients by providing them with more care. Over/under Congressional auditors and some lawmakers have asserted for years that overpayments to Medicare Advantage plans may be much higher than federal officials have acknowledged. Among the most steadfast critics is Rep. Henry Waxman, D-Calif. In a March 6, 2009, letter to an agency official, he argued that Medicare Advantage plans were a bad deal for taxpayers because each illness they discover, \u201cwhether it is treated or not can increase the payment the plan receives from CMS.\u201d Waxman, who then chaired the House Energy and Commerce Committee, criticized health plans for figuring out how to \u201cmanipulate\u201d risk scores to wrest money they didn\u2019t deserve from Medicare. CMS officials have conceded that risk scores rose much faster for Medicare Advantage patients than for those in standard Medicare and that the rise couldn\u2019t be explained away by saying that the health plan members were sicker. Starting in 2010, they stepped in and cut payments to Medicare Advantage plans to offset rising risk scores. Yet in January 2012 the Government Accountability Office, the watchdog arm of Congress,saidthat the cuts weren\u2019t deep enough and opined that Medicare could have saved as much as $3 billion a year by reducing risk scores further. A year later, the GAO went a step further. A January 2013reportsaid CMS made \u201cexcess payments\u201d to Medicare Advantage plans of between $3.2 billion and $5.1 billion between 2010 and the end of 2012 because risk scores were higher than justified. The Center for Public Integrity data analysis found that Medicare Advantage can cost the government as much as 25 percent more than standard Medicare in some areas. The data analysis also found that seemingly tiny variations in risk scores can boost taxpayer costs enormously \u2014 especially in health plans that are growing fast. Industry officials have a different take. They argue that their members tend to have lower incomes than the elderly population as a whole and have a higher risk of needing expensive medical care. \u201cThey have looked healthier because of incompleteness of this data,\u201d saidJohn Gorman, a former federal health official who is now a prominent Medicare Advantage consultant. Others blame the sheer complexity of risk-scoring for causing confusion about billing. Jim Redmond, a vice president at Excellus Health Plan, which federal auditors in 2012 said couldn\u2019t always document illnesses it was paid to treat, denied any impropriety. He said the billing system was \u201cestablished with good intentions\u201d but \u201cdidn\u2019t fully recognize\u201d how difficult it would be for health plans to oversee. \u201cWe have more than 18,000 physicians submitting claims to us every day. We audit a portion of the claims and medical records for accuracy, completeness and consistency,\u201d Redmond wrote in an email. \u201cHowever, the medical delivery system would grind to a halt if we made every provider submit all of the documentation for each and every claim they file on behalf of members.\u201d Court records show that the billing system\u2019s complexity has stymied government investigators reviewing a whistleblower lawsuit filed in 2010 by physician Olivia Graves against Humana. Graves, who has practiced in South Florida for more than three decades,allegesthat a Humana-owned clinic diagnosed patients with conditions such as diabetes with complications, which boosted Medicare payments. She alleged that those diagnoses were \u201cnot supported by the medical records.\u201d Her suit alleges that Humana knew about the alleged overcharging and did nothing to stop it.. The U.S. Attorney\u2019s Office declined to join the South Florida case even though a federal judge granted it 11 requests for more time to investigate. They argued lawyers and other government personnel \u201chad little or no experience in the applicable regulations and operations of the [Medicare Advantage] program\u201d However, government lawyers said their investigation is continuing. The case was unsealed in May and is pending. Humana also faces other investigations into allegations that it overbilled the government, including a criminal investigation by the Department of Justice in Washington and a criminal case involving the U.S. Attorney\u2019s branch office in West Palm Beach, Florida, according to court records. Humana spokesman Tom Noland said \u201cHumana to our knowledge is not the subject of a criminal investigation.\u201d \u2018Black box\u2019 Many researchers are hoping that CMS will make public detailed Medicare Advantage billing and service data that might allow them to assess how well risk scoring is doing in predicting costs. They also want to study industry claims that they are treating lower income and sicker patients. But that\u2019s not yet possible because CMS has shown little interest in making Medicare Advantage data public. That\u2019s quite a different stance than the agency took in April, when it released detailed information about how much individual doctors were paid by Medicare. The decision drew criticism from the American Medical Association, which has argued that it violated the privacy of doctors. CMS principal deputy administrator Jonathan Blum, who left the agency in May, previously announced on hisblogthat data \u201ccan shine a light on how care is delivered in the Medicare program.\u201d Sparrow, the fraud expert from Harvard, said that it should be easier for the government to cough up information about huge health care corporations than about individual physicians. The doctor billing data covers about $77 billion in taxpayer spending for 2012, about half the Medicare Advantage price tag. \u201cAnything that starts with a \u2018b\u2019 seems like a lot of money to me,\u201d Sparrow said, adding that Medicare Advantage financial data and other records \u201cought to be a matter of ordinary public record.\u201d Medicare Advantage is a \u201cblack box,\u201d added James Cosgrove, who heads health investigations for the GAO, the audit arm of Congress. \u201cWe know what services they say they will provide \u2026 but we never know exactly what services are being provided,\u201d Cosgrove said.',
  'title': u'Why Medicare Advantage costs taxpayers billions more than it should',
  'url': u'http://www.publicintegrity.org/2014/06/04/14840/why-medicare-advantage-costs-taxpayers-billions-more-it-should'},
 {'article_html': u'<p>Medicare covers about 54 million Americans who are over 65 years old or disabled. The government-funded program offers two options:</p>\n\n<p><strong>Fee-For-Service:</strong> This is the standard coverage chosen by more than two-thirds of beneficiaries. They can visit any doctor they want and buy insurance policies to cover any gaps in what Medicare will pay for. Doctors bill Medicare for each service they provide.</p>\n\n<p><strong>Medicare Advantage:</strong> Nearly 16 million seniors have joined about 700 insurance plans that accept a set fee from Medicare for covering each patient in exchange for providing all medical care, from doctor visits to hospital services. The plans also provide extra benefits that are popular with the elderly, including gym memberships and eyeglasses and often are less expensive than standard Medicare. Monthly premiums average about $35.</p>\n\n<p><strong>Other terms</strong></p>\n\n<p><strong>The Centers for Medicare and Medicaid Services: </strong>Referred to as CMS, this federal agency oversees Medicare and Medicaid, the government health plan for low income people. CMS is part of the Department of Health and Human Services.</p>\n\n<p><strong>Dual Eligibles:&nbsp;</strong>The term refers to people who are eligible both for Medicare and Medicaid because they have low incomes. These patients are generally considered the most costly to treat.</p>\n\n<p><strong>In-Home Health Assessments:</strong>&nbsp;Medicare Advantage plans tout these free \u201chouse calls\u201d as a major health benefit. But the visits also can be profitable for the health plans when they uncover new diseases that raise a patient\u2019s risk score\u2014 even if the health plan provides no added treatment. CMS officials proposed banning home visits for collecting risk data, but backed down. The industry said banning the house calls would cut its Medicare payments by some $3 billion a year.</p>\n\n<p><strong>Monitor, Evaluate, Assess/Address and Treat (MEAT)</strong>: Doctors must document that they did all these things in order for a health plan to claim payment based on a patient\u2019s illness. In other words, a health plan cannot just write down that a patient has a disease and seek extra payments from Medicare. The plan must also show that its doctors assessed and treated the condition. Still, federal officials in April backed off a proposed regulation that would have banned home health assessments which uncovered new diseases but didn\u2019t lead to any more treatment.</p>\n\n<p><strong>Retrospective Chart Reviews:</strong>&nbsp;The risk-based payment system has spurred the growth of a medical information and data analysis industry that \u201cmines\u201d electronic patient medical files looking for evidence of unrecognized diseases that could boost risk scores and Medicare payments. CMS has proposed that health plans also report cases in which risk scores should be reduced, which would reduce overpayments.</p>\n\n<p><strong>Risk Score: </strong>Since 2004, CMS has paid Medicare Advantage plans based on a risk score that is supposed to assess the overall health of each patient. Medicare pays higher rates for sicker patients that are likely to require more costly medical services and less for healthy people. Medicare Advantage plans on average received about $9,900 per person in 2011.</p>\n\n<p><strong>Risk Adjustment Data Validation</strong> <strong>(RADV)</strong> <strong>audits:</strong> Health plans collect medical data used to calculate patient risk scores. But mistakes are common and trigger billions of dollars in \u201cimproper payments\u201d every year, mostly overcharges. RADV audits are supposed to keep the industry honest. But CMS only does a few dozen audits a year and usually recoups minimal amounts.</p>\n\n<p><strong>Special Needs Plans: </strong>These are Medicare Advantage plans that enroll people with chronic diseases such as diabetes and take other steps to manage their care.</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/-0_1YGyz7FE" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/-0_1YGyz7FE'],
  'article_links': [],
  'authors': [u'Fred Schulte'],
  'datetime': datetime.datetime(2014, 6, 4, 9, 8, 19, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Medicare', u'Medicare Advantage Money Grab'],
  'text': u'Medicare covers about 54 million Americans who are over 65 years old or disabled. The government-funded program offers two options: Fee-For-Service: This is the standard coverage chosen by more than two-thirds of beneficiaries. They can visit any doctor they want and buy insurance policies to cover any gaps in what Medicare will pay for. Doctors bill Medicare for each service they provide. Medicare Advantage: Nearly 16 million seniors have joined about 700 insurance plans that accept a set fee from Medicare for covering each patient in exchange for providing all medical care, from doctor visits to hospital services. The plans also provide extra benefits that are popular with the elderly, including gym memberships and eyeglasses and often are less expensive than standard Medicare. Monthly premiums average about $35. Other terms The Centers for Medicare and Medicaid Services: Referred to as CMS, this federal agency oversees Medicare and Medicaid, the government health plan for low income people. CMS is part of the Department of Health and Human Services. Dual Eligibles:The term refers to people who are eligible both for Medicare and Medicaid because they have low incomes. These patients are generally considered the most costly to treat. In-Home Health Assessments:Medicare Advantage plans tout these free \u201chouse calls\u201d as a major health benefit. But the visits also can be profitable for the health plans when they uncover new diseases that raise a patient\u2019s risk score\u2014 even if the health plan provides no added treatment. CMS officials proposed banning home visits for collecting risk data, but backed down. The industry said banning the house calls would cut its Medicare payments by some $3 billion a year. Monitor, Evaluate, Assess/Address and Treat (MEAT): Doctors must document that they did all these things in order for a health plan to claim payment based on a patient\u2019s illness. In other words, a health plan cannot just write down that a patient has a disease and seek extra payments from Medicare. The plan must also show that its doctors assessed and treated the condition. Still, federal officials in April backed off a proposed regulation that would have banned home health assessments which uncovered new diseases but didn\u2019t lead to any more treatment. Retrospective Chart Reviews:The risk-based payment system has spurred the growth of a medical information and data analysis industry that \u201cmines\u201d electronic patient medical files looking for evidence of unrecognized diseases that could boost risk scores and Medicare payments. CMS has proposed that health plans also report cases in which risk scores should be reduced, which would reduce overpayments. Risk Score: Since 2004, CMS has paid Medicare Advantage plans based on a risk score that is supposed to assess the overall health of each patient. Medicare pays higher rates for sicker patients that are likely to require more costly medical services and less for healthy people. Medicare Advantage plans on average received about $9,900 per person in 2011. Risk Adjustment Data Validation (RADV) audits: Health plans collect medical data used to calculate patient risk scores. But mistakes are common and trigger billions of dollars in \u201cimproper payments\u201d every year, mostly overcharges. RADV audits are supposed to keep the industry honest. But CMS only does a few dozen audits a year and usually recoups minimal amounts. Special Needs Plans: These are Medicare Advantage plans that enroll people with chronic diseases such as diabetes and take other steps to manage their care.',
  'title': u'Medicare Advantage made simple: a glossary',
  'url': u'http://www.publicintegrity.org/2014/06/04/14829/medicare-advantage-made-simple-glossary'},
 {'article_html': u'<p>A prominent state lawmakers\u2019 advisory group issued a major report Tuesday warning of the \u201cschool to prison\u201d pipeline and offering multiple alternatives to harsh school discipline and police crackdowns on students.</p>\n\n<p>Released by the Council of State Governments \u2014 a nonpartisan national research group that advises legislators \u2014 the&nbsp;<a href="http://csgjusticecenter.org/youth/posts/csg-justice-center-releases-roadmap-for-reforming-school-discipline/">\u201cSchool Discipline Consensus Report\u201d</a>&nbsp;encourages schools and lawmakers to embrace ideas such as conflict resolution and counseling \u2014 rather than suspensions, expulsions and forcing kids into juvenile court for infractions as minor as cursing or shoving matches.</p>\n\n<p>\u201cWhen suspended, these students are at significantly higher risk of falling behind academically, dropping out of school and coming into contact with the juvenile justice system,\u201d says the report. \u201cA disproportionately large percentage of disciplined students are youth of color, students with disabilities and youth who identify as lesbian, gay, bisexual or transgender.\u201d</p>\n\n<p>In a conference call with reporters Tuesday, a Republican Tennessee state Senate leader \u2014 Sen. Mark Norris \u2014 spoke out in favor of the report\u2019s recommendations in his role as the elected chairman of the council.</p>\n\n<p>\u201cThis is a wake up regardless of what side of the aisle you sit on,\u201d said Norris, who hails from Collierville, a Memphis suburb. \u201cWe\u2019re very worried about that pipeline to court.\u201d</p>\n\n<p>Norris\u2019 own state has come under scrutiny from the U.S. Justice Department for <a href="https://www.publicintegrity.org/2014/05/19/14782/tennessee-supreme-court-declines-review-case-featured-center-report">prosecuting and jailing accused truants</a>&nbsp;\u2014 including kids with mental-health difficulties \u2014 whose parents say they were <a href="https://www.publicintegrity.org/2014/05/09/14699/juvenile-injustice-truants-face-courts-jailing-without-legal-counsel-aid-them">not afforded appointed attorneys in juvenile court</a> in Knox County, as the Center for Public Integrity recently reported. &nbsp;&nbsp;&nbsp;</p>\n\n<p>If kids are derailed from school by harsh reactions to minor misbehavior, Norris said, they won\u2019t become productive members of a community and contribute to its economic well-being.</p>\n\n<p>He said communities need a \u201cbright light\u201d on counterproductive discipline, including issues raised in the Center\u2019s report, such as accused truants facing prosecution in court without the appointment of legal counsel.</p>\n\n<p>The School Discipline Consensus Report calls on state, community and school leaders to help reduce suspensions, expulsions and arrests of students and \u201cprovide conditions for learning wherein all students feel safe, welcome and supported.\u201d</p>\n\n<p>A national network called <a href="http://www.dignityinschools.org/">Dignity in Schools</a>&nbsp;\u2014 which has helped shape discipline reform in many cities \u2014 said interested educators can find viable alternatives in the report: \u201cThe strategies in the report are practical, innovative and are based on successful efforts that have been made in schools all across the country from Denver to Austin to Baltimore.\u201d</p>\n\n<p>In 2011, the Council of State Governments released a longitudinal study finding that 60 percent of all Texas students had been suspended at least once, with punishment falling particularly <a href="http://www.publicintegrity.org/2011/07/19/5259/study-finds-stunning-rates-discipline-among-texas-students">harshly on black and Latino male students</a>.</p>\n\n<p>The vast majority of suspensions and expulsions \u2014 97 percent \u2014 were due to discretionary or local \u201czero tolerance\u201d policies, not federal policies mandating removal of students. Compared to peers, students with multiple suspensions disproportionately went on to get into trouble with the criminal justice system \u2014 not straighten out and get engaged in school.&nbsp;</p>\n<p>Texas state Sen. John Whitmire, a Democrat from the Houston area, told reporters during the conference call: \u201cOut-of-school suspensions rarely accomplish anything.\u201d&nbsp;</p>\n\n<p>As chair of the Texas Senate Criminal Justice Committee, Whitmire said he tells his colleagues in the legislature \u201cyou either pay now\u201d to help kids stay in school, or \u201cyou pay later\u201d with higher incarceration costs. Whitmire said kids in Texas have been accused of misdemeanors for infractions as minor as throwing an eraser. &nbsp;</p>\n\n<p>To address behavioral problems, the report suggests that \u201ceach school should have a student support team (or teams) to oversee services for youth with behavioral health and related needs.\u201d</p>\n\n<p>Norris agreed that alternatives listed in the report can be \u201ccost-effective\u201d and that there are multiple options \u201cso you can find what is relevant in your state.\u201d</p>\n\n<p>The report includes recommendations such as the use of \u201crestorative\u201d justice peer counseling. It also includes lengthy sections urging schools to define precisely what the role of police officers should be in a school.</p>\n\n<p>\u201cPolice should not be engaged in routine classroom management,\u201d the report recommends, \u201cand whenever possible should use alternatives to arrest for students\u2019 minor offenses that can be appropriately addressed through the school\u2019s discipline system.\u201d</p>\n\n<p><a href="http://www.publicintegrity.org/juvenile-justice">The Center for Public Integrity</a>&nbsp;has reported on how aggressive use of police and \u201czero tolerance\u201d suspensions and expulsions have fallen disproportionately on black, Latino and low-income children, including middle-school students.</p>\n\n<p>In Kern County, California, for example<a href="http://www.publicintegrity.org/2013/07/15/12951/throwaway-kids-disciplined-california-teens-struggle-school-themselves">, low-income farmworker kids</a>&nbsp;have been removed from regular schools for minor infractions and sent to alternative schools so far away that they languished at home, assigned to study on their own,&nbsp;<a href="http://www.publicintegrity.org/2013/09/25/13455/nations-richest-farmland-some-workers-kids-get-no-education-all">or dropped out</a>.</p>\n\n<p>In Los Angeles, until recent reforms were enacted, the nation\u2019s largest&nbsp;<a href="http://www.publicintegrity.org/2012/04/24/8741/school-discipline-debate-reignited-new-los-angeles-data">school police force was ticketing</a>&nbsp;tens of thousands of inner-city children in low-income neighborhoods, about half of them 14 or younger.</p>\n\n<p>Kids as young as 12 have been&nbsp;<a href="http://www.publicintegrity.org/2012/05/21/8906/los-angeles-school-police-citations-draw-federal-scrutiny">arrested at Los Angeles schools</a>&nbsp;for playground fights with friends, and they developed juvenile records for assault as a result, the Center reported.</p>\n\n<p>Since the Texas longitudinal study\u2019s release in 2011, some of the Lone Star state\u2019s school districts have implemented reforms that contributed to 10 percent overall reduction in suspensions and a 30 percent reduction in expulsions at last count, according to Michael Thompson, director of the Council of State Governments Justice Center, which produced the report.</p>\n\n<p>More needs to be done, Whitmire said. He called it \u201cnonsense\u201d for a school in&nbsp;<a href="http://www.myfoxdfw.com/story/25516642/duncanville-hs-sends-hundreds-home-for-dress-code-violations">Duncanville, Texas</a>&nbsp;to suspend and send home about 170 students in May for dress code violations that included not wearing a belt or a shirt with a collar. Principal Andre Smith told media that the school resorted to the suspensions to teach students to \u201cmeet expectations\u201d in school and \u201coutside of school as well.\u201d</p>\n\n<p>Thompson said the report released Tuesday represents \u201ca consensus\u201d and \u201ca vision from the field\u201d with alternatives to harsh discipline recommended by more than 100 educators, parent representatives, law enforcement and court officials and mental and social-welfare officials.</p>\n\n<p>Local and state leaders will join representatives of the Council of State Governments in Austin, Texas, on Wednesday and in Los Angeles on Thursday to promote the strategies in the report.</p>\n\n<p>The council\u2019s report was prepared in part with funding from the California Endowment, Atlantic Philanthopies and the Open Society Foundations, which also&nbsp;funds independent reporting by the Center for Public Integrity.</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/I9hvhoGRm-Q" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/I9hvhoGRm-Q'],
  'article_links': ['https://www.publicintegrity.org/2014/05/19/14782/tennessee-supreme-court-declines-review-case-featured-center-report',
   'https://www.publicintegrity.org/2014/05/09/14699/juvenile-injustice-truants-face-courts-jailing-without-legal-counsel-aid-them',
   'http://www.publicintegrity.org/2012/05/21/8906/los-angeles-school-police-citations-draw-federal-scrutiny',
   'http://www.dignityinschools.org',
   'http://www.myfoxdfw.com/story/25516642/duncanville-hs-sends-hundreds-home-for-dress-code-violations',
   'http://www.publicintegrity.org/2013/07/15/12951/throwaway-kids-disciplined-california-teens-struggle-school-themselves',
   'http://csgjusticecenter.org/youth/posts/csg-justice-center-releases-roadmap-for-reforming-school-discipline',
   'http://www.publicintegrity.org/2013/09/25/13455/nations-richest-farmland-some-workers-kids-get-no-education-all',
   'http://www.publicintegrity.org/2011/07/19/5259/study-finds-stunning-rates-discipline-among-texas-students',
   'http://www.publicintegrity.org/juvenile-justice',
   'http://www.publicintegrity.org/2012/04/24/8741/school-discipline-debate-reignited-new-los-angeles-data'],
  'authors': [u'Susan Ferriss'],
  'datetime': datetime.datetime(2014, 6, 3, 20, 42, 21, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Juvenile Justice'],
  'text': u'A prominent state lawmakers\u2019 advisory group issued a major report Tuesday warning of the \u201cschool to prison\u201d pipeline and offering multiple alternatives to harsh school discipline and police crackdowns on students. Released by the Council of State Governments \u2014 a nonpartisan national research group that advises legislators \u2014 the\u201cSchool Discipline Consensus Report\u201dencourages schools and lawmakers to embrace ideas such as conflict resolution and counseling \u2014 rather than suspensions, expulsions and forcing kids into juvenile court for infractions as minor as cursing or shoving matches. \u201cWhen suspended, these students are at significantly higher risk of falling behind academically, dropping out of school and coming into contact with the juvenile justice system,\u201d says the report. \u201cA disproportionately large percentage of disciplined students are youth of color, students with disabilities and youth who identify as lesbian, gay, bisexual or transgender.\u201d In a conference call with reporters Tuesday, a Republican Tennessee state Senate leader \u2014 Sen. Mark Norris \u2014 spoke out in favor of the report\u2019s recommendations in his role as the elected chairman of the council. \u201cThis is a wake up regardless of what side of the aisle you sit on,\u201d said Norris, who hails from Collierville, a Memphis suburb. \u201cWe\u2019re very worried about that pipeline to court.\u201d Norris\u2019 own state has come under scrutiny from the U.S. Justice Department for prosecuting and jailing accused truants\u2014 including kids with mental-health difficulties \u2014 whose parents say they were not afforded appointed attorneys in juvenile court in Knox County, as the Center for Public Integrity recently reported. If kids are derailed from school by harsh reactions to minor misbehavior, Norris said, they won\u2019t become productive members of a community and contribute to its economic well-being. He said communities need a \u201cbright light\u201d on counterproductive discipline, including issues raised in the Center\u2019s report, such as accused truants facing prosecution in court without the appointment of legal counsel. The School Discipline Consensus Report calls on state, community and school leaders to help reduce suspensions, expulsions and arrests of students and \u201cprovide conditions for learning wherein all students feel safe, welcome and supported.\u201d A national network called Dignity in Schools\u2014 which has helped shape discipline reform in many cities \u2014 said interested educators can find viable alternatives in the report: \u201cThe strategies in the report are practical, innovative and are based on successful efforts that have been made in schools all across the country from Denver to Austin to Baltimore.\u201d In 2011, the Council of State Governments released a longitudinal study finding that 60 percent of all Texas students had been suspended at least once, with punishment falling particularly harshly on black and Latino male students. The vast majority of suspensions and expulsions \u2014 97 percent \u2014 were due to discretionary or local \u201czero tolerance\u201d policies, not federal policies mandating removal of students. Compared to peers, students with multiple suspensions disproportionately went on to get into trouble with the criminal justice system \u2014 not straighten out and get engaged in school. Texas state Sen. John Whitmire, a Democrat from the Houston area, told reporters during the conference call: \u201cOut-of-school suspensions rarely accomplish anything.\u201d As chair of the Texas Senate Criminal Justice Committee, Whitmire said he tells his colleagues in the legislature \u201cyou either pay now\u201d to help kids stay in school, or \u201cyou pay later\u201d with higher incarceration costs. Whitmire said kids in Texas have been accused of misdemeanors for infractions as minor as throwing an eraser. To address behavioral problems, the report suggests that \u201ceach school should have a student support team (or teams) to oversee services for youth with behavioral health and related needs.\u201d Norris agreed that alternatives listed in the report can be \u201ccost-effective\u201d and that there are multiple options \u201cso you can find what is relevant in your state.\u201d The report includes recommendations such as the use of \u201crestorative\u201d justice peer counseling. It also includes lengthy sections urging schools to define precisely what the role of police officers should be in a school. \u201cPolice should not be engaged in routine classroom management,\u201d the report recommends, \u201cand whenever possible should use alternatives to arrest for students\u2019 minor offenses that can be appropriately addressed through the school\u2019s discipline system.\u201d The Center for Public Integrityhas reported on how aggressive use of police and \u201czero tolerance\u201d suspensions and expulsions have fallen disproportionately on black, Latino and low-income children, including middle-school students. In Kern County, California, for example, low-income farmworker kidshave been removed from regular schools for minor infractions and sent to alternative schools so far away that they languished at home, assigned to study on their own,or dropped out. In Los Angeles, until recent reforms were enacted, the nation\u2019s largestschool police force was ticketingtens of thousands of inner-city children in low-income neighborhoods, about half of them 14 or younger. Kids as young as 12 have beenarrested at Los Angeles schoolsfor playground fights with friends, and they developed juvenile records for assault as a result, the Center reported. Since the Texas longitudinal study\u2019s release in 2011, some of the Lone Star state\u2019s school districts have implemented reforms that contributed to 10 percent overall reduction in suspensions and a 30 percent reduction in expulsions at last count, according to Michael Thompson, director of the Council of State Governments Justice Center, which produced the report. More needs to be done, Whitmire said. He called it \u201cnonsense\u201d for a school inDuncanville, Texasto suspend and send home about 170 students in May for dress code violations that included not wearing a belt or a shirt with a collar. Principal Andre Smith told media that the school resorted to the suspensions to teach students to \u201cmeet expectations\u201d in school and \u201coutside of school as well.\u201d Thompson said the report released Tuesday represents \u201ca consensus\u201d and \u201ca vision from the field\u201d with alternatives to harsh discipline recommended by more than 100 educators, parent representatives, law enforcement and court officials and mental and social-welfare officials. Local and state leaders will join representatives of the Council of State Governments in Austin, Texas, on Wednesday and in Los Angeles on Thursday to promote the strategies in the report. The council\u2019s report was prepared in part with funding from the California Endowment, Atlantic Philanthopies and the Open Society Foundations, which alsofunds independent reporting by the Center for Public Integrity.',
  'title': u'States urged to embrace alternatives to school discipline criminalizing kids',
  'url': u'http://www.publicintegrity.org/2014/06/03/14887/states-urged-embrace-alternatives-school-discipline-criminalizing-kids'},
 {'article_html': u'<p>A federal appeals court has <a href="https://www.documentcloud.org/documents/1180304-fifth-circuit-judgment-withdrawn.html" style="line-height: 1.6;">withdrawn</a> a three-judge panel\u2019s 2007 dismissal of a Pennsylvania man\u2019s lawsuit against ExxonMobil Corp. after a <a href="https://www.publicintegrity.org/2014/04/28/14630/federal-judges-plead-guilty">Center for Public Integrity investigation</a> found that the wife of one of the judges owned up to $100,000 worth of stock in the oil company at the time of the panel\u2019s decision.</p>\n\n<p>The New Orleans-based 5th U.S. Circuit Court of Appeals had dubbed the case as \u201cfrivolous\u201d when it originally dismissed the case that <a href="https://www.documentcloud.org/documents/1180309-tilli-v-exxonmobil-original-complaint.html">accused ExxonMobil and its chairman of maliciously and illegally raising oil and gas prices</a>.</p>\n\n<p>But the court reopened the case on May 15, one day after the court received a letter from the plaintiff, Daniel Tilli, saying that he was \u201cin disbelief\u201d that Judge Thomas Reavley did not know that his wife had <a href="https://www.documentcloud.org/documents/1180324-reavleys-wife-exxonmobil-2007-stock-ownership.html">owned stock in the oil company</a> until seven years after the court ruled. Reavley is married to fellow 5th Circuit Judge Carolyn King.</p>\n\n<p>Tilli, a Bethlehem, Pa., resident who represented himself, requested that a new panel hear his case because Reavley was \u201cnot impartial.\u201d</p>\n\n<p>By law, judges cannot own even a single share of stock in companies that come before them. Nor can their spouses or dependent children.</p>\n\n<p>Tilli learned about the judge\u2019s conflict of interest after it was brought to the 5th Circuit\u2019s attention by the Center in early April. The Center identified the conflict while reporting its months-long <a href="http://www.publicintegrity.org/2014/04/28/14630/federal-judges-plead-guilty">\u201cJuris Imprudence\u201d</a> investigation, which found 26 other examples since 2010 where federal appellate judges ruled on cases in which they had a financial conflict.</p>\n\n<p>As required under court rules, Reavley and judges in all of those cases had <a href="https://www.documentcloud.org/documents/1149940-reavley-tilli-v-exxonmobil.html">letters sent to the litigants</a> to alert them of the mistakes. The letters were the first step in possibly reopening the cases.</p>\n\n<p>Reavley\u2019s case is the third to be reopened due to the Center\u2019s reporting.</p>\n\n<p>In one case that was reopened because of a stock conflict involving 4th U.S. Circuit Court of Appeals Judge Allyson Duncan, a new three-judge panel reached the same decision as the first. <a href="http://www.publicintegrity.org/2014/05/13/14748/case-reopened-after-center-reveals-judges-conflict-interest">Another case</a> tainted by stock ownership of 11th Circuit Judge Frank Hull is still pending. Many of the others remain in limbo.</p>\n\n<p>Lyle Cayce, the 5th Circuit clerk of court, told the Center that Reavley\u2019s involvement in the Tilli case was the result of a \u201cstaff error.\u201d He said the case pre-dated an automated screening process, which helps the court avoid assigning judges to cases in which they have a conflict of interest.</p>\n\n<p>Now that the 2007 judgment has been withdrawn, a newly constituted three-judge panel without Reavley will review the case. But it\u2019s unclear how long it will take the new panel to reach a decision.</p>\n\n<p>Because the case wrapped up nearly seven years ago, Cayce said the court is currently retrieving some case records, which are no longer stored in the court.</p>\n\n<p>It\u2019s also unclear how a new panel will rule. Neither Tilli nor an attorney for ExxonMobil could immediately be reached for comment.</p>\n<p>&nbsp;&nbsp;</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/Lf3UCaQ3IlE" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/Lf3UCaQ3IlE'],
  'article_links': ['https://www.publicintegrity.org/2014/04/28/14630/federal-judges-plead-guilty',
   'https://www.documentcloud.org/documents/1180309-tilli-v-exxonmobil-original-complaint.html',
   'https://www.documentcloud.org/documents/1180324-reavleys-wife-exxonmobil-2007-stock-ownership.html',
   'https://www.documentcloud.org/documents/1180304-fifth-circuit-judgment-withdrawn.html',
   'https://www.documentcloud.org/documents/1149940-reavley-tilli-v-exxonmobil.html',
   'http://www.publicintegrity.org/2014/05/13/14748/case-reopened-after-center-reveals-judges-conflict-interest',
   'http://www.publicintegrity.org/2014/04/28/14630/federal-judges-plead-guilty'],
  'authors': [u'Chris Young'],
  'datetime': datetime.datetime(2014, 6, 3, 20, 33, 25, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Consider the Source', u'Justice Obscured'],
  'text': u'A federal appeals court has withdrawn a three-judge panel\u2019s 2007 dismissal of a Pennsylvania man\u2019s lawsuit against ExxonMobil Corp. after a Center for Public Integrity investigation found that the wife of one of the judges owned up to $100,000 worth of stock in the oil company at the time of the panel\u2019s decision. The New Orleans-based 5th U.S. Circuit Court of Appeals had dubbed the case as \u201cfrivolous\u201d when it originally dismissed the case that accused ExxonMobil and its chairman of maliciously and illegally raising oil and gas prices. But the court reopened the case on May 15, one day after the court received a letter from the plaintiff, Daniel Tilli, saying that he was \u201cin disbelief\u201d that Judge Thomas Reavley did not know that his wife had owned stock in the oil company until seven years after the court ruled. Reavley is married to fellow 5th Circuit Judge Carolyn King. Tilli, a Bethlehem, Pa., resident who represented himself, requested that a new panel hear his case because Reavley was \u201cnot impartial.\u201d By law, judges cannot own even a single share of stock in companies that come before them. Nor can their spouses or dependent children. Tilli learned about the judge\u2019s conflict of interest after it was brought to the 5th Circuit\u2019s attention by the Center in early April. The Center identified the conflict while reporting its months-long \u201cJuris Imprudence\u201d investigation, which found 26 other examples since 2010 where federal appellate judges ruled on cases in which they had a financial conflict. As required under court rules, Reavley and judges in all of those cases had letters sent to the litigants to alert them of the mistakes. The letters were the first step in possibly reopening the cases. Reavley\u2019s case is the third to be reopened due to the Center\u2019s reporting. In one case that was reopened because of a stock conflict involving 4th U.S. Circuit Court of Appeals Judge Allyson Duncan, a new three-judge panel reached the same decision as the first. Another case tainted by stock ownership of 11th Circuit Judge Frank Hull is still pending. Many of the others remain in limbo. Lyle Cayce, the 5th Circuit clerk of court, told the Center that Reavley\u2019s involvement in the Tilli case was the result of a \u201cstaff error.\u201d He said the case pre-dated an automated screening process, which helps the court avoid assigning judges to cases in which they have a conflict of interest. Now that the 2007 judgment has been withdrawn, a newly constituted three-judge panel without Reavley will review the case. But it\u2019s unclear how long it will take the new panel to reach a decision. Because the case wrapped up nearly seven years ago, Cayce said the court is currently retrieving some case records, which are no longer stored in the court. It\u2019s also unclear how a new panel will rule. Neither Tilli nor an attorney for ExxonMobil could immediately be reached for comment.',
  'title': u'Court reopens third case after Center uncovered judicial conflicts of interest',
  'url': u'http://www.publicintegrity.org/2014/06/03/14871/court-reopens-third-case-after-center-uncovered-judicial-conflicts-interest'},
 {'article_html': u'<p>The Environmental Protection Agency&nbsp;on Monday <a href="http://yosemite.epa.gov/opa/admpress.nsf/d0cf6618525a9efb85257359003fb69d/5bb6d20668b9a18485257ceb00490c98!OpenDocument">proposed the first-ever limits on greenhouse gas emissions</a> from existing power plants. The high-profile announcement marks the second time in less than a year the agency has released far-reaching rules aimed at fulfilling a key pillar of President Obama\u2019s sweeping climate plan \u2014 to cut carbon pollution from both existing and&nbsp;planned power plants.</p>\n\n<p>EPA Administrator Gina McCarthy unveiled a dense, <a href="http://www2.epa.gov/sites/production/files/2014-05/documents/20140602proposal-cleanpowerplan.pdf">645-page proposal</a> to limit carbon dioxide emissions from roughly 1,000 existing coal, gas, and oil plants nationwide \u2014 the largest source of carbon pollution in the United States, accounting for nearly one- third of all domestic greenhouse gas emissions. McCarthy presented the groundbreaking regulation as a \u201cvital piece of President Obama\u2019s climate plan\u201d and \u201ccritical step forward\u201d in the global fight against climate change.</p>\n\n<p>\u201cThis is not just about disappearing polar bears or melting ice caps,\u201d she said. \u201cThis is about protecting our health and our homes. This is about protecting local economies and jobs.\u201d</p>\n\n<p>Dubbed the \u201cClean Power Plan,\u201d the EPA proposal would cut carbon emissions from existing plants by as much as 30 percent by 2030, as compared to 2005 levels \u2014 or, about 730 million metric tons of carbon pollution. Under this plan, state officials would develop energy-efficiency policies and renewable-energy programs to meet what the EPA has identified as state-specific goals for reducing carbon pollution.</p>\n\n<p>To reach such \u201ccarbon targets,\u201d the states could implement a range of options from designing a market-based carbon tax to using \u201cno carbon\u201d electricity sources like wind, solar, and nuclear. The EPA proposal would give states a flexible timeline for submitting their plans to the agency, with initial drafts or final plans due by June 2016.</p>\n\n<p>Touting the plan\u2019s \u201chuge\u201d benefits, including the billions of dollars saved in health-care costs because of fewer&nbsp;asthma attacks and premature deaths, the EPA administrator called it \u201can investment in better health and a better future for our kids.\u201d</p>\n\n<p>Alluding to the battle now brewing over carbon regulations for power plants, she added, \u201cThere are still special interest skeptics who will cry the sky is falling. Who will deliberately ignore the risks, overestimate the costs, and undervalue the benefits. But the facts are clear.\u201d</p>\n\n<p>Even before Monday\u2019s announcement,&nbsp;the EPA\u2019s plan to regulate carbon pollution from aging coal-fired power plants had set off a <a href="https://www.publicintegrity.org/2013/09/03/13290/coal-industry-hill-allies-target-fine-print-obama-climate-plan">fierce lobbying campaign by coal companies and coal-burning utilities</a>. Last fall, the agency announced its first-ever national standards to cut carbon dioxide emissions from planned&nbsp;power plants; those standards are&nbsp;pending. Like that rule, opponents consider Monday\'s&nbsp;proposal to be an effective ban on coal plants.<br />\n<br />\n\u201cIf these rules are allowed to go into effect, the administration for all intents and purposes is creating America\u2019s next energy crisis,\u201d said Mike Duncan of the American Coalition for Clean Coal Electricity, the coal industry\u2019s most public voice. Noting how coal still accounts for nearly 40 percent of all electricity, he reiterated longstanding industry arguments about the costs of such stringent regulation \u2014 i.e., higher energy prices, lower grid reliability.</p>\n<p>Other vocal opponents, like Jeffrey Holmstead, who represents coal and utility companies at the D.C. lobbying firm Bracewell &amp; Guiliani, wondered whether EPA\u2019s proposal would actually address such climate dangers as rising sea levels and soaring temperatures. \u201cThe way they\u2019ve promoted the rule is highly misleading,\u201d charged Holmstead, who headed the EPA\u2019s air and radiation office under President George W. Bush. \u201cThis is the rule that\u2019s going to address all these risks,\u201d yet nowhere do EPA officials say how the proposed rule will do so.</p>\n\n<p>Calling its overall goal \u201cunrealistic,\u201d he noted that many states have already implemented \u201ceasy fixes and easy improvements\u201d to try to promote energy efficiency and renewable sources, thus reducing carbon pollution. Currently, according to the EPA, 38 states have their own renewable portfolio standards or goals; 27 have the same for energy efficiency. For most, Holmstead said, \u201cI don\u2019t think there\u2019s any plausible way to comply without a cap and trade proposal or a carbon tax\u201d \u2014 an option fraught with politics.</p>\n\n<div>Not all power companies reacted negatively to the EPA\'s proposal. Jack Ihle, of Xcel Energy, a large utility operating gas plants and wind farms in Minnesota and Colorado, acknowledged that the plan has the potential to significantly change the way the industry produces electricity. Seeing itself as an industry leader, Xcel has retired coal plants, renovated gas plants, and served as what Ihle called the "number one provider of wind energy to customers for 10 straight years," all to try to reduce its carbon emissions.</div>\n\n<div>&nbsp;</div>\n\n<div>Such moves "have been made very clear under this new rule," Ihle said, adding that Xcel "hopes to achieve recognition of significant emission reductions" under it.</div>\n\n<div>&nbsp;</div>\n\n<div>Environmental advocates welcomed the EPA proposal as a long time coming, applauding both its national limit and its political message. \u201cWe think this is the right direction,\u201d said Abigail Dillen, of the public-interest law firm Earthjustice, which, like many environmental groups, will be pushing the EPA to cut carbon pollution even further in its final rule. She added, \u201cThe most important thing to do today is celebrate that the president has taken this tremendously courageous action.\u201d</div>\n\n<div>&nbsp;</div>\n\n<p>The EPA proposal must go through a 120-day public comment period and additional reviews.&nbsp;Next month, the agency also plans to hold four public hearings on the proposal, in Denver, Atlanta, Pittsburgh, and Washington, D.C. A final rule is expected by June 2015.</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/nyX3KDpCFY8" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/nyX3KDpCFY8'],
  'article_links': ['http://www2.epa.gov/sites/production/files/2014-05/documents/20140602proposal-cleanpowerplan.pdf',
   'https://www.publicintegrity.org/2013/09/03/13290/coal-industry-hill-allies-target-fine-print-obama-climate-plan',
   'http://yosemite.epa.gov/opa/admpress.nsf/d0cf6618525a9efb85257359003fb69d/5bb6d20668b9a18485257ceb00490c98!OpenDocument'],
  'authors': [u'Rosalind Adams', u'Kristen Lombardi', u'Ashley Schwartz'],
  'datetime': datetime.datetime(2014, 6, 2, 23, 24, 29, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Environment', u'Pollution'],
  'text': u'The Environmental Protection Agencyon Monday proposed the first-ever limits on greenhouse gas emissions from existing power plants. The high-profile announcement marks the second time in less than a year the agency has released far-reaching rules aimed at fulfilling a key pillar of President Obama\u2019s sweeping climate plan \u2014 to cut carbon pollution from both existing andplanned power plants. EPA Administrator Gina McCarthy unveiled a dense, 645-page proposal to limit carbon dioxide emissions from roughly 1,000 existing coal, gas, and oil plants nationwide \u2014 the largest source of carbon pollution in the United States, accounting for nearly one- third of all domestic greenhouse gas emissions. McCarthy presented the groundbreaking regulation as a \u201cvital piece of President Obama\u2019s climate plan\u201d and \u201ccritical step forward\u201d in the global fight against climate change. \u201cThis is not just about disappearing polar bears or melting ice caps,\u201d she said. \u201cThis is about protecting our health and our homes. This is about protecting local economies and jobs.\u201d Dubbed the \u201cClean Power Plan,\u201d the EPA proposal would cut carbon emissions from existing plants by as much as 30 percent by 2030, as compared to 2005 levels \u2014 or, about 730 million metric tons of carbon pollution. Under this plan, state officials would develop energy-efficiency policies and renewable-energy programs to meet what the EPA has identified as state-specific goals for reducing carbon pollution. To reach such \u201ccarbon targets,\u201d the states could implement a range of options from designing a market-based carbon tax to using \u201cno carbon\u201d electricity sources like wind, solar, and nuclear. The EPA proposal would give states a flexible timeline for submitting their plans to the agency, with initial drafts or final plans due by June 2016. Touting the plan\u2019s \u201chuge\u201d benefits, including the billions of dollars saved in health-care costs because of fewerasthma attacks and premature deaths, the EPA administrator called it \u201can investment in better health and a better future for our kids.\u201d Alluding to the battle now brewing over carbon regulations for power plants, she added, \u201cThere are still special interest skeptics who will cry the sky is falling. Who will deliberately ignore the risks, overestimate the costs, and undervalue the benefits. But the facts are clear.\u201d Even before Monday\u2019s announcement,the EPA\u2019s plan to regulate carbon pollution from aging coal-fired power plants had set off a fierce lobbying campaign by coal companies and coal-burning utilities. Last fall, the agency announced its first-ever national standards to cut carbon dioxide emissions from plannedpower plants; those standards arepending. Like that rule, opponents consider Monday\'sproposal to be an effective ban on coal plants. \u201cIf these rules are allowed to go into effect, the administration for all intents and purposes is creating America\u2019s next energy crisis,\u201d said Mike Duncan of the American Coalition for Clean Coal Electricity, the coal industry\u2019s most public voice. Noting how coal still accounts for nearly 40 percent of all electricity, he reiterated longstanding industry arguments about the costs of such stringent regulation \u2014 i.e., higher energy prices, lower grid reliability. Other vocal opponents, like Jeffrey Holmstead, who represents coal and utility companies at the D.C. lobbying firm Bracewell Guiliani, wondered whether EPA\u2019s proposal would actually address such climate dangers as rising sea levels and soaring temperatures. \u201cThe way they\u2019ve promoted the rule is highly misleading,\u201d charged Holmstead, who headed the EPA\u2019s air and radiation office under President George W. Bush. \u201cThis is the rule that\u2019s going to address all these risks,\u201d yet nowhere do EPA officials say how the proposed rule will do so. Calling its overall goal \u201cunrealistic,\u201d he noted that many states have already implemented \u201ceasy fixes and easy improvements\u201d to try to promote energy efficiency and renewable sources, thus reducing carbon pollution. Currently, according to the EPA, 38 states have their own renewable portfolio standards or goals; 27 have the same for energy efficiency. For most, Holmstead said, \u201cI don\u2019t think there\u2019s any plausible way to comply without a cap and trade proposal or a carbon tax\u201d \u2014 an option fraught with politics. Not all power companies reacted negatively to the EPA\'s proposal. Jack Ihle, of Xcel Energy, a large utility operating gas plants and wind farms in Minnesota and Colorado, acknowledged that the plan has the potential to significantly change the way the industry produces electricity. Seeing itself as an industry leader, Xcel has retired coal plants, renovated gas plants, and served as what Ihle called the "number one provider of wind energy to customers for 10 straight years," all to try to reduce its carbon emissions. Such moves "have been made very clear under this new rule," Ihle said, adding that Xcel "hopes to achieve recognition of significant emission reductions" under it. Environmental advocates welcomed the EPA proposal as a long time coming, applauding both its national limit and its political message. \u201cWe think this is the right direction,\u201d said Abigail Dillen, of the public-interest law firm Earthjustice, which, like many environmental groups, will be pushing the EPA to cut carbon pollution even further in its final rule. She added, \u201cThe most important thing to do today is celebrate that the president has taken this tremendously courageous action.\u201d The EPA proposal must go through a 120-day public comment period and additional reviews.Next month, the agency also plans to hold four public hearings on the proposal, in Denver, Atlanta, Pittsburgh, and Washington, D.C. A final rule is expected by June 2015.',
  'title': u'EPA plan would slash climate-damaging carbon emissions from 1,000 existing power plants',
  'url': u'http://www.publicintegrity.org/2014/06/02/14879/epa-plan-would-slash-climate-damaging-carbon-emissions-1000-existing-power-plants'},
 {'article_html': u'<p>A prominent Tennessee state senator involved in national juvenile justice reforms said he is troubled by a recent <a href="http://www.publicintegrity.org/2014/05/09/14699/juvenile-injustice-truants-face-courts-jailing-without-legal-counsel-aid-them">Center for Public Integrity report</a> on children who\u2019ve been prosecuted for truancy in his state, jailed and given permanent court records without the benefit of appointed legal counsel.</p>\n\n<p>\u201cThey should be provided proper notice and counsel at the front end,\u201d said state Sen. Mark Norris, a Republican from Collierville, near Memphis, who is the Tennessee Senate majority leader and was elected last fall to serve as chairman of the <a href="http://www.csg.org/about/MessageFromCSGChair.aspx">national Council of State Governments</a>.</p>\n\n<p>Norris said the findings in the Center\u2019s <a href="http://www.publicintegrity.org/2014/05/09/14699/juvenile-injustice-truants-face-courts-jailing-without-legal-counsel-aid-them">Juvenile Injustice</a> report \u201cneed to be aired,\u201d and if need be, he would consider supporting a legislative solution. &nbsp;</p>\n\n<p>The nonpartisan Council of State Governments provides staff research and policy recommendations to assist leaders in states struggling to shape solutions to problems. The council\u2019s <a href="http://www.csg.org/pubs/capitolideas/2014_jan_feb/csgtoolbox_justicecenter.aspx">Justice Center</a> has made documenting the negative impact of harsh school discipline \u2014 and keeping students out of the criminal justice system \u2014 a top priority in recent years. &nbsp;&nbsp;</p>\n\n<p>On Tuesday, with Norris joining in, the influential council plans to unveil a comprehensive \u201cconsensus\u201d report on school discipline recommendations. &nbsp;</p>\n\n<p>The report includes ideas authors argue are practical and cost-effective alternatives to removing students from schools through suspension and expulsion. The report also cautions against unnecessary referrals of students to police and to courts for school-based infractions.</p>\n\n<p>The council\u2019s own research \u2014 including a longitudinal project <a href="http://www.publicintegrity.org/2011/07/19/5259/study-finds-stunning-rates-discipline-among-texas-students">tracking suspended Texas students</a> over time \u2014 has found that \u201cwhen students are removed from the classroom as a disciplinary measure, the odds increase dramatically that they will repeat a grade, drop out, or become involved in the juvenile justice system.\u201d The report found that such actions disproportionately affect children of color and students with special needs.</p>\n\n<p>Norris said he has similar concerns about truancy prosecutions that fail to address kids\u2019 individual needs and problems and introduces them to the criminal justice system.</p>\n\n<p>He said he\u2019s been troubled to realize that kids get sent to court in the Memphis area for infractions like school dress code violations. \u201cThey still have the young boy there for the drooping drawers or sassing,\u201d he said.</p>\n\n<p>The Center\u2019s Juvenile Injustice report featured a student whose records show she was jailed the first time she appeared in court in Tennessee\u2019s Knox County and pleaded guilty to truancy without the benefit of a lawyer.</p>\n\n<p>Although truancy is not a crime, the student \u2014 who was struggling with unrecognized special needs at school \u2014 was unaware the court gave her a delinquency record in connection with her truancy. Such a record remains on file unless youths later request such files be expunged.&nbsp;</p>\n<p>Other truants interviewed by the Center said they were shackled and jailed in a Knox County juvenile detention center after they were accused of failing to follow court orders governing their behavior \u2014 including orders of mandatory drug testing and court-prescribed counseling programs, at the students\u2019 own expense.</p>\n\n<p>The&nbsp;<a href="http://www.publicintegrity.org/2014/05/19/14782/tennessee-supreme-court-declines-review-case-featured-center-report">U.S. Justice Department</a>&nbsp;is looking into practices in Knox County. It is unclear how many truants have been jailed in the county \u2014 with or without representation \u2014 and how many might have permanent delinquency records that could surface to undermine future job and other applications.</p>\n\n<p>Knox County volunteer lawyers say the Knox County Juvenile Court has rejected&nbsp;their offer to set up a project at the court to offer pro bono counsel to accused truants as they arrive with parents to hearings.</p>\n\n<p>Truancy in most states is not a crime, and the accused minors do not benefit from the constitutional right to appointed counsel when they first enter court and before they plead guilty. Truancy is a status offense, like violating a curfew or running away, infractions that only minors can be accused of committing.</p>\n\n<p>Federal law does not allow immediate jailing of status offenders if states wish to receive federal juvenile-justice grants, as Tennessee does. However, federal law does allow limited jailing of status offenders if judges impose court orders on these minors and they fail to obey them. The youths must first be afforded appointed attorneys, however, if courts are considering jailing the youths in response to their failure to follow orders.</p>\n\n<p>Some parents and youths jailed in Knox County told the Center that they were not informed of that right. Lawyers in Knox County who later represented children who had been jailed said there was no proof in these emotionally troubled students\u2019 files that they had been offered appointed attorneys before those jailings.&nbsp;</p>\n\n<p>Norris, in response, said: \u201cYou have federal rules in place and apparently they\u2019re being ignored.\u201d</p>\n\n<p>Norris also said he was troubled that accused truants don\u2019t benefit from attorneys \u2014 if they can\u2019t afford to hire one \u2014 when they are first summoned to court and asked to enter a plea. &nbsp;&nbsp;</p>\n\n<p>\u201cHow can that plea be a knowing plea without representation \u2014 especially with a child?\u201d Norris said. &nbsp;</p>\n\n<p>In 2012, more than 9,600 accused truants were summoned to courts in Tennessee.</p>\n\n<p>Nationally, in 2010, about 137,000 status offenders, about a third of them truants, were ordered into courts for their infractions, according to the&nbsp;<a href="http://www.vera.org/sites/default/files/resources/downloads/from-courts-to-communities-response-to-status-offenses-v2.pdf">Vera Institute of Justice</a>.</p>\n\n<p>Some states require that truants or other status offenders receive representation automatically or early during their involvement in courts. In 2012, an attempt in Tennessee by establish that immediate right to counsel for truants failed without debate in the state legislature; a fiscal analysis found the proposal would require an additional half million dollars a year on top of juvenile indigent defense costs estimated at $2 million in 2010 out of $37 million overall for indigent defense.</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/TLHVmq0tkA8" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/TLHVmq0tkA8'],
  'article_links': ['http://www.publicintegrity.org/2014/05/19/14782/tennessee-supreme-court-declines-review-case-featured-center-report',
   'http://www.publicintegrity.org/2014/05/09/14699/juvenile-injustice-truants-face-courts-jailing-without-legal-counsel-aid-them',
   'http://www.publicintegrity.org/2011/07/19/5259/study-finds-stunning-rates-discipline-among-texas-students',
   'http://www.csg.org/about/MessageFromCSGChair.aspx',
   'http://www.vera.org/sites/default/files/resources/downloads/from-courts-to-communities-response-to-status-offenses-v2.pdf',
   'http://www.csg.org/pubs/capitolideas/2014_jan_feb/csgtoolbox_justicecenter.aspx'],
  'authors': [u'Susan Ferriss'],
  'datetime': datetime.datetime(2014, 6, 3, 19, 20, 46, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Juvenile Justice'],
  'text': u'A prominent Tennessee state senator involved in national juvenile justice reforms said he is troubled by a recent Center for Public Integrity report on children who\u2019ve been prosecuted for truancy in his state, jailed and given permanent court records without the benefit of appointed legal counsel. \u201cThey should be provided proper notice and counsel at the front end,\u201d said state Sen. Mark Norris, a Republican from Collierville, near Memphis, who is the Tennessee Senate majority leader and was elected last fall to serve as chairman of the national Council of State Governments. Norris said the findings in the Center\u2019s Juvenile Injustice report \u201cneed to be aired,\u201d and if need be, he would consider supporting a legislative solution. The nonpartisan Council of State Governments provides staff research and policy recommendations to assist leaders in states struggling to shape solutions to problems. The council\u2019s Justice Center has made documenting the negative impact of harsh school discipline \u2014 and keeping students out of the criminal justice system \u2014 a top priority in recent years. On Tuesday, with Norris joining in, the influential council plans to unveil a comprehensive \u201cconsensus\u201d report on school discipline recommendations. The report includes ideas authors argue are practical and cost-effective alternatives to removing students from schools through suspension and expulsion. The report also cautions against unnecessary referrals of students to police and to courts for school-based infractions. The council\u2019s own research \u2014 including a longitudinal project tracking suspended Texas students over time \u2014 has found that \u201cwhen students are removed from the classroom as a disciplinary measure, the odds increase dramatically that they will repeat a grade, drop out, or become involved in the juvenile justice system.\u201d The report found that such actions disproportionately affect children of color and students with special needs. Norris said he has similar concerns about truancy prosecutions that fail to address kids\u2019 individual needs and problems and introduces them to the criminal justice system. He said he\u2019s been troubled to realize that kids get sent to court in the Memphis area for infractions like school dress code violations. \u201cThey still have the young boy there for the drooping drawers or sassing,\u201d he said. The Center\u2019s Juvenile Injustice report featured a student whose records show she was jailed the first time she appeared in court in Tennessee\u2019s Knox County and pleaded guilty to truancy without the benefit of a lawyer. Although truancy is not a crime, the student \u2014 who was struggling with unrecognized special needs at school \u2014 was unaware the court gave her a delinquency record in connection with her truancy. Such a record remains on file unless youths later request such files be expunged. Other truants interviewed by the Center said they were shackled and jailed in a Knox County juvenile detention center after they were accused of failing to follow court orders governing their behavior \u2014 including orders of mandatory drug testing and court-prescribed counseling programs, at the students\u2019 own expense. TheU.S. Justice Departmentis looking into practices in Knox County. It is unclear how many truants have been jailed in the county \u2014 with or without representation \u2014 and how many might have permanent delinquency records that could surface to undermine future job and other applications. Knox County volunteer lawyers say the Knox County Juvenile Court has rejectedtheir offer to set up a project at the court to offer pro bono counsel to accused truants as they arrive with parents to hearings. Truancy in most states is not a crime, and the accused minors do not benefit from the constitutional right to appointed counsel when they first enter court and before they plead guilty. Truancy is a status offense, like violating a curfew or running away, infractions that only minors can be accused of committing. Federal law does not allow immediate jailing of status offenders if states wish to receive federal juvenile-justice grants, as Tennessee does. However, federal law does allow limited jailing of status offenders if judges impose court orders on these minors and they fail to obey them. The youths must first be afforded appointed attorneys, however, if courts are considering jailing the youths in response to their failure to follow orders. Some parents and youths jailed in Knox County told the Center that they were not informed of that right. Lawyers in Knox County who later represented children who had been jailed said there was no proof in these emotionally troubled students\u2019 files that they had been offered appointed attorneys before those jailings. Norris, in response, said: \u201cYou have federal rules in place and apparently they\u2019re being ignored.\u201d Norris also said he was troubled that accused truants don\u2019t benefit from attorneys \u2014 if they can\u2019t afford to hire one \u2014 when they are first summoned to court and asked to enter a plea. \u201cHow can that plea be a knowing plea without representation \u2014 especially with a child?\u201d Norris said. In 2012, more than 9,600 accused truants were summoned to courts in Tennessee. Nationally, in 2010, about 137,000 status offenders, about a third of them truants, were ordered into courts for their infractions, according to theVera Institute of Justice. Some states require that truants or other status offenders receive representation automatically or early during their involvement in courts. In 2012, an attempt in Tennessee by establish that immediate right to counsel for truants failed without debate in the state legislature; a fiscal analysis found the proposal would require an additional half million dollars a year on top of juvenile indigent defense costs estimated at $2 million in 2010 out of $37 million overall for indigent defense.',
  'title': u'State Senate leader reacts to Center report, urging counsel for truants',
  'url': u'http://www.publicintegrity.org/2014/06/02/14873/state-senate-leader-reacts-center-report-urging-counsel-truants'},
 {'article_html': u'<p>If you read my column last week about <a href="https://www.publicintegrity.org/2014/05/26/14802/forcing-health-insurers-do-whats-right">a Senate hearing that showed how Obamacare has affected Americans</a>, you might have wondered if I was in the same room with reporters who presumably covered the event.</p>\n\n<p>The disparity goes a long way toward explaining why so many of us are clueless about the actual impact the law is having on our lives.</p>\n\n<p>The title of the May 21 Senate Commerce Committee hearing: \u201cDelivering Better Health Care Value to Consumers: The First Three Years of the Medical Loss Ratio.\u201d I was one of four witnesses talking about the part &nbsp;of the law that requires health insurers to issue rebates to policyholders if they spend more than 20 percent of premiums &nbsp;on non-medical expenses, including profits \u2014 the so-called Medical Loss Ratio.</p>\n\n<p>Prior to the passage of the law, insurance company executives \u2014 who consider what they spend on medical care to be a loss \u2014 were in many cases devoting up to half of premiums they collected to pay for advertising and other administrative functions and to reward executives and shareholders.</p>\n\n<p>As I wrote <a href="https://www.publicintegrity.org/2014/05/26/14802/forcing-health-insurers-do-whats-right">last week</a>, consumers have saved at least $3 billion since the provision of the law that mandates insurers must spend at least 80 percent of our premiums on medical care went into effect in 2011.</p>\n\n<p>The hearing wasn\u2019t just about numbers, however. Katherine Fernandez, a small business owner from Houston, testified about how the MLR provision and other aspects of the law have enabled her family to pay less for far more comprehensive coverage than was possible in the past.</p>\n\n<p>She told the committee that because both her husband and son had pre-existing conditions, the only policies available to them pre-Obamacare would not cover any medical care pertaining to those maladies. And even then the policies had both high premiums and high deductibles. She said that during the 14 years prior to the law\u2019s passage, her family paid more than $100,000 in premiums for what she described as bare-bones coverage. And the premiums went up sharply every year \u2014 165 percent between 2000 and 2003 alone.</p>\n\n<p>She said she was elated when the Affordable Care Act passed. \u201cNo more pre-existing condition clauses \u2026 and insurance companies had to refund some of what we paid if they didn\u2019t spend enough. What reasonable ideas.\u201d</p>\n\n<p>If you read the accounts of the hearing in <em><a href="http://www.washingtonpost.com/politics/rockefellers-says-race-colors-gop-views-on-obama/2014/05/22/b278565c-e1f1-11e3-8dcc-d6b7fede081a_story.html">The Washington Post</a>, <a href="http://www.usatoday.com/story/theoval/2014/05/22/obama-health-care-jay-rockefeller-ron-johnson/9434021/">USA Today</a>, <a href="http://www.politico.com/story/2014/05/jay-rockefeller-john-johnson-race-106983.html#ixzz33DtJEY00">Politico</a></em> or <a href="http://www.cbsnews.com/news/dont-call-me-a-racist-republican-senator-ron-johnson-tells-democrat-jay-rockefeller/">CBS News</a>&nbsp;\u2014 the only news outlets I could find that provided any coverage \u2014 you would not have read anything about the $3 billion consumers have saved as a result of the MLR provision or how the law has benefited the Fernandez family.</p>\n<p>The focus of all those stories was a brief exchange toward the end of the hearing between Committee Chair Jay Rockefeller, a West Virginia Democrat, and GOP Sen. Ron Johnson of Wisconsin about whether the color of President Obama\u2019s skin might explain why some people are opposed to the law.&nbsp;</p>\n\n<p>Rockefeller suggested race might be a factor, which provoked a spirited denial from Johnson.&nbsp;<em>Politico\u2019s&nbsp;</em>only hint about the hearing\u2019s actual subject was this: \u201cHis (Rockefeller\u2019s) critiques of the GOP again came in a sparsely attended committee hearing, this time during an analysis of health-care spending.\u201d</p>\n\n<p>The only one of these pieces that even mentioned \u201cmedical loss ratio\u201d was the CBS story, and it, too, was primarily about the exchange between Rockefeller and Johnson. In the&nbsp;<em>USA Today</em>&nbsp;article, which apparently was based on a&nbsp;<em>National Journal</em>&nbsp;transcript, the only hint of a hearing was in the very last sentence:&nbsp; "Rockefeller then veered into another topic before adjourning the hearing."</p>\n\n<p>That other topic, of course, was the medical loss ratio.</p>\n\n<p><em>The Washington Post</em>&nbsp;likewise found medical loss ratio of no interest. Its story, too, was about the back-and-forth between Rockefeller and Johnson during what the reporter dismissed as \u201can otherwise sleepy committee hearing.\u201d</p>\n\n<p>Granted, it is challenging to substantively cover the Affordable Care Act. The U.S. health care system is dizzyingly complex, and so is the law. It\u2019s far easier to write about constant political sparring than to take the time to educate readers about what\u2019s actually in the law and how it affects people. It\u2019s not a heavy lift to review a transcript and write the kind of \u201che said, she said\u201d \u2014 in this case the \u201che said, he said\u201d \u2014 coverage that passes for journalism.</p>\n\n<p>There are a lot of reasons why Americans don\u2019t know how the law affects them or why they believe things about Obamcare that aren\u2019t true. The Democrats have done a lousy job of explaining it. And more than $400 million has been spent by opponents attacking it \u2014 15 times as much as has been spent by supporters. But one of the biggest reasons is the failure of many in the media to provide anything other than the most superficial coverage. As a former reporter who used to cover hearings on the Hill, I consider that shameful.&nbsp;</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/3sSbRuSuOn8" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/3sSbRuSuOn8'],
  'article_links': ['http://www.washingtonpost.com/politics/rockefellers-says-race-colors-gop-views-on-obama/2014/05/22/b278565c-e1f1-11e3-8dcc-d6b7fede081a_story.html',
   'http://www.usatoday.com/story/theoval/2014/05/22/obama-health-care-jay-rockefeller-ron-johnson/9434021',
   'http://www.cbsnews.com/news/dont-call-me-a-racist-republican-senator-ron-johnson-tells-democrat-jay-rockefeller',
   'http://www.politico.com/story/2014/05/jay-rockefeller-john-johnson-race-106983.html',
   'https://www.publicintegrity.org/2014/05/26/14802/forcing-health-insurers-do-whats-right'],
  'authors': [u'Wendell Potter'],
  'datetime': datetime.datetime(2014, 6, 2, 10, 2, 2, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Health', u'Wendell Potter'],
  'text': u'If you read my column last week about a Senate hearing that showed how Obamacare has affected Americans, you might have wondered if I was in the same room with reporters who presumably covered the event. The disparity goes a long way toward explaining why so many of us are clueless about the actual impact the law is having on our lives. The title of the May 21 Senate Commerce Committee hearing: \u201cDelivering Better Health Care Value to Consumers: The First Three Years of the Medical Loss Ratio.\u201d I was one of four witnesses talking about the part of the law that requires health insurers to issue rebates to policyholders if they spend more than 20 percent of premiums on non-medical expenses, including profits \u2014 the so-called Medical Loss Ratio. Prior to the passage of the law, insurance company executives \u2014 who consider what they spend on medical care to be a loss \u2014 were in many cases devoting up to half of premiums they collected to pay for advertising and other administrative functions and to reward executives and shareholders. As I wrote last week, consumers have saved at least $3 billion since the provision of the law that mandates insurers must spend at least 80 percent of our premiums on medical care went into effect in 2011. The hearing wasn\u2019t just about numbers, however. Katherine Fernandez, a small business owner from Houston, testified about how the MLR provision and other aspects of the law have enabled her family to pay less for far more comprehensive coverage than was possible in the past. She told the committee that because both her husband and son had pre-existing conditions, the only policies available to them pre-Obamacare would not cover any medical care pertaining to those maladies. And even then the policies had both high premiums and high deductibles. She said that during the 14 years prior to the law\u2019s passage, her family paid more than $100,000 in premiums for what she described as bare-bones coverage. And the premiums went up sharply every year \u2014 165 percent between 2000 and 2003 alone. She said she was elated when the Affordable Care Act passed. \u201cNo more pre-existing condition clauses \u2026 and insurance companies had to refund some of what we paid if they didn\u2019t spend enough. What reasonable ideas.\u201d If you read the accounts of the hearing in The Washington Post, USA Today, Politico or CBS News\u2014 the only news outlets I could find that provided any coverage \u2014 you would not have read anything about the $3 billion consumers have saved as a result of the MLR provision or how the law has benefited the Fernandez family. The focus of all those stories was a brief exchange toward the end of the hearing between Committee Chair Jay Rockefeller, a West Virginia Democrat, and GOP Sen. Ron Johnson of Wisconsin about whether the color of President Obama\u2019s skin might explain why some people are opposed to the law. Rockefeller suggested race might be a factor, which provoked a spirited denial from Johnson.Politico\u2019sonly hint about the hearing\u2019s actual subject was this: \u201cHis (Rockefeller\u2019s) critiques of the GOP again came in a sparsely attended committee hearing, this time during an analysis of health-care spending.\u201d The only one of these pieces that even mentioned \u201cmedical loss ratio\u201d was the CBS story, and it, too, was primarily about the exchange between Rockefeller and Johnson. In theUSA Todayarticle, which apparently was based on aNational Journaltranscript, the only hint of a hearing was in the very last sentence: "Rockefeller then veered into another topic before adjourning the hearing." That other topic, of course, was the medical loss ratio. The Washington Postlikewise found medical loss ratio of no interest. Its story, too, was about the back-and-forth between Rockefeller and Johnson during what the reporter dismissed as \u201can otherwise sleepy committee hearing.\u201d Granted, it is challenging to substantively cover the Affordable Care Act. The U.S. health care system is dizzyingly complex, and so is the law. It\u2019s far easier to write about constant political sparring than to take the time to educate readers about what\u2019s actually in the law and how it affects people. It\u2019s not a heavy lift to review a transcript and write the kind of \u201che said, she said\u201d \u2014 in this case the \u201che said, he said\u201d \u2014 coverage that passes for journalism. There are a lot of reasons why Americans don\u2019t know how the law affects them or why they believe things about Obamcare that aren\u2019t true. The Democrats have done a lousy job of explaining it. And more than $400 million has been spent by opponents attacking it \u2014 15 times as much as has been spent by supporters. But one of the biggest reasons is the failure of many in the media to provide anything other than the most superficial coverage. As a former reporter who used to cover hearings on the Hill, I consider that shameful.',
  'title': u"Shameful coverage of Obamacare's real impacts",
  'url': u'http://www.publicintegrity.org/2014/06/02/14864/shameful-coverage-obamacares-real-impacts'},
 {'article_html': u'<p>A class-action lawsuit filed against the state of California Thursday alleges that low-income students are deprived of an equal education because they are denied academic instruction time \u2014 yet assigned to excessive hours of \u201cservice\u201d that include tasks like tidying up classrooms.</p>\n\n<p>In addition to being assigned menial tasks at school, some pupils \u2014 even those below grade level in reading or other subjects \u2014 are simply sent home during free time \u201ceven though they are supposed to receiving a full day of education,\u201d <a href="http://www.publiccounsel.org/press_releases?id=0081">the suit</a> filed in Alameda County Superior Court argues.</p>\n\n<p>The 18 plaintiffs in the suit are Latino and black students at seven of the state\u2019s most disadvantaged and underfunded schools, whose students are almost all ethnic minorities. The schools are located in Los Angeles County and the San Francisco Bay Area. The suit demands that the state of California \u2014 a defendant in the suit \u2014 monitor practices at the schools and intervene to make improvements.&nbsp;</p>\n\n<p>\u201cI think a lot of parents would be aghast if these were the conditions in <em>their</em> children\u2019s schools,\u201d said Kathryn Eidmann, Los Angeles-based staff attorney at Public Counsel, the nation\u2019s largest pro bono law firm. Public Counsel is representing the plaintiffs, along with the American Civil Liberties Union of Southern California and other legal groups. Certain practices \u201cslowly rob\u201d students of real instructional time, lawyers said.</p>\n\n<p>At-school \u201cwork\u201d periods assigned to students are \u201cclasses in name only,\u201d Eidmann said. \u201cIt\u2019s being done to fill a hole.\u201d Many teachers at the schools face tough challenges, Eidmann said, and staff turnover during the year and the use of multiple substitute teachers are common.</p>\n\n<p>State officials said they had not yet had time to review the litigation, but also cited fresh efforts to improve the situation for low-income students.&nbsp;</p>\n\n<p>The suit comes just as California lawmakers launch an initiative they hope will boost lagging graduation and academic proficiency among Latino and black students, in particular. Students registering lower rates of graduation and achievement are concentrated in schools stripped bare by years of state budget cuts and unequal local financial support.</p>\n\n<p>The Golden State \u2014 long seen as a bellwether for national trends \u2014 is preparing to send millions of new state dollars to districts so they can use the funds, based on local jurisdictions\u2019 own plan, to upgrade education for disadvantaged children.&nbsp;</p>\n\n<p>The lawsuit filed Thursday alleges that at Fremont High School in Oakland, approximately one-third of seniors are assigned to so-called \u201cInside Work Experience\u201d periods \u201cinstead of being placed in meaningful core or enrichment classes.\u201d Students sort mail, run errands and perform other tasks. Juniors in the school of some 800 students are also assigned such work periods as well, the suit says.</p>\n<p>\u201cWhen plaintiff Daisy Romo received her schedule at the beginning of the 2013-2014 school year,\u201d according to the suit, \u201cshe was first assigned to an IWE (Inside Work Experience) instead of a science class.\u201d</p>\n\n<p>In L.A. County, at Compton High School, another \u201cchronically low performing school\u201d with a high rate of staff turnover, students are also allegedly assigned to \u201cteaching assistant\u201d periods during which kids help teachers with tasks or simply get \u201cfree periods.\u201d Plaintiff Lucia Barajas, according to the suit, requested that a free period she was given be switched to a chemistry class she needed to pass to graduate.</p>\n\n<p>\u201cShe was told, however, there was no space in any chemistry class,\u201d the suit says.</p>\n\n<p>Another Compton High student, Ignacia Barajas, was enrolled in a U.S. history class with more than 10 substitute teachers during the fall 2013 semester. \u201cOn some days,\u201d according to the suit, \u201cno substitute teacher showed up at all. The class waited outside the classroom door until they were sent to the library or another teacher\u2019s classroom for the duration of the class period.\u201d</p>\n<p>At Castlemont High School in Oakland, student plaintiff Lee Simmons was assigned \u201cwork experience\u201d periods for two out of six periods in the day. That\u2019s a 33 percent reduction in his instructional learning time during his senior year, according to the suit.&nbsp;In South Central&nbsp;Los Angeles, student Jessy Cruz of&nbsp;a school also called&nbsp;Fremont High School will graduate&nbsp;without enough credits to enter a four-year college. Yet he was assigned to two "service" periods at school and a period of "home" time, the suit also says.</p>\n\n<p>The suit argues that academic instructional time the plaintiffs have been getting is \u201cfar below the norm\u201d in public schools across the state, even though large numbers of these students are struggling to catch up with affluent peers.</p>\n\n<p>Even if they are able to graduate, Eidmann said, they are deprived of courses affluent students are getting in their schools that prepare them for entry to college.</p>\n\n<p>All the schools named in the suit \u2014 including one elementary school \u2014 are affected by neighborhood violence that lead to \u201clockdowns,\u201d resulting in hours, even days of lost instructional time, lawyers for the students also argue. Some schools have few or no counselors or psychologists on staff to help thousands of students cope with disturbances that spark fear and absenteeism.&nbsp;</p>\n\n<p>\u201cFor these students, consigned to a series of schools that perpetually fail to deliver education, hope fades and potential is crushed,\u201d the suit argues. \u201cThe loss of educational opportunity does not occur in any dramatic, headline-making way,\u201d but rather \u201cover time, from the loss of learning time itself.\u201d</p>\n\n<p>Students receive \u201cfewer minutes of learning per hour, fewer hours per week, and fewer weeks per year. As a result of this massive deprivation, an indefensibly high percentage of students at these schools fall far behind, give up, and drop out.\u201d</p>\n\n<p>State Superintendent of Public Instruction Tom Torlakson \u2014 who is named&nbsp;as a defendant \u2014 and State Board of Education President Michael Kirst issued a statement Thursday saying that they hadn\u2019t had time to review specific claims in the suit. But the statement also said: \u201cCalifornia\u2019s education system is in the midst of a historic effort to shift authority over decision making to local school districts, empowering them to determine how best to meet the needs of the students they serve.\u201d</p>\n\n<p>The statement encouraged plaintiffs\u2019 lawyers to work with local school districts.</p>\n\n<p>Troy Flint, director of communications for the Oakland Unified School District, said, \u201cWe are not opposed to the lawsuit\u201d filed by Public Counsel and the ACLU. Flint said the district is aware \u201cthere are serious problems\u201d at Fremont and Castlemont high schools. He said that the district has been trying to initiate reforms at each school to ensure students are put into more appropriate classes.</p>\n\n<p>The suit argues that practices to patch together classes for students at these underfunded and troubled schools are violating students\u2019 right to educational opportunities, regardless of \u201cwealth or race\u201d under the California State Constitution.</p>\n<p>In 2013, the&nbsp;Center for Public Integrity&nbsp;published reports on the expulsion of students in California\u2019s Kern County \u2014 mostly for behavior that did not require expulsion \u2014 and their&nbsp;<a href="https://www.publicintegrity.org/2013/07/15/12951/throwaway-kids-disciplined-california-teens-struggle-school-themselves" style="line-height: 1.6;">assignment to alternative schools so far away</a>&nbsp;the students were put on home-study plans or dropped out. Most were the children of farmworkers who were unable to drive their children back and forth to schools 20 to 40 miles away. The students expected to school themselves at home four out of five days a week were counted as full-time enrolled students.</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/FaoH8_u4tKE" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/FaoH8_u4tKE'],
  'article_links': ['https://www.publicintegrity.org/2013/07/15/12951/throwaway-kids-disciplined-california-teens-struggle-school-themselves',
   'http://www.publiccounsel.org/press_releases'],
  'authors': [u'Susan Ferriss'],
  'datetime': datetime.datetime(2014, 5, 30, 17, 42, 12, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Juvenile Justice'],
  'text': u'A class-action lawsuit filed against the state of California Thursday alleges that low-income students are deprived of an equal education because they are denied academic instruction time \u2014 yet assigned to excessive hours of \u201cservice\u201d that include tasks like tidying up classrooms. In addition to being assigned menial tasks at school, some pupils \u2014 even those below grade level in reading or other subjects \u2014 are simply sent home during free time \u201ceven though they are supposed to receiving a full day of education,\u201d the suit filed in Alameda County Superior Court argues. The 18 plaintiffs in the suit are Latino and black students at seven of the state\u2019s most disadvantaged and underfunded schools, whose students are almost all ethnic minorities. The schools are located in Los Angeles County and the San Francisco Bay Area. The suit demands that the state of California \u2014 a defendant in the suit \u2014 monitor practices at the schools and intervene to make improvements. \u201cI think a lot of parents would be aghast if these were the conditions in their children\u2019s schools,\u201d said Kathryn Eidmann, Los Angeles-based staff attorney at Public Counsel, the nation\u2019s largest pro bono law firm. Public Counsel is representing the plaintiffs, along with the American Civil Liberties Union of Southern California and other legal groups. Certain practices \u201cslowly rob\u201d students of real instructional time, lawyers said. At-school \u201cwork\u201d periods assigned to students are \u201cclasses in name only,\u201d Eidmann said. \u201cIt\u2019s being done to fill a hole.\u201d Many teachers at the schools face tough challenges, Eidmann said, and staff turnover during the year and the use of multiple substitute teachers are common. State officials said they had not yet had time to review the litigation, but also cited fresh efforts to improve the situation for low-income students. The suit comes just as California lawmakers launch an initiative they hope will boost lagging graduation and academic proficiency among Latino and black students, in particular. Students registering lower rates of graduation and achievement are concentrated in schools stripped bare by years of state budget cuts and unequal local financial support. The Golden State \u2014 long seen as a bellwether for national trends \u2014 is preparing to send millions of new state dollars to districts so they can use the funds, based on local jurisdictions\u2019 own plan, to upgrade education for disadvantaged children. The lawsuit filed Thursday alleges that at Fremont High School in Oakland, approximately one-third of seniors are assigned to so-called \u201cInside Work Experience\u201d periods \u201cinstead of being placed in meaningful core or enrichment classes.\u201d Students sort mail, run errands and perform other tasks. Juniors in the school of some 800 students are also assigned such work periods as well, the suit says. \u201cWhen plaintiff Daisy Romo received her schedule at the beginning of the 2013-2014 school year,\u201d according to the suit, \u201cshe was first assigned to an IWE (Inside Work Experience) instead of a science class.\u201d In L.A. County, at Compton High School, another \u201cchronically low performing school\u201d with a high rate of staff turnover, students are also allegedly assigned to \u201cteaching assistant\u201d periods during which kids help teachers with tasks or simply get \u201cfree periods.\u201d Plaintiff Lucia Barajas, according to the suit, requested that a free period she was given be switched to a chemistry class she needed to pass to graduate. \u201cShe was told, however, there was no space in any chemistry class,\u201d the suit says. Another Compton High student, Ignacia Barajas, was enrolled in a U.S. history class with more than 10 substitute teachers during the fall 2013 semester. \u201cOn some days,\u201d according to the suit, \u201cno substitute teacher showed up at all. The class waited outside the classroom door until they were sent to the library or another teacher\u2019s classroom for the duration of the class period.\u201d At Castlemont High School in Oakland, student plaintiff Lee Simmons was assigned \u201cwork experience\u201d periods for two out of six periods in the day. That\u2019s a 33 percent reduction in his instructional learning time during his senior year, according to the suit.In South CentralLos Angeles, student Jessy Cruz ofa school also calledFremont High School will graduatewithout enough credits to enter a four-year college. Yet he was assigned to two "service" periods at school and a period of "home" time, the suit also says. The suit argues that academic instructional time the plaintiffs have been getting is \u201cfar below the norm\u201d in public schools across the state, even though large numbers of these students are struggling to catch up with affluent peers. Even if they are able to graduate, Eidmann said, they are deprived of courses affluent students are getting in their schools that prepare them for entry to college. All the schools named in the suit \u2014 including one elementary school \u2014 are affected by neighborhood violence that lead to \u201clockdowns,\u201d resulting in hours, even days of lost instructional time, lawyers for the students also argue. Some schools have few or no counselors or psychologists on staff to help thousands of students cope with disturbances that spark fear and absenteeism. \u201cFor these students, consigned to a series of schools that perpetually fail to deliver education, hope fades and potential is crushed,\u201d the suit argues. \u201cThe loss of educational opportunity does not occur in any dramatic, headline-making way,\u201d but rather \u201cover time, from the loss of learning time itself.\u201d Students receive \u201cfewer minutes of learning per hour, fewer hours per week, and fewer weeks per year. As a result of this massive deprivation, an indefensibly high percentage of students at these schools fall far behind, give up, and drop out.\u201d State Superintendent of Public Instruction Tom Torlakson \u2014 who is namedas a defendant \u2014 and State Board of Education President Michael Kirst issued a statement Thursday saying that they hadn\u2019t had time to review specific claims in the suit. But the statement also said: \u201cCalifornia\u2019s education system is in the midst of a historic effort to shift authority over decision making to local school districts, empowering them to determine how best to meet the needs of the students they serve.\u201d The statement encouraged plaintiffs\u2019 lawyers to work with local school districts. Troy Flint, director of communications for the Oakland Unified School District, said, \u201cWe are not opposed to the lawsuit\u201d filed by Public Counsel and the ACLU. Flint said the district is aware \u201cthere are serious problems\u201d at Fremont and Castlemont high schools. He said that the district has been trying to initiate reforms at each school to ensure students are put into more appropriate classes. The suit argues that practices to patch together classes for students at these underfunded and troubled schools are violating students\u2019 right to educational opportunities, regardless of \u201cwealth or race\u201d under the California State Constitution. In 2013, theCenter for Public Integritypublished reports on the expulsion of students in California\u2019s Kern County \u2014 mostly for behavior that did not require expulsion \u2014 and theirassignment to alternative schools so far awaythe students were put on home-study plans or dropped out. Most were the children of farmworkers who were unable to drive their children back and forth to schools 20 to 40 miles away. The students expected to school themselves at home four out of five days a week were counted as full-time enrolled students.',
  'title': u"Lawsuit: Low-income students assigned too much 'work experience' or free time instead of classes they need",
  'url': u'http://www.publicintegrity.org/2014/05/30/14852/lawsuit-low-income-students-assigned-too-much-work-experience-or-free-time-instead'},
 {'article_html': u'<p>An Iowa-based organization <a href="http://protecttheharvest.com/who-we-are/mission-statement/">dedicated to combating</a> \u201cthe radical animal rights movement\u201d and led by a former Missouri Republican senator\u2019s chief of staff has launched a new super PAC, according to <a href="http://docquery.fec.gov/pdf/009/14031242009/14031242009.pdf#navpanes=0">paperwork</a> filed with the Federal Election Commission.</p>\n\n<p>The Protect the Harvest Political Action Committee told the elections regulator that it \u201cintends to raise funds in unlimited amounts\u201d to call for the election or defeat of federal candidates.</p>\n\n<p>Which politicos will be targeted, however, is still unclear.</p>\n\n<p>Neither the super PAC\u2019s treasurer, Brian Klippenstein, nor its attorney, Mark Roth, responded to requests for comment from the <a href="http://www.publicintegrity.org/">Center for Public Integrity</a>.</p>\n\n<p>Super PACs are legally allowed to solicit unlimited contributions to produce political advertisements \u2014 so long as their spending is not coordinated with any candidates\u2019 campaigns.</p>\n\n<p>Klippenstein <a href="http://protecttheharvest.com/who-we-are/brian-klippenstein/">currently serves</a> as the executive director of Protect the Harvest, a 501(c)(4) \u201csocial welfare\u201d nonprofit established in 2011 to educate the public about \u201cthe benefits of farming, ranching and hunting\u201d and to advocate \u201cfor the right to conduct such activities.\u201d</p>\n\n<p>The nonprofit may engage in politics, although federal law mandates that influencing elections may not be its primary purpose.</p>\n\n<p>On its website, Protect the Harvest <a href="http://protecttheharvest.com/who-we-are/mission-statement/">warns</a> that \u201cthe animal rights movement in America, led by the Humane Society of the United States, has evolved into a wealthy and successful attack group determined to end the consumption of meat, threaten consumer access to affordable food, eliminate hunting, outlaw rodeos and circuses and even ban animal ownership (including pets) altogether.\u201d</p>\n\n<p>That\'s "baloney," said Joe Maxwell, the Humane Society of the United States\' vice president of outreach and engagement. He said his organization is "leading efforts to ensure that we have good stewards of the land and the animals on our farms."</p>\n\n<p>Protect the Harvest, Maxwell asserted, is "nothing but a front group" that is "in bed with industrialized agriculture."</p>\n<p>Previously, Klippenstein spent 26 years on Capitol Hill working for Missouri Republicans, including Sens. Roy Blunt and Kit Bond \u2014 the latter for whom he served as chief of staff for five years, according to Klippenstein\u2019s <a href="http://protecttheharvest.com/who-we-are/brian-klippenstein/">online biography</a>.</p>\n\n<p>For his part, Roth is also listed as the registered agent and incorporator of Protect the Harvest, according to <a href="http://sos.iowa.gov/search/business/(S(1j4xsz55hj5xom55i2p3tr45))/summary.aspx">Iowa business records</a>. Millionaire businessman Forrest Lucas, founder of Lucas Oil Products, serves as Protect the Harvest\u2019s president.</p>\n\n<p>Tax <a href="https://bulk.resource.org/irs.gov/eo/2012_09_EO/45-3551569_990O_201112.pdf" style="line-height: 1.6;">records</a> <a href="http://www.guidestar.org/FinDocuments/2012/453/551/2012-453551569-09f39eb8-9O.pdf" style="line-height: 1.6;">show</a> Protect the Harvest raised about $927,000 between October 2011 and December 2012. A report detailing its 2013 finances is not expected to be filed with the Internal Revenue Service until later this year.</p>\n\n<p>As a social welfare nonprofit, Protect the Harvest is not required to publicly disclose its donors.</p>\n\n<p><a href="http://docquery.fec.gov/pdf/PAPER/12961033005.pdf">FEC records indicate</a>, however, that Lucas Oil Products contributed $200,000 to Protect the Harvest in 2012 to fund <a href="http://www.youtube.com/watch?v=kY5MsnY2FmI">advertisements</a> critical of Iowa Democrat Christie Vilsack, who unsuccessfully challenged incumbent Republican Rep. Steve King.</p>\n\n<p>American Action Network, the social welfare nonprofit led by former GOP Sen. Norm Coleman of Minnesota, also contributed $100,000 to the group sometime between July 2012 and June 2013, according to <a href="https://www.documentcloud.org/documents/1160564-american-action-network-990-july-2012-june-2013.html">its annual tax return</a>.</p>\n\n<p>And a group called Missouri Farmers Care \u2014 which says its mission is to "solicit contributions to support education and advocacy for Missouri agriculture" \u2014 also <a href="http://990s.foundationcenter.org/990_pdf_archive/010/010958163/010958163_201212_990O.pdf">donated $35,000</a> Protect the Harvest in 2012.</p>\n\n<p>Documents list Dale Ludwig, the <a href="http://www.stltoday.com/business/local/leaders-out-at-missouri-soybean-group/article_a96a0b9b-242c-5a54-a6bb-67126f4508fe.html">longtime executive director</a> of the Missouri Soybean Association, as the treasurer of Missouri Farmers Care and as a director of Protect the Harvest. Jackie Klippenstein, Brian\'s wife and a <a href="http://www.dfamilk.com/our-cooperative/leadership/jackie-klippenstein">lobbyist for the Dairy Farmers of America</a>, is also listed as one of the 30 members of Missouri Farmers Care.</p>\n\n<p>Protect the Harvest\u2019s super PAC arm will be required to disclose its funders to the FEC.</p>\n\n<p>While Brian Klippenstein has financially supported Republicans such as 2012 presidential nominee Mitt Romney and House Speaker John Boehner in the past, he has not made any contributions to Iowa politicians this election cycle, according to a Center for Public Integrity review of FEC records. Nor has Lucas.</p>\n\n<p>Last year, Roth, the attorney, <a href="http://docquery.fec.gov/cgi-bin/fecimg/?14020094029">contributed $1,000</a> to businessman Mark Jacobs, who is seeking to become the Republican Party\u2019s nominee for U.S. Senate this year.</p>\n\n<p>Polls <a href="http://www.realclearpolitics.com/epolls/2014/senate/ia/iowa_senate_republican_primary-3644.html">show</a> Jacobs trailing state Sen. Joni Ernst ahead of the GOP\'s June 3 primary.</p>\n\n<p>Additionally, Protect the Harvest itself has endorsed a Missouri ballot measure, backed by the Missouri Farm Bureau, which would amend the state\u2019s constitution <a href="http://www.sos.mo.gov/elections/2014ballot/">to guarantee</a> that \u201cthe right of Missouri citizens to engage in agricultural production and ranching practices shall not be infringed.\u201d</p>\n\n<p>Protect the Harvest backed a similar \u2014 and <a href="http://www.mprnews.org/story/2012/11/08/business/north-dakota-right-to-farm">successful</a> \u2014 ballot measure in North Dakota in 2012.</p>\n\n<p>Critics <a href="http://quincyjournal.com/farm-agriculture/2014/01/9844/right-to-farm-in-missouri-is-seeing-some-backlash/">argue</a> \u201cright to farm\u201d laws, which have been <a href="http://www.alec.org/model-legislation/right-to-farm-act/">supported by</a> the board of the conservative-leaning American Legislative Exchange Council, <a href="http://naturalsociety.com/hawaiian-bill-restrict-countys-ability-reign-pesticides-gmos/">could impede</a> attempts to regulate genetically modified crops and may benefit large, agricultural corporations, not family farmers.</p>\n\n<p>"If right to farm would pass," said Maxwell, of the Humane Society, "it will allow foreign corporations and big agriculture corporations to do whatever they want in Missouri\'s countryside."</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/_x-jOEc2ixw" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/_x-jOEc2ixw'],
  'article_links': ['http://sos.iowa.gov/search/business/(S(1j4xsz55hj5xom55i2p3tr45))/summary.aspx',
   'http://www.dfamilk.com/our-cooperative/leadership/jackie-klippenstein',
   'http://docquery.fec.gov/cgi-bin/fecimg',
   'http://www.mprnews.org/story/2012/11/08/business/north-dakota-right-to-farm',
   'http://quincyjournal.com/farm-agriculture/2014/01/9844/right-to-farm-in-missouri-is-seeing-some-backlash',
   'http://www.youtube.com/watch',
   'http://naturalsociety.com/hawaiian-bill-restrict-countys-ability-reign-pesticides-gmos',
   'http://protecttheharvest.com/who-we-are/brian-klippenstein',
   'http://www.realclearpolitics.com/epolls/2014/senate/ia/iowa_senate_republican_primary-3644.html',
   'http://990s.foundationcenter.org/990_pdf_archive/010/010958163/010958163_201212_990O.pdf',
   'http://docquery.fec.gov/pdf/009/14031242009/14031242009.pdf',
   'https://www.documentcloud.org/documents/1160564-american-action-network-990-july-2012-june-2013.html',
   'http://www.alec.org/model-legislation/right-to-farm-act',
   'http://protecttheharvest.com/who-we-are/mission-statement',
   'http://www.sos.mo.gov/elections/2014ballot',
   'https://bulk.resource.org/irs.gov/eo/2012_09_EO/45-3551569_990O_201112.pdf',
   'http://www.stltoday.com/business/local/leaders-out-at-missouri-soybean-group/article_a96a0b9b-242c-5a54-a6bb-67126f4508fe.html',
   'http://www.publicintegrity.org',
   'http://docquery.fec.gov/pdf/PAPER/12961033005.pdf',
   'http://www.guidestar.org/FinDocuments/2012/453/551/2012-453551569-09f39eb8-9O.pdf'],
  'authors': [u'Michael Beckel'],
  'datetime': datetime.datetime(2014, 5, 29, 20, 20, 1, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Politics', u'Primary Source'],
  'text': u'An Iowa-based organization dedicated to combating \u201cthe radical animal rights movement\u201d and led by a former Missouri Republican senator\u2019s chief of staff has launched a new super PAC, according to paperwork filed with the Federal Election Commission. The Protect the Harvest Political Action Committee told the elections regulator that it \u201cintends to raise funds in unlimited amounts\u201d to call for the election or defeat of federal candidates. Which politicos will be targeted, however, is still unclear. Neither the super PAC\u2019s treasurer, Brian Klippenstein, nor its attorney, Mark Roth, responded to requests for comment from the Center for Public Integrity. Super PACs are legally allowed to solicit unlimited contributions to produce political advertisements \u2014 so long as their spending is not coordinated with any candidates\u2019 campaigns. Klippenstein currently serves as the executive director of Protect the Harvest, a 501(c)(4) \u201csocial welfare\u201d nonprofit established in 2011 to educate the public about \u201cthe benefits of farming, ranching and hunting\u201d and to advocate \u201cfor the right to conduct such activities.\u201d The nonprofit may engage in politics, although federal law mandates that influencing elections may not be its primary purpose. On its website, Protect the Harvest warns that \u201cthe animal rights movement in America, led by the Humane Society of the United States, has evolved into a wealthy and successful attack group determined to end the consumption of meat, threaten consumer access to affordable food, eliminate hunting, outlaw rodeos and circuses and even ban animal ownership (including pets) altogether.\u201d That\'s "baloney," said Joe Maxwell, the Humane Society of the United States\' vice president of outreach and engagement. He said his organization is "leading efforts to ensure that we have good stewards of the land and the animals on our farms." Protect the Harvest, Maxwell asserted, is "nothing but a front group" that is "in bed with industrialized agriculture." Previously, Klippenstein spent 26 years on Capitol Hill working for Missouri Republicans, including Sens. Roy Blunt and Kit Bond \u2014 the latter for whom he served as chief of staff for five years, according to Klippenstein\u2019s online biography. For his part, Roth is also listed as the registered agent and incorporator of Protect the Harvest, according to Iowa business records. Millionaire businessman Forrest Lucas, founder of Lucas Oil Products, serves as Protect the Harvest\u2019s president. Tax records show Protect the Harvest raised about $927,000 between October 2011 and December 2012. A report detailing its 2013 finances is not expected to be filed with the Internal Revenue Service until later this year. As a social welfare nonprofit, Protect the Harvest is not required to publicly disclose its donors. FEC records indicate, however, that Lucas Oil Products contributed $200,000 to Protect the Harvest in 2012 to fund advertisements critical of Iowa Democrat Christie Vilsack, who unsuccessfully challenged incumbent Republican Rep. Steve King. American Action Network, the social welfare nonprofit led by former GOP Sen. Norm Coleman of Minnesota, also contributed $100,000 to the group sometime between July 2012 and June 2013, according to its annual tax return. And a group called Missouri Farmers Care \u2014 which says its mission is to "solicit contributions to support education and advocacy for Missouri agriculture" \u2014 also donated $35,000 Protect the Harvest in 2012. Documents list Dale Ludwig, the longtime executive director of the Missouri Soybean Association, as the treasurer of Missouri Farmers Care and as a director of Protect the Harvest. Jackie Klippenstein, Brian\'s wife and a lobbyist for the Dairy Farmers of America, is also listed as one of the 30 members of Missouri Farmers Care. Protect the Harvest\u2019s super PAC arm will be required to disclose its funders to the FEC. While Brian Klippenstein has financially supported Republicans such as 2012 presidential nominee Mitt Romney and House Speaker John Boehner in the past, he has not made any contributions to Iowa politicians this election cycle, according to a Center for Public Integrity review of FEC records. Nor has Lucas. Last year, Roth, the attorney, contributed $1,000 to businessman Mark Jacobs, who is seeking to become the Republican Party\u2019s nominee for U.S. Senate this year. Polls show Jacobs trailing state Sen. Joni Ernst ahead of the GOP\'s June 3 primary. Additionally, Protect the Harvest itself has endorsed a Missouri ballot measure, backed by the Missouri Farm Bureau, which would amend the state\u2019s constitution to guarantee that \u201cthe right of Missouri citizens to engage in agricultural production and ranching practices shall not be infringed.\u201d Protect the Harvest backed a similar \u2014 and successful \u2014 ballot measure in North Dakota in 2012. Critics argue \u201cright to farm\u201d laws, which have been supported by the board of the conservative-leaning American Legislative Exchange Council, could impede attempts to regulate genetically modified crops and may benefit large, agricultural corporations, not family farmers. "If right to farm would pass," said Maxwell, of the Humane Society, "it will allow foreign corporations and big agriculture corporations to do whatever they want in Missouri\'s countryside."',
  'title': u"'Radical animal rights movement' gets new foe",
  'url': u'http://www.publicintegrity.org/2014/05/29/14846/radical-animal-rights-movement-gets-new-foe'},
 {'article_html': u'<p>Ready for Hillary is now primed to pump Democratic congressional candidates full of cash.</p>\n\n<p>The pro-Clinton super PAC <a href="http://ow.ly/i/5IrYQ/original">today filed paperwork</a> to convert itself into a <a href="http://www.politico.com/news/stories/0112/71763.html">hybrid PAC</a>. This relatively new type of political committee may raise unlimited amounts of money to advocate for and against candidates \u2014 and at the same time collect limited amounts of cash to give directly to candidates.</p>\n\n<p>In doing so, the organization aims to put renewed punch into its <a href="http://thehill.com/blogs/ballot-box/house-races/319419-ready-for-hillary-prepares-to-aid-clintons-down-ballot-allies">promise</a> to <a href="http://www.thedailybeast.com/articles/2014/03/26/ready-for-hillary-super-pac-throws-in-for-2014-midterms.html">this year</a> support Clinton\'s allies during this year\'s midterm elections.</p>\n\n<p>"Ready for Hillary and our more than two million supporters are not only excited about encouraging Hillary to run in 2016, but also excited to be working to elect Democrats in 2014," spokesman Seth Bringman said in an email to the <a href="http://www.publicintegrity.org">Center for Public Integrity</a>. "This is another tool that we now have available to us to help in that effort."</p>\n\n<p>How many candidates does Ready for Hillary plan to contribute to during the midterms \u2014 and which ones?</p>\n\n<p>That\'s still unclear.</p>\n\n<p>Said Bringman: "So far the only decision that has been made is the decision to create the option" to make direct donations to candidates.</p>\n\n<p>Ready for Hillary\'s shift in operating status comes as Democrats are struggling this year to retain their slim majority in the U.S. Senate. Democrats\' hopes of retaking a majority in the U.S. House, meanwhile, are rapidly disappearing.</p>\n\n<p>Ready for Hillary <a href="https://www.publicintegrity.org/2013/01/28/12082/pro-hillary-clinton-super-pac-created">formed</a> in early 2013 with the goal of laying the groundwork for a 2016 presidential run by Clinton, who has not announced her future political intentions. Nevertheless, a <a href="http://www.politico.com/story/2014/05/tim-kaine-hillary-clinton-2016-106300.html">number</a> of <a href="http://www.politico.com/story/2013/06/hillary-clinton-2016-claire-mccaskill-92959.html">high-profile politicos</a> have <a href="http://abcnews.go.com/blogs/politics/2014/05/rahm-emanuel-endorses-hillary-clinton-for-2016/">already endorsed</a> a second Clinton White House bid.</p>\n\n<p>The committee hasn\'t acted like many big-dollar super PACs, eschewing massive television and radio advertising blitzes in favor of grassroots organizing, direct mail and online messaging, among other efforts.</p>\n\n<p>It\'s also set a voluntary donation cap of $25,000, even though super PACs and hybrid PACs may accept any size donation to use toward independently boosting or slamming political candidates.</p>\n\n<p>Ready for Hillary reported more than $857,000 in available cash through March 31, according to its <a href="http://docquery.fec.gov/cgi-bin/dcdev/forms/C00540997/920138/">most recent financial filing</a> with the Federal Election Commission. It <a href="http://docquery.fec.gov/cgi-bin/dcdev/forms/C00540997/920138/">spent</a> nearly $1.6 million during the first three months of the year, with direct mail, travel, printing, consulting fees and staff salaries among its biggest <a href="http://docquery.fec.gov/cgi-bin/dcdev/forms/C00540997/920138/sb/ALL">expenses</a>.</p>\n\n<p>Since its formation, it\'s raised more than $5.7 million \u2014 ranking it among the most financially successful super PACs this election cycle.</p>\n\n<p>As a hybrid PAC, Ready for Hillary will maintain a separate fund from which it may make direct contributions to candidates. For such donations, it must adhere to federal law that <a href="http://www.fec.gov/ans/answers_general.shtml#How_much_can_I_contribute">allows</a> traditional political action committees and hybrid PACs to give federal-level candidates $5,000 per election.</p>\n<p>&nbsp;</p>\n\n<p>&nbsp;</p>\n<img height="1" src="http://feeds.feedburner.com/~r/publici_rss/~4/_ub290iWDkw" width="1" />',
  'article_imgs': ['http://feeds.feedburner.com/~r/publici_rss/~4/_ub290iWDkw'],
  'article_links': ['http://thehill.com/blogs/ballot-box/house-races/319419-ready-for-hillary-prepares-to-aid-clintons-down-ballot-allies',
   'http://www.fec.gov/ans/answers_general.shtml',
   'http://docquery.fec.gov/cgi-bin/dcdev/forms/C00540997/920138/sb/ALL',
   'http://www.politico.com/story/2014/05/tim-kaine-hillary-clinton-2016-106300.html',
   'https://www.publicintegrity.org/2013/01/28/12082/pro-hillary-clinton-super-pac-created',
   'http://ow.ly/i/5IrYQ/original',
   'http://www.publicintegrity.org',
   'http://www.politico.com/news/stories/0112/71763.html',
   'http://docquery.fec.gov/cgi-bin/dcdev/forms/C00540997/920138',
   'http://www.politico.com/story/2013/06/hillary-clinton-2016-claire-mccaskill-92959.html',
   'http://www.thedailybeast.com/articles/2014/03/26/ready-for-hillary-super-pac-throws-in-for-2014-midterms.html',
   'http://abcnews.go.com/blogs/politics/2014/05/rahm-emanuel-endorses-hillary-clinton-for-2016'],
  'authors': [u'Dave Levinthal'],
  'datetime': datetime.datetime(2014, 5, 28, 20, 30, 35, tzinfo=pytz.utc),
  'img_urls': [],
  'tags': [u'Politics', u'Primary Source'],
  'text': u'Ready for Hillary is now primed to pump Democratic congressional candidates full of cash. The pro-Clinton super PAC today filed paperwork to convert itself into a hybrid PAC. This relatively new type of political committee may raise unlimited amounts of money to advocate for and against candidates \u2014 and at the same time collect limited amounts of cash to give directly to candidates. In doing so, the organization aims to put renewed punch into its promise to this year support Clinton\'s allies during this year\'s midterm elections. "Ready for Hillary and our more than two million supporters are not only excited about encouraging Hillary to run in 2016, but also excited to be working to elect Democrats in 2014," spokesman Seth Bringman said in an email to the Center for Public Integrity. "This is another tool that we now have available to us to help in that effort." How many candidates does Ready for Hillary plan to contribute to during the midterms \u2014 and which ones? That\'s still unclear. Said Bringman: "So far the only decision that has been made is the decision to create the option" to make direct donations to candidates. Ready for Hillary\'s shift in operating status comes as Democrats are struggling this year to retain their slim majority in the U.S. Senate. Democrats\' hopes of retaking a majority in the U.S. House, meanwhile, are rapidly disappearing. Ready for Hillary formed in early 2013 with the goal of laying the groundwork for a 2016 presidential run by Clinton, who has not announced her future political intentions. Nevertheless, a number of high-profile politicos have already endorsed a second Clinton White House bid. The committee hasn\'t acted like many big-dollar super PACs, eschewing massive television and radio advertising blitzes in favor of grassroots organizing, direct mail and online messaging, among other efforts. It\'s also set a voluntary donation cap of $25,000, even though super PACs and hybrid PACs may accept any size donation to use toward independently boosting or slamming political candidates. Ready for Hillary reported more than $857,000 in available cash through March 31, according to its most recent financial filing with the Federal Election Commission. It spent nearly $1.6 million during the first three months of the year, with direct mail, travel, printing, consulting fees and staff salaries among its biggest expenses. Since its formation, it\'s raised more than $5.7 million \u2014 ranking it among the most financially successful super PACs this election cycle. As a hybrid PAC, Ready for Hillary will maintain a separate fund from which it may make direct contributions to candidates. For such donations, it must adhere to federal law that allows traditional political action committees and hybrid PACs to give federal-level candidates $5,000 per election.',
  'title': u'Ready for Hillary no longer just a super PAC',
  'url': u'http://www.publicintegrity.org/2014/05/28/14838/ready-hillary-no-longer-just-super-pac'}]