from lxml import etree
from StringIO import StringIO

parse = lambda xml: etree.parse(StringIO(xml))

info = parse('''<?xml version="1.0"?>
<info>
<entry
kind="dir"
path="."
revision="18799">
<url>svn+ssh://dev/vol2/svn/monkey/trunk</url>
<repository>
<root>svn+ssh://dev/vol2/svn</root>
<uuid>d3f15640-29ef-0310-be8a-e17a052a3da3</uuid>
</repository>
<wc-info>
<schedule>normal</schedule>
</wc-info>
<commit
revision="18732">
<author>dbravender</author>
<date>2007-08-01T20:46:18.133879Z</date>
</commit>
</entry>
</info>''')

info_merged_forward = parse('''<?xml version="1.0"?>
<info>
<entry
kind="dir"
path="."
revision="18799">
<url>svn+ssh://dev/vol2/svn/monkey/branches/jquery.2</url>
<repository>
<root>svn+ssh://dev/vol2/svn</root>
<uuid>d3f15640-29ef-0310-be8a-e17a052a3da3</uuid>
</repository>
<wc-info>
<schedule>normal</schedule>
</wc-info>
<commit
revision="18732">
<author>dbravender</author>
<date>2007-08-01T20:46:18.133879Z</date>
</commit>
</entry>
</info>''')

log = parse('''<?xml version="1.0"?>
<log>
<logentry
   revision="18497">
<author>dbravender</author>
<date>2007-07-25T15:59:48.783051Z</date>
<msg>some comment on page load</msg>
</logentry>
<logentry
   revision="18496">
<author>dbravender</author>
<date>2007-07-25T15:55:15.863284Z</date>
<msg>creating a branch for adding jquery or replacing mochikit with jquery</msg>
</logentry>
</log>''')

status_changes = parse('''<?xml version="1.0"?>
<status>
<target
   path=".">
<entry
   path="shellLocal.sh">
<wc-status
   props="none"
   item="modified"
   revision="18579">
<commit
   revision="18403">
<author>cmcavoy</author>
<date>2007-07-20T20:23:58.307906Z</date>
</commit>
</wc-status>
</entry>
</target>
</status>''')

status_clean = parse('''<?xml version="1.0"?>
<status>
<target
   path=".">
</target>
</status>''')

log_trunk_branch_parent = parse('''<?xml version="1.0"?>
<log>
<logentry
   revision="8">
<author>dbravender</author>
<date>2007-08-12T05:32:38.538458Z</date>
<paths>
<path
   action="A">/branches/brass_monkey/that_funky_monkey</path>
</paths>
<msg>insane
</msg>
</logentry>
<logentry
   revision="4">
<author>dbravender</author>
<date>2007-08-12T05:22:02.975050Z</date>
<paths>
<path
   copyfrom-path="/autoleads/trunk"
   copyfrom-rev="3"
   action="A">/branches/brass_monkey</path>
</paths>
<msg>awesome
</msg>
</logentry>
</log>''')

log_non_trunk_branch_parent = parse('''<?xml version="1.0"?>
<log>
<logentry
   revision="8">
<author>dbravender</author>
<date>2007-08-12T05:32:38.538458Z</date>
<paths>
<path
   action="A">/branches/brass_monkey/that_funky_monkey</path>
</paths>
<msg>insane
</msg>
</logentry>
<logentry
   revision="4">
<author>dbravender</author>
<date>2007-08-12T05:22:02.975050Z</date>
<paths>
<path
   copyfrom-path="/autoleads/branches/some_other_branch"
   copyfrom-rev="3"
   action="A">/branches/brass_monkey</path>
</paths>
<msg>awesome
</msg>
</logentry>
</log>''')

ls_before_changes = parse('''<?xml version="1.0"?>
<lists>
<list
   path="https://bravender.us/svn/public/sv/trunk">
<entry
   kind="file">
<name>fixtures.py</name>
<size>2969</size>
<commit
   revision="2">
<author>dbravender</author>
<date>2007-08-12T22:24:49.248816Z</date>
</commit>
</entry>
<entry
   kind="file">
<name>sv</name>
<size>10</size>
<commit
   revision="2">
<author>dbravender</author>
<date>2007-08-12T22:24:49.248816Z</date>
</commit>
</entry>
<entry
   kind="file">
<name>sv.py</name>
<size>10134</size>
<commit
   revision="2">
<author>dbravender</author>
<date>2007-08-12T22:24:49.248816Z</date>
</commit>
</entry>
<entry
   kind="file">
<name>test_sv.py</name>
<size>4533</size>
<commit
   revision="2">
<author>dbravender</author>
<date>2007-08-12T22:24:49.248816Z</date>
</commit>
</entry>
</list>
</lists>''')

ls_after_changes = parse('''<?xml version="1.0"?>
<lists>
<list
   path=".">
<entry
   kind="file">
<name>added_file</name>
<size>38</size>
<commit
   revision="7">
<author>dbravender</author>
<date>2007-08-12T22:56:50.430839Z</date>
</commit>
</entry>
<entry
   kind="file">
<name>fixtures.py</name>
<size>2969</size>
<commit
   revision="2">
<author>dbravender</author>
<date>2007-08-12T22:24:49.248816Z</date>
</commit>
</entry>
<entry
   kind="file">
<name>sv</name>
<size>10</size>
<commit
   revision="2">
<author>dbravender</author>
<date>2007-08-12T22:24:49.248816Z</date>
</commit>
</entry>
<entry
   kind="file">
<name>sv.py</name>
<size>10246</size>
<commit
   revision="4">
<author>dbravender</author>
<date>2007-08-12T22:37:34.237015Z</date>
</commit>
</entry>
<entry
   kind="file">
<name>test_sv.py</name>
<size>4533</size>
<commit
   revision="2">
<author>dbravender</author>
<date>2007-08-12T22:24:49.248816Z</date>
</commit>
</entry>
</list>
</lists>''')
