# -*- coding: utf-8 -*-
"""
App default settings
"""
from django.conf import settings
from django.utils.translation import ugettext_lazy as _

# Add custom cache keys to delete with the command option ``django-admin documents --clearcache``
DOCUMENTS_CACHE_KEYS_TO_CLEAN = getattr(settings, 'DOCUMENTS_CACHE_KEYS_TO_CLEAN', [])

# Forbidden words for slug values in documents
DOCUMENTS_PAGE_RESERVED_SLUGS = getattr(settings, 'DOCUMENTS_PAGE_MENU', ('board','add','preview','documents-help','inserts'))

# Default template to generate tree menu
DOCUMENTS_PAGE_TREEMENU = getattr(settings, 'DOCUMENTS_PAGE_TREEMENU', "sveedocuments/page_treemenu.html")
# Default template to generate flat menu
DOCUMENTS_PAGE_FLATMENU = getattr(settings, 'DOCUMENTS_PAGE_FLATMENU', "sveedocuments/page_flatmenu.html")

# Available templates for Pages
DOCUMENTS_PAGE_TEMPLATES = {
    'elastic': ('sveedocuments/page_details/elastic.html', _('Elastic with an unique column')),
    'elastic_with_columns': ('sveedocuments/page_details/elastic_with_columns.html', _('Elastic with two columns')),
    'fixed_absolute': ('sveedocuments/page_details/fixed_absolute.html', _('Absolute fixed with an unique column')),
    'fixed_absolute_with_columns': ('sveedocuments/page_details/fixed_absolute_with_columns.html', _('Absolute fixed with two columns')),
    'fixed_relative': ('sveedocuments/page_details/fixed_relative.html', _('Relative fixed an unique column')),
    'fixed_relative_with_columns': ('sveedocuments/page_details/fixed_relative_with_columns.html', _('Relative fixed with two columns')),
}
DOCUMENTS_PAGE_TEMPLATES.update(getattr(settings, 'DOCUMENTS_PAGE_TEMPLATES', {}))

# Active a silent reporter to avoid warnings about missing page on role ``:page:xxx``
# If ``True`` the role will be transformed to link despite the page does not exist, 
# if ``False`` the warning will be inserted in the render
DOCUMENTS_PARSER_WIKIROLE_SILENT_WARNING = getattr(settings, 'DOCUMENTS_PARSER_WIKIROLE_SILENT_WARNING', False)

# Get the first part of the local setting, required for the docutils parser that don't 
# support the pattern ``xx_XX``.
DOCUMENTS_PARSER_LANGUAGE_CODE = getattr(settings, 'LANGUAGE_CODE', "en").split('_')[0]

# Disable unsafe ReSTructured directives, enable them at your own risk
DOCUMENTS_PARSER_ENABLE_FILE_INSERTION = getattr(settings, 'DOCUMENTS_PARSER_ENABLE_FILE_INSERTION', False)
DOCUMENTS_PARSER_ENABLE_RAW_INSERTION = getattr(settings, 'DOCUMENTS_PARSER_ENABLE_RAW_INSERTION', False)

# Available parser settings
# These are options only for docutils parser, see 
# http://docutils.sourceforge.net/docs/user/config.html (The used writer is 
# ``html4css1``)
DOCUMENTS_PARSER_FILTER_SETTINGS = {
    'default':{
        'initial_header_level': 3,
        'file_insertion_enabled': DOCUMENTS_PARSER_ENABLE_FILE_INSERTION,
        'raw_enabled': DOCUMENTS_PARSER_ENABLE_RAW_INSERTION,
        'language_code': DOCUMENTS_PARSER_LANGUAGE_CODE,
        'footnote_references': 'superscript',
        'doctitle_xform': False,
    },
    'short':{
        'initial_header_level': 3,
        'file_insertion_enabled': DOCUMENTS_PARSER_ENABLE_FILE_INSERTION,
        'raw_enabled': DOCUMENTS_PARSER_ENABLE_RAW_INSERTION,
        'language_code': DOCUMENTS_PARSER_LANGUAGE_CODE,
        'footnote_references': 'superscript',
        'doctitle_xform': False,
    },
}
DOCUMENTS_PARSER_FILTER_SETTINGS.update(getattr(settings, 'DOCUMENTS_PARSER_FILTER_SETTINGS', {}))

# CSS class prefix for generated Pygments elements
PYGMENTS_CONTAINER_CLASSPREFIX = getattr(settings, 'PYGMENTS_CONTAINER_CLASSPREFIX', "pygments")
# Enable use of inline CSS styles in HTML generated by Pygments, this will fill your HTML 
# with a lot a styles. Disabled by default
PYGMENTS_INLINESTYLES = getattr(settings, 'PYGMENTS_INLINESTYLES', False)

# Cache keys for document elements
PAGE_RENDER_CACHE_KEY_NAME = 'documents-render-page_{id}-setting_{setting}'
INSERT_RENDER_CACHE_KEY_NAME = 'documents-render-insert_{id}-setting_{setting}-hlv_{header_level}'
PAGE_TOC_CACHE_KEY_NAME = 'documents-toc-page_{id}-setting_{setting}'
INSERT_TOC_CACHE_KEY_NAME = 'documents-toc-insert_{id}-setting_{setting}-hlv_{header_level}'
PAGE_SLUGS_CACHE_KEY_NAME = 'documents-page_slugs'
