# Copyright 2008 German Aerospace Center (DLR)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

""" 
This check tests if a file with the same filename (ignoring the case) already exists in the repository.
"""

def run(transaction, config):

    check = config.getArray("CaseInsensitiveFilenameClash.CheckFiles", [".*"])
    ignore = config.getArray("CaseInsensitiveFilenameClash.IgnoreFiles", [])
    files = transaction.getFiles(check, ignore)

    msg = ""
    for filename, attribute in files.iteritems():
        if attribute in ["A"] :
            if transaction.fileExists(filename, ignoreCase=True):
                msg += "A file with the same name already exists: %r\n" % filename

    if msg:
        return (msg, 1)
    else:
        return ("", 0)
