# -*- coding: UTF-8 -*-
#
# sy85/data/voice.py
#

from patches import *

VOICE_SYSEX_FORMAT = [
    # (offset, length, param no, param name, converter func, args...)
    (0, 1, None, 'reserved', None),
    (1, 1, 1, 'Effect mode', 'b_lookup', 'off', 'serial', 'parallel'),
    (2, 1, 2, 'Effect1 type', 'b_range', 0, 90),
    (3, 1, 3, 'Effect2 type', 'b_range',  0, 90),
    (4, 1, 4, 'Effect control1 parameter', 'b_range', 0, 31),
    (5, 1, 5, 'Effect control1 add controller', 'b_range', 0, 124),
    (6, 1, 6, 'Effect control2 parameter', 'b_range', 0, 31),
    (7, 1, 7, 'Effect control2 add controller', 'b_range', 0, 124),
    (8, 1, 8, 'Effect control2 min limit', 'b_range', 0, 124),
    (9, 1, 9, 'Effect control2 max limit', 'b_range', 0, 124),
    (10, 4, 10, 'Effect1 parameter1', 'l_range'),
    (14, 4, 11, 'Effect1 parameter5', 'l_range'),
    (18, 4, 12, 'Effect1 parameter3', 'l_range'),
    (22, 4, 13, 'Effect1 parameter7', 'l_range'),
    (26, 2, 14, 'Effect1 parameter2', 's_range'),
    (28, 2, 15, 'Effect1 parameter4', 's_range'),
    (30, 2, 16, 'Effect1 parameter6', 's_range'),
    (32, 2, 17, 'Effect1 parameter8', 's_range'),
    (34, 1, 18, 'Effect1 level-a', 'b_range', 0, 100),
    (35, 1, 19, 'Effect1 level-b', 'b_range', 0, 100),
    (36, 4, 20, 'Effect2 parameter1', 'l_range'),
    (40, 4, 21, 'Effect2 parameter2', 'l_range'),
    (44, 4, 22, 'Effect2 parameter3', 'l_range'),
    (48, 4, 23, 'Effect2 parameter4', 'l_range'),
    (52, 2, 24, 'Effect2 parameter5', 's_range'),
    (54, 2, 25, 'Effect2 parameter6', 's_range'),
    (56, 2, 26, 'Effect2 parameter7', 's_range'),
    (58, 2, 27, 'Effect2 parameter8', 's_range'),
    (60, 1, 28, 'Effect2 level-a', 'b_range', 0, 100),
    (61, 1, 29, 'Effect2 level-b', 'b_range', 0, 100),
    (62, 1, 30, 'Effect mix level', 'b_range', 0, 100),
    (63, 1, 31, 'Effect balance out1', 'b_range', 0, 100),
    (64, 1, None, 'reserved', None),
    (65, 1, 33, 'Effect control1 min limit ', 'b_range', 0, 100),
    (66, 1, 34, 'Effect control1 max limit', 'b_range', 0, 100),
    (67, 1, 35, 'Effect LFO wave', 'b_lookup', 'tri', 'dwn', 'up', 'squ', 'sin', 'S/H', '1tm'),
    (68, 1, 36, 'Effect1 LFO speed', 'b_range', 0, 99),
    (69, 1, 37, 'Effect1 LFO delay time', 'b_range', 0, 99),
    (70, 3, None, 'reserved', None),
    (73, 8, 49, 'Voice name', 'read_string'),
    (81, 1, None, 'reserved', None),
    (82, 2, 58, 'AWM CARD ID#', 's_range', 0, 16383),
    (84, 1, 60, 'MW Pitch modulation depth', 'b_range'),
    (85, 1, 61, 'MW Amplitude modulation depth', 'b_range'),
    (86, 1, 62, 'MW Frequency modulation depth', 'b_range'),
    (87, 2, 63, 'MW Cutoff frequency depth', 's_range', -127, 127),
    (89, 2, 64, 'MW EG bias depth', 's_range', -127, 127),
    (91, 1, 65, 'FC Pitch modulation depth', 'b_range'),
    (92, 1, 66, 'FC Amplitude modulation depth', 'b_range'),
    (93, 1, 67, 'FC Frequency modulation depth', 'b_range'),
    (94, 2, 68, 'FC Cutoff frequency depth', 's_range', -127, 127),
    (96, 2, 69, 'FC EG bias depth', 's_range', -127, 127),
    (98, 1, 70, 'AT Pitch modulation depth', 'b_range'),
    (99, 1, 71, 'AT Amplitude modulation depth', 'b_range'),
    (100, 1, 72, 'AT Frequency modulation depth', 'b_range'),
    (101, 2, 73, 'AT Cutoff frequency depth', 's_range', -127, 127),
    (103, 2, 74, 'AT EG bias depth', 's_range', -127, 127),
    # signed byte, only value bits 0-4 used
    (105, 2, 75, 'AT Pitch bias depth', 's_signed', -12, 12),
    # supported by TG500 only
    (107, 2, 76, 'Poly after touch switch', 's_lookup', 'channel', 'key'),
    (109, 1, 77, 'Pitch bend range', 'subbyte_range', 7, 0, 12),
    (109, 1, 77, 'Sustain enable', 'bitflag', 6),
    (110, 1, 78, 'FC Volume low limit', 'b_range'),
    (111, 1, 79, 'CS parameter1', 'b_lookup', CS_PARAMETERS),
    (112, 1, 80, 'CS parameter1 min limit', 'b_range', 0, 100),
    (113, 1, 81, 'CS parameter1 max limit', 'b_range', 0, 100),
    (114, 1, 82, 'CS parameter2', 'b_lookup', CS_PARAMETERS),
    (115, 1, 83, 'CS parameter1 min limit', 'b_range', 0, 100),
    (116, 1, 84, 'CS parameter1 max limit', 'b_range', 0, 100),
    (117, 1, 85, 'Voice total level', 'b_range'),
    (118, 1, 86, 'Effect send level', 'b_range'),
    (119, 1, 87, 'Wave data bank', 'subbyte_lookup', 3,
      [x[1] for x in WAVEFORM_BANKS]),
    (119, 1, 87, 'Reverse switch', 'bitflag', 2),
    (120, 2, 88, 'Wave number', 's_range', 0, 244),
]
