# NANO106 - Crystallography of Materials

Welcome to the repo for NANO106.

NANO106 is UCSD's course on Crystallography of Materials taught by Prof Shyue
Ping Ong. The purpose of this repo is to serve as a persistent and evolving
collection of supplementary course materials that illustrate various symmetry
and crystallography concepts and computations. Most of the code are written in
python and presented in ipython notebooks. Some static material may be created
in LaTeX.

While this repo is completely open and anyone is welcome to use the materials
contain therein, I would ask that you acknowledge any usage.

## Usage

To fully make use of this repo, it is recommended that you clone and install
the symmetry package included, as well as ipython, numpy, sympy,
and for some more specific materials analysis, [pymatgen](http://www.pymatgen.org).

However, you can explore a lot of the materials without any installation.

### Viewing the Notebooks

You can explore the notebooks using the excellent online ipython notebook viewer. 
To begin, go to this [link](http://nbviewer.ipython.org/github/materialsvirtuallab/nano106/tree/master/lectures/)
which points to the root lectures directory and this
[link](http://nbviewer.ipython.org/github/materialsvirtuallab/nano106/tree/master/problem_sets/)
which points to the problem sets directory.

## Acknowledgements

NANO106 uses the following textbooks and much of the code and material
contained therein is based on concepts in these books. They are highly
recommended for students of crystallography, symmetry and its implications
for material properties.

1. Structure of Materials: An Introduction to Crystallography, Diffraction and
   Symmetry by Marc De Graef and Michael E. McHenry
2. Properties of Materials: Anisotropy, Symmetry, Structure by Robert E.
   Newnham

--
Shyue Ping Ong
