from hashlib import md5
import math

from syncano.client import SyncanoApi
from syncano.callbacks import ObjectCallback
from syncano.exceptions import ConnectionLost


def retry(obj, fun, *args, **kwargs):
    try:
        return fun(*args, **kwargs)
    except ConnectionLost:
        obj.syncano = SyncanoApi(obj.instance, obj.apikey, callback_handler=ObjectCallback)
        return fun(*args, **kwargs)

class Forum(object):
    
    def __init__(self, instance, apikey, project_id):
        self.instance = instance
        self.apikey = apikey
        self.project_id = project_id
        self.syncano = SyncanoApi(instance, apikey, callback_handler=ObjectCallback)
        
    def add_category(self, name):
        return retry(self, self._add_category, name)
        
    def _add_category(self, name):
        collection = self.syncano.collection.new(self.project_id, name, md5(name).hexdigest())
        collection.activate()
        return collection
    
    def _add_topic(self, collection_id, name):
        folder = self.syncano.folder.new(self.project_id, name, collection_id)
        return folder
        
    def add_topic(self, collection_id, name):
        return retry(self, self._add_topic, collection_id, name)
    
    def _add_post(self, collection_id, folder, message, username):
        data = self.syncano.data.new(self.project_id, collection_id, folder=folder, text=message,
                                     user_name=username, title=username)
        return data
    
    def add_post(self, collection_id, folder, message, username):
        return retry(self, self._add_post, collection_id, folder, message, username)
    
    def _categories(self):
        projects = self.syncano.collection_get(self.project_id)
        return projects
    
    def categories(self):
        return retry(self, self._categories)
    
    def _topics(self, collection_id):
        topics = self.syncano.folder_get(self.project_id, collection_id=collection_id)
        return topics
    
    def topics(self, collection_id):
        return retry(self, self._topics, collection_id)
    
    def _posts(self, collection_id, folder, since_id, max_id, order, limit):
        posts = self.syncano.data.get(self.project_id, collection_id, folders=[folder],
                                      since_id=since_id, max_id=max_id, order=order, limit=limit)
        return posts
    def posts(self, collection_id, folder, since_id, max_id, order, limit=20):
        return list(retry(self, self._posts, collection_id, folder, since_id, max_id, order, limit))
    
    
    def get_pages(self, collection_id, folder, since_id, page):
        first_page = self.posts(collection_id, folder, None, None, 'ASC')
        last_page = self.posts(collection_id, folder, None, None, 'DESC')
        count = self.syncano.data_count(self.project_id, collection_id, folders=folder).count
        last_page = last_page[:count % 20 or 20]
        result = dict(first=[1, None],
                      current=[],
                      last=None)
        if count <= 20:
            result['posts'] = first_page
        else:
            posts_before = self.posts(collection_id, folder, None, since_id-1 if since_id else None, 'DESC', 40)[::-1]
            posts_next = self.posts(collection_id, folder, since_id-1 if since_id else None, None, 'ASC', 60)
            result['last'] = [math.ceil(float(count)/20), last_page[-1].id]
            result['posts'] = posts_next[:20]
            tpage = page - 1
            t_off=20
            while tpage > 1 and tpage != 1:
                result['current'].append((tpage, posts_before[1-t_off].id))
                t_off += 20
                tpage -= 1
            tpage = page
            max_page = tpage + 2
            t_off = 0
            while tpage <= max_page and result['last'][0] != tpage:
                result['current'].append((tpage, posts_next[t_off].id))
                t_off +=20
                tpage +=1
        result['current'].sort(key=lambda x: x[0])
        return result    
            
            
        
        