import sys
import convertible
import inspect
import traceback
import logging
import httplib

def call(func, kwargs):
    argspec = inspect.getargspec(func)
    params = kwargs
    if not argspec.keywords:
        params = dict()
        for key in kwargs.keys():
            if key in argspec.args:
                params[key] = kwargs.get(key)
    return func(**params)


def respond(result, message=None, success=True):
    response = dict(success=success, message=message, data=result)
    response_json = convertible.to_json(response)
    print(response_json)


def run(runner, debug=False):
    if debug:
        logging.basicConfig(level=logging.DEBUG)
        httplib.HTTPConnection.debuglevel = 1
    try:
        data = runner()
        respond(data)
    except Exception, e:
        if debug:
            print '-'*60
            traceback.print_exc(file=sys.stdout)
            print '-'*60

        respond(e, e.message, success=False)
        exit(1)
