import logging
import logging.handlers

formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
fileHandler = None
level = logging.INFO

console = False
consoleHandler = logging.StreamHandler()
consoleHandler.setFormatter(formatter)


def init(filename):
    global fileHandler
    fileHandler = logging.handlers.RotatingFileHandler(filename, maxBytes=1000000, backupCount=5)
    fileHandler.setFormatter(formatter)


def get_logger(name):
    logger = logging.getLogger(name)
    logger.setLevel(level)
    logger.addHandler(fileHandler)
    if console:
        logger.addHandler(consoleHandler)
    return logger

init('/tmp/unset.log')
